/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file NetcdfInterpretor.h
    \brief Definition of the Template class NetcdfInterpretor.
    
    Magics Team - ECMWF 2004
    
    Started: Tue 17-Feb-2004
    
    Changes:
    
*/

#ifndef NetcdfInterpretor_H
#define NetcdfInterpretor_H

#include "magics.h"
#include "Translator.h"
#include "Factory.h"
#include "GeoPoint.h"
#include "UserPoint.h"
#include "MatrixHandler.h"
#include "NetcdfInterpretorAttributes.h"
#include "CustomisedPoint.h"

namespace magics {

template <class P> class RasterData;

class NetcdfInterpretor: public NetcdfInterpretorAttributes {

public:
	NetcdfInterpretor();
	virtual ~NetcdfInterpretor();
    virtual void interpretAsMatrix(Matrix&)
    	{ Log::dev() << "Method  NetcdfInterpretor::interpretAsMatrix() --> Not yet implemented.\n"; }
    virtual void interpretAsVectors(Matrix&, Matrix&) 
    	{ Log::dev() << "Method  NetcdfInterpretor::interpretAsVectors() --> Not yet implemented.\n"; }
    virtual void interpretAsRaster(RasterData<GeoPoint>&) 
    	{ Log::dev() << "Method  NetcdfInterpretor::interpretAsRaster() --> Not yet implemented.\n"; }
    virtual void interpretAsPoints(PointsList<GeoPoint>&)  
    	{ Log::dev() << "Method  NetcdfInterpretor::interpretAsPoints() --> Not yet implemented.\n"; }
    virtual void customisedPoints(const std::set<string>&, CustomisedPointsList&)  
        	{ Log::dev() << "Method  NetcdfInterpretor::customisedPoints() --> Not yet implemented.\n"; }
    virtual void interpretAsRaster(RasterData<UserPoint>&) 
    	{ Log::dev() << "Method  NetcdfInterpretor::interpretAsRaster() --> Not yet implemented.\n"; }
    virtual void interpretAsPoints(PointsList<UserPoint>&)  
    	{ Log::dev() << "Method  NetcdfInterpretor::interpretAsPoints() --> Not yet implemented.\n"; }
    virtual void set(const map<string, string>& params) { NetcdfInterpretorAttributes::set(params); }
    virtual void set(const XmlNode& node) { NetcdfInterpretorAttributes::set(node); }
     virtual bool accept(const string& node) { return NetcdfInterpretorAttributes::accept(node); }
    virtual NetcdfInterpretor* clone() const {
    	NetcdfInterpretor* object = new NetcdfInterpretor();
    	object->copy(*this);
    	return object;
    }


protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const; 
     void setDimensions(const stringarray&, map<string, string>& first, map<string, string>& last);

private:
    //! Copy constructor - No copy allowed
	NetcdfInterpretor(const NetcdfInterpretor&);
    //! Overloaded << operator to copy - No copy allowed
	NetcdfInterpretor& operator=(const NetcdfInterpretor&);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const NetcdfInterpretor& p)
		{ p.print(s); return s; }
};
template<>
class Translator<string, NetcdfInterpretor> { 
public:
	NetcdfInterpretor* operator()(const string& val ) {
		 return SimpleObjectMaker<NetcdfInterpretor>::create(val);
	}

	NetcdfInterpretor* magics(const string& param)
	{
		NetcdfInterpretor* object;
		ParameterManager::update(param, object);
		return object;
	}
};

} // namespace magics
#endif
