/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file GenericSQLDecoder.h
    \brief Implementation of the Template class GenericSQLDecoder.
    
    Magics Team - ECMWF 2004
    
    Started: Fri 16-Jan-2004
    
    Changes:
    
*/



#include "GenericSQLDecoder.h"




using namespace magics;

GenericSQLDecoder::GenericSQLDecoder() : sql_(0)
{
}


GenericSQLDecoder::~GenericSQLDecoder() 
{
    Log::dev() << "Disconnecting database...." << "\n";
   
}

/*!
 Class information are given to the output-stream.
*/		
void GenericSQLDecoder::print(ostream& out)  const
{
	out << "GenericSQLDecoder[";
    GenericSQLDecoderAttributes::print(out);
    out << "]";
}

void GenericSQLDecoder::prepare()
{       
	if (sql_) return;

	odb* o   = odb_connect("cato",8000);
//ST	odb_stm* s;
	int size = 0;
//ST	const double* v;
	int i;

	if(!o) throw GenericSQLException("No connection to the generic SQL database");

	string database = "set database '" + database_ + "';";
	odb_do(o, database.c_str());
	Log::dev() << "OdbDecoderOD::decode--->" << *this << "\n";
	sql_    = odb_prepare_statement(o, query_.c_str());
    
	if ( !sql_) throw GenericSQLException("Query failed");
    
	size = odb_no_columns(sql_);

	for(i = 0; i < size; i++)
	{
		columns_[odb_column_name(sql_,i)] = i;
	}
}
