/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file OutputHandler.cc
    \brief Implementation of the Template class OutputHandler.
    \author Graphics Section, ECMWF

    Started: Wed July 2006
*/

#include "OutputHandler.h"
#include "DriverManager.h"
#include "OutputFactory.h"
#include "XmlNode.h"

using namespace magics;

void OutputHandler::set(DriverManager& magics) 
{
	if ( formats_.empty() ) formats_.push_back(format_);

	for ( vector<string>::const_iterator format = formats_.begin(); format != formats_.end(); ++format)
	{
		OutputFactory* factory = Translator<string, OutputFactory>()(*format);
		XmlNode node;
		factory->set(magics, node); 
		factories_.push_back(factory);
	}
}

void OutputHandler::set(const XmlNode& node, DriverManager& magics) 
{
	try {
		OutputFactory* factory = Translator<string, OutputFactory>()(node.name());
	
		factory->set(magics, node); 
		factories_.push_back(factory);
	}
	catch (...)
	{
	}
}


OutputHandler::~OutputHandler()
{
	for ( vector<OutputFactory* >::const_iterator factory = factories_.begin(); factory != factories_.end(); ++factory)
		(*factory)->reset(); 
}


/*
 This code was copied from OutputFactory.cc to hear to work in 
 STATIC Magics++ libraries!
*/
static SimpleObjectMaker<PS_PsOutputFactory,   OutputFactory> ps("ps");
static SimpleObjectMaker<PS_EpsOutputFactory, OutputFactory> eps("eps");
static SimpleObjectMaker<PS_PdfOutputFactory,  OutputFactory> ps_pdf("ps_pdf");

#ifdef MAGICS_RASTER
static SimpleObjectMaker<GD_PngOutputFactory, OutputFactory> gdpng("gd_png");
static SimpleObjectMaker<GD_JpegOutputFactory, OutputFactory> jpeg("jpeg");
static SimpleObjectMaker<GD_GifOutputFactory, OutputFactory> gif("gif");
static SimpleObjectMaker<GD_GifAnimOutputFactory, OutputFactory> gif_anim("gif_animation");
#endif

static SimpleObjectMaker<SVG_SvgOutputFactory, OutputFactory> svg("svg");

#ifdef MAGICS_CAIRO
static SimpleObjectMaker<CAIRO_PngOutputFactory,   OutputFactory> png("png");
static SimpleObjectMaker<CAIRO_PdfOutputFactory,    OutputFactory> pdf("pdf");
static SimpleObjectMaker<CAIRO_XOutputFactory,       OutputFactory> x("x");
static SimpleObjectMaker<CAIRO_CairoOutputFactory,  OutputFactory> cairo("cairo");
static SimpleObjectMaker<CAIRO_SvgOutputFactory,    OutputFactory> csvg("cairo_svg");
static SimpleObjectMaker<CAIRO_PsOutputFactory,      OutputFactory> cps("cairo_ps");
static SimpleObjectMaker<CAIRO_EpsOutputFactory,    OutputFactory> ceps("cairo_eps");
#endif

static SimpleObjectMaker<KML_KmlOutputFactory, OutputFactory> kml("kml");
