/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file Log.cc
    \brief Implementation of the Log class.
    \author Graphics Section, ECMWF

    Started: Jan 2004

    Changes:
*/

#include <Log.h>

using namespace magics;

Log  Log::log_;
bool Log::header_;

class LogObserver : public ostringstream
{
public:
	LogObserver() {}
	~LogObserver() {}
	LogObserver& flush ( )
	{  
		Log::dev()<< std::endl;
		Log::dev()<< "<-----------------------------------------LogObserver------------------------------------->" << std::endl;
		Log::dev()<< str(); 
		str("");
		
		Log::dev()<< "<-----------------------------------------LogObserver------------------------------------->" << std::endl;
		return *this;
	}
	friend LogObserver& endl(LogObserver& s)
			{ s.flush(); return s; }
	
};

static LogObserver MYLOG;


//extern string lowerCase(const string&);

inline bool setMsg(const string& name, bool def)
{
	string value = getEnvVariable(name);
	//value = lowerCase(value);
	if (value == "no" || value == "off" || value == "false") return false;
	if (value == "yes"|| value == "on"  || value == "true")  return true;

	return def;
}

/*!

 \todo Decide if Warnings are plotted when MAGPLUS_QUIET 
*/
Log::Log() :
    reporter_(0),
    devnull_("/dev/null"),
    debug_(true), 
    dev_(true),
    info_(true),
    userInfo_(true),
    warning_(true),
    error_(true),
    fatal_(true),
    profiling_(true)
{
    debug_ = setMsg("MAGPLUS_DEBUG", false);
    dev_ = setMsg("MAGPLUS_DEV", false);
    info_ = setMsg("MAGPLUS_INFO", false);
    profiling_ = setMsg("MAGPLUS_PROFILE", false);
    if(setMsg("MAGPLUS_QUIET",false) )
    {
       info_      = false;
       dev_       = false;
       profiling_ = false;
       debug_    = false;
       userInfo_ = false;
    }
    header_ = true;
}

Log::~Log() 
{
	//if ( reporter_ ) delete reporter_;
}

static void niceprint(int nb, const string& legend, const string& sep, ostream& out)
{
	if (!nb) return;
	string plurial = (nb > 1) ? "s" : "";
	out << sep << nb << legend << plurial; 
}
	
void ErrorReporter::report(ostream& out)  const
{
	if ( !warnings_ &&  !errors_) return;

	out << " - [ ";
	niceprint(warnings_, " warning", "", out);
	string sep = (warnings_) ? ", " : "";
	niceprint(errors_, " error", sep, out);
	out << " ]";
	warnings_ = 0;
	errors_   = 0;
}


void Log::print(ostream&)  const
{
}


ostream& Log::warning()
{
	if ( log_.reporter_ ) log_.reporter_->warning();
	if (log_.warning_)
	{
		cout << "Magics-warning:";
		return cout;
	}
	return log_.devnull_;
}

ostream& Log::debug()
{
	if (log_.debug_) {
		string text = ( header_ )  ? "Magics-debug:" : "";
		Log::dev()<< text;
	
		return cout;
	}
	return log_.devnull_;
}
ostream& Log::profile()
{
	if (log_.profiling_) {
		string text = ( header_ )  ? "Magics-profile:" : "";
		Log::dev()<< text;
	
		return cout;
	}
	return log_.devnull_;
}

ostream& Log::dev()
{
	if (log_.dev_) {
		string text = ( header_ )  ? "Magics-dev:" : "";
		cout << text;
		
		return cout;
	}
	return log_.devnull_;
}

ostream& Log::info()
{
	if (log_.info_)
	{
		cout << "Magics-info:";
		return cout;
	}
	return log_.devnull_;
}

ostream& Log::userInfo()
{
	if (log_.userInfo_)
	{
		cout << "Magics:";
		return cout;
	}
	return log_.devnull_;
}

ostream& Log::error()
{
	if ( log_.reporter_ ) log_.reporter_->error();
	if (log_.error_)
	{
		cerr << "Magics-ERROR:";
		return cerr;
	}
	return log_.devnull_;
}

ostream& Log::fatal()
{
	if (log_.fatal_)
	{
		cout << "Magics-fatal:";
		return cout;
	}
	return log_.devnull_;
}
