/*! \file FrameLoop.cc
    \brief Implementation of the Template class FrameLoop.
    
    Magics Team - ECMWF 2008
    
    Started: Fri 29-Aug-2008
    
    Changes:
    
*/


#include "AnimationRules.h"
#include "BaseDriver.h"
#include "Text.h"
#include "PaperPoint.h"

#include <limits>

using namespace magics;


AnimationStep::AnimationStep(AnimationRules& rules) : rules_(rules) , slide_(0), 
xResolution_(std::numeric_limits<double>::max()), yResolution_(std::numeric_limits<double>::max())
{
	
}


AnimationStep::~AnimationStep() 
{
}

/*!
 Class information are given to the output-stream.
*/		
void AnimationStep::print(ostream& out)  const
{
	out << "AnimationStep[" << size() << " entries";
	TagHandler::print(out); 
	out << "]";
}


void AnimationStep::execute(const BaseDriver& driver,  const Layout& visitor)
{
	Log::dev() << "AnimationStep::execute->[" <<  visitor<< "]" << endl;

	
		slide_ = rules_.execute(*this, visitor);
	
	if (slide_ )
		driver.redisplay(*slide_);
}

const vector<string>& AnimationStep::label() 
{
	if ( !label_.empty() ) 
		return label_;
	
	for (vector<BasicSceneObject*>::iterator object = this->begin(); object != this->end(); ++object) {
		reset();
		(*object)->visit(*this);
		
		label_.push_back("param: " + get("grib", "shortName") + " (" + get("grib", "lev") + ") at step:" +  get("grib", "stepRange"));	
		
	}	
	
	// Just for the test 
	for (vector<string>::iterator label = label_.begin(); label != label_.end(); ++label)
		Log::dev() << *label << endl;
	
	return label_;
	
}
void AnimationStep::rules(vector<string>& rules)
{ 
	rules_.rules(rules); 
}

AnimationRules::AnimationRules(BasicSceneObject& owner) : owner_(owner)
{
}

AnimationRules::~AnimationRules() 
{
}

/*!
 Class information are given to the output-stream.
*/		
void AnimationRules::print(ostream& out)  const
{
	out << endl;
	for (vector<AnimationStep*>::const_iterator step = this->begin(); step != this->end(); ++step)
		for (vector<string>::const_iterator label = (*step)->label().begin(); label != (*step)->label().end(); ++label)
				out << "\t" << *label << endl;
	out << endl;
}

void AnimationRules::rules(vector<string>& infos) const
{
}

void AsIsAnimationRules::rules(vector<string>& infos) const
{
	infos.push_back("<grib_info key='shortName'/>");
		infos.push_back("<grib_info key='stepRange'/>");
		infos.push_back("<grib_info key='lev'/>");
}


AsIsAnimationRules::AsIsAnimationRules(BasicSceneObject& owner) : AnimationRules(owner)
{
}

AsIsAnimationRules::~AsIsAnimationRules() 
{
}

void AsIsAnimationRules::add(vector<BasicSceneObject*>& objects )
{
	int i = 0;
	for (vector<BasicSceneObject*>::iterator object = objects.begin(); object != objects.end(); ++object) {
		int x = size() -1;
		if ( i > x )  
			this->push_back(new AnimationStep(*this));
		(*this)[i]->push_back(*object);		
		i++;
	}
}

/*!
 Class information are given to the output-stream.
*/		
void AsIsAnimationRules::print(ostream& out)  const
{
	out << "AsIsAnimationRules[" << this->size() << " steps";
	AnimationRules::print(out);
	out << "]";
}


DateAnimationRules::DateAnimationRules(BasicSceneObject& owner) : AnimationRules(owner)
{
}

DateAnimationRules::~DateAnimationRules() 
{
}

/*!
 Class information are given to the output-stream.
*/		
void DateAnimationRules::print(ostream& out)  const
{
	out << "DateAnimationRules[" << this->size() << " entries";
	out << "]";
}
