/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file GraphShade.cc
    \brief Implementation of the Template class GraphShade.
    
    Magics Team - ECMWF 2006
    
    Started: Thu 17-Aug-2006
    
    Changes:
    
*/


#include "GraphShade.h"
#include "PaperPoint.h"
#include "UserPoint.h"
#include "Polyline.h"

using namespace magics;

GraphShade::GraphShade() 
{
}


GraphShade::~GraphShade() 
{
}

/*!
 Class information are given to the output-stream.
*/		
void GraphShade::print(ostream& out)  const
{
	out << "GraphShade[";
	GraphShadeAttributes::print(out);
	out << "]";
}


void GraphShade::operator()(Polyline& box)
{
	// Make sure the polyline is closed! 
	box.push_back(box.front());

	(*style_)(box);
}

void GraphShade::legend(Polyline& box)
{
	
	if ( !box.empty() ) {
		// we make a box! 
		float height = 0.5;
		PaperPoint front = box.front();
		PaperPoint back = box.back();
		
		double xb = back.x();
		double yb = back.y();	
		double xf = front.x();
		double yf = front.y();
		
		box.push_back(PaperPoint(xb, yb+height));
		box.push_back(PaperPoint(xf, yf +height));
		box.push_back(front);
	}
	(*style_)(box);
}
void GraphShade::operator()(CustomisedPointsList& points, vector<UserPoint>& out)
{
	
	for (CustomisedPointsList::iterator point = points.begin(); point != points.end(); ++point)
		out.push_back(UserPoint((**point)["x"], (**point)["y"]));
	CustomisedPointsList::const_reverse_iterator rpoint = points.rbegin(); 
	CustomisedPointsList::const_reverse_iterator last = points.rend(); 

	while ( rpoint != last ) {
		out.push_back(UserPoint((**rpoint)["x2"], (**rpoint)["y2"]));
		rpoint++;
	}
}

void NoGraphShade::operator()(CustomisedPointsList& points, vector<UserPoint>& out)
{
	
	for (CustomisedPointsList::iterator point = points.begin(); point != points.end(); ++point) {
		CustomisedPoint::iterator x = (*point)->find("x");
		CustomisedPoint::iterator y = (*point)->find("y");
		if ( x != (*point)->end() && y != (*point)->end() ) {
			out.push_back(UserPoint(x->second, y->second));
			if ( (*point)->missing() )
				out.back().flagMissing();
		}

	}
		
	
}


void NoGraphShade::print(ostream& out)  const
{
	out << "NoGraphShade[";
	out << "]";
}

