/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file GribDecoderAttributes.h
    \brief Definition of GribDecoder Attributes class.
    \author Meteorological Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Wed Dec  5 12:07:14 2012
*/
   

#ifndef GribDecoderAttributes_H
#define GribDecoderAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "WindMode.h"
#include "GribAddressMode.h"

namespace magics {

class XmlNode;



class GribDecoderAttributes 
{
public:
//  --  constructor
    GribDecoderAttributes();
    
//  --  destructor
    virtual ~GribDecoderAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const GribDecoderAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

	

public:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream& out) const;
	//  --  members:
	string tag_;
	string file_name_;
	string id_;
	bool scaling_;
	bool derived_scaling_;
	double scaling_factor_;
	double scaling_offset_;
	bool expver_;
	bool units_;
	auto_ptr<GribAddressMode> address_mode_;
	auto_ptr<WindMode> wind_mode_;
	int grib_field_position_;
	int position_1_;
	int position_2_;
	int colour_position_;
	double missing_value_;

private:
  
	friend ostream& operator<<(ostream& s,const GribDecoderAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
