/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file MagnifierVisitorAttributes.h
    \brief Definition of MagnifierVisitor Attributes class.
    \author Meteorological Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Mon Apr 15 17:55:27 2013
*/
   

#ifndef MagnifierVisitorAttributes_H
#define MagnifierVisitorAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "Colour.h"

namespace magics {

class XmlNode;



class MagnifierVisitorAttributes 
{
public:
//  --  constructor
    MagnifierVisitorAttributes();
    
//  --  destructor
    virtual ~MagnifierVisitorAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const MagnifierVisitorAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

	

public:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream& out) const;
	//  --  members:
	string tag_;
	string symbol_name_;
	string hidden_symbol_name_;
	auto_ptr<Colour> symbol_colour_;
	auto_ptr<Colour> hidden_symbol_colour_;
	double symbol_height_;
	double hidden_symbol_height_;
	string text_font_name_;
	double text_font_size_;
	auto_ptr<Colour> text_font_colour_;
	string text_format_;

private:
  
	friend ostream& operator<<(ostream& s,const MagnifierVisitorAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
