/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file ListColourTechniqueAttributes.h
    \brief Definition of ListColourTechnique Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Tue Nov 22 10:53:37 2011
*/
   

#ifndef ListColourTechniqueAttributes_H
#define ListColourTechniqueAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "ColourTableDefinitionListInterface.h"

namespace magics {

class XmlNode;



class ListColourTechniqueAttributes : public ColourTableDefinitionListInterface
{
public:
//  --  constructor
    ListColourTechniqueAttributes();
    
//  --  destructor
    virtual ~ListColourTechniqueAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const ListColourTechniqueAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  List of colours to be used in contour shading. 
    \param values Setting contour_shade_colour_list - default=stringarray()
*/
	void setValues(stringarray values) 
		{ values_ =  values; } 
	stringarray getValues() const 
		{ return values_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	stringarray values_;

private:
  
	friend ostream& operator<<(ostream& s,const ListColourTechniqueAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
