/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file AxisTickAttributes.cc
    \brief Implemtation of AxisTick Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Tue Nov 22 10:53:40 2011
*/    

#include "AxisTickAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


AxisTickAttributes::AxisTickAttributes():
	colour_(MagTranslator<string, Colour>().magics("axis_tick_colour")),
	length_(ParameterManager::getDouble("axis_tick_size")),
	thickness_(ParameterManager::getInt("axis_tick_thickness"))
{
} 



AxisTickAttributes::~AxisTickAttributes()
{
}

    
void AxisTickAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	prefix[0] = "axis_tick";
	prefix[1] = "axis";

	setAttribute(prefix, "axis_tick_colour", colour_, params);
	setAttribute(prefix, "axis_tick_size", length_, params);
	setAttribute(prefix, "axis_tick_thickness", thickness_, params);
}

void AxisTickAttributes::copy(const AxisTickAttributes& other)
{
	setColour(other.colour_->clone());
	length_ = other.length_;
	thickness_ = other.thickness_;
} 


bool AxisTickAttributes::accept(const string& node)
{	
	if ( magCompare(node, "tick")  )
		return true;
	return false;
}

void AxisTickAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "tick") )
		set(node.attributes());
	else {
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void AxisTickAttributes::print(ostream& out)  const
{
	out << "AxisTickAttributes[";
	out << "colour = " << *colour_;
	out << ", length = " << length_;
	out << ", thickness = " << thickness_;
	out << "]" << "\n";
}


void AxisTickAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
     out <<  "\"tick\"";
	 out << ", \"axis_tick_colour\":";
	 niceprint(out, *colour_);
	 out << ", \"axis_tick_size\":";
	 niceprint(out,length_);
	 out << ", \"axis_tick_thickness\":";
	 niceprint(out,thickness_);
}
static MagicsParameter<string> axis_tick_colour("axis_tick_colour", "automatic", "");
static MagicsParameter<double> axis_tick_size("axis_tick_size", 0.175, "");
static MagicsParameter<int> axis_tick_thickness("axis_tick_thickness", 2, "");
