/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file Akima760MethodAttributes.h
    \brief Definition of Akima760Method Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Tue Nov 22 10:53:39 2011
*/
   

#ifndef Akima760MethodAttributes_H
#define Akima760MethodAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"



namespace magics {

class XmlNode;



class Akima760MethodAttributes 
{
public:
//  --  constructor
    Akima760MethodAttributes();
    
//  --  destructor
    virtual ~Akima760MethodAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const Akima760MethodAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief X resolution of Akima interpolation
    \param resolutionx Setting contour_akima_x_resolution - default=1.5
*/
	void setResolutionX(double resolutionx) 
		{ resolutionX_ =  resolutionx; } 
	double getResolutionX() const 
		{ return resolutionX_; } 
        
/*!
    Magics Information:
    \brief Y resolution of Akima interpolation
    \param resolutiony Setting contour_akima_y_resolution - default=1.5
*/
	void setResolutionY(double resolutiony) 
		{ resolutionY_ =  resolutiony; } 
	double getResolutionY() const 
		{ return resolutionY_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	double resolutionX_;
	double resolutionY_;

private:
  
	friend ostream& operator<<(ostream& s,const Akima760MethodAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
