/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file NetcdfInterpretorAttributes.h
    \brief Definition of NetcdfInterpretor Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Tue Nov 22 10:53:39 2011
*/
   

#ifndef NetcdfInterpretorAttributes_H
#define NetcdfInterpretorAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"



namespace magics {

class XmlNode;



class NetcdfInterpretorAttributes 
{
public:
//  --  constructor
    NetcdfInterpretorAttributes();
    
//  --  destructor
    virtual ~NetcdfInterpretorAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const NetcdfInterpretorAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief Path of the file to be read
    \param path Setting netcdf_filename - default=
*/
	void setPath(const string& path) 
		{ path_ =  path; } 
	const string& getPath() const 
		{ return path_; } 
        
/*!
    Magics Information:
    \brief The dimensions of the data to load, eg. p/100/10
    \param dimension Setting netcdf_dimension_setting - default=stringarray()
*/
	void setDimension(stringarray dimension) 
		{ dimension_ =  dimension; } 
	stringarray getDimension() const 
		{ return dimension_; } 
        
/*!
    Magics Information:
    \brief Variable name to plot
    \param field Setting netcdf_value_variable - default=
*/
	void setField(const string& field) 
		{ field_ =  field; } 
	const string& getField() const 
		{ return field_; } 
        
/*!
    Magics Information:
    \brief Scaling factor to multiply the field value by
    \param scaling Setting netcdf_field_scaling_factor - default=1
*/
	void setScaling(double scaling) 
		{ scaling_ =  scaling; } 
	double getScaling() const 
		{ return scaling_; } 
        
/*!
    Magics Information:
    \brief Offset added to the field values
    \param offset Setting netcdf_field_add_offset - default=0
*/
	void setOffset(double offset) 
		{ offset_ =  offset; } 
	double getOffset() const 
		{ return offset_; } 
        
/*!
    Magics Information:
    \brief Attribute to read to know the value used to indicate a missing value in the data
    \param missing_attribute Setting netcdf_missing_attribute - default=missing_value
*/
	void setMissing_attribute(const string& missing_attribute) 
		{ missing_attribute_ =  missing_attribute; } 
	const string& getMissing_attribute() const 
		{ return missing_attribute_; } 
        
/*!
    Magics Information:
    \brief attributes name to find the refernce date
    \param reference Setting netcdf_reference_date - default=0
*/
	void setReference(const string& reference) 
		{ reference_ =  reference; } 
	const string& getReference() const 
		{ return reference_; } 
        
/*!
    Magics Information:
    \brief  Values in the input field(s) below this value are to be suppressed, i.e. not to be taken into consideration for plotting purposes 
    \param suppress_below Setting netcdf_field_suppress_below - default=-1.0e+21
*/
	void setSuppress_below(double suppress_below) 
		{ suppress_below_ =  suppress_below; } 
	double getSuppress_below() const 
		{ return suppress_below_; } 
        
/*!
    Magics Information:
    \brief  Values in the input field(s) above this value are to be suppressed, i.e not to be taken into consideration for plotting purposes 
    \param suppress_above Setting netcdf_field_suppress_above - default=1.0e+21
*/
	void setSuppress_above(double suppress_above) 
		{ suppress_above_ =  suppress_above; } 
	double getSuppress_above() const 
		{ return suppress_above_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	string path_;
	stringarray dimension_;
	string field_;
	double scaling_;
	double offset_;
	string missing_attribute_;
	string reference_;
	double suppress_below_;
	double suppress_above_;

private:
  
	friend ostream& operator<<(ostream& s,const NetcdfInterpretorAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
