/*! \file DataConverter.cc
    \brief Implementation of the Template class DataConverter.
    
    Magics Team - ECMWF 2009
    
    Started: Wed 22-Jul-2009
    
    Changes:
    
*/



#include "DataConverter.h"

using namespace magics;

DataConverter::DataConverter(Data<GeoPoint>* data) : data_(data) 
{
}


DataConverter::~DataConverter() 
{
}

/*!
 Class information are given to the output-stream.
*/		
void DataConverter::print(ostream& out)  const
{
	out << "DataConverter[";
	out << "]";
}

PointsHandler<UserPoint>& DataConverter::points()
{ 
       if ( points_.empty()) {
            PointsHandler<GeoPoint>& points = data_->points();
            points.setToFirst();
                while (points.more()) {
                    GeoPoint geo = points.current();
                    points_.push_back(UserPoint(geo.x(), geo.y(), geo.value()));
                    points.advance();
                }
       }
       
       pointsHandlers_.push_back(new PointsHandler<UserPoint>(points_)); 
       return *(pointsHandlers_.back());
     
      
       
        
}
