/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file HiLoTechniqueAttributes.h
    \brief Definition of HiLoTechnique Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Mon Mar  5 17:12:45 2012
*/
   

#ifndef HiLoTechniqueAttributes_H
#define HiLoTechniqueAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "Colour.h"

namespace magics {

class XmlNode;



class HiLoTechniqueAttributes 
{
public:
//  --  constructor
    HiLoTechniqueAttributes();
    
//  --  destructor
    virtual ~HiLoTechniqueAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const HiLoTechniqueAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Height of local maxima/minima text or numbers 
    \param contour_hilo_height Setting contour_hilo_height - default=0.4
*/
	void setContour_hilo_height(double contour_hilo_height) 
		{ contour_hilo_height_ =  contour_hilo_height; } 
	double getContour_hilo_height() const 
		{ return contour_hilo_height_; } 
        
/*!
    Magics Information:
    \brief  (LOW/MEDIUM/HIGH) 
    \param contour_hilo_quality Setting contour_hilo_quality - default=low
*/
	void setContour_hilo_quality(const string& contour_hilo_quality) 
		{ contour_hilo_quality_ =  contour_hilo_quality; } 
	const string& getContour_hilo_quality() const 
		{ return contour_hilo_quality_; } 
        
/*!
    Magics Information:
    \brief  Colour of local maxima text or number 
    \param hi_colour Setting contour_hi_colour - default=blue
*/
	void setHi_colour(Colour* hi_colour) 
		{ auto_ptr<Colour> tmp(hi_colour); hi_colour_ = tmp; } 
	const Colour&  getHi_colour() const 
		{ return *hi_colour_; }
/*!
    Magics Information:
    \brief  Colour of local minima text or number 
    \param lo_colour Setting contour_lo_colour - default=blue
*/
	void setLo_colour(Colour* lo_colour) 
		{ auto_ptr<Colour> tmp(lo_colour); lo_colour_ = tmp; } 
	const Colour&  getLo_colour() const 
		{ return *lo_colour_; }
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	double contour_hilo_height_;
	string contour_hilo_quality_;
	auto_ptr<Colour> hi_colour_;
	auto_ptr<Colour> lo_colour_;

private:
  
	friend ostream& operator<<(ostream& s,const HiLoTechniqueAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
