/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file AxisTitle.cc
    \brief Implementation of the Template class AxisTitle.
    
    Magics Team - ECMWF 2005
    
    Started: Fri 7-Oct-2005
    
    Changes:
    
*/

#include "AxisTitle.h"

#include "Text.h"
#include "Transformation.h"
#include "TagHandler.h"

using namespace magics;

AxisTitle::AxisTitle() 
{
}


AxisTitle::~AxisTitle() 
{
}

/*!
 Class information are given to the output-stream.
*/		
void AxisTitle::print(ostream& out)  const
{
	out << "AxisTitle[";
	out << "]";
}

void AxisTitle::horizontal(const Colour& colour, HorizontalAxisVisitor& out) 
{
	
	Text* text = new Text();
	
	MagFont font; 
	font.size(height_);
	font.colour((colour_->automatic()) ? colour : *colour_);	
	text->setVerticalAlign(MTOP);
	TagHandler helper;
	TagConverter converter(helper);
	converter.font(font);

	converter.decode(text_, text);
	
	double x = (out.minX() + out.maxX())/2;	
	text->push_back(PaperPoint(x, out.offsetTitle())); 
	
	out.push_back(text);
}

void AxisTitle::vertical(const Colour& colour, VerticalAxisVisitor& out) 
{
	double angle = out.angleTitle();
	double x = out.offsetTitle();
	
	Text* text = new Text();
	MagFont font; 
	font.size(height_);
	font.colour((colour_->automatic()) ? colour : *colour_);	
	text->setAngle(( orientation_ == "horizontal" ) ? 0 : angle);
	TagHandler dummy;
	TagConverter converter(dummy);
	converter.font(font); 
	converter.decode(text_, text);	
	
	
    double y = (out.minY() + out.maxY())/2;
	text->push_back(PaperPoint(x, y)); 
   
	out.push_back(text);
}
