/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file BinningObjectAttributes.h
    \brief Definition of BinningObject Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Mon Mar  5 17:12:46 2012
*/
   

#ifndef BinningObjectAttributes_H
#define BinningObjectAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"



namespace magics {

class XmlNode;



class BinningObjectAttributes 
{
public:
//  --  constructor
    BinningObjectAttributes();
    
//  --  destructor
    virtual ~BinningObjectAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const BinningObjectAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief Method to compute binns : count/list/interval 
    \param x Setting binning_x_method - default=count
*/
	void setX(const string& x) 
		{ x_ =  x; } 
	const string& getX() const 
		{ return x_; } 
        
/*!
    Magics Information:
    \brief Min value used to compute the binns  
    \param x_min Setting binning_x_min_value - default=-1.0e+21
*/
	void setX_min(double x_min) 
		{ x_min_ =  x_min; } 
	double getX_min() const 
		{ return x_min_; } 
        
/*!
    Magics Information:
    \brief Max value used to compute the binns  
    \param x_max Setting binning_x_max_value - default=1.0e+21
*/
	void setX_max(double x_max) 
		{ x_max_ =  x_max; } 
	double getX_max() const 
		{ return x_max_; } 
        
/*!
    Magics Information:
    \brief Aprroximate number on binns when using the count method  
    \param x_count Setting binning_x_count - default=10
*/
	void setX_count(int x_count) 
		{ x_count_ =  x_count; } 
	int getX_count() const 
		{ return x_count_; } 
        
/*!
    Magics Information:
    \brief list of binns when using the list method 
    \param x_list Setting binning_x_list - default=floatarray()
*/
	void setX_list(floatarray x_list) 
		{ x_list_ =  x_list; } 
	floatarray getX_list() const 
		{ return x_list_; } 
        
/*!
    Magics Information:
    \brief list of binns when using the interval method 
    \param x_interval Setting binning_x_interval - default=10
*/
	void setX_interval(double x_interval) 
		{ x_interval_ =  x_interval; } 
	double getX_interval() const 
		{ return x_interval_; } 
        
/*!
    Magics Information:
    \brief  list of binns when using the interval method 
    \param x_reference Setting binning_x_reference - default=0
*/
	void setX_reference(double x_reference) 
		{ x_reference_ =  x_reference; } 
	double getX_reference() const 
		{ return x_reference_; } 
        
/*!
    Magics Information:
    \brief Method to compute binns : count/list/interval 
    \param y Setting binning_y_method - default=count
*/
	void setY(const string& y) 
		{ y_ =  y; } 
	const string& getY() const 
		{ return y_; } 
        
/*!
    Magics Information:
    \brief Min value used to compute the binns  
    \param y_min Setting binning_y_min_value - default=-1.0e+21
*/
	void setY_min(double y_min) 
		{ y_min_ =  y_min; } 
	double getY_min() const 
		{ return y_min_; } 
        
/*!
    Magics Information:
    \brief Max value used to compute the binns  
    \param y_max Setting binning_y_max_value - default=1.0e+21
*/
	void setY_max(double y_max) 
		{ y_max_ =  y_max; } 
	double getY_max() const 
		{ return y_max_; } 
        
/*!
    Magics Information:
    \brief Aprroximate number on binns when using the count method  
    \param y_count Setting binning_y_count - default=10
*/
	void setY_count(int y_count) 
		{ y_count_ =  y_count; } 
	int getY_count() const 
		{ return y_count_; } 
        
/*!
    Magics Information:
    \brief list of binns when using the list method 
    \param y_list Setting binning_y_list - default=floatarray()
*/
	void setY_list(floatarray y_list) 
		{ y_list_ =  y_list; } 
	floatarray getY_list() const 
		{ return y_list_; } 
        
/*!
    Magics Information:
    \brief list of binns when using the interval method 
    \param y_interval Setting binning_y_interval - default=10
*/
	void setY_interval(double y_interval) 
		{ y_interval_ =  y_interval; } 
	double getY_interval() const 
		{ return y_interval_; } 
        
/*!
    Magics Information:
    \brief  list of binns when using the interval method 
    \param y_reference Setting binning_y_reference - default=0
*/
	void setY_reference(double y_reference) 
		{ y_reference_ =  y_reference; } 
	double getY_reference() const 
		{ return y_reference_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	string x_;
	double x_min_;
	double x_max_;
	int x_count_;
	floatarray x_list_;
	double x_interval_;
	double x_reference_;
	string y_;
	double y_min_;
	double y_max_;
	int y_count_;
	floatarray y_list_;
	double y_interval_;
	double y_reference_;

private:
  
	friend ostream& operator<<(ostream& s,const BinningObjectAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
