/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file GeoRectangularProjectionAttributes.h
    \brief Definition of GeoRectangularProjection Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Thu Jun 16 12:02:58 2011
*/
   

#ifndef GeoRectangularProjectionAttributes_H
#define GeoRectangularProjectionAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"



namespace magics {

class XmlNode;



class GeoRectangularProjectionAttributes 
{
public:
//  --  constructor
    GeoRectangularProjectionAttributes();
    
//  --  destructor
    virtual ~GeoRectangularProjectionAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const GeoRectangularProjectionAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Latitude of lower left corner of map, if map is CYLINDRICAL, MERCATOR or defined by 'CORNERS' in POLAR STEREOGRAPHIC 
    \param min_latitude Setting subpage_lower_left_latitude - default=-90.0
*/
	void setMin_latitude(double min_latitude) 
		{ min_latitude_ =  min_latitude; } 
	double getMin_latitude() const 
		{ return min_latitude_; } 
        
/*!
    Magics Information:
    \brief  Longitude of lower left corner of map, if map is CYLINDRICAL, MERCATOR or defined by 'CORNERS' in POLAR STEREOGRAPHIC 
    \param min_longitude Setting subpage_lower_left_longitude - default=-180.0
*/
	void setMin_longitude(double min_longitude) 
		{ min_longitude_ =  min_longitude; } 
	double getMin_longitude() const 
		{ return min_longitude_; } 
        
/*!
    Magics Information:
    \brief  Latitude of upper right corner of map, if map is CYLINDRICAL, MERCATOR or defined by 'CORNERS' in POLAR STEREOGRAPHIC 
    \param max_latitude Setting subpage_upper_right_latitude - default=90.0
*/
	void setMax_latitude(double max_latitude) 
		{ max_latitude_ =  max_latitude; } 
	double getMax_latitude() const 
		{ return max_latitude_; } 
        
/*!
    Magics Information:
    \brief  Longitude of upper right corner of map, if map is CYLINDRICAL, MERCATOR or defined by 'CORNERS' in POLAR STEREOGRAPHIC 
    \param max_longitude Setting subpage_upper_right_longitude - default=180.0
*/
	void setMax_longitude(double max_longitude) 
		{ max_longitude_ =  max_longitude; } 
	double getMax_longitude() const 
		{ return max_longitude_; } 
        
/*!
    Magics Information:
    \brief  Dimension in degrees of the minimal area to display  
    \param min_area Setting subpage_minimal_area - default=0.1
*/
	void setMin_area(double min_area) 
		{ min_area_ =  min_area; } 
	double getMin_area() const 
		{ return min_area_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	double min_latitude_;
	double min_longitude_;
	double max_latitude_;
	double max_longitude_;
	double min_area_;

private:
  
	friend ostream& operator<<(ostream& s,const GeoRectangularProjectionAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
