/*! \file FrameLoop.cc
    \brief Implementation of the Template class FrameLoop.
    
    Magics Team - ECMWF 2008
    
    Started: Fri 29-Aug-2008
    
    Changes:
    
*/


#include "AnimationRules.h"
#include "BaseDriver.h"
#include "Text.h"
#include "PaperPoint.h"
#include "Layer.h"
#include <limits>

using namespace magics;


AnimationStep::AnimationStep(AnimationRules& rules) : rules_(rules),
xResolution_(std::numeric_limits<double>::max()), yResolution_(std::numeric_limits<double>::max())
{
	
}


AnimationStep::~AnimationStep() 
{
}

/*!
 Class information are given to the output-stream.
*/		
void AnimationStep::print(ostream& out)  const
{
	out << "AnimationStep[" << size() << " entries";
	TagHandler::print(out); 
	out << "]";
}


/*
const vector<string>& AnimationStep::label() 
{
	if ( !label_.empty() ) 
		return label_;
	
	for (vector<BasicSceneObject*>::iterator object = this->begin(); object != this->end(); ++object) {
		reset();
		(*object)->visit(*this);
		
		label_.push_back("param: " + get("grib", "shortName") +  get("grib", "level") + " at " +  get("grib", "valid-date"));	
		
	}	
	
	// Just for the test 
	for (vector<string>::iterator label = label_.begin(); label != label_.end(); ++label)
		Log::dev() << *label << endl;
	
	return label_;
	
}
*/
void AnimationStep::rules(vector<string>& rules)
{ 
	rules_.rules(rules); 
}

AnimationRules::AnimationRules() 
{
}

AnimationRules::~AnimationRules() 
{
}

/*!
 Class information are given to the output-stream.
*/		
void AnimationRules::print(ostream& out)  const
{
	out << endl;
//	out << endl;
}

void AnimationRules::rules(vector<string>& ) const
{
}

void AsIsAnimationRules::rules(vector<string>& infos) const
{
	infos.push_back("<grib_info key='shortName'/>");
	infos.push_back("<grib_info key='valid-date'/>");
	infos.push_back("<grib_info key='level'/>");
}


AsIsAnimationRules::AsIsAnimationRules() : AnimationRules()
{
}

AsIsAnimationRules::~AsIsAnimationRules() 
{
}

void AnimationRules::add(StepLayer& )
{
	assert(false);
}

void AsIsAnimationRules::add(StepLayer& objects )
{
	int i = 0;
	for (vector<SingleLayer*>::iterator object = objects.firstStep(); object != objects.endStep(); ++object) {
		int x = size() -1;
		if ( i > x )  
			this->push_back(new AnimationStep(*this));
		(*this)[i]->insert(make_pair(&objects, i));		
		i++;
	}
}

NoOverlayAnimationRules::NoOverlayAnimationRules() : AnimationRules()
{
}

NoOverlayAnimationRules::~NoOverlayAnimationRules() 
{
}



void NoOverlayAnimationRules::add(StepLayer& objects )
{
    int i = 0;
	for (vector<SingleLayer*>::iterator object = objects.firstStep(); object != objects.endStep(); ++object) {	
		    AnimationStep* step = new AnimationStep(*this);
		    step->insert(make_pair(&objects, i));
		    push_back(step);	
		    cout << "STEP_> " << *step << endl;
			i++;
	}
	cout << "NoOverlayAnimationRules->size()" << size() << endl;
}
void NoOverlayAnimationRules::rules(vector<string>& infos) const
{
	infos.push_back("<grib_info key='shortName'/>");
	infos.push_back("<grib_info key='valid-date'/>");
	infos.push_back("<grib_info key='level'/>");
}

/*!
 Class information are given to the output-stream.
*/		
void AsIsAnimationRules::print(ostream& out)  const
{
	out << "AsIsAnimationRules[" << this->size() << " steps";
	AnimationRules::print(out);
	out << "]";
}

/*!
 Class information are given to the output-stream.
*/		
void NoOverlayAnimationRules::print(ostream& out)  const
{
	out << "NoOverlayAnimationRules[" << this->size() << " steps";
	AnimationRules::print(out);
	out << "]";
}


DateAnimationRules::DateAnimationRules() : AnimationRules()
{
}

DateAnimationRules::~DateAnimationRules() 
{
}

/*!
 Class information are given to the output-stream.
*/		
void DateAnimationRules::print(ostream& out)  const
{
	out << "DateAnimationRules[" << this->size() << " entries";
	out << "]";
}
