/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file ImportAction.h
    \brief Definition of the Template class ImportAction.
    
    Magics Team - ECMWF 2005
    
    Started: Wed 6-Apr-2005
    
    Changes:
    
*/

#ifndef ImportAction_H
#define ImportAction_H

#include "magics.h"

#include "ImportActionAttributes.h"
#include "Data.h"

namespace magics {

template <class P>
class ImportAction: public ImportActionAttributes, public Data<P> {

public:
	ImportAction() {}
	virtual ~ImportAction() {} 
	void set(const map<string, string>& map) { ImportActionAttributes::set(map); }
	
	
	string path() { return path_; }
	void visit(AnimationStep& step) { step.update("grib", "shortName", "W200");  step.update("grib", "valid-date", valid_time_); }
	

protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream& out) const { out << "ImportAction<P>["; ImportActionAttributes::print(out); out << "]"; }  

private:
    //! Copy constructor - No copy allowed
	ImportAction(const ImportAction&);
    //! Overloaded << operator to copy - No copy allowed
	ImportAction& operator=(const ImportAction&);
    
// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const ImportAction<P>& p)
		{ p.print(s); return s; }

};

template <class P>
class ImportLoop : public DataLoop<P>, vector<Data<P> * >
{
public :
	ImportLoop() {}
	virtual ~ImportLoop() {}
	virtual void set(const map<string, string>&) {}
	virtual void set(const XmlNode&) {}
	virtual void set(LayerNode&) {}
	
	virtual void setToFirst() { current_ = this->begin(); }
	virtual Data<P>* current() { return *current_; }
	virtual bool         hasMore() { return current_!= this->end(); }
	virtual void         next() { ++current_; }
	void add(Data<P>* data) { push_back(data); } 
protected:
	typename vector<Data<P> * >::iterator current_;
};

} // namespace magics


#endif
