unit notes;
{ Translate original note to the following form:
  1. Note name.
  2. Pitch.
  3. Octave adjustments.
  4. One-character suffixes except accidental or dot, possibly sticky.
  5. Accidental with adjustments.
  6. Dot with adjustments.
  7. Xtuplet group.
}

interface uses control;

const count64: array['0'..'9'] of integer =
         ( 64, 4, 32, 2, 16, 0, 1, 0, 8, 128 );

procedure parseNote(var note, xnote: string; dur1: char; var dur: char;
  var count: integer);
function durationCode (note: string): char;
procedure translateSolfa(var nt: char);

implementation uses strings, globals;

procedure translateSolfa(var nt: char);
  var k: integer;
begin  if solfaNoteNames then
  begin k:=pos1(nt,solfa_names);  if k>0 then nt:=has_duration[k]
  end
end;

function durationCode (note: string): char;
  var code: char;
  begin  durationCode:=unspecified;  if length(note)>1 then
    begin  code:=note[2]; if pos1(code,durations)>0 then durationCode:=code
    end
  end;

function half ( dur: char ) : char;
  var k: integer;
  begin  k:= pos1 (dur, durations );  half := dur;
    if k=0 then error ('Invalid duration '+dur,print)
    else if k>ndurs then error (dur+' is too short to halve',print)
    else half := durations[k+1];
  end;

procedure addDuration ( var note: string; dur: char);
begin insertchar(dur,note,2); end;

{ Extract procedures.  All of these remove part of "note" (sometimes
  the part is empty) and put it somewhere else.  The part may be anywhere
  in "note", except when otherwise specified.}

{ Unconditionally extracts the first character. } 

procedure extractFirst(var note: string; var first: char);
begin first:=note[1];  predelete(note,1);
end;

{ Extracts at most one of the characters in "hits". }

procedure extractOneOf(var note: string; hits: string; var hit: string);
  var i, l: integer;
begin  l:=length(note); hit:='';
  for i:=1 to l do  if pos1(note[i],hits)>0 then
  begin hit:=note[i]; delete1(note,i); exit;
  end;
end;

{ Extracts contiguous characters in "hits" until no more are found.
  There may be more later. }

procedure extractContiguous(var note: string; hits: string; var hit: string);
  var i, l, len: integer;
begin  l:=length(note); len:=l; hit:='';
  for i:=1 to l do  if pos1(note[i],hits)>0 then
  begin
    repeat if pos1(note[i],hits)=0 then exit;
      hit:=hit+note[i]; delete1(note,i); dec(len)
    until len<i;
    exit;
  end;
end;

{ Extracts the specified character and everything after it. }

procedure extractAfter(var note: string; delim: char; var tail: string);
  var newlen: integer;
begin  newlen:=pos1(delim,note);  tail:='';  if newlen=0 then exit;
  dec(newlen); tail:=note; predelete(tail,newlen); note[0]:=char(newlen);
end;

{ Extracts the dot shortcut part of a note: comma shortcut is no problem
  because a comma cannot be part of a number. }

procedure extractDotShortcut(var note: string; var tail: string;
    var l: integer);
  var names, tail2: string;
      lt: integer;
      ch: char;
begin extractAfter(note,'.',tail); l:=1; lt:=length(tail);
  if (l<lt) and (tail[2]='.') then l:=2;
  if solfaNoteNames then names:=solfa_names else names:=has_duration;
  if (l<lt) and (pos1(tail[l+1],names)>0) then
    begin translateSolfa(tail[l+1]); exit end;
  if l=2 then error('".." followed by non-note',print);
  if l>=lt then begin note:=note+tail; tail:=''; exit end;
  ch:=tail[1]; predelete(tail,1);
  extractDotShortcut(tail,tail2,l); note:=note+ch+tail; tail:=tail2;
end;

{ Extracts a signed number. }

procedure extractSignedNumber(var note, number: string);
  var k: integer;
      note0: string;
begin  k:=pos1('+',note); if k=0 then k:=pos1('-',note);
  number:=''; if k=0 then exit;
  note0:=note;
  repeat number:=number+note[k]; delete1(note,k)
  until (k>length(note)) or (note[k]<>'0') and (pos1(note[k],digits)=0);
  if length(number)=1 then begin note:=note0; number:='' end
end;

{ Extracts a symbol followed by optional +- or <> shift indicators }

procedure extractGroup(var note: string; delim: char; var group: string);
  var gl, k, k0: integer;
      probe, nonumber: boolean;
      tail: string;
  procedure tryMore;
  begin  while (k<=gl) and (group[k]=group[1]) do inc(k) end;
  procedure try(s: string);
  begin  probe:=(k<gl) and (pos1(group[k],s)>0);  if probe then inc(k)
  end;
  procedure tryNumber;
    var dot: boolean;
  begin  nonumber:=true;  dot:=false;
    while (k<=gl) and (pos1(group[k],digitsdot)>0) do
    begin inc(k);  if group[k]='.' then
      if dot then error('Extra dot in number',print) else dot:=true
      else  nonumber:=false
    end
  end;
begin  extractAfter(note,delim,group); if group='' then exit;
  gl:=length(group); k:=2;
  if (gl>1) and (group[2]=':') then k:=3   else
  begin  tryMore;
    k0:=k; try('+-<>'); if probe then tryNumber;  if nonumber then k:=k0;
    k0:=k; try('+-<>'); if probe then tryNumber;  if nonumber then k:=k0;
  end;
  tail:=group; dec(k); group[0]:=char(k); predelete(tail,k);
  note:=note+tail
end;

{ Not perfect for rests, e.g. wrongly r+6 -> r6+ }
procedure parseNote(var note, xnote: string; dur1: char; var dur: char;
  var count: integer);
var shortcut, xtuplet, accidental, dotgroup, duration, octave, onlymidi: string;
    name, sc: char;
    l, multiplicity: integer;
begin  xnote:=''; shortcut:=''; xtuplet:=''; accidental:='';
  dotgroup:=''; duration:=''; octave:='';
  onlymidi:='';
  if (note='') or not isNoteOrRest(note) or isPause(note) then exit;
  extractFirst(note,name);
  extractAfter(note,'x',xtuplet);
  extractAfter(note,',',shortcut);
  if shortcut='' then extractDotShortcut(note,shortcut,multiplicity);
  if name<>rest then
  begin extractGroup(note,'s',accidental);
    if accidental='' then extractGroup(note,'f',accidental);
    if accidental='' then extractGroup(note,'n',accidental);
  end;
{ Look for 'i' anywhere in what is left of note.}
  if accidental<>'' then
  begin extractOneOf(note,'i',onlymidi);
    if onlymidi<>'' then insertchar('i',accidental,2);
  end;
  extractGroup(note,'d',dotgroup);
  if name=rest then extractSignedNumber(note,accidental);
  extractOneOf(note,durations,duration);
  if duration='' then dur:=dur1 else dur:=duration[1];
  count:=count64[dur]; if dotgroup<>'' then
  begin inc(count,count div 2);
    if startswith(dotgroup,'dd') then inc(count,count div 6)
  end;
  if note<>rest then extractContiguous(note,'=+-',octave);
  duration:=dur; if shortcut<>'' then
  begin  if dotgroup<>'' then
    error('You may not explicitly dot a note with a shortcut',print);
    sc:=shortcut[1]; predelete(shortcut,1);
    if sc='.' then
    begin  if multiplicity=2 then predelete(shortcut,1);
      if not split_dots then duration[1] := half(duration[1])
      else inc(count,count);
      dur1:=duration[1];
      for l:=1 to multiplicity do
      begin duration:=duration+dotcode; dur1:=half(dur1) end;
      addDuration(shortcut,dur1);
    end  else
    begin addDuration(shortcut,half(duration[1]));
      inc(count,count div 2)
    end
  end;
  note := name + duration + octave + note + accidental + dotgroup
    + xtuplet;
  xnote := shortcut;
end;

end.
