/* Output from p2c 1.21alpha-07.Dec.93, the Pascal-to-C translator */
/* From input file "preamble.pas" */


#include "cfuncs.h"


#define PREAMBLE_G
#include "preamble.h"


#ifndef MTXLINE_H
#include "mtxline.h"
#endif

#ifndef STRINGS_H

#endif

#ifndef FILES_H
#include "files.h"
#endif


#define blank_          ' '
#define colon_          ':'
#define semicolon       ';'
#define comma           ','

#define max_styles      24


typedef enum {
  none, title, composer, pmx, options, msize, bars, shortnote, style, sharps,
  flats, meter, space, pages, systems, name, indent, poet, part, only, start
} command_type;

typedef enum {
  unknown, colon_line, command_line, comment_line, plain_line
} line_type;

typedef char style_index;

typedef char style_index0;


#define c1              title
#define cn              start


static short known_styles = 12;
static boolean warn_redefine = false;

static char commands[21][17] = {
  "NONE", "TITLE", "COMPOSER", "PMX", "OPTIONS", "SIZE", "BARS/LINE", "SHORT",
  "STYLE", "SHARPS", "FLATS", "METER", "SPACE", "PAGES", "SYSTEMS", "NAME",
  "INDENT", "POET", "PART", "ONLY", "START"
};

static char cline[21][256] = {
  "", "", "", "", "", "", "", "1/4", "", "0", "", "C", "", "1", "1", "", "",
  "", "", "", ""
};

static boolean redefined[21] = {
  false, false, false, false, false, false, false, false, false, false, false,
  false, false, false, false, false, false, false, false, false, false
};

/** Known styles */

static char known_style[max_styles][256] = {
  "SATB:    Voices S,A T,B; Choral; Clefs G F",
  "SATB4:   Voices S A T B; Choral; Clefs G G G8 F",
  "SINGER:  Voices Voice; Vocal; Clefs G",
  "PIANO:   Voices RH LH; Continuo; Clefs G F",
  "ORGAN:   Voices RH LH Ped; Continuo; Clefs G F F",
  "SOLO:    Voices V; Clefs G", "DUET:    Voices V1 Vc; Clefs G F",
  "TRIO:    Voices V1 Va Vc; Clefs G C F",
  "QUARTET: Voices V1 V2 Va Vc; Clefs G G C F",
  "QUINTET: Voices V1 V2 Va Vc1 Vc2; Clefs G G C F F",
  "SEXTET:  Voices V1 V2 Va1 Va2 Vc1 Vc2; Clefs G G C C F F",
  "SEPTET:  Voices V1 V2 Va1 Va2 Vc1 Vc2 Cb; Clefs G G C C F F F", "", "", "",
  "", "", "", "", "", "", "", "", ""
};

static style_index old_known_styles;
static boolean style_used[max_styles];
static boolean omit_line[lines_in_paragraph];
static style_index0 orig_style_line[max_styles];
static short preamble_line[21];

static short nclefs, n_pages, n_systems, n_sharps, ngroups;
static char part_line[256], title_line[256], composer_line[256],
	    pmx_line[256], options_line[256], start_line[256], voices[256],
	    clefs[256];
static short group_start[maxgroups], group_stop[maxgroups];
static char instr_name[maxstaves][41];
static boolean style_applied, style_supplied;


/* ------------------ Styles ------------------ */

static voice_index0 voiceCount(char *s_)
{
  char s[256];
  short i, l;

  strcpy(s, s_);
  l = strlen(s);
  for (i = 0; i <= l - 1; i++) {
    if (s[i] == comma)
      s[i] = blank_;
  }
  return (wordCount(s));
}


static style_index0 findStyle(char *s_)
{
  style_index0 Result = 0;
  char s[256];
  style_index0 i = 0;

  strcpy(s, s_);
  sprintf(s + strlen(s), "%c", colon_);
  while (i < known_styles) {
    i++;
    if (startsWithIgnoreCase(known_style[i-1], s))
      return i;
  }
  return Result;
}


static void addStyle(char *S)
{
  style_index0 sn;
  char STR1[256];

  sn = findStyle(NextWord(STR1, S, colon_, dummy));
  if (sn > 0) {
    strcpy(known_style[sn-1], S);
    return;
  }
  if (known_styles < max_styles) {
    known_styles++;
    strcpy(known_style[known_styles-1], S);
  } else
    error("Can't add another style - table full", print);
}


static void readStyles(void)
{
  boolean eofstyle;
  char S[256];
  style_index0 l = 0;
  char *TEMP;

  if (styleFileFound())
    eofstyle = true;
  else
    eofstyle = P_eof(stylefile);
  while (!eofstyle) {
    fgets(S, 256, stylefile);
    TEMP = strchr(S, '\n');
    if (TEMP != NULL)
      *TEMP = 0;
    if (*S != '\0') {
      addStyle(S);
      l++;
      orig_style_line[known_styles-1] = l;
    }
    eofstyle = P_eof(stylefile);
  }
}


static void applyStyle(char *s_, char *stylename, stave_index first_inst,
		       stave_index first_stave)
{
  char s[256];
  char clef[256], subline[256], subcommand[256];
  stave_index0 i, last_inst, last_stave;
  boolean continuo = false, toosoon = false, vocal = false;
  char STR2[256];

  strcpy(s, s_);
  last_inst = first_inst - 1;
  GetNextWord(subline, s, blank_, colon_);
  while (*s != '\0') {
    GetNextWord(subline, s, semicolon, dummy);
    i = curtail(subline, semicolon);
    GetNextWord(subcommand, subline, blank_, dummy);
    if (equalsIgnoreCase(subcommand, "VOICES")) {
      sprintf(voices + strlen(voices), " %s", subline);
      last_stave = first_stave + wordCount(subline) - 1;
      last_inst = first_inst + voiceCount(subline) - 1;
    } else if (equalsIgnoreCase(subcommand, "CLEFS")) {
      strcpy(clef, subline);
      sprintf(clefs + strlen(clefs), " %s", clef);
    } else if (equalsIgnoreCase(subcommand, "VOCAL")) {
      if (last_inst < first_inst)
	toosoon = true;
      else {
	some_vocal = true;
	vocal = true;
	for (i = first_inst; i <= last_inst; i++)
	  setVocal(i, true);
      }
    } else if (equalsIgnoreCase(subcommand, "CHORAL") ||
	       equalsIgnoreCase(subcommand, "GROUP")) {
      if (last_inst < first_inst)
	toosoon = true;
      else {
	if (equalsIgnoreCase(subcommand, "CHORAL")) {
	  some_vocal = true;
	  vocal = true;
	  for (i = first_inst; i <= last_inst; i++)
	    setVocal(i, true);
	}
	if (ngroups == maxgroups)
	  error("Too many groups", print);
	else {
	  ngroups++;
	  group_start[ngroups-1] = first_stave;
	  group_stop[ngroups-1] = last_stave;
	}
      }
    } else if (equalsIgnoreCase(subcommand, "CONTINUO"))
      continuo = true;
    else {
      sprintf(STR2, "Subcommand %s in STYLE unknown", subcommand);
      error(STR2, print);
    }
    if (toosoon) {
      sprintf(STR2, "You must first give VOICES before specifying %s",
	      subcommand);
      error(STR2, print);
    }
  }
  if (vocal && continuo)
    error("A continuo instrument may not be vocal", print);
  if (wordCount(clef) != last_stave - first_stave + 1)
    error("Number of clefs does not match number of voices", print);
  if (first_stave == last_stave || continuo) {
    strcpy(instr_name[first_stave-1], stylename);
/* p2c: preamble.pas, line 182:
 * Note: Possible string truncation in assignment [145] */
  } else {
    for (i = first_stave - 1; i <= last_stave - 1; i++)
      *instr_name[i] = '\0';
  }
  if (continuo) {
    ninstr++;
    stave[ninstr-1] = first_stave;
    for (i = first_stave - 1; i <= last_stave - 1; i++)
      instr[i] = ninstr;
    return;
  }
  for (i = first_stave; i <= last_stave; i++) {
    ninstr++;
    stave[ninstr-1] = i;
    instr[i-1] = ninstr;
  }
}


static void applyStyles(void)
{
  short n1, n2, sn;
  char s[256];
  char STR2[256];

  *voices = '\0';
  *clefs = '\0';
  ninstr = 0;
  while (*cline[(long)style] != '\0') {
    n1 = voiceCount(voices) + 1;
    n2 = wordCount(voices) + 1;
    GetNextWord(s, cline[(long)style], blank_, comma);
    curtail(s, comma);
    sn = findStyle(s);
    if (sn == 0) {
      sprintf(STR2, "Style %s unknown", s);
      error(STR2, print);
    }
    line_no = orig_style_line[sn-1];
    applyStyle(known_style[sn-1], s, n1, n2);
    style_used[sn-1] = true;
  }
  style_applied = true;
}


/* ------------------------------------------------------------- */

static void wipeCommands(void)
{
  command_type c;

  for (c = c1; c <= cn; c = (command_type)((long)c + 1))
    *cline[(long)c] = '\0';
}


boolean omitLine(paragraph_index line)
{
  if (line == 0)
    return true;
  else
    return (omit_line[line-1]);
}


static void setName(void)
{
  short i, FORLIM;

  if (!redefined[(long)name])
    return;
  set_names = true;
  FORLIM = ninstr;
  for (i = 0; i <= FORLIM - 1; i++) {
    GetNextWord(instr_name[i], cline[(long)name], blank_, dummy);
/* p2c: preamble.pas, line 223:
 * Note: Possible string truncation in assignment [145] */
  }
}


static void setIndent(void)
{
  if (redefined[(long)indent])
    strcpy(fracindent, cline[(long)indent]);
}


static void checkLabel(char *w)
{
  voice_index j, FORLIM;
  char STR1[256], STR2[256];

  FORLIM = nvoices;
  for (j = 0; j <= FORLIM - 1; j++) {
    if (!strcmp(w, voice_label[j])) {
      sprintf(STR2, "Voice label %s not unique", w);
      warning(STR2, print);
      return;
    }
  }
  if (strlen(w) > 2)
    return;
  if (pos1(w[0], "CLU") > 0) {
    if (strlen(w) > 1) {
      if (pos1(w[1], "123456789") == 0)
	return;
    }
  } else if (pos1(w[0], "123456789") == 0)
    return;
  sprintf(STR1, "Voice label %s conflicts with reserved label", w);
  error(STR1, print);
}


static void setVoices(char *line)
{
  short k;
  char s[256], w[256];
  char STR1[256];

  nvoices = 0;
  nstaves = 0;
  do {
    GetNextWord(s, line, blank_, dummy);
    if (*s != '\0') {
      nstaves++;
      k = 0;
      first_on_stave[nstaves-1] = nvoices + 1;
      do {
	GetNextWord(w, s, blank_, comma);
	curtail(w, comma);
	if (*w != '\0') {
	  k++;
	  if (k <= 2) {
	    nvoices++;
	    checkLabel(w);
	    strcpy(voice_label[nvoices-1], w);
	    if (*instr_name[nstaves-1] == '\0') {
	      strcpy(instr_name[nstaves-1], w);
/* p2c: preamble.pas, line 259:
 * Note: Possible string truncation in assignment [145] */
	    }
	    setStavePos(nvoices, nstaves, k);
	  }
	}
      } while (*w != '\0');
      if (k > 2) {
	sprintf(STR1, "More than two voices per stave: %s", s);
	error(STR1, print);
      }
      if (k == 2) {
	sprintf(instr_name[nstaves-1], "\\vbox{\\hbox{%s}\\hbox{%s}}",
		voice_label[nvoices-2], voice_label[nvoices-1]);
/* p2c: preamble.pas, line 266:
 * Note: Possible string truncation in assignment [145] */
      }
      number_on_stave[nstaves-1] = k;
    }
  } while (*line != '\0');
}


static void setClefs(char *line_)
{
  char line[256];
  char s[256];

  strcpy(line, line_);
  nclefs = 0;
  do {
    GetNextWord(s, line, blank_, dummy);
    if (*s != '\0') {
      nclefs++;
      if (strlen(s) == 1)
	clef[nclefs-1] = s[0];
      else
	clef[nclefs-1] = s[1];
    }
  } while (*s != '\0');
}


static void setSize(char *line_)
{
  char line[256];
  stave_index0 i = 0;
  char word[256];

  strcpy(line, line_);
  while (i < ninstr) {
    GetNextWord(word, line, blank_, dummy);
    if (*word == '\0')
      return;
    i++;
    getNum(word, &musicsize);
    stave_size[i-1] = musicsize;
  }
  if (musicsize < 16)
    musicsize = 16;
  else if (musicsize > 20)
    musicsize = 20;
}


static command_type findCommand(char *command)
{
  command_type j;

  curtail(command, ':');
  if (equalsIgnoreCase(command, "STYLE"))
    style_supplied = true;
  for (j = c1; j <= cn; j = (command_type)((long)j + 1)) {
    if (equalsIgnoreCase(command, commands[(long)j]))
      return j;
  }
  return none;
}


boolean isCommand(char *command_)
{
  char command[256];

  strcpy(command, command_);
  return (findCommand(command) != none);
}


static line_type doCommand(char *line_)
{
  line_type Result;
  char line[256];
  char command[256];
  command_type last_command;
  short j;
  boolean starts_with_note;
  char STR1[256], STR2[256];

  strcpy(line, line_);
  if (line[0] == comment)
    return comment_line;
  starts_with_note = maybeMusicLine(line);
  GetNextWord(command, line, blank_, colon_);
  sprintf(STR1, "%c", colon_);
  if (endsWith(command, STR1)) {
    j = curtail(command, colon_);
    last_command = findCommand(command);
    Result = command_line;
    if (last_command != none) {
      strcpy(cline[(long)last_command], line);
      if (last_command == start)
	strcpy(start_line, line);
      if (warn_redefine && redefined[(long)last_command]) {
	sprintf(STR2, "You have redefined preamble command %s", command);
	warning(STR2, print);
      }
      redefined[(long)last_command] = true;
      return Result;
    }
    Result = colon_line;
    sprintf(STR2, "%s%c %s", command, colon_, line);
    addStyle(STR2);
    orig_style_line[known_styles-1] = line_no;
    return Result;
  } else if (starts_with_note)
    return plain_line;
  else
    return unknown;
  return Result;
}


void setOnly(char *line_)
{
  char line[256];
  short num, num1, num2, l;
  char s[256];
  char STR1[256];

  strcpy(line, line_);
  if (*line == '\0')
    return;
  if (startsWithIgnoreCase(line, "only"))
    GetNextWord(STR1, line, colon_, dummy);
  for (l = 0; l <= lines_in_paragraph - 1; l++)
    omit_line[l] = true;
  do {
    GetNextWord(s, line, blank_, comma);
    if (*s == '\0')
      return;
    curtail(s, comma);
    if (pos1('-', s) == 0) {
      getNum(s, &num);
      if (num > 0 && num <= lines_in_paragraph)
	omit_line[num-1] = false;
      else
	warning("Invalid line number in Only: is skipped", print);
    } else {
      getTwoNums(s, &num1, &num2);
      if (num1 > 0 && num2 <= lines_in_paragraph) {
	for (num = num1 - 1; num <= num2 - 1; num++)
	  omit_line[num] = false;
      } else
	warning("Invalid line range in Only: is skipped", print);
    }
  } while (true);
}


void interpretCommands(void)
{
  short i, num, den, nbars;
  char STR2[256];
  short FORLIM;

  strcpy(title_line, cline[(long)title]);
  strcpy(part_line, cline[(long)part]);
  if (*cline[(long)poet] == '\0')
    strcpy(composer_line, cline[(long)composer]);
  else
    sprintf(composer_line, "%s\\hfill %s",
	    cline[(long)poet], cline[(long)composer]);
  strcpy(pmx_line, cline[(long)pmx]);
  GetNextWord(options_line, cline[(long)options], blank_, dummy);
  FORLIM = known_styles;
  for (i = 0; i <= FORLIM - 1; i++)
    style_used[i] = false;
  applyStyles();
  setVoices(voices);
  FORLIM = known_styles;
  for (i = old_known_styles; i <= FORLIM - 1; i++) {
    if (!style_used[i]) {
      warning("The following style was supplied but not used", !print);
      puts(known_style[i]);
    }
  }
  setClefs(clefs);
  if (!redefined[(long)meter]) {
    sprintf(STR2, "You have not defined Meter, assuming \"%s\" ",
	    cline[(long)meter]);
    warning(STR2, !print);
  }
  setMeter(cline[(long)meter]);
  if (meternum == 0 &&
      !(redefined[(long)pages] || redefined[(long)systems] ||
	redefined[(long)bars])) {
    strcpy(cline[(long)bars], "1");
    redefined[(long)bars] = true;
  }
  if (redefined[(long)pages] || redefined[(long)systems]) {
    if (redefined[(long)bars])
      warning("BARS/LINE ignored since you specified PAGES or SYSTEMS", print);
    if (redefined[(long)systems])
      getNum(cline[(long)systems], &n_systems);
    else
      warning("PAGES specified but not SYSTEMS", !print);
    if (redefined[(long)pages])
      getNum(cline[(long)pages], &n_pages);
    else
      warning("SYSTEMS specified but not PAGES", !print);
  } else if (redefined[(long)bars]) {
    getNum(cline[(long)bars], &nbars);
    if (nbars > 0) {
      n_pages = 0;
      n_systems = nbars;
    }
  }
  getNum(cline[(long)sharps], &n_sharps);
  setSpace(cline[(long)space]);
  setSize(cline[(long)msize]);
  getTwoNums(cline[(long)shortnote], &num, &den);
  if (den == 0)
    den = 1;
  short_note = num * 64 / den;
  if (*cline[(long)flats] != '\0') {
    getNum(cline[(long)flats], &n_sharps);
    n_sharps = -n_sharps;
  }
  setName();
  setIndent();
  setOnly(cline[(long)only]);
  FORLIM = strlen(options_line);
  for (i = 0; i <= FORLIM - 1; i++)
    processOption(options_line[i]);
}


void preambleDefaults(void)
{
  short i;

  xmtrnum0 = 0.0;
  strcpy(fracindent, "0");
  musicsize = 20;
  *start_line = '\0';
  some_vocal = false;
  ngroups = 0;
  style_supplied = false;
  style_applied = false;
  for (i = 1; i <= maxvoices; i++)
    setVocal(i, false);
  for (i = 0; i <= maxstaves - 1; i++) {
    nspace[i] = unspec;
    stave_size[i] = unspec;
  }
  n_pages = 1;
  n_systems = 1;
  readStyles();
  old_known_styles = known_styles;
  for (i = 0; i <= lines_in_paragraph - 1; i++)
    omit_line[i] = false;
}


static void preambleGuess(voice_index maybe_voices)
{
  switch (maybe_voices) {

  case 1:
    strcpy(cline[(long)style], "Solo");
    break;

  case 2:
    strcpy(cline[(long)style], "Duet");
    break;

  case 3:
    strcpy(cline[(long)style], "Trio");
    break;

  case 4:
    strcpy(cline[(long)style], "Quartet");
    break;

  case 5:
    strcpy(cline[(long)style], "Quintet");
    break;

  case 6:
    strcpy(cline[(long)style], "Sextet");
    break;

  case 7:
    strcpy(cline[(long)style], "Septet");
    break;

  default:
    error("I cannot guess a style", !print);
    return;
    break;
  }
  printf("I guess this piece is a %s for strings in C major.\n",
	 cline[(long)style]);
  printf("  Why not provide a STYLE in the setup paragraph to make sure?\n");
}


/* ------------------------------------------------------------------ */

void nonMusic(void)
{
  paragraph_index i, FORLIM;

  FORLIM = para_len;
  for (i = 0; i <= FORLIM - 1; i++)
    doCommand(P[i]);
  setOnly(cline[(long)only]);
  wipeCommands();
}


boolean thisCase(void)
{
  boolean Result;

/* p2c: preamble.pas: Note: Eliminated unused assignment statement [338] */
  if (!startsWithIgnoreCase(P[0], "case:"))
    return true;
  Result = (choice != ' ' && pos1(choice, P[0]) > 0);
  strcpy(P[0], "%");
  return Result;
}


void augmentPreamble(boolean control_para)
{
  paragraph_index i;
  line_type l;
  short s[5];
  paragraph_index FORLIM;

  if (!thisCase())
    return;
  for (l = unknown; l <= plain_line; l = (line_type)((long)l + 1))
    s[(long)l] = 0;
  FORLIM = para_len;
  for (i = 0; i <= FORLIM - 1; i++) {
    line_no = orig_line_no[i];
    l = doCommand(P[i]);
    s[(long)l]++;
    if (l == comment_line && P[i][1] == comment) {
      predelete(P[i], 2);
      putLine(P[i]);
    }
    if (!control_para && l == unknown)
      error("Unidentifiable line", print);
  }
  if (!control_para && s[(long)command_line] > 0 && s[(long)plain_line] > 0)
    error("Mixture of preamble commands and music", !print);
}


void doPreamble(void)
{
  paragraph_index i;
  voice_index0 maybe_voices = 0;
  paragraph_index FORLIM;

  if (style_supplied)  /*augmentPreamble(not known);*/
    return;
  if (true)
    warning("No STYLE supplied", !print);
  FORLIM = para_len;
  for (i = 0; i <= FORLIM - 1; i++) {
    if (maybeMusicLine(P[i]))
      maybe_voices++;
  }
  if (maybe_voices > 0)
    preambleGuess(maybe_voices);
  else
    error("No voices found", !print);
}


void respace(void)
{
  stave_index i, j;
  char STR1[256];
  char STR2[256], STR3[256];

  for (i = ninstr; i >= 2; i--) {
    j = ninstr - i + 1;
    if (nspace[j-1] != unspec) {
      sprintf(STR3, "\\setinterinstrument%s{%s\\Interligne}",
	      toString(STR1, i - 1), toString(STR2, nspace[j-1]));
      tex3(STR3);
    }
  }
  if (nspace[nstaves-1] != unspec) {
    sprintf(STR3, "\\staffbotmarg%s\\Interligne",
	    toString(STR1, nspace[nstaves-1]));
    tex3(STR3);
  }
  must_respace = false;
}


static short clefno(char cl)
{
  short Result;

  switch (cl) {

  case 'G':
  case '0':
  case 't':
  case '8':
    Result = 0;
    break;

  case 's':
  case '1':
    Result = 1;
    break;

  case 'm':
  case '2':
    Result = 2;
    break;

  case 'a':
  case '3':
    Result = 3;
    break;

  case 'n':
  case '4':
    Result = 4;
    break;

  case 'r':
  case '5':
    Result = 5;
    break;

  case 'F':
  case 'b':
  case '6':
    Result = 6;
    break;

  case 'C':
    Result = 3;
    break;

  default:
    warning("Unknown clef code - replaced by treble", print);
    Result = 0;
    break;
  }
  return Result;
}


static void doTenorClefs(void)
{
  voice_index i;
  char c;
  voice_index FORLIM;
  char STR1[256];
  char STR3[256];

  FORLIM = nclefs;
  for (i = 1; i <= FORLIM; i++) {
    c = clef[i-1];
    if (c == '8' || c == 't') {
      sprintf(STR3, "\\\\settrebleclefsymbol{%s}\\treblelowoct\\",
	      toString(STR1, PMXinstr(i)));
      putLine(STR3);
    }
  }
}


static char *pmxMeter(char *Result)
{
  short denom, num;
  char STR1[256], STR3[256], STR4[256], STR5[256];

  if (meternum != 0) {
    num = meternum;
    denom = pmdenom;
    sprintf(Result, "%s %s %s %s",
	    toString(STR1, num), toString(STR3, meterdenom),
	    toString(STR4, pmnum), toString(STR5, denom));
    return Result;
  }
  num = beatsPerLine();
  denom = 0;
  meterChange(old_meter_word, num, meterdenom, true);
  sprintf(Result, "%s %s %s %s",
	  toString(STR1, num), toString(STR3, meterdenom),
	  toString(STR4, pmnum), toString(STR5, denom));
  return Result;
}

static char *sizecode(char *Result, short k)
{
  strcpy(Result, "\\normalvalue");
  switch (k) {

  case 13:
    if (musicsize == 20)
      strcpy(Result, "\\tinyvalue");
    else
      strcpy(Result, "\\smallvalue");
    break;

  case 16:
    if (musicsize == 20)
      strcpy(Result, "\\smallvalue");
    break;

  case 20:
    if (musicsize == 16)
      strcpy(Result, "\\largevalue");
    break;

  case 24:
    if (musicsize == 20)
      strcpy(Result, "\\largevalue");
    else
      strcpy(Result, "\\Largevalue");
    break;

  case 29:
    strcpy(Result, "\\Largevalue");
    break;

  default:
    error("Valid sizes are 13, 16, 20, 24, 29", print);
    break;
  }
  return Result;
}


void doPMXpreamble(void)
{
  static char clefcode[9] = "0123456";
  boolean easy;
  short i, j;
  char clefs[256];
  char STR1[256];
  char STR2[256];
  char STR3[256];
  short FORLIM;
  char STR4[54];

  putLine("---");
  if (set_names && !redefined[(long)indent])
    strcpy(fracindent, "0.12");
  fprintf(outfile, "%d", nstaves);
  easy = (ninstr == nstaves || ninstr == 1);
  if (!easy)
    easy = (stave[ninstr-2] == ninstr - 1);
  if (easy)
    fprintf(outfile, " %d", ninstr);
  else {
    if (!private_pmx) {
      printf("Continuo instrument anywhere except last uses\n");
      warning("  an undocumented PMX feature", print);
    }
    fprintf(outfile, " %d", -ninstr);
    stave[ninstr] = nstaves + 1;
    for (j = ninstr; j >= 1; j--)
      fprintf(outfile, " %d", stave[j] - stave[j-1]);
  }
  fprintf(outfile, " %s %8.5f %d %d %d %d %s\n",
	  pmxMeter(STR3), xmtrnum0, n_sharps, n_pages, n_systems, musicsize,
	  fracindent);
  FORLIM = ninstr;
  for (i = 1; i <= FORLIM; i++) {
    if (!set_names)
      putLine("");
    else {
      sprintf(STR4, "{\\twelvebf{%s}}", instr_name[ninstr - i]);
      putLine(STR4);
    }
  }
  *clefs = '\0';
  for (i = nclefs - 1; i >= 0; i--)
    sprintf(clefs + strlen(clefs), "%c", clefcode[clefno(clef[i])]);
  putLine(clefs);
  if (*texdir == '\0')
    strcpy(texdir, "./");
  putLine(texdir);

  pmx_preamble_done = true;
  respace();

  FORLIM = ngroups;
  for (j = 1; j <= FORLIM; j++)
    fprintf(outfile, "\\\\grouptop%d%d\\groupbottom%d%d\\\n",
	    j, ninstr - group_start[j-1] + 1, j,
	    ninstr - group_stop[j-1] + 1);
  FORLIM = ninstr;
  for (j = 1; j <= FORLIM; j++) {
    if (stave_size[j-1] != unspec) {
      sprintf(STR2, "\\\\setsize%s{%s}\\",
	      toString(STR3, ninstr - j + 1),
	      sizecode(STR1, stave_size[j-1]));
      putLine(STR2);
    }
  }
  if (*part_line != '\0') {
    putLine("Ti");
    putLine(part_line);
  }
  if (*title_line != '\0') {
    putLine("Tt");
    putLine(title_line);
  }
  if (*composer_line != '\0') {
    putLine("Tc");
    putLine(composer_line);
  }
  if (*pmx_line != '\0')
    putLine(pmx_line);
  doTenorClefs();
  wipeCommands();
}


char *startString(char *Result, voice_index0 voice)
{
  char s[256], w[256];
  voice_index j;

  strcpy(s, start_line);
  for (j = 1; j <= voice; j++)
    GetNextWord(w, s, dummy, ';');
  curtail(w, ';');
  if (*w != '\0') {
    sprintf(Result, "%s ", w);
    return Result;
  } else
    return strcpy(Result, w);
}




/* End. */
