require 'xtemplate'

XTemplate::use_simple_expand()

MAX = (ARGV[0] || "3000").to_i
xt_data = {  # data for Amrita
  "books" => (0..MAX).collect{|i|
    { "@isbn" => i,  "title" => "book#{i}", "authors" => "author#{i}" }
  }
}

t = XTemplate::XMLTemplate.new <<EOF
<?xml version="1.0" encoding="UTF-8"?>
<books>
  <book id="books">
    <title id="title"></title>
    <author id="authors"></author>
  </book>
</books>
EOF

t1 = Time.now
t.expand2($stdout, xt_data)
t2 = Time.now
$stderr.puts t2 - t1
