# -*- ruby -*-
#
# Select data with '[node]', which selects all nodes having 'node'.
#

require 'xtemplate'

data ={
  'links' => [
    {'url' => "url1", 'name' => "anchor1"},
    {'url' => "url2", 'name' => "anchor2"},
    {'url' => "url3"                     },
    {                 'name' => "anchor4"},
  ]
}

text = <<EOF
<?xml version="1.0" encoding="EUC-JP"?>
<html>
<body>
  Links which has 'name' field.
  <ul>
    <li id="links[name]/name"></li>
  </ul>

  Links which has no 'name' field.
  <ul>
    <li id="links[not name]/url"></li>
  </ul>

  Links which has both of 'name' and 'url' fields.
  <ul>
    <li id="links[name and url]">
      <url id="url" /><name id="name" />
    </li>
  </ul>
</body>
</html>
EOF

t = XTemplate::XMLTemplate.new(text)
print(t.expand(data))
