# -*- ruby -*-
#
# Using a dummy node.
#

require 'xtemplate'

data = {
  'members' => [
    {'member' => {'name' => 'name1', '@uid' => 1}},
    {'member' => {'name' => 'name2', '@uid' => 2, 'age' => 22}},
    {'member' => {'name' => 'name3', '@uid' => 3, 'age' => 23}},
  ]
}

text = <<EOF
<?xml version="1.0" encoding="EUC-JP"?>
<members>
   <!-- without propagation="no" -->
   <member id="members">
     <xt:select xmlns:xt="#{XTemplate::BIND_URI}" id="member">
       <name xt:id="name" />
       <age xt:id="age" />
     </xt:select>
   </member>

   <!-- with propagation="no" -->
   <member id="members">
     <xt:select xmlns:xt="#{XTemplate::BIND_URI}" id="member" propagation="no">
       <name xt:id="name" />
       <age xt:id="age" />
     </xt:select>
   </member>
</members>
EOF

t = XTemplate::XMLTemplate.new(text)
print(t.expand(data))
