/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;

public class StringUtils {
    private static String notResolveEntityList = new String("-lt--gt--quot--amp-");

    private StringUtils() {
    }

    public static String assembleString(Collection coll, String delim) {
        if (coll == null || coll.isEmpty()) {
            return "";
        }
        StringBuffer buff = new StringBuffer(200);
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            buff.append(iter.next());
            if (!iter.hasNext()) continue;
            buff.append(delim);
        }
        return buff.toString();
    }

    public static String resolveDirectory(String rootPath, String relativePath) {
        if (relativePath.indexOf(35) != -1) {
            relativePath = relativePath.substring(0, relativePath.indexOf(35));
        }
        relativePath = relativePath.replace('\\', File.separatorChar);
        relativePath = relativePath.replace('/', File.separatorChar);
        if (rootPath == null) {
            return relativePath;
        }
        String prefix = null;
        prefix = rootPath.charAt(rootPath.length() - 1) == File.separatorChar ? rootPath.substring(0, rootPath.length() - 1) : rootPath;
        String postfix = relativePath;
        while (postfix.startsWith("..")) {
            int sepPos = postfix.indexOf(File.separatorChar);
            int lastPos = prefix.lastIndexOf(File.separatorChar);
            postfix = postfix.substring(sepPos == -1 ? 0 : sepPos + File.separator.length(), postfix.length());
            if (lastPos == -1) {
                return postfix;
            }
            prefix = prefix.substring(0, lastPos);
        }
        return prefix + File.separatorChar + postfix;
    }

    public static String getEntity(String name) {
        if (name.startsWith("%")) {
            return name + ";";
        }
        return "&" + name + ";";
    }

    public static boolean checkEntity(String name) {
        return notResolveEntityList.indexOf("-" + name.trim() + "-") == -1;
    }
}

