/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.dom;

import com.jclark.xsl.dom.DOMBuilder;
import com.jclark.xsl.dom.DOMExtensions;
import com.jclark.xsl.dom.NodeBase;
import com.jclark.xsl.dom.RootNode;
import com.jclark.xsl.dom.Transform;
import com.jclark.xsl.dom.TransformEngine;
import com.jclark.xsl.dom.TransformException;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.NameTable;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.sax.ExtensionHandlerImpl;
import com.jclark.xsl.sax.MultiNamespaceResult;
import com.jclark.xsl.tr.Engine;
import com.jclark.xsl.tr.EngineImpl;
import com.jclark.xsl.tr.LoadContext;
import com.jclark.xsl.tr.ParameterSet;
import com.jclark.xsl.tr.Result;
import com.jclark.xsl.tr.Sheet;
import com.jclark.xsl.tr.XMLProcessor;
import java.io.IOException;
import java.net.URL;
import org.w3c.dom.DocumentFragment;

public class XSLTransformEngine
implements TransformEngine,
XMLProcessor {
    private Engine engine = new EngineImpl(this, new ExtensionHandlerImpl());
    private DOMExtensions extend;

    public Node load(URL url, int documentIndex, LoadContext context, NameTable nameTable) throws XSLException {
        throw new XSLException("external documents not supported");
    }

    public Result createResult(Node baseNode, int documentIndex, LoadContext loadContext, Node[] rootNodeRef) throws XSLException {
        if (baseNode == null) {
            throw new XSLException("cannot convert result tree fragment returned by extension function to a node-set with the DOM");
        }
        RootNode root = ((NodeBase)baseNode).root;
        DocumentFragment docFrag = root.ownerDocument.createDocumentFragment();
        String base = null;
        URL baseURL = baseNode.getURL();
        if (baseURL != null) {
            base = baseURL.toString();
        }
        rootNodeRef[0] = new RootNode(docFrag, this.extend, loadContext, this.engine.getNameTable(), base, documentIndex);
        return new MultiNamespaceResult(new DOMBuilder(docFrag), null);
    }

    public XSLTransformEngine() {
    }

    public XSLTransformEngine(DOMExtensions extend) {
        this();
        this.extend = extend;
    }

    public Transform createTransform(org.w3c.dom.Node domNode) throws TransformException {
        try {
            return new TransformImpl(this.engine.createSheet(new RootNode(domNode, this.extend, this.engine.getSheetLoadContext(), this.engine.getNameTable(), null, 0)));
        }
        catch (XSLException e) {
            throw this.toTransformException(e);
        }
        catch (IOException e) {
            throw new Error("unexpected exception: " + e);
        }
    }

    private TransformException toTransformException(XSLException e) {
        org.w3c.dom.Node domNode = null;
        Node node = e.getNode();
        if (node != null) {
            domNode = ((NodeBase)node).domNode;
        }
        String message = e.getMessage();
        if (e == null) {
            message = e.getException().toString();
        }
        return new TransformException(message, domNode);
    }

    private class TransformImpl
    implements Transform,
    ParameterSet {
        private Sheet sheet;

        TransformImpl(Sheet sheet) {
            this.sheet = sheet;
        }

        public void transform(org.w3c.dom.Node sourceRoot, org.w3c.dom.Node resultRoot) throws TransformException {
            try {
                this.sheet.process(new RootNode(sourceRoot, XSLTransformEngine.this.extend, this.sheet.getSourceLoadContext(), XSLTransformEngine.this.engine.getNameTable(), null, 0), XSLTransformEngine.this, this, new MultiNamespaceResult(new DOMBuilder(resultRoot), null));
            }
            catch (XSLException e) {
                throw XSLTransformEngine.this.toTransformException(e);
            }
        }

        public Object getParameter(Name name) {
            return null;
        }
    }
}

