/* Copyright (C) 2001-2002 Bart Massey and Jamey Sharp.
 * All Rights Reserved.
 * Portions Copyright 1986, 1998  The Open Group
 * 
 * See the file COPYING for licensing information. */
#include "xclint.h"

int XChangeKeyboardControl(Display *dpy, unsigned long mask, XKeyboardControl *value_list)
{
    unsigned long values[8];
    register unsigned long *value = values;

    if(!mask)
	return 1;

    if (mask & KBKeyClickPercent)
	*value++ = value_list->key_click_percent;
	
    if (mask & KBBellPercent)
    	*value++ = value_list->bell_percent;

    if (mask & KBBellPitch)
    	*value++ = value_list->bell_pitch;

    if (mask & KBBellDuration)
    	*value++ = value_list->bell_duration;

    if (mask & KBLed)
    	*value++ = value_list->led;

    if (mask & KBLedMode)
	*value++ = value_list->led_mode;

    if (mask & KBKey)
        *value++ = value_list->key;

    if (mask & KBAutoRepeatMode)
        *value++ = value_list->auto_repeat_mode;

    XCBChangeKeyboardControl(XCBConnectionOfDisplay(dpy), mask, values);
    return 1;
}
