/*
 * Ostatnia aktualizacja:
 * 
 * - $Id: roster.c,v 1.25 2004/01/19 12:37:31 mati Exp $
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include "libtlen.h"

/*
 * tlen_presence()
 *
 * Pozwala na ustawienie swojego stanu dostpnoci
 *
 * - sesja - nasza sesja
 * - status - stan w postaci TLEN_STATUS_*
 * - description - opcjonalny status opisowy, jeeli NULL to ""
 *
 * Brak uwag dodatkowych
 *
 */

int tlen_presence (struct tlen_session *sesja, int status, const char *description)
{
	char *presence;
	char *query;
	char *urlencoded;

	if (description==NULL) { description = ""; }
	
	urlencoded = tlen_encode(description);
	
	switch (status)
	{
	    case TLEN_STATUS_AVAILABLE: presence = "available"; break; 
	    case TLEN_STATUS_AWAY: presence = "away"; break; 
	    case TLEN_STATUS_CHATTY: presence = "chat"; break; 
	    case TLEN_STATUS_EXT_AWAY: presence = "xa"; break; 
	    case TLEN_STATUS_DND: presence = "dnd"; break; 
	    case TLEN_STATUS_INVISIBLE: tlen_presence_invisible(sesja); return 1; break; 
	    case TLEN_STATUS_UNAVAILABLE: tlen_presence_disconnect(sesja); return 1; break; 
	    default: presence = "available"; break;
	}

	tlen_debug ("Status: %s\nDescription: %s\n", presence, description);

	if (!(query = (char *) malloc (strlen("<presence><show></show><status></status></presence>") + strlen (presence) + strlen (urlencoded) + 1)))
	{
		perror ("malloc");
		sesja->error = TLEN_ERROR_MALLOC;
	}
	sprintf (query, "<presence><show>%s</show><status>%s</status></presence>",presence, urlencoded);
	tlen_socket_write_string (sesja, query);
	sesja->status = status;
	sesja->description = strdup(description);
	free (query);
	free (urlencoded);

	return 1;
}

/*
 * tlen_presence_invisible()
 *
 * Funkcja wewntrzna wysyajca nietypowy status niewidoczny,
 * zgodno z nowym Tlenem, brak moliwoci atwego wykrycia.
 *
 * - sesja - nasza sesja
 *
 * Nie uywa w swoich programach, od tego jest tlen_presence()
 *
 */
 
int tlen_presence_invisible (struct tlen_session *sesja)
{
	tlen_socket_write_string (sesja, "<presence type='invisible'></presence>");
	tlen_debug("Went to invisible\n");
    
	return 1;
}

/*
 * tlen_presence_disconnect()
 *
 * Funkcja wewntrzna zamykajca poczenie z serwerem,
 * wywoywana przez wysanie statusu TLEN_STATUS_UNAVAILABLE
 *
 * - sesja - nasza sesja
 *
 * Nie uywa w swoich programach, od tego jest tlen_presence()
 *
 */

int tlen_presence_disconnect (struct tlen_session *sesja)
{
	tlen_socket_write_string (sesja, "<presence type='unavailable'/>");
	tlen_socket_write_string (sesja, "</s>");
	tlen_debug("Disconnected.\n");
    
	return 1;
}

/*
 * tlen_getroster()
 *
 * Wysya prob o ksiak adresow
 *
 * - sesja - nasza sesja
 *
 * brak uwag
 *
 */

int tlen_getroster (struct tlen_session *sesja)
{
	tlen_socket_write_string (sesja, "<iq type='get' id='GetRoster'><query xmlns='jabber:iq:roster'></query></iq>");

        return 1;
}

/*
 * tlen_addcontact()
 *
 * Dodaje uytkownika do ksiki adresowej
 *
 * - sesja - nasza sesja
 * - name - nazwa uytkownika 
 * - jid - identyfikator uytkownika w @tlen.pl
 * - group - grupa dla uytkownika
 *
 * Po dodaniu wypadaoby poprosi o subskrypcj przez
 * tlen_request_subscription()
 *
 */

int tlen_addcontact (struct tlen_session *sesja, const char *name,
    		     const char *jid, const char *group)
{
	char *query;
        char *fname;
        char *fgroup=NULL;

	if (!jid)
	{
	    perror("NULL jid");
	    return 0;
	}
	if (!name)
	{
	    fname = tlen_encode(jid);
	}
        else
          fname = tlen_encode(name);
	if (!group)
	{
	    /* Mallocujemy +10, bo trzeba doliczyc 8 dlugosci sessid */
	    if (!(query = (char *) malloc (strlen("<iq type='set' id=''><query xmlns='jabber:iq:roster'><item name='' jid=''></item></query></iq>")                            + strlen (fname) + strlen (jid) + 10)))
	    {
		    perror ("malloc");
	    }

    	    sprintf (query,"<iq type='set' id='%s'><query xmlns='jabber:iq:roster'><item name='%s' jid='%s'></item></query></iq>",sesja->sid, fname, jid);
	}
	else
	{
          fgroup = tlen_encode(group);
	    /* Mallocujemy +10, bo trzeba doliczyc 8 dlugosci sessid */
	    if (!(query = (char *) malloc (strlen("<iq type='set' id=''><query xmlns='jabber:iq:roster'><item name='' jid=''><group></group></item></query></iq>")
     + strlen (fname) + strlen (jid) + strlen (fgroup) + 10)))
	    {
		    perror ("malloc");
	    }

    	    sprintf (query,"<iq type='set' id='%s'><query xmlns='jabber:iq:roster'><item name='%s' jid='%s'><group>%s</group></item></query></iq>",
                     sesja->sid, fname, jid, fgroup);
	}
	tlen_socket_write_string (sesja, query);
	free(query);
        free(fname);
        if(fgroup)
          free(fgroup);
	return 1;
}

/*
 * tlen_removecontact()
 *
 * Usuwa uytkownika z ksiki adresowej
 *
 * - sesja - nasza sesja
 * - jid - identyfikator w @tlen.pl
 *
 * Przed naley poprosi o desubskrypcj przez tlen_request_unsubscribe()
 *
 */

int tlen_removecontact (struct tlen_session *sesja, const char *jid)
{
	char *query;

	if (!(query = (char *) malloc (strlen("<iq type='set'><query xmlns='jabber:iq:roster'><item jid='' subscription='remove'></item></query></iq>") + strlen (jid) + 2)))
	{
		perror ("malloc");
	}

	sprintf (query,"<iq type='set'><query xmlns='jabber:iq:roster'><item jid='%s' subscription='remove'></item></query></iq>", jid);
	tlen_socket_write_string (sesja, query);
	free(query);
	return 1;

}

/*
 * tlen_request_subscribe()
 *
 * Wysya prob o subskrybcj
 *
 * - sesja - nasza sesja
 * - jid - identyfikator w @tlen.pl
 *
 */

int tlen_request_subscribe (struct tlen_session *sesja, const char* jid)
{
	char *query;
	if (!(query = (char *) malloc (strlen ("<presence to='' type='subscribe'/>") + strlen(jid) + 1)))
	{
		perror ("malloc");
	}
	sprintf (query, "<presence to='%s' type='subscribe'/>", jid);
	tlen_socket_write_string (sesja, query);
	free (query);
	return 1;
}

/*
 * tlen_request_unsubscribe()
 *
 * Wysya prob o desubskrybcj
 *
 * - sesja - nasza sesja
 * - jid - identyfikator w @tlen.pl
 *
 */

int tlen_request_unsubscribe (struct tlen_session *sesja, const char *jid)
{
	char *query;
	if (!(query = (char *) malloc (strlen ("<presence to='' type='unsubscribe'/>") + strlen (jid) + 1)))
	{
		perror ("malloc");
	}
	sprintf (query, "<presence to='%s' type='unsubscribe'/>", jid);
	tlen_socket_write_string (sesja, query);
	free (query);
	return 1;
}

/*
 * tlen_accept_subcribe()
 *
 * Zgadza si na subskrybcj
 *
 * - sesja - nasza sesja
 * - jid - identyfikator w @tlen.pl
 *
 */

int tlen_accept_subscribe (struct tlen_session *sesja, const char *jid)
{
	char *query;

	if (!(query = (char *) malloc (strlen ("<presence to='' type='subscribed'/>") + strlen (jid) + 1)))
	{
		perror ("malloc");
	}
	sprintf (query, "<presence to='%s' type='subscribed'/>", jid);
	tlen_socket_write_string (sesja, query);
	tlen_debug ("Subscription from %s accepted.\n", jid);

	free (query);
	return 1;
}

/*
 * tlen_accept_unsubcribe()
 *
 * Zgadza si na desubskrybcj
 *
 * - sesja - nasza sesja
 * - jid - identyfikator w @tlen.pl
 *
 */

int tlen_accept_unsubscribe (struct tlen_session *sesja, const char *jid)
{
	char *query;

	if (!(query = (char *) malloc (strlen ("<presence to='' type='unsubscribed'/>") + strlen (jid) + 1)))
	{
		perror ("malloc");
	}
	sprintf (query, "<presence to='%s' type='unsubscribed'/>", jid);
	tlen_socket_write_string (sesja, query);
	tlen_debug ("%s unsubscribed.\n", jid);

	free (query);
	return 1;
}
