/*
 * Ostatnia aktualizacja:
 *
 * - $Id: events.c,v 1.86 2004/02/12 13:04:22 who_ami Exp $
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/ioctl.h>

#include "libtlen.h"

static char* bufferedtags[]={"iq","message","presence","n","w","m",NULL};  

/*
 * tlen_starttag_handler() 
 *
 * Handler wykonywany przy rozpoczciu tagu
 *
 * - userData - dane parsera
 * - name - nazwa obsugiwanego tagu
 * - atts - parametry w tagu
 *
 * Funkcja wewntrzna parsera zdarze
 *
 */

void tlen_starttag_handler(void *userData, const XML_Char *name, const XML_Char **atts)
{
  char* tag;
  char** tags=bufferedtags;
  struct tlen_session *sesja=(struct tlen_session*)userData;
  const XML_Char *s;

  sesja->nestlevel++;

  if (sesja->nestlevel==1)
  {
    if (strcmp(name,"s")==0)
    {
      while ((s=*atts++)!=NULL) {
        if (strcmp(s,"i")==0) {
          sesja->sid = strdup(*atts);
        }
        s=*atts++;
      }
      tlen_authorize(sesja);
      tlen_debug("Event: got id: %s\n",sesja->sid);
      return;
    }
  }

  while ((tag=*tags++)!=NULL) {
    if (strcmp(name,tag)==0) {
      if (sesja->buffering==0) {
        sesja->bufferpool=_pool_new("xmlbuffer");
        sesja->buffer=spool_new(sesja->bufferpool);
        XML_SetCharacterDataHandler(sesja->parser,tlen_char_handler);
      }
      sesja->buffering++;
    }
  }

  if (sesja->buffering) {
    spool_add(sesja->buffer,"<");
    spool_add(sesja->buffer,name);
    while ((s=*atts++)!=NULL) {
      spool_add(sesja->buffer," ");
      spool_add(sesja->buffer,s);
      spool_add(sesja->buffer,"='");
      s=*atts++;
      spool_add(sesja->buffer,strescape(sesja->bufferpool,s));
      spool_add(sesja->buffer,"'");
    }
    spool_add(sesja->buffer,">");
  }
}

/*
 * tlen_endtag_handler() 
 *
 * Handler wykonywany przy zakoczeniu tagu
 *
 * - userData - dane parsera
 * - name - nazwa obsugiwanego tagu
 *
 * Funkcja wewntrzna parsera zdarze
 *
 */

void tlen_endtag_handler (void *userData, const XML_Char *name)
{
  char* tag;
  char** tags=bufferedtags;
  struct tlen_session *sesja=(struct tlen_session*)userData;

  if (sesja->buffering) {
    spool_add(sesja->buffer,"</");
    spool_add(sesja->buffer,name);
    spool_add(sesja->buffer,">");
  }

  while ((tag=*tags++)!=NULL) {
    if (strcmp(name,tag)==0) {
      sesja->buffering--;
      if (sesja->buffering==0) {
        tlen_parsebuffer(sesja);
        pool_free(sesja->bufferpool);
        sesja->bufferpool=NULL;
        XML_SetCharacterDataHandler(sesja->parser,NULL);
      }
    }
  }

  sesja->nestlevel--;
}

/*
 * tlen_char_handler() 
 *
 * Buforuje otrzymywany tekst w celu otrzymania kompletnego tagu
 *
 * - userData - dane parsera
 * - s - tekst dodawany do bufora
 * - len - dugo tekstu
 *
 * Funkcja wewntrzna parsera zdarze
 *
 */

void tlen_char_handler (void *userData, const XML_Char *s, int len)
{
  struct tlen_session *sesja=(struct tlen_session*)userData;
  char* s2=malloc(len+1);
  len[(char*)memcpy(s2,s,len)]=0;
  spool_add(sesja->buffer,strescape(sesja->bufferpool,s2));
  free(s2);
}

/*
 * tlen_parsebuffer() 
 *
 * Parsuje jeden kompletny tag XML otrzymany od serwera
 *
 * - sesja - sesja, w ktrej obsugujemy ewentualne zdarzenia
 *
 * Funkcja wewntrzna parsera zdarze
 *
 */

void tlen_parsebuffer(struct tlen_session *sesja) {
  xmlnode parent;
  xmlnode root;
  struct tlen_event *e;
  char* buffer=spool_print(sesja->buffer);

  do root = parent = xmlstr2xmlnode(buffer); while (!(parent));

  if (!strcmp(xmlnode_get_name(parent),"iq"))
  {
    if (!strcmp(xmlnode_get_attrib(parent,"type"),"result"))
    {
      if (!(xmlnode_get_attrib(parent,"id")))
      {
        e = tlen_newevent(TLEN_EVENT_UNKNOWN);
        tlen_addevent(sesja,e);
      }
      else
      {
        // Otrzyamlisy potwierdzenie autoryzacji
        if (!strcmp(xmlnode_get_attrib(parent,"id"),sesja->sid))
        {
          tlen_debug("Event: Authorized\n");
          e = tlen_newevent(TLEN_EVENT_AUTHORIZED);
          tlen_addevent(sesja,e);
        }

        // Otrzymalismy potwierdzenie zmiany danych w naszym katalogu publicznym
	else if (!strcmp(xmlnode_get_attrib(parent,"id"),"tw"))
        {
          tlen_debug("Event: Pubdir data changed\n");
          e = tlen_newevent(TLEN_EVENT_PUBDIR_GOTUPDATEOK);
          tlen_addevent(sesja,e);
        }
    
        // Otrzymalismy wyniki wyszukiwania
	else if (!strcmp(xmlnode_get_attrib(parent,"id"),"src"))
	{
          struct tlen_pubdir *search;
          char *parameter;
          tlen_debug("Event: Got Search\n");

          parent = xmlnode_get_firstchild(parent);
          parent = xmlnode_get_firstchild(parent);

          if (parent) {
            do {
              if (!(search = (struct tlen_pubdir *)malloc(sizeof(*search))))
              {
                tlen_debug("Error: memory allocation");
                sesja->error = TLEN_ERROR_MALLOC; 
              }

              parameter = xmlnode_get_attrib(parent,"jid");
              if (parameter) { search->id = tlen_decode(parameter); } else { search->id = NULL; }
	      
	      if (xmlnode_get_tag(parent, "first")) { search->firstname = tlen_decode(xmlnode_get_data(xmlnode_get_tag(parent,"first"))); } else { search->firstname = NULL; }	      
	      if (xmlnode_get_tag(parent, "last")) { search->lastname = tlen_decode(xmlnode_get_data(xmlnode_get_tag(parent,"last"))); } else { search->lastname = NULL; }	      
	      if (xmlnode_get_tag(parent, "nick")) { search->nick = tlen_decode(xmlnode_get_data(xmlnode_get_tag(parent,"nick"))); } else { search->nick = NULL; }	      
	      if (xmlnode_get_tag(parent, "email")) { search->email = tlen_decode(xmlnode_get_data(xmlnode_get_tag(parent,"email"))); } else { search->email = NULL; }	      
	      if (xmlnode_get_tag(parent, "e")) { search->school = tlen_decode(xmlnode_get_data(xmlnode_get_tag(parent,"e"))); } else { search->school = NULL; }	      
	      if (xmlnode_get_tag(parent, "c")) { search->city = tlen_decode(xmlnode_get_data(xmlnode_get_tag(parent,"c"))); } else { search->city = NULL; }	      

	      if (xmlnode_get_tag(parent, "s")) { search->gender = atoi(xmlnode_get_data(xmlnode_get_tag(parent,"s"))); } else { search->gender = 1; }	      
	      if (xmlnode_get_tag(parent, "r")) { search->look_for = atoi(xmlnode_get_data(xmlnode_get_tag(parent,"r"))); } else { search->look_for = 0; }	      
	      if (xmlnode_get_tag(parent, "b")) { search->age = atoi(xmlnode_get_data(xmlnode_get_tag(parent,"b"))); } else { search->age = 0; }	      
	      if (xmlnode_get_tag(parent, "g")) { search->voice = atoi(xmlnode_get_data(xmlnode_get_tag(parent,"g"))); } else { search->voice = 0; }	      
	      if (xmlnode_get_tag(parent, "j")) { search->job = atoi(xmlnode_get_data(xmlnode_get_tag(parent,"j"))); } else { search->job = 0; }	      
	      if (xmlnode_get_tag(parent, "p")) { search->plans = atoi(xmlnode_get_data(xmlnode_get_tag(parent,"p"))); } else { search->plans = 0; }	      
	      if (xmlnode_get_tag(parent, "a")) { search->status = atoi(xmlnode_get_data(xmlnode_get_tag(parent,"a"))); } else { search->status = 0; }	      

              tlen_debug("Pozycja wyszukiwania:\n\nId: %s\nImie: %s\nNazwisko: %s\nNick: %s\nE-mail: %s\nSzkoa: %s\nMiasto: %s\nPlec: %d\nPoszukuje: %d\nWiek: %d\nGlos: %d\nZawd: %d\nPlany: %d\nStatus: %d\n-\n",search->id,search->firstname,search->lastname,search->nick,search->email,search->school,search->city,search->gender,search->look_for,search->age,search->voice,search->job,search->plans,search->status);

              e = tlen_newevent(TLEN_EVENT_GOTSEARCHITEM);
              e->pubdir = search;
              tlen_addevent(sesja,e);
            } while ((parent = xmlnode_get_nextsibling(parent)));
          }
          e = tlen_newevent(TLEN_EVENT_ENDSEARCH);
          tlen_addevent(sesja,e);
	}
	
        // Otrzymalismy nasze dane z katalogu publicznego
	else if ((!strcmp(xmlnode_get_attrib(parent,"id"),"tr")))
	{
          struct tlen_pubdir *pubdir;
          tlen_debug("Event: Got our pubdir data\n");

          parent = xmlnode_get_firstchild(parent);
          parent = xmlnode_get_tag(parent,"item");
          if (parent) {
              if (!(pubdir = (struct tlen_pubdir *)malloc(sizeof(*pubdir))))
              {
		tlen_debug("Error: memory allocation");
                sesja->error = TLEN_ERROR_MALLOC; 
              }

	      if (xmlnode_get_tag(parent, "first")) { pubdir->firstname = tlen_decode(xmlnode_get_data(xmlnode_get_tag(parent,"first"))); } else { pubdir->firstname = NULL; }	      
	      if (xmlnode_get_tag(parent, "last")) { pubdir->lastname = tlen_decode(xmlnode_get_data(xmlnode_get_tag(parent,"last"))); } else { pubdir->lastname = NULL; }	      
	      if (xmlnode_get_tag(parent, "nick")) { pubdir->nick = tlen_decode(xmlnode_get_data(xmlnode_get_tag(parent,"nick"))); } else { pubdir->nick = NULL; }	      
	      if (xmlnode_get_tag(parent, "email")) { pubdir->email = tlen_decode(xmlnode_get_data(xmlnode_get_tag(parent,"email"))); } else { pubdir->email = NULL; }	      
	      if (xmlnode_get_tag(parent, "e")) { pubdir->school = tlen_decode(xmlnode_get_data(xmlnode_get_tag(parent,"e"))); } else { pubdir->school = NULL; }	      
	      if (xmlnode_get_tag(parent, "c")) { pubdir->city = tlen_decode(xmlnode_get_data(xmlnode_get_tag(parent,"c"))); } else { pubdir->city = NULL; }	      

	      if (xmlnode_get_tag(parent, "s")) { pubdir->gender = atoi(xmlnode_get_data(xmlnode_get_tag(parent,"s"))); } else { pubdir->gender = 1; }	      
	      if (xmlnode_get_tag(parent, "r")) { pubdir->look_for = atoi(xmlnode_get_data(xmlnode_get_tag(parent,"r"))); } else { pubdir->look_for = 0; }	      
	      if (xmlnode_get_tag(parent, "b")) { pubdir->birthyear = atoi(xmlnode_get_data(xmlnode_get_tag(parent,"b"))); } else { pubdir->birthyear = 0; }	      
	      if (xmlnode_get_tag(parent, "g")) { pubdir->voice = atoi(xmlnode_get_data(xmlnode_get_tag(parent,"g"))); } else { pubdir->voice = 0; }	      
	      if (xmlnode_get_tag(parent, "j")) { pubdir->job = atoi(xmlnode_get_data(xmlnode_get_tag(parent,"j"))); } else { pubdir->job = 0; }	      
	      if (xmlnode_get_tag(parent, "p")) { pubdir->plans = atoi(xmlnode_get_data(xmlnode_get_tag(parent,"p"))); } else { pubdir->plans = 0; }	      
	      if (xmlnode_get_tag(parent, "a")) { pubdir->status = atoi(xmlnode_get_data(xmlnode_get_tag(parent,"a"))); } else { pubdir->status = 0; }	      
	      if (xmlnode_get_tag(parent, "v")) { pubdir->visible = atoi(xmlnode_get_data(xmlnode_get_tag(parent,"v"))); } else { pubdir->visible = 0; }	      

              tlen_debug("Nasze dane w katalogu:\n\nImie: %s\nNazwisko: %s\nNick: %s\nE-mail: %s\nSzkoa: %s\nMiasto: %s\nPlec: %d\nPoszukuje: %d\nRok urodzenia: %d\nGlos: %d\nZawd: %d\nPlany: %d\nStan widoczny: %d\n-\n",pubdir->firstname,pubdir->lastname,pubdir->nick,pubdir->email,pubdir->school,pubdir->city,pubdir->gender,pubdir->look_for,pubdir->birthyear,pubdir->voice,pubdir->job,pubdir->plans,pubdir->visible);

              e = tlen_newevent(TLEN_EVENT_PUBDIR_GOTDATA);
	      e->pubdir = pubdir;
    	      tlen_addevent(sesja,e);
          }
	}


	// Otrzymalismy ksike adresowa
        else if (!strcmp(xmlnode_get_attrib(parent,"id"),"GetRoster"))
        {
          struct tlen_user *user;
          char *parameter;

          parent = xmlnode_get_firstchild(parent);

          tlen_debug("Event: Got Roster\n");

          parent = xmlnode_get_firstchild (parent);

          if (parent) {
            do {
              if (!(user = (struct tlen_user *)malloc(sizeof(*user))))
              {
		tlen_debug("Error: memory allocation");
                sesja->error = TLEN_ERROR_MALLOC; 
              }

              parameter = xmlnode_get_attrib(parent,"name");
              if (parameter) { user->name = tlen_decode(parameter); } else { user->name = NULL; }

              parameter = xmlnode_get_attrib (parent, "jid");
              if (parameter) { tlen_stripresource(parameter); user->jid = tlen_decode(parameter); } else { user->jid = NULL; }

              parameter = xmlnode_get_attrib (parent, "subscription");
              if (parameter) { user->subscription = tlen_decode(parameter); } else { user->subscription = NULL; }

              parameter = xmlnode_get_attrib (parent, "ask");
              if (parameter)
              {
                user->ask = tlen_decode(parameter);
              }
              else
              {
                user->ask = NULL;
              }

              
              //FIXME - wlasciwie to dziala
              {
                xmlnode parent2;
                parent2 = xmlnode_get_firstchild(parent);
                parameter = xmlnode_get_data(parent2);
                if (parameter) { user->group = tlen_decode(parameter); } else { user->group = NULL; }
//                parent = xmlnode_get_parent(parent);
              }
              //FIXME

              tlen_debug("R: %s|%s|%s|%s|%s\n",user->name,user->jid,
                         user->subscription,user->group, user->ask);

              e = tlen_newevent(TLEN_EVENT_GOTROSTERITEM);
              e->roster = user;
              tlen_addevent(sesja,e);
            } while ((parent = xmlnode_get_nextsibling(parent)));
          }
          e = tlen_newevent(TLEN_EVENT_ENDROSTER);
          tlen_addevent(sesja,e);
        }
      }
    }

    // Autoryzacja si nie powioda
    else if (!strcmp(xmlnode_get_attrib(parent,"type"),"error"))
    {
      if (!strcmp(xmlnode_get_attrib(parent,"id"),sesja->sid))
      {
        tlen_debug("Error: Unauthorized\n");
        sesja->error=TLEN_ERROR_UNAUTHORIZED;
      }
    }
  }
  else if (!strcmp(xmlnode_get_name(parent),"message")) 
  { 
    char *parameter;
    char *from;
    char *type;
    char *body;
    char *stamp;
    xmlnode child;

    struct tlen_message *message;

    parameter = xmlnode_get_attrib(parent,"from");
    if (parameter) { tlen_stripresource(parameter); from = tlen_decode(parameter); } else { from = NULL; }
    parameter = xmlnode_get_attrib(parent,"type");
    if (parameter) { type = tlen_decode(parameter); }
    else
    {
      type = strdup("message");
    }
    child=xmlnode_get_tag(parent, "x");
    stamp=NULL;
    if(child)
    {
      parameter=xmlnode_get_attrib(child,"xmlns");
      if (parameter)
      {
        if(!strcmp(parameter,"jabber:x:delay"))
        {
          parameter=xmlnode_get_attrib(child,"stamp");
          stamp=strdup(parameter);
        }
      }
    }
    child = xmlnode_get_tag(parent, "body");
    parameter = xmlnode_get_data(child);
    if (parameter) { body = tlen_decode(parameter); } else { body = NULL; }    

    if (!strcmp(from, "b73@tlen.pl"))
    {
	xmlnode advert;
	struct tlen_advert *tlenadvert;
	char *url;
	char *name;
	int width, height;
	
	advert = xmlstr2xmlnode(body);
	
	child = xmlnode_get_tag(advert, "u");
	parameter = xmlnode_get_data(child);
	if (parameter) { url = strdup(parameter); } else { url = NULL; }
	child = xmlnode_get_tag(advert, "c");
	parameter = xmlnode_get_data(child);
	if (parameter) { name = strdup(parameter); } else { name = NULL; }
	child = xmlnode_get_tag(advert, "w");
	parameter = xmlnode_get_data(child);
	if (parameter) { width = atoi(parameter); } else { width = 0; }
	child = xmlnode_get_tag(advert, "h");
	parameter = xmlnode_get_data(child);
	if (parameter) { height = atoi(parameter); } else { height = 0; }

	tlen_debug("Event: advert from %s at %s. Width: %d, height: %d\n", name, url, width, height);
	
	if (!(tlenadvert = (struct tlen_advert*)malloc(sizeof(*tlenadvert)))) { sesja->error = TLEN_ERROR_MALLOC; }
	tlenadvert->url = url;
	tlenadvert->name = name;
	tlenadvert->width = width;
	tlenadvert->height = height;
	
	e = tlen_newevent(TLEN_EVENT_ADVERT);
	e->advert = tlenadvert;
	tlen_addevent(sesja,e);
    }
    else
    {
        tlen_debug("Event: message from %s with body: %s, type: %s\n",from,body,type); 

	if (!(message = (struct tlen_message*)malloc(sizeof(*message)))) { 	sesja->error = TLEN_ERROR_MALLOC; }
	message[0].from = from;
        message[0].body = body;
	message[0].stamp = stamp;
	if (!strcmp(type,"normal")) { message[0].type = TLEN_MESSAGE; } else { message[0].type = TLEN_CHAT; }
	free(type);

	e = tlen_newevent(TLEN_EVENT_MESSAGE);
	e->message = message;
	tlen_addevent(sesja,e);
    }
  }
  else if (!strcmp(xmlnode_get_name(parent),"presence")) 
  { 
    char *parameter;
    char *from;
    char *charstatus;
    int status=0;
    char *description;
    xmlnode child;

    struct tlen_presence *presence;

    e = tlen_newevent(TLEN_EVENT_PRESENCE);

    if ((xmlnode_get_attrib(parent,"type")))
    {
      if ((!strcmp(xmlnode_get_attrib(parent,"type"),"subscribe"))&&(!(!strcmp(xmlnode_get_attrib(parent,"type"),"unsubscribe")))&&(!(!strcmp(xmlnode_get_attrib(parent,"type"),"d")))) 
      {
        struct tlen_subscription *subscribe;
        if (!(subscribe = (struct tlen_subscription*)malloc(sizeof(*subscribe)))) { tlen_debug("Error: memory allocation"); sesja->error = TLEN_ERROR_MALLOC; }
        tlen_debug("Event: subscription request from %s\n",xmlnode_get_attrib(parent,"from"));
        subscribe->jid = strdup(xmlnode_get_attrib(parent,"from"));
        tlen_stripresource(subscribe->jid); 

        e->type = TLEN_EVENT_SUBSCRIBE;
        e->subscribe = subscribe;
      }
      else if (!strcmp(xmlnode_get_attrib(parent,"type"),"unsubscribe")&&(!(!strcmp(xmlnode_get_attrib(parent,"type"),"d")))) 
      {
        struct tlen_subscription *subscribe;
        if (!(subscribe = (struct tlen_subscription*)malloc(sizeof(*subscribe)))) { tlen_debug("Error: memory allocation"); sesja->error = TLEN_ERROR_MALLOC; }
        tlen_debug("Event: unsubscription request from %s\n",xmlnode_get_attrib(parent,"from"));
        subscribe->jid = strdup(xmlnode_get_attrib(parent,"from"));
        tlen_stripresource(subscribe->jid); 

        e->type = TLEN_EVENT_UNSUBSCRIBE;
        e->subscribe = subscribe;
      }
      else if (!strcmp(xmlnode_get_attrib(parent,"type"),"subscribed"))
      {
        struct tlen_subscription *subscribe;
        if (!(subscribe = (struct tlen_subscription*)malloc(sizeof(*subscribe)))) { tlen_debug("Error: memory allocation"); sesja->error = TLEN_ERROR_MALLOC; }
        tlen_debug("Event: subscription accepted by %s\n",xmlnode_get_attrib(parent,"from"));
        subscribe->jid = strdup(xmlnode_get_attrib(parent,"from"));
        tlen_stripresource(subscribe->jid); 

        e->type = TLEN_EVENT_SUBSCRIBED;
        e->subscribe = subscribe;
      }
      else if (!strcmp(xmlnode_get_attrib(parent,"type"),"unsubscribed"))
      {
        struct tlen_subscription *subscribe;
        if (!(subscribe = (struct tlen_subscription*)malloc(sizeof(*subscribe)))) { tlen_debug("Error: memory allocation"); sesja->error = TLEN_ERROR_MALLOC; }
        tlen_debug("Event: unsubscription accepted by %s\n",xmlnode_get_attrib(parent,"from"));
        subscribe->jid = strdup(xmlnode_get_attrib(parent,"from"));
        tlen_stripresource(subscribe->jid); 

        e->type = TLEN_EVENT_UNSUBSCRIBED;
        e->subscribe = subscribe;
      }
    }

    if (!(presence = (struct tlen_presence*)malloc(sizeof(*presence)))) { tlen_debug("Error: memory allocation");sesja->error = TLEN_ERROR_MALLOC; }

    parameter = xmlnode_get_attrib(parent,"from");
    if (parameter) { tlen_stripresource(parameter); from = tlen_decode(parameter); } else { from = NULL; }
    child = xmlnode_get_tag(parent, "show");
    parameter = xmlnode_get_data(child);
    if (parameter) { charstatus = tlen_decode(parameter); } else { charstatus = NULL; }    
    child = xmlnode_get_tag(parent, "status");
    parameter = xmlnode_get_data(child);
    if (parameter) { description = tlen_decode(parameter); } else { description = NULL; }    

    if (charstatus == NULL) 
    {
      if (!(xmlnode_get_attrib(parent,"type")))
      {
        charstatus = strdup("available"); 
      }
      else
      {
        charstatus = strdup("unavailable");
      }
    }

    if ((!strcmp(charstatus,"available"))&&(!!strcmp(charstatus,"unavailable"))) { status = TLEN_STATUS_AVAILABLE; }
    if (!strcmp(charstatus,"unavailable")) { status = TLEN_STATUS_UNAVAILABLE; }
    if (!strcmp(charstatus,"away")) { status = TLEN_STATUS_AWAY; }
    if (!strcmp(charstatus,"chat")) { status = TLEN_STATUS_CHATTY; }
    if (!strcmp(charstatus,"xa")) { status = TLEN_STATUS_EXT_AWAY; }
    if (!strcmp(charstatus,"dnd")) { status = TLEN_STATUS_DND; }
    if (!strcmp(charstatus,"invisible")) { status = TLEN_STATUS_INVISIBLE; }
    if (!strcmp(charstatus,"online")) { status = TLEN_STATUS_AVAILABLE; }


    presence[0].from = from;
    presence[0].status = status;
    presence[0].description = description;

    tlen_debug("Event: presence from %s with status: %s, and description: %s (int: %d)\n",from,charstatus,description,status); 

    e->presence = presence;
    tlen_addevent(sesja,e);
  }
  else if (!strcmp(xmlnode_get_name(parent),"n"))
  {
    char *parameter;
    char *from;
    char *subject;

    struct tlen_newmail *newmail;

    e = tlen_newevent(TLEN_EVENT_NEWMAIL);
    parameter = xmlnode_get_attrib(parent,"f");
    from = tlen_decode(parameter);
    parameter = xmlnode_get_attrib(parent,"s");
    subject = tlen_decode(parameter);

    if (!(newmail = (struct
                     tlen_newmail*)malloc(sizeof(*newmail))))
    {
      tlen_debug("Error: memory allocation");  
      sesja->error = TLEN_ERROR_MALLOC;
    }
    newmail->from = from;
    newmail->subject = subject;
    e->newmail = newmail;

    tlen_debug("Event: newmail from %s with subject %s\n",from,
               subject);
    tlen_addevent(sesja,e);
  }
  else if (!strcmp(xmlnode_get_name(parent),"m"))
  {
    char *parameter;
    char *from;
    char *to;
    char *type;

    struct tlen_notify *notify;

    e = tlen_newevent(TLEN_EVENT_NOTIFY);
    parameter = xmlnode_get_attrib(parent,"f");
    from = tlen_decode(parameter);
    parameter = xmlnode_get_attrib(parent,"to");
    to = tlen_decode(parameter);
    parameter = xmlnode_get_attrib(parent,"tp");
    type = tlen_decode(parameter);

    if (!(notify = (struct
                     tlen_notify*)malloc(sizeof(*notify))))
    {
      tlen_debug("Error: memory allocation");  
      sesja->error = TLEN_ERROR_MALLOC;
    }
    notify->from = from;
    notify->to = to;
    
    if (type)
    {
      if (!strcmp(type,"t"))
      {
        notify->type = TLEN_NOTIFY_TYPING;;
        e->notify = notify;
        tlen_debug("Event: %s is now typing\n",from);
      }
      else if (!strcmp(type,"u"))
      {
        notify->type = TLEN_NOTIFY_NOTTYPING;
        e->notify = notify;
        tlen_debug("Event: %s is not typing - idle for 30s\n",from);
      }
      else if (!strcmp(type,"a"))
      {
        notify->type = TLEN_NOTIFY_SOUNDALERT;
        e->notify = notify;
        tlen_debug("Event: %s sent you a sound alert\n",from);
      }
    }
    tlen_addevent(sesja,e);
  }
  else if (!strcmp(xmlnode_get_name(parent),"w"))
  {
    char *parameter;
    char *from;
    char *email;
    char *site;
    char *body;

    struct tlen_webmsg *webmsg;

    e = tlen_newevent(TLEN_EVENT_WEBMSG);
    parameter = xmlnode_get_attrib(parent,"f");
    from = tlen_decode(parameter);
    parameter = xmlnode_get_attrib(parent,"e");
    email = tlen_decode(parameter);
    parameter = xmlnode_get_attrib(parent,"s");
    site = tlen_decode(parameter);
    parameter = xmlnode_get_data(parent);
    body = tlen_decode(parameter);

    if (!(webmsg = (struct
                     tlen_webmsg*)malloc(sizeof(*webmsg))))
    {
      tlen_debug("Error: memory allocation");
      sesja->error = TLEN_ERROR_MALLOC;
    }
    webmsg->from=from;
    webmsg->email=email;
    webmsg->site=site;
    webmsg->body=body;
    e->webmsg=webmsg;

    tlen_debug("Event: webmsg from %s (%s) sent from http://%s with body: %s\n",
               from, email, site, body);
    tlen_addevent(sesja,e);
  }
  xmlnode_free(root);
}

/*
 * tlen_addevent() 
 *
 * Dodaje zdarzenie do kolejki zdarze
 *
 * - sesja - sesja, do ktrej kolejki dodajemy
 * - e - zdarzenie
 *
 * Funkcja wewntrzna parsera zdarze
 *
 */

void tlen_addevent(struct tlen_session *sesja, struct tlen_event *e)
{
  struct tlen_event* e_ptr=sesja->event;
  if (e_ptr) {
    while (e_ptr->next_event) e_ptr=e_ptr->next_event;
    e_ptr->next_event=e;
  } else sesja->event=e;
}

/*
 * tlen_getevent() 
 *
 * Pobiera kolejne (jeeli istnieje) zdarzenie z kolejki
 *
 * - sesja - sesja, ktrej zdarzenia obsugujemy
 *
 * Zwraca zdarzenie, lub NULL jeeli nie ma wicej
 *
 */

struct tlen_event* tlen_getevent(struct tlen_session *sesja)
{
  struct tlen_event* e_ptr=sesja->event;
  if (e_ptr) sesja->event=e_ptr->next_event;
  return e_ptr;
}

/*
 * tlen_newevent() 
 *
 * Tworzy nowe zdarzenie
 *
 * - type - typ zdarzenia
 *
 * Zwraca zaalokowan struktur zdarzenia
 * Funkcja wewntrzna parsera zdarze
 *
 */

struct tlen_event* tlen_newevent(int type)
{
  struct tlen_event* e = calloc(1, sizeof (struct tlen_event));
  if (e) e->type = type;
  return e;
}

/*
 * tlen_freeevent() 
 *
 * Zwalnia pami po zdarzeniu
 *
 * - e - zdarzenie
 *
 * Wewntrzna funkcja parsowania zdarze
 *
 */

void tlen_freeevent(struct tlen_event *e)
{
  if (e) {
    if (e->presence) {
      struct tlen_presence* p=e->presence;
      free(p->from);
      free(p->description);
      free(p);
    }
    if (e->message) {
      free(e->message->from);
      free(e->message->body);
      if(e->message->stamp)
        free(e->message->stamp);
      free(e->message);
    }
    if (e->subscribe) {
      free(e->subscribe->jid);
      free(e->subscribe);
    }
    if (e->roster) {
      struct tlen_user* u=e->roster;
      free(u->name);
      free(u->jid);
      free(u->group);
      free(u->subscription);
      free(u);
    }
    if (e->newmail) {
      struct tlen_newmail *n=e->newmail;
      free(n->from);
      free(n->subject);
      free(n);
    }
    if (e->webmsg) {
      struct tlen_webmsg *n=e->webmsg;
      free(n->from);
      free(n->email);
      free(n->site);
      free(n->body);
      free(n);
    }
    if (e->pubdir) {
      struct tlen_pubdir *n=e->pubdir;
      free(n->firstname);
      free(n->lastname);
      free(n->nick);
      free(n->city);
      free(n->email);
      free(n->school);
      free(n);
    }
    if (e->advert) {
      struct tlen_advert *n=e->advert;
      free(n->name);
      free(n->url);
      free(n);
    }
    if (e->notify) {
      struct tlen_notify *n=e->notify;
      free(n->from);
      free(n->to);
      free(n);
    }
    free(e);
  }
  tlen_debug("Event freed\n");
}

/*
 * tlen_watch_fd()
 *
 * funkcja sprawdzajca socket w poszukiwaniu jakiego 
 * zdarzenia
 *
 * - sesja - nasza sesja
 *
 * Podczas bdw ustawia sesja->error i potrafi nawet rozczy gniazdo!
 *
 */

void tlen_watch_fd (struct tlen_session *sesja)
{
  if (!sesja) return;

  switch (sesja->state)
  {
    case TLEN_STATE_CONNECTING_HUB:
      {
        int len, port, res_cr=0;
        char addr[INET_ADDRSTRLEN];
        if (read(sesja->fd, &len, sizeof(len))==sizeof(len))
        {
          if (len>0)
          {
            if (read(sesja->fd, addr, len) == len) 
            {
              addr[len]='\0';
              if (read(sesja->fd, &port, sizeof(port))==sizeof(port))
              {
		tlen_socket_destroy (sesja);
                if ((sesja->fd = tlen_socket_create (addr, port)) == -1) {
                  tlen_debug ("Estabilishing connection to %s failed !\n", addr);
                  sesja->error=TLEN_ERROR_NETWORK;
                } else {
                  sesja->state = TLEN_STATE_CONNECTING;
                  sesja->check = TLEN_CHECK_WRITE;
                }
              } else res_cr=1;
            } else res_cr=1;
          } else {
            tlen_debug ("Finding Tlen host(s) failed, check your DNS !\n");
            tlen_socket_destroy(sesja);
            sesja->error=TLEN_ERROR_NETWORK;
          }
        } else res_cr=1;
        
        if (res_cr) {
          tlen_socket_destroy (sesja);
          tlen_debug ("Resolver process crashed ?\n", TLEN_HUB);
          sesja->error=TLEN_ERROR_OTHER;
        }
        waitpid(sesja->resolv_pid,NULL,0);
	sesja->resolv_pid = 0;

        break;
      }
    case TLEN_STATE_CONNECTING:
      {
        int res, res_size = sizeof (res);

        if ((getsockopt
             (sesja->fd, SOL_SOCKET, SO_ERROR, &res, &res_size)
             || res))
        {
          tlen_socket_destroy (sesja);
          tlen_debug("Error: connection failed");
	  sesja->error=TLEN_ERROR_NETWORK;
          return;
        }

        sesja->state = TLEN_STATE_CONNECTED;
        sesja->check = TLEN_CHECK_READ;

        tlen_debug ("Event: Connected.\n");

	tlen_getid(sesja);

        break;
      }	
    case TLEN_STATE_CONNECTED:
      {
        char response[1025];
        int amount;

	// Zapis tego, co czeka na zapisanie
	if (sesja->check & TLEN_CHECK_WRITE) tlen_socket_write (sesja, NULL, 0);

	// Odczyt
      	amount=read (sesja->fd, response, 1024);
        if (amount==-1) 
        {
          if (errno == EAGAIN) 
          {
            break; // Nie ma nic do odczytania
          } else {
            tlen_socket_destroy(sesja);
            tlen_debug("Error: Socket read error\n");
            sesja->error=TLEN_ERROR_NETWORK;
          }
        }
        else if (amount==0)
        {
          tlen_socket_destroy(sesja);
          tlen_debug("Error: connection failed");
	  sesja->error=TLEN_ERROR_NETWORK;
        }
        else
        {
	  response[amount] = 0;
          tlen_debug ("Dane: %s\n", response);
          if (!XML_Parse(sesja->parser,response,strlen(response),0))
          {
            tlen_socket_destroy(sesja);
            tlen_debug("Error: Malformed XML received !\n");
            sesja->error=TLEN_ERROR_BADRESPONSE;
          }
        }
        break;
      }
  }
}

