#ifndef TAGCOLL_FILTERCHAIN_H
#define TAGCOLL_FILTERCHAIN_H

/*
 * Chain more TagcollFilters together
 * 
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#pragma interface

#include <tagcoll/TagcollConsumer.h>
#include <tagcoll/TagcollFilter.h>

namespace Tagcoll
{

// Tagcoll consumer that builds a chain of filters with a final consumer
template<class ITEM, class TAG>
class FilterChain : public TagcollConsumer<ITEM, TAG>
{
protected:
	TagcollConsumer<ITEM, TAG>* consumer;
	TagcollFilter<ITEM, TAG>* last;

public:
	FilterChain<ITEM, TAG>() throw () : consumer(0), last(0) {}

	// Set the consumer at the end of the chain
	void setConsumer(TagcollConsumer<ITEM, TAG>* c) throw ();

	// Add a filter at the end of the chain
	void appendFilter(TagcollFilter<ITEM, TAG>* f) throw ();

	// Delete the filters in the chain (but not the consumer at the end)
	// This is a convenience method, since the FilterChain destructor does not
	// delete the filters in the chain
	void deleteFilters() throw ();

	// Consume data to be filtered
	virtual void consume(const ITEM& item) throw ();
	virtual void consume(const ITEM& item, const OpSet<TAG>& tags) throw ();
	virtual void consume(const OpSet<ITEM>& items) throw ();
	virtual void consume(const OpSet<ITEM>& items, const OpSet<TAG>& tags) throw ();
};

};

// vim:set ts=4 sw=4:
#endif
