/*
 * Base class for parsers
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#pragma implementation

#include "ParserBase.h"
#include "stringf.h"
#include <string>

using namespace std;
using namespace stringf;

ParserException::ParserException(const ParserInput& input, const std::string& message) throw ()
	: ContextException(message), _file(input.fileName()), _line(input.lineNumber()) {}


string ParserException::desc() const throw ()
{
	if (_file.size() > 0)
		if (_line != -1)
			return _file + ":" + fmt(_line) + ": " + _context;
		else
			return _file + ":" + _context;
	else
		if (_line != -1)
			return fmt(_line) + ": " + _context;
		else
			return _context;
}

// vim:set ts=4 sw=4:
