#ifndef _SPFMILTER_H
#define _SPFMILTER_H 1

#ifdef HAVE_CONFIG_H
#include "../../config.h"
#else
#include "port.h"
#endif

#ifdef STDC_HEADERS
#include <stdio.h>
#include <stdlib.h>
#include <syslog.h>
#include <errno.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#ifdef HAVE_STRING_H
# include <string.h>
#else
# ifdef HAVE_STRINGS_H
#  include <strings.h>
# endif
#endif

#ifdef HAVE_PWD_H
#include <pwd.h>
#endif

#ifdef HAVE_GRP_H
#include <grp.h>
#endif

#ifdef HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif

#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif

#ifdef HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

#ifdef HAVE_ARPA_INET_H
#include <arpa/inet.h>
#endif

#ifdef HAVE_GETOPT_H
#include <getopt.h>
#endif

#include <pthread.h>

#include <libmilter/mfapi.h>

#include "version.h"
#include "match.h"
#include "iparray.h"

#include "../../src/libspf/spf.h" 

#ifdef  HAVE__BEGIN_DECLS
__BEGIN_DECLS
#else
# ifdef __cplusplus
extern "C" {
# endif /* __cplusplus */
#endif /* HAVE__BEGIN_DECLS */

#define DOC_LONGOPT(l, v, t, p1) \
  do \
  { \
    (void) fprintf( stderr, "    --%s%c%s%*s" t "\n", l, (v ? '=' : ' '), \
      (v ? v: ""), p1, "" ); \
  } while(0)
#else
#define DOC_LONGOPT(l, v, t, p1) do { } while( 0 )
#endif

const char *shortopts = "l:tg:f:w:re:mu:p:Xhd::";

#define DOC_OPT(s, l, v, t, p0, p1) \
  do \
  { \
    (void) fprintf( stderr, "    -%c%c%s%*s" t "\n", s, (v ? ' ' : ' '), \
      (v ? v : ""), p0, "" ); \
    DOC_LONGOPT(l, v, t, p1); \
  } while(0)

/* Defines. */
#define HEADER_NAME "Received-SPF"
#define SPFMILTER_RESULT_PASS 0
#define SPFMILTER_RESULT_FAIL 1
#define SPFMILTER_RESULT_SOFTFAIL 2
#define SPFMILTER_RESULT_NEUTRAL 3
#define SPFMILTER_RESULT_UNKNOWN 4
#define SPFMILTER_RESULT_UNMECH 5
#define SPFMILTER_RESULT_ERROR 6
#define SPFMILTER_RESULT_NONE 7
#define SPFMILTER_ACTION_UNKNOWN 0
#define SPFMILTER_ACTION_REJECT 1
#define SPFMILTER_ACTION_MARK 2
#define SPFMILTER_ACTION_TEMPFAIL 3

/* Structs. */

/* Fallback list. */
struct lib_fallback_s;
typedef struct lib_fallback_s lib_fallback_t;
typedef struct fallback_s
{
  const char* pattern;
  const char* str;
  lib_fallback_t* lib_fallback;
} fallback_t;
fallback_t* fallbacks;
int max_fallbacks, num_fallbacks;


/* Per-connection data structure. */
#define DEL_HEADER_MAX 10
struct lib_data_s;
typedef struct lib_data_s lib_data_t;
typedef struct connection_data_s
{
  int whitelisted;
  int authenticated;
  const char* ip_str;
  const char* helo;
  const char* from;
  lib_data_t* lib_data;
  int result;
  int action;
  int n_spf_headers;
  int n_del_headers;
  int del_header_list[DEL_HEADER_MAX];
} connection_data_t;


/* Forwards. */
void usage(void);
void init_fallback(const char* fallback_filename, const char* guess_str);
void add_fallback(const char *pattern, const char *str);
void fini_fallback(void);
int find_fallback(const char *from);
void init_whitelist(const char *whitelist_filename);
void fini_whitelist(void);
void trim(char *str);
void init_uid(const char *user);
void init_socket(const char *sockpath);
void fini_socket(const char *sockpath);
void unlink_socket(const char *sockpath);
void init_daemon(void);
void init_pidfile(const char *pidfile);
void fini_pidfile(const char *pidfile);

/*
*  The milter calback routines.
*  Signatures for these are fixed by the milter API
*/
sfsistat spf_connect(SMFICTX *ctx, char *connhost,
 _SOCK_ADDR *connaddr);
sfsistat spf_helo(SMFICTX *ctx, char *helohost);
sfsistat spf_envfrom(SMFICTX *ctx, char **fromargs);
sfsistat spf_envrcpt(SMFICTX *ctx, char **rcptargs);
sfsistat spf_header(SMFICTX *ctx, char *name, char *value);
sfsistat spf_eoh(SMFICTX *ctx);
sfsistat spf_eom(SMFICTX *ctx);
sfsistat spf_abort(SMFICTX *ctx);
sfsistat spf_close(SMFICTX *ctx);

sfsistat handle_result(SMFICTX *ctx);
void escape_percents(const char *in, char *out, int out_size);
int receiver_is_me(const char *value);
void build_header(connection_data_t* cd, char* header, int header_size,
  const char *reason);
connection_data_t *init_connection_data(void);
int init_message_data(connection_data_t *cd);
void fini_message_data(connection_data_t *cd);
void fini_connection_data(connection_data_t *cd);
char * result_str(int result);

/* Library interface routines. */
int lib_init(void);
lib_fallback_t *lib_init_fallback(const char *str);
int lib_set_local_hostname(lib_data_t *ld);
lib_data_t *lib_init_connection_data(void);
int lib_init_message_data(lib_data_t *ld);
int lib_set_ipv4(lib_data_t *ld, struct in_addr ipv4_addr,
  char *ipv4_str);
int lib_set_ipv6(lib_data_t *ld, struct in6_addr ipv6_addr,
  char *ipv6_str);
int lib_set_helo_hostname(lib_data_t *ld, char *helo_hostname);
int lib_set_from(lib_data_t *ld, const char *from);
int lib_do_check(lib_data_t *ld, const char *from);
int lib_do_check_recipient(lib_data_t *ld, const char *to);
int lib_do_check_final(lib_data_t *ld);
int lib_get_result(lib_data_t *ld);
const char *lib_get_reason(lib_data_t *ld);
const char *lib_get_explanation(lib_data_t *ld);
const char *lib_get_error(lib_data_t *ld);
void lib_fini_message_data(lib_data_t *ld);
void lib_fini_connection_data(lib_data_t *ld);
void lib_fini_fallback(lib_fallback_t *lf);
void lib_fini(void);


/* Globals. */
int recipientmx;

int debug;
int markonly;
int header_name_len;
int trustedforwarders;
int local_hostname_len;

char *argv0;
char *localpolicy_str;
char *explanation_str;
char *local_hostname;

iparray whitelist;

struct smfiDesc smfilter =
{
  "SPF",                        /* filter name */
  SMFI_VERSION,                 /* version code -- do not change */
  SMFIF_CHGHDRS|SMFIF_ADDHDRS,  /* flags */
  spf_connect,                  /* connection info filter */
  spf_helo,                     /* SMTP HELO command filter */
  spf_envfrom,                  /* envelope sender filter */
  spf_envrcpt,                  /* envelope recipient filter */
  spf_header,                   /* header filter */
  spf_eoh,                      /* end of header */
  NULL,                         /* body block filter */
  spf_eom,                      /* end of message */
  spf_abort,                    /* message aborted */
  spf_close                     /* connection cleanup */
};

#ifdef HAVE_GETOPT_LONG
const struct option  longopts[] =
{
  { "localpolicy",        required_argument,  NULL, 'l', },
  { "trustedforwarders",  no_argument,        NULL, 't', },
  { "guess",              required_argument,  NULL, 'g', },
  { "fallback",           required_argument,  NULL, 'f', },
  { "whitelist",          required_argument,  NULL, 'w', },
  { "recipientmx",        no_argument,        NULL, 'r', },
  { "explanation",        required_argument,  NULL, 'e', },
  { "markonly",           no_argument,        NULL, 'm', },
  { "user",               required_argument,  NULL, 'u', },
  { "pidfile",            required_argument,  NULL, 'p', },
  { "nodaemon",           no_argument,        NULL, 'X', },
  { "help",               no_argument,        NULL, 'h', },
  { "debug",              optional_argument,  NULL, 'd', },
  { 0,                    0,                  0,    0    },
};


#ifdef  HAVE__BEGIN_DECLS
__END_DECLS
#else
# ifdef __cplusplus
}
# endif /* __cplusplus */
#endif /* HAVE__BEGIN_DECLS */

#endif /* _SPFMILTER_H */

/* end spfmilter.h */
