# we don't currently package all files under buildroot. This is required so
# rpm doesn't complain.
%define _unpackaged_files_terminate_build	0

# automatically determine if we should build xml
%define build_xml %( ([ -e /usr/include/xercesc/ ] && echo 1) || echo 0 )

# automatically determine if we should build docs
%define build_docs %( ( which doxygen > /dev/null 2>&1 && echo 1) || echo 0 )

# build rpm containing everything statically linked
%define build_static 0

# build bios update tools rpm
%define build_butrpm 0

# allow --with[out] <feature> at rpm command line build, to override the above
# e.g. --with xml    ...or...   --without xml 
%{?_without_xml: %{expand: %%define build_xml 0}}
%{?_with_xml: %{expand: %%define build_xml 1}}
%{?_without_static: %{expand: %%define build_static 0}}
%{?_with_static: %{expand: %%define build_static 1}}
%{?_without_docs: %{expand: %%define build_docs 0}}
%{?_with_docs: %{expand: %%define build_docs 1}}
%{?_without_butrpm: %{expand: %%define build_butrpm 0}}
%{?_with_butrpm: %{expand: %%define build_butrpm 1}}

# if passed a "dist" variable, use it. Otherwise, not.
%{!?dist: %{expand: %%define relver 1}}
%{?dist:  %{expand: %%define relver 1.%{dist}}}

Name: libsmbios
Version: 0.10.6
Release: %{relver}
License: Dell Proprietary
Packager: Michael E Brown <Michael_E_Brown@dell.com>
Source: libsmbios-0.10.6.tar.bz2
Summary: Open BIOS parsing libs
Group: Applications/Libraries
Buildroot: %{_tmppath}/libsmbios

%description
Libsmbios is a library and utilites that can be used by client programs 
to get information from standard BIOS tables, such as the SMBIOS table.

%package -n bios_update_tools
Summary: Scripts to manage firmware updates
Group: Applications/Binaries
Requires: libsmbios-bin

%package libs
Summary: Libsmbios shared libraries.
Group: Applications/Libraries

%package -n libsmbiosxml-libs
Summary: Libsmbiosxml shared libraries.
Group: Applications/Libraries

%package bin
Summary: The "supported" sample binaries that use libsmbios
Group: Applications/Binaries

%package unsupported-bin
Summary: Unsupported sample binaries using libsmbios
Group: Applications/Binaries

%package -n libsmbiosxml-bin
Summary: sample binaries that use libsmbiosxml
Group: Applications/Binaries

%package devel
Summary: development headers and archives
Group: Applications/Development

%package static
Summary: All of the libsmbios binaries that can be statically built
Group: Applications/Binaries

%description -n bios_update_tools
Scripts and tools to manage firmware and BIOS updates.

%description libs
Libsmbios is a library and utilites that can be used by client programs 
to get information from standard BIOS tables, such as the SMBIOS table.

%description -n libsmbiosxml-libs
Libsmbios is a library and utilites that can be used by client programs 
to get information from standard BIOS tables, such as the SMBIOS table.

%description devel
Libsmbios is a library and utilites that can be used by client programs 
to get information from standard BIOS tables, such as the SMBIOS table.

This package contains the headers and .a files necessary to compile new 
client programs against libsmbios

%description bin
Libsmbios is a library and utilites that can be used by client programs 
to get information from standard BIOS tables, such as the SMBIOS table.

This package contains some sample binaries that use libsmbios.

%description unsupported-bin
Libsmbios is a library and utilites that can be used by client programs 
to get information from standard BIOS tables, such as the SMBIOS table.

This package contains some sample binaries that use libsmbios.

%description -n libsmbiosxml-bin
Libsmbios is a library and utilites that can be used by client programs 
to get information from standard BIOS tables, such as the SMBIOS table.

This package contains some sample binaries that use libsmbios.

%description static
Libsmbios is a library and utilites that can be used by client programs 
to get information from standard BIOS tables, such as the SMBIOS table.

This package contains some sample binaries that use libsmbios.

%prep
%setup 

%build
make default
%if %{build_static}
    make static
%endif
%if %{build_xml}
    make xml
%endif
%if %{build_docs}
    make doxygen
%endif

%install
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf ${RPM_BUILD_ROOT}
install -d -m 755 $RPM_BUILD_ROOT/%{_bindir}  $RPM_BUILD_ROOT/%{_libdir} $RPM_BUILD_ROOT/usr/include/ $RPM_BUILD_ROOT/%{_sysconfdir} $RPM_BUILD_ROOT/%{_sysconfdir}/rc.d/init.d/

install -D -m 555 supported-bins/output/* $RPM_BUILD_ROOT/%{_bindir}
install -D -m 555 bins/output/* $RPM_BUILD_ROOT/%{_bindir}

cp    lib/libsmbios*  $RPM_BUILD_ROOT/%{_libdir}/
cp -a include/smbios  $RPM_BUILD_ROOT/usr/include/

install -D -m 555 build/bios_update_tools/bios_update.conf   $RPM_BUILD_ROOT/%{_sysconfdir}/bios_update/bios_update.conf
install -D -m 555 build/bios_update_tools/bios_update_check $RPM_BUILD_ROOT/%{_sysconfdir}/rc.d/init.d/bios_update_check
install -D -m 555 build/bios_update_tools/apply_installed_updates  $RPM_BUILD_ROOT%{_bindir}/apply_installed_updates
install -D -m 555 build/bios_update_tools/inventory_system  $RPM_BUILD_ROOT%{_bindir}/inventory_system
install -D -m 555 build/bios_update_tools/inventory_to_packages  $RPM_BUILD_ROOT%{_bindir}/inventory_to_packages
install -D -m 555 build/bios_update_tools/rbu_check  $RPM_BUILD_ROOT%{_bindir}/rbu_check
install -D -m 555 build/bios_update_tools/update_bios  $RPM_BUILD_ROOT%{_bindir}/update_bios

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf ${RPM_BUILD_ROOT}

%post libs
ldconfig

%post -n libsmbiosxml-libs
ldconfig

%if %{build_butrpm}
%files -n bios_update_tools
%defattr(-,root,root)
%{_sysconfdir}/bios_update/bios_update.conf
%{_sysconfdir}/rc.d/init.d/bios_update_check
%{_bindir}/apply_installed_updates
%{_bindir}/inventory_system
%{_bindir}/inventory_to_packages
%{_bindir}/rbu_check
%{_bindir}/update_bios
%endif

%files libs
%defattr(-,root,root)
%{_libdir}/libsmbios.so.*.*

%if %{build_xml}
%files -n libsmbiosxml-libs
%defattr(-,root,root)
%{_libdir}/libsmbiosxml.so.*.*
%endif

%files devel
%defattr(-,root,root)

%if %{build_docs}
    %doc doc/full/html
%endif

%{_libdir}/libsmbios.so
/usr/include/smbios

%if %{build_xml}
%{_libdir}/libsmbiosxml.so
%endif


%files bin 
%defattr(555,root,root)
%{_bindir}/assetTag
%{_bindir}/dellBiosUpdate
%{_bindir}/getSystemId
%{_bindir}/propertyTag
%{_bindir}/serviceTag
%{_bindir}/tokenCtl
%{_bindir}/verifySmiPassword
%{_bindir}/wakeupCtl

%files unsupported-bin 
%defattr(555,root,root)
%{_bindir}/activateCmosToken
%{_bindir}/ascii2enUS_scancode
%{_bindir}/createUnitTestFiles
%{_bindir}/disable_console_redir
%{_bindir}/dumpCmos
%{_bindir}/getPasswordFormat
%{_bindir}/isCmosTokenActive
%{_bindir}/probes
%{_bindir}/smitest
%{_bindir}/stateByteCtl
%{_bindir}/upBootCtl

%if %{build_xml}
%files -n libsmbiosxml-bin 
%defattr(555,root,root)
%{_bindir}/dumpSmbios
%endif

%if %{build_static}
%files static 
%defattr(555,root,root)
%{_bindir}/*S
%endif
