// vim:expandtab:autoindent:tabstop=4:shiftwidth=4:filetype=c:
/*
 * Copyright (C) 2005 Dell Inc.
 *  by Michael Brown <Michael_E_Brown@dell.com>
 * Licensed under the Open Software License version 2.1 
 * 
 * Alternatively, you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, 
 * or (at your option) any later version.

 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 * See the GNU General Public License for more details.
 */


#ifndef RBU_H
#define RBU_H

// compat header should always be first header, if system headers included
#include "smbios/compat.h"

#include <string>

// types.h should be first user-defined header.
#include "smbios/types.h"
#include "smbios/IException.h"

// abi_prefix should be last header included before declarations
#include "smbios/config/abi_prefix.hpp"


namespace rbu
{
    DECLARE_EXCEPTION( RbuException );
    DECLARE_EXCEPTION_EX( RbuNotSupported, rbu, RbuException );
    DECLARE_EXCEPTION_EX( InvalidHdrFile, rbu, RbuException );
    DECLARE_EXCEPTION_EX( UnsupportedSystemForHdrFile, rbu, RbuException );
    DECLARE_EXCEPTION_EX( HdrFileIOError, rbu, RbuException );
    DECLARE_EXCEPTION_EX( RbuDriverIOError, rbu, RbuException );

    typedef enum { pt_any, pt_mono, pt_packet, pt_init } packet_type;
    typedef enum { rbu_unsupported, rbu_linux_v1, rbu_linux_v2 } driver_type;

    const int SYSID_OVERRIDE = 1;
    const int BIOSVER_OVERRIDE = 2;

    //! Update BIOS on Dell systems
    /** 
     */
    void dellBiosUpdate( std::string fileName, packet_type force_type);

    //! Cancel BIOS Update on Dell systems
    /** 
     */
    void cancelDellBiosUpdate();
    
    //! Dump info for BIOS Update HDR file.
    /** 
     */
    void dumpHdrInfo(std::string fileName);

    //! Check to see if a HDR file supports a specific System ID
    /** 
     */
    bool checkSystemId(std::string fileName, u16 sysId );

    //! Get BIOS ver of HDR file
    /** 
     */
    std::string getHdrBiosVer(std::string fileName);
}

// always should be last thing in header file
#include "smbios/config/abi_suffix.hpp"

#endif  /* RBU_H */
