# vim:noexpandtab:autoindent:tabstop=8:shiftwidth=8:filetype=make:

.PHONY: doxygen
doxygen: doc/interface/html/index.html  doc/full/html/index.html 

libsmbios.spec: doc/libsmbios.spec.in doc/module.mk
	perl -p -e "s/\@VERSION\@/$(RELEASE_VERSION)/g" doc/libsmbios.spec.in > libsmbios.spec	
	perl -p -i -e "s/\@PACKAGE\@/$(RELEASE_NAME)/g"  libsmbios.spec	

CLEAN_LIST += doc/full-documentation.dox
doc/full-documentation.dox: doc/full-documentation.dox.in
	@[ "$(SIL)" = "" ] || echo "BUILDING dox config file."
	$(SIL)DOT=$$(which dot 2>/dev/null); if [ -z "$$DOT" ]; then HAVE_DOT='NO'; else HAVE_DOT='YES'; fi; cp $^ $@; perl -p -i -e "s/^HAVE_DOT\s*=.*/HAVE_DOT = $$HAVE_DOT/" $@

HEADERS := $(shell find include libraries -type f -name \*.h | grep -v CVS)
INCLUDE := $(shell find include -type f | grep -v CVS )
CODE := $(shell find libraries -type f -name \*.cpp | grep -v CVS )
TXT_FILES := $(shell find doc/ -name \*.txt) TODO

CLEAN_LIST += doc/doxygen-full.log
DOCS += doc/full/html/index.html
DISTCLEAN_LIST += doc/full
doc/full/html/index.html: doc/full-documentation.dox $(CODE) $(INCLUDE) $(HEADERS) $(TXT_FILES)
	@[ "$(SIL)" = "" ] || echo "DOXYGEN                  : $(@)"
	$(SIL)doxygen doc/full-documentation.dox > doc/doxygen-full.log

CLEAN_LIST += doc/doxygen-int.log
DOCS += doc/interface/html/index.html
DISTCLEAN_LIST += doc/interface
doc/interface/html/index.html: doc/interface-only.dox $(HEADERS) $(TXT_FILES)
	@[ "$(SIL)" = "" ] || echo "DOXYGEN                  : $(@)"
	$(SIL)doxygen doc/interface-only.dox > doc/doxygen-int.log

doc/full/html/index.html: doc/reports/valgrind_output.txt
doc/interface/html/index.html: doc/reports/valgrind_output.txt
CLEAN_LIST += doc/reports/valgrind_output.txt
doc/reports/valgrind_output.txt:
	[ -e doc/reports ] || mkdir -p doc/reports
	@echo '/** \page leak_detect Automatically generated leak detection report' > doc/reports/valgrind_output.txt
	@echo '\section leaks Leak detection report' >> doc/reports/valgrind_output.txt
	@echo "Generated for $$(whoami) on $$(date)" >> doc/reports/valgrind_output.txt
	@echo '<pre>' >> doc/reports/valgrind_output.txt
	@echo 'LEAK DETECTION REPORT HAS NOT BEEN RUN YET IN THIS SOURCE TREE!' >> doc/reports/valgrind_output.txt
	@echo "</pre>*/" >> doc/reports/valgrind_output.txt
	@echo '/** \section leak_time Time to run leak detection report.' >> doc/reports/valgrind_output.txt
	@echo '<pre>' >> doc/reports/valgrind_output.txt
	@echo 'LEAK DETECTION REPORT HAS NOT BEEN RUN YET IN THIS SOURCE TREE!' >> doc/reports/valgrind_output.txt
	@echo "</pre>*/" >> doc/reports/valgrind_output.txt

doc/full/html/index.html: doc/reports/code-coverage.txt
doc/interface/html/index.html: doc/reports/code-coverage.txt
CLEAN_LIST += doc/reports/code-coverage.txt
doc/reports/code-coverage.txt:
	[ -e doc/reports ] || mkdir -p doc/reports
	@echo '/** \page code_coverage Automatically generated code coverage report' > doc/reports/code-coverage.txt
	@echo '<pre>' >> doc/reports/code-coverage.txt
	@echo 'CODE COVERAGE REPORT HAS NOT BEEN RUN YET IN THIS SOURCE TREE!' >> doc/reports/code-coverage.txt
	@echo "</pre>*/" >> doc/reports/code-coverage.txt


