/* Copyright (C) 2005 Red Hat, Inc. */

#include "seuser_internal.h"

typedef semanage_seuser_key_t record_key_t;
typedef semanage_seuser_t record_t;
#define DBASE_RECORD_DEFINED

#include <stddef.h>
#include "user_internal.h"
#include <semanage/users_policy.h>
#include "seusers.h"
#include "handle.h"
#include "database.h"
#include "debug.h"

int semanage_seuser_add(
	semanage_handle_t* handle,
	semanage_seuser_key_t* key,
	semanage_seuser_t* data) {

	dbase_config_t* dconfig = semanage_seuser_dbase(handle);
	return dbase_add(handle, dconfig, key, data);
}

int semanage_seuser_modify(
	semanage_handle_t* handle,
	semanage_seuser_key_t* key,
	semanage_seuser_t* data) {

	dbase_config_t* dconfig = semanage_seuser_dbase(handle);	
	return dbase_modify(handle, dconfig, key, data);
}

int semanage_seuser_set(
	semanage_handle_t* handle,
	semanage_seuser_key_t* key,
	semanage_seuser_t* data) {

	dbase_config_t* dconfig = semanage_seuser_dbase(handle);
	return dbase_set(handle, dconfig, key, data);
}

int semanage_seuser_del(
	semanage_handle_t* handle,
	semanage_seuser_key_t* key) {

	dbase_config_t* dconfig = semanage_seuser_dbase(handle);
	return dbase_del(handle, dconfig, key);
}

int semanage_seuser_query(
	semanage_handle_t* handle,
	semanage_seuser_key_t* key,
	semanage_seuser_t** response) {

	dbase_config_t* dconfig = semanage_seuser_dbase(handle);
	return dbase_query(handle, dconfig, key, response);
}

int semanage_seuser_exists(
	semanage_handle_t* handle,
	semanage_seuser_key_t* key,
	int* response) {

	dbase_config_t* dconfig = semanage_seuser_dbase(handle);
	return dbase_exists(handle, dconfig, key, response);
}

int semanage_seuser_count(
	semanage_handle_t* handle,
	unsigned int* response) {

	dbase_config_t* dconfig = semanage_seuser_dbase(handle);
	return dbase_count(handle, dconfig, response);
}

int semanage_seuser_iterate(
	semanage_handle_t* handle,
	int (*handler) (semanage_seuser_t* record,
	                void* varg),
	void* handler_arg) {

	dbase_config_t* dconfig = semanage_seuser_dbase(handle);
	return dbase_iterate(handle, dconfig, handler, handler_arg);
}
hidden_def(semanage_seuser_iterate)

int semanage_seuser_list(
	semanage_handle_t* handle,
	semanage_seuser_t*** records,
	size_t* count) {

	dbase_config_t* dconfig = semanage_seuser_dbase(handle);
	return dbase_list(handle, dconfig, records, count);
}


struct validate_handler_arg {
	semanage_handle_t* handle;
};

static int validate_handler(
	semanage_seuser_t* seuser,
	void* varg) {

	struct validate_handler_arg* arg = 
		(struct validate_handler_arg*) varg;

	const char* name = semanage_seuser_get_name(seuser);
	const char* sename = semanage_seuser_get_sename(seuser);
	const char* mls_range = semanage_seuser_get_mlsrange(seuser);

	semanage_user_key_t* key = NULL;
	int exists;
	if (semanage_user_key_create(arg->handle, sename, &key) < 0)
		goto err;

	if (semanage_user_exists(arg->handle, key, &exists) < 0)
		goto err;

	if (!exists) {
		ERR(arg->handle, "selinux user %s does not exist", sename);
		goto invalid;
	}

	/* FIXME: check unix user? */
	/* FIXME: add MLS checks */

	semanage_user_key_free(key);
	return 0;

	err:
	ERR(arg->handle, "could not check if the seuser mapping "
		"%s -> (%s, %s) is valid", name, sename, mls_range);
	semanage_user_key_free(key);
	return -1;

	invalid:
	ERR(arg->handle, "seuser mapping %s -> (%s, %s) is invalid",
		name, sename, mls_range);
	semanage_user_key_free(key);
	return -1;
}

int hidden semanage_seuser_validate(
	semanage_handle_t* handle) {

	struct validate_handler_arg arg;
	arg.handle = handle;
	return semanage_seuser_iterate(handle, validate_handler, &arg);
}
