%%  Copyright (c) 2001 Dan Gudmundsson
%%
%%  See the file "license.terms" for information on usage and redistribution
%%  of this file, and for a DISCLAIMER OF ALL WARRANTIES.
%% 
%%     $Id: gl.hrl,v 1.2 2004/03/31 14:00:15 dgud Exp $
%%
%/*  C type              GL type         storage                            */
%/*-------------------------------------------------------------------------*/
%typedef void            GLvoid;
%typedef unsigned char   GLboolean;
%typedef signed char     GLbyte;         /* 1-byte signed */
%typedef short           GLshort;        /* 2-byte signed */
%typedef int             GLint;          /* 4-byte signed */
%typedef unsigned char   GLubyte;        /* 1-byte unsigned */
%typedef unsigned short  GLushort;       /* 2-byte unsigned */
%typedef unsigned int    GLuint;         /* 4-byte unsigned */
%typedef int             GLsizei;        /* 4-byte signed */
%typedef float           GLfloat;        /* single precision float */
%typedef float           GLclampf;       /* single precision float in [0,1] */
%typedef double          GLdouble;       /* double precision float */
%typedef double          GLclampd;       /* double precision float in [0,1] */
%typedef unsigned int    GLbitfield;     /* 32 bits */

-define(GL_BYTE_SIZE, 8).
-define(GL_UNSIGNED_BYTE_SIZE, 8).
-define(GL_SHORT_SIZE, 16).
-define(GL_UNSIGNED_SHORT_SIZE, 16).
-define(GL_INT_SIZE, 32).
-define(GL_UNSIGNED_INT_SIZE, 32).
-define(GL_FLOAT_SIZE, 32).
-define(GL_DOUBLE_SIZE, 64).

-define(gl_type_size(TYPE), 
	case (TYPE) of 
	    ?GL_BYTE ->           ?GL_BYTE_SIZE;
	    ?GL_UNSIGNED_BYTE->   ?GL_UNSIGNED_BYTE_SIZE;
	    ?GL_SHORT ->          ?GL_SHORT_SIZE;
	    ?GL_UNSIGNED_SHORT -> ?GL_UNSIGNED_SHORT_SIZE;
	    ?GL_INT ->            ?GL_INT_SIZE;
	    ?GL_UNSIGNED_INT ->   ?GL_UNSIGNED_INT_SIZE;
	    ?GL_FLOAT ->          ?GL_FLOAT_SIZE;
	    ?GL_DOUBLE ->         ?GL_DOUBLE_SIZE
	end).
-ifndef(__gl_h_).
-define(__gl_h_, 1).
%%%% Version 
-define(GL_VERSION_1_1, 1).
-define(GL_VERSION_1_2, 1).
%%%% Extensions 
-define(GL_ARB_imaging, 1).
-define(GL_ARB_multitexture, 1).
%%%% AccumOp 
-define(GL_ACCUM, 16#0100).
-define(GL_LOAD, 16#0101).
-define(GL_RETURN, 16#0102).
-define(GL_MULT, 16#0103).
-define(GL_ADD, 16#0104).
%%%% AlphaFunction 
-define(GL_NEVER, 16#0200).
-define(GL_LESS, 16#0201).
-define(GL_EQUAL, 16#0202).
-define(GL_LEQUAL, 16#0203).
-define(GL_GREATER, 16#0204).
-define(GL_NOTEQUAL, 16#0205).
-define(GL_GEQUAL, 16#0206).
-define(GL_ALWAYS, 16#0207).
%%%% AttribMask 
-define(GL_CURRENT_BIT, 16#00000001).
-define(GL_POINT_BIT, 16#00000002).
-define(GL_LINE_BIT, 16#00000004).
-define(GL_POLYGON_BIT, 16#00000008).
-define(GL_POLYGON_STIPPLE_BIT, 16#00000010).
-define(GL_PIXEL_MODE_BIT, 16#00000020).
-define(GL_LIGHTING_BIT, 16#00000040).
-define(GL_FOG_BIT, 16#00000080).
-define(GL_DEPTH_BUFFER_BIT, 16#00000100).
-define(GL_ACCUM_BUFFER_BIT, 16#00000200).
-define(GL_STENCIL_BUFFER_BIT, 16#00000400).
-define(GL_VIEWPORT_BIT, 16#00000800).
-define(GL_TRANSFORM_BIT, 16#00001000).
-define(GL_ENABLE_BIT, 16#00002000).
-define(GL_COLOR_BUFFER_BIT, 16#00004000).
-define(GL_HINT_BIT, 16#00008000).
-define(GL_EVAL_BIT, 16#00010000).
-define(GL_LIST_BIT, 16#00020000).
-define(GL_TEXTURE_BIT, 16#00040000).
-define(GL_SCISSOR_BIT, 16#00080000).
-define(GL_ALL_ATTRIB_BITS, 16#000fffff).
%%%% BeginMode 
-define(GL_POINTS, 16#0000).
-define(GL_LINES, 16#0001).
-define(GL_LINE_LOOP, 16#0002).
-define(GL_LINE_STRIP, 16#0003).
-define(GL_TRIANGLES, 16#0004).
-define(GL_TRIANGLE_STRIP, 16#0005).
-define(GL_TRIANGLE_FAN, 16#0006).
-define(GL_QUADS, 16#0007).
-define(GL_QUAD_STRIP, 16#0008).
-define(GL_POLYGON, 16#0009).
%%%% BlendEquationMode 
%%%% GL_LOGIC_OP 
%%%% GL_FUNC_ADD 
%%%% GL_MIN 
%%%% GL_MAX 
%%%% GL_FUNC_SUBTRACT 
%%%% GL_FUNC_REVERSE_SUBTRACT 
%%%% BlendingFactorDest 
-define(GL_ZERO, 0).
-define(GL_ONE, 1).
-define(GL_SRC_COLOR, 16#0300).
-define(GL_ONE_MINUS_SRC_COLOR, 16#0301).
-define(GL_SRC_ALPHA, 16#0302).
-define(GL_ONE_MINUS_SRC_ALPHA, 16#0303).
-define(GL_DST_ALPHA, 16#0304).
-define(GL_ONE_MINUS_DST_ALPHA, 16#0305).
%%%% GL_CONSTANT_COLOR 
%%%% GL_ONE_MINUS_CONSTANT_COLOR 
%%%% GL_CONSTANT_ALPHA 
%%%% GL_ONE_MINUS_CONSTANT_ALPHA 
%%%% BlendingFactorSrc 
%%%% GL_ZERO 
%%%% GL_ONE 
-define(GL_DST_COLOR, 16#0306).
-define(GL_ONE_MINUS_DST_COLOR, 16#0307).
-define(GL_SRC_ALPHA_SATURATE, 16#0308).
%%%% GL_SRC_ALPHA 
%%%% GL_ONE_MINUS_SRC_ALPHA 
%%%% GL_DST_ALPHA 
%%%% GL_ONE_MINUS_DST_ALPHA 
%%%% GL_CONSTANT_COLOR 
%%%% GL_ONE_MINUS_CONSTANT_COLOR 
%%%% GL_CONSTANT_ALPHA 
%%%% GL_ONE_MINUS_CONSTANT_ALPHA 
%%%% Boolean 
-define(GL_TRUE, 1).
-define(GL_FALSE, 0).
%%%% ClearBufferMask 
%%%% GL_COLOR_BUFFER_BIT 
%%%% GL_ACCUM_BUFFER_BIT 
%%%% GL_STENCIL_BUFFER_BIT 
%%%% GL_DEPTH_BUFFER_BIT 
%%%% ClientArrayType 
%%%% GL_VERTEX_ARRAY 
%%%% GL_NORMAL_ARRAY 
%%%% GL_COLOR_ARRAY 
%%%% GL_INDEX_ARRAY 
%%%% GL_TEXTURE_COORD_ARRAY 
%%%% GL_EDGE_FLAG_ARRAY 
%%%% ClipPlaneName 
-define(GL_CLIP_PLANE0, 16#3000).
-define(GL_CLIP_PLANE1, 16#3001).
-define(GL_CLIP_PLANE2, 16#3002).
-define(GL_CLIP_PLANE3, 16#3003).
-define(GL_CLIP_PLANE4, 16#3004).
-define(GL_CLIP_PLANE5, 16#3005).
%%%% ColorMaterialFace 
%%%% GL_FRONT 
%%%% GL_BACK 
%%%% GL_FRONT_AND_BACK 
%%%% ColorMaterialParameter 
%%%% GL_AMBIENT 
%%%% GL_DIFFUSE 
%%%% GL_SPECULAR 
%%%% GL_EMISSION 
%%%% GL_AMBIENT_AND_DIFFUSE 
%%%% ColorPointerType 
%%%% GL_BYTE 
%%%% GL_UNSIGNED_BYTE 
%%%% GL_SHORT 
%%%% GL_UNSIGNED_SHORT 
%%%% GL_INT 
%%%% GL_UNSIGNED_INT 
%%%% GL_FLOAT 
%%%% GL_DOUBLE 
%%%% ColorTableParameterPName 
%%%% GL_COLOR_TABLE_SCALE 
%%%% GL_COLOR_TABLE_BIAS 
%%%% ColorTableTarget 
%%%% GL_COLOR_TABLE 
%%%% GL_POST_CONVOLUTION_COLOR_TABLE 
%%%% GL_POST_COLOR_MATRIX_COLOR_TABLE 
%%%% GL_PROXY_COLOR_TABLE 
%%%% GL_PROXY_POST_CONVOLUTION_COLOR_TABLE 
%%%% GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE 
%%%% ConvolutionBorderMode 
%%%% GL_REDUCE 
%%%% GL_IGNORE_BORDER 
%%%% GL_CONSTANT_BORDER 
%%%% ConvolutionParameter 
%%%% GL_CONVOLUTION_BORDER_MODE 
%%%% GL_CONVOLUTION_FILTER_SCALE 
%%%% GL_CONVOLUTION_FILTER_BIAS 
%%%% ConvolutionTarget 
%%%% GL_CONVOLUTION_1D 
%%%% GL_CONVOLUTION_2D 
%%%% CullFaceMode 
%%%% GL_FRONT 
%%%% GL_BACK 
%%%% GL_FRONT_AND_BACK 
%%%% DataType 
-define(GL_BYTE, 16#1400).
-define(GL_UNSIGNED_BYTE, 16#1401).
-define(GL_SHORT, 16#1402).
-define(GL_UNSIGNED_SHORT, 16#1403).
-define(GL_INT, 16#1404).
-define(GL_UNSIGNED_INT, 16#1405).
-define(GL_FLOAT, 16#1406).
-define(GL_2_BYTES, 16#1407).
-define(GL_3_BYTES, 16#1408).
-define(GL_4_BYTES, 16#1409).
-define(GL_DOUBLE, 16#140A).
%%%% DepthFunction 
%%%% GL_NEVER 
%%%% GL_LESS 
%%%% GL_EQUAL 
%%%% GL_LEQUAL 
%%%% GL_GREATER 
%%%% GL_NOTEQUAL 
%%%% GL_GEQUAL 
%%%% GL_ALWAYS 
%%%% DrawBufferMode 
-define(GL_NONE, 0).
-define(GL_FRONT_LEFT, 16#0400).
-define(GL_FRONT_RIGHT, 16#0401).
-define(GL_BACK_LEFT, 16#0402).
-define(GL_BACK_RIGHT, 16#0403).
-define(GL_FRONT, 16#0404).
-define(GL_BACK, 16#0405).
-define(GL_LEFT, 16#0406).
-define(GL_RIGHT, 16#0407).
-define(GL_FRONT_AND_BACK, 16#0408).
-define(GL_AUX0, 16#0409).
-define(GL_AUX1, 16#040A).
-define(GL_AUX2, 16#040B).
-define(GL_AUX3, 16#040C).
%%%% Enable 
%%%% GL_FOG 
%%%% GL_LIGHTING 
%%%% GL_TEXTURE_1D 
%%%% GL_TEXTURE_2D 
%%%% GL_LINE_STIPPLE 
%%%% GL_POLYGON_STIPPLE 
%%%% GL_CULL_FACE 
%%%% GL_ALPHA_TEST 
%%%% GL_BLEND 
%%%% GL_INDEX_LOGIC_OP 
%%%% GL_COLOR_LOGIC_OP 
%%%% GL_DITHER 
%%%% GL_STENCIL_TEST 
%%%% GL_DEPTH_TEST 
%%%% GL_CLIP_PLANE0 
%%%% GL_CLIP_PLANE1 
%%%% GL_CLIP_PLANE2 
%%%% GL_CLIP_PLANE3 
%%%% GL_CLIP_PLANE4 
%%%% GL_CLIP_PLANE5 
%%%% GL_LIGHT0 
%%%% GL_LIGHT1 
%%%% GL_LIGHT2 
%%%% GL_LIGHT3 
%%%% GL_LIGHT4 
%%%% GL_LIGHT5 
%%%% GL_LIGHT6 
%%%% GL_LIGHT7 
%%%% GL_TEXTURE_GEN_S 
%%%% GL_TEXTURE_GEN_T 
%%%% GL_TEXTURE_GEN_R 
%%%% GL_TEXTURE_GEN_Q 
%%%% GL_MAP1_VERTEX_3 
%%%% GL_MAP1_VERTEX_4 
%%%% GL_MAP1_COLOR_4 
%%%% GL_MAP1_INDEX 
%%%% GL_MAP1_NORMAL 
%%%% GL_MAP1_TEXTURE_COORD_1 
%%%% GL_MAP1_TEXTURE_COORD_2 
%%%% GL_MAP1_TEXTURE_COORD_3 
%%%% GL_MAP1_TEXTURE_COORD_4 
%%%% GL_MAP2_VERTEX_3 
%%%% GL_MAP2_VERTEX_4 
%%%% GL_MAP2_COLOR_4 
%%%% GL_MAP2_INDEX 
%%%% GL_MAP2_NORMAL 
%%%% GL_MAP2_TEXTURE_COORD_1 
%%%% GL_MAP2_TEXTURE_COORD_2 
%%%% GL_MAP2_TEXTURE_COORD_3 
%%%% GL_MAP2_TEXTURE_COORD_4 
%%%% GL_POINT_SMOOTH 
%%%% GL_LINE_SMOOTH 
%%%% GL_POLYGON_SMOOTH 
%%%% GL_SCISSOR_TEST 
%%%% GL_COLOR_MATERIAL 
%%%% GL_NORMALIZE 
%%%% GL_AUTO_NORMAL 
%%%% GL_VERTEX_ARRAY 
%%%% GL_NORMAL_ARRAY 
%%%% GL_COLOR_ARRAY 
%%%% GL_INDEX_ARRAY 
%%%% GL_TEXTURE_COORD_ARRAY 
%%%% GL_EDGE_FLAG_ARRAY 
%%%% GL_POLYGON_OFFSET_POINT 
%%%% GL_POLYGON_OFFSET_LINE 
%%%% GL_POLYGON_OFFSET_FILL 
%%%% GL_COLOR_TABLE 
%%%% GL_POST_CONVOLUTION_COLOR_TABLE 
%%%% GL_POST_COLOR_MATRIX_COLOR_TABLE 
%%%% GL_CONVOLUTION_1D 
%%%% GL_CONVOLUTION_2D 
%%%% GL_SEPARABLE_2D 
%%%% GL_HISTOGRAM 
%%%% GL_MINMAX 
%%%% GL_RESCALE_NORMAL 
%%%% GL_TEXTURE_3D 
%%%% ErrorCode 
-define(GL_NO_ERROR, 0).
-define(GL_INVALID_ENUM, 16#0500).
-define(GL_INVALID_VALUE, 16#0501).
-define(GL_INVALID_OPERATION, 16#0502).
-define(GL_STACK_OVERFLOW, 16#0503).
-define(GL_STACK_UNDERFLOW, 16#0504).
-define(GL_OUT_OF_MEMORY, 16#0505).
%%%% GL_TABLE_TOO_LARGE 
%%%% FeedBackMode 
-define(GL_2D, 16#0600).
-define(GL_3D, 16#0601).
-define(GL_3D_COLOR, 16#0602).
-define(GL_3D_COLOR_TEXTURE, 16#0603).
-define(GL_4D_COLOR_TEXTURE, 16#0604).
%%%% FeedBackToken 
-define(GL_PASS_THROUGH_TOKEN, 16#0700).
-define(GL_POINT_TOKEN, 16#0701).
-define(GL_LINE_TOKEN, 16#0702).
-define(GL_POLYGON_TOKEN, 16#0703).
-define(GL_BITMAP_TOKEN, 16#0704).
-define(GL_DRAW_PIXEL_TOKEN, 16#0705).
-define(GL_COPY_PIXEL_TOKEN, 16#0706).
-define(GL_LINE_RESET_TOKEN, 16#0707).
%%%% FogMode 
%%%% GL_LINEAR 
-define(GL_EXP, 16#0800).
-define(GL_EXP2, 16#0801).
%%%% FogParameter 
%%%% GL_FOG_COLOR 
%%%% GL_FOG_DENSITY 
%%%% GL_FOG_END 
%%%% GL_FOG_INDEX 
%%%% GL_FOG_MODE 
%%%% GL_FOG_START 
%%%% FrontFaceDirection 
-define(GL_CW, 16#0900).
-define(GL_CCW, 16#0901).
%%%% GetColorTableParameterPName 
%%%% GL_COLOR_TABLE_SCALE 
%%%% GL_COLOR_TABLE_BIAS 
%%%% GL_COLOR_TABLE_FORMAT 
%%%% GL_COLOR_TABLE_WIDTH 
%%%% GL_COLOR_TABLE_RED_SIZE 
%%%% GL_COLOR_TABLE_GREEN_SIZE 
%%%% GL_COLOR_TABLE_BLUE_SIZE 
%%%% GL_COLOR_TABLE_ALPHA_SIZE 
%%%% GL_COLOR_TABLE_LUMINANCE_SIZE 
%%%% GL_COLOR_TABLE_INTENSITY_SIZE 
%%%% GetConvolutionParameterPName 
%%%% GL_CONVOLUTION_BORDER_COLOR 
%%%% GL_CONVOLUTION_BORDER_MODE 
%%%% GL_CONVOLUTION_FILTER_SCALE 
%%%% GL_CONVOLUTION_FILTER_BIAS 
%%%% GL_CONVOLUTION_FORMAT 
%%%% GL_CONVOLUTION_WIDTH 
%%%% GL_CONVOLUTION_HEIGHT 
%%%% GL_MAX_CONVOLUTION_WIDTH 
%%%% GL_MAX_CONVOLUTION_HEIGHT 
%%%% GetHistogramParameterPName 
%%%% GL_HISTOGRAM_WIDTH 
%%%% GL_HISTOGRAM_FORMAT 
%%%% GL_HISTOGRAM_RED_SIZE 
%%%% GL_HISTOGRAM_GREEN_SIZE 
%%%% GL_HISTOGRAM_BLUE_SIZE 
%%%% GL_HISTOGRAM_ALPHA_SIZE 
%%%% GL_HISTOGRAM_LUMINANCE_SIZE 
%%%% GL_HISTOGRAM_SINK 
%%%% GetMapTarget 
-define(GL_COEFF, 16#0A00).
-define(GL_ORDER, 16#0A01).
-define(GL_DOMAIN, 16#0A02).
%%%% GetMinmaxParameterPName 
%%%% GL_MINMAX_FORMAT 
%%%% GL_MINMAX_SINK 
%%%% GetPixelMap 
%%%% GL_PIXEL_MAP_I_TO_I 
%%%% GL_PIXEL_MAP_S_TO_S 
%%%% GL_PIXEL_MAP_I_TO_R 
%%%% GL_PIXEL_MAP_I_TO_G 
%%%% GL_PIXEL_MAP_I_TO_B 
%%%% GL_PIXEL_MAP_I_TO_A 
%%%% GL_PIXEL_MAP_R_TO_R 
%%%% GL_PIXEL_MAP_G_TO_G 
%%%% GL_PIXEL_MAP_B_TO_B 
%%%% GL_PIXEL_MAP_A_TO_A 
%%%% GetPointerTarget 
%%%% GL_VERTEX_ARRAY_POINTER 
%%%% GL_NORMAL_ARRAY_POINTER 
%%%% GL_COLOR_ARRAY_POINTER 
%%%% GL_INDEX_ARRAY_POINTER 
%%%% GL_TEXTURE_COORD_ARRAY_POINTER 
%%%% GL_EDGE_FLAG_ARRAY_POINTER 
%%%% GetTarget 
-define(GL_CURRENT_COLOR, 16#0B00).
-define(GL_CURRENT_INDEX, 16#0B01).
-define(GL_CURRENT_NORMAL, 16#0B02).
-define(GL_CURRENT_TEXTURE_COORDS, 16#0B03).
-define(GL_CURRENT_RASTER_COLOR, 16#0B04).
-define(GL_CURRENT_RASTER_INDEX, 16#0B05).
-define(GL_CURRENT_RASTER_TEXTURE_COORDS, 16#0B06).
-define(GL_CURRENT_RASTER_POSITION, 16#0B07).
-define(GL_CURRENT_RASTER_POSITION_VALID, 16#0B08).
-define(GL_CURRENT_RASTER_DISTANCE, 16#0B09).
-define(GL_POINT_SMOOTH, 16#0B10).
-define(GL_POINT_SIZE, 16#0B11).
-define(GL_POINT_SIZE_RANGE, 16#0B12).
-define(GL_POINT_SIZE_GRANULARITY, 16#0B13).
-define(GL_LINE_SMOOTH, 16#0B20).
-define(GL_LINE_WIDTH, 16#0B21).
-define(GL_LINE_WIDTH_RANGE, 16#0B22).
-define(GL_LINE_WIDTH_GRANULARITY, 16#0B23).
-define(GL_LINE_STIPPLE, 16#0B24).
-define(GL_LINE_STIPPLE_PATTERN, 16#0B25).
-define(GL_LINE_STIPPLE_REPEAT, 16#0B26).
%%%% GL_SMOOTH_POINT_SIZE_RANGE 
%%%% GL_SMOOTH_POINT_SIZE_GRANULARITY 
%%%% GL_SMOOTH_LINE_WIDTH_RANGE 
%%%% GL_SMOOTH_LINE_WIDTH_GRANULARITY 
%%%% GL_ALIASED_POINT_SIZE_RANGE 
%%%% GL_ALIASED_LINE_WIDTH_RANGE 
-define(GL_LIST_MODE, 16#0B30).
-define(GL_MAX_LIST_NESTING, 16#0B31).
-define(GL_LIST_BASE, 16#0B32).
-define(GL_LIST_INDEX, 16#0B33).
-define(GL_POLYGON_MODE, 16#0B40).
-define(GL_POLYGON_SMOOTH, 16#0B41).
-define(GL_POLYGON_STIPPLE, 16#0B42).
-define(GL_EDGE_FLAG, 16#0B43).
-define(GL_CULL_FACE, 16#0B44).
-define(GL_CULL_FACE_MODE, 16#0B45).
-define(GL_FRONT_FACE, 16#0B46).
-define(GL_LIGHTING, 16#0B50).
-define(GL_LIGHT_MODEL_LOCAL_VIEWER, 16#0B51).
-define(GL_LIGHT_MODEL_TWO_SIDE, 16#0B52).
-define(GL_LIGHT_MODEL_AMBIENT, 16#0B53).
-define(GL_SHADE_MODEL, 16#0B54).
-define(GL_COLOR_MATERIAL_FACE, 16#0B55).
-define(GL_COLOR_MATERIAL_PARAMETER, 16#0B56).
-define(GL_COLOR_MATERIAL, 16#0B57).
-define(GL_FOG, 16#0B60).
-define(GL_FOG_INDEX, 16#0B61).
-define(GL_FOG_DENSITY, 16#0B62).
-define(GL_FOG_START, 16#0B63).
-define(GL_FOG_END, 16#0B64).
-define(GL_FOG_MODE, 16#0B65).
-define(GL_FOG_COLOR, 16#0B66).
-define(GL_DEPTH_RANGE, 16#0B70).
-define(GL_DEPTH_TEST, 16#0B71).
-define(GL_DEPTH_WRITEMASK, 16#0B72).
-define(GL_DEPTH_CLEAR_VALUE, 16#0B73).
-define(GL_DEPTH_FUNC, 16#0B74).
-define(GL_ACCUM_CLEAR_VALUE, 16#0B80).
-define(GL_STENCIL_TEST, 16#0B90).
-define(GL_STENCIL_CLEAR_VALUE, 16#0B91).
-define(GL_STENCIL_FUNC, 16#0B92).
-define(GL_STENCIL_VALUE_MASK, 16#0B93).
-define(GL_STENCIL_FAIL, 16#0B94).
-define(GL_STENCIL_PASS_DEPTH_FAIL, 16#0B95).
-define(GL_STENCIL_PASS_DEPTH_PASS, 16#0B96).
-define(GL_STENCIL_REF, 16#0B97).
-define(GL_STENCIL_WRITEMASK, 16#0B98).
-define(GL_MATRIX_MODE, 16#0BA0).
-define(GL_NORMALIZE, 16#0BA1).
-define(GL_VIEWPORT, 16#0BA2).
-define(GL_MODELVIEW_STACK_DEPTH, 16#0BA3).
-define(GL_PROJECTION_STACK_DEPTH, 16#0BA4).
-define(GL_TEXTURE_STACK_DEPTH, 16#0BA5).
-define(GL_MODELVIEW_MATRIX, 16#0BA6).
-define(GL_PROJECTION_MATRIX, 16#0BA7).
-define(GL_TEXTURE_MATRIX, 16#0BA8).
-define(GL_ATTRIB_STACK_DEPTH, 16#0BB0).
-define(GL_CLIENT_ATTRIB_STACK_DEPTH, 16#0BB1).
-define(GL_ALPHA_TEST, 16#0BC0).
-define(GL_ALPHA_TEST_FUNC, 16#0BC1).
-define(GL_ALPHA_TEST_REF, 16#0BC2).
-define(GL_DITHER, 16#0BD0).
-define(GL_BLEND_DST, 16#0BE0).
-define(GL_BLEND_SRC, 16#0BE1).
-define(GL_BLEND, 16#0BE2).
-define(GL_LOGIC_OP_MODE, 16#0BF0).
-define(GL_INDEX_LOGIC_OP, 16#0BF1).
-define(GL_COLOR_LOGIC_OP, 16#0BF2).
-define(GL_AUX_BUFFERS, 16#0C00).
-define(GL_DRAW_BUFFER, 16#0C01).
-define(GL_READ_BUFFER, 16#0C02).
-define(GL_SCISSOR_BOX, 16#0C10).
-define(GL_SCISSOR_TEST, 16#0C11).
-define(GL_INDEX_CLEAR_VALUE, 16#0C20).
-define(GL_INDEX_WRITEMASK, 16#0C21).
-define(GL_COLOR_CLEAR_VALUE, 16#0C22).
-define(GL_COLOR_WRITEMASK, 16#0C23).
-define(GL_INDEX_MODE, 16#0C30).
-define(GL_RGBA_MODE, 16#0C31).
-define(GL_DOUBLEBUFFER, 16#0C32).
-define(GL_STEREO, 16#0C33).
-define(GL_RENDER_MODE, 16#0C40).
-define(GL_PERSPECTIVE_CORRECTION_HINT, 16#0C50).
-define(GL_POINT_SMOOTH_HINT, 16#0C51).
-define(GL_LINE_SMOOTH_HINT, 16#0C52).
-define(GL_POLYGON_SMOOTH_HINT, 16#0C53).
-define(GL_FOG_HINT, 16#0C54).
-define(GL_TEXTURE_GEN_S, 16#0C60).
-define(GL_TEXTURE_GEN_T, 16#0C61).
-define(GL_TEXTURE_GEN_R, 16#0C62).
-define(GL_TEXTURE_GEN_Q, 16#0C63).
-define(GL_PIXEL_MAP_I_TO_I, 16#0C70).
-define(GL_PIXEL_MAP_S_TO_S, 16#0C71).
-define(GL_PIXEL_MAP_I_TO_R, 16#0C72).
-define(GL_PIXEL_MAP_I_TO_G, 16#0C73).
-define(GL_PIXEL_MAP_I_TO_B, 16#0C74).
-define(GL_PIXEL_MAP_I_TO_A, 16#0C75).
-define(GL_PIXEL_MAP_R_TO_R, 16#0C76).
-define(GL_PIXEL_MAP_G_TO_G, 16#0C77).
-define(GL_PIXEL_MAP_B_TO_B, 16#0C78).
-define(GL_PIXEL_MAP_A_TO_A, 16#0C79).
-define(GL_PIXEL_MAP_I_TO_I_SIZE, 16#0CB0).
-define(GL_PIXEL_MAP_S_TO_S_SIZE, 16#0CB1).
-define(GL_PIXEL_MAP_I_TO_R_SIZE, 16#0CB2).
-define(GL_PIXEL_MAP_I_TO_G_SIZE, 16#0CB3).
-define(GL_PIXEL_MAP_I_TO_B_SIZE, 16#0CB4).
-define(GL_PIXEL_MAP_I_TO_A_SIZE, 16#0CB5).
-define(GL_PIXEL_MAP_R_TO_R_SIZE, 16#0CB6).
-define(GL_PIXEL_MAP_G_TO_G_SIZE, 16#0CB7).
-define(GL_PIXEL_MAP_B_TO_B_SIZE, 16#0CB8).
-define(GL_PIXEL_MAP_A_TO_A_SIZE, 16#0CB9).
-define(GL_UNPACK_SWAP_BYTES, 16#0CF0).
-define(GL_UNPACK_LSB_FIRST, 16#0CF1).
-define(GL_UNPACK_ROW_LENGTH, 16#0CF2).
-define(GL_UNPACK_SKIP_ROWS, 16#0CF3).
-define(GL_UNPACK_SKIP_PIXELS, 16#0CF4).
-define(GL_UNPACK_ALIGNMENT, 16#0CF5).
-define(GL_PACK_SWAP_BYTES, 16#0D00).
-define(GL_PACK_LSB_FIRST, 16#0D01).
-define(GL_PACK_ROW_LENGTH, 16#0D02).
-define(GL_PACK_SKIP_ROWS, 16#0D03).
-define(GL_PACK_SKIP_PIXELS, 16#0D04).
-define(GL_PACK_ALIGNMENT, 16#0D05).
-define(GL_MAP_COLOR, 16#0D10).
-define(GL_MAP_STENCIL, 16#0D11).
-define(GL_INDEX_SHIFT, 16#0D12).
-define(GL_INDEX_OFFSET, 16#0D13).
-define(GL_RED_SCALE, 16#0D14).
-define(GL_RED_BIAS, 16#0D15).
-define(GL_ZOOM_X, 16#0D16).
-define(GL_ZOOM_Y, 16#0D17).
-define(GL_GREEN_SCALE, 16#0D18).
-define(GL_GREEN_BIAS, 16#0D19).
-define(GL_BLUE_SCALE, 16#0D1A).
-define(GL_BLUE_BIAS, 16#0D1B).
-define(GL_ALPHA_SCALE, 16#0D1C).
-define(GL_ALPHA_BIAS, 16#0D1D).
-define(GL_DEPTH_SCALE, 16#0D1E).
-define(GL_DEPTH_BIAS, 16#0D1F).
-define(GL_MAX_EVAL_ORDER, 16#0D30).
-define(GL_MAX_LIGHTS, 16#0D31).
-define(GL_MAX_CLIP_PLANES, 16#0D32).
-define(GL_MAX_TEXTURE_SIZE, 16#0D33).
-define(GL_MAX_PIXEL_MAP_TABLE, 16#0D34).
-define(GL_MAX_ATTRIB_STACK_DEPTH, 16#0D35).
-define(GL_MAX_MODELVIEW_STACK_DEPTH, 16#0D36).
-define(GL_MAX_NAME_STACK_DEPTH, 16#0D37).
-define(GL_MAX_PROJECTION_STACK_DEPTH, 16#0D38).
-define(GL_MAX_TEXTURE_STACK_DEPTH, 16#0D39).
-define(GL_MAX_VIEWPORT_DIMS, 16#0D3A).
-define(GL_MAX_CLIENT_ATTRIB_STACK_DEPTH, 16#0D3B).
-define(GL_SUBPIXEL_BITS, 16#0D50).
-define(GL_INDEX_BITS, 16#0D51).
-define(GL_RED_BITS, 16#0D52).
-define(GL_GREEN_BITS, 16#0D53).
-define(GL_BLUE_BITS, 16#0D54).
-define(GL_ALPHA_BITS, 16#0D55).
-define(GL_DEPTH_BITS, 16#0D56).
-define(GL_STENCIL_BITS, 16#0D57).
-define(GL_ACCUM_RED_BITS, 16#0D58).
-define(GL_ACCUM_GREEN_BITS, 16#0D59).
-define(GL_ACCUM_BLUE_BITS, 16#0D5A).
-define(GL_ACCUM_ALPHA_BITS, 16#0D5B).
-define(GL_NAME_STACK_DEPTH, 16#0D70).
-define(GL_AUTO_NORMAL, 16#0D80).
-define(GL_MAP1_COLOR_4, 16#0D90).
-define(GL_MAP1_INDEX, 16#0D91).
-define(GL_MAP1_NORMAL, 16#0D92).
-define(GL_MAP1_TEXTURE_COORD_1, 16#0D93).
-define(GL_MAP1_TEXTURE_COORD_2, 16#0D94).
-define(GL_MAP1_TEXTURE_COORD_3, 16#0D95).
-define(GL_MAP1_TEXTURE_COORD_4, 16#0D96).
-define(GL_MAP1_VERTEX_3, 16#0D97).
-define(GL_MAP1_VERTEX_4, 16#0D98).
-define(GL_MAP2_COLOR_4, 16#0DB0).
-define(GL_MAP2_INDEX, 16#0DB1).
-define(GL_MAP2_NORMAL, 16#0DB2).
-define(GL_MAP2_TEXTURE_COORD_1, 16#0DB3).
-define(GL_MAP2_TEXTURE_COORD_2, 16#0DB4).
-define(GL_MAP2_TEXTURE_COORD_3, 16#0DB5).
-define(GL_MAP2_TEXTURE_COORD_4, 16#0DB6).
-define(GL_MAP2_VERTEX_3, 16#0DB7).
-define(GL_MAP2_VERTEX_4, 16#0DB8).
-define(GL_MAP1_GRID_DOMAIN, 16#0DD0).
-define(GL_MAP1_GRID_SEGMENTS, 16#0DD1).
-define(GL_MAP2_GRID_DOMAIN, 16#0DD2).
-define(GL_MAP2_GRID_SEGMENTS, 16#0DD3).
-define(GL_TEXTURE_1D, 16#0DE0).
-define(GL_TEXTURE_2D, 16#0DE1).
-define(GL_FEEDBACK_BUFFER_POINTER, 16#0DF0).
-define(GL_FEEDBACK_BUFFER_SIZE, 16#0DF1).
-define(GL_FEEDBACK_BUFFER_TYPE, 16#0DF2).
-define(GL_SELECTION_BUFFER_POINTER, 16#0DF3).
-define(GL_SELECTION_BUFFER_SIZE, 16#0DF4).
%%%% GL_TEXTURE_BINDING_1D 
%%%% GL_TEXTURE_BINDING_2D 
%%%% GL_TEXTURE_BINDING_3D 
%%%% GL_VERTEX_ARRAY 
%%%% GL_NORMAL_ARRAY 
%%%% GL_COLOR_ARRAY 
%%%% GL_INDEX_ARRAY 
%%%% GL_TEXTURE_COORD_ARRAY 
%%%% GL_EDGE_FLAG_ARRAY 
%%%% GL_VERTEX_ARRAY_SIZE 
%%%% GL_VERTEX_ARRAY_TYPE 
%%%% GL_VERTEX_ARRAY_STRIDE 
%%%% GL_NORMAL_ARRAY_TYPE 
%%%% GL_NORMAL_ARRAY_STRIDE 
%%%% GL_COLOR_ARRAY_SIZE 
%%%% GL_COLOR_ARRAY_TYPE 
%%%% GL_COLOR_ARRAY_STRIDE 
%%%% GL_INDEX_ARRAY_TYPE 
%%%% GL_INDEX_ARRAY_STRIDE 
%%%% GL_TEXTURE_COORD_ARRAY_SIZE 
%%%% GL_TEXTURE_COORD_ARRAY_TYPE 
%%%% GL_TEXTURE_COORD_ARRAY_STRIDE 
%%%% GL_EDGE_FLAG_ARRAY_STRIDE 
%%%% GL_POLYGON_OFFSET_FACTOR 
%%%% GL_POLYGON_OFFSET_UNITS 
%%%% GL_COLOR_TABLE 
%%%% GL_POST_CONVOLUTION_COLOR_TABLE 
%%%% GL_POST_COLOR_MATRIX_COLOR_TABLE 
%%%% GL_CONVOLUTION_1D 
%%%% GL_CONVOLUTION_2D 
%%%% GL_SEPARABLE_2D 
%%%% GL_POST_CONVOLUTION_RED_SCALE 
%%%% GL_POST_CONVOLUTION_GREEN_SCALE 
%%%% GL_POST_CONVOLUTION_BLUE_SCALE 
%%%% GL_POST_CONVOLUTION_ALPHA_SCALE 
%%%% GL_POST_CONVOLUTION_RED_BIAS 
%%%% GL_POST_CONVOLUTION_GREEN_BIAS 
%%%% GL_POST_CONVOLUTION_BLUE_BIAS 
%%%% GL_POST_CONVOLUTION_ALPHA_BIAS 
%%%% GL_COLOR_MATRIX 
%%%% GL_COLOR_MATRIX_STACK_DEPTH 
%%%% GL_MAX_COLOR_MATRIX_STACK_DEPTH 
%%%% GL_POST_COLOR_MATRIX_RED_SCALE 
%%%% GL_POST_COLOR_MATRIX_GREEN_SCALE 
%%%% GL_POST_COLOR_MATRIX_BLUE_SCALE 
%%%% GL_POST_COLOR_MATRIX_ALPHA_SCALE 
%%%% GL_POST_COLOR_MATRIX_RED_BIAS 
%%%% GL_POST_COLOR_MATRIX_GREEN_BIAS 
%%%% GL_POST_COLOR_MATRIX_BLUE_BIAS 
%%%% GL_POST_COLOR_MATRIX_ALPHA_BIAS 
%%%% GL_HISTOGRAM 
%%%% GL_MINMAX 
%%%% GL_MAX_ELEMENTS_VERTICES 
%%%% GL_MAX_ELEMENTS_INDICES 
%%%% GL_RESCALE_NORMAL 
%%%% GL_LIGHT_MODEL_COLOR_CONTROL 
%%%% GL_PACK_SKIP_IMAGES 
%%%% GL_PACK_IMAGE_HEIGHT 
%%%% GL_UNPACK_SKIP_IMAGES 
%%%% GL_UNPACK_IMAGE_HEIGHT 
%%%% GL_TEXTURE_3D 
%%%% GL_MAX_3D_TEXTURE_SIZE 
%%%% GL_BLEND_COLOR 
%%%% GL_BLEND_EQUATION 
%%%% GL_ACTIVE_TEXTURE_ARB 
%%%% GL_CLIENT_ACTIVE_TEXTURE_ARB 
%%%% GL_MAX_TEXTURE_UNITS_ARB 
%%%% GetTextureParameter 
%%%% GL_TEXTURE_MAG_FILTER 
%%%% GL_TEXTURE_MIN_FILTER 
%%%% GL_TEXTURE_WRAP_S 
%%%% GL_TEXTURE_WRAP_T 
-define(GL_TEXTURE_WIDTH, 16#1000).
-define(GL_TEXTURE_HEIGHT, 16#1001).
-define(GL_TEXTURE_INTERNAL_FORMAT, 16#1003).
-define(GL_TEXTURE_BORDER_COLOR, 16#1004).
-define(GL_TEXTURE_BORDER, 16#1005).
%%%% GL_TEXTURE_RED_SIZE 
%%%% GL_TEXTURE_GREEN_SIZE 
%%%% GL_TEXTURE_BLUE_SIZE 
%%%% GL_TEXTURE_ALPHA_SIZE 
%%%% GL_TEXTURE_LUMINANCE_SIZE 
%%%% GL_TEXTURE_INTENSITY_SIZE 
%%%% GL_TEXTURE_PRIORITY 
%%%% GL_TEXTURE_RESIDENT 
%%%% GL_TEXTURE_DEPTH 
%%%% GL_TEXTURE_WRAP_R 
%%%% GL_TEXTURE_MIN_LOD 
%%%% GL_TEXTURE_MAX_LOD 
%%%% GL_TEXTURE_BASE_LEVEL 
%%%% GL_TEXTURE_MAX_LEVEL 
%%%% HintMode 
-define(GL_DONT_CARE, 16#1100).
-define(GL_FASTEST, 16#1101).
-define(GL_NICEST, 16#1102).
%%%% HintTarget 
%%%% GL_PERSPECTIVE_CORRECTION_HINT 
%%%% GL_POINT_SMOOTH_HINT 
%%%% GL_LINE_SMOOTH_HINT 
%%%% GL_POLYGON_SMOOTH_HINT 
%%%% GL_FOG_HINT 
%%%% HistogramTarget 
%%%% GL_HISTOGRAM 
%%%% GL_PROXY_HISTOGRAM 
%%%% IndexPointerType 
%%%% GL_SHORT 
%%%% GL_INT 
%%%% GL_FLOAT 
%%%% GL_DOUBLE 
%%%% LightModelColorControl 
%%%% GL_SINGLE_COLOR 
%%%% GL_SEPARATE_SPECULAR_COLOR 
%%%% LightModelParameter 
%%%% GL_LIGHT_MODEL_AMBIENT 
%%%% GL_LIGHT_MODEL_LOCAL_VIEWER 
%%%% GL_LIGHT_MODEL_TWO_SIDE 
%%%% GL_LIGHT_MODEL_COLOR_CONTROL 
%%%% LightName 
-define(GL_LIGHT0, 16#4000).
-define(GL_LIGHT1, 16#4001).
-define(GL_LIGHT2, 16#4002).
-define(GL_LIGHT3, 16#4003).
-define(GL_LIGHT4, 16#4004).
-define(GL_LIGHT5, 16#4005).
-define(GL_LIGHT6, 16#4006).
-define(GL_LIGHT7, 16#4007).
%%%% LightParameter 
-define(GL_AMBIENT, 16#1200).
-define(GL_DIFFUSE, 16#1201).
-define(GL_SPECULAR, 16#1202).
-define(GL_POSITION, 16#1203).
-define(GL_SPOT_DIRECTION, 16#1204).
-define(GL_SPOT_EXPONENT, 16#1205).
-define(GL_SPOT_CUTOFF, 16#1206).
-define(GL_CONSTANT_ATTENUATION, 16#1207).
-define(GL_LINEAR_ATTENUATION, 16#1208).
-define(GL_QUADRATIC_ATTENUATION, 16#1209).
%%%% InterleavedArrays 
%%%% GL_V2F 
%%%% GL_V3F 
%%%% GL_C4UB_V2F 
%%%% GL_C4UB_V3F 
%%%% GL_C3F_V3F 
%%%% GL_N3F_V3F 
%%%% GL_C4F_N3F_V3F 
%%%% GL_T2F_V3F 
%%%% GL_T4F_V4F 
%%%% GL_T2F_C4UB_V3F 
%%%% GL_T2F_C3F_V3F 
%%%% GL_T2F_N3F_V3F 
%%%% GL_T2F_C4F_N3F_V3F 
%%%% GL_T4F_C4F_N3F_V4F 
%%%% ListMode 
-define(GL_COMPILE, 16#1300).
-define(GL_COMPILE_AND_EXECUTE, 16#1301).
%%%% ListNameType 
%%%% GL_BYTE 
%%%% GL_UNSIGNED_BYTE 
%%%% GL_SHORT 
%%%% GL_UNSIGNED_SHORT 
%%%% GL_INT 
%%%% GL_UNSIGNED_INT 
%%%% GL_FLOAT 
%%%% GL_2_BYTES 
%%%% GL_3_BYTES 
%%%% GL_4_BYTES 
%%%% LogicOp 
-define(GL_CLEAR, 16#1500).
-define(GL_AND, 16#1501).
-define(GL_AND_REVERSE, 16#1502).
-define(GL_COPY, 16#1503).
-define(GL_AND_INVERTED, 16#1504).
-define(GL_NOOP, 16#1505).
-define(GL_XOR, 16#1506).
-define(GL_OR, 16#1507).
-define(GL_NOR, 16#1508).
-define(GL_EQUIV, 16#1509).
-define(GL_INVERT, 16#150A).
-define(GL_OR_REVERSE, 16#150B).
-define(GL_COPY_INVERTED, 16#150C).
-define(GL_OR_INVERTED, 16#150D).
-define(GL_NAND, 16#150E).
-define(GL_SET, 16#150F).
%%%% MapTarget 
%%%% GL_MAP1_COLOR_4 
%%%% GL_MAP1_INDEX 
%%%% GL_MAP1_NORMAL 
%%%% GL_MAP1_TEXTURE_COORD_1 
%%%% GL_MAP1_TEXTURE_COORD_2 
%%%% GL_MAP1_TEXTURE_COORD_3 
%%%% GL_MAP1_TEXTURE_COORD_4 
%%%% GL_MAP1_VERTEX_3 
%%%% GL_MAP1_VERTEX_4 
%%%% GL_MAP2_COLOR_4 
%%%% GL_MAP2_INDEX 
%%%% GL_MAP2_NORMAL 
%%%% GL_MAP2_TEXTURE_COORD_1 
%%%% GL_MAP2_TEXTURE_COORD_2 
%%%% GL_MAP2_TEXTURE_COORD_3 
%%%% GL_MAP2_TEXTURE_COORD_4 
%%%% GL_MAP2_VERTEX_3 
%%%% GL_MAP2_VERTEX_4 
%%%% MaterialFace 
%%%% GL_FRONT 
%%%% GL_BACK 
%%%% GL_FRONT_AND_BACK 
%%%% MaterialParameter 
-define(GL_EMISSION, 16#1600).
-define(GL_SHININESS, 16#1601).
-define(GL_AMBIENT_AND_DIFFUSE, 16#1602).
-define(GL_COLOR_INDEXES, 16#1603).
%%%% GL_AMBIENT 
%%%% GL_DIFFUSE 
%%%% GL_SPECULAR 
%%%% MatrixMode 
-define(GL_MODELVIEW, 16#1700).
-define(GL_PROJECTION, 16#1701).
-define(GL_TEXTURE, 16#1702).
%%%% MeshMode1 
%%%% GL_POINT 
%%%% GL_LINE 
%%%% MeshMode2 
%%%% GL_POINT 
%%%% GL_LINE 
%%%% GL_FILL 
%%%% MinmaxTarget 
%%%% GL_MINMAX 
%%%% NormalPointerType 
%%%% GL_BYTE 
%%%% GL_SHORT 
%%%% GL_INT 
%%%% GL_FLOAT 
%%%% GL_DOUBLE 
%%%% PixelCopyType 
-define(GL_COLOR, 16#1800).
-define(GL_DEPTH, 16#1801).
-define(GL_STENCIL, 16#1802).
%%%% PixelFormat 
-define(GL_COLOR_INDEX, 16#1900).
-define(GL_STENCIL_INDEX, 16#1901).
-define(GL_DEPTH_COMPONENT, 16#1902).
-define(GL_RED, 16#1903).
-define(GL_GREEN, 16#1904).
-define(GL_BLUE, 16#1905).
-define(GL_ALPHA, 16#1906).
-define(GL_RGB, 16#1907).
-define(GL_RGBA, 16#1908).
-define(GL_LUMINANCE, 16#1909).
-define(GL_LUMINANCE_ALPHA, 16#190A).
%%%% GL_ABGR 
%%%% PixelInternalFormat 
%%%% GL_ALPHA4 
%%%% GL_ALPHA8 
%%%% GL_ALPHA12 
%%%% GL_ALPHA16 
%%%% GL_LUMINANCE4 
%%%% GL_LUMINANCE8 
%%%% GL_LUMINANCE12 
%%%% GL_LUMINANCE16 
%%%% GL_LUMINANCE4_ALPHA4 
%%%% GL_LUMINANCE6_ALPHA2 
%%%% GL_LUMINANCE8_ALPHA8 
%%%% GL_LUMINANCE12_ALPHA4 
%%%% GL_LUMINANCE12_ALPHA12 
%%%% GL_LUMINANCE16_ALPHA16 
%%%% GL_INTENSITY 
%%%% GL_INTENSITY4 
%%%% GL_INTENSITY8 
%%%% GL_INTENSITY12 
%%%% GL_INTENSITY16 
%%%% GL_R3_G3_B2 
%%%% GL_RGB4 
%%%% GL_RGB5 
%%%% GL_RGB8 
%%%% GL_RGB10 
%%%% GL_RGB12 
%%%% GL_RGB16 
%%%% GL_RGBA2 
%%%% GL_RGBA4 
%%%% GL_RGB5_A1 
%%%% GL_RGBA8 
%%%% GL_RGB10_A2 
%%%% GL_RGBA12 
%%%% GL_RGBA16 
%%%% PixelMap 
%%%% GL_PIXEL_MAP_I_TO_I 
%%%% GL_PIXEL_MAP_S_TO_S 
%%%% GL_PIXEL_MAP_I_TO_R 
%%%% GL_PIXEL_MAP_I_TO_G 
%%%% GL_PIXEL_MAP_I_TO_B 
%%%% GL_PIXEL_MAP_I_TO_A 
%%%% GL_PIXEL_MAP_R_TO_R 
%%%% GL_PIXEL_MAP_G_TO_G 
%%%% GL_PIXEL_MAP_B_TO_B 
%%%% GL_PIXEL_MAP_A_TO_A 
%%%% PixelStore 
%%%% GL_UNPACK_SWAP_BYTES 
%%%% GL_UNPACK_LSB_FIRST 
%%%% GL_UNPACK_ROW_LENGTH 
%%%% GL_UNPACK_SKIP_ROWS 
%%%% GL_UNPACK_SKIP_PIXELS 
%%%% GL_UNPACK_ALIGNMENT 
%%%% GL_PACK_SWAP_BYTES 
%%%% GL_PACK_LSB_FIRST 
%%%% GL_PACK_ROW_LENGTH 
%%%% GL_PACK_SKIP_ROWS 
%%%% GL_PACK_SKIP_PIXELS 
%%%% GL_PACK_ALIGNMENT 
%%%% GL_PACK_SKIP_IMAGES 
%%%% GL_PACK_IMAGE_HEIGHT 
%%%% GL_UNPACK_SKIP_IMAGES 
%%%% GL_UNPACK_IMAGE_HEIGHT 
%%%% PixelTransfer 
%%%% GL_MAP_COLOR 
%%%% GL_MAP_STENCIL 
%%%% GL_INDEX_SHIFT 
%%%% GL_INDEX_OFFSET 
%%%% GL_RED_SCALE 
%%%% GL_RED_BIAS 
%%%% GL_GREEN_SCALE 
%%%% GL_GREEN_BIAS 
%%%% GL_BLUE_SCALE 
%%%% GL_BLUE_BIAS 
%%%% GL_ALPHA_SCALE 
%%%% GL_ALPHA_BIAS 
%%%% GL_DEPTH_SCALE 
%%%% GL_DEPTH_BIAS 
%%%% GL_POST_CONVOLUTION_RED_SCALE 
%%%% GL_POST_CONVOLUTION_GREEN_SCALE 
%%%% GL_POST_CONVOLUTION_BLUE_SCALE 
%%%% GL_POST_CONVOLUTION_ALPHA_SCALE 
%%%% GL_POST_CONVOLUTION_RED_BIAS 
%%%% GL_POST_CONVOLUTION_GREEN_BIAS 
%%%% GL_POST_CONVOLUTION_BLUE_BIAS 
%%%% GL_POST_CONVOLUTION_ALPHA_BIAS 
%%%% GL_POST_COLOR_MATRIX_RED_SCALE 
%%%% GL_POST_COLOR_MATRIX_GREEN_SCALE 
%%%% GL_POST_COLOR_MATRIX_BLUE_SCALE 
%%%% GL_POST_COLOR_MATRIX_ALPHA_SCALE 
%%%% GL_POST_COLOR_MATRIX_RED_BIAS 
%%%% GL_POST_COLOR_MATRIX_GREEN_BIAS 
%%%% GL_POST_COLOR_MATRIX_BLUE_BIAS 
%%%% GL_POST_COLOR_MATRIX_ALPHA_BIAS 
%%%% PixelType 
-define(GL_BITMAP, 16#1A00).
%%%% GL_BYTE 
%%%% GL_UNSIGNED_BYTE 
%%%% GL_SHORT 
%%%% GL_UNSIGNED_SHORT 
%%%% GL_INT 
%%%% GL_UNSIGNED_INT 
%%%% GL_FLOAT 
%%%% GL_BGR 
%%%% GL_BGRA 
%%%% GL_UNSIGNED_BYTE_3_3_2 
%%%% GL_UNSIGNED_SHORT_4_4_4_4 
%%%% GL_UNSIGNED_SHORT_5_5_5_1 
%%%% GL_UNSIGNED_INT_8_8_8_8 
%%%% GL_UNSIGNED_INT_10_10_10_2 
%%%% GL_UNSIGNED_SHORT_5_6_5 
%%%% GL_UNSIGNED_BYTE_2_3_3_REV 
%%%% GL_UNSIGNED_SHORT_5_6_5_REV 
%%%% GL_UNSIGNED_SHORT_4_4_4_4_REV 
%%%% GL_UNSIGNED_SHORT_1_5_5_5_REV 
%%%% GL_UNSIGNED_INT_8_8_8_8_REV 
%%%% GL_UNSIGNED_INT_2_10_10_10_REV 
%%%% PolygonMode 
-define(GL_POINT, 16#1B00).
-define(GL_LINE, 16#1B01).
-define(GL_FILL, 16#1B02).
%%%% ReadBufferMode 
%%%% GL_FRONT_LEFT 
%%%% GL_FRONT_RIGHT 
%%%% GL_BACK_LEFT 
%%%% GL_BACK_RIGHT 
%%%% GL_FRONT 
%%%% GL_BACK 
%%%% GL_LEFT 
%%%% GL_RIGHT 
%%%% GL_AUX0 
%%%% GL_AUX1 
%%%% GL_AUX2 
%%%% GL_AUX3 
%%%% RenderingMode 
-define(GL_RENDER, 16#1C00).
-define(GL_FEEDBACK, 16#1C01).
-define(GL_SELECT, 16#1C02).
%%%% SeparableTarget 
%%%% GL_SEPARABLE_2D 
%%%% ShadingModel 
-define(GL_FLAT, 16#1D00).
-define(GL_SMOOTH, 16#1D01).
%%%% StencilFunction 
%%%% GL_NEVER 
%%%% GL_LESS 
%%%% GL_EQUAL 
%%%% GL_LEQUAL 
%%%% GL_GREATER 
%%%% GL_NOTEQUAL 
%%%% GL_GEQUAL 
%%%% GL_ALWAYS 
%%%% StencilOp 
%%%% GL_ZERO 
-define(GL_KEEP, 16#1E00).
-define(GL_REPLACE, 16#1E01).
-define(GL_INCR, 16#1E02).
-define(GL_DECR, 16#1E03).
%%%% GL_INVERT 
%%%% StringName 
-define(GL_VENDOR, 16#1F00).
-define(GL_RENDERER, 16#1F01).
-define(GL_VERSION, 16#1F02).
-define(GL_EXTENSIONS, 16#1F03).
%%%% TextureCoordName 
-define(GL_S, 16#2000).
-define(GL_T, 16#2001).
-define(GL_R, 16#2002).
-define(GL_Q, 16#2003).
%%%% TexCoordPointerType 
%%%% GL_SHORT 
%%%% GL_INT 
%%%% GL_FLOAT 
%%%% GL_DOUBLE 
%%%% TextureEnvMode 
-define(GL_MODULATE, 16#2100).
-define(GL_DECAL, 16#2101).
%%%% GL_BLEND 
%%%% GL_REPLACE 
%%%% TextureEnvParameter 
-define(GL_TEXTURE_ENV_MODE, 16#2200).
-define(GL_TEXTURE_ENV_COLOR, 16#2201).
%%%% TextureEnvTarget 
-define(GL_TEXTURE_ENV, 16#2300).
%%%% TextureGenMode 
-define(GL_EYE_LINEAR, 16#2400).
-define(GL_OBJECT_LINEAR, 16#2401).
-define(GL_SPHERE_MAP, 16#2402).
%%%% TextureGenParameter 
-define(GL_TEXTURE_GEN_MODE, 16#2500).
-define(GL_OBJECT_PLANE, 16#2501).
-define(GL_EYE_PLANE, 16#2502).
%%%% TextureMagFilter 
-define(GL_NEAREST, 16#2600).
-define(GL_LINEAR, 16#2601).
%%%% TextureMinFilter 
%%%% GL_NEAREST 
%%%% GL_LINEAR 
-define(GL_NEAREST_MIPMAP_NEAREST, 16#2700).
-define(GL_LINEAR_MIPMAP_NEAREST, 16#2701).
-define(GL_NEAREST_MIPMAP_LINEAR, 16#2702).
-define(GL_LINEAR_MIPMAP_LINEAR, 16#2703).
%%%% TextureParameterName 
-define(GL_TEXTURE_MAG_FILTER, 16#2800).
-define(GL_TEXTURE_MIN_FILTER, 16#2801).
-define(GL_TEXTURE_WRAP_S, 16#2802).
-define(GL_TEXTURE_WRAP_T, 16#2803).
%%%% GL_TEXTURE_BORDER_COLOR 
%%%% GL_TEXTURE_PRIORITY 
%%%% GL_TEXTURE_WRAP_R 
%%%% GL_TEXTURE_MIN_LOD 
%%%% GL_TEXTURE_MAX_LOD 
%%%% GL_TEXTURE_BASE_LEVEL 
%%%% GL_TEXTURE_MAX_LEVEL 
%%%% TextureTarget 
%%%% GL_TEXTURE_1D 
%%%% GL_TEXTURE_2D 
%%%% GL_PROXY_TEXTURE_1D 
%%%% GL_PROXY_TEXTURE_2D 
%%%% GL_TEXTURE_3D 
%%%% GL_PROXY_TEXTURE_3D 
%%%% TextureUnit 
%%%% GL_TEXTURE0_ARB 
%%%% GL_TEXTURE1_ARB 
%%%% GL_TEXTURE2_ARB 
%%%% GL_TEXTURE3_ARB 
%%%% GL_TEXTURE4_ARB 
%%%% GL_TEXTURE5_ARB 
%%%% GL_TEXTURE6_ARB 
%%%% GL_TEXTURE7_ARB 
%%%% GL_TEXTURE8_ARB 
%%%% GL_TEXTURE9_ARB 
%%%% GL_TEXTURE10_ARB 
%%%% GL_TEXTURE11_ARB 
%%%% GL_TEXTURE12_ARB 
%%%% GL_TEXTURE13_ARB 
%%%% GL_TEXTURE14_ARB 
%%%% GL_TEXTURE15_ARB 
%%%% GL_TEXTURE16_ARB 
%%%% GL_TEXTURE17_ARB 
%%%% GL_TEXTURE18_ARB 
%%%% GL_TEXTURE19_ARB 
%%%% GL_TEXTURE20_ARB 
%%%% GL_TEXTURE21_ARB 
%%%% GL_TEXTURE22_ARB 
%%%% GL_TEXTURE23_ARB 
%%%% GL_TEXTURE24_ARB 
%%%% GL_TEXTURE25_ARB 
%%%% GL_TEXTURE26_ARB 
%%%% GL_TEXTURE27_ARB 
%%%% GL_TEXTURE28_ARB 
%%%% GL_TEXTURE29_ARB 
%%%% GL_TEXTURE30_ARB 
%%%% GL_TEXTURE31_ARB 
%%%% TextureWrapMode 
-define(GL_CLAMP, 16#2900).
-define(GL_REPEAT, 16#2901).
%%%% GL_CLAMP_TO_EDGE 
%%%% VertexPointerType 
%%%% GL_SHORT 
%%%% GL_INT 
%%%% GL_FLOAT 
%%%% GL_DOUBLE 
%%%% ClientAttribMask 
-define(GL_CLIENT_PIXEL_STORE_BIT, 16#00000001).
-define(GL_CLIENT_VERTEX_ARRAY_BIT, 16#00000002).
-define(GL_CLIENT_ALL_ATTRIB_BITS, 16#ffffffff).
%%%% polygon_offset 
-define(GL_POLYGON_OFFSET_FACTOR, 16#8038).
-define(GL_POLYGON_OFFSET_UNITS, 16#2A00).
-define(GL_POLYGON_OFFSET_POINT, 16#2A01).
-define(GL_POLYGON_OFFSET_LINE, 16#2A02).
-define(GL_POLYGON_OFFSET_FILL, 16#8037).
%%%% texture 
-define(GL_ALPHA4, 16#803B).
-define(GL_ALPHA8, 16#803C).
-define(GL_ALPHA12, 16#803D).
-define(GL_ALPHA16, 16#803E).
-define(GL_LUMINANCE4, 16#803F).
-define(GL_LUMINANCE8, 16#8040).
-define(GL_LUMINANCE12, 16#8041).
-define(GL_LUMINANCE16, 16#8042).
-define(GL_LUMINANCE4_ALPHA4, 16#8043).
-define(GL_LUMINANCE6_ALPHA2, 16#8044).
-define(GL_LUMINANCE8_ALPHA8, 16#8045).
-define(GL_LUMINANCE12_ALPHA4, 16#8046).
-define(GL_LUMINANCE12_ALPHA12, 16#8047).
-define(GL_LUMINANCE16_ALPHA16, 16#8048).
-define(GL_INTENSITY, 16#8049).
-define(GL_INTENSITY4, 16#804A).
-define(GL_INTENSITY8, 16#804B).
-define(GL_INTENSITY12, 16#804C).
-define(GL_INTENSITY16, 16#804D).
-define(GL_R3_G3_B2, 16#2A10).
-define(GL_RGB4, 16#804F).
-define(GL_RGB5, 16#8050).
-define(GL_RGB8, 16#8051).
-define(GL_RGB10, 16#8052).
-define(GL_RGB12, 16#8053).
-define(GL_RGB16, 16#8054).
-define(GL_RGBA2, 16#8055).
-define(GL_RGBA4, 16#8056).
-define(GL_RGB5_A1, 16#8057).
-define(GL_RGBA8, 16#8058).
-define(GL_RGB10_A2, 16#8059).
-define(GL_RGBA12, 16#805A).
-define(GL_RGBA16, 16#805B).
-define(GL_TEXTURE_RED_SIZE, 16#805C).
-define(GL_TEXTURE_GREEN_SIZE, 16#805D).
-define(GL_TEXTURE_BLUE_SIZE, 16#805E).
-define(GL_TEXTURE_ALPHA_SIZE, 16#805F).
-define(GL_TEXTURE_LUMINANCE_SIZE, 16#8060).
-define(GL_TEXTURE_INTENSITY_SIZE, 16#8061).
-define(GL_PROXY_TEXTURE_1D, 16#8063).
-define(GL_PROXY_TEXTURE_2D, 16#8064).
%%%% texture_object 
-define(GL_TEXTURE_PRIORITY, 16#8066).
-define(GL_TEXTURE_RESIDENT, 16#8067).
-define(GL_TEXTURE_BINDING_1D, 16#8068).
-define(GL_TEXTURE_BINDING_2D, 16#8069).
-define(GL_TEXTURE_BINDING_3D, 16#806A).
%%%% vertex_array 
-define(GL_VERTEX_ARRAY, 16#8074).
-define(GL_NORMAL_ARRAY, 16#8075).
-define(GL_COLOR_ARRAY, 16#8076).
-define(GL_INDEX_ARRAY, 16#8077).
-define(GL_TEXTURE_COORD_ARRAY, 16#8078).
-define(GL_EDGE_FLAG_ARRAY, 16#8079).
-define(GL_VERTEX_ARRAY_SIZE, 16#807A).
-define(GL_VERTEX_ARRAY_TYPE, 16#807B).
-define(GL_VERTEX_ARRAY_STRIDE, 16#807C).
-define(GL_NORMAL_ARRAY_TYPE, 16#807E).
-define(GL_NORMAL_ARRAY_STRIDE, 16#807F).
-define(GL_COLOR_ARRAY_SIZE, 16#8081).
-define(GL_COLOR_ARRAY_TYPE, 16#8082).
-define(GL_COLOR_ARRAY_STRIDE, 16#8083).
-define(GL_INDEX_ARRAY_TYPE, 16#8085).
-define(GL_INDEX_ARRAY_STRIDE, 16#8086).
-define(GL_TEXTURE_COORD_ARRAY_SIZE, 16#8088).
-define(GL_TEXTURE_COORD_ARRAY_TYPE, 16#8089).
-define(GL_TEXTURE_COORD_ARRAY_STRIDE, 16#808A).
-define(GL_EDGE_FLAG_ARRAY_STRIDE, 16#808C).
-define(GL_VERTEX_ARRAY_POINTER, 16#808E).
-define(GL_NORMAL_ARRAY_POINTER, 16#808F).
-define(GL_COLOR_ARRAY_POINTER, 16#8090).
-define(GL_INDEX_ARRAY_POINTER, 16#8091).
-define(GL_TEXTURE_COORD_ARRAY_POINTER, 16#8092).
-define(GL_EDGE_FLAG_ARRAY_POINTER, 16#8093).
-define(GL_V2F, 16#2A20).
-define(GL_V3F, 16#2A21).
-define(GL_C4UB_V2F, 16#2A22).
-define(GL_C4UB_V3F, 16#2A23).
-define(GL_C3F_V3F, 16#2A24).
-define(GL_N3F_V3F, 16#2A25).
-define(GL_C4F_N3F_V3F, 16#2A26).
-define(GL_T2F_V3F, 16#2A27).
-define(GL_T4F_V4F, 16#2A28).
-define(GL_T2F_C4UB_V3F, 16#2A29).
-define(GL_T2F_C3F_V3F, 16#2A2A).
-define(GL_T2F_N3F_V3F, 16#2A2B).
-define(GL_T2F_C4F_N3F_V3F, 16#2A2C).
-define(GL_T4F_C4F_N3F_V4F, 16#2A2D).
%%%% bgra 
-define(GL_BGR, 16#80E0).
-define(GL_BGRA, 16#80E1).
%%%% blend_color 
-define(GL_CONSTANT_COLOR, 16#8001).
-define(GL_ONE_MINUS_CONSTANT_COLOR, 16#8002).
-define(GL_CONSTANT_ALPHA, 16#8003).
-define(GL_ONE_MINUS_CONSTANT_ALPHA, 16#8004).
-define(GL_BLEND_COLOR, 16#8005).
%%%% blend_minmax 
-define(GL_FUNC_ADD, 16#8006).
-define(GL_MIN, 16#8007).
-define(GL_MAX, 16#8008).
-define(GL_BLEND_EQUATION, 16#8009).
%%%% blend_subtract 
-define(GL_FUNC_SUBTRACT, 16#800A).
-define(GL_FUNC_REVERSE_SUBTRACT, 16#800B).
%%%% color_matrix 
-define(GL_COLOR_MATRIX, 16#80B1).
-define(GL_COLOR_MATRIX_STACK_DEPTH, 16#80B2).
-define(GL_MAX_COLOR_MATRIX_STACK_DEPTH, 16#80B3).
-define(GL_POST_COLOR_MATRIX_RED_SCALE, 16#80B4).
-define(GL_POST_COLOR_MATRIX_GREEN_SCALE, 16#80B5).
-define(GL_POST_COLOR_MATRIX_BLUE_SCALE, 16#80B6).
-define(GL_POST_COLOR_MATRIX_ALPHA_SCALE, 16#80B7).
-define(GL_POST_COLOR_MATRIX_RED_BIAS, 16#80B8).
-define(GL_POST_COLOR_MATRIX_GREEN_BIAS, 16#80B9).
-define(GL_POST_COLOR_MATRIX_BLUE_BIAS, 16#80BA).
-define(GL_POST_COLOR_MATRIX_ALPHA_BIAS, 16#80BB).
%%%% color_table 
-define(GL_COLOR_TABLE, 16#80D0).
-define(GL_POST_CONVOLUTION_COLOR_TABLE, 16#80D1).
-define(GL_POST_COLOR_MATRIX_COLOR_TABLE, 16#80D2).
-define(GL_PROXY_COLOR_TABLE, 16#80D3).
-define(GL_PROXY_POST_CONVOLUTION_COLOR_TABLE, 16#80D4).
-define(GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE, 16#80D5).
-define(GL_COLOR_TABLE_SCALE, 16#80D6).
-define(GL_COLOR_TABLE_BIAS, 16#80D7).
-define(GL_COLOR_TABLE_FORMAT, 16#80D8).
-define(GL_COLOR_TABLE_WIDTH, 16#80D9).
-define(GL_COLOR_TABLE_RED_SIZE, 16#80DA).
-define(GL_COLOR_TABLE_GREEN_SIZE, 16#80DB).
-define(GL_COLOR_TABLE_BLUE_SIZE, 16#80DC).
-define(GL_COLOR_TABLE_ALPHA_SIZE, 16#80DD).
-define(GL_COLOR_TABLE_LUMINANCE_SIZE, 16#80DE).
-define(GL_COLOR_TABLE_INTENSITY_SIZE, 16#80DF).
%%%% convolution 
-define(GL_CONVOLUTION_1D, 16#8010).
-define(GL_CONVOLUTION_2D, 16#8011).
-define(GL_SEPARABLE_2D, 16#8012).
-define(GL_CONVOLUTION_BORDER_MODE, 16#8013).
-define(GL_CONVOLUTION_FILTER_SCALE, 16#8014).
-define(GL_CONVOLUTION_FILTER_BIAS, 16#8015).
-define(GL_REDUCE, 16#8016).
-define(GL_CONVOLUTION_FORMAT, 16#8017).
-define(GL_CONVOLUTION_WIDTH, 16#8018).
-define(GL_CONVOLUTION_HEIGHT, 16#8019).
-define(GL_MAX_CONVOLUTION_WIDTH, 16#801A).
-define(GL_MAX_CONVOLUTION_HEIGHT, 16#801B).
-define(GL_POST_CONVOLUTION_RED_SCALE, 16#801C).
-define(GL_POST_CONVOLUTION_GREEN_SCALE, 16#801D).
-define(GL_POST_CONVOLUTION_BLUE_SCALE, 16#801E).
-define(GL_POST_CONVOLUTION_ALPHA_SCALE, 16#801F).
-define(GL_POST_CONVOLUTION_RED_BIAS, 16#8020).
-define(GL_POST_CONVOLUTION_GREEN_BIAS, 16#8021).
-define(GL_POST_CONVOLUTION_BLUE_BIAS, 16#8022).
-define(GL_POST_CONVOLUTION_ALPHA_BIAS, 16#8023).
-define(GL_CONSTANT_BORDER, 16#8151).
-define(GL_REPLICATE_BORDER, 16#8153).
-define(GL_CONVOLUTION_BORDER_COLOR, 16#8154).
%%%% draw_range_elements 
-define(GL_MAX_ELEMENTS_VERTICES, 16#80E8).
-define(GL_MAX_ELEMENTS_INDICES, 16#80E9).
%%%% histogram 
-define(GL_HISTOGRAM, 16#8024).
-define(GL_PROXY_HISTOGRAM, 16#8025).
-define(GL_HISTOGRAM_WIDTH, 16#8026).
-define(GL_HISTOGRAM_FORMAT, 16#8027).
-define(GL_HISTOGRAM_RED_SIZE, 16#8028).
-define(GL_HISTOGRAM_GREEN_SIZE, 16#8029).
-define(GL_HISTOGRAM_BLUE_SIZE, 16#802A).
-define(GL_HISTOGRAM_ALPHA_SIZE, 16#802B).
-define(GL_HISTOGRAM_LUMINANCE_SIZE, 16#802C).
-define(GL_HISTOGRAM_SINK, 16#802D).
-define(GL_MINMAX, 16#802E).
-define(GL_MINMAX_FORMAT, 16#802F).
-define(GL_MINMAX_SINK, 16#8030).
-define(GL_TABLE_TOO_LARGE, 16#8031).
%%%% packed_pixels 
-define(GL_UNSIGNED_BYTE_3_3_2, 16#8032).
-define(GL_UNSIGNED_SHORT_4_4_4_4, 16#8033).
-define(GL_UNSIGNED_SHORT_5_5_5_1, 16#8034).
-define(GL_UNSIGNED_INT_8_8_8_8, 16#8035).
-define(GL_UNSIGNED_INT_10_10_10_2, 16#8036).
-define(GL_UNSIGNED_BYTE_2_3_3_REV, 16#8362).
-define(GL_UNSIGNED_SHORT_5_6_5, 16#8363).
-define(GL_UNSIGNED_SHORT_5_6_5_REV, 16#8364).
-define(GL_UNSIGNED_SHORT_4_4_4_4_REV, 16#8365).
-define(GL_UNSIGNED_SHORT_1_5_5_5_REV, 16#8366).
-define(GL_UNSIGNED_INT_8_8_8_8_REV, 16#8367).
-define(GL_UNSIGNED_INT_2_10_10_10_REV, 16#8368).
%%%% rescale_normal 
-define(GL_RESCALE_NORMAL, 16#803A).
%%%% separate_specular_color 
-define(GL_LIGHT_MODEL_COLOR_CONTROL, 16#81F8).
-define(GL_SINGLE_COLOR, 16#81F9).
-define(GL_SEPARATE_SPECULAR_COLOR, 16#81FA).
%%%% texture3D 
-define(GL_PACK_SKIP_IMAGES, 16#806B).
-define(GL_PACK_IMAGE_HEIGHT, 16#806C).
-define(GL_UNPACK_SKIP_IMAGES, 16#806D).
-define(GL_UNPACK_IMAGE_HEIGHT, 16#806E).
-define(GL_TEXTURE_3D, 16#806F).
-define(GL_PROXY_TEXTURE_3D, 16#8070).
-define(GL_TEXTURE_DEPTH, 16#8071).
-define(GL_TEXTURE_WRAP_R, 16#8072).
-define(GL_MAX_3D_TEXTURE_SIZE, 16#8073).
%%%% texture_edge_clamp 
-define(GL_CLAMP_TO_EDGE, 16#812F).
%%%% texture_lod 
-define(GL_TEXTURE_MIN_LOD, 16#813A).
-define(GL_TEXTURE_MAX_LOD, 16#813B).
-define(GL_TEXTURE_BASE_LEVEL, 16#813C).
-define(GL_TEXTURE_MAX_LEVEL, 16#813D).
%%%% GetTarget1_2 
-define(GL_SMOOTH_POINT_SIZE_RANGE, 16#0B12).
-define(GL_SMOOTH_POINT_SIZE_GRANULARITY, 16#0B13).
-define(GL_SMOOTH_LINE_WIDTH_RANGE, 16#0B22).
-define(GL_SMOOTH_LINE_WIDTH_GRANULARITY, 16#0B23).
-define(GL_ALIASED_POINT_SIZE_RANGE, 16#846D).
-define(GL_ALIASED_LINE_WIDTH_RANGE, 16#846E).
%%%% multitexture 
-define(GL_TEXTURE0_ARB, 16#84C0).
-define(GL_TEXTURE0, 16#84C0).
-define(GL_TEXTURE1_ARB, 16#84C1).
-define(GL_TEXTURE1, 16#84C1).
-define(GL_TEXTURE2_ARB, 16#84C2).
-define(GL_TEXTURE2, 16#84C2).
-define(GL_TEXTURE3_ARB, 16#84C3).
-define(GL_TEXTURE3, 16#84C3).
-define(GL_TEXTURE4_ARB, 16#84C4).
-define(GL_TEXTURE4, 16#84C4).
-define(GL_TEXTURE5_ARB, 16#84C5).
-define(GL_TEXTURE5, 16#84C5).
-define(GL_TEXTURE6_ARB, 16#84C6).
-define(GL_TEXTURE6, 16#84C6).
-define(GL_TEXTURE7_ARB, 16#84C7).
-define(GL_TEXTURE7, 16#84C7).
-define(GL_TEXTURE8_ARB, 16#84C8).
-define(GL_TEXTURE8, 16#84C8).
-define(GL_TEXTURE9_ARB, 16#84C9).
-define(GL_TEXTURE9, 16#84C9).
-define(GL_TEXTURE10_ARB, 16#84CA).
-define(GL_TEXTURE10, 16#84CA).
-define(GL_TEXTURE11_ARB, 16#84CB).
-define(GL_TEXTURE11, 16#84CB).
-define(GL_TEXTURE12_ARB, 16#84CC).
-define(GL_TEXTURE12, 16#84CC).
-define(GL_TEXTURE13_ARB, 16#84CD).
-define(GL_TEXTURE13, 16#84CD).
-define(GL_TEXTURE14_ARB, 16#84CE).
-define(GL_TEXTURE14, 16#84CE).
-define(GL_TEXTURE15_ARB, 16#84CF).
-define(GL_TEXTURE15, 16#84CF).
-define(GL_TEXTURE16_ARB, 16#84D0).
-define(GL_TEXTURE16, 16#84D0).
-define(GL_TEXTURE17_ARB, 16#84D1).
-define(GL_TEXTURE17, 16#84D1).
-define(GL_TEXTURE18_ARB, 16#84D2).
-define(GL_TEXTURE18, 16#84D2).
-define(GL_TEXTURE19_ARB, 16#84D3).
-define(GL_TEXTURE19, 16#84D3).
-define(GL_TEXTURE20_ARB, 16#84D4).
-define(GL_TEXTURE20, 16#84D4).
-define(GL_TEXTURE21_ARB, 16#84D5).
-define(GL_TEXTURE21, 16#84D5).
-define(GL_TEXTURE22_ARB, 16#84D6).
-define(GL_TEXTURE22, 16#84D6).
-define(GL_TEXTURE23_ARB, 16#84D7).
-define(GL_TEXTURE23, 16#84D7).
-define(GL_TEXTURE24_ARB, 16#84D8).
-define(GL_TEXTURE24, 16#84D8).
-define(GL_TEXTURE25_ARB, 16#84D9).
-define(GL_TEXTURE25, 16#84D9).
-define(GL_TEXTURE26_ARB, 16#84DA).
-define(GL_TEXTURE26, 16#84DA).
-define(GL_TEXTURE27_ARB, 16#84DB).
-define(GL_TEXTURE27, 16#84DB).
-define(GL_TEXTURE28_ARB, 16#84DC).
-define(GL_TEXTURE28, 16#84DC).
-define(GL_TEXTURE29_ARB, 16#84DD).
-define(GL_TEXTURE29, 16#84DD).
-define(GL_TEXTURE30_ARB, 16#84DE).
-define(GL_TEXTURE30, 16#84DE).
-define(GL_TEXTURE31_ARB, 16#84DF).
-define(GL_TEXTURE31, 16#84DF).
-define(GL_ACTIVE_TEXTURE_ARB, 16#84E0).
-define(GL_ACTIVE_TEXTURE, 16#84E0).
-define(GL_CLIENT_ACTIVE_TEXTURE_ARB, 16#84E1).
-define(GL_CLIENT_ACTIVE_TEXTURE, 16#84E1).
-define(GL_MAX_TEXTURE_UNITS_ARB, 16#84E2).
-define(GL_MAX_TEXTURE_UNITS, 16#84E2).
%%%% Extensions 
-define(GL_EXT_abgr, 1).
-define(GL_EXT_blend_color, 1).
-define(GL_EXT_blend_minmax, 1).
-define(GL_EXT_blend_subtract, 1).
-define(GL_EXT_texture_env_combine, 1).
-define(GL_EXT_texture_env_add, 1).
%%%% EXT_abgr 
-define(GL_ABGR_EXT, 16#8000).
%%%% EXT_blend_color 
-define(GL_CONSTANT_COLOR_EXT, 16#8001).
-define(GL_ONE_MINUS_CONSTANT_COLOR_EXT, 16#8002).
-define(GL_CONSTANT_ALPHA_EXT, 16#8003).
-define(GL_ONE_MINUS_CONSTANT_ALPHA_EXT, 16#8004).
-define(GL_BLEND_COLOR_EXT, 16#8005).
%%%% EXT_blend_minmax 
-define(GL_FUNC_ADD_EXT, 16#8006).
-define(GL_MIN_EXT, 16#8007).
-define(GL_MAX_EXT, 16#8008).
-define(GL_BLEND_EQUATION_EXT, 16#8009).
%%%% EXT_blend_subtract 
-define(GL_FUNC_SUBTRACT_EXT, 16#800A).
-define(GL_FUNC_REVERSE_SUBTRACT_EXT, 16#800B).
%%%% EXT_texture_env_combine 
-define(GL_COMBINE_EXT, 16#8570).
-define(GL_COMBINE_RGB_EXT, 16#8571).
-define(GL_COMBINE_ALPHA_EXT, 16#8572).
-define(GL_RGB_SCALE_EXT, 16#8573).
-define(GL_ADD_SIGNED_EXT, 16#8574).
-define(GL_INTERPOLATE_EXT, 16#8575).
-define(GL_CONSTANT_EXT, 16#8576).
-define(GL_PRIMARY_COLOR_EXT, 16#8577).
-define(GL_PREVIOUS_EXT, 16#8578).
-define(GL_SOURCE0_RGB_EXT, 16#8580).
-define(GL_SOURCE1_RGB_EXT, 16#8581).
-define(GL_SOURCE2_RGB_EXT, 16#8582).
-define(GL_SOURCE0_ALPHA_EXT, 16#8588).
-define(GL_SOURCE1_ALPHA_EXT, 16#8589).
-define(GL_SOURCE2_ALPHA_EXT, 16#858A).
-define(GL_OPERAND0_RGB_EXT, 16#8590).
-define(GL_OPERAND1_RGB_EXT, 16#8591).
-define(GL_OPERAND2_RGB_EXT, 16#8592).
-define(GL_OPERAND0_ALPHA_EXT, 16#8598).
-define(GL_OPERAND1_ALPHA_EXT, 16#8599).
-define(GL_OPERAND2_ALPHA_EXT, 16#859A).
%%%% For compatibility with OpenGL v1.0 
-define(GL_LOGIC_OP, GL_INDEX_LOGIC_OP).
-define(GL_TEXTURE_COMPONENTS, GL_TEXTURE_INTERNAL_FORMAT).

%%% OpenGL v1.2 and later

-define(__glext_h_, 1).

-define(GL_GLEXT_VERSION, 22).
-ifndef(GL_VERSION_1_2).
-define(GL_UNSIGNED_BYTE_3_3_2, 16#8032).
-define(GL_UNSIGNED_SHORT_4_4_4_4, 16#8033).
-define(GL_UNSIGNED_SHORT_5_5_5_1, 16#8034).
-define(GL_UNSIGNED_INT_8_8_8_8, 16#8035).
-define(GL_UNSIGNED_INT_10_10_10_2, 16#8036).
-define(GL_RESCALE_NORMAL, 16#803A).
-define(GL_TEXTURE_BINDING_3D, 16#806A).
-define(GL_PACK_SKIP_IMAGES, 16#806B).
-define(GL_PACK_IMAGE_HEIGHT, 16#806C).
-define(GL_UNPACK_SKIP_IMAGES, 16#806D).
-define(GL_UNPACK_IMAGE_HEIGHT, 16#806E).
-define(GL_TEXTURE_3D, 16#806F).
-define(GL_PROXY_TEXTURE_3D, 16#8070).
-define(GL_TEXTURE_DEPTH, 16#8071).
-define(GL_TEXTURE_WRAP_R, 16#8072).
-define(GL_MAX_3D_TEXTURE_SIZE, 16#8073).
-define(GL_UNSIGNED_BYTE_2_3_3_REV, 16#8362).
-define(GL_UNSIGNED_SHORT_5_6_5, 16#8363).
-define(GL_UNSIGNED_SHORT_5_6_5_REV, 16#8364).
-define(GL_UNSIGNED_SHORT_4_4_4_4_REV, 16#8365).
-define(GL_UNSIGNED_SHORT_1_5_5_5_REV, 16#8366).
-define(GL_UNSIGNED_INT_8_8_8_8_REV, 16#8367).
-define(GL_UNSIGNED_INT_2_10_10_10_REV, 16#8368).
-define(GL_BGR, 16#80E0).
-define(GL_BGRA, 16#80E1).
-define(GL_MAX_ELEMENTS_VERTICES, 16#80E8).
-define(GL_MAX_ELEMENTS_INDICES, 16#80E9).
-define(GL_CLAMP_TO_EDGE, 16#812F).
-define(GL_TEXTURE_MIN_LOD, 16#813A).
-define(GL_TEXTURE_MAX_LOD, 16#813B).
-define(GL_TEXTURE_BASE_LEVEL, 16#813C).
-define(GL_TEXTURE_MAX_LEVEL, 16#813D).
-define(GL_LIGHT_MODEL_COLOR_CONTROL, 16#81F8).
-define(GL_SINGLE_COLOR, 16#81F9).
-define(GL_SEPARATE_SPECULAR_COLOR, 16#81FA).
-define(GL_SMOOTH_POINT_SIZE_RANGE, 16#0B12).
-define(GL_SMOOTH_POINT_SIZE_GRANULARITY, 16#0B13).
-define(GL_SMOOTH_LINE_WIDTH_RANGE, 16#0B22).
-define(GL_SMOOTH_LINE_WIDTH_GRANULARITY, 16#0B23).
-define(GL_ALIASED_POINT_SIZE_RANGE, 16#846D).
-define(GL_ALIASED_LINE_WIDTH_RANGE, 16#846E).
-endif.
-ifndef(GL_ARB_imaging).
-define(GL_CONSTANT_COLOR, 16#8001).
-define(GL_ONE_MINUS_CONSTANT_COLOR, 16#8002).
-define(GL_CONSTANT_ALPHA, 16#8003).
-define(GL_ONE_MINUS_CONSTANT_ALPHA, 16#8004).
-define(GL_BLEND_COLOR, 16#8005).
-define(GL_FUNC_ADD, 16#8006).
-define(GL_MIN, 16#8007).
-define(GL_MAX, 16#8008).
-define(GL_BLEND_EQUATION, 16#8009).
-define(GL_FUNC_SUBTRACT, 16#800A).
-define(GL_FUNC_REVERSE_SUBTRACT, 16#800B).
-define(GL_CONVOLUTION_1D, 16#8010).
-define(GL_CONVOLUTION_2D, 16#8011).
-define(GL_SEPARABLE_2D, 16#8012).
-define(GL_CONVOLUTION_BORDER_MODE, 16#8013).
-define(GL_CONVOLUTION_FILTER_SCALE, 16#8014).
-define(GL_CONVOLUTION_FILTER_BIAS, 16#8015).
-define(GL_REDUCE, 16#8016).
-define(GL_CONVOLUTION_FORMAT, 16#8017).
-define(GL_CONVOLUTION_WIDTH, 16#8018).
-define(GL_CONVOLUTION_HEIGHT, 16#8019).
-define(GL_MAX_CONVOLUTION_WIDTH, 16#801A).
-define(GL_MAX_CONVOLUTION_HEIGHT, 16#801B).
-define(GL_POST_CONVOLUTION_RED_SCALE, 16#801C).
-define(GL_POST_CONVOLUTION_GREEN_SCALE, 16#801D).
-define(GL_POST_CONVOLUTION_BLUE_SCALE, 16#801E).
-define(GL_POST_CONVOLUTION_ALPHA_SCALE, 16#801F).
-define(GL_POST_CONVOLUTION_RED_BIAS, 16#8020).
-define(GL_POST_CONVOLUTION_GREEN_BIAS, 16#8021).
-define(GL_POST_CONVOLUTION_BLUE_BIAS, 16#8022).
-define(GL_POST_CONVOLUTION_ALPHA_BIAS, 16#8023).
-define(GL_HISTOGRAM, 16#8024).
-define(GL_PROXY_HISTOGRAM, 16#8025).
-define(GL_HISTOGRAM_WIDTH, 16#8026).
-define(GL_HISTOGRAM_FORMAT, 16#8027).
-define(GL_HISTOGRAM_RED_SIZE, 16#8028).
-define(GL_HISTOGRAM_GREEN_SIZE, 16#8029).
-define(GL_HISTOGRAM_BLUE_SIZE, 16#802A).
-define(GL_HISTOGRAM_ALPHA_SIZE, 16#802B).
-define(GL_HISTOGRAM_LUMINANCE_SIZE, 16#802C).
-define(GL_HISTOGRAM_SINK, 16#802D).
-define(GL_MINMAX, 16#802E).
-define(GL_MINMAX_FORMAT, 16#802F).
-define(GL_MINMAX_SINK, 16#8030).
-define(GL_TABLE_TOO_LARGE, 16#8031).
-define(GL_COLOR_MATRIX, 16#80B1).
-define(GL_COLOR_MATRIX_STACK_DEPTH, 16#80B2).
-define(GL_MAX_COLOR_MATRIX_STACK_DEPTH, 16#80B3).
-define(GL_POST_COLOR_MATRIX_RED_SCALE, 16#80B4).
-define(GL_POST_COLOR_MATRIX_GREEN_SCALE, 16#80B5).
-define(GL_POST_COLOR_MATRIX_BLUE_SCALE, 16#80B6).
-define(GL_POST_COLOR_MATRIX_ALPHA_SCALE, 16#80B7).
-define(GL_POST_COLOR_MATRIX_RED_BIAS, 16#80B8).
-define(GL_POST_COLOR_MATRIX_GREEN_BIAS, 16#80B9).
-define(GL_POST_COLOR_MATRIX_BLUE_BIAS, 16#80BA).
-define(GL_POST_COLOR_MATRIX_ALPHA_BIAS, 16#80BB).
-define(GL_COLOR_TABLE, 16#80D0).
-define(GL_POST_CONVOLUTION_COLOR_TABLE, 16#80D1).
-define(GL_POST_COLOR_MATRIX_COLOR_TABLE, 16#80D2).
-define(GL_PROXY_COLOR_TABLE, 16#80D3).
-define(GL_PROXY_POST_CONVOLUTION_COLOR_TABLE, 16#80D4).
-define(GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE, 16#80D5).
-define(GL_COLOR_TABLE_SCALE, 16#80D6).
-define(GL_COLOR_TABLE_BIAS, 16#80D7).
-define(GL_COLOR_TABLE_FORMAT, 16#80D8).
-define(GL_COLOR_TABLE_WIDTH, 16#80D9).
-define(GL_COLOR_TABLE_RED_SIZE, 16#80DA).
-define(GL_COLOR_TABLE_GREEN_SIZE, 16#80DB).
-define(GL_COLOR_TABLE_BLUE_SIZE, 16#80DC).
-define(GL_COLOR_TABLE_ALPHA_SIZE, 16#80DD).
-define(GL_COLOR_TABLE_LUMINANCE_SIZE, 16#80DE).
-define(GL_COLOR_TABLE_INTENSITY_SIZE, 16#80DF).
-define(GL_CONSTANT_BORDER, 16#8151).
-define(GL_REPLICATE_BORDER, 16#8153).
-define(GL_CONVOLUTION_BORDER_COLOR, 16#8154).
-endif.
-ifndef(GL_VERSION_1_3).
%-define(GL_TEXTURE0, 16#84C0).
%-define(GL_TEXTURE1, 16#84C1).
%-define(GL_TEXTURE2, 16#84C2).
%-define(GL_TEXTURE3, 16#84C3).
%-define(GL_TEXTURE4, 16#84C4).
%-define(GL_TEXTURE5, 16#84C5).
%-define(GL_TEXTURE6, 16#84C6).
%-define(GL_TEXTURE7, 16#84C7).
% -define(GL_TEXTURE8, 16#84C8).
% -define(GL_TEXTURE9, 16#84C9).
% -define(GL_TEXTURE10, 16#84CA).
% -define(GL_TEXTURE11, 16#84CB).
% -define(GL_TEXTURE12, 16#84CC).
% -define(GL_TEXTURE13, 16#84CD).
% -define(GL_TEXTURE14, 16#84CE).
% -define(GL_TEXTURE15, 16#84CF).
% -define(GL_TEXTURE16, 16#84D0).
% -define(GL_TEXTURE17, 16#84D1).
% -define(GL_TEXTURE18, 16#84D2).
% -define(GL_TEXTURE19, 16#84D3).
% -define(GL_TEXTURE20, 16#84D4).
% -define(GL_TEXTURE21, 16#84D5).
% -define(GL_TEXTURE22, 16#84D6).
% -define(GL_TEXTURE23, 16#84D7).
% -define(GL_TEXTURE24, 16#84D8).
% -define(GL_TEXTURE25, 16#84D9).
% -define(GL_TEXTURE26, 16#84DA).
% -define(GL_TEXTURE27, 16#84DB).
% -define(GL_TEXTURE28, 16#84DC).
% -define(GL_TEXTURE29, 16#84DD).
% -define(GL_TEXTURE30, 16#84DE).
% -define(GL_TEXTURE31, 16#84DF).
% -define(GL_ACTIVE_TEXTURE, 16#84E0).
% -define(GL_CLIENT_ACTIVE_TEXTURE, 16#84E1).
% -define(GL_MAX_TEXTURE_UNITS, 16#84E2).
-define(GL_TRANSPOSE_MODELVIEW_MATRIX, 16#84E3).
-define(GL_TRANSPOSE_PROJECTION_MATRIX, 16#84E4).
-define(GL_TRANSPOSE_TEXTURE_MATRIX, 16#84E5).
-define(GL_TRANSPOSE_COLOR_MATRIX, 16#84E6).
-define(GL_MULTISAMPLE, 16#809D).
-define(GL_SAMPLE_ALPHA_TO_COVERAGE, 16#809E).
-define(GL_SAMPLE_ALPHA_TO_ONE, 16#809F).
-define(GL_SAMPLE_COVERAGE, 16#80A0).
-define(GL_SAMPLE_BUFFERS, 16#80A8).
-define(GL_SAMPLES, 16#80A9).
-define(GL_SAMPLE_COVERAGE_VALUE, 16#80AA).
-define(GL_SAMPLE_COVERAGE_INVERT, 16#80AB).
-define(GL_MULTISAMPLE_BIT, 16#20000000).
-define(GL_NORMAL_MAP, 16#8511).
-define(GL_REFLECTION_MAP, 16#8512).
-define(GL_TEXTURE_CUBE_MAP, 16#8513).
-define(GL_TEXTURE_BINDING_CUBE_MAP, 16#8514).
-define(GL_TEXTURE_CUBE_MAP_POSITIVE_X, 16#8515).
-define(GL_TEXTURE_CUBE_MAP_NEGATIVE_X, 16#8516).
-define(GL_TEXTURE_CUBE_MAP_POSITIVE_Y, 16#8517).
-define(GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, 16#8518).
-define(GL_TEXTURE_CUBE_MAP_POSITIVE_Z, 16#8519).
-define(GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, 16#851A).
-define(GL_PROXY_TEXTURE_CUBE_MAP, 16#851B).
-define(GL_MAX_CUBE_MAP_TEXTURE_SIZE, 16#851C).
-define(GL_COMPRESSED_ALPHA, 16#84E9).
-define(GL_COMPRESSED_LUMINANCE, 16#84EA).
-define(GL_COMPRESSED_LUMINANCE_ALPHA, 16#84EB).
-define(GL_COMPRESSED_INTENSITY, 16#84EC).
-define(GL_COMPRESSED_RGB, 16#84ED).
-define(GL_COMPRESSED_RGBA, 16#84EE).
-define(GL_TEXTURE_COMPRESSION_HINT, 16#84EF).
-define(GL_TEXTURE_COMPRESSED_IMAGE_SIZE, 16#86A0).
-define(GL_TEXTURE_COMPRESSED, 16#86A1).
-define(GL_NUM_COMPRESSED_TEXTURE_FORMATS, 16#86A2).
-define(GL_COMPRESSED_TEXTURE_FORMATS, 16#86A3).
-define(GL_CLAMP_TO_BORDER, 16#812D).
-define(GL_CLAMP_TO_BORDER_SGIS, 16#812D).
-define(GL_COMBINE, 16#8570).
-define(GL_COMBINE_RGB, 16#8571).
-define(GL_COMBINE_ALPHA, 16#8572).
-define(GL_SOURCE0_RGB, 16#8580).
-define(GL_SOURCE1_RGB, 16#8581).
-define(GL_SOURCE2_RGB, 16#8582).
-define(GL_SOURCE0_ALPHA, 16#8588).
-define(GL_SOURCE1_ALPHA, 16#8589).
-define(GL_SOURCE2_ALPHA, 16#858A).
-define(GL_OPERAND0_RGB, 16#8590).
-define(GL_OPERAND1_RGB, 16#8591).
-define(GL_OPERAND2_RGB, 16#8592).
-define(GL_OPERAND0_ALPHA, 16#8598).
-define(GL_OPERAND1_ALPHA, 16#8599).
-define(GL_OPERAND2_ALPHA, 16#859A).
-define(GL_RGB_SCALE, 16#8573).
-define(GL_ADD_SIGNED, 16#8574).
-define(GL_INTERPOLATE, 16#8575).
-define(GL_SUBTRACT, 16#84E7).
-define(GL_CONSTANT, 16#8576).
-define(GL_PRIMARY_COLOR, 16#8577).
-define(GL_PREVIOUS, 16#8578).
-define(GL_DOT3_RGB, 16#86AE).
-define(GL_DOT3_RGBA, 16#86AF).
-endif.
-ifndef(GL_VERSION_1_4).
-define(GL_BLEND_DST_RGB, 16#80C8).
-define(GL_BLEND_SRC_RGB, 16#80C9).
-define(GL_BLEND_DST_ALPHA, 16#80CA).
-define(GL_BLEND_SRC_ALPHA, 16#80CB).
-define(GL_POINT_SIZE_MIN, 16#8126).
-define(GL_POINT_SIZE_MAX, 16#8127).
-define(GL_POINT_FADE_THRESHOLD_SIZE, 16#8128).
-define(GL_POINT_DISTANCE_ATTENUATION, 16#8129).
-define(GL_GENERATE_MIPMAP, 16#8191).
-define(GL_GENERATE_MIPMAP_HINT, 16#8192).
-define(GL_DEPTH_COMPONENT16, 16#81A5).
-define(GL_DEPTH_COMPONENT24, 16#81A6).
-define(GL_DEPTH_COMPONENT32, 16#81A7).
-define(GL_MIRRORED_REPEAT, 16#8370).
-define(GL_FOG_COORDINATE_SOURCE, 16#8450).
-define(GL_FOG_COORDINATE, 16#8451).
-define(GL_FRAGMENT_DEPTH, 16#8452).
-define(GL_CURRENT_FOG_COORDINATE, 16#8453).
-define(GL_FOG_COORDINATE_ARRAY_TYPE, 16#8454).
-define(GL_FOG_COORDINATE_ARRAY_STRIDE, 16#8455).
-define(GL_FOG_COORDINATE_ARRAY_POINTER, 16#8456).
-define(GL_FOG_COORDINATE_ARRAY, 16#8457).
-define(GL_COLOR_SUM, 16#8458).
-define(GL_CURRENT_SECONDARY_COLOR, 16#8459).
-define(GL_SECONDARY_COLOR_ARRAY_SIZE, 16#845A).
-define(GL_SECONDARY_COLOR_ARRAY_TYPE, 16#845B).
-define(GL_SECONDARY_COLOR_ARRAY_STRIDE, 16#845C).
-define(GL_SECONDARY_COLOR_ARRAY_POINTER, 16#845D).
-define(GL_SECONDARY_COLOR_ARRAY, 16#845E).
-define(GL_MAX_TEXTURE_LOD_BIAS, 16#84FD).
-define(GL_TEXTURE_FILTER_CONTROL, 16#8500).
-define(GL_TEXTURE_LOD_BIAS, 16#8501).
-define(GL_INCR_WRAP, 16#8507).
-define(GL_DECR_WRAP, 16#8508).
-define(GL_TEXTURE_DEPTH_SIZE, 16#884A).
-define(GL_DEPTH_TEXTURE_MODE, 16#884B).
-define(GL_TEXTURE_COMPARE_MODE, 16#884C).
-define(GL_TEXTURE_COMPARE_FUNC, 16#884D).
-define(GL_COMPARE_R_TO_TEXTURE, 16#884E).
-endif.
-ifndef(GL_VERSION_1_5).
-define(GL_BUFFER_SIZE, 16#8764).
-define(GL_BUFFER_USAGE, 16#8765).
-define(GL_QUERY_COUNTER_BITS, 16#8864).
-define(GL_CURRENT_QUERY, 16#8865).
-define(GL_QUERY_RESULT, 16#8866).
-define(GL_QUERY_RESULT_AVAILABLE, 16#8867).
-define(GL_ARRAY_BUFFER, 16#8892).
-define(GL_ELEMENT_ARRAY_BUFFER, 16#8893).
-define(GL_ARRAY_BUFFER_BINDING, 16#8894).
-define(GL_ELEMENT_ARRAY_BUFFER_BINDING, 16#8895).
-define(GL_VERTEX_ARRAY_BUFFER_BINDING, 16#8896).
-define(GL_NORMAL_ARRAY_BUFFER_BINDING, 16#8897).
-define(GL_COLOR_ARRAY_BUFFER_BINDING, 16#8898).
-define(GL_INDEX_ARRAY_BUFFER_BINDING, 16#8899).
-define(GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING, 16#889A).
-define(GL_EDGE_FLAG_ARRAY_BUFFER_BINDING, 16#889B).
-define(GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING, 16#889C).
-define(GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING, 16#889D).
-define(GL_WEIGHT_ARRAY_BUFFER_BINDING, 16#889E).
-define(GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, 16#889F).
-define(GL_READ_ONLY, 16#88B8).
-define(GL_WRITE_ONLY, 16#88B9).
-define(GL_READ_WRITE, 16#88BA).
-define(GL_BUFFER_ACCESS, 16#88BB).
-define(GL_BUFFER_MAPPED, 16#88BC).
-define(GL_BUFFER_MAP_POINTER, 16#88BD).
-define(GL_STREAM_DRAW, 16#88E0).
-define(GL_STREAM_READ, 16#88E1).
-define(GL_STREAM_COPY, 16#88E2).
-define(GL_STATIC_DRAW, 16#88E4).
-define(GL_STATIC_READ, 16#88E5).
-define(GL_STATIC_COPY, 16#88E6).
-define(GL_DYNAMIC_DRAW, 16#88E8).
-define(GL_DYNAMIC_READ, 16#88E9).
-define(GL_DYNAMIC_COPY, 16#88EA).
-define(GL_SAMPLES_PASSED, 16#8914).
-define(GL_FOG_COORD_SOURCE, ?GL_FOG_COORDINATE_SOURCE).
-define(GL_FOG_COORD, ?GL_FOG_COORDINATE).
-define(GL_CURRENT_FOG_COORD, ?GL_CURRENT_FOG_COORDINATE).
-define(GL_FOG_COORD_ARRAY_TYPE, ?GL_FOG_COORDINATE_ARRAY_TYPE).
-define(GL_FOG_COORD_ARRAY_STRIDE, ?GL_FOG_COORDINATE_ARRAY_STRIDE).
-define(GL_FOG_COORD_ARRAY_POINTER, ?GL_FOG_COORDINATE_ARRAY_POINTER).
-define(GL_FOG_COORD_ARRAY, ?GL_FOG_COORDINATE_ARRAY).
-define(GL_FOG_COORD_ARRAY_BUFFER_BINDING, ?GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING).
-define(GL_SRC0_RGB, ?GL_SOURCE0_RGB).
-define(GL_SRC1_RGB, ?GL_SOURCE1_RGB).
-define(GL_SRC2_RGB, ?GL_SOURCE2_RGB).
-define(GL_SRC0_ALPHA, ?GL_SOURCE0_ALPHA).
-define(GL_SRC1_ALPHA, ?GL_SOURCE1_ALPHA).
-define(GL_SRC2_ALPHA, ?GL_SOURCE2_ALPHA).
-endif.
-ifndef(GL_ARB_vertex_blend).
-define(GL_MAX_VERTEX_UNITS_ARB, 16#86A4).
-define(GL_MAX_VERTEX_UNITS, 16#86A4).
-define(GL_ACTIVE_VERTEX_UNITS_ARB, 16#86A5).
-define(GL_ACTIVE_VERTEX_UNITS, 16#86A5).
-define(GL_WEIGHT_SUM_UNITY_ARB, 16#86A6).
-define(GL_WEIGHT_SUM_UNITY, 16#86A6).
-define(GL_VERTEX_BLEND_ARB, 16#86A7).
-define(GL_VERTEX_BLEND, 16#86A7).
-define(GL_CURRENT_WEIGHT_ARB, 16#86A8).
-define(GL_CURRENT_WEIGHT, 16#86A8).
-define(GL_WEIGHT_ARRAY_TYPE_ARB, 16#86A9).
-define(GL_WEIGHT_ARRAY_TYPE, 16#86A9).
-define(GL_WEIGHT_ARRAY_STRIDE_ARB, 16#86AA).
-define(GL_WEIGHT_ARRAY_STRIDE, 16#86AA).
-define(GL_WEIGHT_ARRAY_SIZE_ARB, 16#86AB).
-define(GL_WEIGHT_ARRAY_SIZE, 16#86AB).
-define(GL_WEIGHT_ARRAY_POINTER_ARB, 16#86AC).
-define(GL_WEIGHT_ARRAY_POINTER, 16#86AC).
-define(GL_WEIGHT_ARRAY_ARB, 16#86AD).
-define(GL_WEIGHT_ARRAY, 16#86AD).
-define(GL_MODELVIEW0_ARB, 16#1700).
-define(GL_MODELVIEW0, 16#1700).
-define(GL_MODELVIEW1_ARB, 16#850A).
-define(GL_MODELVIEW1, 16#850A).
-define(GL_MODELVIEW2_ARB, 16#8722).
-define(GL_MODELVIEW2, 16#8722).
-define(GL_MODELVIEW3_ARB, 16#8723).
-define(GL_MODELVIEW3, 16#8723).
-define(GL_MODELVIEW4_ARB, 16#8724).
-define(GL_MODELVIEW4, 16#8724).
-define(GL_MODELVIEW5_ARB, 16#8725).
-define(GL_MODELVIEW5, 16#8725).
-define(GL_MODELVIEW6_ARB, 16#8726).
-define(GL_MODELVIEW6, 16#8726).
-define(GL_MODELVIEW7_ARB, 16#8727).
-define(GL_MODELVIEW7, 16#8727).
-define(GL_MODELVIEW8_ARB, 16#8728).
-define(GL_MODELVIEW8, 16#8728).
-define(GL_MODELVIEW9_ARB, 16#8729).
-define(GL_MODELVIEW9, 16#8729).
-define(GL_MODELVIEW10_ARB, 16#872A).
-define(GL_MODELVIEW10, 16#872A).
-define(GL_MODELVIEW11_ARB, 16#872B).
-define(GL_MODELVIEW11, 16#872B).
-define(GL_MODELVIEW12_ARB, 16#872C).
-define(GL_MODELVIEW12, 16#872C).
-define(GL_MODELVIEW13_ARB, 16#872D).
-define(GL_MODELVIEW13, 16#872D).
-define(GL_MODELVIEW14_ARB, 16#872E).
-define(GL_MODELVIEW14, 16#872E).
-define(GL_MODELVIEW15_ARB, 16#872F).
-define(GL_MODELVIEW15, 16#872F).
-define(GL_MODELVIEW16_ARB, 16#8730).
-define(GL_MODELVIEW16, 16#8730).
-define(GL_MODELVIEW17_ARB, 16#8731).
-define(GL_MODELVIEW17, 16#8731).
-define(GL_MODELVIEW18_ARB, 16#8732).
-define(GL_MODELVIEW18, 16#8732).
-define(GL_MODELVIEW19_ARB, 16#8733).
-define(GL_MODELVIEW19, 16#8733).
-define(GL_MODELVIEW20_ARB, 16#8734).
-define(GL_MODELVIEW20, 16#8734).
-define(GL_MODELVIEW21_ARB, 16#8735).
-define(GL_MODELVIEW21, 16#8735).
-define(GL_MODELVIEW22_ARB, 16#8736).
-define(GL_MODELVIEW22, 16#8736).
-define(GL_MODELVIEW23_ARB, 16#8737).
-define(GL_MODELVIEW23, 16#8737).
-define(GL_MODELVIEW24_ARB, 16#8738).
-define(GL_MODELVIEW24, 16#8738).
-define(GL_MODELVIEW25_ARB, 16#8739).
-define(GL_MODELVIEW25, 16#8739).
-define(GL_MODELVIEW26_ARB, 16#873A).
-define(GL_MODELVIEW26, 16#873A).
-define(GL_MODELVIEW27_ARB, 16#873B).
-define(GL_MODELVIEW27, 16#873B).
-define(GL_MODELVIEW28_ARB, 16#873C).
-define(GL_MODELVIEW28, 16#873C).
-define(GL_MODELVIEW29_ARB, 16#873D).
-define(GL_MODELVIEW29, 16#873D).
-define(GL_MODELVIEW30_ARB, 16#873E).
-define(GL_MODELVIEW30, 16#873E).
-define(GL_MODELVIEW31_ARB, 16#873F).
-define(GL_MODELVIEW31, 16#873F).
-endif.
-ifndef(GL_ARB_matrix_palette).
-define(GL_MATRIX_PALETTE_ARB, 16#8840).
-define(GL_MATRIX_PALETTE, 16#8840).
-define(GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB, 16#8841).
-define(GL_MAX_MATRIX_PALETTE_STACK_DEPTH, 16#8841).
-define(GL_MAX_PALETTE_MATRICES_ARB, 16#8842).
-define(GL_MAX_PALETTE_MATRICES, 16#8842).
-define(GL_CURRENT_PALETTE_MATRIX_ARB, 16#8843).
-define(GL_CURRENT_PALETTE_MATRIX, 16#8843).
-define(GL_MATRIX_INDEX_ARRAY_ARB, 16#8844).
-define(GL_MATRIX_INDEX_ARRAY, 16#8844).
-define(GL_CURRENT_MATRIX_INDEX_ARB, 16#8845).
-define(GL_CURRENT_MATRIX_INDEX, 16#8845).
-define(GL_MATRIX_INDEX_ARRAY_SIZE_ARB, 16#8846).
-define(GL_MATRIX_INDEX_ARRAY_SIZE, 16#8846).
-define(GL_MATRIX_INDEX_ARRAY_TYPE_ARB, 16#8847).
-define(GL_MATRIX_INDEX_ARRAY_TYPE, 16#8847).
-define(GL_MATRIX_INDEX_ARRAY_STRIDE_ARB, 16#8848).
-define(GL_MATRIX_INDEX_ARRAY_STRIDE, 16#8848).
-define(GL_MATRIX_INDEX_ARRAY_POINTER_ARB, 16#8849).
-define(GL_MATRIX_INDEX_ARRAY_POINTER, 16#8849).
-endif.
-ifndef(GL_ARB_shadow_ambient).
-define(GL_TEXTURE_COMPARE_FAIL_VALUE_ARB, 16#80BF).
-define(GL_TEXTURE_COMPARE_FAIL_VALUE, 16#80BF).
-endif.
-ifndef(GL_ARB_vertex_program).
-define(GL_COLOR_SUM_ARB, 16#8458).
%%-define(GL_COLOR_SUM, 16#8458).  % already defined
-define(GL_VERTEX_PROGRAM_ARB, 16#8620).
-define(GL_VERTEX_PROGRAM, 16#8620).
-define(GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB, 16#8622).
-define(GL_VERTEX_ATTRIB_ARRAY_ENABLED, 16#8622).
-define(GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB, 16#8623).
-define(GL_VERTEX_ATTRIB_ARRAY_SIZE, 16#8623).
-define(GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB, 16#8624).
-define(GL_VERTEX_ATTRIB_ARRAY_STRIDE, 16#8624).
-define(GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB, 16#8625).
-define(GL_VERTEX_ATTRIB_ARRAY_TYPE, 16#8625).
-define(GL_CURRENT_VERTEX_ATTRIB_ARB, 16#8626).
-define(GL_CURRENT_VERTEX_ATTRIB, 16#8626).
-define(GL_PROGRAM_LENGTH_ARB, 16#8627).
-define(GL_PROGRAM_LENGTH, 16#8627).
-define(GL_PROGRAM_STRING_ARB, 16#8628).
-define(GL_PROGRAM_STRING, 16#8628).
-define(GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB, 16#862E).
-define(GL_MAX_PROGRAM_MATRIX_STACK_DEPTH, 16#862E).
-define(GL_MAX_PROGRAM_MATRICES_ARB, 16#862F).
-define(GL_MAX_PROGRAM_MATRICES, 16#862F).
-define(GL_CURRENT_MATRIX_STACK_DEPTH_ARB, 16#8640).
-define(GL_CURRENT_MATRIX_STACK_DEPTH, 16#8640).
-define(GL_CURRENT_MATRIX_ARB, 16#8641).
-define(GL_CURRENT_MATRIX, 16#8641).
-define(GL_VERTEX_PROGRAM_POINT_SIZE_ARB, 16#8642).
-define(GL_VERTEX_PROGRAM_POINT_SIZE, 16#8642).
-define(GL_VERTEX_PROGRAM_TWO_SIDE_ARB, 16#8643).
-define(GL_VERTEX_PROGRAM_TWO_SIDE, 16#8643).
-define(GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB, 16#8645).
-define(GL_VERTEX_ATTRIB_ARRAY_POINTER, 16#8645).
-define(GL_PROGRAM_ERROR_POSITION_ARB, 16#864B).
-define(GL_PROGRAM_ERROR_POSITION, 16#864B).
-define(GL_PROGRAM_BINDING_ARB, 16#8677).
-define(GL_PROGRAM_BINDING, 16#8677).
-define(GL_MAX_VERTEX_ATTRIBS_ARB, 16#8869).
-define(GL_MAX_VERTEX_ATTRIBS, 16#8869).
-define(GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB, 16#886A).
-define(GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, 16#886A).
-define(GL_PROGRAM_ERROR_STRING_ARB, 16#8874).
-define(GL_PROGRAM_ERROR_STRING, 16#8874).
-define(GL_PROGRAM_FORMAT_ASCII_ARB, 16#8875).
-define(GL_PROGRAM_FORMAT_ASCII, 16#8875).
-define(GL_PROGRAM_FORMAT_ARB, 16#8876).
-define(GL_PROGRAM_FORMAT, 16#8876).
-define(GL_PROGRAM_INSTRUCTIONS_ARB, 16#88A0).
-define(GL_PROGRAM_INSTRUCTIONS, 16#88A0).
-define(GL_MAX_PROGRAM_INSTRUCTIONS_ARB, 16#88A1).
-define(GL_MAX_PROGRAM_INSTRUCTIONS, 16#88A1).
-define(GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB, 16#88A2).
-define(GL_PROGRAM_NATIVE_INSTRUCTIONS, 16#88A2).
-define(GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB, 16#88A3).
-define(GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS, 16#88A3).
-define(GL_PROGRAM_TEMPORARIES_ARB, 16#88A4).
-define(GL_PROGRAM_TEMPORARIES, 16#88A4).
-define(GL_MAX_PROGRAM_TEMPORARIES_ARB, 16#88A5).
-define(GL_MAX_PROGRAM_TEMPORARIES, 16#88A5).
-define(GL_PROGRAM_NATIVE_TEMPORARIES_ARB, 16#88A6).
-define(GL_PROGRAM_NATIVE_TEMPORARIES, 16#88A6).
-define(GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB, 16#88A7).
-define(GL_MAX_PROGRAM_NATIVE_TEMPORARIES, 16#88A7).
-define(GL_PROGRAM_PARAMETERS_ARB, 16#88A8).
-define(GL_PROGRAM_PARAMETERS, 16#88A8).
-define(GL_MAX_PROGRAM_PARAMETERS_ARB, 16#88A9).
-define(GL_MAX_PROGRAM_PARAMETERS, 16#88A9).
-define(GL_PROGRAM_NATIVE_PARAMETERS_ARB, 16#88AA).
-define(GL_PROGRAM_NATIVE_PARAMETERS, 16#88AA).
-define(GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB, 16#88AB).
-define(GL_MAX_PROGRAM_NATIVE_PARAMETERS, 16#88AB).
-define(GL_PROGRAM_ATTRIBS_ARB, 16#88AC).
-define(GL_PROGRAM_ATTRIBS, 16#88AC).
-define(GL_MAX_PROGRAM_ATTRIBS_ARB, 16#88AD).
-define(GL_MAX_PROGRAM_ATTRIBS, 16#88AD).
-define(GL_PROGRAM_NATIVE_ATTRIBS_ARB, 16#88AE).
-define(GL_PROGRAM_NATIVE_ATTRIBS, 16#88AE).
-define(GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB, 16#88AF).
-define(GL_MAX_PROGRAM_NATIVE_ATTRIBS, 16#88AF).
-define(GL_PROGRAM_ADDRESS_REGISTERS_ARB, 16#88B0).
-define(GL_PROGRAM_ADDRESS_REGISTERS, 16#88B0).
-define(GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB, 16#88B1).
-define(GL_MAX_PROGRAM_ADDRESS_REGISTERS, 16#88B1).
-define(GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB, 16#88B2).
-define(GL_PROGRAM_NATIVE_ADDRESS_REGISTERS, 16#88B2).
-define(GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB, 16#88B3).
-define(GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS, 16#88B3).
-define(GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB, 16#88B4).
-define(GL_MAX_PROGRAM_LOCAL_PARAMETERS, 16#88B4).
-define(GL_MAX_PROGRAM_ENV_PARAMETERS_ARB, 16#88B5).
-define(GL_MAX_PROGRAM_ENV_PARAMETERS, 16#88B5).
-define(GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB, 16#88B6).
-define(GL_PROGRAM_UNDER_NATIVE_LIMITS, 16#88B6).
-define(GL_TRANSPOSE_CURRENT_MATRIX_ARB, 16#88B7).
-define(GL_TRANSPOSE_CURRENT_MATRIX, 16#88B7).
-define(GL_MATRIX0_ARB, 16#88C0).
-define(GL_MATRIX0, 16#88C0).
-define(GL_MATRIX1_ARB, 16#88C1).
-define(GL_MATRIX1, 16#88C1).
-define(GL_MATRIX2_ARB, 16#88C2).
-define(GL_MATRIX2, 16#88C2).
-define(GL_MATRIX3_ARB, 16#88C3).
-define(GL_MATRIX3, 16#88C3).
-define(GL_MATRIX4_ARB, 16#88C4).
-define(GL_MATRIX4, 16#88C4).
-define(GL_MATRIX5_ARB, 16#88C5).
-define(GL_MATRIX5, 16#88C5).
-define(GL_MATRIX6_ARB, 16#88C6).
-define(GL_MATRIX6, 16#88C6).
-define(GL_MATRIX7_ARB, 16#88C7).
-define(GL_MATRIX7, 16#88C7).
-define(GL_MATRIX8_ARB, 16#88C8).
-define(GL_MATRIX8, 16#88C8).
-define(GL_MATRIX9_ARB, 16#88C9).
-define(GL_MATRIX9, 16#88C9).
-define(GL_MATRIX10_ARB, 16#88CA).
-define(GL_MATRIX10, 16#88CA).
-define(GL_MATRIX11_ARB, 16#88CB).
-define(GL_MATRIX11, 16#88CB).
-define(GL_MATRIX12_ARB, 16#88CC).
-define(GL_MATRIX12, 16#88CC).
-define(GL_MATRIX13_ARB, 16#88CD).
-define(GL_MATRIX13, 16#88CD).
-define(GL_MATRIX14_ARB, 16#88CE).
-define(GL_MATRIX14, 16#88CE).
-define(GL_MATRIX15_ARB, 16#88CF).
-define(GL_MATRIX15, 16#88CF).
-define(GL_MATRIX16_ARB, 16#88D0).
-define(GL_MATRIX16, 16#88D0).
-define(GL_MATRIX17_ARB, 16#88D1).
-define(GL_MATRIX17, 16#88D1).
-define(GL_MATRIX18_ARB, 16#88D2).
-define(GL_MATRIX18, 16#88D2).
-define(GL_MATRIX19_ARB, 16#88D3).
-define(GL_MATRIX19, 16#88D3).
-define(GL_MATRIX20_ARB, 16#88D4).
-define(GL_MATRIX20, 16#88D4).
-define(GL_MATRIX21_ARB, 16#88D5).
-define(GL_MATRIX21, 16#88D5).
-define(GL_MATRIX22_ARB, 16#88D6).
-define(GL_MATRIX22, 16#88D6).
-define(GL_MATRIX23_ARB, 16#88D7).
-define(GL_MATRIX23, 16#88D7).
-define(GL_MATRIX24_ARB, 16#88D8).
-define(GL_MATRIX24, 16#88D8).
-define(GL_MATRIX25_ARB, 16#88D9).
-define(GL_MATRIX25, 16#88D9).
-define(GL_MATRIX26_ARB, 16#88DA).
-define(GL_MATRIX26, 16#88DA).
-define(GL_MATRIX27_ARB, 16#88DB).
-define(GL_MATRIX27, 16#88DB).
-define(GL_MATRIX28_ARB, 16#88DC).
-define(GL_MATRIX28, 16#88DC).
-define(GL_MATRIX29_ARB, 16#88DD).
-define(GL_MATRIX29, 16#88DD).
-define(GL_MATRIX30_ARB, 16#88DE).
-define(GL_MATRIX30, 16#88DE).
-define(GL_MATRIX31_ARB, 16#88DF).
-define(GL_MATRIX31, 16#88DF).
-endif.
-ifndef(GL_ARB_fragment_program).
-define(GL_FRAGMENT_PROGRAM_ARB, 16#8804).
-define(GL_FRAGMENT_PROGRAM, 16#8804).
-define(GL_PROGRAM_ALU_INSTRUCTIONS_ARB, 16#8805).
-define(GL_PROGRAM_ALU_INSTRUCTIONS, 16#8805).
-define(GL_PROGRAM_TEX_INSTRUCTIONS_ARB, 16#8806).
-define(GL_PROGRAM_TEX_INSTRUCTIONS, 16#8806).
-define(GL_PROGRAM_TEX_INDIRECTIONS_ARB, 16#8807).
-define(GL_PROGRAM_TEX_INDIRECTIONS, 16#8807).
-define(GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB, 16#8808).
-define(GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS, 16#8808).
-define(GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB, 16#8809).
-define(GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS, 16#8809).
-define(GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB, 16#880A).
-define(GL_PROGRAM_NATIVE_TEX_INDIRECTIONS, 16#880A).
-define(GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB, 16#880B).
-define(GL_MAX_PROGRAM_ALU_INSTRUCTIONS, 16#880B).
-define(GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB, 16#880C).
-define(GL_MAX_PROGRAM_TEX_INSTRUCTIONS, 16#880C).
-define(GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB, 16#880D).
-define(GL_MAX_PROGRAM_TEX_INDIRECTIONS, 16#880D).
-define(GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB, 16#880E).
-define(GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS, 16#880E).
-define(GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB, 16#880F).
-define(GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS, 16#880F).
-define(GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB, 16#8810).
-define(GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS, 16#8810).
-define(GL_MAX_TEXTURE_COORDS_ARB, 16#8871).
-define(GL_MAX_TEXTURE_COORDS, 16#8871).
-define(GL_MAX_TEXTURE_IMAGE_UNITS_ARB, 16#8872).
-define(GL_MAX_TEXTURE_IMAGE_UNITS, 16#8872).
-endif.
-ifndef(GL_ARB_shader_objects).
-define(GL_PROGRAM_OBJECT_ARB, 16#8B40).
-define(GL_PROGRAM_OBJECT, 16#8B40).
-define(GL_SHADER_OBJECT_ARB, 16#8B48).
-define(GL_SHADER_OBJECT, 16#8B48).
-define(GL_OBJECT_TYPE_ARB, 16#8B4E).
-define(GL_OBJECT_TYPE, 16#8B4E).
-define(GL_OBJECT_SUBTYPE_ARB, 16#8B4F).
-define(GL_OBJECT_SUBTYPE, 16#8B4F).
-define(GL_FLOAT_VEC2_ARB, 16#8B50).
-define(GL_FLOAT_VEC2, 16#8B50).
-define(GL_FLOAT_VEC3_ARB, 16#8B51).
-define(GL_FLOAT_VEC3, 16#8B51).
-define(GL_FLOAT_VEC4_ARB, 16#8B52).
-define(GL_FLOAT_VEC4, 16#8B52).
-define(GL_INT_VEC2_ARB, 16#8B53).
-define(GL_INT_VEC2, 16#8B53).
-define(GL_INT_VEC3_ARB, 16#8B54).
-define(GL_INT_VEC3, 16#8B54).
-define(GL_INT_VEC4_ARB, 16#8B55).
-define(GL_INT_VEC4, 16#8B55).
-define(GL_BOOL_ARB, 16#8B56).
-define(GL_BOOL, 16#8B56).
-define(GL_BOOL_VEC2_ARB, 16#8B57).
-define(GL_BOOL_VEC2, 16#8B57).
-define(GL_BOOL_VEC3_ARB, 16#8B58).
-define(GL_BOOL_VEC3, 16#8B58).
-define(GL_BOOL_VEC4_ARB, 16#8B59).
-define(GL_BOOL_VEC4, 16#8B59).
-define(GL_FLOAT_MAT2_ARB, 16#8B5A).
-define(GL_FLOAT_MAT2, 16#8B5A).
-define(GL_FLOAT_MAT3_ARB, 16#8B5B).
-define(GL_FLOAT_MAT3, 16#8B5B).
-define(GL_FLOAT_MAT4_ARB, 16#8B5C).
-define(GL_FLOAT_MAT4, 16#8B5C).
-define(GL_OBJECT_DELETE_STATUS_ARB, 16#8B80).
-define(GL_OBJECT_DELETE_STATUS, 16#8B80).
-define(GL_OBJECT_COMPILE_STATUS_ARB, 16#8B81).
-define(GL_OBJECT_COMPILE_STATUS, 16#8B81).
-define(GL_OBJECT_LINK_STATUS_ARB, 16#8B82).
-define(GL_OBJECT_LINK_STATUS, 16#8B82).
-define(GL_OBJECT_VALIDATE_STATUS_ARB, 16#8B83).
-define(GL_OBJECT_VALIDATE_STATUS, 16#8B83).
-define(GL_OBJECT_INFO_LOG_LENGTH_ARB, 16#8B84).
-define(GL_OBJECT_INFO_LOG_LENGTH, 16#8B84).
-define(GL_OBJECT_ATTACHED_OBJECTS_ARB, 16#8B85).
-define(GL_OBJECT_ATTACHED_OBJECTS, 16#8B85).
-define(GL_OBJECT_ACTIVE_UNIFORMS_ARB, 16#8B86).
-define(GL_OBJECT_ACTIVE_UNIFORMS, 16#8B86).
-define(GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB, 16#8B87).
-define(GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH, 16#8B87).
-define(GL_OBJECT_SHADER_SOURCE_LENGTH_ARB, 16#8B88).
-define(GL_OBJECT_SHADER_SOURCE_LENGTH, 16#8B88).
-endif.
-ifndef(GL_ARB_vertex_shader).
-define(GL_VERTEX_SHADER_ARB, 16#8B31).
-define(GL_VERTEX_SHADER, 16#8B31).
-define(GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB, 16#8B4A).
-define(GL_MAX_VERTEX_UNIFORM_COMPONENTS, 16#8B4A).
-define(GL_MAX_VARYING_FLOATS_ARB, 16#8B4B).
-define(GL_MAX_VARYING_FLOATS, 16#8B4B).
-define(GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB, 16#8B4C).
-define(GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS, 16#8B4C).
-define(GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB, 16#8B4D).
-define(GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS, 16#8B4D).
-define(GL_OBJECT_ACTIVE_ATTRIBUTES_ARB, 16#8B89).
-define(GL_OBJECT_ACTIVE_ATTRIBUTES, 16#8B89).
-define(GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB, 16#8B8A).
-define(GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH, 16#8B8A).
-endif.
-ifndef(GL_ARB_fragment_shader).
-define(GL_FRAGMENT_SHADER_ARB, 16#8B30).
-define(GL_FRAGMENT_SHADER, 16#8B30).
-define(GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB, 16#8B49).
-define(GL_MAX_FRAGMENT_UNIFORM_COMPONENTS, 16#8B49).
-endif.
-ifndef(GL_ARB_shading_language_100).
-endif.
-ifndef(GL_ARB_texture_non_power_of_two).
-endif.
-ifndef(GL_ARB_point_sprite).
-define(GL_POINT_SPRITE_ARB, 16#8861).
-define(GL_POINT_SPRITE, 16#8861).
-define(GL_COORD_REPLACE_ARB, 16#8862).
-define(GL_COORD_REPLACE, 16#8862).
-endif.
-ifndef(GL_NV_depth_clamp).
-define(GL_DEPTH_CLAMP_NV, 16#864F).
-endif.
-ifndef(GL_S3_s3tc).
-define(GL_RGB_S3TC, 16#83A0).
-define(GL_RGB4_S3TC, 16#83A1).
-define(GL_RGBA_S3TC, 16#83A2).
-define(GL_RGBA4_S3TC, 16#83A3).
-endif.
-ifndef(GL_ATI_texture_float).
-define(GL_RGBA_FLOAT32_ATI, 16#8814).
-define(GL_RGB_FLOAT32_ATI, 16#8815).
-define(GL_ALPHA_FLOAT32_ATI, 16#8816).
-define(GL_INTENSITY_FLOAT32_ATI, 16#8817).
-define(GL_LUMINANCE_FLOAT32_ATI, 16#8818).
-define(GL_LUMINANCE_ALPHA_FLOAT32_ATI, 16#8819).
-define(GL_RGBA_FLOAT16_ATI, 16#881A).
-define(GL_RGB_FLOAT16_ATI, 16#881B).
-define(GL_ALPHA_FLOAT16_ATI, 16#881C).
-define(GL_INTENSITY_FLOAT16_ATI, 16#881D).
-define(GL_LUMINANCE_FLOAT16_ATI, 16#881E).
-define(GL_LUMINANCE_ALPHA_FLOAT16_ATI, 16#881F).
-endif.
-ifndef(GL_NV_float_buffer).
-define(GL_FLOAT_R_NV, 16#8880).
-define(GL_FLOAT_RG_NV, 16#8881).
-define(GL_FLOAT_RGB_NV, 16#8882).
-define(GL_FLOAT_RGBA_NV, 16#8883).
-define(GL_FLOAT_R16_NV, 16#8884).
-define(GL_FLOAT_R32_NV, 16#8885).
-define(GL_FLOAT_RG16_NV, 16#8886).
-define(GL_FLOAT_RG32_NV, 16#8887).
-define(GL_FLOAT_RGB16_NV, 16#8888).
-define(GL_FLOAT_RGB32_NV, 16#8889).
-define(GL_FLOAT_RGBA16_NV, 16#888A).
-define(GL_FLOAT_RGBA32_NV, 16#888B).
-define(GL_TEXTURE_FLOAT_COMPONENTS_NV, 16#888C).
-define(GL_FLOAT_CLEAR_COLOR_VALUE_NV, 16#888D).
-define(GL_FLOAT_RGBA_MODE_NV, 16#888E).
-endif.
-ifndef(GL_ATI_separate_stencil).
-define(GL_STENCIL_BACK_FUNC_ATI, 16#8800).
-define(GL_STENCIL_BACK_FAIL_ATI, 16#8801).
-define(GL_STENCIL_BACK_PASS_DEPTH_FAIL_ATI, 16#8802).
-define(GL_STENCIL_BACK_PASS_DEPTH_PASS_ATI, 16#8803).
-endif.
-ifndef(GL_EXT_texture_mirror_clamp).
-define(GL_MIRROR_CLAMP_EXT, 16#8742).
-define(GL_MIRROR_CLAMP_TO_EDGE_EXT, 16#8743).
-define(GL_MIRROR_CLAMP_TO_BORDER_EXT, 16#8912).
-endif.
%%%% pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer pointer 
-ifndef(GL_VERSION_1_5).
%%%% GL types for handling large vertex buffer objects 
-endif.
-ifndef(GL_ARB_shader_objects).
%%%% GL types for handling shader object handles and characters 
-endif.
-ifndef(GL_VERSION_1_2).
-define(GL_VERSION_1_2, 1).
-endif.
-ifndef(GL_VERSION_1_3).
-define(GL_VERSION_1_3, 1).
-endif.
-ifndef(GL_VERSION_1_4).
-define(GL_VERSION_1_4, 1).
-endif.
-ifndef(GL_VERSION_1_5).
-define(GL_VERSION_1_5, 1).
-endif.
-ifndef(GL_ARB_vertex_blend).
-define(GL_ARB_vertex_blend, 1).
-endif.
-ifndef(GL_ARB_matrix_palette).
-define(GL_ARB_matrix_palette, 1).
-endif.
-ifndef(GL_ARB_shadow_ambient).
-define(GL_ARB_shadow_ambient, 1).
-endif.
-ifndef(GL_ARB_vertex_program).
-define(GL_ARB_vertex_program, 1).
-endif.
-ifndef(GL_ARB_fragment_program).
-define(GL_ARB_fragment_program, 1).
%%%% All ARB_fragment_program entry points are shared with ARB_vertex_program. 
-endif.
-ifndef(GL_ARB_shader_objects).
-define(GL_ARB_shader_objects, 1).
-endif.
-ifndef(GL_ARB_vertex_shader).
-define(GL_ARB_vertex_shader, 1).
-endif.
-ifndef(GL_ARB_fragment_shader).
-define(GL_ARB_fragment_shader, 1).
-endif.
-ifndef(GL_ARB_shading_language_100).
-define(GL_ARB_shading_language_100, 1).
-endif.
-ifndef(GL_ARB_texture_non_power_of_two).
-define(GL_ARB_texture_non_power_of_two, 1).
-endif.
-ifndef(GL_ARB_point_sprite).
-define(GL_ARB_point_sprite, 1).
-endif.
-ifndef(GL_NV_depth_clamp).
-define(GL_NV_depth_clamp, 1).
-endif.
-ifndef(GL_S3_s3tc).
-define(GL_S3_s3tc, 1).
-endif.
-ifndef(GL_ATI_texture_float).
-define(GL_ATI_texture_float, 1).
-endif.
-ifndef(GL_NV_float_buffer).
-define(GL_NV_float_buffer, 1).
-endif.
-ifndef(GL_ATI_separate_stencil).
-define(GL_ATI_separate_stencil, 1).
-endif.
-ifndef(GL_EXT_texture_mirror_clamp).
-define(GL_EXT_texture_mirror_clamp, 1).
-endif.
-ifdef(__cplusplus).
-endif.
-endif.
