/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace libsbmlcs {

 using System;
 using System.Runtime.InteropServices;

/** 
 * LibSBML implementation of SBML's %Compartment construct.
 *
 * A compartment in SBML represents a bounded space in which species are
 * located.  Compartments do not necessarily have to correspond to actual
 * structures inside or outside of a biological cell.
 * 
 * It is important to note that although compartments are optional in the
 * overall definition of Model, every species in an SBML model must be
 * located in a compartment.  This in turn means that if a model defines
 * any species, the model must also define at least one compartment.  The
 * reason is simply that species represent physical things, and therefore
 * must exist @em somewhere.  Compartments represent the @em somewhere.
 *
 * Compartment has one required attribute, 'id', to give the compartment a
 * unique identifier by which other parts of an SBML model definition can
 * refer to it.  A compartment can also have an optional 'name' attribute
 * of type @c string.  Identifiers and names must be used according to the
 * guidelines described in the SBML specifications.
 * 
 * Compartment also has an optional attribute 'spatialDimensions' that is
 * used to indicate the number of spatial dimensions possessed by the
 * compartment.  Most modeling scenarios involve compartments with integer
 * values of 'spatialDimensions' of @c 3 (i.e., a three-dimensional
 * compartment, which is to say, a volume), or 2 (a two-dimensional
 * compartment, a surface), or @c 1 (a one-dimensional compartment, a
 * line).  In SBML Level&nbsp;3, the type of this attribute is @c double,
 * there are no restrictions on the permitted values of the
 * 'spatialDimensions' attribute, and there are no default values.  In SBML
 * Level&nbsp;2, the value must be a positive @c integer, and the default
 * value is @c 3; the permissible values in SBML Level&nbsp;2 are @c 3, @c
 * 2, @c 1, and @c 0 (for a point).
 *
 * Another optional attribute on Compartment is 'size', representing the
 * @em initial total size of that compartment in the model.  The 'size'
 * attribute must be a floating-point value and may represent a volume (if
 * the compartment is a three-dimensional one), or an area (if the
 * compartment is two-dimensional), or a length (if the compartment is
 * one-dimensional).  There is no default value of compartment size in SBML
 * Level&nbsp;2 or Level&nbsp;3.  In particular, a missing 'size' value
 * <em>does not imply that the compartment size is 1</em>.  (This is unlike
 * the definition of compartment 'volume' in SBML Level&nbsp;1.)  When the
 * compartment's 'spatialDimensions' attribute does not have a value of @c
 * 0, a missing value of 'size' for a given compartment signifies that the
 * value either is unknown, or to be obtained from an external source, or
 * determined by an InitialAssignment, AssignmentRule, AlgebraicRule or
 * RateRule elsewhere in the model.  In SBML Level&nbsp;2, there are
 * additional special requirements on the values of 'size'; we discuss them
 * in a <a href='#comp-l2'>separate section below</a>.
 *
 * The units associated with a compartment's 'size' attribute value may be
 * set using the optional attribute 'units'.  The rules for setting and
 * using compartment size units differ between SBML Level&nbsp;2 and
 * Level&nbsp;3, and are discussed separately below.
 * 
 * Finally, the optional Compartment attribute named 'constant' is used to
 * indicate whether the compartment's size stays constant after simulation
 * begins.  A value of @c true indicates the compartment's 'size' cannot be
 * changed by any other construct except InitialAssignment; a value of @c
 * false indicates the compartment's 'size' can be changed by other
 * constructs in SBML.  In SBML Level&nbsp;2, there is an additional
 * explicit restriction that if 'spatialDimensions'=@c '0', the value
 * cannot be changed by InitialAssignment either.  Further, in
 * Level&nbsp;2, 'constant' has a default value of @c true.  In SBML
 * Level&nbsp;3, there is no default value for the 'constant' attribute.
 *
 * 
 * @section comp-l2 Additional considerations in SBML Level&nbsp;2
 * 
 * In SBML Level&nbsp;2, the default units of compartment size, and the
 * kinds of units allowed as values of the attribute 'units', interact with
 * the number of spatial dimensions of the compartment.  The value of the
 * 'units' attribute of a Compartment object must be one of the base units
 * (see Unit), or the predefined unit identifiers @c volume, @c area, @c
 * length or @c dimensionless, or a new unit defined by a UnitDefinition
 * object in the enclosing Model, subject to the restrictions detailed in
 * the following table:
 *
 * @htmlinclude compartment-size-restrictions.html 
 *
 * In SBML Level&nbsp;2, the units of the compartment size, as defined by the
 * 'units' attribute or (if 'units' is not set) the default value listed in
 * the table above, are used in the following ways when the compartment has
 * a 'spatialDimensions' value greater than @c 0:
 * <ul>
 * <li> The value of the 'units' attribute is used as the units of the
 * compartment identifier when the identifier appears as a numerical
 * quantity in a mathematical formula expressed in MathML.
 * 
 * <li> The @c math element of an AssignmentRule or InitialAssignment
 * referring to this compartment must have identical units.
 *
 * <li> In RateRule objects that set the rate of change of the compartment's
 * size, the units of the rule's @c math element must be identical to the
 * compartment's 'units' attribute divided by the default @em time units.
 * (In other words, the units for the rate of change of compartment size
 * are <em>compartment size</em>/<em>time</em> units.
 *
 * <li> When a Species is to be treated in terms of concentrations or
 * density, the units of the spatial size portion of the concentration
 * value (i.e., the denominator in the units formula @em substance/@em
 * size) are those indicated by the value of the 'units' attribute on the
 * compartment in which the species is located.
 * </ul>
 *
 * Compartments with 'spatialDimensions'=@c 0 require special treatment in
 * this framework.  As implied above, the 'size' attribute must not have a
 * value on an SBML Level&nbsp;2 Compartment object if the
 * 'spatialDimensions' attribute has a value of @c 0.  An additional
 * related restriction is that the 'constant' attribute must default to or
 * be set to @c true if the value of the 'spatialDimensions' attribute is
 * @c 0, because a zero-dimensional compartment cannot ever have a size.
 *
 * If a compartment has no size or dimensional units, how should such a
 * compartment's identifier be interpreted when it appears in mathematical
 * formulas?  The answer is that such a compartment's identifier should not
 * appear in mathematical formulas in the first place&mdash;it has no
 * value, and its value cannot change.  Note also that a zero-dimensional
 * compartment is a point, and species located at points can only be
 * described in terms of amounts, not spatially-dependent measures such as
 * concentration.  Since SBML KineticLaw formulas are already in terms of
 * @em substance/@em time and not (say) @em concentration/@em time, volume
 * or other factors in principle are not needed for species located in
 * zero-dimensional compartments.
 *
 * Finally, in SBML Level&nbsp;2 Versions 2&ndash;4, each compartment in a
 * model may optionally be designated as belonging to a particular
 * compartment @em type.  The optional attribute 'compartmentType' is used
 * identify the compartment type represented by the Compartment structure.
 * The 'compartmentType' attribute's value must be the identifier of a
 * CompartmentType instance defined in the model.  If the 'compartmentType'
 * attribute is not present on a particular compartment definition, a
 * unique virtual compartment type is assumed for that compartment, and no
 * other compartment can belong to that compartment type.  The values of
 * 'compartmentType' attributes on compartments have no effect on the
 * numerical interpretation of a model.  Simulators and other numerical
 * analysis software may ignore 'compartmentType' attributes.  The
 * 'compartmentType' attribute and the CompartmentType class of objects are
 * not present in SBML Level&nbsp;3 Core nor in SBML Level&nbsp;1.
 * 
 * 
 * @section comp-l3 Additional considerations in SBML Level&nbsp;3
 *
 * One difference between SBML Level&nbsp;3 and lower Levels of SBML is
 * that there are no restrictions on the permissible values of the
 * 'spatialDimensions' attribute, and there is no default value defined for
 * the attribute.  The value of 'spatialDimensions' does not have to be an
 * integer, either; this is to allow for the possibility of representing
 * structures with fractal dimensions.
 *
 * The number of spatial dimensions possessed by a compartment cannot enter
 * into mathematical formulas, and therefore cannot directly alter the
 * numerical interpretation of a model.  However, the value of
 * 'spatialDimensions' @em does affect the interpretation of the units
 * associated with a compartment's size.  Specifically, the value of
 * 'spatialDimensions' is used to select among the Model attributes
 * 'volumeUnits', 'areaUnits' and 'lengthUnits' when a Compartment object
 * does not define a value for its 'units' attribute.
 *
 * The 'units' attribute may be left unspecified for a given compartment in
 * a model; in that case, the compartment inherits the unit of measurement
 * specified by one of the attributes on the enclosing Model object
 * instance.  The applicable attribute on Model depends on the value of the
 * compartment's 'spatialDimensions' attribute; the relationship is shown
 * in the table below.  If the Model object does not define the relevant
 * attribute ('volumeUnits', 'areaUnits' or 'lengthUnits') for a given
 * 'spatialDimensions' value, the unit associated with that Compartment
 * object's size is undefined.  If @em both 'spatialDimensions' and 'units'
 * are left unset on a given Compartment object instance, then no unit can
 * be chosen from among the Model's 'volumeUnits', 'areaUnits' or
 * 'lengthUnits' attributes (even if the Model instance provides values for
 * those attributes), because there is no basis to select between them and
 * there is no default value of 'spatialDimensions'.  Leaving the units of
 * compartments' sizes undefined in an SBML model does not render the model
 * invalid; however, as a matter of best practice, we strongly recommend
 * that all models specify the units of measurement for all compartment
 * sizes.
 *
 * @htmlinclude compartment-size-recommendations.html
 *
 * The unit of measurement associated with a compartment's size, as defined
 * by the 'units' attribute or (if 'units' is not set) the inherited value
 * from Model according to the table above, is used in the following ways:
 *
 * <ul>
 * 
 * <li> When the identifier of the compartment appears as a numerical
 * quantity in a mathematical formula expressed in MathML, it represents
 * the size of the compartment, and the unit associated with the size is
 * the value of the 'units' attribute.
 * 
 * <li> When a Species is to be treated in terms of concentrations or
 * density, the unit associated with the spatial size portion of the
 * concentration value (i.e., the denominator in the formula
 * <em>amount</em>/<em>size</em>) is specified by the value of the 'units'
 * attribute on the compartment in which the species is located.
 * 
 * <li> The 'math' elements of AssignmentRule, InitialAssignment and
 * EventAssignment objects setting the value of the compartment size
 * should all have the same units as the unit associated with the
 * compartment's size.
 * 
 * <li> In a RateRule object that defines a rate of change for a
 * compartment's size, the unit of the rule's 'math' element should be
 * identical to the compartment's 'units' attribute divided by the
 * model-wide unit of <em>time</em>.  (In other words, {<em>unit of
 * compartment size</em>}/{<em>unit of time</em>}.)
 * 
 * </ul>
 * 
 *
 * @section comp-other Other aspects of Compartment
 *
 * In SBML Level&nbsp;1 and Level&nbsp;2, Compartment has an optional
 * attribute named 'outside', whose value can be the identifier of another
 * Compartment object defined in the enclosing Model object.  Doing so
 * means that the other compartment contains it or is outside of it.  This
 * enables the representation of simple topological relationships between
 * compartments, for those simulation systems that can make use of the
 * information (e.g., for drawing simple diagrams of compartments).  It is
 * worth noting that in SBML, there is no relationship between compartment
 * sizes when compartment positioning is expressed using the 'outside'
 * attribute.  The size of a given compartment does not in any sense
 * include the sizes of other compartments having it as the value of their
 * 'outside' attributes.  In other words, if a compartment @em B has the
 * identifier of compartment @em A as its 'outside' attribute value, the
 * size of @em A does not include the size of @em B.  The compartment sizes
 * are separate.
 *
 * In Level&nbsp;2, there are two restrictions on the 'outside' attribute.
 * First, because a compartment with 'spatialDimensions' of @c 0 has no
 * size, such a compartment cannot act as the container of any other
 * compartment @em except compartments that @em also have
 * 'spatialDimensions' values of @c 0.  Second, the directed graph formed
 * by representing Compartment structures as vertexes and the 'outside'
 * attribute values as edges must be acyclic.  The latter condition is
 * imposed to prevent a compartment from being contained inside itself.  In
 * the absence of a value for 'outside', compartment definitions in SBML
 * Level&nbsp;2 do not have any implied spatial relationships between each
 * other.
 * 
 * 
 * <!-- leave this next break as-is to work around some doxygen bug -->
 */

public class Compartment : SBase {
	private HandleRef swigCPtr;
	
	internal Compartment(IntPtr cPtr, bool cMemoryOwn) : base(libsbmlPINVOKE.Compartment_SWIGUpcast(cPtr), cMemoryOwn)
	{
		//super(libsbmlPINVOKE.CompartmentUpcast(cPtr), cMemoryOwn);
		swigCPtr = new HandleRef(this, cPtr);
	}
	
	internal static HandleRef getCPtr(Compartment obj)
	{
		return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
	}
	
	internal static HandleRef getCPtrAndDisown (Compartment obj)
	{
		HandleRef ptr = new HandleRef(null, IntPtr.Zero);
		
		if (obj != null)
		{
			ptr             = obj.swigCPtr;
			obj.swigCMemOwn = false;
		}
		
		return ptr;
	}

  ~Compartment() {
    Dispose();
  }

  public override void Dispose() {
    lock(this) {
      if (swigCPtr.Handle != IntPtr.Zero) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          libsbmlPINVOKE.delete_Compartment(swigCPtr);
        }
        swigCPtr = new HandleRef(null, IntPtr.Zero);
      }
      GC.SuppressFinalize(this);
      base.Dispose();
    }
  }

  
/**
   * Creates a new Compartment using the given SBML @p level and @p version
   * values.
   *
   * @param level a long integer, the SBML Level to assign to this Compartment
   *
   * @param version a long integer, the SBML Version to assign to this
   * Compartment
   *
   * @throws @if python ValueError @else SBMLConstructorException @endif@~
   * Thrown if the given @p level and @p version combination, or this kind
   * of SBML object, are either invalid or mismatched with respect to the
   * parent SBMLDocument object.
   * 
   * @note Upon the addition of a Compartment object to an SBMLDocument
   * (e.g., using Model::addCompartment(@if java Compartment c@endif)), the SBML Level, SBML Version
   * and XML namespace of the document @em override the values used
   * when creating the Compartment object via this constructor.  This is
   * necessary to ensure that an SBML document is a consistent structure.
   * Nevertheless, the ability to supply the values at the time of creation
   * of a Compartment is an important aid to producing valid SBML.
   * Knowledge of the intented SBML Level and Version determine whether it
   * is valid to assign a particular value to an attribute, or whether it
   * is valid to add an object to an existing SBMLDocument.
   */ public
 Compartment(long level, long version) : this(libsbmlPINVOKE.new_Compartment__SWIG_0(level, version), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates a new Compartment using the given SBMLNamespaces object 
   * @p sbmlns.
   *
   * The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
   * information.  It is used to communicate the SBML Level, Version, and
   * (in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
   * A common approach to using this class constructor is to create an
   * SBMLNamespaces object somewhere in a program, once, then pass it to
   * object constructors such as this one when needed.
   *
   * It is worth emphasizing that although this constructor does not take
   * an identifier argument, in SBML Level&nbsp;2 and beyond, the 'id'
   * (identifier) attribute of a Compartment is required to have a value.
   * Thus, callers are cautioned to assign a value after calling this
   * constructor.  Setting the identifier can be accomplished using the
   * method @if java Compartment::setId(String id)@else setId()@endif.
   *
   * @param sbmlns an SBMLNamespaces object.
   *
   * @throws @if python ValueError @else SBMLConstructorException @endif@~
   * Thrown if the given @p level and @p version combination, or this kind
   * of SBML object, are either invalid or mismatched with respect to the
   * parent SBMLDocument object.
   *
   * @note Upon the addition of a Compartment object to an SBMLDocument
   * (e.g., using Model::addCompartment(@if java Compartment c@endif)), the SBML XML namespace of the
   * document @em overrides the value used when creating the Compartment
   * object via this constructor.  This is necessary to ensure that an SBML
   * document is a consistent structure.  Nevertheless, the ability to
   * supply the values at the time of creation of a Compartment is an
   * important aid to producing valid SBML.  Knowledge of the intented SBML
   * Level and Version determine whether it is valid to assign a particular
   * value to an attribute, or whether it is valid to add an object to an
   * existing SBMLDocument.
   */ public
 Compartment(SBMLNamespaces sbmlns) : this(libsbmlPINVOKE.new_Compartment__SWIG_1(SBMLNamespaces.getCPtr(sbmlns)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Copy constructor; creates a copy of a Compartment.
   * 
   * @param orig the Compartment instance to copy.
   *
   * @throws @if python ValueError @else SBMLConstructorException @endif@~
   * Thrown if the argument @p orig is @c null.
   */ public
 Compartment(Compartment orig) : this(libsbmlPINVOKE.new_Compartment__SWIG_2(Compartment.getCPtr(orig)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates and returns a deep copy of this Compartment object.
   * 
   * @return a (deep) copy of this Compartment.
   */ public new
 Compartment clone() {
    IntPtr cPtr = libsbmlPINVOKE.Compartment_clone(swigCPtr);
    Compartment ret = (cPtr == IntPtr.Zero) ? null : new Compartment(cPtr, true);
    return ret;
  }

  
/**
   * Initializes the fields of this Compartment object to 'typical' default
   * values.
   *
   * The SBML Compartment component has slightly different aspects and
   * default attribute values in different SBML Levels and Versions.
   * This method sets the values to certain common defaults, based
   * mostly on what they are in SBML Level&nbsp;2.  Specifically:
   * <ul>
   * <li> Sets attribute 'spatialDimensions' to @c 3
   * <li> Sets attribute 'constant' to @c true
   * <li> (Applies to Level&nbsp;1 models only) Sets attribute 'volume' to @c 1.0
   * <li> (Applies to Level&nbsp;3 models only) Sets attribute 'units' to @c litre
   * </ul>
   */ public
 void initDefaults() {
    libsbmlPINVOKE.Compartment_initDefaults(swigCPtr);
  }

  
/**
   * Returns the value of the 'id' attribute of this Compartment object.
   * 
   * @return the id of this Compartment.
   */ public new
 string getId() {
    string ret = libsbmlPINVOKE.Compartment_getId(swigCPtr);
    return ret;
  }

  
/**
   * Returns the value of the 'name' attribute of this Compartment object.
   * 
   * @return the name of this Compartment.
   */ public new
 string getName() {
    string ret = libsbmlPINVOKE.Compartment_getName(swigCPtr);
    return ret;
  }

  
/**
   * Get the value of the 'compartmentType' attribute of this Compartment
   * object.
   * 
   * @return the value of the 'compartmentType' attribute of this
   * Compartment as a string.
   *
   * @note The 'compartmentType' attribute is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.
   */ public
 string getCompartmentType() {
    string ret = libsbmlPINVOKE.Compartment_getCompartmentType(swigCPtr);
    return ret;
  }

  
/**
   * Get the number of spatial dimensions of this Compartment object.
   *
   * @note In SBML Level&nbsp;3, the data type of the 'spatialDimensions'
   * attribute is @c double, whereas in Level&nbsp;2, it is @c integer.
   * LibSBML provides a separate method for obtaining the value as a double,
   * for models where it is relevant.
   *
   * @return the value of the 'spatialDimensions' attribute of this
   * Compartment as a long integereger
   *
   * @see getSpatialDimensionsAsDouble()
   */ public
 long getSpatialDimensions() { return (long)libsbmlPINVOKE.Compartment_getSpatialDimensions(swigCPtr); }

  
/**
   * Get the number of spatial dimensions of this Compartment object
   * as a double.
   *
   * @note In SBML Level&nbsp;3, the data type of the 'spatialDimensions'
   * attribute is @c double, whereas in Level&nbsp;2, it is @c integer.  To
   * avoid backward compatibility issues, libSBML provides a separate
   * method for obtaining the value as a double, for models where it is
   * relevant.
   *
   * @return the value of the 'spatialDimensions' attribute of this
   * Compartment as a double, or @c NaN if this model is not in SBML
   * Level&nbsp;3 format.
   *
   * @see getSpatialDimensions()
   */ public
 double getSpatialDimensionsAsDouble() {
    double ret = libsbmlPINVOKE.Compartment_getSpatialDimensionsAsDouble(swigCPtr);
    return ret;
  }

  
/**
   * Get the size of this Compartment.
   *
   * This method is identical to
   * @if java Compartment::getVolume()@else getVolume()@endif.
   * In SBML Level&nbsp;1, compartments are always three-dimensional
   * constructs and only have volumes, whereas in SBML Level&nbsp;2,
   * compartments may be other than three-dimensional and therefore the
   * 'volume' attribute is named 'size' in Level&nbsp;2.  LibSBML provides
   * both
   * @if java Compartment::getSize()@else getSize()@endif@~ and
   * @if java Compartment::getVolume()@else getVolume()@endif@~ for
   * easier compatibility between SBML Levels.
   *
   * @return the value of the 'size' attribute ('volume' in Level&nbsp;1) of
   * this Compartment as a float-point number.
   *
   * @see isSetSize()
   * @see getVolume()
   */ public
 double getSize() {
    double ret = libsbmlPINVOKE.Compartment_getSize(swigCPtr);
    return ret;
  }

  
/**
   * Get the volume of this Compartment.
   * 
   * This method is identical to
   * @if java Compartment::getSize()@else getSize()@endif.  In
   * SBML Level&nbsp;1, compartments are always three-dimensional
   * constructs and only have volumes, whereas in SBML Level&nbsp;2,
   * compartments may be other than three-dimensional and therefore the
   * 'volume' attribute is named 'size' in Level&nbsp;2.  LibSBML provides
   * both
   * @if java Compartment::getSize()@else getSize()@endif@~ and
   * @if java Compartment::getVolume()@else getVolume()@endif@~
   * for easier compatibility between SBML Levels.
   *
   * @return the value of the 'volume' attribute ('size' in Level&nbsp;2) of
   * this Compartment, as a floating-point number.
   *
   * @note The attribute 'volume' only exists by that name in SBML
   * Level&nbsp;1.  In Level&nbsp;2 and above, the equivalent attribute is
   * named 'size'.
   * 
   * @see isSetVolume()
   * @see getSize()
   */ public
 double getVolume() {
    double ret = libsbmlPINVOKE.Compartment_getVolume(swigCPtr);
    return ret;
  }

  
/**
   * Get the units of this compartment's size.
   * 
   * The value of an SBML compartment's 'units' attribute establishes the
   * unit of measurement associated with the compartment's size.
   *
   * @return the value of the 'units' attribute of this Compartment, as a
   * string.  An empty string indicates that no units have been assigned to
   * the value of the size.
   *
   * @note @htmlinclude unassigned-units-are-not-a-default.html
   *
   * @see isSetUnits()
   * @see @if java Compartment::setUnits(String sid)@else setUnits()@endif@~
   * @see getSize()
   */ public
 string getUnits() {
    string ret = libsbmlPINVOKE.Compartment_getUnits(swigCPtr);
    return ret;
  }

  
/**
   * Get the identifier, if any, of the compartment that is designated
   * as being outside of this one.
   * 
   * @return the value of the 'outside' attribute of this Compartment.
   *
   * @note The 'outside' attribute is defined in SBML Level&nbsp;1 and
   * Level&nbsp;2, but does not exist in SBML Level&nbsp;3 Version&nbsp;1
   * Core.
   */ public
 string getOutside() {
    string ret = libsbmlPINVOKE.Compartment_getOutside(swigCPtr);
    return ret;
  }

  
/**
   * Get the value of the 'constant' attribute of this Compartment.
   *
   * @return @c true if this Compartment's size is flagged as being
   * constant, @c false otherwise.
   */ public
 bool getConstant() {
    bool ret = libsbmlPINVOKE.Compartment_getConstant(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Compartment's 'id' attribute is set.
   *
   * @return @c true if the 'id' attribute of this Compartment is 
   * set, @c false otherwise.
   */ public new
 bool isSetId() {
    bool ret = libsbmlPINVOKE.Compartment_isSetId(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Compartment's 'name' attribute is set.
   *
   * @return @c true if the 'name' attribute of this Compartment is
   * set, @c false otherwise.
   */ public new
 bool isSetName() {
    bool ret = libsbmlPINVOKE.Compartment_isSetName(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Compartment's 'compartmentType' attribute is set.
   *
   * @return @c true if the 'compartmentType' attribute of this Compartment
   * is set, @c false otherwise.
   *
   * @note The 'compartmentType' attribute is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.
   */ public
 bool isSetCompartmentType() {
    bool ret = libsbmlPINVOKE.Compartment_isSetCompartmentType(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Compartment's 'size' attribute is set.
   *
   * This method is similar but not identical to
   * @if java Compartment::isSetVolume()@else isSetVolume()@endif.  The latter
   * should be used in the context of SBML Level&nbsp;1 models instead of
   * @if java Compartment::isSetSize()@else isSetSize()@endif@~
   * because @if java Compartment::isSetVolume()@else isSetVolume()@endif@~
   * performs extra processing to take into account the difference in
   * default values between SBML Levels 1 and 2.
   * 
   * @return @c true if the 'size' attribute ('volume' in Level&nbsp;2) of
   * this Compartment is set, @c false otherwise.
   *
   * @see isSetVolume()
   * @see setSize(double value)
   */ public
 bool isSetSize() {
    bool ret = libsbmlPINVOKE.Compartment_isSetSize(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this Compartment's
   * 'volume' attribute is set.
   * 
   * This method is similar but not identical to
   * @if java Compartment::isSetSize()@else isSetSize()@endif.  The latter
   * should not be used in the context of SBML Level&nbsp;1 models because this
   * method performs extra processing to take into account
   * the difference in default values between SBML Levels 1 and 2.
   * 
   * @return @c true if the 'volume' attribute ('size' in Level&nbsp;2 and
   * above) of this Compartment is set, @c false otherwise.
   *
   * @note The attribute 'volume' only exists by that name in SBML
   * Level&nbsp;1.  In Level&nbsp;2 and above, the equivalent attribute is
   * named 'size'.  In SBML Level&nbsp;1, a compartment's volume has a
   * default value (@c 1.0) and therefore this method will always return @c
   * true.  In Level 2, a compartment's size (the equivalent of SBML
   * Level&nbsp;1's 'volume') is optional and has no default value, and
   * therefore may or may not be set.
   *
   * @see isSetSize()
   * @see @if java Compartment::setVolume(double value)@else setVolume()@endif@~
   */ public
 bool isSetVolume() {
    bool ret = libsbmlPINVOKE.Compartment_isSetVolume(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Compartment's 'units' attribute is set.
   * 
   * @return @c true if the 'units' attribute of this Compartment is
   * set, @c false otherwise.
   *
   * @note @htmlinclude unassigned-units-are-not-a-default.html
   */ public
 bool isSetUnits() {
    bool ret = libsbmlPINVOKE.Compartment_isSetUnits(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Compartment's 'outside' attribute is set.
   * 
   * @return @c true if the 'outside' attribute of this Compartment is
   * set, @c false otherwise.
   * 
   * @note The 'outside' attribute is defined in SBML Level&nbsp;1 and
   * Level&nbsp;2, but does not exist in SBML Level&nbsp;3 Version&nbsp;1
   * Core.
   */ public
 bool isSetOutside() {
    bool ret = libsbmlPINVOKE.Compartment_isSetOutside(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Compartment's 'spatialDimensions' attribute is set.
   * 
   * @return @c true if the 'spatialDimensions' attribute of this
   * Compartment is set, @c false otherwise.
   */ public
 bool isSetSpatialDimensions() {
    bool ret = libsbmlPINVOKE.Compartment_isSetSpatialDimensions(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Compartment's 'constant' attribute is set.
   * 
   * @return @c true if the 'constant' attribute of this Compartment is
   * set, @c false otherwise.
   */ public
 bool isSetConstant() {
    bool ret = libsbmlPINVOKE.Compartment_isSetConstant(swigCPtr);
    return ret;
  }

  
/**
   * Sets the value of the 'id' attribute of this Compartment.
   *
   * The string @p sid is copied.  Note that SBML has strict requirements
   * for the syntax of identifiers.  @htmlinclude id-syntax.html
   *
   * @param sid the string to use as the identifier of this Compartment
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
   */ public new
 int setId(string sid) {
    int ret = libsbmlPINVOKE.Compartment_setId(swigCPtr, sid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Sets the value of the 'name' attribute of this Compartment.
   *
   * The string in @p name is copied.
   *
   * @param name the new name for the Compartment
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
   */ public new
 int setName(string name) {
    int ret = libsbmlPINVOKE.Compartment_setName(swigCPtr, name);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Sets the 'compartmentType' attribute of this Compartment.
   *
   * @param sid the identifier of a CompartmentType object defined
   * elsewhere in this Model.
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
   * 
   * @note The 'compartmentType' attribute is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.
   */ public
 int setCompartmentType(string sid) {
    int ret = libsbmlPINVOKE.Compartment_setCompartmentType(swigCPtr, sid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Sets the 'spatialDimensions' attribute of this Compartment.
   *
   * If @p value is not one of @c 0, @c 1, @c 2, or @c 3, this method will
   * have no effect (i.e., the 'spatialDimensions' attribute will not be
   * set).
   * 
   * @param value a long integereger indicating the number of dimensions
   * of this compartment.
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
   */ public
 int setSpatialDimensions(long value) {
    int ret = libsbmlPINVOKE.Compartment_setSpatialDimensions__SWIG_0(swigCPtr, value);
    return ret;
  }

  
/**
   * Sets the 'spatialDimensions' attribute of this Compartment as a double.
   *
   * @param value a double indicating the number of dimensions
   * of this compartment.
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
   */ public
 int setSpatialDimensions(double value) {
    int ret = libsbmlPINVOKE.Compartment_setSpatialDimensions__SWIG_1(swigCPtr, value);
    return ret;
  }

  
/**
   * Sets the 'size' attribute (or 'volume' in SBML Level&nbsp;1) of this
   * Compartment.
   *
   * This method is identical to
   * @if java Compartment::setVolume(double value)@else setVolume()@endif@~
   * and is provided for compatibility between
   * SBML Level&nbsp;1 and Level&nbsp;2.
   *
   * @param value a @c double representing the size of this compartment
   * instance in whatever units are in effect for the compartment.
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   *
   * @note The attribute 'volume' only exists by that name in SBML
   * Level&nbsp;1.  In Level&nbsp;2 and above, the equivalent attribute is
   * named 'size'.
   */ public
 int setSize(double value) {
    int ret = libsbmlPINVOKE.Compartment_setSize(swigCPtr, value);
    return ret;
  }

  
/**
   * Sets the 'volume' attribute (or 'size' in SBML Level&nbsp;2) of this
   * Compartment.
   *
   * This method is identical to
   * @if java Compartment::setVolume(double value)@else setVolume()@endif@~
   * and is provided for compatibility between SBML Level&nbsp;1 and
   * Level&nbsp;2.
   * 
   * @param value a @c double representing the volume of this compartment
   * instance in whatever units are in effect for the compartment.
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   *
   * @note The attribute 'volume' only exists by that name in SBML
   * Level&nbsp;1.  In Level&nbsp;2 and above, the equivalent attribute is
   * named 'size'.
   */ public
 int setVolume(double value) {
    int ret = libsbmlPINVOKE.Compartment_setVolume(swigCPtr, value);
    return ret;
  }

  
/**
   * Sets the 'units' attribute of this Compartment.
   *
   * @param sid the identifier of the defined units to use.
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
   */ public
 int setUnits(string sid) {
    int ret = libsbmlPINVOKE.Compartment_setUnits(swigCPtr, sid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Sets the 'outside' attribute of this Compartment.
   *
   * @param sid the identifier of a compartment that encloses this one.
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
   *
   * @note The 'outside' attribute is defined in SBML Level&nbsp;1 and
   * Level&nbsp;2, but does not exist in SBML Level&nbsp;3 Version&nbsp;1
   * Core.
   */ public
 int setOutside(string sid) {
    int ret = libsbmlPINVOKE.Compartment_setOutside(swigCPtr, sid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Sets the value of the 'constant' attribute of this Compartment.
   *
   * @param value a bool indicating whether the size/volume of this
   * compartment should be considered constant (@c true) or variable
   * (@c false)
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
   */ public
 int setConstant(bool value) {
    int ret = libsbmlPINVOKE.Compartment_setConstant(swigCPtr, value);
    return ret;
  }

  
/**
   * Renames all the SIdRef attributes on this element, including any found in MathML
   */ public
 void renameSIdRefs(string oldid, string newid) {
    libsbmlPINVOKE.Compartment_renameSIdRefs(swigCPtr, oldid, newid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Renames all the UnitSIdRef attributes on this element
   */ public
 void renameUnitSIdRefs(string oldid, string newid) {
    libsbmlPINVOKE.Compartment_renameUnitSIdRefs(swigCPtr, oldid, newid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Unsets the value of the 'name' attribute of this Compartment.
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
   */ public new
 int unsetName() {
    int ret = libsbmlPINVOKE.Compartment_unsetName(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'compartmentType'
   * attribute of this Compartment.
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
   * 
   * @note The 'compartmentType' attribute is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.
   *
   * @see setCompartmentType(string sid)
   * @see isSetCompartmentType()
   */ public
 int unsetCompartmentType() {
    int ret = libsbmlPINVOKE.Compartment_unsetCompartmentType(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'size' attribute of this Compartment.
   * 
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
   *
   * @note The attribute 'volume' only exists by that name in SBML
   * Level&nbsp;1.  In Level&nbsp;2 and above, the equivalent attribute is
   * named 'size'.
   */ public
 int unsetSize() {
    int ret = libsbmlPINVOKE.Compartment_unsetSize(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'volume' attribute of this
   * Compartment.
   * 
   * In SBML Level&nbsp;1, a Compartment volume has a default value (@c 1.0) and
   * therefore <em>should always be set</em>.  In Level&nbsp;2, 'size' is
   * optional with no default value and as such may or may not be set.
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
   *
   * @note The attribute 'volume' only exists by that name in SBML
   * Level&nbsp;1.  In Level&nbsp;2 and above, the equivalent attribute is
   * named 'size'.
   */ public
 int unsetVolume() {
    int ret = libsbmlPINVOKE.Compartment_unsetVolume(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'units' attribute of this Compartment.
   * 
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
   */ public
 int unsetUnits() {
    int ret = libsbmlPINVOKE.Compartment_unsetUnits(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'outside' attribute of this Compartment.
   * 
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
   *
   * @note The 'outside' attribute is defined in SBML Level&nbsp;1 and
   * Level&nbsp;2, but does not exist in SBML Level&nbsp;3 Version&nbsp;1
   * Core.
   */ public
 int unsetOutside() {
    int ret = libsbmlPINVOKE.Compartment_unsetOutside(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'spatialDimensions' attribute of this Compartment.
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
   *
   * @note This function is only valid for SBML Level&nbsp;3.
   */ public
 int unsetSpatialDimensions() {
    int ret = libsbmlPINVOKE.Compartment_unsetSpatialDimensions(swigCPtr);
    return ret;
  }

  
/**
   * Constructs and returns a UnitDefinition that corresponds to the units
   * of this Compartment's designated size.
   *
   * Compartments in SBML have an attribute ('units') for declaring the
   * units of measurement intended for the value of the compartment's size.
   * In the absence of a value given for this attribute, the units are
   * inherited from values either defined on the enclosing Model (in SBML
   * Level&nbsp;3) or in defaults (in SBML Level&nbsp;2).  This method
   * returns a UnitDefinition object based on how this compartment's units
   * are interpreted according to the relevant SBML guidelines, or it
   * returns @c null if no units have been declared and no defaults are
   * defined by the relevant SBML specification.
   *
   * Note that unit declarations for Compartment objects are specified in
   * terms of the @em identifier of a unit (e.g., using
   * @if java Compartment::setUnits(String sid)@else setUnits()@endif), but
   * @em this method returns a UnitDefinition object, not a unit
   * identifier.  It does this by constructing an appropriate
   * UnitDefinition.  For SBML Level&nbsp;2 models, it will do this even
   * when the value of the 'units' attribute is one of the special SBML
   * Level&nbsp;2 unit identifiers @c 'substance', @c 'volume', @c 'area',
   * @c 'length' or @c 'time'.  Callers may find this useful in conjunction
   * with the helper methods provided by the UnitDefinition class for
   * comparing different UnitDefinition objects.
   * 
   * @return a UnitDefinition that expresses the units of this 
   * Compartment, or @c null if one cannot be constructed.
   *
   * @note The libSBML system for unit analysis depends on the model as a
   * whole.  In cases where the Compartment object has not yet been added
   * to a model, or the model itself is incomplete, unit analysis is not
   * possible, and consequently this method will return @c null.
   *
   * @see isSetUnits()
   * @see getUnits()
   */ public
 UnitDefinition getDerivedUnitDefinition() {
    IntPtr cPtr = libsbmlPINVOKE.Compartment_getDerivedUnitDefinition__SWIG_0(swigCPtr);
    UnitDefinition ret = (cPtr == IntPtr.Zero) ? null : new UnitDefinition(cPtr, false);
    return ret;
  }

  
/**
   * Returns the libSBML type code for this SBML object.
   * 
   * @if clike LibSBML attaches an identifying code to every kind of SBML
   * object.  These are known as <em>SBML type codes</em>.  The set of
   * possible type codes is defined in the enumeration #SBMLTypeCode_t.
   * The names of the type codes all begin with the characters @c
   * SBML_. @endif@if java LibSBML attaches an identifying code to every
   * kind of SBML object.  These are known as <em>SBML type codes</em>.  In
   * other languages, the set of type codes is stored in an enumeration; in
   * the Java language interface for libSBML, the type codes are defined as
   * static integer constants in the interface class {@link
   * libsbmlConstants}.  The names of the type codes all begin with the
   * characters @c SBML_. @endif@if python LibSBML attaches an identifying
   * code to every kind of SBML object.  These are known as <em>SBML type
   * codes</em>.  In the Python language interface for libSBML, the type
   * codes are defined as static integer constants in the interface class
   * @link libsbml@endlink.  The names of the type codes all begin with the
   * characters @c SBML_. @endif@if csharp LibSBML attaches an identifying
   * code to every kind of SBML object.  These are known as <em>SBML type
   * codes</em>.  In the C# language interface for libSBML, the type codes
   * are defined as static integer constants in the interface class @link
   * libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
   * the characters @c SBML_. @endif@~
   *
   * @return the SBML type code for this object, or
   * @link libsbmlcs.libsbml.SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
   *
   * @see getElementName()
   */ public new
 int getTypeCode() {
    int ret = libsbmlPINVOKE.Compartment_getTypeCode(swigCPtr);
    return ret;
  }

  
/**
   * Returns the XML element name of this object, which for Compartment, is
   * always @c 'compartment'.
   * 
   * @return the name of this element, i.e., @c 'compartment'.
   */ public new
 string getElementName() {
    string ret = libsbmlPINVOKE.Compartment_getElementName(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if
   * all the required attributes for this Compartment object
   * have been set.
   *
   * @note The required attributes for a Compartment object are:
   * @li 'id' (or 'name' in SBML Level&nbsp;1)
   * @li 'constant' (in SBML Level&nbsp;3 only)
   *
   * @return a bool value indicating whether all the required
   * attributes for this object have been defined.
   */ public new
 bool hasRequiredAttributes() {
    bool ret = libsbmlPINVOKE.Compartment_hasRequiredAttributes(swigCPtr);
    return ret;
  }

}

}
