///  @file    TestL3KineticLaw.cs
///  @brief   L3 KineticLaw unit tests
///  @author  Frank Bergmann (Csharp conversion)
///  @author  Akiya Jouraku (Csharp conversion)
///  @author  Sarah Keating
 
/// 
/// 
///  ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
/// 
///  DO NOT EDIT THIS FILE.
/// 
///  This file was generated automatically by converting the file located at
///  src/sbml/test/TestL3KineticLaw.c
///  using the conversion program dev/utilities/translateTests/translateTests.pl.
///  Any changes made here will be lost the next time the file is regenerated.
/// 
///  -----------------------------------------------------------------------------
///  This file is part of libSBML.  Please visit http://sbml.org for more
///  information about SBML, and the latest version of libSBML.
/// 
///  Copyright 2005-2010 California Institute of Technology.
///  Copyright 2002-2005 California Institute of Technology and
///                      Japan Science and Technology Corporation.
///  
///  This library is free software; you can redistribute it and/or modify it
///  under the terms of the GNU Lesser General Public License as published by
///  the Free Software Foundation.  A copy of the license agreement is provided
///  in the file named "LICENSE.txt" included with this software distribution
///  and also available online as http://sbml.org/software/libsbml/license.html
///  -----------------------------------------------------------------------------


namespace LibSBMLCSTest.sbml {

  using libsbmlcs;

  using System;

  using System.IO;

  public class TestL3KineticLaw {
    public class AssertionError : System.Exception 
    {
      public AssertionError() : base()
      {
        
      }
    }


    static void assertTrue(bool condition)
    {
      if (condition == true)
      {
        return;
      }
      throw new AssertionError();
    }

    static void assertEquals(object a, object b)
    {
      if ( (a == null) && (b == null) )
      {
        return;
      }
      else if ( (a == null) || (b == null) )
      {
        throw new AssertionError();
      }
      else if (a.Equals(b))
      {
        return;
      }
  
      throw new AssertionError();
    }

    static void assertNotEquals(object a, object b)
    {
      if ( (a == null) && (b == null) )
      {
        throw new AssertionError();
      }
      else if ( (a == null) || (b == null) )
      {
        return;
      }
      else if (a.Equals(b))
      {
        throw new AssertionError();
      }
    }

    static void assertEquals(bool a, bool b)
    {
      if ( a == b )
      {
        return;
      }
      throw new AssertionError();
    }

    static void assertNotEquals(bool a, bool b)
    {
      if ( a != b )
      {
        return;
      }
      throw new AssertionError();
    }

    static void assertEquals(int a, int b)
    {
      if ( a == b )
      {
        return;
      }
      throw new AssertionError();
    }

    static void assertNotEquals(int a, int b)
    {
      if ( a != b )
      {
        return;
      }
      throw new AssertionError();
    }

    private KineticLaw KL;

    public void setUp()
    {
      KL = new  KineticLaw(3,1);
      if (KL == null);
      {
      }
    }

    public void tearDown()
    {
      KL = null;
    }

    public void test_L3_KineticLaw_addParameter1()
    {
      KineticLaw kl = new  KineticLaw(3,1);
      Parameter p = new  Parameter(3,1);
      int i = KL.addParameter(p);
      assertTrue( i == libsbml.LIBSBML_INVALID_OBJECT );
      p.setId( "p");
      i = KL.addParameter(p);
      assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS );
      assertTrue( KL.getNumParameters() == 1 );
      assertTrue( KL.getNumLocalParameters() == 1 );
      assertTrue( kl.getNumParameters() == 0 );
      assertTrue( kl.getNumLocalParameters() == 0 );
      i = kl.addParameter(p);
      assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS );
      assertTrue( KL.getNumParameters() == 1 );
      assertTrue( KL.getNumLocalParameters() == 1 );
      assertTrue( kl.getNumParameters() == 1 );
      assertTrue( kl.getNumLocalParameters() == 1 );
      p = null;
      kl = null;
    }

    public void test_L3_KineticLaw_addParameter2()
    {
      KineticLaw kl = new  KineticLaw(3,1);
      LocalParameter lp = new  LocalParameter(3,1);
      LocalParameter lp1 = new  LocalParameter(3,1);
      int i = kl.addLocalParameter(lp);
      assertTrue( i == libsbml.LIBSBML_INVALID_OBJECT );
      lp.setId( "p");
      lp1.setId( "p1");
      i = kl.addLocalParameter(lp);
      assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS );
      assertTrue( kl.getNumParameters() == 1 );
      assertTrue( kl.getNumLocalParameters() == 1 );
      i = kl.addParameter(lp1);
      assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS );
      assertTrue( kl.getNumParameters() == 2 );
      assertTrue( kl.getNumLocalParameters() == 2 );
      lp = null;
      kl = null;
    }

    public void test_L3_KineticLaw_create()
    {
      assertTrue( KL.getTypeCode() == libsbml.SBML_KINETIC_LAW );
      assertTrue( KL.getMetaId() == "" );
      assertTrue( KL.getNotes() == null );
      assertTrue( KL.getAnnotation() == null );
      assertTrue( KL.getNumParameters() == 0 );
      assertTrue( KL.getNumLocalParameters() == 0 );
    }

    public void test_L3_KineticLaw_free_NULL()
    {
    }

  }
}
