#
# @file    TestRDFAnnotationC.py
# @brief   RDFAnnotation parser unit tests
#
# @author  Akiya Jouraku (Python conversion)
# @author  Sarah Keating 
# 
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/annotation/test/TestRDFAnnotationC.c
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------

import sys
import unittest
import libsbml


class TestRDFAnnotationC(unittest.TestCase):

  global d
  d = None
  global m
  m = None

  def setUp(self):
    filename = "../../sbml/annotation/test/test-data/annotation.xml"
    self.d = libsbml.readSBML(filename)
    self.m = self.d.getModel()
    pass  

  def tearDown(self):
    _dummyList = [ self.d ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_RDFAnnotation_C_delete(self):
    obj = self.m.getCompartment(0)
    node = libsbml.RDFAnnotationParser.parseCVTerms(obj)
    n1 = libsbml.RDFAnnotationParser.deleteRDFAnnotation(node)
    self.assertTrue( n1.getNumChildren() == 0 )
    self.assertTrue((  "annotation" == n1.getName() ))
    _dummyList = [ node ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_RDFAnnotation_C_getModelHistory(self):
    self.assertTrue( (self.m == None) == False )
    history = self.m.getModelHistory()
    self.assertTrue( history != None )
    mc = history.getCreator(0)
    self.assertTrue((  "Le Novere" == mc.getFamilyName() ))
    self.assertTrue((  "Nicolas" == mc.getGivenName() ))
    self.assertTrue((  "lenov@ebi.ac.uk" == mc.getEmail() ))
    self.assertTrue((  "EMBL-EBI" == mc.getOrganisation() ))
    date = history.getCreatedDate()
    self.assertTrue( date.getYear() == 2005 )
    self.assertTrue( date.getMonth() == 2 )
    self.assertTrue( date.getDay() == 2 )
    self.assertTrue( date.getHour() == 14 )
    self.assertTrue( date.getMinute() == 56 )
    self.assertTrue( date.getSecond() == 11 )
    self.assertTrue( date.getSignOffset() == 0 )
    self.assertTrue( date.getHoursOffset() == 0 )
    self.assertTrue( date.getMinutesOffset() == 0 )
    self.assertTrue((  "2005-02-02T14:56:11Z" == date.getDateAsString() ))
    date = history.getModifiedDate()
    self.assertTrue( date.getYear() == 2006 )
    self.assertTrue( date.getMonth() == 5 )
    self.assertTrue( date.getDay() == 30 )
    self.assertTrue( date.getHour() == 10 )
    self.assertTrue( date.getMinute() == 46 )
    self.assertTrue( date.getSecond() == 2 )
    self.assertTrue( date.getSignOffset() == 0 )
    self.assertTrue( date.getHoursOffset() == 0 )
    self.assertTrue( date.getMinutesOffset() == 0 )
    self.assertTrue((  "2006-05-30T10:46:02Z" == date.getDateAsString() ))
    pass  

  def test_RDFAnnotation_C_parseCVTerms(self):
    obj = self.m.getCompartment(0)
    node = libsbml.RDFAnnotationParser.parseCVTerms(obj)
    self.assertTrue( node.getNumChildren() == 1 )
    rdf = node.getChild(0)
    self.assertTrue((  "RDF" == rdf.getName() ))
    self.assertTrue((  "rdf" == rdf.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == rdf.getURI() ))
    self.assertTrue( rdf.getNumChildren() == 1 )
    desc = rdf.getChild(0)
    self.assertTrue((  "Description" == desc.getName() ))
    self.assertTrue((  "rdf" == desc.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == desc.getURI() ))
    self.assertTrue( desc.getNumChildren() == 1 )
    is1 = desc.getChild(0)
    self.assertTrue((  "is" == is1.getName() ))
    self.assertTrue((  "bqbiol" == is1.getPrefix() ))
    self.assertTrue( is1.getNumChildren() == 1 )
    Bag = is1.getChild(0)
    self.assertTrue((  "Bag" == Bag.getName() ))
    self.assertTrue((  "rdf" == Bag.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == Bag.getURI() ))
    self.assertTrue( Bag.getNumChildren() == 4 )
    li = Bag.getChild(0)
    self.assertTrue((  "li" == li.getName() ))
    self.assertTrue((  "rdf" == li.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == li.getURI() ))
    self.assertTrue( li.getNumChildren() == 0 )
    li1 = Bag.getChild(1)
    self.assertTrue((  "li" == li1.getName() ))
    self.assertTrue((  "rdf" == li1.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == li1.getURI() ))
    self.assertTrue( li1.getNumChildren() == 0 )
    li2 = Bag.getChild(2)
    self.assertTrue((  "li" == li2.getName() ))
    self.assertTrue((  "rdf" == li2.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == li2.getURI() ))
    self.assertTrue( li2.getNumChildren() == 0 )
    li3 = Bag.getChild(3)
    self.assertTrue((  "li" == li3.getName() ))
    self.assertTrue((  "rdf" == li3.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == li3.getURI() ))
    self.assertTrue( li3.getNumChildren() == 0 )
    _dummyList = [ node ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_RDFAnnotation_C_parseModelHistory(self):
    node = libsbml.RDFAnnotationParser.parseModelHistory(self.m)
    self.assertTrue( node.getNumChildren() == 1 )
    rdf = node.getChild(0)
    self.assertTrue((  "RDF" == rdf.getName() ))
    self.assertTrue((  "rdf" == rdf.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == rdf.getURI() ))
    self.assertTrue( rdf.getNumChildren() == 1 )
    desc = rdf.getChild(0)
    self.assertTrue((  "Description" == desc.getName() ))
    self.assertTrue((  "rdf" == desc.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == desc.getURI() ))
    self.assertTrue( desc.getNumChildren() == 3 )
    creator = desc.getChild(0)
    self.assertTrue((  "creator" == creator.getName() ))
    self.assertTrue((  "dc" == creator.getPrefix() ))
    self.assertTrue( creator.getNumChildren() == 1 )
    Bag = creator.getChild(0)
    self.assertTrue((  "Bag" == Bag.getName() ))
    self.assertTrue((  "rdf" == Bag.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == Bag.getURI() ))
    self.assertTrue( Bag.getNumChildren() == 1 )
    li = Bag.getChild(0)
    self.assertTrue((  "li" == li.getName() ))
    self.assertTrue((  "rdf" == li.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/1999/02/22-rdf-syntax-ns#" == li.getURI() ))
    self.assertTrue( li.getNumChildren() == 3 )
    N = li.getChild(0)
    self.assertTrue((  "N" == N.getName() ))
    self.assertTrue((  "vCard" == N.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/2001/vcard-rdf/3.0#" == N.getURI() ))
    self.assertTrue( N.getNumChildren() == 2 )
    Family = N.getChild(0)
    self.assertTrue((  "Family" == Family.getName() ))
    self.assertTrue((  "vCard" == Family.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/2001/vcard-rdf/3.0#" == Family.getURI() ))
    self.assertTrue( Family.getNumChildren() == 1 )
    Given = N.getChild(1)
    self.assertTrue((  "Given" == Given.getName() ))
    self.assertTrue((  "vCard" == Given.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/2001/vcard-rdf/3.0#" == Given.getURI() ))
    self.assertTrue( Given.getNumChildren() == 1 )
    EMAIL = li.getChild(1)
    self.assertTrue((  "EMAIL" == EMAIL.getName() ))
    self.assertTrue((  "vCard" == EMAIL.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/2001/vcard-rdf/3.0#" == EMAIL.getURI() ))
    self.assertTrue( EMAIL.getNumChildren() == 1 )
    ORG = li.getChild(2)
    self.assertTrue((  "ORG" == ORG.getName() ))
    self.assertTrue((  "vCard" == ORG.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/2001/vcard-rdf/3.0#" == ORG.getURI() ))
    self.assertTrue( ORG.getNumChildren() == 1 )
    Orgname = ORG.getChild(0)
    self.assertTrue((  "Orgname" == Orgname.getName() ))
    self.assertTrue((  "vCard" == Orgname.getPrefix() ))
    self.assertTrue((  "http://www.w3.org/2001/vcard-rdf/3.0#" == Orgname.getURI() ))
    self.assertTrue( Orgname.getNumChildren() == 1 )
    created = desc.getChild(1)
    self.assertTrue((  "created" == created.getName() ))
    self.assertTrue((  "dcterms" == created.getPrefix() ))
    self.assertTrue((  "http://purl.org/dc/terms/" == created.getURI() ))
    self.assertTrue( created.getNumChildren() == 1 )
    cr_date = created.getChild(0)
    self.assertTrue((  "W3CDTF" == cr_date.getName() ))
    self.assertTrue((  "dcterms" == cr_date.getPrefix() ))
    self.assertTrue((  "http://purl.org/dc/terms/" == cr_date.getURI() ))
    self.assertTrue( cr_date.getNumChildren() == 1 )
    modified = desc.getChild(2)
    self.assertTrue((  "modified" == modified.getName() ))
    self.assertTrue((  "dcterms" == modified.getPrefix() ))
    self.assertTrue((  "http://purl.org/dc/terms/" == modified.getURI() ))
    self.assertTrue( modified.getNumChildren() == 1 )
    mo_date = created.getChild(0)
    self.assertTrue((  "W3CDTF" == mo_date.getName() ))
    self.assertTrue((  "dcterms" == mo_date.getPrefix() ))
    self.assertTrue((  "http://purl.org/dc/terms/" == mo_date.getURI() ))
    self.assertTrue( mo_date.getNumChildren() == 1 )
    _dummyList = [ node ]; _dummyList[:] = []; del _dummyList
    pass  

def suite():
  suite = unittest.TestSuite()
  suite.addTest(unittest.makeSuite(TestRDFAnnotationC))

  return suite

if __name__ == "__main__":
  if unittest.TextTestRunner(verbosity=1).run(suite()).wasSuccessful() :
    sys.exit(0)
  else:
    sys.exit(1)
