# This file was automatically generated by SWIG (http://www.swig.org).
# Version 2.0.6
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

package LibSBML;
use base qw(Exporter);
use base qw(DynaLoader);
package LibSBMLc;
bootstrap LibSBML;
package LibSBML;
@EXPORT = qw();
=head1 NAME

LibSBML  -- interface to the libSBML library

=head1 SYNOPSIS

  # Change the following path to wherever your copy is installed.
  use lib '/usr/local/lib/perl5/site_perl';

  use File::Spec;
  use LibSBML;
  use strict;

  my $file     = File::Spec->rel2abs('FOO.xml');
  my $rd       = new LibSBML::SBMLReader;
  my $document = $rd->readSBML($file);
  
  # Check for reading errors:
  my $errors   = $document->getNumErrors();

  # Print errors, if any, to stderr.
  if ($errors > 0) {
    $document->printErrors();
    die "Errors while reading $file";
  }

  my $model = $document->getModel() || die "No Model found in $file";
  ... 

=head1 DESCRIPTION

The LibSBML.pm package gives access to almost all functions in libSBML
(http://sbml.org). The Perl wrapper is generated using SWIG
http://www.swig.org/ with relatively little manual intervention.  


=head1 AUTHORS

 Christoph Flamm <xtof@tbi.univie.ac.at>
 Rainer Machne   <raim@tbi.univie.ac.at>

=head1 FUNCTION INDEX

=over 8

=item getLibSBMLVersion

Returns the version number of this copy of libSBML as an integer.
@return the libSBML version as an integer; version 1.2.3 becomes 10203.


=item getLibSBMLDottedVersion

Returns the version number of this copy of libSBML as a string.
@return the libSBML version as a string; version 1.2.3 becomes
"1.2.3".

@see getLibSBMLVersionString()


=item getLibSBMLVersionString

Returns the version number of this copy of libSBML as a string without
periods.

@return the libSBML version as a string: version 1.2.3 becomes "10203".
@see getLibSBMLDottedVersion()


=item isLibSBMLCompiledWith

Returns an indication whether libSBML has been compiled with
against a specific library. 
@param option the library to test against, this can be one of
"expat", "libxml", "xerces-c", "bzip2", "zip"
@return 0 in case the libSBML has not been compiled against 
that library and non-zero otherwise (for libraries 
that define an integer version number that number will 
be returned).
@see getLibSBMLDependencyVersionOf(const char  option)


=item getLibSBMLDependencyVersionOf

Returns the version string for the dependency library used. 
@param option the library for which the version
should be retrieved, this can be one of
"expat", "libxml", "xerces-c", "bzip2", "zip"
@return NULL in case libSBML has not been compiled against 
that library and a version string otherwise.
@see isLibSBMLCompiledWith(const char  option)


=item OperationReturnValue_toString

This method takes an SBML operation return value and returns a string representing
the code.
@param returnValue the operation return value to convert to a string.
@return a human readable name for the given
@if clike #OperationReturnValues_t value@else operation return value @endif.
@note The caller does not own the returned string and is therefore not
allowed to modify it.


=back

=head2 IdList

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html Maintains a list of SIds.
@internal

=over


=item IdList::append

@internal


=item IdList::contains

@internal


=item IdList::removeIdsBefore

@internal


=item IdList::size

@internal


=back

=head2 IdentifierTransformer

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html Base class for identifier transformers.
@internal

=over


=back

=head2 ElementFilter

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html Base class for filter functions.
@htmlinclude libsbml-facility-only-warning.html
Some libSBML objects provide the ability to return lists of components.
To provide callers with greater control over exactly what is
returned, these methods take optional arguments in the form of filters.
The ElementFilter class is the parent class for these filters.

=over


=item ElementFilter::ElementFilter

Creates a new ElementFilter object.


=item ElementFilter::filter

Predicate to test elements.
This is the central predicate of the ElementFilter class.  In subclasses
of ElementFilter, callers should implement this method such that it
returns C<true> for C<element> arguments that are "desirable" and @c
false for those that are "undesirable" in whatever filtering context the
ElementFilter subclass is designed to be used.
@param element the element to be tested.
@return C<true> if the C<element> is desirable or should be kept,
C<false> otherwise.


=item ElementFilter::getUserData

Returns the user data that has been previously set via setUserData().
Callers can attach private data to ElementFilter objects using
setUserData().  This user data can be used by an application to store
custom information to be accessed by the ElementFilter in its work.  In
case of a deep copy, the data will passed as it is.  The attribute will
never be interpreted by libSBML.
@return the user data of this node, or C<NULL> if no user data has been
set.

@warning This <em>user data</em> is specific to an ElementFilter object
instance, and is not the same as the user data that may be attached to
an SBML object using SBase::setUserData().
@see setUserData()


=item ElementFilter::setUserData

Sets the user data of this element.
Callers can attach private data to ElementFilter objects using this
method, and retrieve them using getUserData().  Such user data can be
used by an application to store information to be accessed by the
ElementFilter in its work.  In case of a deep copy, this data will
passed as it is.  The attribute will never be interpreted by libSBML.
@param userData specifies the new user data.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@warning This <em>user data</em> is specific to an ElementFilter object
instance, and is not the same as the user data that may be attached to
an SBML object using SBase::setUserData().
@see getUserData()


=back

=head2 SBMLReader

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html File and text-string SBML reader.
@htmlinclude not-sbml-warning.html
The SBMLReader class provides the main interface for reading SBML content
from files and strings.  The methods for reading SBML all return an
@if python @link libsbml.SBMLDocument SBMLDocument@endlink@else SBMLDocument@endif@~
object representing the results.  In the case of failures (such as if the
SBML contains errors or a file cannot be read), the errors will be
recorded with the SBMLErrorLog object kept in the
@if python @link libsbml.SBMLDocument SBMLDocument@endlink@else SBMLDocument@endif@~
returned by SBMLReader.  Consequently, immediately after calling a method
on SBMLReader, callers should always check for errors and warnings using
the methods for this purpose provided by @if python @link
libsbml.SBMLDocument SBMLDocument@endlink@else SBMLDocument@endif.
For convenience as well as easy access from other languages besides C++,
this file also defines two global functions, @sbmlfunction{readSBML,
String} and @sbmlfunction{readSBMLFromString, String}.  They are
equivalent to creating an SBMLReader object and then calling the
@if python @link SBMLReader::readSBML() SBMLReader.readSBML()@endlink@endif@if java SBMLReader::readSBML(String)@endif@if cpp SBMLReader::readSBML()@endif@if csharp SBMLReader.readSBML()@endif@~ and
@if python @link SBMLReader::readSBMLFromString() SBMLReader.readSBMLFromString()@endlink@endif@if java SBMLReader::readSBMLFromString(String)@endif@if cpp SBMLReader::readSBMLFromString()@endif@if csharp SBMLReader.readSBMLFromString()@endif@~ methods, respectively.
@section compression Support for reading compressed files
LibSBML provides support for reading (as well as writing) compressed
SBML files.  The process is transparent to the calling
application---the application does not need to do anything
deliberate to invoke the functionality.  If a given SBML filename ends
with an extension for the I<gzip>, I<zip> or I<bzip2> compression
formats (respectively, @c .gz, @c .zip, or @c .bz2), then the methods
@if python @link SBMLReader::readSBML() SBMLReader.readSBML()@endlink@endif@if java @link SBMLReader::readSBML(String) SBMLReader.readSBML(String)@endlink@endif@if cpp SBMLReader::readSBML()@endif@if csharp SBMLReader.readSBML()@endif@~ and
@if python @link SBMLWriter::writeSBML() SBMLWriter.writeSBML()@endlink@endif@if java @link SBMLWriter::writeSBML(String) SBMLWriter.writeSBML(String)@endlink@endif@if cpp SBMLWriter::writeSBML()@endif@if csharp SBMLWriter.writeSBML()@endif@~
will automatically decompress and compress the file while reading and
writing it.  If the filename has no such extension, it will be read and
written uncompressed as normal.
The compression feature requires that the I<zlib> (for I<gzip> and @em
zip formats) and/or I<bzip2> (for I<bzip2> format) be available on the
system running libSBML, and that libSBML was configured with their
support compiled-in.  Please see the libSBML
@if java <a href="../../../libsbml-installation.html">installation instructions</a> @else <a href="libsbml-installation.html">installation instructions</a>@endif@~
for more information about this.  The methods
@if java SBMLReader::hasZlib()@else hasZlib()@endif@~ and
@if java SBMLReader::hasBzip2()@else hasBzip2()@endif@~
can be used by an application to query at run-time whether support
for the compression libraries is available in the present copy of
libSBML.

Support for compression is not mandated by the SBML standard, but
applications may find it helpful, particularly when large SBML models
are being communicated across data links of limited bandwidth.

=over


=item SBMLReader::SBMLReader

Creates a new SBMLReader object and returns it.
The libSBML SBMLReader object offers methods for reading SBML in
XML form from files and text strings.


=item SBMLReader::readSBML

C<opydoc> doc_readsbmlfromfile
This method is identical to
@if python @link SBMLReader::readSBMLFromFile() SBMLReader.readSBMLFromFile()@endlink@endif@if java @link SBMLReader::readSBMLFromFile(String) SBMLReader.readSBMLFromFile(String)@endlink@endif@if cpp SBMLReader::readSBMLFromFile()@endif@if csharp SBMLReader.readSBMLFromFile()@endif.
@param filename the name or full pathname of the file to be read.
@return a pointer to the SBMLDocument object created from the SBML
content in C<filename>.
C<opydetails> doc_note_sbmlreader_error_handling
@see readSBMLFromString(@if java String@endif)
@see SBMLError
@see SBMLDocument


=item SBMLReader::readSBMLFromFile

C<opydoc> doc_readsbmlfromfile
This method is identical to
@if python @link SBMLReader::readSBML() SBMLReader.readSBML()@endlink@endif@if java @link SBMLReader::readSBML(String) SBMLReader.readSBML(String)@endlink@endif@if cpp SBMLReader::readSBML()@endif@if csharp SBMLReader.readSBML()@endif.
@param filename the name or full pathname of the file to be read.
@return a pointer to the SBMLDocument object created from the SBML
content in C<filename>.
C<opydetails> doc_note_sbmlreader_error_handling
@see readSBMLFromString(@if java String@endif)
@see SBMLError
@see SBMLDocument


=item SBMLReader::readSBMLFromString

C<opydoc> doc_readsbmlfromstring
@param xml a string containing a full SBML model.
@return a pointer to the SBMLDocument created from the SBML content,
or a null pointer if C<xml> is null.
C<opydetails> doc_note_reading_comp
@see SBMLReader::readSBML(@if java String@endif)


=item SBMLReader::hasZlib

Static method; returns C<true> if this copy of libSBML supports
<i>gzip</I> and <i>zip</i> format compression.
@return C<true> if libSBML has been linked with the <i>zlib</i>
library, C<false> otherwise.
C<opydetails> doc_note_static_methods
@see @if clike hasBzip2() @else SBMLReader::hasBzip2()@endif@~


=item SBMLReader::hasBzip2

Static method; returns C<true> if this copy of libSBML supports
<i>bzip2</i> format compression.
@return C<true> if libSBML is linked with the <i>bzip2</i>
libraries, C<false> otherwise.
C<opydetails> doc_note_static_methods
@see @if clike hasZlib() @else SBMLReader::hasZlib()@endif@~


=item SBMLReader::readInternal

@internal


=item readSBML

C<opydoc> doc_readsbmlfromfile
@if conly
@memberof SBMLReader_t
@endif


=item readSBMLFromFile

C<opydoc> doc_readsbmlfromfile
@param filename the name or full pathname of the file to be read.
@return a pointer to the SBMLDocument structure created from the SBML
content in C<filename>.
@if conly
@memberof SBMLReader_t
@endif


=item readSBMLFromString

C<opydoc> doc_readsbmlfromstring
@param xml a string containing a full SBML model.
@return a pointer to the SBMLDocument structure created from the SBML
content in C<xml>.
C<opydetails> doc_note_reading_comp
@if conly
@memberof SBMLReader_t
@endif


=back

=head2 SBMLWriter

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html File and text-string SBML writer.
@htmlinclude not-sbml-warning.html
The SBMLWriter class is the converse of SBMLReader, and provides the
main interface for serializing SBML models into XML and writing the
result to an output stream or to files and text strings.  The methods 
for writing SBML all take an SBMLDocument object and a destination.  
They return a boolean or integer value to indicate success or failure.
@section sbmlwriter-compression Support for writing compressed files
LibSBML provides support for writing (as well as reading) compressed
SBML files.  The process is transparent to the calling
application---the application does not need to do anything
deliberate to invoke the functionality.  If a given SBML filename ends
with an extension for the I<gzip>, I<zip> or I<bzip2> compression
formats (respectively, C<&quot;.gz&quot;>,
C<&quot;.zip&quot;>, or C<&quot;.bz2&quot;>),
then the methods
SBMLWriter::writeSBML(@if java SBMLDocument, String@endif)
and SBMLReader::readSBML(@if java String@endif)
will automatically compress and decompress the file while writing and
reading it.  If the filename has no such extension, it
will be written and read uncompressed as normal.
The compression feature requires that the I<zlib> (for I<gzip> and @em
zip formats) and/or I<bzip2> (for I<bzip2> format) be available on the
system running libSBML, and that libSBML was configured with their
support compiled-in.  Please see the libSBML @if clike <a href="libsbml-installation.html">installation instructions</a>@endif@if python <a href="libsbml-installation.html">installation instructions</a>@endif@if java  <a href="../../../libsbml-installation.html">installation instructions</a>@endif@~ for 
more information about this.  The methods
SBMLWriter::hasZlib() and
SBMLWriter::hasBzip2()
can be used by an application to query at run-time whether support
for the compression libraries is available in the present copy of
libSBML.

Support for compression is not mandated by the SBML standard, but
applications may find it helpful, particularly when large SBML models
are being communicated across data links of limited bandwidth.

=over


=item SBMLWriter::SBMLWriter

Creates a new SBMLWriter.
The libSBML SBMLWriter objects offer methods for writing SBML in
XML form to files and text strings.


=item SBMLWriter::setProgramName

Sets the name of this program, i.e., the program that is about to
write out the SBMLDocument.
If the program name and version are set (see
SBMLWriter::setProgramVersion(@if java String@endif)), the
following XML comment, intended for human consumption, will be written
at the beginning of the XML document:
@verbatim
<!-- Created by <program name> version <program version>
on yyyy-MM-dd HH:mm with libSBML version <libsbml version>. -->
@endverbatim

If the program name and version are not set at some point before
calling the writeSBML() methods, no such comment is written out.
@param name the name of this program (where "this program" refers to
program in which libSBML is embedded, not libSBML itself!)
C<opydetails> doc_returns_one_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@see setProgramVersion(const std::string& version)


=item SBMLWriter::setProgramVersion

Sets the version of this program, i.e., the program that is about to
write out the SBMLDocument.
If the program version and name are set (see
SBMLWriter::setProgramName(@if java String@endif)), the
following XML comment, intended for human consumption, will be written
at the beginning of the document:
@verbatim
<!-- Created by <program name> version <program version>
on yyyy-MM-dd HH:mm with libSBML version <libsbml version>. -->
@endverbatim

If the program version and name are not set at some point before
calling the writeSBML() methods, no such comment is written out.
@param version the version of this program (where "this program"
refers to program in which libSBML is embedded, not libSBML itself!)
C<opydetails> doc_returns_one_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@see setProgramName(const std::string& name)


=item SBMLWriter::writeSBML

Writes the given SBML document to filename.
@htmlinclude assuming-compressed-file.html
@param d the SBML document to be written.
@param filename the name or full pathname of the file where the SBML
is to be written. 
@return C<true> on success and C<false> if the filename could not be
opened for writing.
@note @htmlinclude note-writing-zipped-files.html
@see setProgramVersion(const std::string& version)
@see setProgramName(const std::string& name)


=item SBMLWriter::writeSBML

Writes the given SBML document to the output stream.
@param d the SBML document to be written.
@param stream the stream object where the SBML is to be written.
@return C<true> on success and C<false> if one of the underlying
parser components fail (rare).
@see setProgramVersion(const std::string& version)
@see setProgramName(const std::string& name)


=item SBMLWriter::writeToString

@internal


=item SBMLWriter::writeSBMLToFile

Writes the given SBML document to filename.
@htmlinclude assuming-compressed-file.html
@param d the SBML document to be written.
@param filename the name or full pathname of the file where the SBML
is to be written. 
@return C<true> on success and C<false> if the filename could not be
opened for writing.
@note @htmlinclude note-writing-zipped-files.html
@see setProgramVersion(const std::string& version)
@see setProgramName(const std::string& name)


=item SBMLWriter::writeSBMLToString

Writes the given SBML document to an in-memory string and returns a
pointer to it.
The string is owned by the caller and should be freed (with C<free>())
when no longer needed.
@param d the SBML document to be written.
@return the string on success and C<0> if one of the underlying parser
components fail.
@see setProgramVersion(const std::string& version)
@see setProgramName(const std::string& name)


=item SBMLWriter::hasZlib

Predicate returning C<true> if this copy of libSBML has been linked
with the <em>zlib</em> library.
LibSBML supports reading and writing files compressed with either
bzip2 or zip/gzip compression.  The facility depends on libSBML having
been compiled with the necessary support libraries.  This method
allows a calling program to inquire whether that is the case for the
copy of libSBML it is using.
@return C<true> if libSBML is linked with zlib, C<false> otherwise.
C<opydetails> doc_note_static_methods
@see @if clike hasBzip2() @else SBMLWriter::hasBzip2() @endif@~


=item SBMLWriter::hasBzip2

Predicate returning C<true> if this copy of libSBML has been linked
with the <em>bzip2</em> library.
LibSBML supports reading and writing files compressed with either
bzip2 or zip/gzip compression.  The facility depends on libSBML having
been compiled with the necessary support libraries.  This method
allows a calling program to inquire whether that is the case for the
copy of libSBML it is using.
@return C<true> if libSBML is linked with bzip2, C<false> otherwise.
C<opydetails> doc_note_static_methods
@see @if clike hasZlib() @else SBMLWriter::hasZlib() @endif@~


=item writeSBML

Writes the given SBML document C<d> to the file named by C<filename>.
This convenience function is functionally equivalent to:
SBMLWriter_writeSBML(SBMLWriter_create(), d, filename);
@htmlinclude assuming-compressed-file.html
@param d the SBMLDocument object to be written out in XML format.
@param filename a string giving the path to a file where the XML
content is to be written.
@return C<1> on success and C<0> (zero) if C<filename> could not be
written.  Some possible reasons for failure include (a) being unable to
open the file, and (b) using a filename that indicates a compressed SBML
file (i.e., a filename ending in C<&quot;.zip&quot;> or
similar) when the compression functionality has not been enabled in
the underlying copy of libSBML.
@see SBMLWriter::hasZlib()
@see SBMLWriter::hasBzip2()
@if conly
@memberof SBMLWriter_t
@endif


=item writeSBMLToString

Writes the given SBML document C<d> to an in-memory string and returns a
pointer to it.  The string is owned by the caller and should be freed
(with free()) when no longer needed.  This convenience function is
functionally equivalent to:
SBMLWriter_writeSBMLToString(SBMLWriter_create(), d);
but does not require the caller to create an SBMLWriter object first.
@param d an SBMLDocument object to be written out in XML format.
@return the string on success and C<NULL> if one of the underlying parser
components fail.
@if clike @warning Note that the string is owned by the caller and
should be freed after it is no longer needed.@endif@~
@if conly
@memberof SBMLWriter_t
@endif


=item writeSBMLToFile

Writes the given SBML document C<d> to the file C<filename>.
This convenience function is functionally equivalent to:
SBMLWriter_writeSBMLToFile(SBMLWriter_create(), d, filename);
but that does not require the caller to create an SBMLWriter object first.
@htmlinclude assuming-compressed-file.html
@param d an SBMLDocument object to be written out in XML format.
@param filename a string giving the path to a file where the XML
content is to be written.
@return C<1> on success and C<0> (zero) if C<filename> could not be
written.  Some possible reasons for failure include (a) being unable to
open the file, and (b) using a filename that indicates a compressed SBML
file (i.e., a filename ending in C<&quot;.zip&quot;> or
similar) when the compression functionality has not been enabled in
the underlying copy of libSBML.
@if clike @warning Note that the string is owned by the caller and
should be freed (with the normal string C<free()> C++
function) after it is no longer needed.@endif@~
@see SBMLWriter::hasZlib()
@see SBMLWriter::hasBzip2()
@if conly
@memberof SBMLWriter_t
@endif


=item SBMLTypeCode_toString

This method takes an SBML type code and returns a string representing
the code.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
@return a human readable name for the given
@if clike #SBMLTypeCode_t value@else SBML type code@endif.
@note The caller does not own the returned string and is therefore not
allowed to modify it.


=back

=head2 SBase

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html SBML's <em>SBase</em> class, base class of most SBML objects.
Most components in SBML are derived from a single abstract base type,
SBase.  In addition to serving as the parent class for most other
classes of objects in SBML, this base type is designed to allow a
modeler or a software package to attach arbitrary information to each
major element or list in an SBML model.
SBase has an optional subelement called "notes".  It is intended to
serve as a place for storing optional information intended to be seen by
humans.  An example use of the "notes" element would be to contain
formatted user comments about the model element in which the "notes"
element is enclosed.  There are certain conditions on the XHTML content
permitted inside the "notes" element; please consult the <a
target="_blank" href="http://sbml.org/Documents/Specifications">SBML
specification document</a> corresponding to the SBML Level and Version
of your model for more information about the requirements for "notes"
content.

SBase has another optional subelement called "annotation".  Whereas the
"notes" element described above is a container for content to be shown
directly to humans, the "annotation" element is a container for optional
software-generated content I<not> meant to be shown to humans.  The
element's content type is <a target="_blank"
href="http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls">XML type
"any"</a>, allowing essentially arbitrary data content.  SBML places
only a few restrictions on the organization of the content; these are
intended to help software tools read and write the data as well as help
reduce conflicts between annotations added by different tools.  As is
the case with "notes", it is important to refer to the <a
target="_blank" href="http://sbml.org/Documents/Specifications">SBML
specification document</a> corresponding to the SBML Level and Version
of your model for more information about the requirements for
"annotation" content.
It is worth pointing out that the "annotation" element in the definition
of SBase exists in order that software developers may attach optional
application-specific data to the elements in an SBML model.  However, it
is important that this facility not be misused.  In particular, it is
<em>critical</em> that data essential to a model definition or that can
be encoded in existing SBML elements is <em>not</em> stored in
"annotation". Parameter values, functional dependencies between model
elements, etc., should not be recorded as annotations.  It is crucial to
keep in mind the fact that data placed in annotations can be freely
ignored by software applications.  If such data affects the
interpretation of a model, then software interoperability is greatly
impeded.

SBML Level 2 introduced an optional SBase attribute named "metaid" for
supporting metadata annotations using RDF (<a target="_blank"
href="http://www.w3.org/RDF/">Resource Description Format</a>). The
attribute value has the data type <a
href="http://www.w3.org/TR/REC-xml/#id">XML ID</a>, the XML identifier
type, which means each "metaid" value must be globally unique within an
SBML file.  (Importantly, this uniqueness criterion applies across any
attribute with type <a href="http://www.w3.org/TR/REC-xml/#id">XML
ID</a>, not just the "metaid" attribute used by SBML---something to
be aware of if your application-specific XML content inside the
"annotation" subelement happens to use <a
href="http://www.w3.org/TR/REC-xml/#id">XML ID</a>.)  The "metaid" value
serves to identify a model component for purposes such as referencing
that component from metadata placed within "annotation" subelements.
Beginning with SBML Level 2 Version 3, SBase also has an optional
attribute named "sboTerm" for supporting the use of the Systems Biology
Ontology.  In SBML proper, the data type of the attribute is a string of
the form "SBO:NNNNNNN", where "NNNNNNN" is a seven digit integer number;
libSBML simplifies the representation by only storing the "NNNNNNN"
integer portion.  Thus, in libSBML, the "sboTerm" attribute on SBase has
data type C<int>, and SBO identifiers are stored simply as integers.
(For convenience, SBase offers methods for returning both the integer
form and a text-string form of the SBO identifier.)  SBO terms are a
type of optional annotation, and each different class of SBML object
derived from SBase imposes its own requirements about the values
permitted for "sboTerm".  Please consult the SBML Level&nbsp;2
Version&nbsp;4 specification for more information about the use of SBO
and the "sboTerm" attribute.
Finally, note that, in the list of methods on SBase, there is no public
constructor because SBase is an abstract class.  The constructors reside
in the subclasses derived from SBase.
@section sbase-miriam Standard format for annotations linking data resources
SBML Level 2 Versions 2, 3 and 4, and Level&nbsp;3, define a proposed
regular format for encoding two particular categories of annotations:
(a) references to controlled vocabulary terms and database identifiers
which define and describe biological and biochemical entities in a
model; and (b) descriptions of the provenance of a model, including its
author(s) and modification history.

=over


=item SBase::accept

@internal


=item SBase::clone

Creates and returns a deep copy of this SBase object.
@return the (deep) copy of this SBase object.


=item SBase::getElementBySId

Returns the first child element found that has the given C<id> in the
model-wide C<SId> namespace, or C<NULL> if no such object is found.
@param id string representing the "id" attribute value of the object
to find.
@return pointer to the first element found with the given identifier.


=item SBase::getElementBySId

Returns the first child element found that has the given C<id> in the
model-wide C<SId> namespace, or C<NULL> if no such object is found.
@param id string representing the "id" attribute value of the object
to find.
@return pointer to the first element found with the given identifier.


=item SBase::getElementByMetaId

Returns the first child element it can find with a specific "metaid"
attribute value, or C<NULL> if no such object is found.
C<opydetails> doc_what_is_metaid
@param metaid string representing the "metaid" attribute value of the
object to find.
@return pointer to the first element found with the given meta-identifier.


=item SBase::getElementByMetaId

Returns the first child element it can find with a specific "metaid"
attribute value, or C<NULL> if no such object is found.
C<opydetails> doc_what_is_metaid
@param metaid string representing the "metaid" attribute value of the
object to find.
@return pointer to the first element found with the given meta-identifier.


=item SBase::getAllElements

Returns a List of all child SBase objects, including those nested to
an arbitrary depth.
@param filter a pointer to an ElementFilter, which causes the function 
to return only elements that match a particular set of constraints.  
If NULL (the default), the function will return all child objects.
@return a pointer to a List of pointers to all objects that are children
of this object.


=item SBase::renameSIdRefs

C<opydoc> doc_renamesidref_common


=item SBase::renameMetaIdRefs

C<opydoc> doc_renamemetasidref_common


=item SBase::renameUnitSIdRefs

C<opydoc> doc_renameunitsidref_common


=item SBase::replaceSIDWithFunction

@internal


=item SBase::divideAssignmentsToSIdByFunction

@internal


=item SBase::multiplyAssignmentsToSIdByFunction

@internal


=item SBase::getElementFromPluginsBySId

@internal


=item SBase::getElementFromPluginsByMetaId

@internal


=item SBase::hasNonstandardIdentifierBeginningWith

@internal


=item SBase::prependStringToAllIdentifiers

@internal


=item SBase::transformIdentifiers

@internal


=item SBase::getAllElementsFromPlugins

Returns a List of all child SBase objects contained in SBML package
plug-ins.

C<opydetails> doc_what_are_plugins
This method walks down the list of all SBML Level&nbsp;3 packages used
by this object and returns all child objects defined by those packages.
@param filter a pointer to an ElementFilter, which causes the function 
to return only elements that match a particular set of constraints.  
If NULL (the default), the function will return all child objects.
@return a pointer to a List of pointers to all children objects from
plug-ins.

@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item SBase::getMetaId

Returns the value of the "metaid" attribute of this SBML object.
C<opydetails> doc_what_is_metaid
@return the meta-identifier of this SBML object.
@see isSetMetaId()
@see setMetaId(const std::string& metaid)


=item SBase::getMetaId

Returns the value of the "metaid" attribute of this SBML object.
C<opydetails> doc_what_is_metaid
@return the meta-identifier of this SBML object, as a string.
@see isSetMetaId()
@see setMetaId(const std::string& metaid)


=item SBase::getId

Returns the value of the "id" attribute of this SBML object, if it has one, 
or the "variable" attribute of a Rule, or the "symbol" attribute of
an InitialAssignment.
@note Because of the inconsistent behavior of this function with 
respect to assignments and rules, it is now recommended to
use the getIdAttribute() function instead.
C<opydetails> doc_id_attribute
@return the id of this SBML object, or the "variable" if the object 
is a Rule, or the "symbol" if the object is an InitialAssignment.
@see getIdAttribute()
@see setIdAttribute(const std::string& sid)
@see isSetIdAttribute()
@see unsetIdAttribute()


=item SBase::getIdAttribute

Returns the value of the "id" attribute of this SBML object.
@note Because of the inconsistent behavior of the old SBase::getId()
function with respect to assignments and rules, it is now 
recommended to use this getIdAttribute() function instead.
C<opydetails> doc_id_attribute
@return the id of this SBML object, if set and valid for this
level and version of SBML; an empty string otherwise.
@see setIdAttribute(const std::string& sid)
@see isSetIdAttribute()
@see unsetIdAttribute()


=item SBase::getName

Returns the value of the "name" attribute of this SBML object.
C<opydetails> doc_get_name


=item SBase::getNotes

Returns the content of the "notes" subelement of this object as
a tree of XMLNode objects.
C<opydetails> doc_what_are_notes 
The "notes" element content returned by this method will be in XML
form, but libSBML does not provide an object model specifically for
the content of notes.  Callers will need to traverse the XML tree
structure using the facilities available on XMLNode and related
objects.  For an alternative method of accessing the notes, see
getNotesString().

@return the content of the "notes" subelement of this SBML object as a
tree structure composed of XMLNode objects.
@see getNotesString()
@see isSetNotes()
@see setNotes(const XMLNode  notes)
@see setNotes(const std::string& notes, bool addXHTMLMarkup)
@see appendNotes(const XMLNode  notes)
@see appendNotes(const std::string& notes)
@see unsetNotes()
@see SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode@endif)


=item SBase::getNotes

Returns the content of the "notes" subelement of this object as
a tree of XMLNode objects.
C<opydetails> doc_what_are_notes 
The "notes" element content returned by this method will be in XML
form, but libSBML does not provide an object model specifically for
the content of notes.  Callers will need to traverse the XML tree
structure using the facilities available on XMLNode and related
objects.  For an alternative method of accessing the notes, see
getNotesString().

@return the content of the "notes" subelement of this SBML object as a
tree structure composed of XMLNode objects.
@see getNotesString()
@see isSetNotes()
@see setNotes(const XMLNode  notes)
@see setNotes(const std::string& notes, bool addXHTMLMarkup)
@see appendNotes(const XMLNode  notes)
@see appendNotes(const std::string& notes)
@see unsetNotes()
@see SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode@endif)


=item SBase::getNotesString

Returns the content of the "notes" subelement of this object as a
string.

C<opydetails> doc_what_are_notes 
For an alternative method of accessing the notes, see getNotes(),
which returns the content as an XMLNode tree structure.  Depending on
an application's needs, one or the other method may be more
convenient.

@return the content of the "notes" subelement of this SBML object as a
string.

@see getNotes()
@see isSetNotes()
@see setNotes(const XMLNode  notes)
@see setNotes(const std::string& notes, bool addXHTMLMarkup)
@see appendNotes(const XMLNode  notes)
@see appendNotes(const std::string& notes)
@see unsetNotes()
@see SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode@endif)


=item SBase::getNotesString

Returns the content of the "notes" subelement of this object as a
string.

C<opydetails> doc_what_are_notes 
For an alternative method of accessing the notes, see getNotes(),
which returns the content as an XMLNode tree structure.  Depending on
an application's needs, one or the other method may be more
convenient.

@return the content of the "notes" subelement of this SBML object as a
string.

@see getNotes()
@see isSetNotes()
@see setNotes(const XMLNode  notes)
@see setNotes(const std::string& notes, bool addXHTMLMarkup)
@see appendNotes(const XMLNode  notes)
@see appendNotes(const std::string& notes)
@see unsetNotes()
@see SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode@endif)


=item SBase::getAnnotation

Returns the content of the "annotation" subelement of this object as
a tree of XMLNode objects.
C<opydetails> doc_what_are_annotations 
The annotations returned by this method will be in XML form.  LibSBML
provides an object model and related interfaces for certain specific
kinds of annotations, namely model history information and RDF
content.  See the ModelHistory, CVTerm and RDFAnnotationParser classes
for more information about the facilities available.
@return the annotation of this SBML object as a tree of XMLNode objects.
@see getAnnotationString()
@see isSetAnnotation()
@see setAnnotation(const XMLNode  annotation)
@see setAnnotation(const std::string& annotation)
@see appendAnnotation(const XMLNode  annotation)
@see appendAnnotation(const std::string& annotation)
@see unsetAnnotation()


=item SBase::getAnnotation

Returns the content of the "annotation" subelement of this object as
a tree of XMLNode objects.
C<opydetails> doc_what_are_annotations 
The annotations returned by this method will be in XML form.  LibSBML
provides an object model and related interfaces for certain specific
kinds of annotations, namely model history information and RDF
content.  See the ModelHistory, CVTerm and RDFAnnotationParser classes
for more information about the facilities available.
@return the annotation of this SBML object as a tree of XMLNode objects.
@see getAnnotationString()
@see isSetAnnotation()
@see setAnnotation(const XMLNode  annotation)
@see setAnnotation(const std::string& annotation)
@see appendAnnotation(const XMLNode  annotation)
@see appendAnnotation(const std::string& annotation)
@see unsetAnnotation()


=item SBase::getAnnotationString

Returns the content of the "annotation" subelement of this object as a
character string.
C<opydetails> doc_what_are_annotations 
The annotations returned by this method will be in string form.  See the
method getAnnotation() for a version that returns annotations in XML form.
@return the annotation of this SBML object as a character string.
@see getAnnotation()
@see isSetAnnotation()
@see setAnnotation(const XMLNode  annotation)
@see setAnnotation(const std::string& annotation)
@see appendAnnotation(const XMLNode  annotation)
@see appendAnnotation(const std::string& annotation)
@see unsetAnnotation()


=item SBase::getAnnotationString

Returns the content of the "annotation" subelement of this object as a
character string.
C<opydetails> doc_what_are_annotations
The annotations returned by this method will be in string form.  See the
method getAnnotation() for a version that returns annotations in XML form.
@return the annotation of this SBML object as a character string.
@see getAnnotation()
@see isSetAnnotation()
@see setAnnotation(const XMLNode  annotation)
@see setAnnotation(const std::string& annotation)
@see appendAnnotation(const XMLNode  annotation)
@see appendAnnotation(const std::string& annotation)
@see unsetAnnotation()


=item SBase::getNamespaces

Returns a list of the XML Namespaces declared on the SBML document
owning this object.
The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and (in
Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
@return the XML Namespaces associated with this SBML object, or C<NULL>
in certain very usual circumstances where a namespace is not set.
@see getLevel()
@see getVersion()


=item SBase::getSBMLDocument

Returns the SBMLDocument object containing this object instance.
C<opydetails> doc_what_is_SBMLDocument
This method allows the caller to obtain the SBMLDocument for the
current object.
@return the parent SBMLDocument object of this SBML object.
@see getParentSBMLObject()
@see getModel()


=item SBase::getSBMLDocument

Returns the SBMLDocument object containing this object instance.
C<opydetails> doc_what_is_SBMLDocument
This method allows the caller to obtain the SBMLDocument for the
current object.
@return the parent SBMLDocument object of this SBML object.
@see getParentSBMLObject()
@see getModel()


=item SBase::getParentSBMLObject

Returns the parent SBML object containing this object.
This returns the immediately-containing object.  This method is
convenient when holding an object nested inside other objects in an
SBML model.  
@return the parent SBML object of this SBML object.
@see getSBMLDocument()
@see getModel()


=item SBase::getParentSBMLObject

Returns the parent SBML object containing this object.
This returns the immediately-containing object.  This method is
convenient when holding an object nested inside other objects in an
SBML model.  
@return the parent SBML object of this SBML object.
@see getSBMLDocument()
@see getModel()


=item SBase::getAncestorOfType

Returns the first ancestor object that has the given SBML type code from the given package.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
This method searches the tree of objects that are parents of this
object, and returns the first one that has the given SBML type code from 
the given C<pkgName>.
@param type the SBML type code of the object sought.
@param pkgName (optional) the short name of an SBML Level&nbsp;3
package to which the sought-after object must belong.
@return the ancestor SBML object of this SBML object that corresponds
to the given @if clike #SBMLTypeCode_t value@else SBML object type
code@endif, or C<NULL> if no ancestor exists.
@warning The optional argument C<pkgName> must be used for all type codes
from SBML Level&nbsp;3 packages.  Otherwise, the function will search the 
"core" namespace alone, not find any corresponding elements, and return 
NULL.

@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item SBase::getAncestorOfType

Returns the first ancestor object that has the given SBML type code from the given package.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
This method searches the tree of objects that are parents of this
object, and returns the first one that has the given SBML type code from 
the given C<pkgName>.
@param type the SBML type code of the object sought.
@param pkgName (optional) the short name of an SBML Level&nbsp;3
package to which the sought-after object must belong.
@return the ancestor SBML object of this SBML object that corresponds
to the given @if clike #SBMLTypeCode_t value@else SBML object type
code@endif, or C<NULL> if no ancestor exists.
@warning The optional argument C<pkgName> must be used for all type codes
from SBML Level&nbsp;3 packages.  Otherwise, the function will search the 
"core" namespace alone, not find any corresponding elements, and return 
NULL.

@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item SBase::getSBOTerm

Returns the integer portion of the value of the "sboTerm" attribute of
this object.
Beginning with SBML Level 2 Version 3, objects derived from SBase have
an optional attribute named "sboTerm" for supporting the use of the
Systems Biology Ontology.  In SBML proper, the data type of the
attribute is a string of the form "SBO:NNNNNNN", where "NNNNNNN" is a
seven digit integer number; libSBML simplifies the representation by
only storing the "NNNNNNN" integer portion.  Thus, in libSBML, the
"sboTerm" attribute on SBase has data type C<int>, and SBO identifiers
are stored simply as integers.  (For convenience, libSBML offers
methods for returning both the integer form and a text-string form of
the SBO identifier.)
SBO terms are a type of optional annotation, and each different class
of SBML object derived from SBase imposes its own requirements about
the values permitted for "sboTerm".  Please consult the SBML
Level&nbsp;2 Version&nbsp;4 specification for more information about
the use of SBO and the "sboTerm" attribute.
@return the value of the "sboTerm" attribute as an integer, or C<-1>
if the value is not set.


=item SBase::getSBOTermID

Returns the string representation of the "sboTerm" attribute of
this object.
Beginning with SBML Level 2 Version 3, objects derived from SBase have
an optional attribute named "sboTerm" for supporting the use of the
Systems Biology Ontology.  In SBML proper, the data type of the
attribute is a string of the form "SBO:NNNNNNN", where "NNNNNNN" is a
seven digit integer number; libSBML simplifies the representation by
only storing the "NNNNNNN" integer portion.  Thus, in libSBML, the
"sboTerm" attribute on SBase has data type C<int>, and SBO identifiers
are stored simply as integers.  This method returns the entire SBO
identifier as a text string in the form "SBO:NNNNNNN".
SBO terms are a type of optional annotation, and each different class
of SBML object derived from SBase imposes its own requirements about
the values permitted for "sboTerm".  Please consult the SBML
Level&nbsp;2 Version&nbsp;4 specification for more information about
the use of SBO and the "sboTerm" attribute.
@return the value of the "sboTerm" attribute as a string (its value
will be of the form "SBO:NNNNNNN"), or an empty string if
the value is not set.


=item SBase::getSBOTermAsURL

Returns the URL representation of the "sboTerm" attribute of this
object.

This method returns the entire SBO identifier as a text string in the
form <code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://identifiers.org/biomodels.sbo/SBO:NNNNNNN"</code>.
SBO terms are a type of optional annotation, and each different class
of SBML object derived from SBase imposes its own requirements about
the values permitted for "sboTerm".  Please consult the SBML
Level&nbsp;2 Version&nbsp;4 specification for more information about
the use of SBO and the "sboTerm" attribute.
@return the value of the "sboTerm" attribute as an identifiers.org URL,
or an empty string if the value is not set.


=item SBase::getLine

Returns the line number where this object first appears in the XML
representation of the SBML document.
@return the line number of this SBML object.  If this object was
created programmatically and not read from a file, this method will
return the value C<0>.
@note The line number for each construct in an SBML model is set upon
reading the model.  The accuracy of the line number depends on the
correctness of the XML representation of the model, and on the
particular XML parser library being used.  The former limitation
relates to the following problem: if the model is actually invalid
XML, then the parser may not be able to interpret the data correctly
and consequently may not be able to establish the real line number.
The latter limitation is simply that different parsers seem to have
their own accuracy limitations, and out of all the parsers supported
by libSBML, none have been 100% accurate in all situations. (At this
time, libSBML supports the use of <a target="_blank"
href="http://xmlsoft.org">libxml2</a>, <a target="_blank"
href="http://expat.sourceforge.net/">Expat</a> and <a target="_blank"
href="http://xerces.apache.org/xerces-c/">Xerces</a>.)

@see getColumn()


=item SBase::getColumn

Returns the column number where this object first appears in the XML
representation of the SBML document.
@return the column number of this SBML object.  If this object was
created programmatically and not read from a file, this method will
return the value C<0>.
@note The column number for each construct in an SBML model is set
upon reading the model.  The accuracy of the column number depends on
the correctness of the XML representation of the model, and on the
particular XML parser library being used.  The former limitation
relates to the following problem: if the model is actually invalid
XML, then the parser may not be able to interpret the data correctly
and consequently may not be able to establish the real column number.
The latter limitation is simply that different parsers seem to have
their own accuracy limitations, and out of all the parsers supported
by libSBML, none have been 100% accurate in all situations. (At this
time, libSBML supports the use of <a target="_blank"
href="http://xmlsoft.org">libxml2</a>, <a target="_blank"
href="http://expat.sourceforge.net/">Expat</a> and <a target="_blank"
href="http://xerces.apache.org/xerces-c/">Xerces</a>.)

@see getLine()


=item SBase::getModelHistory

Returns the ModelHistory object, if any, attached to this object.
@return the ModelHistory object attached to this object, or C<NULL> if
none exist.
@note In SBML Level&nbsp;2, model history annotations were only
permitted on the Model element.  In SBML Level&nbsp;3, they are
permitted on all SBML components derived from SBase.


=item SBase::getModelHistory

Returns the ModelHistory object, if any, attached to this object.
@return the ModelHistory object attached to this object, or C<NULL> if
none exist.
@note In SBML Level&nbsp;2, model history annotations were only
permitted on the Model element.  In SBML Level&nbsp;3, they are
permitted on all SBML components derived from SBase.


=item SBase::isSetMetaId

Predicate returning C<true> if this object's "metaid" attribute is set.
C<opydetails> doc_what_is_metaid 
@return C<true> if the "metaid" attribute of this SBML object is
set, C<false> otherwise.
@see getMetaId()
@see setMetaId(const std::string& metaid)


=item SBase::isSetId

Predicate returning C<true> if a call to getId() returns a 
non-empty string.  This means that for most objects, this 
function will return C<true> if its "id" attribute is set, and
C<false> if it is not, or if the object has no "id" attribute
at all.  However, for an EventAssignment or a Rule, isSetId() 
checks whether the "variable" attribute is set, and for an
InitialAssignment, it checks whether the "symbol" attribute
is set.  Because those elements will also have an "id"
attribute in SBML Level&nbsp;3 Version&nbsp;2 which isSetId()
will not check, the function itself is deprecated, and it
is recommended to use isSetIdAttribute() in all cases where
one needs to know whether the "id" attribute is set, and
to use EventAssignment::isSetVariable(), Rule::isSetVariable()
and InitialAssignment::isSetSymbol() when the status of the
"variable" or "symbol" attributes need to be checked.
C<opydetails> doc_isset_id


=item SBase::isSetIdAttribute

Predicate returning C<true> if this object's "id" attribute is set.
C<opydetails> doc_id_attribute
@return C<true> if the "id" attribute of this SBML object is
set, C<false> otherwise.
@see getIdAttribute()
@see setIdAttribute(const std::string& sid)
@see unsetIdAttribute()


=item SBase::isSetName

Predicate returning C<true> if this
object's "name" attribute is set.
C<opydetails> doc_isset_name


=item SBase::isSetNotes

Predicate returning C<true> if this
object's "notes" subelement exists and has content.
The optional SBML element named "notes", present on every major SBML
component type, is intended as a place for storing optional
information intended to be seen by humans.  An example use of the
"notes" element would be to contain formatted user comments about the
model element in which the "notes" element is enclosed.  Every object
derived directly or indirectly from type SBase can have a separate
value for "notes", allowing users considerable freedom when adding
comments to their models.
The format of "notes" elements must be <a target="_blank"
href="http://www.w3.org/TR/xhtml1/">XHTML&nbsp;1.0</a>.  To help
verify the formatting of "notes" content, libSBML provides the static
utility method SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode xhtml@endif); however,
readers are urged to consult the appropriate <a target="_blank"
href="http://sbml.org/Documents/Specifications">SBML specification
document</a> for the Level and Version of their model for more
in-depth explanations.  The SBML Level&nbsp;2 and&nbsp;3
specifications have considerable detail about how "notes" element
content must be structured.
@return C<true> if a "notes" subelement exists, C<false> otherwise.
@see getNotes()
@see getNotesString()
@see setNotes(const XMLNode  notes)
@see setNotes(const std::string& notes, bool addXHTMLMarkup)
@see appendNotes(const XMLNode  notes)
@see appendNotes(const std::string& notes)
@see unsetNotes()
@see SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode@endif)


=item SBase::isSetAnnotation

Predicate returning C<true> if this
object's "annotation" subelement exists and has content.
Whereas the SBase "notes" subelement is a container for content to be
shown directly to humans, the "annotation" element is a container for
optional software-generated content I<not> meant to be shown to
humans.  Every object derived from SBase can have its own value for
"annotation".  The element's content type is <a target="_blank"
href="http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls">XML type
"any"</a>, allowing essentially arbitrary well-formed XML data
content.

SBML places a few restrictions on the organization of the content of
annotations; these are intended to help software tools read and write
the data as well as help reduce conflicts between annotations added by
different tools.  Please see the SBML specifications for more details.
@return C<true> if a "annotation" subelement exists, C<false>
otherwise.

@see getAnnotation()
@see getAnnotationString()
@see setAnnotation(const XMLNode  annotation)
@see setAnnotation(const std::string& annotation)
@see appendAnnotation(const XMLNode  annotation)
@see appendAnnotation(const std::string& annotation)
@see unsetAnnotation()


=item SBase::isSetSBOTerm

Predicate returning C<true> if this
object's "sboTerm" attribute is set.
@return C<true> if the "sboTerm" attribute of this SBML object is
set, C<false> otherwise.


=item SBase::setMetaId

Sets the value of the meta-identifier attribute of this SBML object.
C<opydetails> doc_what_is_metaid 
The string C<metaid> is copied.  
@param metaid the identifier string to use as the value of the
"metaid" attribute.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@see getMetaId()
@see isSetMetaId()


=item SBase::isSetModelHistory

Predicate returning C<true> if this
object has a ModelHistory object attached to it.
@return C<true> if the ModelHistory of this object is set, @c
false otherwise.
@note In SBML Level&nbsp;2, model history annotations were only
permitted on the Model element.  In SBML Level&nbsp;3, they are
permitted on all SBML components derived from SBase.


=item SBase::setId

Sets the value of the "id" attribute of this SBML object.
C<opydetails> doc_set_id


=item SBase::setIdAttribute

Sets the value of the "id" attribute of this SBML object.
C<opydetails> doc_set_id


=item SBase::setName

Sets the value of the "name" attribute of this SBML object.
C<opydetails> doc_set_name


=item SBase::setAnnotation

Sets the value of the "annotation" subelement of this SBML object.
The content of C<annotation> is copied, and any previous content of
this object's "annotation" subelement is deleted.
Whereas the SBase "notes" subelement is a container for content to be
shown directly to humans, the "annotation" element is a container for
optional software-generated content I<not> meant to be shown to
humans.  Every object derived from SBase can have its own value for
"annotation".  The element's content type is <a target="_blank"
href="http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls">XML type
"any"</a>, allowing essentially arbitrary well-formed XML data
content.

SBML places a few restrictions on the organization of the content of
annotations; these are intended to help software tools read and write
the data as well as help reduce conflicts between annotations added by
different tools.  Please see the SBML specifications for more details.
Call this method will result in any existing content of the
"annotation" subelement to be discarded.  Unless you have taken steps
to first copy and reconstitute any existing annotations into the @p
annotation that is about to be assigned, it is likely that performing
such wholesale replacement is unfriendly towards other software
applications whose annotations are discarded.  An alternative may be
to use SBase::appendAnnotation(const XMLNode  annotation) or
SBase::appendAnnotation(const std::string& annotation).
@param annotation an XML structure that is to be used as the new content
of the "annotation" subelement of this object.
C<opydetails> doc_returns_one_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@see getAnnotationString()
@see isSetAnnotation()
@see setAnnotation(const std::string& annotation)
@see appendAnnotation(const XMLNode  annotation)
@see appendAnnotation(const std::string& annotation)
@see unsetAnnotation()


=item SBase::setAnnotation

Sets the value of the "annotation" subelement of this SBML object.
The content of C<annotation> is copied, and any previous content of
this object's "annotation" subelement is deleted.
Whereas the SBase "notes" subelement is a container for content to be
shown directly to humans, the "annotation" element is a container for
optional software-generated content I<not> meant to be shown to
humans.  Every object derived from SBase can have its own value for
"annotation".  The element's content type is <a target="_blank"
href="http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls">XML type
"any"</a>, allowing essentially arbitrary well-formed XML data
content.

SBML places a few restrictions on the organization of the content of
annotations; these are intended to help software tools read and write
the data as well as help reduce conflicts between annotations added by
different tools.  Please see the SBML specifications for more details.
Call this method will result in any existing content of the
"annotation" subelement to be discarded.  Unless you have taken steps
to first copy and reconstitute any existing annotations into the @p
annotation that is about to be assigned, it is likely that performing
such wholesale replacement is unfriendly towards other software
applications whose annotations are discarded.  An alternative may be
to use SBase::appendAnnotation(const XMLNode  annotation) or
SBase::appendAnnotation(const std::string& annotation).
@param annotation an XML string that is to be used as the content
of the "annotation" subelement of this object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@see getAnnotationString()
@see isSetAnnotation()
@see setAnnotation(const XMLNode  annotation)
@see appendAnnotation(const XMLNode  annotation)
@see appendAnnotation(const std::string& annotation)
@see unsetAnnotation()


=item SBase::appendAnnotation

Appends the given C<annotation> to the "annotation" subelement of this
object.

Whereas the SBase "notes" subelement is a container for content to be
shown directly to humans, the "annotation" element is a container for
optional software-generated content I<not> meant to be shown to
humans.  Every object derived from SBase can have its own value for
"annotation".  The element's content type is <a
target="_blank"
href="http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls">XML type "any"</a>,
allowing essentially arbitrary well-formed XML data content.
SBML places a few restrictions on the organization of the content of
annotations; these are intended to help software tools read and write
the data as well as help reduce conflicts between annotations added by
different tools.  Please see the SBML specifications for more details.
Unlike SBase::setAnnotation(const XMLNode  annotation) or
SBase::setAnnotation(const std::string& annotation), this method
allows other annotations to be preserved when an application adds its
own data.
@param annotation an XML structure that is to be copied and appended
to the content of the "annotation" subelement of this object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
(if the parent element does not have the 'metaid' attribute set)
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_ANNOTATION_NS LIBSBML_DUPLICATE_ANNOTATION_NS@endlink
(if the parent was already annotated with the annotation in question)
@see getAnnotationString()
@see isSetAnnotation()
@see setAnnotation(const XMLNode  annotation)
@see setAnnotation(const std::string& annotation)
@see appendAnnotation(const std::string& annotation)
@see unsetAnnotation()


=item SBase::appendAnnotation

Appends the given C<annotation> to the "annotation" subelement of this
object.

Whereas the SBase "notes" subelement is a container for content to be
shown directly to humans, the "annotation" element is a container for
optional software-generated content I<not> meant to be shown to
humans.  Every object derived from SBase can have its own value for
"annotation".  The element's content type is <a
target="_blank"
href="http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls">XML type "any"</a>,
allowing essentially arbitrary well-formed XML data content.
SBML places a few restrictions on the organization of the content of
annotations; these are intended to help software tools read and write
the data as well as help reduce conflicts between annotations added by
different tools.  Please see the SBML specifications for more details.
Unlike SBase::setAnnotation(const XMLNode  annotation) or
SBase::setAnnotation(const std::string& annotation), this method
allows other annotations to be preserved when an application adds its
own data.
@param annotation an XML string that is to be copied and appended
to the content of the "annotation" subelement of this object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
(if the parent element does not have the 'metaid' attribute set)
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_ANNOTATION_NS LIBSBML_DUPLICATE_ANNOTATION_NS@endlink
(if the parent was already annotated with the annotation in question)
@see getAnnotationString()
@see isSetAnnotation()
@see setAnnotation(const XMLNode  annotation)
@see setAnnotation(const std::string& annotation)
@see appendAnnotation(const XMLNode  annotation)
@see unsetAnnotation()


=item SBase::removeTopLevelAnnotationElement

Removes the top-level element within the "annotation" subelement of this
SBML object with the given name and optional URI.
SBML places a few restrictions on the organization of the content of
annotations; these are intended to help software tools read and write
the data as well as help reduce conflicts between annotations added by
different tools.  Please see the SBML specifications for more details.
Calling this method allows a particular annotation element to be removed
whilst the remaining annotations remain intact.
@param elementName a string representing the name of the top level
annotation element that is to be removed.
@param elementURI an optional string that is used to check both the name
and URI of the top level element to be removed.
@param removeEmpty if after removing of the element, the annotation is 
empty, and the removeEmpty argument is true, the annotation node will be 
deleted (default). 
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@li @link OperationReturnValues_t#LIBSBML_ANNOTATION_NAME_NOT_FOUND LIBSBML_ANNOTATION_NAME_NOT_FOUND@endlink
@li @link OperationReturnValues_t#LIBSBML_ANNOTATION_NS_NOT_FOUND LIBSBML_ANNOTATION_NS_NOT_FOUND@endlink
@see replaceTopLevelAnnotationElement(const XMLNode  )
@see replaceTopLevelAnnotationElement(const std::string&)


=item SBase::replaceTopLevelAnnotationElement

Replaces the given top-level element within the "annotation" 
subelement of this SBML object and with the annotation element supplied.
SBML places a few restrictions on the organization of the content of
annotations; these are intended to help software tools read and write
the data as well as help reduce conflicts between annotations added by
different tools.  Please see the SBML specifications for more details.
This method determines the name of the element to be replaced from the
annotation argument. Functionally it is equivalent to calling C<
removeTopLevelAnnotationElement(name)> followed by calling
C<appendAnnotation(annotation_with_name)>, with the exception
that the placement of the annotation element remains the same.
@param annotation XMLNode representing the replacement top level annotation.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@see removeTopLevelAnnotationElement(const std::string elementName, const std::string elementURI, bool removeEmpty)
@see replaceTopLevelAnnotationElement(const std::string&)


=item SBase::replaceTopLevelAnnotationElement

Replaces the given top-level element within the "annotation" 
subelement of this SBML object and with the annotation element supplied.
SBML places a few restrictions on the organization of the content of
annotations; these are intended to help software tools read and write
the data as well as help reduce conflicts between annotations added by
different tools.  Please see the SBML specifications for more details.
This method determines the name of the element to be replaced from the
annotation argument. Functionally it is equivalent to calling C<
removeTopLevelAnnotationElement(name)> followed by calling
C<appendAnnotation(annotation_with_name)>, with the exception
that the placement of the annotation element remains the same.
@param annotation string representing the replacement top level annotation.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@see removeTopLevelAnnotationElement(const std::string elementName, const std::string elementURI)
@see replaceTopLevelAnnotationElement(const XMLNode )


=item SBase::setNotes

Sets the value of the "notes" subelement of this SBML object.
The content of C<notes> is copied, and any existing content of this
object's "notes" subelement is deleted.
The optional SBML element named "notes", present on every major SBML
component type, is intended as a place for storing optional
information intended to be seen by humans.  An example use of the
"notes" element would be to contain formatted user comments about the
model element in which the "notes" element is enclosed.  Every object
derived directly or indirectly from type SBase can have a separate
value for "notes", allowing users considerable freedom when adding
comments to their models.
The format of "notes" elements must be <a target="_blank"
href="http://www.w3.org/TR/xhtml1/">XHTML&nbsp;1.0</a>.  To help
verify the formatting of "notes" content, libSBML provides the static
utility method SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode xhtml@endif); however,
readers are urged to consult the appropriate <a target="_blank"
href="http://sbml.org/Documents/Specifications">SBML specification
document</a> for the Level and Version of their model for more
in-depth explanations.  The SBML Level&nbsp;2 and&nbsp;3
specifications have considerable detail about how "notes" element
content must be structured.
@param notes an XML structure that is to be used as the content of the
"notes" subelement of this object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@see getNotesString()
@see isSetNotes()
@see setNotes(const std::string& notes, bool addXHTMLMarkup)
@see appendNotes(const XMLNode  notes)
@see appendNotes(const std::string& notes)
@see unsetNotes()
@see SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode@endif)


=item SBase::setNotes

Sets the value of the "notes" subelement of this SBML object to a copy
of the string C<notes>.
The content of C<notes> is copied, and any existing content of this
object's "notes" subelement is deleted.
The optional SBML element named "notes", present on every major SBML
component type, is intended as a place for storing optional
information intended to be seen by humans.  An example use of the
"notes" element would be to contain formatted user comments about the
model element in which the "notes" element is enclosed.  Every object
derived directly or indirectly from type SBase can have a separate
value for "notes", allowing users considerable freedom when adding
comments to their models.
The format of "notes" elements must be <a target="_blank"
href="http://www.w3.org/TR/xhtml1/">XHTML&nbsp;1.0</a>.  To help
verify the formatting of "notes" content, libSBML provides the static
utility method SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode@endif); however,
readers are urged to consult the appropriate <a target="_blank"
href="http://sbml.org/Documents/Specifications">SBML specification
document</a> for the Level and Version of their model for more
in-depth explanations.  The SBML Level&nbsp;2 and&nbsp;3
specifications have considerable detail about how "notes" element
content must be structured.
The following code illustrates a very simple way of setting the notes
using this method.  Here, the object being annotated is the whole SBML
document, but that is for illustration purposes only; you could of
course use this same approach to annotate any other SBML component.
@if cpp
C<ode{>.cpp}
SBMLDocument  s = new SBMLDocument(3, 1);
s->setNotes("<body xmlns='http://www.w3.org/1999/xhtml'><p>here is my note</p></body>");
@endcode
@endif
@if java
C<ode{>.java}
SBMLDocument s = new SBMLDocument(3, 1);
s.setNotes("<body xmlns='http://www.w3.org/1999/xhtml'><p>here is my note</p></body>");
@endcode
@endif
@if python
C<ode{>.py}
try:
sbmlDoc = SBMLDocument(3, 1)
except ValueError:
print('Could not create SBMLDocument object')
sys.exit(1)

note = "<body xmlns='http://www.w3.org/1999/xhtml'><p>here is my note</p></body>"
status = sbmlDoc.setNotes(note)
if status != LIBSBML_OPERATION_SUCCESS:
# Do something to handle the error here.
print("Unable to set notes on the SBML document object")
sys.exit(1)
@endcode
@endif
@if csharp
C<ode>
SBMLDocument s = new SBMLDocument(3, 1);
s.setNotes("<body xmlns='http://www.w3.org/1999/xhtml'><p>here is my note</p></body>");
@endcode
@endif@~
@param notes an XML string that is to be used as the content of the
"notes" subelement of this object.
@param addXHTMLMarkup a boolean indicating whether to wrap the contents
of the C<notes> argument with XHTML paragraph (C<&lt;p&gt;>)
tags.  This is appropriate when the string in C<notes> does not already
containg the appropriate XHTML markup.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@see getNotesString()
@see isSetNotes()
@see setNotes(const XMLNode  notes)
@see appendNotes(const XMLNode  notes)
@see appendNotes(const std::string& notes)
@see unsetNotes()
@see SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode@endif)


=item SBase::appendNotes

Appends the given C<notes> to the "notes" subelement of this object.
The content of C<notes> is copied.
The optional SBML element named "notes", present on every major SBML
component type, is intended as a place for storing optional
information intended to be seen by humans.  An example use of the
"notes" element would be to contain formatted user comments about the
model element in which the "notes" element is enclosed.  Every object
derived directly or indirectly from type SBase can have a separate
value for "notes", allowing users considerable freedom when adding
comments to their models.
The format of "notes" elements must be <a target="_blank"
href="http://www.w3.org/TR/xhtml1/">XHTML&nbsp;1.0</a>.  To help
verify the formatting of "notes" content, libSBML provides the static
utility method SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode@endif); however,
readers are urged to consult the appropriate <a target="_blank"
href="http://sbml.org/Documents/Specifications">SBML specification
document</a> for the Level and Version of their model for more
in-depth explanations.  The SBML Level&nbsp;2 and&nbsp;3
specifications have considerable detail about how "notes" element
content must be structured.
@param notes an XML node structure that is to appended to the content
of the "notes" subelement of this object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@see getNotesString()
@see isSetNotes()
@see setNotes(const XMLNode  notes)
@see setNotes(const std::string& notes, bool addXHTMLMarkup)
@see appendNotes(const std::string& notes)
@see unsetNotes()
@see SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode@endif)


=item SBase::appendNotes

Appends the given C<notes> to the "notes" subelement of this object.
The content of the parameter C<notes> is copied.
The optional SBML element named "notes", present on every major SBML
component type, is intended as a place for storing optional
information intended to be seen by humans.  An example use of the
"notes" element would be to contain formatted user comments about the
model element in which the "notes" element is enclosed.  Every object
derived directly or indirectly from type SBase can have a separate
value for "notes", allowing users considerable freedom when adding
comments to their models.
The format of "notes" elements must be <a target="_blank"
href="http://www.w3.org/TR/xhtml1/">XHTML&nbsp;1.0</a>.  To help
verify the formatting of "notes" content, libSBML provides the static
utility method SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode@endif); however,
readers are urged to consult the appropriate <a target="_blank"
href="http://sbml.org/Documents/Specifications">SBML specification
document</a> for the Level and Version of their model for more
in-depth explanations.  The SBML Level&nbsp;2 and&nbsp;3
specifications have considerable detail about how "notes" element
content must be structured.
@param notes an XML string that is to appended to the content of
the "notes" subelement of this object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@see getNotesString()
@see isSetNotes()
@see setNotes(const XMLNode  notes)
@see setNotes(const std::string& notes, bool addXHTMLMarkup)
@see appendNotes(const XMLNode  notes)
@see unsetNotes()
@see SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode@endif)


=item SBase::setModelHistory

Sets the ModelHistory of this object.
The content of C<history> is copied, and this object's existing model
history content is deleted.
@param history ModelHistory of this object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@note In SBML Level&nbsp;2, model history annotations were only
permitted on the Model element.  In SBML Level&nbsp;3, they are
permitted on all SBML components derived from SBase.


=item SBase::setSBMLDocument

@internal


=item SBase::connectToParent

@internal


=item SBase::setSBOTerm

Sets the value of the "sboTerm" attribute.
Beginning with SBML Level 2 Version 3, objects derived from SBase have
an optional attribute named "sboTerm" for supporting the use of the
Systems Biology Ontology.  In SBML proper, the data type of the
attribute is a string of the form "SBO:NNNNNNN", where "NNNNNNN" is a
seven digit integer number; libSBML simplifies the representation by
only storing the "NNNNNNN" integer portion.  Thus, in libSBML, the
"sboTerm" attribute on SBase has data type C<int>, and SBO identifiers
are stored simply as integers. 
SBO terms are a type of optional annotation, and each different class
of SBML object derived from SBase imposes its own requirements about
the values permitted for "sboTerm".  Please consult the SBML
Level&nbsp;2 Version&nbsp;4 specification for more information about
the use of SBO and the "sboTerm" attribute.
@param value the NNNNNNN integer portion of the SBO identifier.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@see setSBOTerm(const std::string &sboid)


=item SBase::setSBOTerm

Sets the value of the "sboTerm" attribute by string.
Beginning with SBML Level 2 Version 3, objects derived from SBase have
an optional attribute named "sboTerm" for supporting the use of the
Systems Biology Ontology.  In SBML proper, the data type of the
attribute is a string of the form "SBO:NNNNNNN", where "NNNNNNN" is a
seven digit integer number; libSBML simplifies the representation by
only storing the "NNNNNNN" integer portion.  Thus, in libSBML, the
"sboTerm" attribute on SBase has data type C<int>, and SBO identifiers
are stored simply as integers.  This method lets you set the value of
"sboTerm" as a complete string of the form "SBO:NNNNNNN", whereas
SBase::setSBOTerm(int value) allows you to set it using the integer form.
SBO terms are a type of optional annotation, and each different class
of SBML object derived from SBase imposes its own requirements about
the values permitted for "sboTerm".  Please consult the SBML
Level&nbsp;2 Version&nbsp;4 specification for more information about
the use of SBO and the "sboTerm" attribute.
@param sboid the SBO identifier string of the form "SBO:NNNNNNN".
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@see setSBOTerm(int value)


=item SBase::setNamespaces

Sets the namespaces relevant of this SBML object.
The content of C<xmlns> is copied, and this object's existing
namespace content is deleted.
The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
@param xmlns the namespaces to set.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink


=item SBase::unsetMetaId

Unsets the value of the "metaid" attribute of this SBML object.
C<opydetails> doc_what_is_metaid 
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink


=item SBase::unsetId

Unsets the value of the "id" attribute of this SBML object.
C<opydetails> doc_unset_id


=item SBase::unsetIdAttribute

Unsets the value of the "id" attribute of this SBML object.
Most (but not all) objects in SBML include two common attributes: "id"
and "name".  The identifier given by an object's "id" attribute value
is used to identify the object within the SBML model definition.
Other objects can refer to the component using this identifier.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@see getIdAttribute()
@see setIdAttribute(const std::string& sid)
@see isSetIdAttribute()


=item SBase::unsetName

Unsets the value of the "name" attribute of this SBML object.
C<opydetails> doc_unset_name


=item SBase::unsetNotes

Unsets the value of the "notes" subelement of this SBML object.
The optional SBML element named "notes", present on every major SBML
component type, is intended as a place for storing optional
information intended to be seen by humans.  An example use of the
"notes" element would be to contain formatted user comments about the
model element in which the "notes" element is enclosed.  Every object
derived directly or indirectly from type SBase can have a separate
value for "notes", allowing users considerable freedom when adding
comments to their models.
The format of "notes" elements must be <a target="_blank"
href="http://www.w3.org/TR/xhtml1/">XHTML&nbsp;1.0</a>.  To help
verify the formatting of "notes" content, libSBML provides the static
utility method SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode@endif); however,
readers are urged to consult the appropriate <a target="_blank"
href="http://sbml.org/Documents/Specifications">SBML specification
document</a> for the Level and Version of their model for more
in-depth explanations.  The SBML Level&nbsp;2 and&nbsp;3
specifications have considerable detail about how "notes" element
content must be structured.
C<opydetails> doc_returns_one_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@see getNotesString()
@see isSetNotes()
@see setNotes(const XMLNode  notes)
@see setNotes(const std::string& notes, bool addXHTMLMarkup)
@see appendNotes(const XMLNode  notes)
@see appendNotes(const std::string& notes)
@see SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode@endif)


=item SBase::unsetAnnotation

Unsets the value of the "annotation" subelement of this SBML object.
Whereas the SBase "notes" subelement is a container for content to be
shown directly to humans, the "annotation" element is a container for
optional software-generated content I<not> meant to be shown to
humans.  Every object derived from SBase can have its own value for
"annotation".  The element's content type is <a target="_blank"
href="http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls">XML type
"any"</a>, allowing essentially arbitrary well-formed XML data
content.

SBML places a few restrictions on the organization of the content of
annotations; these are intended to help software tools read and write
the data as well as help reduce conflicts between annotations added by
different tools.  Please see the SBML specifications for more details.
C<opydetails> doc_returns_one_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@see getAnnotation()
@see getAnnotationString()
@see isSetAnnotation()
@see setAnnotation(const XMLNode  annotation)
@see setAnnotation(const std::string& annotation)
@see appendAnnotation(const XMLNode  annotation)
@see appendAnnotation(const std::string& annotation)


=item SBase::unsetSBOTerm

Unsets the value of the "sboTerm" attribute of this SBML object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink


=item SBase::addCVTerm

Adds a copy of the given CVTerm object to this SBML object.
@param term the CVTerm to assign.
@param newBag if C<true>, creates a new RDF bag with the same identifier
as a previous bag, and if C<false>, adds the term to an existing
RDF bag with the same type of qualifier as the term being added.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink, if
this object lacks a "metaid" attribute
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@note Since the CV Term uses the "metaid" attribute of the object as a
reference, if the object has no "metaid" attribute value set, then the
CVTerm will not be added.
C<opydetails> doc_note_object_is_copied
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item SBase::getCVTerms

Returns a list of CVTerm objects in the annotations of this SBML
object.

@return the list of CVTerms for this SBML object.


=item SBase::getCVTerms

Returns a list of CVTerm objects in the annotations of this SBML
object.

@return the list of CVTerms for this SBML object.


=item SBase::getNumCVTerms

Returns the number of CVTerm objects in the annotations of this SBML
object.

@return the number of CVTerms for this SBML object.


=item SBase::getCVTerm

Returns the nth CVTerm in the list of CVTerms of this SBML
object.

@param n unsigned int the index of the CVTerm to retrieve.
@return the nth CVTerm in the list of CVTerms for this SBML object.


=item SBase::unsetCVTerms

Clears the list of CVTerm objects attached to this SBML object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink


=item SBase::unsetModelHistory

Unsets the ModelHistory object attached to this object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@note In SBML Level&nbsp;2, model history annotations were only
permitted on the Model element.  In SBML Level&nbsp;3, they are
permitted on all SBML components derived from SBase.


=item SBase::getResourceBiologicalQualifier

Returns the MIRIAM <em>biological qualifier</em> associated with the
given resource.
In <a target="_blank" href="http://biomodels.net/miriam">MIRIAM</a>,
qualifiers are an optional means of indicating the relationship
between a model component and its annotations.  There are two broad
kinds of annotations: <em>model</em> and <em>biological</em>.  The
latter kind is used to qualify the relationship between a model
component and a biological entity which it represents.  Examples of
relationships include "is" and "has part", but many others are
possible.  MIRIAM defines <a target="_blank"
href="http://www.ebi.ac.uk/miriam/main/qualifiers/">numerous
relationship qualifiers</a> to enable different software tools to
qualify biological annotations in the same standardized way.  In
libSBML, the MIRIAM controlled-vocabulary annotations on an SBML model
element are represented using lists of CVTerm objects, and the
the MIRIAM biological qualifiers are represented using
values @if clike from the enumeration
type #BiolQualifierType_t.@endif@if python whose
names begin with C<BQB_> in the interface class
@link libsbml libsbml@endlink.@endif@if java whose
names begin with C<BQB_> in the interface class
{@link libsbmlConstants}.@endif@if csharp whose
names begin with C<BQB_> in the interface class
@link libsbmlcs.libsbml libsbml@endlink.@endif@~
This method searches the controlled-vocabulary annotations
(i.e., the list of CVTerm objects) on the present object, then out of
those that have biological qualifiers, looks for an annotation to the
given C<resource>.  If such an annotation is found, it returns the
type of biological qualifier associated with that resource as a 
value @if clike from the enumeration type
#BiolQualifierType_t.@endif@if python whose name begins with
C<BQB_> from the interface
class @link libsbml libsbml@endlink.@endif@if java whose name
begins with C<BQB_> from the interface
class {@link libsbmlConstants}.@endif@if csharp whose
names begin with C<BQB_> in the interface class
@link libsbmlcs.libsbml libsbml@endlink.@endif@~
@param resource string representing the resource; e.g.,
C<"http://www.geneontology.org/#GO:0005892">.

@return the qualifier associated with the resource,
or @link BiolQualifierType_t#BQB_UNKNOWN BQB_UNKNOWN@endlink if the
resource does not exist.
@if clike
@note The set of MIRIAM biological qualifiers grows over
time, although relatively slowly.  The values in the enumeration
#BiolQualifierType_t are up to date with MIRIAM at the time of a given
libSBML release.  The set of values may be expanded in later libSBML
releases, to match the values defined by MIRIAM at that later time.
@endif@if python
@note The set of MIRIAM biological qualifiers grows over
time, although relatively slowly.  The values are up to date with
MIRIAM at the time of a given libSBML release.  The set of values in
list of C<BQB_> constants defined in @link libsbml
libsbml@endlink may be expanded in later libSBML releases, to match
the values defined by MIRIAM at that later time.
@endif@if java
@note The set of MIRIAM biological qualifiers grows over
time, although relatively slowly.  The values are up to date with
MIRIAM at the time of a given libSBML release.  The set of values in
list of C<BQB_> constants defined in {@link libsbmlConstants}
may be expanded in later libSBML releases, to match
the values defined by MIRIAM at that later time.
@endif@if csharp
@note The set of MIRIAM biological qualifiers grows over
time, although relatively slowly.  The values are up to date with
MIRIAM at the time of a given libSBML release.  The set of values in
list of C<BQB_> constants defined in @link libsbmlcs.libsbml libsbml@endlink
may be expanded in later libSBML releases, to match
the values defined by MIRIAM at that later time.
@endif@~


=item SBase::getResourceModelQualifier

Returns the MIRIAM <em>model qualifier</em> associated with the
given resource.
In <a target="_blank" href="http://biomodels.net/miriam">MIRIAM</a>,
qualifiers are an optional means of indicating the relationship
between a model component and its annotations.  There are two broad
kinds of annotations: <em>model</em> and <em>biological</em>.  The
former kind is used to qualify the relationship between a model
component and another modeling object.  An example qualifier is
"isDerivedFrom", to indicate that a given component of the model is
derived from the modeling object represented by the referenced
resource.  MIRIAM defines <a target="_blank"
href="http://www.ebi.ac.uk/miriam/main/qualifiers/">numerous
relationship qualifiers</a> to enable different software tools to
qualify model annotations in the same standardized way.  In libSBML,
the MIRIAM controlled-vocabulary annotations on an SBML model element
are represented using lists of CVTerm objects, and the 
the MIRIAM model qualifiers are represented using
values @if clike from the enumeration
type #ModelQualifierType_t.@endif@if python whose
names begin with C<BQM_> in the interface class
@link libsbml libsbml@endlink.@endif@if java whose
names begin with C<BQM_> in the interface class
{@link libsbmlConstants}.@endif@if csharp whose
names begin with C<BQB_> in the interface class
@link libsbmlcs.libsbml libsbml@endlink.@endif@~
This method method searches the controlled-vocabulary annotations
(i.e., the list of CVTerm objects) on the present object, then out of
those that have model qualifiers, looks for an annotation to the given
C<resource>.  If such an annotation is found, it returns the type of
type of model qualifier associated with that resource as a 
value @if clike from the enumeration type
#ModelQualifierType_t.@endif@if python whose name begins with
C<BQM_> from the interface
class @link libsbml libsbml@endlink.@endif@if java whose name
begins with C<BQM_> from the interface
class {@link libsbmlConstants}.@endif@if csharp whose
names begin with C<BQB_> in the interface class
@link libsbmlcs.libsbml libsbml@endlink.@endif@~
@param resource string representing the resource; e.g.,
C<"http://www.geneontology.org/#GO:0005892">.

@return the @if clike #ModelQualifierType_t value@else model qualifier
type@endif@~ associated with the resource, or @link   ModelQualifierType_t#BQM_UNKNOWN BQM_UNKNOWN@endlink if the resource does not exist.
@if clike
@note The set of MIRIAM biological qualifiers grows over
time, although relatively slowly.  The values in the enumeration
#ModelQualifierType_t are up to date with MIRIAM at the time of a given
libSBML release.  The set of values may be expanded in later libSBML
releases, to match the values defined by MIRIAM at that later time.
@endif@if python
@note The set of MIRIAM model qualifiers grows over
time, although relatively slowly.  The values are up to date with
MIRIAM at the time of a given libSBML release.  The set of values in
list of C<BQM_> constants defined in @link libsbml
libsbml@endlink may be expanded in later libSBML releases, to match
the values defined by MIRIAM at that later time.
@endif@if java
@note The set of MIRIAM model qualifiers grows over
time, although relatively slowly.  The values are up to date with
MIRIAM at the time of a given libSBML release.  The set of values in
list of C<BQM_> constants defined in {@link libsbmlConstants}
may be expanded in later libSBML releases, to match
the values defined by MIRIAM at that later time.
@endif@if csharp
@note The set of MIRIAM model qualifiers grows over
time, although relatively slowly.  The values are up to date with
MIRIAM at the time of a given libSBML release.  The set of values in
list of C<BQM_> constants defined in @link libsbmlcs.libsbml libsbml@endlink
may be expanded in later libSBML releases, to match
the values defined by MIRIAM at that later time.
@endif@~


=item SBase::getModel

Returns the Model object for the SBML Document in which the current object is located.
@return the Model object for the SBML Document of this SBML object.
@see getParentSBMLObject()
@see getSBMLDocument()


=item SBase::getLevel

Returns the SBML Level of the SBMLDocument object containing I<this>
object.

C<opydetails> doc_what_is_SBMLDocument
@return the SBML level of this SBML object.
@see getVersion()
@see getNamespaces()
@see getPackageVersion()


=item SBase::getVersion

Returns the Version within the SBML Level of the SBMLDocument object
containing I<this> object.
C<opydetails> doc_what_is_SBMLDocument
@return the SBML version of this SBML object.
@see getLevel()
@see getNamespaces()


=item SBase::getObjectVersion

Returns the Version within the SBML Level of the actual object.
C<opydetails> doc_what_is_SBMLDocument
@return the SBML version of this SBML object.


=item SBase::getPackageVersion

Returns the Version of the SBML Level&nbsp;3 package to which this
element belongs to.
@return the version of the SBML Level&nbsp;3 package to which this
element belongs. The value C<0> will be returned if this element
belongs to the SBML Level&nbsp;3 Core package.
@see getLevel()
@see getVersion()


=item SBase::getPackageName

Returns the name of the SBML Level&nbsp;3 package in which this element
is defined.
@return the name of the SBML package in which this element is defined.
The string C<&quot;core&quot;> will be returned if this
element is defined in SBML Level&nbsp;3 Core. The string
C<&quot;unknown&quot;> will be returned if this element is
not defined in any SBML package.


=item SBase::getTypeCode

Returns the libSBML type code for this object.
C<opydetails> doc_what_are_typecodes
C<opydetails> doc_additional_typecode_details
@return the @if clike #SBMLTypeCode_t value@else SBML object type
code@endif@~ of this SBML object, or @link   SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (the default).  The latter is possible because
subclasses of SBase are not required to implement this method to return
a type code.
C<opydetails> doc_warning_typecodes_not_unique
@see getPackageName()
@see getElementName()


=item SBase::hasValidLevelVersionNamespaceCombination

Predicate returning C<true> if this object's level/version and namespace
values correspond to a valid SBML specification.
The valid combinations of SBML Level, Version and Namespace as of this
release of libSBML are the following:
\n=over\n
\n=item\n\nLevel&nbsp;1 Version&nbsp;2: &quot;<code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://www.sbml.org/sbml/level1</code>&quot;
\n=item\n\nLevel&nbsp;2 Version&nbsp;1: &quot;<code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://www.sbml.org/sbml/level2</code>&quot;
\n=item\n\nLevel&nbsp;2 Version&nbsp;2: &quot;<code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://www.sbml.org/sbml/level2/version2</code>&quot;
\n=item\n\nLevel&nbsp;2 Version&nbsp;3: &quot;<code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://www.sbml.org/sbml/level2/version3</code>&quot;
\n=item\n\nLevel&nbsp;2 Version&nbsp;4: &quot;<code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://www.sbml.org/sbml/level2/version4</code>&quot;
\n=item\n\nLevel&nbsp;2 Version&nbsp;5: &quot;<code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://www.sbml.org/sbml/level2/version5</code>&quot;
\n=item\n\nLevel&nbsp;3 Version&nbsp;1 Core: &quot;<code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://www.sbml.org/sbml/level3/version1/core</code>&quot;
\n=item\n\nLevel&nbsp;3 Version&nbsp;2 Core: &quot;<code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://www.sbml.org/sbml/level3/version2/core</code>&quot;
\n=back\n

@return C<true> if the level, version and namespace values of this 
SBML object correspond to a valid set of values, C<false> otherwise.


=item SBase::getElementName

Returns the XML element name of this object.
This is overridden by subclasses to return a string appropriate to the
SBML component.  For example, Model defines it as returning @c
"model", CompartmentType defines it as returning C<"compartmentType">,
and so on.


=item SBase::toSBML

Returns a string consisting of a partial SBML corresponding to just
this object.
@return the partial SBML that describes this SBML object.
@warning <span class="warning">This is primarily provided for testing
and debugging purposes.  It may be removed in a future version of
libSBML.</span>


=item SBase::toXMLNode

Returns this element as an XMLNode.
@return this element as an XMLNode.
@warning <span class="warning">This operation is computationally
expensive, because the element has to be fully serialized to a string
and then parsed into the XMLNode structure.  Attempting to convert a
large tree structure (e.g., a large Model) may consume significant
computer memory and time.</span>


=item SBase::read

Reads (initializes) this SBML object by reading from the given XMLNode.
@param node the XMLNode to read from.
@param flag an optional flag that determines how how errors are logged
during the reading process.
@warning <span class="warning">This method is computationally expensive,
because the given node has to be serialized to a string first.
Attempting to serialize a large tree structure (e.g., a large Model) may
consume significant computer memory and time.</span>


=item SBase::getPlugin

Returns a plug-in object (extension interface) for an SBML Level&nbsp;3
package extension with the given package name or URI.
C<opydetails> doc_what_are_plugins
@param package the name or URI of the package.
@return the plug-in object (the libSBML extension interface) of
a package extension with the given package name or URI.
@see getPlugin(unsigned int n)


=item SBase::getPlugin

Returns a plug-in object (extension interface) for an SBML Level&nbsp;3
package extension with the given package name or URI.
C<opydetails> doc_what_are_plugins
@param package the name or URI of the package.
@return the plug-in object (the libSBML extension interface) of a
package extension with the given package name or URI.
@see getPlugin(unsigned int n)


=item SBase::getPlugin

Returns the nth plug-in object (extension interface) for an SBML Level&nbsp;3
package extension.
C<opydetails> doc_what_are_plugins
@param n the index of the plug-in to return.
@return the nth plug-in object (the libSBML extension interface) of a
package extension.
@see getNumPlugins()
@see getPlugin(const std::string& package)


=item SBase::getPlugin

Returns the nth plug-in object (extension interface) for an SBML Level&nbsp;3
package extension.
C<opydetails> doc_what_are_plugins
@param n the index of the plug-in to return.
@return the nth plug-in object (the libSBML extension interface) of a
package extension.
@see getNumPlugins()
@see getPlugin(const std::string& package)


=item SBase::getDisabledPlugin

Returns the nth disabled plug-in object (extension interface) for an SBML Level&nbsp;3
package extension.
C<opydetails> doc_what_are_plugins
C<opydetails> doc_what_are_disabled_plugins
@param n the index of the disabled plug-in to return.
@return the nth disabled plug-in object (the libSBML extension interface) of a
package extension.
@see getNumDisabledPlugins()
@see getPlugin(const std::string& package)


=item SBase::getDisabledPlugin

Returns the nth disabled plug-in object (extension interface) for an SBML Level&nbsp;3
package extension.
C<opydetails> doc_what_are_plugins
C<opydetails> doc_what_are_disabled_plugins
@param n the index of the disabled plug-in to return.
@return the nth disabled plug-in object (the libSBML extension interface) of a
package extension.
@see getNumDisabledPlugins()
@see getPlugin(const std::string& package)


=item SBase::getNumPlugins

Returns the number of plug-in objects (extenstion interfaces) for SBML
Level&nbsp;3 package extensions known.
C<opydetails> doc_what_are_plugins
@return the number of plug-in objects (extension interfaces) of
package extensions known by this instance of libSBML.
@see getPlugin(unsigned int n)


=item SBase::getNumDisabledPlugins

Returns the number of disabled plug-in objects (extension interfaces) 
for SBML Level&nbsp;3 package extensions known.
C<opydetails> doc_what_are_plugins
C<opydetails> doc_what_are_disabled_plugins
@return the number of disabled plug-in objects (extension interfaces) 
of package extensions known by this instance of libSBML.


=item SBase::deleteDisabledPlugins

Deletes all information stored in disabled plugins.  If the plugin is 
re-enabled later, it will then not have any previously-stored information.
C<opydetails> doc_what_are_plugins
C<opydetails> doc_what_are_disabled_plugins
@param recursive if C<true>, the disabled information will be deleted
also from all child elements, otherwise only from this SBase element.
@see getNumDisabledPlugins()


=item SBase::enablePackage

Enables or disables the given SBML Level&nbsp;3 package on this object.
This method enables the specified package on this object and other
objects connected by child-parent links in the same SBMLDocument object.
This method is the converse of
SBase::disablePackage(const std::string& pkgURI, const std::string& pkgPrefix).
@param pkgURI the URI of the package.
@param pkgPrefix the XML prefix of the package.
@param flag whether to enable (C<true>) or disable (C<false>) the package.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_PKG_UNKNOWN LIBSBML_PKG_UNKNOWN@endlink
@li @link OperationReturnValues_t#LIBSBML_PKG_VERSION_MISMATCH LIBSBML_PKG_VERSION_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_PKG_CONFLICTED_VERSION LIBSBML_PKG_CONFLICTED_VERSION@endlink
@see disablePackage(const std::string& pkgURI, const std::string& pkgPrefix)


=item SBase::disablePackage

Disables the given SBML Level&nbsp;3 package on this object.
This method disables the specified package on this object
and other objects connected by child-parent links in the same
SBMLDocument object.
An example of when this may be useful is during construction of model
components when mixing existing and new models.  Suppose your
application read an SBML document containing a model that used the SBML
Hierarchical Model Composition (&ldquo;comp&rdquo;) package, and
extracted parts of that model in order to construct a new model in
memory.  The new, in-memory model will not accept a component drawn from
an other SBMLDocument with different package namespace declarations.
You could reconstruct the same namespaces in the in-memory model first,
but as a shortcut, you could also disable the package namespace on the
object being added.  Here is a code example to help clarify this:
@if cpp
C<ode{>.cpp}
// We read in an SBML L3V1 model that uses the 'comp'
// package namespace.
doc = readSBML("sbml-file-with-comp-elements.xml");
// We extract one of the species from the model.
Species  s1 = doc->getModel()->getSpecies(0);
// We construct a new model.  This model does not use the
// 'comp' package.
Model   newModel = new Model(3,1);
// The following will fail with an error, because addSpecies()
// will first check that the parent of the given object has
// namespaces declared, and will discover that s1 does but
// newModel does not.
// newModel->addSpecies(s1);
// However, if we disable the 'comp' package on s1, then
// the call to addSpecies will work.
s1->disablePackage("http://www.sbml.org/sbml/level3/version1/comp/version1",
"comp");
newModel->addSpecies(s1);
@endcode
@endif
@if python
C<ode{>.py}
import sys
import os.path
from libsbml import  
# We read an SBML L3V1 model that uses the 'comp' package.
doc = readSBML("sbml-file-with-comp-elements.xml");
if doc.getNumErrors() E<gt> 0:
print('readSBML encountered errors while reading the file.')
doc.printErrors()
sys.exit(1)
# We extract one of the species from the model.
model = doc.getModel()
if model == None:
print('Unable to retrieve Model object')
sys.exit(1)

s1 = model.getSpecies(0)
if s1 == None:
print('Unable to retrieve Species object')
sys.exit(1)

# We construct a new model.
# This model does not use the 'comp' package.
try:
newDoc = SBMLDocument(3, 1)
except ValueError:
print('Could not create SBMLDocument object')
sys.exit(1)

newModel = newDoc.createModel()
if newModel == None:
print('Unable to create new Model object')
sys.exit(1)

# The following would normally fail with an error, because
# addSpecies() would first check that the parent of the given
# object has namespaces declared, and will discover that s1
# does but newModel does not.
#   newModel.addSpecies(s1)
# However, if we disable the 'comp' package on s1, then the
# call to addSpecies will work.
compNS = "http://www.sbml.org/sbml/level3/version1/comp/version1"
status = s1.disablePackage(compNS, "comp")
if status != LIBSBML_OPERATION_SUCCESS:
print('Unable to disable package.')
sys.exit(1)

newSpecies = newModel.addSpecies(s1)   # This will work now.
if newSpecies == None:
print('Could not add Species')       # (This will not happen,
sys.exit(1)                          # but always check errors.)
@endcode
@endif
@if java
C<ode{>.java}
// We read in an SBML L3V1 model that uses the 'comp' package namespace
SBMLReader reader = new SBMLReader();
SBMLDocument doc = reader.readSBML("sbml-file-with-comp-elements.xml");
// We extract one of the species from the model we just read in.
Species s1 = doc.getModel().getSpecies(0);
// We construct a new model.  This model does not use the 'comp' package.
Model newModel = new Model(3,1);
// The following will fail with an error, because addSpecies() will
// first check that the parent of the given object has namespaces
// declared, and will discover that s1 does but newModel does not.
// newModel->addSpecies(s1);
// However, if we disable the 'comp' package on s1, then the call
// to addSpecies will work.
s1->disablePackage("http://www.sbml.org/sbml/level3/version1/comp/version1",
"comp");
newModel.addSpecies(s1);
@endcode
@endif
@param pkgURI the URI of the package.
@param pkgPrefix the XML prefix of the package.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_PKG_UNKNOWN LIBSBML_PKG_UNKNOWN@endlink
@li @link OperationReturnValues_t#LIBSBML_PKG_VERSION_MISMATCH LIBSBML_PKG_VERSION_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_PKG_CONFLICTED_VERSION LIBSBML_PKG_CONFLICTED_VERSION@endlink
@see enablePackage(const std::string& pkgURI, const std::string& pkgPrefix, bool flag)


=item SBase::enablePackageInternal

@internal


=item SBase::isPackageURIEnabled

Predicate returning C<true> if an SBML Level&nbsp;3 package with the
given URI is enabled with this object.
@param pkgURI the URI of the package.
@return C<true> if the given package is enabled within this object, @c 
false otherwise.
@see isPackageEnabled(@if java String@endif)


=item SBase::isPackageEnabled

Predicate returning C<true> if the given SBML Level&nbsp;3 package is
enabled with this object.
The search ignores the package version.
@param pkgName the name of the package.
@return C<true> if the given package is enabled within this object, @c
false otherwise.
@see isPackageURIEnabled(@if java String@endif)


=item SBase::isPkgURIEnabled

Predicate returning C<true> if an SBML Level&nbsp;3 package with the
given URI is enabled with this object.
@param pkgURI the URI of the package.
@return C<true> if the given package is enabled within this object, @c 
false otherwise.
@deprecated Replaced in libSBML 5.2.0 by
SBase::isPackageURIEnabled(@if java String@endif).
@see isPkgEnabled(@if java String@endif)


=item SBase::isPkgEnabled

Predicate returning C<true> if the given SBML Level&nbsp;3 package is
enabled with this object.
The search ignores the package version.
@param pkgName the name of the package.
@return C<true> if the given package is enabled within this object, @c
false otherwise.
@deprecated Replaced in libSBML 5.2.0 by
SBase::isPackageEnabled(@if java String@endif).
@see isPkgURIEnabled(@if java String@endif)


=item SBase::writeExtensionElements

@internal


=item SBase::read

@internal


=item SBase::write

@internal


=item SBase::writeElements

@internal


=item SBase::hasRequiredAttributes

@internal


=item SBase::hasRequiredElements

@internal


=item SBase::checkCompatibility

@internal


=item SBase::setSBMLNamespaces

@internal


=item SBase::setSBMLNamespacesAndOwn

@internal


=item SBase::getSBMLNamespaces

@internal


=item SBase::removeDuplicateAnnotations

@internal


=item SBase::checkMathMLNamespace

@internal


=item SBase::getDerivedUnitDefinition

@internal


=item SBase::containsUndeclaredUnits

@internal


=item SBase::removeFromParentAndDelete

Removes this object from its parent.
If the parent was storing this object as a pointer, it is deleted.  If
not, it is simply cleared (as in ListOf objects).  This is a pure
virtual method, as every SBase element has different parents, and
therefore different methods of removing itself.  Will fail (and not
delete itself) if it has no parent object.  This function is designed to
be overridden, but for all objects whose parent is of the class ListOf,
the default implementation will work.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink


=item SBase::matchesSBMLNamespaces

Returns C<true> if this object's set of XML namespaces are the same
as the given object's XML namespaces.
C<opydetails> doc_what_are_sbmlnamespaces
@param sb an object to compare with respect to namespaces.
@return boolean, C<true> if this object's collection of namespaces is
the same as C<sb's>, C<false> otherwise.


=item SBase::matchesSBMLNamespaces

Returns C<true> if this object's set of XML namespaces are the same
as the given object's XML namespaces.
C<opydetails> doc_what_are_sbmlnamespaces
@param sb an object to compare with respect to namespaces.
@return boolean, C<true> if this object's collection of namespaces is
the same as C<sb's>, C<false> otherwise.


=item SBase::matchesRequiredSBMLNamespacesForAddition

Returns C<true> if this object's set of XML namespaces are a subset
of the given object's XML namespaces.
C<opydetails> doc_what_are_sbmlnamespaces
@param sb an object to compare with respect to namespaces.
@return boolean, C<true> if this object's collection of namespaces is
a subset of C<sb's>, C<false> otherwise.


=item SBase::matchesRequiredSBMLNamespacesForAddition

Returns C<true> if this object's set of XML namespaces are a subset
of the given object's XML namespaces.
C<opydetails> doc_what_are_sbmlnamespaces
@param sb an object to compare with respect to namespaces.
@return boolean, C<true> if this object's collection of namespaces is
a subset of C<sb's>, C<false> otherwise.


=item SBase::setUserData

Sets the user data of this element.
C<opydetails> doc_what_is_user_data
@param userData specifies the new user data.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink


=item SBase::*getUserData

Returns the user data that has been previously set via setUserData().
C<opydetails> doc_what_is_user_data
@return the user data of this node, or C<NULL> if no user data has been set.
@if clike
@see ASTNode::setUserData(void  userData)
@endif@~


=item SBase::isSetUserData

Predicate returning true or false depending on whether
the user data of this element has been set.
C<opydetails> doc_what_is_user_data
@return boolean, C<true> if this object's user data has been set,
C<false> otherwise.


=item SBase::unsetUserData

Unsets the user data of this element.
C<opydetails> doc_what_is_user_data
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink


=item SBase::getURI

Gets the namespace URI to which this element belongs to.
For example, all elements that belong to SBML Level&nbsp;3 Version&nbsp;1 Core
must would have the URI C<"http://www.sbml.org/sbml/level3/version1/core">;
all elements that belong to Layout Extension Version 1 for SBML Level&nbsp;3
Version&nbsp;1 Core must would have the URI
C<"http://www.sbml.org/sbml/level3/version1/layout/version1">.

This function first returns the URI for this element by looking into the
SBMLNamespaces object of the document with the its package name.  If not
found, it will then look for the namespace associated with the element
itself.

@return the URI of this element, as a text string.
@see getSBMLDocument()
@see getPackageName()


=item SBase::getPrefix

Returns the XML namespace prefix of this element.
This reports the XML namespace prefix chosen for this class of object in
the current SBML document.  This may be an empty string if the component
has no explicit prefix (for instance, if it is a core SBML object placed
in the default SBML namespace of the document).  If it is not empty, then
it corresponds to the XML namespace prefix used set the object, whatever
that may be in a given SBML document.
@return a text string representing the XML namespace prefix.


=item SBase::hasOptionalAttributes

@internal


=item SBase::hasOptionalElements

@internal


=item SBase::setElementText

@internal

When overridden allows SBase elements to use the text included in between
the elements tags. The default implementation does nothing.
@param text the text string found between the element tags.


=item SBase::matchesCoreSBMLNamespace

@internal


=item SBase::matchesCoreSBMLNamespace

@internal


=item SBase::SBase

@internal


=item SBase::SBase

@internal


=item SBase::SBase

@internal


=item SBase::createObject

@internal


=item SBase::hasValidLevelVersionNamespaceCombination

@internal


=item SBase::readOtherXML

@internal


=item SBase::getElementPosition

@internal


=item SBase::getErrorLog

@internal


=item SBase::logError

@internal


=item SBase::logUnknownAttribute

@internal


=item SBase::logUnknownElement

@internal


=item SBase::logEmptyString

@internal


=item SBase::addExpectedAttributes

@internal


=item SBase::readAttributes

@internal


=item SBase::writeAttributes

@internal


=item SBase::writeXMLNS

@internal


=item SBase::syncAnnotation

@internal


=item SBase::reconstructRDFAnnotation

@internal


=item SBase::checkOrderAndLogError

@internal


=item SBase::checkListOfPopulated

@internal


=item SBase::checkDefaultNamespace

@internal


=item SBase::checkAnnotation

@internal


=item SBase::checkXHTML

@internal


=item SBase::loadPlugins

@internal


=item SBase::createExtensionObject

@internal


=item SBase::setElementNamespace

@internal


=item SBase::getElementNamespace

@internal


=item SBase::readExtensionAttributes

@internal


=item SBase::writeExtensionAttributes

@internal


=item SBase::storeUnknownExtAttribute

@internal


=item SBase::storeUnknownExtElement

@internal


=item SBase::getSBMLPrefix

@internal


=item SBase::getRootElement

@internal


=item SBase::getHasBeenDeleted

@internal


=item SBase::setSBaseFields

@internal


=item SBase::readAnnotation

@internal


=item SBase::removeDuplicatedResources

@internal


=item SBase::addTermToExistingBag

@internal


=item SBase::readNotes

@internal


=back

=head2 ListOf

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html Parent class for libSBML's "ListOfXYZ" classes.
@htmlinclude not-sbml-warning.html
The ListOf class in libSBML is a utility class that serves as the parent
class for implementing the ListOf__ classes.  It provides methods for
working generically with the various SBML lists of objects in a program.
LibSBML uses this separate list class rather than ordinary
@if conly C@endif@if cpp C++; @endif@if java Java@endif@if python Python@endif@~ lists,
so that it can provide the methods and features associated with SBase.
Whether a given ListOf element may be empty or not depends on the 
element in question, and on what level and version of SBML it
is being used for.  For ListOf elements in SBML Level&nbsp;3
Version&nbsp;1 and prior, no core list and few package lists could
be empty.  As of SBML Level&nbsp;3 Version&nbsp;2, the rules
were relaxed, and lists were allowed to be empty.  In libSBML,
documents created for Level&nbsp;3 Version&nbsp;2 will be written
with empty ListOf's if that ListOf contains some other 'extra'
information: an attribute such as metaid or sboTerm, a child
'&lt;notes&gt;' or '&lt;annotation&gt;', or information from a SBML 
Level&nbsp;3 package.
C<opydetails> doc_what_is_listof

=over


=item ListOf::ListOf

Creates a new ListOf object.
@param level the SBML Level; if not assigned, defaults to the
value of SBMLDocument::getDefaultLevel().
@param version the Version within the SBML Level; if not assigned,
defaults to the value of SBMLDocument::getDefaultVersion().
C<opydetails> doc_note_bare_listof
C<opydetails> doc_note_setting_lv
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item ListOf::ListOf

Creates a new ListOf with a given SBMLNamespaces object.
@param sbmlns the set of SBML namespaces that this ListOf should
contain.

C<opydetails> doc_note_bare_listof
C<opydetails> doc_note_setting_lv


=item ListOf::ListOf

Copy constructor; creates a copy of this ListOf.
@param orig the ListOf instance to copy.


=item ListOf::accept

@internal


=item ListOf::clone

Creates and returns a deep copy of this ListOf object.
@return the (deep) copy of this ListOf object.


=item ListOf::append

Adds an item to the end of this ListOf's list of items.
This method makes a clone of the C<item> handed to it.  This means that
when the ListOf object is destroyed, the original items will not be
destroyed.  For a method with an alternative ownership behavior, see the
ListOf::appendAndOwn(@if java SBase@endif) method.
@param item the item to be added to the list.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@see appendAndOwn(SBase  disownedItem)
@see appendFrom(const ListOf  list)


=item ListOf::appendAndOwn

Adds an item to the end of this ListOf's list of items.
This method does not clone the C<disownedItem> handed to it; instead, it assumes
ownership of it.  This means that when the ListOf is destroyed, the item
will be destroyed along with it.  For a method with an alternative
ownership behavior, see the ListOf::append(SBase  item) method.
@param disownedItem the item to be added to the list.
Will become a child of the parent list.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@see append(const SBase  item)
@see appendFrom(const ListOf  list)


=item ListOf::appendFrom

Adds a clone of a list of items to this ListOf's list.
Note that because this clones the objects handed to it, the original
items will not be destroyed when this ListOf object is destroyed.
@param list a list of items to be added.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@see append(const SBase  item)
@see appendAndOwn(SBase  disownedItem)


=item ListOf::insert

Inserts an item at a given position in this ListOf's list of items.
This variant of the method makes a clone of the C<item> handed to it.
This means that when the ListOf is destroyed, the original C<item> will
<em>not</em> be destroyed.
@param location the location in the list where to insert the item.
@param item the item to be inserted to the list.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@see insertAndOwn(int location, SBase  item)


=item ListOf::insertAndOwn

Inserts an item at a given position in this ListOf's list of items.
This variant of the method does not make a clone of the C<disownedItem> handed to it.
This means that when the ListOf is destroyed, the original C<item>
<em>will</em> be destroyed.
@param location the location where to insert the item.
@param disownedItem the item to be inserted to the list.
Will become a child of the parent list.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@see insert(int location, const SBase  item)


=item ListOf::get

Get an item from the list.
@param n the index number of the item to get.
@return the <em>n</em>th item in this ListOf items, or a null pointer if
the index number C<n> refers to a nonexistent position in this list.
@see size()


=item ListOf::get

Get an item from the list.
@param n the index number of the item to get.
@return the <em>n</em>th item in this ListOf items, or a null pointer if
the index number C<n> refers to a nonexistent position in this list.
@see size()


=item ListOf::getElementBySId

Returns the first child element found that has the given identifier.
This method searches this ListOf's list of items for SBML objects based
on their "id" attribute value in the model-wide C<SId>
identifier namespace.
@param id string representing the id of the object to find.
@return the first element found with the given C<id>, or C<NULL> if no
such object is found.


=item ListOf::getElementByMetaId

Returns the first child element found with the given meta-identifier.
@param metaid string representing the "metaid" attribute of the object
to find.
@return the first element found with the given C<metaid>, or C<NULL> if
no such object is found.


=item ListOf::getAllElements

Returns a List of all child SBase objects.
The values returned include all children of the objects in this ListOf
list, nested to an arbitrary depth.
@param filter a pointer to an ElementFilter, which causes the function 
to return only elements that match a particular set of constraints.  
If NULL (the default), the function will return all child objects.
@return a List of pointers to all child objects.


=item ListOf::clear

Removes all items in this ListOf object.
If parameter C<doDelete> is C<true> (default), all items in this ListOf
object are deleted and cleared, and thus the caller doesn't have to
delete those items.  Otherwise, all items are cleared only from this
ListOf object; the caller is still responsible for deleting the actual
items.  (In the latter case, callers are advised to store pointers to
all items elsewhere before calling this function.)
@param doDelete if C<true> (default), all items are deleted and cleared.
Otherwise, all items are just cleared and not deleted.
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item ListOf::removeFromParentAndDelete

Removes all items in this ListOf object and deletes its properties too.
This performs a call to clear() with an argument of C<true> (thus removing
all the child objects in the list), followed by calls to various libSBML
<code>unset<em>Foo</em></code> methods to delete everything else: CVTerm
objects, model history objects, etc.
@if cpp Implementations of subclasses of ListOf may need to override
this method if different handling of child objects is needed.@endif@~
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink


=item ListOf::remove

Removes the <em>n</em>th item from this ListOf list of items and returns
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove.
@see size()


=item ListOf::size

Returns number of items in this ListOf list.
@return the number of items in this ListOf items.


=item ListOf::setSBMLDocument

@internal


=item ListOf::getTypeCode

Returns the libSBML type code for this object, namely,
@link SBMLTypeCode_t#SBML_LIST_OF SBML_LIST_OF@endlink.
C<opydetails> doc_what_are_typecodes
@return the SBML type code for this object:
@link SBMLTypeCode_t#SBML_LIST_OF SBML_LIST_OF@endlink (default).
@note The various ListOf classes mostly differ from each other in what they
contain.  Hence, one must call getItemTypeCode() to fully determine the
class of this SBML object.
C<opydetails> doc_warning_typecodes_not_unique
@see getItemTypeCode()
@see getElementName()
@see getPackageName()


=item ListOf::getItemTypeCode

Get the type code of the objects contained in this ListOf.
C<opydetails> doc_what_are_typecodes
Classes that inherit from the ListOf class should override this method
to return the SBML type code for the objects contained in this ListOf.
If they do not, this method will return
@link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink
@return The ListOf base class contains no SBML objects, and therefore
this method returns @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink.
@see getElementName()
@see getPackageName()


=item ListOf::getElementName

Returns the XML element name of this object, which for ListOf, is
always C<"listOf">.
@return the XML name of this element.


=item ListOf::writeElements

@internal


=item ListOf::enablePackageInternal

@internal


=item ListOf::hasOptionalElements

@internal


=item ListOf::isExplicitlyListed

@internal


=item ListOf::setExplicitlyListed

@internal


=item ListOf::addExpectedAttributes

@internal


=item ListOf::readAttributes

@internal


=item ListOf::writeAttributes

@internal


=item ListOf::isValidTypeForList

@internal


=back

=head2 Model

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html An SBML model.
In an SBML model definition, a single object of class Model serves as
the overall container for the lists of the various model components.
All of the lists are optional, but if a given list container is present
within the model, the list must not be empty; that is, it must have
length one or more.  The following are the components and lists
permitted in different Levels and Versions of SBML in
version @htmlinclude libsbml-version.html
of libSBML:
\n=over\n
\n=item\n\nIn SBML Level 1, the components are: UnitDefinition, Compartment,
Species, Parameter, Rule, and Reaction.  Instances of the classes are
placed inside instances of classes ListOfUnitDefinitions,
ListOfCompartments, ListOfSpecies, ListOfParameters, ListOfRules, and
ListOfReactions.

\n=item\n\nIn SBML Level 2 Version 1, the components are: FunctionDefinition,
UnitDefinition, Compartment, Species, Parameter, Rule, Reaction and
Event.  Instances of the classes are placed inside instances of classes
ListOfFunctionDefinitions, ListOfUnitDefinitions, ListOfCompartments,
ListOfSpecies, ListOfParameters, ListOfRules, ListOfReactions, and
ListOfEvents.

\n=item\n\nIn SBML Level 2 Versions 2, 3 and 4, the components are:
FunctionDefinition, UnitDefinition, CompartmentType, SpeciesType,
Compartment, Species, Parameter, InitialAssignment, Rule, Constraint,
Reaction and Event.  Instances of the classes are placed inside
instances of classes ListOfFunctionDefinitions, ListOfUnitDefinitions,
ListOfCompartmentTypes, ListOfSpeciesTypes, ListOfCompartments,
ListOfSpecies, ListOfParameters, ListOfInitialAssignments, ListOfRules,
ListOfConstraints, ListOfReactions, and ListOfEvents.
\n=item\n\nIn SBML Level 3 Version 1, the components are: FunctionDefinition,
UnitDefinition, Compartment, Species, Parameter, InitialAssignment,
Rule, Constraint, Reaction and Event.  Instances of the classes are
placed inside instances of classes ListOfFunctionDefinitions,
ListOfUnitDefinitions, ListOfCompartments, ListOfSpecies,
ListOfParameters, ListOfInitialAssignments, ListOfRules,
ListOfConstraints, ListOfReactions, and ListOfEvents.  
\n=back\n

Although all the lists are optional, there are dependencies between SBML
components such that defining some components requires defining others.
An example is that defining a species requires defining a compartment,
and defining a reaction requires defining a species.  The dependencies
are explained in more detail in the SBML specifications.
In addition to the above lists and attributes, the Model class in both
SBML Level&nbsp;2 and Level&nbsp;3 has the usual two attributes of "id"
and "name", and both are optional.  As is the case for other SBML
components with "id" and "name" attributes, they must be used according
to the guidelines described in the SBML specifications.  (Within the
frameworks of SBML Level&nbsp;2 and Level&nbsp;3, a
Model object identifier has no assigned meaning, but extension packages
planned for SBML Level&nbsp;3 are likely to make use of this
identifier.)

Finally, SBML Level&nbsp;3 has introduced a number of additional Model
attributes.  They are discussed in a separate section below.
@section approaches Approaches to creating objects using the libSBML API
LibSBML provides two main mechanisms for creating objects: class
constructors
(e.g., @if java <a href="org/sbml/libsbml/Species.html">Species()</a> @else Species::Species() @endif), 
and <code>create<span class="placeholder-nospace"><em>Object</em></span>()</code>
methods (such as Model::createSpecies()) provided by certain <span
class="placeholder-nospace"><em>Object</em></span> classes such as Model.  These
multiple mechanisms are provided by libSBML for flexibility and to
support different use-cases, but they also have different implications
for the overall model structure.
In general, the recommended approach is to use the <code>create<span
class="placeholder-nospace"><em>Object</em></span>()</code> methods.  These
methods both create an object I<and> link it to the parent in one step.
Here is an example:@if clike
C<ode{>.cpp}
// Create an SBMLDocument object in Level 3 Version 1 format:
SBMLDocument  sbmlDoc = new SBMLDocument(3, 1);
// Create a Model object inside the SBMLDocument object and set
// its identifier.  The call returns a pointer to the Model object
// created, and methods called on that object affect the attributes
// of the object attached to the model (as expected).
Model  model = sbmlDoc->createModel();
model->setId("BestModelEver");
// Create a Species object inside the Model and set its identifier.
// Similar to the lines above, this call returns a pointer to the Species
// object created, and methods called on that object affect the attributes
// of the object attached to the model (as expected).
Species  sp = model->createSpecies();
sp->setId("MySpecies");
@endcode
@endif@if java
C<ode{>.java}
// Create an SBMLDocument object in Level 3 Version 1 format:
SBMLDocument sbmlDoc = new SBMLDocument(3, 1);
// Create a Model object inside the SBMLDocument object and set
// its identifier.  The call returns a pointer to the Model object
// created, and methods called on that object affect the attributes
// of the object attached to the model (as expected).  Note that
// the call to setId() returns a status code, and a real program
// should check this status code to make sure everything went okay.
Model model = sbmlDoc.createModel();
model.setId(&#34;BestModelEver&#34;);
// Create a Species object inside the Model and set its identifier.
// Similar to the lines above, this call returns a pointer to the Species
// object created, and methods called on that object affect the attributes
// of the object attached to the model (as expected).  Note that, like
// with Model, the call to setId() returns a status code, and a real program
// should check this status code to make sure everything went okay.
Species sp = model.createSpecies();
sp.setId(&#34;BestSpeciesEver&#34;);
@endcode
@endif@if python
C<ode{>.py}
# Create an SBMLDocument object in Level 3 Version 1 format.
# Make sure to check for possible failures.
try:
sbmlDoc = SBMLDocument(3, 1)
except ValueError:
print('Could not create SBMLDocument object')
sys.exit(1)

# Create a Model object inside the SBMLDocument object and set its
# identifier, checking the returned values.  The call to setId() returns a
# status code to indicate whether the assignment was successful.
model = sbmlDoc.createModel()
if model == None:
# Do something to handle the error here.
print("Unable to create Model object.")
sys.exit(1)

status = model.setId('BestModelEver')
if status != LIBSBML_OPERATION_SUCCESS:
# Do something to handle the error here.
print("Unable to set identifier on the Model object")
sys.exit(1)

# Create a Species object inside the Model and set its identifier.
# Again, the setId() returns a status code to indicate whether the
# assignment was successful.
sp = model.createSpecies()
if sp == None:
# Do something to handle the error here.
print("Unable to create Species object.")
sys.exit(1)

status = sp.setId('BestSpeciesEver')
if status != LIBSBML_OPERATION_SUCCESS:
# Do something to handle the error here.
print("Unable to set identifier on the Species object")
sys.exit(1)
@endcode
@endif@if csharp
C<ode>
// Create an SBMLDocument object in Level 3 Version 1 format:
SBMLDocument sbmlDoc = new SBMLDocument(3, 1);
// Create a Model object inside the SBMLDocument object and set
// its identifier.  The call returns a pointer to the Model object
// created, and methods called on that object affect the attributes
// of the object attached to the model (as expected).
Model model = sbmlDoc.createModel();
model.setId("BestModelEver");
// Create a Species object inside the Model and set its identifier.
// Similar to the lines above, this call returns a pointer to the Species
// object created, and methods called on that object affect the attributes
// of the object attached to the model (as expected).
Species sp = model.createSpecies();
sp.setId("MySpecies");
@endcode
@endif@~

The <code>create<span
class="placeholder-nospace"><em>Object</em></span>()</code> methods return a
pointer to the object created, but they also add the object to the
relevant list of object instances contained in the parent.  (These lists
become the <code>&lt;listOf<span
class="placeholder-nospace"><em>Object</em></span>s&gt;</code> elements in the
finished XML rendition of SBML.)  In the example above,
Model::createSpecies() adds the created species directly to the
C<&lt;listOfSpecies&gt;> list in the model.  Subsequently,
methods called on the species change the species in the model (which is
what is expected in most situations).
@section model-checking Consistency and adherence to SBML specifications
To make it easier for applications to do whatever they need,
libSBML version @htmlinclude libsbml-version.html
is relatively lax when it comes to enforcing correctness and
completeness of models I<during> model construction and editing.
Essentially, libSBML I<will> I<not> in most cases check automatically
that a model's components have valid attribute values, or that the
overall model is consistent and free of errors---even obvious errors
such as duplication of identifiers.  This allows applications great
leeway in how they build their models, but it means that software
authors must take deliberate steps to ensure that the model will be, in
the end, valid SBML.  These steps include such things as keeping track
of the identifiers used in a model, manually performing updates in
certain situations where an entity is referenced in more than one place
(e.g., a species that is referenced by multiple SpeciesReference
objects), and so on.
That said, libSBML does provide powerful features for deliberately
performing validation of SBML when an application decides it is time to
do so.  The interfaces to these facilities are on the SBMLDocument
class, in the form of SBMLDocument::checkInternalConsistency() and
SBMLDocument::checkConsistency().  Please refer to the documentation for
SBMLDocument for more information about this.
While applications may play fast and loose and live like free spirits
during the construction and editing of SBML models, they should always
make sure to call SBMLDocument::checkInternalConsistency() and/or
SBMLDocument::checkConsistency() before writing out the final version of
an SBML model.
@section model-l3-attrib Model attributes introduced in SBML Level&nbsp;3
As mentioned above, the Model class has a number of optional attributes
in SBML Level&nbsp;3.  These are "substanceUnits",
"timeUnits", "volumeUnits", "areaUnits", "lengthUnits", "extentUnits",
and "conversionFactor.  The following provide more information about
them.

@subsection model-l3-substanceunits The "substanceUnits" attribute
The "substanceUnits" attribute is used to specify the unit of
measurement associated with substance quantities of Species objects that
do not specify units explicitly.  If a given Species object definition
does not specify its unit of substance quantity via the "substanceUnits"
attribute on the Species object instance, then that species inherits the
value of the Model "substanceUnits" attribute.  If the Model does not
define a value for this attribute, then there is no unit to inherit, and
all species that do not specify individual "substanceUnits" attribute
values then have <em>no</em> declared units for their quantities.  The
SBML Level&nbsp;3 specifications provide more details.
Note that when the identifier of a species appears in a model's
mathematical expressions, the unit of measurement associated with that
identifier is <em>not solely determined</em> by setting "substanceUnits"
on Model or Species.  Please see the discussion about units given in
the documentation for the Species class.
@subsection model-l3-timeunits The "timeUnits" attribute
The "timeUnits" attribute on SBML Level&nbsp;3's Model object is used to
specify the unit in which time is measured in the model.  This attribute
on Model is the <em>only</em> way to specify a unit for time in a model.
It is a global attribute; time is measured in the model everywhere in
the same way.  This is particularly relevant to Reaction and RateRule
objects in a model: all Reaction and RateRule objects in SBML define
per-time values, and the unit of time is given by the "timeUnits"
attribute on the Model object instance.  If the Model "timeUnits"
attribute has no value, it means that the unit of time is not defined
for the model's reactions and rate rules.  Leaving it unspecified in an
SBML model does not result in an invalid model in SBML Level&nbsp;3;
however, as a matter of best practice, we strongly recommend that all
models specify units of measurement for time.
@subsection model-l3-voletc The "volumeUnits", "areaUnits", and "lengthUnits" attributes
The attributes "volumeUnits", "areaUnits" and "lengthUnits" together are
used to set the units of measurements for the sizes of Compartment
objects in an SBML Level&nbsp;3 model when those objects do not
otherwise specify units.  The three attributes correspond to the most
common cases of compartment dimensions: "volumeUnits" for compartments
having a "spatialDimensions" attribute value of C<"3">, "areaUnits" for
compartments having a "spatialDimensions" attribute value of C<"2">, and
"lengthUnits" for compartments having a "spatialDimensions" attribute
value of C<"1">.  The attributes are not applicable to compartments
whose "spatialDimensions" attribute values are I<not> one of C<"1">, @c
"2" or C<"3">.
If a given Compartment object instance does not provide a value for its
"units" attribute, then the unit of measurement of that compartment's
size is inherited from the value specified by the Model "volumeUnits",
"areaUnits" or "lengthUnits" attribute, as appropriate based on the
Compartment object's "spatialDimensions" attribute value.  If the Model
object does not define the relevant attribute, then there are no units
to inherit, and all Compartment objects that do not set a value for
their "units" attribute then have <em>no</em> units associated with
their compartment sizes.
The use of three separate attributes is a carry-over from SBML
Level&nbsp;2.  Note that it is entirely possible for a model to define a
value for two or more of the attributes "volumeUnits", "areaUnits" and
"lengthUnits" simultaneously, because SBML models may contain
compartments with different numbers of dimensions.
@subsection model-l3-extentunits The "extentUnits" attribute
Reactions are processes that occur over time.  These processes involve
events of some sort, where a single ``reaction event'' is one in which
some set of entities (known as reactants, products and modifiers in
SBML) interact, once.  The <em>extent</em> of a reaction is a measure of
how many times the reaction has occurred, while the time derivative of
the extent gives the instantaneous rate at which the reaction is
occurring.  Thus, what is colloquially referred to as the "rate of the
reaction" is in fact equal to the rate of change of reaction extent.
In SBML Level&nbsp;3, the combination of "extentUnits" and "timeUnits"
defines the units of kinetic laws in SBML and establishes how the
numerical value of each KineticLaw object's mathematical formula is
meant to be interpreted in a model.  The units of the kinetic laws are
taken to be "extentUnits" divided by "timeUnits".
Note that this embodies an important principle in SBML Level&nbsp;3
models: <em>all reactions in an SBML model must have the same units</em>
for the rate of change of extent.  In other words, the units of all
reaction rates in the model <em>must be the same</em>.  There is only
one global value for "extentUnits" and one global value for "timeUnits".
@subsection model-l3-convfactor The "conversionFactor" attribute
The attribute "conversionFactor" in SBML Level&nbsp;3's Model object
defines a global value inherited by all Species object instances that do
not define separate values for their "conversionFactor" attributes.  The
value of this attribute must refer to a Parameter object instance
defined in the model.  The Parameter object in question must be a
constant; ie it must have its "constant" attribute value set to @c
"true".

If a given Species object definition does not specify a conversion
factor via the "conversionFactor" attribute on Species, then the species
inherits the conversion factor specified by the Model "conversionFactor"
attribute.  If the Model does not define a value for this attribute,
then there is no conversion factor to inherit.  More information about
conversion factors is provided in the SBML Level&nbsp;3
specifications.

=over


=item Model::Model

Creates a new Model using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this Model.
@param version an unsigned int, the SBML Version to assign to this
Model.

C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item Model::Model

Creates a new Model using the given SBMLNamespaces object
C<sbmlns>.
C<opydetails> doc_what_are_sbmlnamespaces
@param sbmlns an SBMLNamespaces object.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item Model::Model

Copy constructor; creates a (deep) copy of the given Model object.
@param orig the object to copy.


=item Model::accept

@internal


=item Model::clone

Creates and returns a deep copy of this Model object.
@return the (deep) copy of this Model object.


=item Model::getElementBySId

Returns the first child element found that has the given C<id>.
This operation searches the model-wide C<SId> identifier
type namespace
@param id string representing the id of the object to find.
@return pointer to the first element found with the given C<id>, or @c
NULL if no such object is found.


=item Model::getElementByMetaId

Returns the first child element it can find with the given C<metaid>.
@param metaid string representing the meta-identifier of the object to
find.

@return pointer to the first element found with the given C<metaid>, or
NULL if no such object is found.


=item Model::getAllElements

Returns a List of all child objects.
This returns all child objects nested to an arbitrary depth.  If an
optional element filter is provided, only those objects for which the
C<filter's> C<filter()> method returns true will be added to 
the list.
@param filter a pointer to an ElementFilter, which causes the function 
to return only elements that match a particular set of constraints.  
If NULL (the default), the function will return all child objects.
@return a List of pointers to all children objects.


=item Model::getId

Returns the value of the "id" attribute of this Model.
@note Because of the inconsistent behavior of this function with 
respect to assignments and rules, it is now recommended to
use the getIdAttribute() function instead.
C<opydetails> doc_id_attribute
@return the id of this Model.
@see getIdAttribute()
@see setIdAttribute(const std::string& sid)
@see isSetIdAttribute()
@see unsetIdAttribute()


=item Model::getName

Returns the value of the "name" attribute of this Model object.
C<opydetails> doc_get_name


=item Model::getSubstanceUnits

Returns the value of the "substanceUnits" attribute of this Model.
@return the substanceUnits of this Model.
@note The "substanceUnits" attribute is available in
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::getTimeUnits

Returns the value of the "timeUnits" attribute of this Model.
@return the timeUnits of this Model.
@note The "timeUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::getVolumeUnits

Returns the value of the "volumeUnits" attribute of this Model.
@return the volumeUnits of this Model.
@note The "volumeUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::getAreaUnits

Returns the value of the "areaUnits" attribute of this Model.
@return the areaUnits of this Model.
@note The "areaUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::getLengthUnits

Returns the value of the "lengthUnits" attribute of this Model.
@return the lengthUnits of this Model.
@note The "lengthUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::getExtentUnits

Returns the value of the "extentUnits" attribute of this Model.
@return the extentUnits of this Model.
@note The "extentUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::getConversionFactor

Returns the value of the "conversionFactor" attribute of this Model.
@return the conversionFactor of this Model.
@note The "conversionFactor" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::isSetId

Predicate returning C<true> if this
Model's "id" attribute is set.
C<opydetails> doc_isset_id


=item Model::isSetName

Predicate returning C<true> if this
Model's "name" attribute is set.
C<opydetails> doc_isset_name


=item Model::isSetSubstanceUnits

Predicate returning C<true> if this
Model's "substanceUnits" attribute is set.
@return C<true> if the "substanceUnits" attribute of this Model is
set, C<false> otherwise.
@note The "substanceUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::isSetTimeUnits

Predicate returning C<true> if this
Model's "timeUnits" attribute is set.
@return C<true> if the "timeUnits" attribute of this Model is
set, C<false> otherwise.
@note The "substanceUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::isSetVolumeUnits

Predicate returning C<true> if this
Model's "volumeUnits" attribute is set.
@return C<true> if the "volumeUnits" attribute of this Model is
set, C<false> otherwise.
@note The "volumeUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::isSetAreaUnits

Predicate returning C<true> if this
Model's "areaUnits" attribute is set.
@return C<true> if the "areaUnits" attribute of this Model is
set, C<false> otherwise.
@note The "areaUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::isSetLengthUnits

Predicate returning C<true> if this
Model's "lengthUnits" attribute is set.
@return C<true> if the "lengthUnits" attribute of this Model is
set, C<false> otherwise.
@note The "lengthUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::isSetExtentUnits

Predicate returning C<true> if this
Model's "extentUnits" attribute is set.
@return C<true> if the "extentUnits" attribute of this Model is
set, C<false> otherwise.
@note The "extentUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::isSetConversionFactor

Predicate returning C<true> if this
Model's "conversionFactor" attribute is set.
@return C<true> if the "conversionFactor" attribute of this Model is
set, C<false> otherwise.
@note The "conversionFactor" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::setId

Sets the value of the "id" attribute of this Model.
C<opydetails> doc_set_id


=item Model::setName

Sets the value of the "name" attribute of this Model.
C<opydetails> doc_set_name


=item Model::setSubstanceUnits

Sets the value of the "substanceUnits" attribute of this Model.
The string in C<units> is copied.
@param units the new substanceUnits for the Model.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@note The "substanceUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::setTimeUnits

Sets the value of the "timeUnits" attribute of this Model.
The string in C<units> is copied.
@param units the new timeUnits for the Model.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@note The "timeUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::setVolumeUnits

Sets the value of the "volumeUnits" attribute of this Model.
The string in C<units> is copied.
@param units the new volumeUnits for the Model.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@note The "volumeUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::setAreaUnits

Sets the value of the "areaUnits" attribute of this Model.
The string in C<units> is copied.
@param units the new areaUnits for the Model.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@note The "areaUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::setLengthUnits

Sets the value of the "lengthUnits" attribute of this Model.
The string in C<units> is copied.
@param units the new lengthUnits for the Model.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@note The "lengthUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::setExtentUnits

Sets the value of the "extentUnits" attribute of this Model.
The string in C<units> is copied.
@param units the new extentUnits for the Model.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@note The "extentUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::setConversionFactor

Sets the value of the "conversionFactor" attribute of this Model.
The string in C<units> is copied.
@param units the new conversionFactor for the Model.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@note The "conversionFactor" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::unsetId

Unsets the value of the "id" attribute of this Model.
C<opydetails> doc_unset_id


=item Model::unsetName

Unsets the value of the "name" attribute of this Model.
C<opydetails> doc_unset_name


=item Model::unsetSubstanceUnits

Unsets the value of the "substanceUnits" attribute of this Model.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@note The "substanceUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::unsetTimeUnits

Unsets the value of the "timeUnits" attribute of this Model.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@note The "timeUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::unsetVolumeUnits

Unsets the value of the "volumeUnits" attribute of this Model.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@note The "volumeUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::unsetAreaUnits

Unsets the value of the "areaUnits" attribute of this Model.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@note The "areaUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::unsetLengthUnits

Unsets the value of the "lengthUnits" attribute of this Model.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@note The "lengthUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::unsetExtentUnits

Unsets the value of the "extentUnits" attribute of this Model.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@note The "extentUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::unsetConversionFactor

Unsets the value of the "conversionFactor" attribute of this Model.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@note The "conversionFactor" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::addFunctionDefinition

Adds a copy of the given FunctionDefinition object to this Model.
@param fd the FunctionDefinition to add.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
C<opydetails> doc_note_object_is_copied 
@see createFunctionDefinition()


=item Model::addUnitDefinition

Adds a copy of the given UnitDefinition object to this Model.
@param ud the UnitDefinition object to add.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
C<opydetails> doc_note_object_is_copied 
@see createUnitDefinition()


=item Model::addCompartmentType

Adds a copy of the given CompartmentType object to this Model.
@param ct the CompartmentType object to add.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
C<opydetails> doc_note_object_is_copied 
@note The CompartmentType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.
@see createCompartmentType()


=item Model::addSpeciesType

Adds a copy of the given SpeciesType object to this Model.
@param st the SpeciesType object to add.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
C<opydetails> doc_note_object_is_copied 
@note The SpeciesType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.
@see createSpeciesType()


=item Model::addCompartment

Adds a copy of the given Compartment object to this Model.
@param c the Compartment object to add.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
C<opydetails> doc_note_object_is_copied 
@see createCompartment()


=item Model::addSpecies

Adds a copy of the given Species object to this Model.
@param s the Species object to add.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
C<opydetails> doc_note_object_is_copied 
@see createSpecies()


=item Model::addParameter

Adds a copy of the given Parameter object to this Model.
@param p the Parameter object to add.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
C<opydetails> doc_note_object_is_copied 
@see createParameter()


=item Model::addInitialAssignment

Adds a copy of the given InitialAssignment object to this Model.
@param ia the InitialAssignment object to add.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
C<opydetails> doc_note_object_is_copied 
@see createInitialAssignment()


=item Model::addRule

Adds a copy of the given Rule object to this Model.
@param r the Rule object to add.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
C<opydetails> doc_note_object_is_copied 
@see createAlgebraicRule()
@see createAssignmentRule()
@see createRateRule()


=item Model::addConstraint

Adds a copy of the given Constraint object to this Model.
@param c the Constraint object to add.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
C<opydetails> doc_note_object_is_copied 
@see createConstraint()


=item Model::addReaction

Adds a copy of the given Reaction object to this Model.
@param r the Reaction object to add.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
C<opydetails> doc_note_object_is_copied 
@see createReaction()


=item Model::addEvent

Adds a copy of the given Event object to this Model.
@param e the Event object to add.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
C<opydetails> doc_note_object_is_copied 
@see createEvent()


=item Model::createFunctionDefinition

Creates a new FunctionDefinition inside this Model and returns it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
@return the FunctionDefinition object created.
@see addFunctionDefinition(const FunctionDefinition  fd)


=item Model::createUnitDefinition

Creates a new UnitDefinition inside this Model and returns it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
@return the UnitDefinition object created.
@see addUnitDefinition(const UnitDefinition  ud)


=item Model::createUnit

Creates a new Unit object within the last UnitDefinition object
created in this model and returns a pointer to it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
The mechanism by which the UnitDefinition was created is not
significant.  If a UnitDefinition object does not exist in this model,
a new Unit is I<not> created and C<NULL> is returned instead.
@return the Unit object created.
@see addUnitDefinition(const UnitDefinition  ud)


=item Model::createCompartmentType

Creates a new CompartmentType inside this Model and returns it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
@return the CompartmentType object created.
@note The CompartmentType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.
@see addCompartmentType(const CompartmentType  ct)


=item Model::createSpeciesType

Creates a new SpeciesType inside this Model and returns it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
@return the SpeciesType object created.
@note The SpeciesType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.
@see addSpeciesType(const SpeciesType  st)


=item Model::createCompartment

Creates a new Compartment inside this Model and returns it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
@return the Compartment object created.
@see addCompartment(const Compartment  c)


=item Model::createSpecies

Creates a new Species inside this Model and returns it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
@return the Species object created.
@see addSpecies(const Species  s)


=item Model::createParameter

Creates a new Parameter inside this Model and returns it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
@return the Parameter object created.
@see addParameter(const Parameter  p)


=item Model::createInitialAssignment

Creates a new InitialAssignment inside this Model and returns it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
@return the InitialAssignment object created.
@see addInitialAssignment(const InitialAssignment  ia)


=item Model::createAlgebraicRule

Creates a new AlgebraicRule inside this Model and returns it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
@return the AlgebraicRule object created.
@see addRule(const Rule  r)


=item Model::createAssignmentRule

Creates a new AssignmentRule inside this Model and returns it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
@return the AssignmentRule object created.
@see addRule(const Rule  r)


=item Model::createRateRule

Creates a new RateRule inside this Model and returns it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
@return the RateRule object created.
@see addRule(const Rule  r)


=item Model::createConstraint

Creates a new Constraint inside this Model and returns it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
@return the Constraint object created.
@see addConstraint(const Constraint  c)


=item Model::createReaction

Creates a new Reaction inside this Model and returns it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
@return the Reaction object created.
@see addReaction(const Reaction  r)


=item Model::createReactant

Creates a new SpeciesReference object for a reactant inside the last
Reaction object in this Model, and returns a pointer to it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
C<opydetails> doc_how_added_last_reaction_irrelevant
@return the SpeciesReference object created.  If a Reaction does not
exist for this model, a new SpeciesReference is I<not> created and @c
NULL is returned.


=item Model::createProduct

Creates a new SpeciesReference object for a product inside the last
Reaction object in this Model, and returns a pointer to it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
C<opydetails> doc_how_added_last_reaction_irrelevant
@return the SpeciesReference object created. If a Reaction does not
exist for this model, a new SpeciesReference is I<not> created and @c
NULL is returned.


=item Model::createModifier

Creates a new ModifierSpeciesReference object for a modifier species
inside the last Reaction object in this Model, and returns a pointer
to it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
C<opydetails> doc_how_added_last_reaction_irrelevant
@return the SpeciesReference object created.  If a Reaction does not
exist for this model, a new SpeciesReference is I<not> created and @c
NULL is returned.


=item Model::createKineticLaw

Creates a new KineticLaw inside the last Reaction object created in
this Model, and returns a pointer to it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
C<opydetails> doc_how_added_last_reaction_irrelevant
@return the KineticLaw object created.  If a Reaction does not exist for
this model, or a Reaction does exist but already has a KineticLaw, a new
KineticLaw is I<not> created and C<NULL> is returned.


=item Model::createKineticLawParameter

Creates a new local Parameter inside the KineticLaw object of the last
Reaction created inside this Model, and returns a pointer to it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
C<opydetails> doc_how_added_last_kineticlaw_irrelevant
@return the Parameter object created.  If a Reaction does not exist for
this model, or a KineticLaw for the Reaction does not exist, a new
Parameter is I<not> created and C<NULL> is returned.


=item Model::createKineticLawLocalParameter

Creates a new LocalParameter inside the KineticLaw object of the last
Reaction created inside this Model, and returns a pointer to it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
C<opydetails> doc_how_added_last_kineticlaw_irrelevant
@return the Parameter object created.  If a Reaction does not exist for
this model, or a KineticLaw for the Reaction does not exist, a new
Parameter is I<not> created and C<NULL> is returned.


=item Model::createEvent

Creates a new Event inside this Model and returns it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
@return the Event object created.


=item Model::createEventAssignment

Creates a new EventAssignment inside the last Event object created in
this Model, and returns a pointer to it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
C<opydetails> doc_how_added_last_event_irrelevant
@return the EventAssignment object created.


=item Model::createTrigger

Creates a new Trigger inside the last Event object created in
this Model, and returns a pointer to it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
C<opydetails> doc_how_added_last_event_irrelevant
@return the Trigger object created.


=item Model::createDelay

Creates a new Delay inside the last Event object created in
this Model, and returns a pointer to it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
C<opydetails> doc_how_added_last_event_irrelevant
@return the Delay object created.


=item Model::setAnnotation

Sets the value of the "annotation" subelement of this SBML object to a
copy of C<annotation>.
Any existing content of the "annotation" subelement is discarded.
Unless you have taken steps to first copy and reconstitute any
existing annotations into the C<annotation> that is about to be
assigned, it is likely that performing such wholesale replacement is
unfriendly towards other software applications whose annotations are
discarded.  An alternative may be to use appendAnnotation().
@param annotation an XML structure that is to be used as the content
of the "annotation" subelement of this object.
C<opydetails> doc_returns_one_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@see appendAnnotation(const XMLNode  annotation)


=item Model::setAnnotation

Sets the value of the "annotation" subelement of this SBML object to a
copy of C<annotation>.
Any existing content of the "annotation" subelement is discarded.
Unless you have taken steps to first copy and reconstitute any
existing annotations into the C<annotation> that is about to be
assigned, it is likely that performing such wholesale replacement is
unfriendly towards other software applications whose annotations are
discarded.  An alternative may be to use appendAnnotation().
@param annotation an XML string that is to be used as the content
of the "annotation" subelement of this object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@see appendAnnotation(const std::string& annotation)


=item Model::appendAnnotation

Appends annotation content to any existing content in the "annotation"
subelement of this object.
The content in C<annotation> is copied.  Unlike setAnnotation(), this
method allows other annotations to be preserved when an application
adds its own data.
@param annotation an XML structure that is to be copied and appended
to the content of the "annotation" subelement of this object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@see setAnnotation(const XMLNode  annotation)


=item Model::appendAnnotation

Appends annotation content to any existing content in the "annotation"
subelement of this object.
The content in C<annotation> is copied.  Unlike setAnnotation(), this 
method allows other annotations to be preserved when an application
adds its own data.
@param annotation an XML string that is to be copied and appended
to the content of the "annotation" subelement of this object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@see setAnnotation(const std::string& annotation)


=item Model::getListOfFunctionDefinitions

Get the ListOfFunctionDefinitions object in this Model.
@return the list of FunctionDefinitions for this Model.


=item Model::getListOfFunctionDefinitions

Get the ListOfFunctionDefinitions object in this Model.
@return the list of FunctionDefinitions for this Model.


=item Model::getListOfUnitDefinitions

Get the ListOfUnitDefinitions object in this Model.
@return the list of UnitDefinitions for this Model.


=item Model::getListOfUnitDefinitions

Get the ListOfUnitDefinitions object in this Model.
@return the list of UnitDefinitions for this Model.


=item Model::getListOfCompartmentTypes

Get the ListOfCompartmentTypes object in this Model.
@return the list of CompartmentTypes for this Model.
@note The CompartmentType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.


=item Model::getListOfCompartmentTypes

Get the ListOfCompartmentTypes object in this Model.
@return the list of CompartmentTypes for this Model.
@note The CompartmentType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.


=item Model::getListOfSpeciesTypes

Get the ListOfSpeciesTypes object in this Model.
@return the list of SpeciesTypes for this Model.
@note The SpeciesType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.


=item Model::getListOfSpeciesTypes

Get the ListOfSpeciesTypes object in this Model.
@return the list of SpeciesTypes for this Model.
@note The SpeciesType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.


=item Model::getListOfCompartments

Get the ListOfCompartments object in this Model.
@return the list of Compartments for this Model.


=item Model::getListOfCompartments

Get the ListOfCompartments object in this Model.
@return the list of Compartments for this Model.


=item Model::getListOfSpecies

Get the ListOfSpecies object in this Model.
@return the list of Species for this Model.


=item Model::getListOfSpecies

Get the ListOfSpecies object in this Model.
@return the list of Species for this Model.


=item Model::getListOfParameters

Get the ListOfParameters object in this Model.
@return the list of Parameters for this Model.


=item Model::getListOfParameters

Get the ListOfParameters object in this Model.
@return the list of Parameters for this Model.


=item Model::getListOfInitialAssignments

Get the ListOfInitialAssignments object in this Model.
@return the list of InitialAssignments for this Model.


=item Model::getListOfInitialAssignments

Get the ListOfInitialAssignments object in this Model.
@return the list of InitialAssignment for this Model.


=item Model::getListOfRules

Get the ListOfRules object in this Model.
@return the list of Rules for this Model.


=item Model::getListOfRules

Get the ListOfRules object in this Model.
@return the list of Rules for this Model.


=item Model::getListOfConstraints

Get the ListOfConstraints object in this Model.
@return the list of Constraints for this Model.


=item Model::getListOfConstraints

Get the ListOfConstraints object in this Model.
@return the list of Constraints for this Model.


=item Model::getListOfReactions

Get the ListOfReactions object in this Model.
@return the list of Reactions for this Model.


=item Model::getListOfReactions

Get the ListOfReactions object in this Model.
@return the list of Reactions for this Model.


=item Model::getListOfEvents

Get the ListOfEvents object in this Model.
@return the list of Events for this Model.


=item Model::getListOfEvents

Get the ListOfEvents object in this Model.
@return the list of Events for this Model.


=item Model::getFunctionDefinition

Get the nth FunctionDefinitions object in this Model.
@param n the index of the object to return.
@return the nth FunctionDefinition of this Model.


=item Model::getFunctionDefinition

Get the nth FunctionDefinitions object in this Model.
@param n the index of the object to return.
@return the nth FunctionDefinition of this Model.


=item Model::getFunctionDefinition

Get a FunctionDefinition object based on its identifier.
@param sid the identifier to search for.
@return the FunctionDefinition in this Model with the identifier
C<sid> or C<NULL> if no such FunctionDefinition exists.


=item Model::getFunctionDefinition

Get a FunctionDefinition object based on its identifier.
@param sid the identifier to search for.
@return the FunctionDefinition in this Model with the identifier
C<sid> or C<NULL> if no such FunctionDefinition exists.


=item Model::getUnitDefinition

Get the nth UnitDefinition object in this Model.
@param n the index of the object to return.
@return the nth UnitDefinition of this Model.


=item Model::getUnitDefinition

Get the nth UnitDefinition object in this Model.
@param n the index of the object to return.
@return the nth UnitDefinition of this Model.


=item Model::getUnitDefinition

Get a UnitDefinition based on its identifier.
@param sid the identifier to search for.
@return the UnitDefinition in this Model with the identifier C<sid> or
C<NULL> if no such UnitDefinition exists.


=item Model::getUnitDefinition

Get a UnitDefinition based on its identifier.
@param sid the identifier to search for.
@return the UnitDefinition in this Model with the identifier C<sid> or
C<NULL> if no such UnitDefinition exists.


=item Model::getCompartmentType

Get the nth CompartmentType object in this Model.
@param n the index of the object to return.
@return the nth CompartmentType of this Model.
@note The CompartmentType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.


=item Model::getCompartmentType

Get the nth CompartmentType object in this Model.
@param n the index of the object to return.
@return the nth CompartmentType of this Model.
@note The CompartmentType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.


=item Model::getCompartmentType

Get a CompartmentType object based on its identifier.
@param sid the identifier to search for.
@return the CompartmentType in this Model with the identifier C<sid>
or C<NULL> if no such CompartmentType exists.
@note The CompartmentType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.


=item Model::getCompartmentType

Get a CompartmentType object based on its identifier.
@param sid the identifier to search for.
@return the CompartmentType in this Model with the identifier C<sid>
or C<NULL> if no such CompartmentType exists.
@note The CompartmentType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.


=item Model::getSpeciesType

Get the nth SpeciesType object in this Model.
@param n the index of the object to return.
@return the nth SpeciesType of this Model.
@note The SpeciesType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.


=item Model::getSpeciesType

Get the nth SpeciesType object in this Model.
@param n the index of the object to return.
@return the nth SpeciesType of this Model.
@note The SpeciesType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.


=item Model::getSpeciesType

Get a SpeciesType object based on its identifier.
@param sid the identifier to search for.
@return the SpeciesType in this Model with the identifier C<sid> or
C<NULL> if no such SpeciesType exists.
@note The SpeciesType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.


=item Model::getSpeciesType

Get a SpeciesType object based on its identifier.
@param sid the identifier to search for.
@return the SpeciesType in this Model with the identifier C<sid> or
C<NULL> if no such SpeciesType exists.
@note The SpeciesType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.


=item Model::getCompartment

Get the nth Compartment object in this Model.
@param n the index of the object to return.
@return the nth Compartment of this Model.


=item Model::getCompartment

Get the nth Compartment object in this Model.
@param n the index of the object to return.
@return the nth Compartment of this Model.


=item Model::getCompartment

Get a Compartment object based on its identifier.
@param sid the identifier to search for.
@return the Compartment in this Model with the identifier C<sid> or
C<NULL> if no such Compartment exists.


=item Model::getCompartment

Get a Compartment object based on its identifier.
@param sid the identifier to search for.
@return the Compartment in this Model with the identifier C<sid> or
C<NULL> if no such Compartment exists.


=item Model::getSpecies

Get the nth Species object in this Model.
@param n the index of the object to return.
@return the nth Species of this Model.


=item Model::getSpecies

Get the nth Species object in this Model.
@param n the index of the object to return.
@return the nth Species of this Model.


=item Model::getSpecies

Get a Species object based on its identifier.
@param sid the identifier to search for.
@return the Species in this Model with the identifier C<sid> or C<NULL>
if no such Species exists.


=item Model::getSpecies

Get a Species object based on its identifier.
@param sid the identifier to search for.
@return the Species in this Model with the identifier C<sid> or C<NULL>
if no such Species exists.


=item Model::getParameter

Get the nth Parameter object in this Model.
@param n the index of the object to return.
@return the nth Parameter of this Model.


=item Model::getParameter

Get the nth Parameter object in this Model.
@param n the index of the object to return.
@return the nth Parameter of this Model.


=item Model::getParameter

Get a Parameter object based on its identifier.
@param sid the identifier to search for.
@return the Parameter in this Model with the identifier C<sid> or C<NULL>
if no such Parameter exists.


=item Model::getParameter

Get a Parameter object based on its identifier.
@param sid the identifier to search for.
@return the Parameter in this Model with the identifier C<sid> or C<NULL>
if no such Parameter exists.


=item Model::getInitialAssignment

Get the nth InitialAssignment object in this Model.
@param n the index of the object to return.
@return the nth InitialAssignment of this Model.


=item Model::getInitialAssignment

Get the nth InitialAssignment object in this Model.
@param n the index of the object to return.
@return the nth InitialAssignment of this Model.


=item Model::getInitialAssignment

Get an InitialAssignment object based on the symbol to which it
assigns a value.
@param symbol the symbol to search for.
@return the InitialAssignment in this Model with the given "symbol"
attribute value or C<NULL> if no such InitialAssignment exists.


=item Model::getInitialAssignmentBySymbol

Get an InitialAssignment object based on the symbol to which it
assigns a value.
@param symbol the symbol to search for.
@return the InitialAssignment in this Model with the given "symbol"
attribute value or C<NULL> if no such InitialAssignment exists.


=item Model::getInitialAssignment

Get an InitialAssignment object based on the symbol to which it
assigns a value.
@param symbol the symbol to search for.
@return the InitialAssignment in this Model with the given "symbol"
attribute value or C<NULL> if no such InitialAssignment exists.


=item Model::getInitialAssignmentBySymbol

Get an InitialAssignment object based on the symbol to which it
assigns a value.
@param symbol the symbol to search for.
@return the InitialAssignment in this Model with the given "symbol"
attribute value or C<NULL> if no such InitialAssignment exists.


=item Model::getRule

Get the nth Rule object in this Model.
@param n the index of the object to return.
@return the nth Rule of this Model.


=item Model::getRule

Get the nth Rule object in this Model.
@param n the index of the object to return.
@return the nth Rule of this Model.


=item Model::getRule

Get a Rule object based on the variable to which it assigns a value.
@param variable the variable to search for.
@return the Rule in this Model with the given "variable" attribute
value or C<NULL> if no such Rule exists.


=item Model::getRule

Get a Rule object based on the variable to which it assigns a value.
@param variable the variable to search for.
@return the Rule in this Model with the given "variable" attribute
value or C<NULL> if no such Rule exists.


=item Model::getRuleByVariable

Get a Rule object based on the variable to which it assigns a value.
@param variable the variable to search for.
@return the Rule in this Model with the given "variable" attribute
value or C<NULL> if no such Rule exists.


=item Model::getRuleByVariable

Get a Rule object based on the variable to which it assigns a value.
@param variable the variable to search for.
@return the Rule in this Model with the given "variable" attribute
value or C<NULL> if no such Rule exists.


=item Model::getAssignmentRule

Get a Rule object based on the variable to which it assigns a value.
@param variable the variable to search for.
@return the Rule in this Model with the given "variable" attribute
value or C<NULL> if no such Rule exists.


=item Model::getAssignmentRule

Get a Rule object based on the variable to which it assigns a value.
@param variable the variable to search for.
@return the Rule in this Model with the given "variable" attribute
value or C<NULL> if no such Rule exists.


=item Model::getRateRule

Get a Rule object based on the variable to which it assigns a value.
@param variable the symbol to search for.
@return the Rule in this Model with the given "variable" attribute
value or C<NULL> if no such Rule exists.


=item Model::getRateRule

Get a Rule object based on the variable to which it assigns a value.
@param variable the variable to search for.
@return the Rule in this Model with the given "variable" attribute
value or C<NULL> if no such Rule exists.


=item Model::getAssignmentRuleByVariable

Get a Rule object based on the variable to which it assigns a value.
@param variable the variable to search for.
@return the Rule in this Model with the given "variable" attribute
value or C<NULL> if no such Rule exists.


=item Model::getAssignmentRuleByVariable

Get a Rule object based on the variable to which it assigns a value.
@param variable the variable to search for.
@return the Rule in this Model with the given "variable" attribute
value or C<NULL> if no such Rule exists.


=item Model::getRateRuleByVariable

Get a Rule object based on the variable to which it assigns a value.
@param variable the variable to search for.
@return the Rule in this Model with the given "variable" attribute
value or C<NULL> if no such Rule exists.


=item Model::getRateRuleByVariable

Get a Rule object based on the variable to which it assigns a value.
@param variable the variable to search for.
@return the Rule in this Model with the given "variable" attribute
value or C<NULL> if no such Rule exists.


=item Model::getConstraint

Get the nth Constraint object in this Model.
@param n the index of the object to return.
@return the nth Constraint of this Model.


=item Model::getConstraint

Get the nth Constraint object in this Model.
@param n the index of the object to return.
@return the nth Constraint of this Model.


=item Model::getReaction

Get the nth Reaction object in this Model.
@param n the index of the object to return.
@return the nth Reaction of this Model.


=item Model::getReaction

Get the nth Reaction object in this Model.
@param n the index of the object to return.
@return the nth Reaction of this Model.


=item Model::getReaction

Get a Reaction object based on its identifier.
@param sid the identifier to search for.
@return the Reaction in this Model with the identifier C<sid> or C<NULL>
if no such Reaction exists.


=item Model::getReaction

Get a Reaction object based on its identifier.
@param sid the identifier to search for.
@return the Reaction in this Model with the identifier C<sid> or C<NULL>
if no such Reaction exists.


=item Model::getSpeciesReference

Get a SpeciesReference object based on its identifier.
@param sid the identifier to search for.
@return the SpeciesReference in this Model with the identifier C<sid> or C<NULL>
if no such SpeciesReference exists.


=item Model::getSpeciesReference

Get a SpeciesReference object based on its identifier.
@param sid the identifier to search for.
@return the SpeciesReference in this Model with the identifier C<sid> or C<NULL>
if no such SpeciesReference exists.


=item Model::getModifierSpeciesReference

Get a ModifierSpeciesReference object based on its identifier.
@param sid the identifier to search for.
@return the ModifierSpeciesReference in this Model with the 
identifier C<sid> or C<NULL>
if no such ModifierSpeciesReference exists.


=item Model::getModifierSpeciesReference

Get a ModifierSpeciesReference object based on its identifier.
@param sid the identifier to search for.
@return the ModifierSpeciesReference in this Model with the 
identifier C<sid> or C<NULL>
if no such ModifierSpeciesReference exists.


=item Model::getEvent

Get the nth Event object in this Model.
@param n the index of the object to return.
@return the nth Event of this Model.


=item Model::getEvent

Get the nth Event object in this Model.
@param n the index of the object to return.
@return the nth Event of this Model.


=item Model::getEvent

Get an Event object based on its identifier.
@param sid the identifier to search for.
@return the Event in this Model with the identifier C<sid> or C<NULL> if
no such Event exists.


=item Model::getEvent

Get an Event object based on its identifier.
@param sid the identifier to search for.
@return the Event in this Model with the identifier C<sid> or C<NULL> if
no such Event exists.


=item Model::getNumFunctionDefinitions

Get the number of FunctionDefinition objects in this Model.
@return the number of FunctionDefinitions in this Model.


=item Model::getNumUnitDefinitions

Get the number of UnitDefinition objects in this Model.
@return the number of UnitDefinitions in this Model.


=item Model::getNumCompartmentTypes

Get the number of CompartmentType objects in this Model.
@return the number of CompartmentTypes in this Model.
@note The CompartmentType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.


=item Model::getNumSpeciesTypes

Get the number of SpeciesType objects in this Model.
@return the number of SpeciesTypes in this Model.
@note The SpeciesType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.


=item Model::getNumCompartments

Get the number of Compartment objects in this Model.
@return the number of Compartments in this Model.


=item Model::getNumSpecies

Get the number of Species objects in this Model.
@return the number of Species in this Model.


=item Model::getNumSpeciesWithBoundaryCondition

Get the number of Species in this Model having their
"boundaryCondition" attribute value set to C<true>.
@return the number of Species in this Model with boundaryCondition set
to true.


=item Model::getNumParameters

Get the number of Parameter objects in this Model.
@return the number of Parameters in this Model.  Parameters defined in
KineticLaws are not included.


=item Model::getNumInitialAssignments

Get the number of InitialAssignment objects in this Model.
@return the number of InitialAssignments in this Model.


=item Model::getNumRules

Get the number of Rule objects in this Model.
@return the number of Rules in this Model.


=item Model::getNumConstraints

Get the number of Constraint objects in this Model.
@return the number of Constraints in this Model.


=item Model::getNumReactions

Get the number of Reaction objects in this Model.
@return the number of Reactions in this Model.


=item Model::getNumEvents

Get the number of Event objects in this Model.
@return the number of Events in this Model.


=item Model::removeFromParentAndDelete

Remove this Model from its parent SBMLDocument object.
This works by finding this Model's parent SBMLDocument and then calling
C<setModel(NULL)> on it, indirectly deleting itself.
Overridden from the SBase function since the parent is not a ListOf.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink


=item Model::renameAllIds

@internal


=item Model::renameIDs

@internal


=item Model::renameSIdRefs

C<opydoc> doc_renamesidref_common


=item Model::renameUnitSIdRefs

C<opydoc> doc_renameunitsidref_common


=item Model::isBoolean

@internal


=item Model::convertL1ToL2

@internal


=item Model::convertL1ToL3

@internal


=item Model::convertL2ToL3

@internal


=item Model::convertL2ToL1

@internal


=item Model::convertL3ToL1

@internal


=item Model::convertL3ToL2

@internal


=item Model::convertFromL3V2

@internal


=item Model::dealWithFast

@internal


=item Model::addModifiers

@internal


=item Model::addConstantAttribute

@internal


=item Model::setSpatialDimensions

@internal


=item Model::addDefinitionsForDefaultUnits

@internal


=item Model::dealWithDefaultValues

@internal


=item Model::convertParametersToLocals

@internal


=item Model::setSpeciesReferenceConstantValueAndStoichiometry

@internal


=item Model::removeMetaId

@internal


=item Model::removeSBOTerms

@internal


=item Model::removeHasOnlySubstanceUnits

@internal


=item Model::removeSBOTermsNotInL2V2

@internal


=item Model::removeDuplicateTopLevelAnnotations

@internal


=item Model::removeParameterRuleUnits

@internal


=item Model::convertStoichiometryMath

@internal


=item Model::assignRequiredValues

@internal


=item Model::dealWithModelUnits

@internal


=item Model::dealWithStoichiometry

@internal


=item Model::dealWithEvents

@internal


=item Model::removeSpeciesTypes

@internal


=item Model::removeCompartmentTypes

@internal


=item Model::setSBMLDocument

@internal


=item Model::getTypeCode

Returns the libSBML type code for this SBML object.
C<opydetails> doc_what_are_typecodes
@return the SBML type code for this object:
@link SBMLTypeCode_t#SBML_MODEL SBML_MODEL@endlink (default).
C<opydetails> doc_warning_typecodes_not_unique
@see getElementName()
@see getPackageName()


=item Model::getElementName

Returns the XML element name of this object, which for Model, is
always C<"model">.
@return the name of this element, i.e., C<"model">.


=item Model::getElementPosition

@internal


=item Model::writeElements

@internal


=item Model::populateListFormulaUnitsData

Populates the internal list of derived units for this Model object.
This method tells libSBML to (re)calculate all units for all components
of the enclosing Model object.  The result is stored in an internal list
of unit data.  Users can access the resulting data by calling the method
SBase::getDerivedUnitDefinition() available on most objects.  (The name
"formula units data" is drawn from the name of the internal objects
libSBML uses to store the data; note that these internal objects are not
exposed to callers, because callers can interact with the results using
the ordinary SBML unit objects.)
This method is used by libSBML itself in the validator concerned with
unit consistency.  The unit consistency validator (like all other
validators in libSBML) is invoked by using
SBMLDocument::checkConsistency(), with the consistency checks for the
category @link SBMLErrorCategory_t#LIBSBML_CAT_UNITS_CONSISTENCY LIBSBML_CAT_UNITS_CONSISTENCY@endlink turned on.  The method
populateListFormulaUnitsData() does not need to be called prior to
invoking the validator if unit consistency checking has not been turned
off.  This method is only provided for cases when callers have a special
need to force the unit data to be recalculated.  For instance, during
construction of a model, a caller may want to interrogate libSBML's
inferred units without invoking full-blown model validation; this is a
scenario in which calling populateListFormulaUnitsData() may be useful.
@warning Computing and inferring units is a time-consuming operation.
Callers may want to call isPopulatedListFormulaUnitsData() to determine
whether the units may already have been computed, to save themselves the
need of invoking unit inference unnecessarily.
@see isPopulatedListFormulaUnitsData()


=item Model::isPopulatedListFormulaUnitsData

Predicate returning C<true> if libSBML has derived units for the
components of this model.
LibSBML can infer the units of measurement associated with different
elements of a model.  When libSBML does that, it builds a complex
internal structure during a resource-intensive operation.  This is done
automatically only when callers invoke validation (via
SBMLDocument::checkConsistency()) and have not turned off the unit
validation option.
Callers can force units to be recalculated by calling
populateListFormulaUnitsData().  To avoid calling that method
unnecessarily, calling programs may first want to invoke this method
(isPopulatedListFormulaUnitsData()) to determine whether it is even
necessary.

@return C<true> if the units have already been computed, C<false>
otherwise.


=item Model::addFormulaUnitsData

@internal


=item Model::createFormulaUnitsData

@internal


=item Model::getFormulaUnitsData

@internal


=item Model::getFormulaUnitsData

@internal


=item Model::getFormulaUnitsData

@internal


=item Model::getFormulaUnitsData

@internal


=item Model::getFormulaUnitsDataForVariable

@internal


=item Model::getFormulaUnitsDataForAssignment

@internal


=item Model::getNumFormulaUnitsData

@internal


=item Model::getListFormulaUnitsData

@internal


=item Model::getListFormulaUnitsData

@internal


=item Model::populateAllElementIdList

Populates the internal list of the identifiers of all elements within this Model object.
This method tells libSBML to retrieve the identifiers of all elements
of the enclosing Model object.  The result is stored in an internal list
of ids.  Users can access the resulting data by calling the method
getAllElementIdList().

@warning Retrieving all elements within a model is a time-consuming operation.
Callers may want to call isPopulatedAllElementIdList() to determine
whether the id list may already have been populated.
@see isPopulatedAllElementIdList()


=item Model::isPopulatedAllElementIdList

Predicate returning C<true> if libSBML has a list of the ids of all 
components of this model.
@return C<true> if the id list has already been populated, C<false>
otherwise.


=item Model::getAllElementIdList

Returns the internal list of the identifiers of all elements within this Model object.
@return an IdList of all the identifiers in the model.
@see populateAllElementIdList()
@see isPopulatedAllElementIdList()


=item Model::clearAllElementIdList

Clears the internal list of the identifiers of all elements within this Model object.
@see populateAllElementIdList()
@see isPopulatedAllElementIdList()


=item Model::populateAllElementMetaIdList

Populates the internal list of the metaids of all elements within this Model object.
This method tells libSBML to retrieve the identifiers of all elements
of the enclosing Model object.  The result is stored in an internal list
of metaids.  Users can access the resulting data by calling the method
getAllElementMetaIdList().

@warning Retrieving all elements within a model is a time-consuming operation.
Callers may want to call isPopulatedAllElementMetaIdList() to determine
whether the metaid list may already have been populated.
@see isPopulatedAllElementMetaIdList()


=item Model::isPopulatedAllElementMetaIdList

Predicate returning C<true> if libSBML has a list of the metaids of all 
components of this model.
@return C<true> if the metaid list has already been populated, C<false>
otherwise.


=item Model::getAllElementMetaIdList

Returns the internal list of the metaids of all elements within this Model object.
@return an IdList of all the metaids in the model.
@see populateAllElementMetaIdList()
@see isPopulatedAllElementMetaIdList()


=item Model::clearAllElementMetaIdList

Clears the internal list of the metaids of all elements within this Model object.
@see populateAllElementMetaIdList()
@see isPopulatedAllElementMetaIdList()


=item Model::hasRequiredElements

Predicate returning C<true> if all the required elements for this Model
object have been set.
@return a boolean value indicating whether all the required
elements for this object have been defined.


=item Model::removeFunctionDefinition

Removes the nth FunctionDefinition object from this Model object and 
returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the FunctionDefinition object to remove.
@return the FunctionDefinition object removed, or C<NULL> if the given
index is out of range.


=item Model::removeFunctionDefinition

Removes the FunctionDefinition object with the given identifier from this Model 
object and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param sid the identifier of the FunctionDefinition object to remove.
@return the FunctionDefinition object removed, or C<NULL> if no
FunctionDefinition object with the identifier exists in this Model
object.


=item Model::removeUnitDefinition

Removes the nth UnitDefinition object from this Model object and
returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the UnitDefinition object to remove.
@return the UnitDefinition object removed., or C<NULL> if the given
index is out of range.


=item Model::removeUnitDefinition

Removes the UnitDefinition object with the given identifier from this Model
object and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param sid the identifier of the UnitDefinition object to remove.
@return the UnitDefinition object removed, or C<NULL> if no
UnitDefinition object with the identifier exists in this Model object.


=item Model::removeCompartmentType

Removes the nth CompartmentType object from this Model object and
returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the CompartmentType object to remove.
@return the ComapartmentType object removed, or C<NULL> if the given
index is out of range.


=item Model::removeCompartmentType

Removes the CompartmentType object with the given identifier from this Model
object and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param sid the identifier of the object to remove.
@return the CompartmentType object removed, or C<NULL> if no
CompartmentType object with the identifier exists in this Model object.


=item Model::removeSpeciesType

Removes the nth SpeciesType object from this Model object and
returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the SpeciesType object to remove.
@return the SpeciesType object removed, or C<NULL> if the given index is
out of range.


=item Model::removeSpeciesType

Removes the SpeciesType object with the given identifier from this Model
object and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param sid the identifier of the SpeciesType object to remove.
@return the SpeciesType object removed, or C<NULL> if no SpeciesType
object with the identifier exists in this Model object.


=item Model::removeCompartment

Removes the nth Compartment object from this Model object and
returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the Compartment object to remove.
@return the Compartment object removed, or C<NULL> if the given index is
out of range.


=item Model::removeCompartment

Removes the Compartment object with the given identifier from this Model
object and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param sid the identifier of the Compartment object to remove.
@return the Compartment object removed, or C<NULL> if no Compartment
object with the identifier exists in this Model object.


=item Model::removeSpecies

Removes the nth Species object from this Model object and
returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the Species object to remove.
@return the Species object removed, or C<NULL> if the given index is out
of range.


=item Model::removeSpecies

Removes the Species object with the given identifier from this Model
object and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param sid the identifier of the Species object to remove.
@return the Species object removed, or C<NULL> if no Species object with
the identifier exists in this Model object.


=item Model::removeParameter

Removes the nth Parameter object from this Model object and
returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the Parameter object to remove.
@return the Parameter object removed, or C<NULL> if the given index is
out of range.


=item Model::removeParameter

Removes the Parameter object with the given identifier from this Model
object and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param sid the identifier of the Parameter object to remove.
@return the Parameter object removed, or C<NULL> if no Parameter object
with the identifier exists in this Model object.


=item Model::removeInitialAssignment

Removes the nth InitialAssignment object from this Model object and
returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the InitialAssignment object to remove.
@return the InitialAssignment object removed, or C<NULL> if the given
index is out of range.


=item Model::removeInitialAssignment

Removes the InitialAssignment object with the given "symbol" attribute 
from this Model object and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param symbol the "symbol" attribute of the InitialAssignment object to remove.
@return the InitialAssignment object removed, or C<NULL> if no
InitialAssignment object with the "symbol" attribute exists in this
Model object.


=item Model::removeRule

Removes the nth Rule object from this Model object and
returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the Rule object to remove.
@return the Rule object removed, or C<NULL> if the given index is out of
range.


=item Model::removeRule

Removes the Rule object with the given "variable" attribute from this Model 
object and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param variable the "variable" attribute of the Rule object to remove.
@return the Rule object removed, or C<NULL> if no Rule object with the
"variable" attribute exists in this Model object.


=item Model::removeRuleByVariable

Removes the Rule object with the given "variable" attribute from this Model 
object and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param variable the "variable" attribute of the Rule object to remove.
@return the Rule object removed, or C<NULL> if no Rule object with the
"variable" attribute exists in this Model object.


=item Model::removeConstraint

Removes the nth Constraint object from this Model object and
returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the Constraint object to remove.
@return the Constraint object removed, or C<NULL> if the given index is
out of range.


=item Model::removeReaction

Removes the nth Reaction object from this Model object and
returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the Reaction object to remove.
@return the Reaction object removed, or C<NULL> if the given index is
out of range.


=item Model::removeReaction

Removes the Reaction object with the given identifier from this Model
object and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param sid the identifier of the Reaction object to remove.
@return the Reaction object removed, or C<NULL> if no Reaction object
with the identifier exists in this Model object.


=item Model::removeEvent

Removes the nth Event object from this Model object and
returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the Event object to remove.
@return the Event object removed, or C<NULL> if the given index is out
of range.


=item Model::removeEvent

Removes the Event object with the given identifier from this Model
object and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param sid the identifier of the Event object to remove.
@return the Event object removed, or C<NULL> if no Event object with the
identifier exists in this Model object.


=item Model::appendFrom

Copies a given Model object's subcomponents and appends the copies to
the appropriate places in this Model.
This method also calls the C<appendFrom> method on all libSBML
plug-in objects.
C<opydetails> doc_what_are_plugins
@param model the Model to merge with this one.


=item Model::enablePackageInternal

@internal


=item Model::readOtherXML

@internal


=item Model::createObject

@internal


=item Model::addExpectedAttributes

@internal


=item Model::readAttributes

@internal


=item Model::readL1Attributes

@internal


=item Model::readL2Attributes

@internal


=item Model::readL3Attributes

@internal


=item Model::writeAttributes

@internal


=item Model::syncAnnotation

@internal


=item Model::populatePerTimeUnitDefinition

@internal


=item Model::createSpeciesReferenceUnitsData

@internal


=item Model::removeListFormulaUnitsData

@internal


=item Model::createSubstanceUnitsData

@internal


=item Model::getL3SubstanceUD

@internal


=item Model::getSubstanceUD

@internal


=item Model::createTimeUnitsData

@internal


=item Model::getL3TimeUD

@internal


=item Model::getTimeUD

@internal


=item Model::createVolumeUnitsData

@internal


=item Model::getL3VolumeUD

@internal


=item Model::getVolumeUD

@internal


=item Model::createAreaUnitsData

@internal


=item Model::getL3AreaUD

@internal


=item Model::getAreaUD

@internal


=item Model::createLengthUnitsData

@internal


=item Model::getL3LengthUD

@internal


=item Model::getLengthUD

@internal


=item Model::createExtentUnitsData

@internal


=item Model::getL3ExtentUD

@internal


=item Model::createSubstancePerTimeUnitsData

@internal


=item Model::getL3SubstancePerTimeUD

@internal


=item Model::getSubstancePerTimeUD

@internal


=item Model::createCompartmentUnitsData

@internal


=item Model::createSpeciesUnitsData

@internal


=item Model::createL3SpeciesUnitsData

@internal


=item Model::createParameterUnitsData

@internal


=item Model::createUnitsDataFromMath

@internal


=item Model::createInitialAssignmentUnitsData

@internal


=item Model::createRuleUnitsData

@internal


=item Model::createReactionUnitsData

@internal


=item Model::createEventUnitsData

@internal


=item Model::createDelayUnitsData

@internal


=item Model::createPriorityUnitsData

@internal


=item Model::createEventAssignmentUnitsData

@internal


=item Model::createLocalParameterUnitsData

@internal


=back

=head2 SBMLDocument

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html Overall SBML container object.
@if clike LibSBML uses the class SBMLDocument as a
top-level container for storing SBML content and data associated with it
(such as warnings and error messages).  The two primary means of reading
an SBML model, SBMLReader::readSBML() and
SBMLReader::readSBMLFromString(), both return a pointer to an
SBMLDocument object.  From there, callers can inquire about any errors
encountered (e.g., using SBMLDocument::getNumErrors()), access the Model
object, and perform other actions such as consistency-checking and model
translation.
@endif@if python LibSBML uses the class SBMLDocument as a
top-level container for storing SBML content and data associated with it
(such as warnings and error messages).  The two primary means of reading
an SBML model, SBMLReader::readSBML() and
SBMLReader::readSBMLFromString(), both return a pointer to an
SBMLDocument object.  From there, callers can inquire about any errors
encountered (e.g., using SBMLDocument::getNumErrors()), access the Model
object, and perform other actions such as consistency-checking and model
translation.
@endif@if java LibSBML uses the class SBMLDocument as a top-level
container for storing SBML content and data associated with it (such as
warnings and error messages).  The two primary means of reading an SBML
model, SBMLReader::readSBML(String filename) and
SBMLReader::readSBMLFromString(String xml), both return an SBMLDocument
object.  From there, callers can inquire about any errors encountered
(e.g., using SBMLDocument::getNumErrors()), access the Model object, and
perform other actions such as consistency-checking and model
translation.
@endif@~
When creating fresh models programmatically, the starting point is
typically the creation of an SBMLDocument object instance.  The
SBMLDocument constructor accepts arguments for the SBML Level and
Version of the model to be created.  After creating the SBMLDocument
object, calling programs then typically call SBMLDocument::createModel()
almost immediately, and then proceed to call the methods on the Model
object to fill out the model's contents.
SBMLDocument corresponds roughly to the class <i>Sbml</i> defined in the
SBML Level&nbsp;2 specification and <i>SBML</i> in the Level&nbsp;3
specification.  It does not have a direct correspondence in SBML
Level&nbsp;1.  (However, to make matters simpler for applications,
libSBML creates an SBMLDocument no matter whether the model is
Level&nbsp;1, Level&nbsp;2 or Level&nbsp;3.)  In its barest form, when written out in
XML format for (e.g.) SBML Level&nbsp;2 Version&nbsp;4, the corresponding
structure is the following:
@verbatim
<sbml xmlns="http://www.sbml.org/sbml/level2/version4" level="2" version="4">
...
</sbml>@endverbatim
SBMLDocument is derived from SBase, and therefore contains the usual SBase
attributes (in SBML Level&nbsp;2 and Level&nbsp;3) of "metaid" and "sboTerm", as
well as the subelements "notes" and "annotation".  It also contains the
attributes "level" and "version" indicating the Level and Version of the
SBML data structure.  These can be accessed using the methods defined by
the SBase class for that purpose.
@section checking Checking consistency and adherence to SBML specifications
One of the most important features of libSBML is its ability to perform
SBML validation to ensure that a model adheres to the SBML specification
for whatever Level+Version combination the model uses.  SBMLDocument
provides the methods for running consistency-checking and validation
rules on the SBML content.
First, a brief explanation of the rationale is in order.  In libSBML
versions up to and including the version&nbsp;3.3.x series, the
individual methods for creating and setting attributes and other
components were quite lenient, and allowed a caller to compose SBML
entities that might not, in the end, represent valid SBML.  This allowed
applications the freedom to do things such as save incomplete models
(which is useful when models are being developed over long periods of
time).  In the version&nbsp;4.x series, libSBML is somewhat stricter,
but still permits structures to be created independently and the results
to be combined in a separate step.  In all these cases, it means that a
separate validation step is necessary when a calling program finally
wants to finish a complete SBML document.
The primary interface to this validation facility is SBMLDocument's
SBMLDocument::checkInternalConsistency() and
SBMLDocument::checkConsistency().  The former verifies the basic
internal consistency and syntax of an SBML document, and the latter
implements more elaborate validation rules (both those defined by the
SBML specifications, as well as additional rules offered by libSBML).
@if clike The checks performed by SBMLDocument::checkInternalConsistency() are
hardwired and cannot be changed by calling programs, but the validation
performed by SBMLDocument::checkConsistency() is under program control
using the method SBMLDocument::setConsistencyChecks().  Applications can
selectively disable specific kinds of checks that they may not be
interested in, by calling SBMLDocument::setConsistencyChecks() with
appropriate parameters.
@endif@if python The checks performed by SBMLDocument::checkInternalConsistency() are
hardwired and cannot be changed by calling programs, but the validation
performed by SBMLDocument::checkConsistency() is under program control
using the method SBMLDocument::setConsistencyChecks().  Applications can
selectively disable specific kinds of checks that they may not be
interested in, by calling SBMLDocument::setConsistencyChecks() with
appropriate parameters.
@endif@if java The checks performed by SBMLDocument::checkInternalConsistency() are
hardwired and cannot be changed by calling programs, but the validation
performed by SBMLDocument::checkConsistency() is under program control
using the method SBMLDocument::setConsistencyChecks(int categ, boolean
onoff).  Applications can selectively disable specific kinds of checks
that they may not be interested by calling
SBMLDocument::setConsistencyChecks(int categ, boolean onoff) with
appropriate parameters.
@endif@~

These methods have slightly different relevance depending on whether a
model is created programmaticaly from scratch, or whether it is read in
from a file or data stream.  The following list summarizes the possible
scenarios.

<em>Scenario 1: Creating a model from scratch</em>.  Before writing out
the model, 
@li Call SBMLDocument::checkInternalConsistency(), then inquire about
the results by calling SBMLDocument::getNumErrors()
@li Call @if java SBMLDocument::setConsistencyChecks(int categ, boolean
onoff) @else SBMLDocument::setConsistencyChecks() @endif@~ to configure
which checks will be performed by SBMLDocument::checkConsistency()
@li Call SBMLDocument::checkConsistency(), then inquire about the results by
calling SBMLDocument::getNumErrors()
<em>Scenario 2: Reading a model from a file or data stream.</em> After
reading the model,
@li Basic consistency checks will have been performed automatically by
libSBML upon reading the content, so you only need to inquire about the
results by using SBMLDocument::getNumErrors()
@li Call @if java SBMLDocument::setConsistencyChecks(int categ, boolean
onoff) @else SBMLDocument::setConsistencyChecks() @endif@~ to configure
which checks are performed by SBMLDocument::checkConsistency()
@li Call SBMLDocument::checkConsistency(), then inquire about the results
by calling SBMLDocument::getNumErrors()
@if clike An example of using the consistency-checking
and validation facilities is provided in this manual in the
section @ref libsbml-example. @endif@~
It should be noted that as of SBML Level&nbsp;3 Version&nbsp;2, the Model
became an optional child of SBMLDocument, instead of being required.  This
means that one can no longer use SBMLDocument::getModel() as a cheap method
of checking if an SBML document was read in properly: the more robust
getError methods detailed above must be used instead.
@section converting Converting documents between Levels and Versions of SBML
LibSBML provides facilities for limited translation of SBML between
Levels and Versions of the SBML specifications.  The method for doing is
is @if java SBMLDocument::setLevelAndVersion(long lev, long ver, boolean strict) @else setLevelAndVersion() @endif.  In 
general, models can be converted upward without difficulty (e.g., from
SBML Level&nbsp;1 to Level&nbsp;2, or from an earlier Version of
Level&nbsp;2 to the latest Version of Level&nbsp;2).  Sometimes models
can be translated downward as well, if they do not use constructs
specific to more advanced Levels of SBML.
Calling @if java SBMLDocument::setLevelAndVersion(long lev, long ver, boolean strict) @else SBMLDocument::setLevelAndVersion() @endif@~ will not I<necessarily> lead
to a successful conversion.  The method will return a boolean value
to indicate success or failure.  Callers must check the error log (see 
next section) attached to the SBMLDocument object after calling
@if java SBMLDocument::setLevelAndVersion(long lev, long ver) @else SBMLDocument::setLevelAndVersion() @endif@~ in order to assess whether any
problems arose.
If an application is interested in translating to a lower Level and/or
Version of SBML within a Level, the following methods allow for prior
assessment of whether there is sufficient compatibility to make a
translation possible:
@li SBMLDocument::checkL1Compatibility(),
@li SBMLDocument::checkL2v1Compatibility(),
@li SBMLDocument::checkL2v2Compatibility(),
@li SBMLDocument::checkL2v3Compatibility(), 
@li SBMLDocument::checkL2v4Compatibility(),
@li SBMLDocument::checkL2v5Compatibility(), and
@li SBMLDocument::checkL3v1Compatibility().
Some changes between Versions of SBML Level&nbsp;2 may lead to
unexpected behaviors when attempting conversions in either direction.
For example, SBML Level&nbsp;2 Version&nbsp;4 relaxed the requirement
for consistency in units of measurement between expressions annd
quantities in a model.  As a result, a model written in Version&nbsp;4,
if converted to Version&nbsp;3 with no other changes, may fail
validation as a Version&nbsp;3 model because Version&nbsp;3 imposed
stricter requirements on unit consistency.
Other changes between SBML Level 2 and Level 3 make downward conversions
challenging.  In some cases, it means that a model converted to
Level&nbsp;2 from Level&nbsp;3 will contain attributes that were not
explicitly given in the Level&nbsp;3 model, because in Level&nbsp;2
these attributes may have been optional or have default values.
@section errors Error handling
Upon reading a model, SBMLDocument logs any problems encountered while
reading the model from the file or data stream.  The log contains
objects that record diagnostic information about any notable issues that
arose.  Whether the problems are warnings or errors, they are both
reported through a single common interface involving the object class
SBMLError.

The methods SBMLDocument::getNumErrors(), @if java SBMLDocument::getError(long n) @else SBMLDocument::getError() @endif@~ and
SBMLDocument::printErrors() allow callers to interact with the warnings
or errors logged.  Alternatively, callers may retrieve the entire log as
an SBMLErrorLog object using the method SBMLDocument::getErrorLog().
The SBMLErrorLog object provides some alternative methods for
interacting with the set of errors and warnings.  In either case,
applications typically should first call SBMLDocument::getNumErrors() to
find out if any issues have been logged after specific libSBML
operations such as the ones discussed in the sections above.  If they
have, then an application will should proceed to inspect the individual
reports using either the direct interfaces on SBMLDocument or using the
methods on the SBMLErrorLog object.
@if clike An example of using the error facility is
provided in this manual in the
section @ref libsbml-example. @endif@~

=over


=item SBMLDocument::getDefaultLevel

The default SBML Level of new SBMLDocument objects.
C<opydetails> doc_sbmldocument_default_level
@return an integer indicating the most recent SBML specification Level.
C<opydetails> doc_note_static_methods
@see @if clike getDefaultVersion() @else SBMLDocument::getDefaultVersion() @endif@~


=item SBMLDocument::getDefaultVersion

The default Version of new SBMLDocument objects.
C<opydetails> doc_sbmldocument_default_version 
@return an integer indicating the most recent SBML specification
Version.

C<opydetails> doc_note_static_methods
@see @if clike getDefaultLevel() @else SBMLDocument::getDefaultLevel() @endif@~


=item SBMLDocument::SBMLDocument

Creates a new SBMLDocument, optionally with given values for the SBML
Level and Version.
If <em>both</em> the SBML Level and Version attributes are not
specified, the SBML document is treated as having the latest Level and
Version of SBML as determined by SBMLDocument::getDefaultLevel() and
SBMLDocument::getDefaultVersion(); <em>however</em>, the SBMLDocument
object is otherwise left blank.  In particular, the blank SBMLDocument
object has no associated XML attributes, including (but not limited
to) an XML namespace declaration.  The XML namespace declaration is
not added until the model is written out, <em>or</em> the method
SBMLDocument::setLevelAndVersion(@if java long, long, boolean@endif)
is called.  This may be important to keep in mind
if an application needs to add additional XML namespace declarations
on the C<&lt;sbml&gt;> element.  Application writers should
either provide values for C<level> and C<version> on the call to this
constructor, or else call
SBMLDocument::setLevelAndVersion(@if java long, long, boolean@endif)
shortly after creating the SBMLDocument object.
@param level an integer for the SBML Level.
@param version an integer for the Version within the SBML Level.
C<opydetails> doc_throw_exception_lv
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~
@see SBMLDocument::setLevelAndVersion(@if java long, long, boolean@endif)
@see getDefaultLevel()
@see getDefaultVersion()


=item SBMLDocument::SBMLDocument

Creates a new SBMLDocument using the given SBMLNamespaces object 
C<sbmlns>.
C<opydetails> doc_what_are_sbmlnamespaces 
@param sbmlns an SBMLNamespaces object.
C<opydetails> doc_throw_exception_namespace


=item SBMLDocument::SBMLDocument

Copy constructor; creates a copy of this SBMLDocument.
@param orig the object to copy.


=item SBMLDocument::accept

@internal


=item SBMLDocument::clone

Creates and returns a deep copy of this SBMLDocument object.
@return the (deep) copy of this SBMLDocument object.


=item SBMLDocument::isSetModel

Returns C<true> if the Model object has been set, otherwise 
returns C<false>.
@return C<true> if the Model object has been set


=item SBMLDocument::getModel

Returns the Model object stored in this SBMLDocument.
It is important to note that this method <em>does not create</em> a
Model instance.  The model in the SBMLDocument must have been created
at some prior time, for example using SBMLDocument::createModel() 
or SBMLDocument::setModel(@if java Model@endif).
This method returns C<NULL> if a model does not yet exist.
@return the Model contained in this SBMLDocument, or C<NULL> if no such model exists.
@see createModel()


=item SBMLDocument::getModel

Returns the Model object stored in this SBMLDocument.
It is important to note that this method <em>does not create</em> a
Model instance.  The model in the SBMLDocument must have been created
at some prior time, for example using SBMLDocument::createModel() 
or SBMLDocument::setModel(@if java Model@endif).
This method returns C<NULL> if a model does not yet exist.
@return the Model contained in this SBMLDocument.
@see createModel()


=item SBMLDocument::getElementBySId

Returns the first child element found that has the given C<id> in the
model-wide SId namespace, or C<NULL> if no such object is found.
@param id string representing the id of the object to find.
@return pointer to the first element found with the given C<id>.


=item SBMLDocument::getElementByMetaId

Returns the first child element it can find with the given C<metaid>, or
itself if it has the given C<metaid>, or C<NULL> if no such object is
found.

@param metaid string representing the metaid of the object to find.
@return pointer to the first element found with the given C<metaid>.


=item SBMLDocument::getAllElements

Returns a List of all child SBase objects, including those nested to an
arbitrary depth
@param filter a pointer to an ElementFilter, which causes the function 
to return only elements that match a particular set of constraints.  
If NULL (the default), the function will return all child objects.
@return a List of pointers to all children objects.


=item SBMLDocument::expandFunctionDefinitions

Removes FunctionDefinition constructs from the document and expands
any instances of their use within C<&lt;math&gt;> elements.
For example, suppose a Model contains a FunctionDefinition with
identifier C<"f"> representing the math expression: <em>f(x, y) = x  
y</em>.  Suppose further that there is a reaction in which the
C<&lt;math&gt;> element of the KineticLaw object contains
C<f(s, p)>, where C<s> and C<p> are other identifiers
defined in the model.  The outcome of invoking this method is that the
C<&lt;math&gt;> of the KineticLaw now represents the
expression <em>s   p</em> and the model no longer contains any
FunctionDefinition objects.
@return bool C<true> if the transformation was successful, 
C<false>, otherwise.
@note This function will check the consistency of a model before
attemptimg the transformation.  If the model is not valid SBML, the
transformation will not be performed and the function will return @c
false.


=item SBMLDocument::expandInitialAssignments

Removes InitialAssignment constructs from the document and
replaces them with appropriate values.
For example, suppose a Model contains a InitialAssignment to a symbol
C<"k"> where C<"k"> is the identifier of a Parameter.  The outcome of
invoking this method is that the "value" attribute of the Parameter
definition is set to the result calculated using the InitialAssignment
object's C<&lt;math&gt;> formula, and the corresponding
InitialAssignment is then removed from the Model.
@return bool C<true> if the transformation was successful, 
C<false>, otherwise.
@note This function will check the consistency of a model before
attemptimg the transformation.  If the model is not valid SBML, the
transformation will not be performed and the function will return @c
false.  As part of that process, this method will check that it has
values for any components referred to by the C<&lt;math&gt;>
elements of InitialAssignment objects.  In cases where not all of the
values have been declared (e.g., if the mathematical expression refers
to model entities that have no declared values), the InitialAssignment
in question will I<not> be removed and this method will return @c
false.


=item SBMLDocument::setLevelAndVersion

Sets the SBML Level and Version of this SBMLDocument instance,
attempting to convert the model as needed.
This method is the principal way in libSBML to convert models between
Levels and Versions of SBML.  Generally, models can be converted
upward without difficulty (e.g., from SBML Level&nbsp;1 to
Level&nbsp;2, or from an earlier Version of Level&nbsp;2 to the latest
Version of Level&nbsp;2).  Sometimes models can be translated downward
as well, if they do not use constructs specific to more advanced
Levels of SBML.
Before calling this method, callers may check compatibility directly
using the methods SBMLDocument::checkL1Compatibility(),
SBMLDocument::checkL2v1Compatibility(),
SBMLDocument::checkL2v2Compatibility(),
SBMLDocument::checkL2v3Compatibility(),
SBMLDocument::checkL2v4Compatibility(),
SBMLDocument::checkL2v5Compatibility(), and
SBMLDocument::checkL3v1Compatibility().

The valid combinations of SBML Level and Version as of this release
of libSBML are the following: 
\n=over\n
\n=item\n\nLevel&nbsp;1 Version&nbsp;2
\n=item\n\nLevel&nbsp;2 Version&nbsp;1
\n=item\n\nLevel&nbsp;2 Version&nbsp;2
\n=item\n\nLevel&nbsp;2 Version&nbsp;3
\n=item\n\nLevel&nbsp;2 Version&nbsp;4
\n=item\n\nLevel&nbsp;2 Version&nbsp;5
\n=item\n\nLevel&nbsp;3 Version&nbsp;1
\n=item\n\nLevel&nbsp;3 Version&nbsp;2
\n=back\n

Strict conversion applies the additional criteria that both the
source and the target model must be consistent SBML.  Users can
control the consistency checks that are applied using the
SBMLDocument::setConsistencyChecksForConversion(@if java int, boolean@endif) method.  If either
the source or the potential target model have validation errors, the
conversion is not performed.  When a strict conversion is successful,
the underlying SBML object model is altered to reflect the new level
and version.  Thus, information that cannot be converted
(e.g. sboTerms) will be lost.
@param level the desired SBML Level.
@param version the desired Version within the SBML Level.
@param strict boolean indicating whether to check consistency
of both the source and target model when performing
conversion (defaults to C< true >).
@param ignorePackages boolean indicating whether the presence of
packages should be ignored by the conversion routine 
(defaults to C< false >).
@return C<true> if the level and version of the document were
successfully set to the requested values (which may have required
conversion of the model), C<false> otherwise.
@note Calling this method will not I<necessarily> lead to a successful
conversion.  If the conversion fails, it will be logged in the error
list associated with this SBMLDocument.  Callers should consult
getNumErrors() to find out if the conversion succeeded without
problems.  For conversions from Level&nbsp;2 to Level&nbsp;1, callers
can also check the Level of the model after calling this method to
find out whether it is Level&nbsp;1.  (If the conversion to
Level&nbsp;1 failed, the Level of this model will be left unchanged.)
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~
@see checkL1Compatibility()
@see checkL2v1Compatibility()
@see checkL2v2Compatibility()
@see checkL2v3Compatibility()
@see checkL2v4Compatibility()
@see checkL2v5Compatibility()
@see checkL3v1Compatibility()


=item SBMLDocument::updateSBMLNamespace

@internal


=item SBMLDocument::setModel

Sets the Model for this SBMLDocument to a copy of the given Model.
@param m the new Model to use.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
@see createModel()
@see getModel()


=item SBMLDocument::createModel

Creates a new Model inside this SBMLDocument, and returns a pointer to
it.

In SBML Level&nbsp;2, the use of an identifier on a Model object is
optional.  This method takes an optional argument, C<sid>, for setting
the identifier.  If not supplied, the identifier attribute on the
Model instance is not set.
@param sid the identifier of the new Model to create.
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~
@see getModel()
@see SBMLDocument::setModel(@if java Model@endif)


=item SBMLDocument::setLocationURI

Sets the location of this SBMLDocument.
Called automatically when readSBMLFromFile is used, but may be set
manually as well.


=item SBMLDocument::getLocationURI

Get the location of this SBMLDocument.
If this document was read from a file or had its location set manually,
that filename or set location will be returned, otherwise, an empty
string is returned.


=item SBMLDocument::getLocationURI

Get the location of this SBMLDocument.
If this document was read from a file or had its location set manually,
that filename or set location will be returned, otherwise, an empty
string is returned.


=item SBMLDocument::setConsistencyChecks

Controls the consistency checks that are performed when
SBMLDocument::checkConsistency() is called.
This method works by adding or subtracting consistency checks from the
set of all possible checks that SBMLDocument::checkConsistency() knows
how to perform.  This method may need to be called multiple times in
order to achieve the desired combination of checks.  The first
argument (C<category>) in a call to this method indicates the category
of consistency/error checks that are to be turned on or off, and the
second argument (C<apply>, a boolean) indicates whether to turn it on
(value of C<true>) or off (value of C<false>).
@if clike
The possible categories (values to the argument C<category>) are the
set of values from the enumeration #SBMLErrorCategory_t.
The following are the possible choices:
@endif@if java
The possible categories (values to the argument C<category>) are the
set of constants whose names begin with the characters C<LIBSBML_CAT_>
in the interface class {@link libsbmlConstants}.
The following are the possible choices:
@endif@if python 
The possible categories (values to the argument C<category>) are the
set of constants whose names begin with the characters C<LIBSBML_CAT_>
in the interface class @link libsbml libsbml@endlink.
The following are the possible choices:
@endif@~
\n=over\n
\n=item\n\n@link SBMLErrorCategory_t#LIBSBML_CAT_GENERAL_CONSISTENCY LIBSBML_CAT_GENERAL_CONSISTENCY@endlink:
Correctness and consistency of specific SBML language constructs.
Performing this set of checks is highly recommended.  With respect to
the SBML specification, these concern failures in applying the
validation rules numbered 2xxxx in the Level&nbsp;2
Versions&nbsp;2&ndash;4 and Level&nbsp;3 Versions&nbsp;1&ndash;2 specifications.
\n=item\n\n@link SBMLErrorCategory_t#LIBSBML_CAT_IDENTIFIER_CONSISTENCY LIBSBML_CAT_IDENTIFIER_CONSISTENCY@endlink:
Correctness and consistency of identifiers used for model entities.  An
example of inconsistency would be using a species identifier in a
reaction rate formula without first having declared the species.  With
respect to the SBML specification, these concern failures in applying
the validation rules numbered 103xx in the Level&nbsp;2
Versions&nbsp;2&ndash;4 and Level&nbsp;3 Versions&nbsp;1&ndash;2 specifications.
\n=item\n\n@link SBMLErrorCategory_t#LIBSBML_CAT_UNITS_CONSISTENCY LIBSBML_CAT_UNITS_CONSISTENCY@endlink:
Consistency of measurement units associated with quantities in a model.
With respect to the SBML specification, these concern failures in
applying the validation rules numbered 105xx in the Level&nbsp;2
Versions&nbsp;2&ndash;4 and Level&nbsp;3 Versions&nbsp;1&ndash;2 specifications.
\n=item\n\n@link SBMLErrorCategory_t#LIBSBML_CAT_MATHML_CONSISTENCY LIBSBML_CAT_MATHML_CONSISTENCY@endlink:
Syntax of MathML constructs.  With respect to the SBML specification,
these concern failures in applying the validation rules numbered 102xx
in the Level&nbsp;2 Versions&nbsp;2&ndash;4 and Level&nbsp;3
Versions&nbsp;1&ndash;2 specifications.
\n=item\n\n@link SBMLErrorCategory_t#LIBSBML_CAT_SBO_CONSISTENCY LIBSBML_CAT_SBO_CONSISTENCY@endlink:
Consistency and validity of SBO identifiers (if any) used in the model.
With respect to the SBML specification, these concern failures in
applying the validation rules numbered 107xx in the Level&nbsp;2
Versions&nbsp;2&ndash;4 and Level&nbsp;3 Versions&nbsp;1&ndash;2 specifications.
\n=item\n\n@link SBMLErrorCategory_t#LIBSBML_CAT_OVERDETERMINED_MODEL LIBSBML_CAT_OVERDETERMINED_MODEL@endlink:
Static analysis of whether the system of equations implied by a model is
mathematically overdetermined.  With respect to the SBML specification,
this is validation rule #10601 in the Level&nbsp;2
Versions&nbsp;2&ndash;4 and Level&nbsp;3 Versions&nbsp;1&ndash;2 specifications.
\n=item\n\n@link SBMLErrorCategory_t#LIBSBML_CAT_MODELING_PRACTICE LIBSBML_CAT_MODELING_PRACTICE@endlink:
Additional checks for recommended good modeling practice. (These are
tests performed by libSBML and do not have equivalent SBML validation
rules.)  \n=back\n
<em>By default, all validation checks are applied</em> to the model in
an SBMLDocument object I<unless>
SBMLDocument::setConsistencyChecks(@if java int categ, boolean onoff@endif)
is called to indicate that only a subset should be applied.  Further,
this default (i.e., performing all checks) applies separately to
<em>each new SBMLDocument object</em> created.  In other words, each
time a model is read using SBMLReader::readSBML(@if java String filename@endif),
SBMLReader::readSBMLFromString(@if java String xml@endif),
or the global functions readSBML() and readSBMLFromString(), a new
SBMLDocument is created and for that document, a call to
SBMLDocument::checkConsistency() will default to applying all possible checks.
Calling programs must invoke
SBMLDocument::setConsistencyChecks(@if java int categ, boolean onoff@endif)
for each such new model if they wish to change the consistency checks
applied.

@param category a value drawn from @if clike #SBMLErrorCategory_t@else
the set of SBML error categories@endif@~ indicating the
consistency checking/validation to be turned on or off.
@param apply a boolean indicating whether the checks indicated by
C<category> should be applied or not.
@see SBMLDocument::checkConsistency()


=item SBMLDocument::setConsistencyChecksForConversion

Controls the consistency checks that are performed when
SBMLDocument::setLevelAndVersion(@if java long, long, boolean@endif) is called.
This method works by adding or subtracting consistency checks from the
set of all possible checks that may be performed to avoid conversion
to or from an invalid document.  This method may need to be called 
multiple times in
order to achieve the desired combination of checks.  The first
argument (C<category>) in a call to this method indicates the category
of consistency/error checks that are to be turned on or off, and the
second argument (C<apply>, a boolean) indicates whether to turn it on
(value of C<true>) or off (value of C<false>).
@if clike
The possible categories (values to the argument C<category>) are the
set of values from the enumeration #SBMLErrorCategory_t.
The following are the possible choices:
@endif@if java
The possible categories (values to the argument C<category>) are the
set of constants whose names begin with the characters C<LIBSBML_CAT_>
in the interface class {@link libsbmlConstants}.
The following are the possible choices:
@endif@if python 
The possible categories (values to the argument C<category>) are the
set of constants whose names begin with the characters C<LIBSBML_CAT_>
in the interface class @link libsbml libsbml@endlink.
The following are the possible choices:
@endif@~
\n=over\n
\n=item\n\n@link SBMLErrorCategory_t#LIBSBML_CAT_GENERAL_CONSISTENCY LIBSBML_CAT_GENERAL_CONSISTENCY@endlink:
Correctness and consistency of specific SBML language constructs.
Performing this set of checks is highly recommended.  With respect to
the SBML specification, these concern failures in applying the
validation rules numbered 2xxxx in the Level&nbsp;2
Versions&nbsp;2&ndash;4 and Level&nbsp;3 Versions&nbsp;1&ndash;2 specifications.
\n=item\n\n@link SBMLErrorCategory_t#LIBSBML_CAT_IDENTIFIER_CONSISTENCY LIBSBML_CAT_IDENTIFIER_CONSISTENCY@endlink:
Correctness and consistency of identifiers used for model entities.  An
example of inconsistency would be using a species identifier in a
reaction rate formula without first having declared the species.  With
respect to the SBML specification, these concern failures in applying
the validation rules numbered 103xx in the Level&nbsp;2
Versions&nbsp;2&ndash;4 and Level&nbsp;3 Versions&nbsp;1&ndash;2 specifications.
\n=item\n\n@link SBMLErrorCategory_t#LIBSBML_CAT_UNITS_CONSISTENCY LIBSBML_CAT_UNITS_CONSISTENCY@endlink:
Consistency of measurement units associated with quantities in a model.
With respect to the SBML specification, these concern failures in
applying the validation rules numbered 105xx in the Level&nbsp;2
Versions&nbsp;2&ndash;4 and Level&nbsp;3 Versions&nbsp;1&ndash;2 specifications.
\n=item\n\n@link SBMLErrorCategory_t#LIBSBML_CAT_MATHML_CONSISTENCY LIBSBML_CAT_MATHML_CONSISTENCY@endlink:
Syntax of MathML constructs.  With respect to the SBML specification,
these concern failures in applying the validation rules numbered 102xx
in the Level&nbsp;2 Versions&nbsp;2&ndash;4 and Level&nbsp;3
Versions&nbsp;1&ndash;2 specifications.
\n=item\n\n@link SBMLErrorCategory_t#LIBSBML_CAT_SBO_CONSISTENCY LIBSBML_CAT_SBO_CONSISTENCY@endlink:
Consistency and validity of SBO identifiers (if any) used in the model.
With respect to the SBML specification, these concern failures in
applying the validation rules numbered 107xx in the Level&nbsp;2
Versions&nbsp;2&ndash;4 and Level&nbsp;3 Versions&nbsp;1&ndash;2 specifications.
\n=item\n\n@link SBMLErrorCategory_t#LIBSBML_CAT_OVERDETERMINED_MODEL LIBSBML_CAT_OVERDETERMINED_MODEL@endlink:
Static analysis of whether the system of equations implied by a model is
mathematically overdetermined.  With respect to the SBML specification,
this is validation rule #10601 in the Level&nbsp;2
Versions&nbsp;2&ndash;4 and Level&nbsp;3 Versions&nbsp;1&ndash;2 specifications.
\n=item\n\n@link SBMLErrorCategory_t#LIBSBML_CAT_MODELING_PRACTICE LIBSBML_CAT_MODELING_PRACTICE@endlink:
Additional checks for recommended good modeling practice. (These are
tests performed by libSBML and do not have equivalent SBML validation
rules.)
\n=back\n
<em>By default, all validation checks are applied</em> to the model in
an SBMLDocument object I<unless>
SBMLDocument::setConsistencyChecks(@if java int, boolean@endif)
is called to indicate that only a subset should be applied.  Further,
this default (i.e., performing all checks) applies separately to
<em>each new SBMLDocument object</em> created.  In other words, each
time a model is read using SBMLReader::readSBML(@if java String@endif),
SBMLReader::readSBMLFromString(@if java String@endif),
or the global functions readSBML() and readSBMLFromString(), a new
SBMLDocument is created and for that document, a call to
SBMLDocument::checkConsistency() will default to applying all possible checks.
Calling programs must invoke
SBMLDocument::setConsistencyChecks(@if java int, boolean@endif)
for each such new model if they wish to change the consistency checks
applied.

@param category a value drawn from @if clike #SBMLErrorCategory_t@else
the set of SBML error categories@endif@~ indicating the consistency
checking/validation to be turned on or off.
@param apply a boolean indicating whether the checks indicated by
C<category> should be applied or not.
@see SBMLDocument::setLevelAndVersion(@if java long, long, boolean@endif)


=item SBMLDocument::checkConsistency

Performs consistency checking and validation on this SBML document.
If this method returns a nonzero value (meaning, one or more
consistency checks have failed for SBML document), the failures may be
due to warnings I<or> errors.  Callers should inspect the severity
flag in the individual SBMLError objects returned by
SBMLDocument::getError(@if java long@endif) to determine the nature of the failures.
@return the number of failed checks (errors) encountered.
@see SBMLDocument::checkInternalConsistency()


=item SBMLDocument::checkConsistencyWithStrictUnits

Performs consistency checking and validation on this SBML document
using the ultra strict units validator that assumes that there
are no hidden numerical conversion factors.
If this method returns a nonzero value (meaning, one or more
consistency checks have failed for SBML document), the failures may be
due to warnings I<or> errors.  Callers should inspect the severity
flag in the individual SBMLError objects returned by
SBMLDocument::getError(@if java long@endif) to determine the nature of the failures.
@return the number of failed checks (errors) encountered.
@see SBMLDocument::checkInternalConsistency()


=item SBMLDocument::validateSBML

Performs consistency checking and validation on this SBML document.
If this method returns a nonzero value (meaning, one or more
consistency checks have failed for SBML document), the failures may be
due to warnings I<or> errors.  Callers should inspect the severity
flag in the individual SBMLError objects returned by
SBMLDocument::getError(@if java long@endif) to determine the nature of the failures.
@note unlike checkConsistency this method will write the document
in order to determine all errors for the document. This will 
also clear the error log. 
@return the number of failed checks (errors) encountered.
@see SBMLDocument::checkConsistency()


=item SBMLDocument::checkInternalConsistency

Performs consistency checking on libSBML's internal representation of 
an SBML Model.
Callers should query the results of the consistency check by calling
SBMLDocument::getError(@if java long@endif).
@return the number of failed checks (errors) encountered.
The distinction between this method and
SBMLDocument::checkConsistency() is that this method reports on
fundamental syntactic and structural errors that violate the XML
Schema for SBML; by contrast, SBMLDocument::checkConsistency()
performs more elaborate model verifications and also validation
according to the validation rules written in the appendices of the
SBML Level&nbsp;2 Versions&nbsp;2&ndash;4 specification documents.
@see SBMLDocument::checkConsistency()


=item SBMLDocument::checkL1Compatibility

Performs a set of consistency checks on the document to establish
whether it is compatible with SBML Level&nbsp;1 and can be converted
to Level&nbsp;1.
Callers should query the results of the consistency check by calling
SBMLDocument::getError(@if java long@endif).
@return the number of failed checks (errors) encountered.


=item SBMLDocument::checkL2v1Compatibility

Performs a set of consistency checks on the document to establish
whether it is compatible with SBML Level&nbsp;2 Version&nbsp;1 and can
be converted to Level&nbsp;2 Version&nbsp;1.
Callers should query the results of the consistency check by calling
SBMLDocument::getError(@if java long@endif).
@return the number of failed checks (errors) encountered.


=item SBMLDocument::checkL2v2Compatibility

Performs a set of consistency checks on the document to establish
whether it is compatible with SBML Level&nbsp;2 Version&nbsp;2 and can
be converted to Level&nbsp;2 Version&nbsp;2.
Callers should query the results of the consistency check by calling
SBMLDocument::getError(@if java long@endif).
@return the number of failed checks (errors) encountered.


=item SBMLDocument::checkL2v3Compatibility

Performs a set of consistency checks on the document to establish
whether it is compatible with SBML Level&nbsp;2 Version&nbsp;3 and can
be converted to Level&nbsp;2 Version&nbsp;3.
Callers should query the results of the consistency check by calling
SBMLDocument::getError(@if java long@endif).
@return the number of failed checks (errors) encountered.


=item SBMLDocument::checkL2v4Compatibility

Performs a set of consistency checks on the document to establish
whether it is compatible with SBML Level&nbsp;2 Version&nbsp;4 and can
be converted to Level&nbsp;2 Version&nbsp;4.
Callers should query the results of the consistency check by calling
SBMLDocument::getError(@if java long@endif).
@return the number of failed checks (errors) encountered.


=item SBMLDocument::checkL2v5Compatibility

Performs a set of consistency checks on the document to establish
whether it is compatible with SBML Level&nbsp;2 Version&nbsp;5 and can
be converted to Level&nbsp;2 Version&nbsp;5.
Callers should query the results of the consistency check by calling
SBMLDocument::getError(@if java long@endif).
@return the number of failed checks (errors) encountered.


=item SBMLDocument::checkL3v1Compatibility

Performs a set of consistency checks on the document to establish
whether it is compatible with SBML Level&nbsp;3 Version&nbsp;1 and can
be converted to Level&nbsp;3 Version&nbsp;1.
Callers should query the results of the consistency check by calling
SBMLDocument::getError(@if java long@endif).
@return the number of failed checks (errors) encountered.


=item SBMLDocument::checkL3v2Compatibility

Performs a set of consistency checks on the document to establish
whether it is compatible with SBML Level&nbsp;3 Version&nbsp;2 and can
be converted to Level&nbsp;3 Version&nbsp;2.
Callers should query the results of the consistency check by calling
SBMLDocument::getError(@if java long@endif).
@return the number of failed checks (errors) encountered.


=item SBMLDocument::getError

Returns the nth error or warning encountered during parsing,
consistency checking, or attempted translation of this model.
Callers can use method XMLError::getSeverity() on the result to assess
the severity of the problem.  The possible severity levels range from
informational messages to fatal errors.
@return the error or warning indexed by integer C<n>, or return @c
NULL if C<n &gt; (getNumErrors() - 1)>.
@param n the integer index of the error sought.
@see SBMLDocument::getNumErrors()


=item SBMLDocument::getErrorWithSeverity

Returns the nth error or warning with the given severity
encountered during parsing, consistency checking, or attempted
translation of this model.
@return the error or warning indexed by integer C<n>, or return @c
NULL if C<n &gt; (getNumErrors(severity) - 1)>.
@param n the integer index of the error sought.
@param severity the severity of the error sought.
@see SBMLDocument::getNumErrors()


=item SBMLDocument::getNumErrors

Returns the number of errors or warnings encountered during parsing,
consistency checking, or attempted translation of this model.
@return the number of errors or warnings encountered.
@see SBMLDocument::getError(unsigned int n)


=item SBMLDocument::getNumErrors

Returns the number of errors or warnings encountered with the given 
severity during parsing,
consistency checking, or attempted translation of this model.
@param severity the severity of the error sought.
@return the number of errors or warnings encountered.
@see SBMLDocument::getError(unsigned int n)


=item SBMLDocument::printErrors

Prints all the errors or warnings encountered trying to parse,
check, or translate this SBML document.
It prints the text to the stream given by the optional parameter @p
stream.  If no parameter is given, it prints the output to the
standard error stream.
If no errors have occurred, i.e., C<getNumErrors() == 0>, no
output will be sent to the stream.
The format of the output is:
@verbatim
N error(s):
line NNN: (id) message
@endverbatim

@param stream the ostream or ostringstream object indicating where
the output should be printed.
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~
@see getNumErrors()
@see getErrorLog()
@see SBMLDocument::getError(unsigned int n)


=item SBMLDocument::printErrors

Prints all the errors or warnings with the given severity encountered 
trying to parse, check, or translate this SBML document.
It prints the text to the stream given by the parameter @p
stream.  

If no errors have occurred, i.e., C<getNumErrors(severity) == 0>, no
output will be sent to the stream.
The format of the output is:
@verbatim
N error(s):
line NNN: (id) message
@endverbatim
@param stream the ostream or ostringstream object indicating where
the output should be printed.
@param severity of the errors sought.
@see getNumErrors(unsigned int severity)
@see getErrorLog()
@see SBMLDocument::getErrorWithSeverity(unsigned int n, unsigned int severity)


=item SBMLDocument::setSBMLDocument

@internal


=item SBMLDocument::convert

Converts this document using the converter that best matches
the given conversion properties. 
@param props the conversion properties to use.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@li @link OperationReturnValues_t#LIBSBML_CONV_CONVERSION_NOT_AVAILABLE LIBSBML_CONV_CONVERSION_NOT_AVAILABLE@endlink


=item SBMLDocument::enablePackageInternal

@internal


=item SBMLDocument::getTypeCode

Returns the libSBML type code for this SBML object.
C<opydetails> doc_what_are_typecodes
@return the SBML type code for this object:
@link SBMLTypeCode_t#SBML_DOCUMENT SBML_DOCUMENT@endlink (default).
C<opydetails> doc_warning_typecodes_not_unique
@see SBMLDocument::getElementName()
@see getPackageName()


=item SBMLDocument::getElementName

Returns the XML element name of this object, which for SBMLDocument,
is always C<"sbml">.
@return the name of this element, i.e., C<"sbml">.


=item SBMLDocument::getErrorLog

Returns the list of errors or warnings logged during parsing, 
consistency checking, or attempted translation of this model.
@return the SBMLErrorLog used for this SBMLDocument.
@see SBMLDocument::getNumErrors()


=item SBMLDocument::getErrorLog

Returns a constant pointer to the list of errors or warnings 
logged during parsing, consistency checking, or attempted translation 
of this model.
@return the SBMLErrorLog used for this SBMLDocument.
@see SBMLDocument::getNumErrors()


=item SBMLDocument::getNamespaces

Returns a list of XML Namespaces associated with the XML content
of this SBML document.
@return the XML Namespaces associated with this SBML object.


=item SBMLDocument::enableDefaultNS

Set/unset default namespace to each top-level element defined in the
given package extension.
This works by adding a C<xmlns=&quot;...&quot;> attribute.  No
prefix will be written when writing elements defined in the given
package extension if C<true> is given as second argument.
@param package the name or URI of the package extension.
@param flag boolean value to indicate whether to write a namespace
prefix.

C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_PKG_UNKNOWN_VERSION LIBSBML_PKG_UNKNOWN_VERSION@endlink


=item SBMLDocument::isEnabledDefaultNS

Returns C<true> if a default namespace is added to each top-level
element defined in the given package extension, otherwise returns
C<false>.
This basically checks if the attribute
C<xmlns=&quot;...&quot;> is present.
@param package the name or URI of the package extension.
@return a boolean indicating whether the given package's default namespace is enabled.


=item SBMLDocument::setPackageRequired

Sets the C<required> attribute value of the given package
extension.

@note The name of package must not be given if the package is not
enabled.

@param package the name or URI of the package extension.
@param flag Boolean value indicating whether the package is required.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_PKG_UNKNOWN_VERSION LIBSBML_PKG_UNKNOWN_VERSION@endlink


=item SBMLDocument::getPackageRequired

Returns the C<required> attribute of the given package
extension.

@note The name of package must not be given if the package is not
enabled.

@param package the name or URI of the package extension.
@return Boolean flag indicating whether the package is flagged as
being required.


=item SBMLDocument::isSetPackageRequired

Returns C<true> if the required attribute of the given package extension
is defined, otherwise returns C<false>.
@note The name of package must not be given if the package is not
enabled.

@param package the name or URI of the package extension.
@return a Boolean indicating whether the package's 'required' flag is set.


=item SBMLDocument::isIgnoredPackage

Returns C<true> if the given package extension is one of an ignored
packages, otherwise returns C<false>.
An ignored package is one that is defined to be used in this SBML
document, but the package is not enabled in this copy of libSBML.
@param pkgURI the URI of the package extension.
@return a Boolean, C<true> if the package is being ignored and
C<false> otherwise.


=item SBMLDocument::isDisabledIgnoredPackage

Returns C<true> if the given package extension is one of an ignored
packages that has been disabled, otherwise returns C<false>.
An ignored package is one that is defined to be used in this SBML
document, but the package is not enabled in this copy of libSBML.
It may have been disabled to avoid reproducing the package
information when writing out the file.
@param pkgURI the URI of the package extension.
@return a Boolean, C<true> if the package is being ignored and
C<false> otherwise.


=item SBMLDocument::setPkgRequired

Sets the value of the C<required> attribute for the given
package.

@note The name of package must not be given if the package is not
enabled.

@param package the name or URI of the package extension.
@param flag a Boolean value.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_PKG_UNKNOWN_VERSION LIBSBML_PKG_UNKNOWN_VERSION@endlink
@deprecated Replaced in libSBML 5.2.0 by
setPackageRequired(@if java String, boolean@endif)


=item SBMLDocument::getPkgRequired

Returns the C<required> attribute of the given package
extension.

@note The name of package must not be given if the package is not
enabled.

@param package the name or URI of the package extension.
@return a Boolean value indicating whether the package is flagged as
being required in this SBML document.
@deprecated Replaced in libSBML 5.2.0 by
getPackageRequired(@if java String@endif)


=item SBMLDocument::isSetPkgRequired

Returns C<true> if the required attribute of the given package extension
is defined, otherwise returns C<false>.
@note The name of package must not be given if the package is not
enabled.

@param package the name or URI of the package extension.
@return a Boolean value.
@deprecated Replaced in libSBML 5.2.0 by
isSetPackageRequired(@if java String@endif)


=item SBMLDocument::isIgnoredPkg

Returns C<true> if the given package extension is one of ignored
packages, otherwise returns C<false>.
An ignored package is one that is defined to be used in this SBML
document, but the package is not enabled in this copy of libSBML.
@param pkgURI the URI of the package extension.
@return a boolean indicating whether the given package is being ignored.
@deprecated Replaced in libSBML 5.2.0 by
isIgnoredPackage(@if java String@endif)


=item SBMLDocument::getElementPosition

@internal


=item SBMLDocument::writeElements

@internal


=item SBMLDocument::getApplicableValidators

@internal


=item SBMLDocument::getConversionValidators

@internal


=item SBMLDocument::setApplicableValidators

@internal


=item SBMLDocument::setConversionValidators

@internal


=item SBMLDocument::getNumValidators

@internal


=item SBMLDocument::clearValidators

@internal


=item SBMLDocument::addValidator

@internal


=item SBMLDocument::getValidator

@internal


=item SBMLDocument::addUnknownPackageRequired

@internal


=item SBMLDocument::hasUnknownPackage

@internal


=item SBMLDocument::getNumUnknownPackages

@internal


=item SBMLDocument::getUnknownPackageURI

@internal


=item SBMLDocument::getUnknownPackagePrefix

@internal


=item SBMLDocument::createObject

@internal


=item SBMLDocument::addExpectedAttributes

@internal


=item SBMLDocument::readAttributes

@internal


=item SBMLDocument::writeAttributes

@internal


=item SBMLDocument::writeXMLNS

@internal


=item SBMLDocument::setInvalidLevel

@internal


=back

=head2 FunctionDefinition

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html A user-defined function in an SBML model.
The FunctionDefinition structure associates an identifier with a
function definition.  This identifier can then be used as the function
called in subsequent MathML content elsewhere in an SBML model.
FunctionDefinition has one required attribute, "id", to give the
function a unique identifier by which other parts of an SBML model
definition can refer to it.  A FunctionDefinition instance can also have
an optional "name" attribute of type C<string>.  Identifiers and names
must be used according to the guidelines described in the SBML
specification (e.g., Section 3.3 in the Level 2 Version 4
specification).

FunctionDefinition has a "math" subelement containing a MathML
expression defining the function body.  In SBML Level&nbsp;2 and SBML
Level&nbsp;3 Version&nbsp;1, that "math" subelement is required;
in SBML Level&nbsp;3 Version&nbsp;2, this restriction was relaxed,
making the "math" subelement optional.  The content of this element can
only be a MathML "lambda" element.  The "lambda" element must begin with
zero or more "bvar" elements, followed by any other of the elements in
the MathML subset allowed in SBML Level 2 I<except> "lambda" (i.e., a
"lambda" element cannot contain another "lambda" element).  This is the
only place in SBML where a "lambda" element can be used.  The function
defined by a FunctionDefinition is only available for use in other
MathML elements that I<follow> the FunctionDefinition definition in the
model.  (These restrictions prevent recursive and mutually-recursive
functions from being expressed.)
A further restriction on the content of "math" is that it cannot contain
references to variables other than the variables declared to the
"lambda" itself.  That is, the contents of MathML "ci" elements inside
the body of the "lambda" can only be the variables declared by its
"bvar" elements, or the identifiers of other FunctionDefinition
instances in the model.  This means must be written so that all
variables or parameters used in the MathML content are passed to them
via their function parameters.  In SBML Level&nbsp;2, this restriction
applies also to the MathML C<csymbol> elements for I<time> and @em
delay; in SBML Level&nbsp;3, it additionally applies to the C<csymbol>
element for I<avogadro>.
In SBML Level&nbsp;3 Version&nbsp;2, if no math element is present in 
the FunctionDefinition, the function has no mathematical meaning 
defined in SBML Level&nbsp;3 Core. This situation may arise when models 
are incomplete, or when additional meanings are provided by an SBML 
Level&nbsp;3 package.
@note Function definitions (also informally known as user-defined
functions) were introduced in SBML Level 2.  They have purposefully
limited capabilities.  A function cannot reference parameters or other
model quantities outside of itself; values must be passed as parameters
to the function.  Moreover, recursive and mutually-recursive functions
are not permitted.  The purpose of these limitations is to balance power
against complexity of implementation.  With the restrictions as they
are, function definitions could be implemented as textual
substitutions---they are simply macros.  Software implementations
therefore do not need the full function-definition machinery typically
associated with programming languages.
<br><br>
Another important point to note is FunctionDefinition does not
have a separate attribute for defining the units of the value returned
by the function.  The units associated with the function's return value,
when the function is called from within MathML expressions elsewhere in
SBML, are simply the overall units of the expression in
FunctionDefinition's "math" subelement when applied to the arguments
supplied in the call to the function.  Ascertaining these units requires
performing dimensional analysis on the expression.  (Readers may wonder
why there is no attribute.  The reason is that having a separate
attribute for declaring the units would not only be redundant, but also
lead to the potential for having conflicting information.  In the case
of a conflict between the declared units and those of the value actually
returned by the function, the only logical resolution rule would be to
assume that the correct units are those of the expression anyway.)

=over


=back

=head2 ListOfFunctionDefinitions

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html A list of FunctionDefinition objects.
C<opydetails> doc_what_is_listof

=over


=item FunctionDefinition::FunctionDefinition

Creates a new FunctionDefinition using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this FunctionDefinition.
@param version an unsigned int, the SBML Version to assign to this
FunctionDefinition.

C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item FunctionDefinition::FunctionDefinition

Creates a new FunctionDefinition using the given SBMLNamespaces object
C<sbmlns>.
C<opydetails> doc_what_are_sbmlnamespaces 
@param sbmlns an SBMLNamespaces object.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item FunctionDefinition::FunctionDefinition

Copy constructor; creates a copy of this FunctionDefinition.
@param orig the object to copy.


=item FunctionDefinition::accept

@internal


=item FunctionDefinition::clone

Creates and returns a deep copy of this FunctionDefinition object.
@return the (deep) copy of this FunctionDefinition object.


=item FunctionDefinition::getId

Returns the value of the "id" attribute of this FunctionDefinition.
@note Because of the inconsistent behavior of this function with 
respect to assignments and rules, it is now recommended to
use the getIdAttribute() function instead.
C<opydetails> doc_id_attribute
@return the id of this FunctionDefinition.
@see getIdAttribute()
@see setIdAttribute(const std::string& sid)
@see isSetIdAttribute()
@see unsetIdAttribute()


=item FunctionDefinition::getName

Returns the value of the "name" attribute of this FunctionDefinition object.
C<opydetails> doc_get_name


=item FunctionDefinition::getMath

Get the mathematical formula of this FunctionDefinition.
@return an ASTNode, the value of the "math" subelement of this
FunctionDefinition, or C<NULL> if the math is not set.


=item FunctionDefinition::isSetId

Predicate returning C<true> if this
FunctionDefinition's "id" attribute is set.
C<opydetails> doc_isset_id


=item FunctionDefinition::isSetName

Predicate returning C<true> if this
FunctionDefinition's "name" attribute is set.
C<opydetails> doc_isset_name


=item FunctionDefinition::isSetMath

Predicate returning C<true> if this
FunctionDefinition's "math" subelement contains a value.
@return C<true> if the "math" for this FunctionDefinition is set,
C<false> otherwise.


=item FunctionDefinition::setId

Sets the value of the "id" attribute of this FunctionDefinition.
C<opydetails> doc_set_id


=item FunctionDefinition::setName

Sets the value of the "name" attribute of this FunctionDefinition.
C<opydetails> doc_set_name


=item FunctionDefinition::setMath

Sets the "math" subelement of this FunctionDefinition to the Abstract
Syntax Tree given in C<math>.
@param math an AST containing the mathematical expression to
be used as the formula for this FunctionDefinition.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink


=item FunctionDefinition::unsetName

Unsets the value of the "name" attribute of this FunctionDefinition.
C<opydetails> doc_unset_name


=item FunctionDefinition::getArgument

Get the C<n>th argument to this function.
Callers should first find out the number of arguments to the function
by calling getNumArguments().
@param n an integer index for the argument sought.
@return the nth argument (bound variable) passed to this
FunctionDefinition.

@see getNumArguments()


=item FunctionDefinition::getArgument

Get the argument named C<name> to this FunctionDefinition.
@param name the exact name (case-sensitive) of the sought-after
argument.

@return the argument (bound variable) having the given name, or C<NULL> if
no such argument exists.


=item FunctionDefinition::getBody

Get the mathematical expression that is the body of this
FunctionDefinition object.
@return the body of this FunctionDefinition as an Abstract Syntax
Tree, or C<NULL> if no body is defined.


=item FunctionDefinition::getBody

Get the mathematical expression that is the body of this
FunctionDefinition object.
@return the body of this FunctionDefinition as an Abstract Syntax
Tree, or C<NULL> if no body is defined.


=item FunctionDefinition::isSetBody

Predicate returning C<true> if the body of this
FunctionDefinition has set.
@return C<true> if the body of this FunctionDefinition is 
set, C<false> otherwise.


=item FunctionDefinition::getNumArguments

Get the number of arguments (bound variables) taken by this
FunctionDefinition.

@return the number of arguments (bound variables) that must be passed
to this FunctionDefinition.


=item FunctionDefinition::getTypeCode

Returns the libSBML type code for this SBML object.
C<opydetails> doc_what_are_typecodes
@return the SBML type code for this object:
@link SBMLTypeCode_t#SBML_FUNCTION_DEFINITION SBML_FUNCTION_DEFINITION@endlink (default).
C<opydetails> doc_warning_typecodes_not_unique
@see getElementName()
@see getPackageName()


=item FunctionDefinition::getElementName

Returns the XML element name of this object, which for
FunctionDefinition, is always C<"functionDefinition">.
@return the name of this element, i.e., C<"functionDefinition">.


=item FunctionDefinition::writeElements

@internal


=item FunctionDefinition::hasRequiredAttributes

Predicate returning C<true> if
all the required attributes for this FunctionDefinition object
have been set.
The required attributes for a FunctionDefinition object are:
@li "id"
@return C<true> if the required attributes have been set, C<false>
otherwise.


=item FunctionDefinition::hasRequiredElements

Predicate returning C<true> if
all the required elements for this FunctionDefinition object
have been set.
@note The required elements for a FunctionDefinition object are:
@li "math" inSBML Level&nbsp;2 and Level&nbsp;3 Version&nbsp;1.  
(In SBML Level&nbsp;3 Version&nbsp;2+, it is no longer required.)
@return a boolean value indicating whether all the required
elements for this object have been defined.


=item FunctionDefinition::renameUnitSIdRefs

Renames all the C<UnitSIdRef> attributes on this element.
C<opydetails> doc_what_is_unitsidref
This method works by looking at all unit identifier attribute values
(including, if appropriate, inside mathematical formulas), comparing the
unit identifiers to the value of C<oldid>.  If any matches are found,
the matching identifiers are replaced with C<newid>.  The method does
I<not> descend into child elements.
@param oldid the old identifier.
@param newid the new identifier.


=item FunctionDefinition::readOtherXML

@internal


=item FunctionDefinition::addExpectedAttributes

@internal


=item FunctionDefinition::readAttributes

@internal


=item FunctionDefinition::readL2Attributes

@internal


=item FunctionDefinition::readL3Attributes

@internal


=item FunctionDefinition::writeAttributes

@internal


=item ListOfFunctionDefinitions::ListOfFunctionDefinitions

Creates a new ListOfFunctionDefinitions object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level.
@param version the Version within the SBML Level.
C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item ListOfFunctionDefinitions::ListOfFunctionDefinitions

Creates a new ListOfFunctionDefinitions object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfFunctionDefinitions object to be created.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item ListOfFunctionDefinitions::clone

Creates and returns a deep copy of this ListOfFunctionDefinitions object.
@return the (deep) copy of this ListOfFunctionDefinitions object.


=item ListOfFunctionDefinitions::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., FunctionDefinition objects, if the list is non-empty).
C<opydetails> doc_what_are_typecodes
@return the SBML type code for the objects contained in this ListOf:
@link SBMLTypeCode_t#SBML_FUNCTION_DEFINITION SBML_FUNCTION_DEFINITION@endlink (default).
@see getElementName()
@see getPackageName()


=item ListOfFunctionDefinitions::getElementName

Returns the XML element name of this object.
For ListOfFunctionDefinitions, the XML element name is @c
"listOfFunctionDefinitions".

@return the name of this element, i.e., C<"listOfFunctionDefinitions">.


=item ListOfFunctionDefinitions::get

Get a FunctionDefinition from the ListOfFunctionDefinitions.
@param n the index number of the FunctionDefinition to get.
@return the nth FunctionDefinition in this ListOfFunctionDefinitions.
@see size()


=item ListOfFunctionDefinitions::get

Get a FunctionDefinition from the ListOfFunctionDefinitions.
@param n the index number of the FunctionDefinition to get.
@return the nth FunctionDefinition in this ListOfFunctionDefinitions.
@see size()


=item ListOfFunctionDefinitions::get

Get a FunctionDefinition from the ListOfFunctionDefinitions
based on its identifier.
@param sid a string representing the identifier 
of the FunctionDefinition to get.
@return FunctionDefinition in this ListOfFunctionDefinitions
with the given C<sid> or C<NULL> if no such
FunctionDefinition exists.
@see get(unsigned int n)
@see size()


=item ListOfFunctionDefinitions::get

Get a FunctionDefinition from the ListOfFunctionDefinitions
based on its identifier.
@param sid a string representing the identifier 
of the FunctionDefinition to get.
@return FunctionDefinition in this ListOfFunctionDefinitions
with the given C<sid> or C<NULL> if no such
FunctionDefinition exists.
@see get(unsigned int n)
@see size()


=item ListOfFunctionDefinitions::remove

Removes the nth item from this ListOfFunctionDefinitions items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove.
@see size()


=item ListOfFunctionDefinitions::remove

Removes item in this ListOfFunctionDefinitions items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove.
@return the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfFunctionDefinitions::getElementPosition

@internal


=item ListOfFunctionDefinitions::createObject

@internal


=item UnitKind_equals

Tests for logical equality between two given C<UNIT_KIND_>
code values.
This function behaves exactly like C's C<==> operator, except
for the following two cases:
\n=over\n
<li>@link UnitKind_t#UNIT_KIND_LITER UNIT_KIND_LITER@endlink C<==> @link UnitKind_t#UNIT_KIND_LITRE UNIT_KIND_LITRE@endlink
<li>@link UnitKind_t#UNIT_KIND_METER UNIT_KIND_METER@endlink C<==> @link UnitKind_t#UNIT_KIND_METRE UNIT_KIND_METRE@endlink
\n=back\n

In the two cases above, C equality comparison would yield C<false>
(because each of the above is a distinct enumeration value), but
this function returns C<true>.
@param uk1 a C<UNIT_KIND_> value.
@param uk2 a second C<UNIT_KIND_> value to compare to C<uk1>.
@return nonzero (for C<true>) if C<uk1> is logically equivalent to @p
uk2, zero (for C<false>) otherwise.
@note For more information about the libSBML unit codes, please refer to
the class documentation for Unit.
@if conly
@memberof Unit_t
@endif


=item UnitKind_forName

Converts a text string naming a kind of unit to its corresponding
libSBML C<UNIT_KIND_> constant/enumeration value.
@param name a string, the name of a predefined base unit in SBML.
@return @if clike a value from UnitKind_t corresponding to the given
string C<name> (determined in a case-insensitive manner).
@endif@if python a value the set of C<UNIT_KIND_> codes
defined in class @link libsbml libsbml@endlink, corresponding to the
string C<name> (determined in a case-insensitive
manner).@endif@if java a value the set of C<UNIT_KIND_> codes
defined in class {@link libsbmlConstants}, corresponding to the string
C<name> (determined in a case-insensitive manner).@endif@~
@note For more information about the libSBML unit codes, please refer to
the class documentation for Unit.
@if conly
@memberof Unit_t
@endif


=item UnitKind_toString

Converts a unit code to a text string equivalent.
@param uk @if clike a value from the UnitKind_t enumeration
@endif@if python a value from the set of C<UNIT_KIND_> codes
defined in the class @link libsbml libsbml@endlink
@endif@if java a value from the set of C<UNIT_KIND_> codes
defined in the class {@link libsbmlConstants}
@endif@~

@return the name corresponding to the given unit code.
@note For more information about the libSBML unit codes, please refer to
the class documentation for Unit.
@warning The string returned is a static data value.  The caller does not
own the returned string and is therefore not allowed to modify it.
@if conly
@memberof Unit_t
@endif


=item UnitKind_isValidUnitKindString

Predicate for testing whether a given string corresponds to a
predefined libSBML unit code.
@param str a text string naming a base unit defined by SBML.
@param level the Level of SBML.
@param version the Version within the Level of SBML.
@return nonzero (for C<true>) if string is the name of a valid
C<UNIT_KIND_> value, zero (for C<false>) otherwise.
@note For more information about the libSBML unit codes, please refer to
the class documentation for Unit.
@if conly
@memberof Unit_t
@endif


=back

=head2 Unit

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html A single unit referenced in an SBML <em>unit definition</em>.
The SBML unit definition facility uses two classes of objects,
UnitDefinition and Unit.  The approach to defining units in SBML is
compositional; for example, <em>meter second<sup> &ndash;2</sup></em> is
constructed by combining a Unit object representing <em>meter</em> with
another Unit object representing <em>second<sup> &ndash;2</sup></em>.
The combination is wrapped inside a UnitDefinition, which provides for
assigning an identifier and optional name to the combination.  The
identifier can then be referenced from elsewhere in a model.  Thus, the
UnitDefinition class is the container, and Unit instances are placed
inside UnitDefinition instances.
A Unit has four attributes named "kind", "exponent", "scale"
and "multiplier".  It represents a (possibly transformed) reference to a
base unit.  The attribute "kind" on Unit indicates the chosen base unit.
Its value must be one of the text strings listed below; this list
corresponds to SBML Level&nbsp;3:
C<opydetails> doc_base_units
A few small differences exist between the Level&nbsp;3 list of base
units and the list defined in other Level/Version combinations of SBML.
Specifically, Levels of SBML before Level&nbsp;3 do not define @c
avogadro; conversely, Level&nbsp;2 Version&nbsp;1 defines C<Celsius>,
and Level&nbsp;1 defines C<celsius>, C<meter>, and C<liter>, none of
which are available in Level&nbsp;3.  In libSBML, each of the predefined
base unit names is represented by an enumeration value @if clike in
#UnitKind_t@else whose name begins with the characters
C<UNIT_KIND_>@endif, discussed in a separate section below.
The attribute named "exponent" on Unit represents an exponent on the
unit.  In SBML Level&nbsp;2, the attribute is optional and has a default
value of C<1> (one); in SBML Level&nbsp;3, the attribute is mandatory
and there is no default value.  A Unit also has an attribute
called "scale"; its value must be an integer exponent for a power-of-ten
multiplier used to set the scale of the unit.  For example, a unit
having a "kind" value of C<gram> and a "scale" value of C<-3> signifies
10<sup>&nbsp;&ndash;3</sup> \f$\times\f$ gram, or milligrams.  In SBML
Level&nbsp;2, the attribute is optional and has a default value of C<0>
(zero), because 10<sup> 0</sup> = 1; in SBML Level&nbsp;3, the attribute
is mandatory and has no default value.  Lastly, the attribute named
"multiplier" can be used to multiply the unit by a real-numbered factor;
this enables the definition of units that are not power-of-ten multiples
of SI units.  For instance, a multiplier of 0.3048 could be used to
define C<foot> as a measure of length in terms of a C<metre>.  The
"multiplier" attribute is optional in SBML Level&nbsp;2, where it has a
default value of C<1> (one); in SBML Level&nbsp;3, the attribute is
mandatory and has not default value.
@if clike
<h3><a class="anchor" name="UnitKind_t">UnitKind_t</a></h3>
@else
<h3><a class="anchor" name="UnitKind_t">Unit identification codes</a></h3>
@endif@~

As discussed above, SBML defines a set of base units which serves as the
starting point for new unit definitions.  This set of base units
consists of the SI units and a small number of additional convenience
units.

@if clike Until SBML Level&nbsp;2 Version&nbsp;3, there
existed a data type in the SBML specifications called C<UnitKind>,
enumerating the possible SBML base units.  Although SBML Level&nbsp;2
Version&nbsp;3 removed this type from the language specification,
libSBML maintains the corresponding enumeration type #UnitKind_t as a
convenience and as a way to provide backward compatibility to previous
SBML Level/Version specifications.  (The removal in SBML Level&nbsp;2
Version&nbsp;3 of the enumeration C<UnitKind> was also accompanied by
the redefinition of the data type C<UnitSId> to include the previous @c
UnitKind values as reserved symbols in the C<UnitSId> space.  This
change has no net effect on permissible models, their representation or
their syntax.  The purpose of the change in the SBML specification was
simply to clean up an inconsistency about the contexts in which these
values were usable.)
@endif@if java In SBML Level&nbsp;2 Versions before
Version&nbsp;3, there existed an enumeration of units called @c
UnitKind.  In Version&nbsp;3, this enumeration was removed and the
identifier class C<UnitSId> redefined to include the previous @c
UnitKind values as reserved symbols.  This change has no net effect on
permissible models, their representation or their syntax.  The purpose
of the change in the SBML specification was simply to clean up an
inconsistency about the contexts in which these values were usable.
However, libSBML maintains UnitKind in the form of of a set of static
integer constants whose names begin with the characters
C<UNIT_KIND_>.  These constants are defined in the class
<code><a href="libsbmlConstants.html">libsbmlConstants</a></code>.
@endif@if python In SBML Level&nbsp;2 Versions before
Version&nbsp;3, there existed an enumeration of units called @c
UnitKind.  In Version&nbsp;3, this enumeration was removed and the
identifier class C<UnitSId> redefined to include the previous @c
UnitKind values as reserved symbols.  This change has no net effect on
permissible models, their representation or their syntax.  The purpose
of the change in the SBML specification was simply to clean up an
inconsistency about the contexts in which these values were usable.
However, libSBML maintains UnitKind in the form of of a set of static
integer constants whose names begin with the characters
C<UNIT_KIND_>.  These constants are defined in the class
@link libsbml libsbml@endlink.
@endif@~

As a consequence of the fact that libSBML supports models in all Levels
and Versions of SBML, libSBML's set of C<UNIT_KIND_> values is a union
of all the possible base unit names defined in the different SBML
specifications.  However, not every base unit is allowed in every
Level+Version combination of SBML.  Note in particular the following
exceptions:
\n=over\n
\n=item\n\nThe alternate spelling C<"meter"> is included in
addition to the official SI spelling C<"metre">.  This spelling is only
permitted in SBML Level&nbsp;1 models.
\n=item\n\nThe alternate spelling C<"liter"> is included in addition to the
official SI spelling C<"litre">.  This spelling is only permitted in
SBML Level&nbsp;1 models.
\n=item\n\nThe unit C<"Celsius"> is included because of its presence in
specifications of SBML prior to SBML Level&nbsp;2 Version&nbsp;3.
\n=item\n\nThe unit C<avogadro> was introduced in SBML Level&nbsp;3, and
is only permitted for use in SBML Level&nbsp;3 models.
\n=back\n

@if clike The table below lists the symbols defined in the
C<UnitKind_t> enumeration, and their
meanings. @else The table below lists the unit
constants defined in libSBML, and their meanings. @endif@~
@htmlinclude unitkind-table.html

=over


=back

=head2 ListOfUnits

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html A list of Unit objects.
ListOfUnits is entirely contained within UnitDefinition.
C<opydetails> doc_what_is_listof

=over


=item Unit::Unit

Creates a new Unit using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this Unit.
@param version an unsigned int, the SBML Version to assign to this
Unit.

C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item Unit::Unit

Creates a new Unit using the given SBMLNamespaces object
C<sbmlns>.
C<opydetails> doc_what_are_sbmlnamespaces
@param sbmlns an SBMLNamespaces object.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item Unit::Unit

Copy constructor; creates a copy of this Unit.
@param orig the object to copy.


=item Unit::accept

@internal


=item Unit::clone

Creates and returns a deep copy of this Unit object.
@return the (deep) copy of this Unit object.


=item Unit::initDefaults

Initializes the fields of this Unit object to "typical" default
values.

The SBML Unit component has slightly different aspects and default
attribute values in different SBML Levels and Versions.  This method
sets the values to certain common defaults, based mostly on what they
are in SBML Level&nbsp;2.  Specifically:
\n=over\n
\n=item\n\nSets attribute "exponent" to C<1>
\n=item\n\nSets attribute "scale" to C<0>
\n=item\n\nSets attribute "multiplier" to C<1>.0
\n=back\n

The "kind" attribute is left unchanged.


=item Unit::getKind

Returns the "kind" of Unit this is.
@if clike
@return the value of the "kind" attribute of this Unit as a
value from the <a class="el" href="#UnitKind_t">UnitKind_t</a> enumeration.
@endif@if java
@return the value of the "kind" attribute of this Unit as a
value from the set of constants whose names begin
with C<UNIT_KIND_> defined in the class
<code><a href="libsbmlConstants.html">libsbmlConstants</a></code>.
@endif@if python
@return the value of the "kind" attribute of this Unit as a
value from the set of constants whose names begin
with C<UNIT_KIND_> defined in the class
@link libsbml libsbml@endlink.
@endif@~


=item Unit::getExponent

Returns the value of the "exponent" attribute of this unit.
@return the "exponent" value of this Unit, as an integer.


=item Unit::getExponentAsDouble

Returns the value of the "exponent" attribute of this unit.
@return the "exponent" value of this Unit, as a double.


=item Unit::getScale

Returns the value of the "scale" attribute of this unit.
@return the "scale" value of this Unit, as an integer.


=item Unit::getMultiplier

Returns the value of the "multiplier" attribute of this Unit.
@return the "multiplier" value of this Unit, as a double.


=item Unit::getOffset

Returns the value of the "offset" attribute of this Unit.
@return the "offset" value of this Unit, as a double.
C<opydetails> doc_warning_unit_offset_only_l2v1


=item Unit::isAmpere

Predicate for testing whether this Unit is of the kind C<ampere>.
@return C<true> if the kind of this Unit is C<ampere>, C<false>
otherwise.


=item Unit::isAvogadro

Predicate for testing whether this Unit is of the kind C<avogadro>.
@return C<true> if the kind of this Unit is C<avogadro>, C<false>
otherwise.

@note The unit C<avogadro> was introduced in SBML Level&nbsp;3, and
is only permitted for use in SBML Level&nbsp;3 models.


=item Unit::isBecquerel

Predicate for testing whether this Unit is of the kind C<becquerel>
@return C<true> if the kind of this Unit is C<becquerel>, C<false>
otherwise.


=item Unit::isCandela

Predicate for testing whether this Unit is of the kind C<candela>
@return C<true> if the kind of this Unit is C<candela>, C<false>
otherwise.


=item Unit::isCelsius

Predicate for testing whether this Unit is of the kind C<Celsius>
@return C<true> if the kind of this Unit is C<Celsius>, C<false>
otherwise. 

@warning <span class="warning">The predefined unit C<Celsius> was
removed from the list of predefined units in SBML Level&nbsp;2
Version&nbsp;2 at the same time that the "offset" attribute was removed
from Unit definitions.  LibSBML methods such as this one related to @c
Celsius are retained in order to support SBML Level&nbsp;2
Version&nbsp;1, but their use is strongly discouraged.</span>


=item Unit::isCoulomb

Predicate for testing whether this Unit is of the kind C<coulomb>
@return C<true> if the kind of this Unit is C<coulomb>, C<false>
otherwise.


=item Unit::isDimensionless

Predicate for testing whether this Unit is of the kind @c
dimensionless.

@return C<true> if the kind of this Unit is C<dimensionless>, C<false>
otherwise.


=item Unit::isFarad

Predicate for testing whether this Unit is of the kind C<farad>
@return C<true> if the kind of this Unit is C<farad>, C<false>
otherwise.


=item Unit::isGram

Predicate for testing whether this Unit is of the kind C<gram>
@return C<true> if the kind of this Unit is C<gram>, C<false>
otherwise.


=item Unit::isGray

Predicate for testing whether this Unit is of the kind C<gray>
@return C<true> if the kind of this Unit is C<gray>, C<false>
otherwise.


=item Unit::isHenry

Predicate for testing whether this Unit is of the kind C<henry>
@return C<true> if the kind of this Unit is C<henry>, C<false>
otherwise.


=item Unit::isHertz

Predicate for testing whether this Unit is of the kind C<hertz>
@return C<true> if the kind of this Unit is C<hertz>, C<false>
otherwise.


=item Unit::isItem

Predicate for testing whether this Unit is of the kind C<item>
@return C<true> if the kind of this Unit is C<item>, C<false>
otherwise.


=item Unit::isJoule

Predicate for testing whether this Unit is of the kind C<joule>
@return C<true> if the kind of this Unit is C<joule>, C<false>
otherwise.


=item Unit::isKatal

Predicate for testing whether this Unit is of the kind C<katal>
@return C<true> if the kind of this Unit is C<katal>, C<false>
otherwise.


=item Unit::isKelvin

Predicate for testing whether this Unit is of the kind C<kelvin>
@return C<true> if the kind of this Unit is C<kelvin>, C<false>
otherwise.


=item Unit::isKilogram

Predicate for testing whether this Unit is of the kind C<kilogram>
@return C<true> if the kind of this Unit is C<kilogram>, C<false>
otherwise.


=item Unit::isLitre

Predicate for testing whether this Unit is of the kind C<litre>
@return C<true> if the kind of this Unit is C<litre> or 'liter', @c
false 
otherwise.


=item Unit::isLumen

Predicate for testing whether this Unit is of the kind C<lumen>
@return C<true> if the kind of this Unit is C<lumen>, C<false>
otherwise.


=item Unit::isLux

Predicate for testing whether this Unit is of the kind C<lux>
@return C<true> if the kind of this Unit is C<lux>, C<false>
otherwise.


=item Unit::isMetre

Predicate for testing whether this Unit is of the kind C<metre>
@return C<true> if the kind of this Unit is C<metre> or 'meter', @c
false 
otherwise.


=item Unit::isMole

Predicate for testing whether this Unit is of the kind C<mole>
@return C<true> if the kind of this Unit is C<mole>, C<false>
otherwise.


=item Unit::isNewton

Predicate for testing whether this Unit is of the kind C<newton>
@return C<true> if the kind of this Unit is C<newton>, C<false>
otherwise.


=item Unit::isOhm

Predicate for testing whether this Unit is of the kind C<ohm>
@return C<true> if the kind of this Unit is C<ohm>, C<false>
otherwise.


=item Unit::isPascal

Predicate for testing whether this Unit is of the kind C<pascal>
@return C<true> if the kind of this Unit is C<pascal>, C<false>
otherwise.


=item Unit::isRadian

Predicate for testing whether this Unit is of the kind C<radian>
@return C<true> if the kind of this Unit is C<radian>, C<false>
otherwise.


=item Unit::isSecond

Predicate for testing whether this Unit is of the kind C<second>
@return C<true> if the kind of this Unit is C<second>, C<false>
otherwise.


=item Unit::isSiemens

Predicate for testing whether this Unit is of the kind C<siemens>
@return C<true> if the kind of this Unit is C<siemens>, C<false>
otherwise.


=item Unit::isSievert

Predicate for testing whether this Unit is of the kind C<sievert>
@return C<true> if the kind of this Unit is C<sievert>, C<false>
otherwise.


=item Unit::isSteradian

Predicate for testing whether this Unit is of the kind C<steradian>
@return C<true> if the kind of this Unit is C<steradian>, C<false>
otherwise.


=item Unit::isTesla

Predicate for testing whether this Unit is of the kind C<tesla>
@return C<true> if the kind of this Unit is C<tesla>, C<false>
otherwise.


=item Unit::isVolt

Predicate for testing whether this Unit is of the kind C<volt>
@return C<true> if the kind of this Unit is C<volt>, C<false>
otherwise.


=item Unit::isWatt

Predicate for testing whether this Unit is of the kind C<watt>
@return C<true> if the kind of this Unit is C<watt>, C<false>
otherwise.


=item Unit::isWeber

Predicate for testing whether this Unit is of the kind C<weber>
@return C<true> if the kind of this Unit is C<weber>, C<false>
otherwise.


=item Unit::isSetKind

Predicate to test whether the "kind" attribute of this Unit is set.
@return C<true> if the "kind" attribute of this Unit is set, @c
false otherwise.


=item Unit::isSetExponent

Predicate to test whether the "exponent" attribute of this Unit 
is set.
@return C<true> if the "exponent" attribute of this Unit is set, 
C<false> otherwise.


=item Unit::isSetScale

Predicate to test whether the "scale" attribute of this Unit 
is set.
@return C<true> if the "scale" attribute of this Unit is set, 
C<false> otherwise.


=item Unit::isSetMultiplier

Predicate to test whether the "multiplier" attribute of this Unit 
is set.
@return C<true> if the "multiplier" attribute of this Unit is set, 
C<false> otherwise.


=item Unit::isSetOffset

Predicate to test whether the "offset" attribute of this Unit 
is set.
@return C<true> if the "offset" attribute of this Unit is set, 
C<false> otherwise.
C<opydetails> doc_warning_unit_offset_only_l2v1


=item Unit::setKind

Sets the "kind" attribute value of this Unit.
@if clike
@param kind a value from the <a class="el"
href="#UnitKind_t">UnitKind_t</a> enumeration.
@endif@if java
@param kind a unit identifier chosen from the set of constants whose
names begin with C<UNIT_KIND_> in <code><a
href="libsbmlConstants.html">libsbmlConstants</a></code>.
@endif@if python
@param kind a unit identifier chosen from the set of constants whose
names begin with C<UNIT_KIND_> in @link libsbml libsbml@endlink.
@endif@~

C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink


=item Unit::setExponent

Sets the "exponent" attribute value of this Unit.
@param value the integer to which the attribute "exponent" should be set.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink


=item Unit::setExponent

Sets the "exponent" attribute value of this Unit.
@param value the double to which the attribute "exponent" should be set.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink


=item Unit::setScale

Sets the "scale" attribute value of this Unit.
@param value the integer to which the attribute "scale" should be set.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink


=item Unit::setMultiplier

Sets the "multipler" attribute value of this Unit.
@param value the floating-point value to which the attribute
"multiplier" should be set.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink


=item Unit::setOffset

Sets the "offset" attribute value of this Unit.
@param value the float-point value to which the attribute "offset"
should set.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
C<opydetails> doc_warning_unit_offset_only_l2v1


=item Unit::unsetKind

Unsets the "kind" attribute value of this Unit.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink


=item Unit::unsetExponent

Unsets the "exponent" attribute value of this Unit.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink


=item Unit::unsetScale

Unsets the "scale" attribute value of this Unit.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink


=item Unit::unsetMultiplier

Unsets the "multipler" attribute value of this Unit.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink


=item Unit::unsetOffset

Unsets the "offset" attribute value of this Unit.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
C<opydetails> doc_warning_unit_offset_only_l2v1


=item Unit::getTypeCode

Returns the libSBML type code of this object instance.
C<opydetails> doc_what_are_typecodes
@return the SBML type code for this object:
@link SBMLTypeCode_t#SBML_UNIT SBML_UNIT@endlink (default).
C<opydetails> doc_warning_typecodes_not_unique
@see getPackageName()
@see getElementName()


=item Unit::getElementName

Returns the XML element name of this object, which for Unit, is
always C<"unit">.
@return the name of this element, i.e., C<"unit">.


=item Unit::writeElements

@internal


=item Unit::isBuiltIn

Predicate to test whether a given string is the name of a
predefined SBML unit.
@param name a string to be tested against the predefined unit names.
@param level the Level of SBML for which the determination should be
made.  This is necessary because there are a few small differences
in allowed units between SBML Level&nbsp;1 and Level&nbsp;2.
@return C<true> if C<name> is one of the five SBML predefined unit
identifiers (C<"substance">, C<"volume">, C<"area">, C<"length"> or @c
"time"), C<false> otherwise.
@note The predefined unit identifiers C<"length"> and C<"area"> were
added in Level&nbsp;2 Version&nbsp;1.
C<opydetails> doc_note_static_methods


=item Unit::isUnitKind

Predicate to test whether a given string is the name of a valid
base unit in SBML (such as C<"gram"> or C<"mole">).
This method exists because prior to SBML Level&nbsp;2 Version&nbsp;3,
an enumeration called C<UnitKind> was defined by SBML.  This enumeration
was removed in SBML Level&nbsp;2 Version&nbsp;3 and its values were
folded into the space of values of a type called C<UnitSId>.  This method
therefore has less significance in SBML Level&nbsp;2 Version&nbsp;3
and Level&nbsp;2 Version&nbsp;4, but remains for backward
compatibility and support for reading models in older Versions of
Level&nbsp;2.

@param name a string to be tested.
@param level an unsigned int representing the SBML specification
Level.

@param version an unsigned int representing the SBML specification
Version.

@return C<true> if name is a valid SBML UnitKind, C<false> otherwise.
@note The allowed unit names differ between SBML Levels&nbsp;1
and&nbsp;2 and again slightly between Level&nbsp;2 Versions&nbsp;1
and&nbsp;2.

C<opydetails> doc_note_static_methods


=item Unit::areIdentical

Predicate returning C<true> if two
Unit objects are identical.
Two Unit objects are considered to be I<identical> if they match in
all attributes.  (Contrast this to the method areEquivalent(@if java
Unit u1, Unit u2@endif), which compares Unit objects only with respect
to certain attributes.)
@param unit1 the first Unit object to compare.
@param unit2 the second Unit object to compare.
@return C<true> if all the attributes of unit1 are identical
to the attributes of unit2, C<false> otherwise.
C<opydetails> doc_note_static_methods
@see @if clike areEquivalent() @else Unit::areEquivalent(Unit u1, Unit u2) @endif@~


=item Unit::areEquivalent

Predicate returning C<true> if 
Unit objects are equivalent.
Two Unit objects are considered to be I<equivalent> either if (1) both
have a "kind" attribute value of C<dimensionless>, or (2) their "kind",
"exponent" and (for SBML Level&nbsp;2 Version&nbsp;1) "offset"
attribute values are equal. (Contrast this to the method
areIdentical(@if java Unit, Unit@endif), which compares Unit objects with respect to all
attributes, not just the "kind" and "exponent".)
@param unit1 the first Unit object to compare.
@param unit2 the second Unit object to compare.
@return C<true> if the "kind" and "exponent" attributes of unit1 are
identical to the kind and exponent attributes of unit2, C<false>
otherwise.

C<opydetails> doc_note_static_methods
@see @if clike areIdentical() @else Unit::areIdentical(Unit u1, Unit u2) @endif@~


=item Unit::removeScale

Manipulates the attributes of the Unit to express the unit with the 
value of the scale attribute reduced to zero.
For example, 1 millimetre can be expressed as a Unit with kind=@c
"metre" multiplier=C<"1"> scale=C<"-3"> exponent=C<"1">. It can also be
expressed as a Unit with kind=C<"metre">
multiplier=C<"0.001"> scale=C<"0"> exponent=C<"1">.
@param unit the Unit object to manipulate.
C<opydetails> doc_returns_one_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
C<opydetails> doc_note_static_methods
@see @if clike convertToSI() @else Unit::convertToSI(Unit u) @endif@~
@see @if clike merge() @else Unit::merge(Unit u1, Unit u2) @endif@~


=item Unit::merge

Merges two Unit objects with the same "kind" attribute value into a
single Unit.
For example, the following,
@verbatim
<unit kind="metre" exponent="2"/>
<unit kind="metre" exponent="1"/>
@endverbatim
would be merged to become
@verbatim
<unit kind="metre" exponent="3"/>
@endverbatim

@param unit1 the first Unit object; the result of the operation is
left as a new version of this unit, modified in-place.  Not modified if
the two units have different kinds.
@param unit2 the second Unit object to merge with the first.
C<opydetails> doc_note_static_methods
@see @if clike convertToSI() @else Unit::convertToSI(Unit u) @endif@~
@see @if clike removeScale() @else Unit::removeScale(Unit u) @endif@~


=item Unit::convertToSI

Returns a UnitDefinition object containing the given C<unit> converted
to the appropriate SI unit.
This method exists because some units can be expressed in terms of
others when the same physical dimension is involved.  For example, one
hertz is identical to 1&nbsp;sec<sup>-1</sup>, one litre is equivalent
to 1 cubic decametre, and so on.
@param unit the Unit object to convert to SI.
@return a UnitDefinition object containing the SI unit.
C<opydetails> doc_note_static_methods
@see @if clike merge() @else Unit::merge(Unit u1, Unit u2) @endif@~


=item Unit::hasRequiredAttributes

Predicate returning C<true> if
all the required attributes for this Unit object
have been set.
The required attributes for a Unit object are:
@li "kind"
@li "exponent" (required in SBML Level&nbsp;3; optional in Level&nbsp;2)
@li "multiplier" (required in SBML Level&nbsp;3; optional in Level&nbsp;2)
@li "scale" (required in SBML Level&nbsp;3; optional in Level&nbsp;2)
@return C<true> if the required attributes have been set, C<false>
otherwise.


=item Unit::setExponentUnitChecking

@internal


=item Unit::getExponentUnitChecking

@internal


=item Unit::getExponentUnitChecking

@internal


=item Unit::isUnitChecking

@internal


=item Unit::isUnitChecking

@internal


=item Unit::addExpectedAttributes

@internal


=item Unit::readAttributes

@internal


=item Unit::readL1Attributes

@internal


=item Unit::readL2Attributes

@internal


=item Unit::readL3Attributes

@internal


=item Unit::writeAttributes

@internal


=item Unit::isL1UnitKind

@internal


=item Unit::isL2V1UnitKind

@internal


=item Unit::isL2UnitKind

@internal


=item Unit::isL3UnitKind

@internal


=item Unit::isExplicitlySetExponent

@internal


=item Unit::isExplicitlySetMultiplier

@internal


=item Unit::isExplicitlySetScale

@internal


=item Unit::isExplicitlySetOffset

@internal


=item ListOfUnits::ListOfUnits

Creates a new ListOfUnits object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level.
@param version the Version within the SBML Level.
C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item ListOfUnits::ListOfUnits

Creates a new ListOfUnits object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfUnits object to be created.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item ListOfUnits::clone

Creates and returns a deep copy of this ListOfUnits object.
@return the (deep) copy of this ListOfUnits object.


=item ListOfUnits::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., Unit objects, if the list is non-empty).
C<opydetails> doc_what_are_typecodes
@return the SBML type code for objects contained in this list:
@link SBMLTypeCode_t#SBML_UNIT SBML_UNIT@endlink (default).
@see getElementName()
@see getPackageName()


=item ListOfUnits::getElementName

Returns the XML element name of this object.
For ListOfUnits, the XML element name is C<"listOfUnits">.
@return the name of this element, i.e., C<"listOfUnits">.


=item ListOfUnits::get

Get a Unit from the ListOfUnits.
@param n the index number of the Unit to get.
@return the nth Unit in this ListOfUnits.
@see size()


=item ListOfUnits::get

Get a Unit from the ListOfUnits.
@param n the index number of the Unit to get.
@return the nth Unit in this ListOfUnits.
@see size()


=item ListOfUnits::remove

Removes the nth item from this ListOfUnits items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove.
@see size()


=item ListOfUnits::getElementPosition

@internal


=item ListOfUnits::createObject

@internal


=back

=head2 UnitDefinition

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html A definition of a unit used in an SBML model.
Units of measurement may be supplied in a number of contexts in an SBML
model.  The SBML unit definition facility uses two classes of objects,
UnitDefinition and Unit.  The approach to defining units in SBML is
compositional; for example, <em>meter second<sup> &ndash;2</sup></em> is
constructed by combining a Unit object representing <em>meter</em> with
another Unit object representing <em>second<sup> &ndash;2</sup></em>.
The combination is wrapped inside a UnitDefinition, which provides for
assigning an identifier and optional name to the combination.  The
identifier can then be referenced from elsewhere in a model.  Thus, the
UnitDefinition class is the container, and Unit instances are placed
inside UnitDefinition instances.
Two points are worth discussing in the context of SBML units.  First,
unit declarations in SBML models are I<optional>.  The consequence of
this is that a model must be numerically self-consistent independently
of unit declarations, for the benefit of software tools that cannot
interpret or manipulate units.  Unit declarations in SBML are thus more
akin to a type of annotation; they can indicate intentions, and can be
used by model readers for checking the consistency of the model,
labeling simulation output, etc., but any transformations of values
implied by different units must be incorporated I<explicitly> into a
model.

Second, the vast majority of situations that require new SBML unit
definitions involve simple multiplicative combinations of base units and
factors.  An example is <em>moles per litre per second</em>.  What
distinguishes these sorts of unit definitions from more complex ones is
that they may be expressed without the use of an additive offset from a
zero point.  The use of offsets complicates all unit definition systems,
yet in the domain of SBML, the real-life cases requiring offsets are few
(and in fact, to the best of our knowledge, only involve temperature).
Consequently, the SBML unit system has been consciously designed to
simplify implementation of unit support for the most common cases in
systems biology.  The cost of this simplification is to require units
with offsets to be handled explicitly by the modeler.
@section unitdef-summary Summary of the UnitDefinition construct
UnitDefinition has two attributes and one subelement.  The two
attributes are "id" and "name", and the subelement is ListOfUnits.
The required attribute "id" and optional attribute "name" are both
strings.  The "id" attribute is used to give the defined unit a unique
identifier by which other parts of an SBML model definition can refer to
it.  The "name" attribute is intended to be used for giving the unit
definition an optional human-readable name.  Please see the <a
href="#unitdef-id">next section</a> for information about the values
permitted for "id".
A UnitDefinition may contain exactly one ListOfUnits, and this list
may contain one or more Unit definitions; see the definitions of these
other object classes for more information about them.  In SBML 
Level&nbsp;2 and SBML Level&nbsp;3 Version&nbsp;1, if the ListOfUnits
was present, it must have one or more Unit definitions.  In SBML
Level&nbsp;3 Version&nbsp;2, this restriction was relaxed, and 
a ListOfUnits was allowed to be empty.  In either case, if a
UnitDefinition had no child Unit elements, the unit was considered
to be undefined.
The following
example illustrates a complete unit definition (when written in XML)
when all the pieces are combined together.  This defines "mmls"
to be millimoles per litre per second.
@verbatim
<listOfUnitDefinitions>
<unitDefinition id="mmls">
<listOfUnits>
<unit kind="mole"   scale="-3"/>
<unit kind="litre"  exponent="-1"/>
<unit kind="second" exponent="-1"/>
</listOfUnits>
</unitDefinition>
</listOfUnitDefinitions>
@endverbatim
@section unitdef-id Special considerations for Unit object identifiers
The attribute "id" in UnitDefinition cannot be given simply any value,
and the precise details of the values permitted differ slightly between
Levels of SBML:
\n=over\n

\n=item\n\nThe "id" of a UnitDefinition must I<not> contain a value from the
list of SBML's predefined base unit names (i.e., the strings C<gram>, @c
litre, etc.).  In SBML Level&nbsp;3, this list consists of the
following:

C<opydetails> doc_base_units
This list of predefined base units is nearly identical in SBML
Level&nbsp;2 Version&nbsp;4, the exception being that Level&nbsp;2 does
not define C<avogadro>.  SBML Level&nbsp;2 Version&nbsp;1 (and I<only>
this Level+Version combination) provides an additional predefined unit
name, C<Celsius>, not available in Level&nbsp;3.  Finally, SBML
Level&nbsp;1 Versions&nbsp;2&ndash;3 provide two more additional
predefined unit names, C<meter> and C<liter>.  This is explained in
somewhat greater detail in the description of the Unit class.
\n=over\n
\n=item\n\nIn SBML Level&nbsp;2 (all Versions), there is an additional set of
reserved identifiers: C<substance>, C<volume>, C<area>, C<length>, and
C<time>.  Using one of these values for the attribute "id" of a
UnitDefinition has the effect of redefining the model-wide default units
for the corresponding quantities.  The list of special unit names in
SBML Level&nbsp;2 is given in the table below:
\n=back\n

@htmlinclude predefined-units.html
Also, SBML Level&nbsp;2 imposes two limitations on redefining the
predefined unit C<substance>, C<volume>, C<area>, C<length>, and @c
time: (1) The UnitDefinition of a predefined SBML unit can only contain
a single Unit object within it.  (2) The value of the "kind" attribute
in a Unit instance must be drawn from one of the values in the second
column of the table above.
The special unit names C<substance>, C<volume>, C<area>, C<length>, and
C<time> are not defined by SBML Level&nbsp;3, which uses a different
approach to setting model-wide inherited units.
@section sbml-units-limits Further comments about SBML's unit definition system
The vast majority of modeling situations requiring new SBML unit
definitions involve simple multiplicative combinations of base units and
factors.  An example of this might be <em>moles per litre per
second</em>.  What distinguishes these sorts of simpler unit definitions
from more complex ones is that they may be expressed without the use of
an additive offset from a zero point.  The use of offsets complicates
all unit definition systems, yet in the domain of SBML the real-life
cases requiring offsets are few (and in fact, to the best of our
knowledge, only involve temperature).  Consequently, the SBML unit
system has been consciously designed in a way that attempts to simplify
implementation of unit support for the most common cases in systems
biology.

As of SBML Level&nbsp;2 Version&nbsp;2, Unit no longer has the
attribute called "offset" introduced in SBML Level&nbsp;2
Version&nbsp;1.  It turned out that the general case involving units
with offsets was incorrectly defined, and few (if any) developers even
attempted to support offset-based units in their software.  In the
development of Level&nbsp;2 Version&nbsp;2, a consensus among SBML
developers emerged that a fully generalized unit scheme is I<so>
confusing and complicated that it actually I<impedes> interoperability.
SBML Level&nbsp;2 Version&nbsp;2, Version&nbsp;3 and Version&nbsp;4 acknowledge this
reality by reducing and simplifying the unit system, specifically by
removing the "offset" attribute on Unit and C<Celsius> as a pre-defined
unit.

The following guidelines suggest methods for handling units that do
require the use of zero offsets for their definitions:
\n=over\n
\n=item\n\n<em>Handling Celsius</em>.  A model in which certain quantities are
temperatures measured in degrees Celsius can be converted
straightforwardly to a model in which those temperatures are in
kelvin.  A software tool could do this by performing a straightforward
substitution using the following relationship: <em>T<sub> kelvin</sub> =
T<sub>Celsius</sub> + 273.15</em>.  In every mathematical formula of the
model where a quantity (call it I<x>) in degrees Celsius appears,
replace I<x> with <em>x<sub>k</sub>+ 273.15</em>, where
<em>x<sub>k</sub></em> is now in kelvin.  An alternative approach would 
be to use a FunctionDefinition object to define a function encapsulating this
relationship above and then using that in the rest of the model as
needed.  Since Celsius is a commonly-used unit, software tools could
help users by providing users with the ability to express temperatures
in Celsius in the tools' interfaces, and making substitutions
automatically when writing out the SBML.
\n=item\n\n<em>Other units requiring offsets</em>.  One approach to handling
other kinds of units is to use a FunctionDefinition to define a function
encapsulating the necessary mathematical relationship, then
substituting a call to this function wherever the original quantity
appeared in the model.  For example, here is a possible definition for
converting Fahrenheit to Celsius degrees:
@verbatim
<functionDefinition id="Fahrenheit_to_kelvin">
<math xmlns="http://www.w3.org/1998/Math/MathML">
<lambda>
<bvar><ci> temp_in_fahrenheit </ci></bvar>
<apply>
<divide/>
<apply>
<plus/>
<ci> temp_in_fahrenheit </ci>
<cn> 459.67 </cn>
</apply>
<cn> 1.8 </cn>
</apply>
</lambda>
</math>
</functionDefinition>
@endverbatim

\n=item\n\nAn alternative approach not requiring the use of function definitions
is to use an AssignmentRule for each variable in Fahrenheit units.
The AssignmentRule could compute the conversion from Fahrenheit to
(say) kelvin, assign its value to a variable (in Kelvin units), and
then that variable could be used elsewhere in the model.
\n=item\n\nStill another approach is to rewrite the mathematical formulas of a
model to directly incorporate the conversion formula wherever the
original quantity appeared.
\n=back\n

Please consult the SBML specifications for more information about this
and other issues involving units.

=over


=back

=head2 ListOfUnitDefinitions

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html A list of UnitDefinition objects.
C<opydetails> doc_what_is_listof

=over


=item UnitDefinition::UnitDefinition

Creates a new UnitDefinition using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this UnitDefinition.
@param version an unsigned int, the SBML Version to assign to this
UnitDefinition.

C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item UnitDefinition::UnitDefinition

Creates a new UnitDefinition using the given SBMLNamespaces object
C<sbmlns>.
C<opydetails> doc_what_are_sbmlnamespaces 
@param sbmlns an SBMLNamespaces object.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item UnitDefinition::UnitDefinition

Copy constructor; creates a copy of this UnitDefinition.
@param orig the object to copy.


=item UnitDefinition::accept

@internal


=item UnitDefinition::clone

Creates and returns a deep copy of this UnitDefinition object.
@return the (deep) copy of this UnitDefinition object.


=item UnitDefinition::getElementBySId

Returns the first child element found that has the given C<id> in the
model-wide SId namespace, or C<NULL> if no such object is found.
@param id string representing the id of the object to find.
@return pointer to the first element found with the given C<id>.


=item UnitDefinition::getElementByMetaId

Returns the first child element it can find with the given C<metaid>, or
C<NULL> if no such object is found.
@param metaid string representing the metaid of the object to find.
@return pointer to the first element found with the given C<metaid>.


=item UnitDefinition::getAllElements

Returns a List of all child SBase objects, including those nested to an
arbitrary depth
@param filter a pointer to an ElementFilter, which causes the function 
to return only elements that match a particular set of constraints.  
If NULL (the default), the function will return all child objects.
@return a List of pointers to all children objects.


=item UnitDefinition::getId

Returns the value of the "id" attribute of this UnitDefinition.
@note Because of the inconsistent behavior of this function with 
respect to assignments and rules, it is now recommended to
use the getIdAttribute() function instead.
C<opydetails> doc_id_attribute
@return the id of this UnitDefinition.
@see getIdAttribute()
@see setIdAttribute(const std::string& sid)
@see isSetIdAttribute()
@see unsetIdAttribute()


=item UnitDefinition::getName

Returns the value of the "name" attribute of this UnitDefinition object.
C<opydetails> doc_get_name


=item UnitDefinition::isSetId

Predicate returning C<true> if this
UnitDefinition's "id" attribute is set.
C<opydetails> doc_isset_id


=item UnitDefinition::isSetName

Predicate returning C<true> if this
UnitDefinition's "name" attribute is set.
C<opydetails> doc_isset_name


=item UnitDefinition::setId

Sets the value of the "id" attribute of this UnitDefinition.
C<opydetails> doc_set_id


=item UnitDefinition::setName

Sets the value of the "name" attribute of this UnitDefinition.
C<opydetails> doc_set_name


=item UnitDefinition::unsetName

Unsets the value of the "name" attribute of this UnitDefinition.
C<opydetails> doc_unset_name


=item UnitDefinition::isVariantOfArea

Convenience function for testing if a given unit definition is a
variant of the predefined unit identifier C<"area">.
@return C<true> if this UnitDefinition is a variant of the predefined
unit C<area>, meaning square metres with only abritrary variations
in scale or multiplier values; C<false> otherwise.


=item UnitDefinition::isVariantOfLength

Convenience function for testing if a given unit definition is a
variant of the predefined unit identifier C<"length">.
@return C<true> if this UnitDefinition is a variant of the predefined
unit C<length>, meaning metres with only abritrary variations in scale
or multiplier values; C<false> otherwise.


=item UnitDefinition::isVariantOfSubstance

Convenience function for testing if a given unit definition is a
variant of the predefined unit identifier C<"substance">.
@return C<true> if this UnitDefinition is a variant of the predefined
unit C<substance>, meaning moles or items (and grams or kilograms from
SBML Level&nbsp;2 Version&nbsp;2 onwards) with only abritrary variations
in scale or multiplier values; C<false> otherwise.


=item UnitDefinition::isVariantOfTime

Convenience function for testing if a given unit definition is a
variant of the predefined unit identifier C<"time">.
@return C<true> if this UnitDefinition is a variant of the predefined
unit C<time>, meaning seconds with only abritrary variations in scale or
multiplier values; C<false> otherwise.


=item UnitDefinition::isVariantOfVolume

Convenience function for testing if a given unit definition is a
variant of the predefined unit identifier C<"volume">.
@return C<true> if this UnitDefinition is a variant of the predefined
unit C<volume>, meaning litre or cubic metre with only abritrary
variations in scale or multiplier values; C<false> otherwise.


=item UnitDefinition::isVariantOfDimensionless

Convenience function for testing if a given unit definition is a
variant of the unit C<"dimensionless">.
@return C<true> if this UnitDefinition is a variant of @c
dimensionless, meaning dimensionless with only abritrary variations in
scale or multiplier values; C<false> otherwise.


=item UnitDefinition::isVariantOfMass

Convenience function for testing if a given unit definition is a
variant of the predefined unit identifier C<"mass">.
@return C<true> if this UnitDefinition is a variant of mass units,
meaning gram or kilogram with only abritrary variations in scale or
multiplier values; C<false> otherwise.


=item UnitDefinition::isVariantOfSubstancePerTime

Convenience function for testing if a given unit definition is a
variant of the predefined unit C<"substance"> divided by the predefined
unit C<"time">.
@return C<true> if this UnitDefinition is a variant of the predefined
unit C<substance> per predefined unit C<time>, meaning it contains two
units one of which is a variant of substance and the other is a
variant of time which an exponent of -1; C<false> otherwise.


=item UnitDefinition::addUnit

Adds a copy of the given Unit to this UnitDefinition.
@param u the Unit instance to add to this UnitDefinition.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
C<opydetails> doc_note_object_is_copied 
@see createUnit()


=item UnitDefinition::createUnit

Creates a new and empty Unit, adds it to this UnitDefinition's list of
units, and returns it.
@return a newly constructed (and empty) Unit instance.
@note It is worth emphasizing that the attribute "kind" value of a
Unit is a required attribute for a valid Unit definition.  The
createUnit() method does not assign a valid kind to the constructed
unit (instead, it sets the "kind" to @link UnitKind_t#UNIT_KIND_INVALID UNIT_KIND_INVALID@endlink).
Callers are cautioned to set the newly-constructed Unit's kind using
Unit::setKind(@if java int@endif) soon after calling this method.
@see addUnit(const Unit  u)


=item UnitDefinition::getListOfUnits

Returns the list of Units for this UnitDefinition instance.
@return the ListOfUnits value for this UnitDefinition.


=item UnitDefinition::getListOfUnits

Returns the list of Units for this UnitDefinition instance.
@return the ListOfUnits value for this UnitDefinition.


=item UnitDefinition::getUnit

Returns a specific Unit instance belonging to this UnitDefinition.
@param n an integer, the index of the Unit to be returned.
@return the nth Unit of this UnitDefinition.
@see getNumUnits()


=item UnitDefinition::getUnit

Returns a specific Unit instance belonging to this UnitDefinition.
@param n an integer, the index of the Unit to be returned.
@return the nth Unit of this UnitDefinition.


=item UnitDefinition::getNumUnits

Returns the number of Unit objects contained within this
UnitDefinition.

@return an integer representing the number of Units in this
UnitDefinition.


=item UnitDefinition::removeUnit

Removes the nth Unit object from this UnitDefinition object and
returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the Unit object to remove.
@return the Unit object removed, or C<NULL> if the given index 
is out of range.


=item UnitDefinition::setSBMLDocument

@internal


=item UnitDefinition::enablePackageInternal

@internal


=item UnitDefinition::getTypeCode

Returns the libSBML type code for this object instance.
C<opydetails> doc_what_are_typecodes
@return the SBML type code for this object:
@link SBMLTypeCode_t#SBML_UNIT_DEFINITION SBML_UNIT_DEFINITION@endlink (default).
C<opydetails> doc_warning_typecodes_not_unique
@see getPackageName()
@see getElementName()


=item UnitDefinition::getElementName

Returns the XML element name of this object, which for UnitDefinition,
is always C<"unitDefinition">.
@return the name of this element, i.e., C<"unitDefinition">.


=item UnitDefinition::simplify

Simplifies the UnitDefinition such that any given kind of Unit object
occurs only once in the ListOfUnits.
For example, the following definition,
@verbatim
<unitDefinition>
<listOfUnits>
<unit kind="metre" exponent="1"/>
<unit kind="metre" exponent="2"/>
</listOfUnits>
<unitDefinition>
@endverbatim
will be simplified to 
@verbatim
<unitDefinition>
<listOfUnits>
<unit kind="metre" exponent="3"/>
</listOfUnits>
<unitDefinition>
@endverbatim

@param ud the UnitDefinition object to be simplified.
C<opydetails> doc_note_static_methods


=item UnitDefinition::reorder

Alphabetically orders the Unit objects within the ListOfUnits of a
UnitDefinition.

@param ud the UnitDefinition object whose units are to be reordered.
C<opydetails> doc_note_static_methods


=item UnitDefinition::convertToSI

Convert a given UnitDefinition into a new UnitDefinition object
that uses SI units.
@param ud the UnitDefinition object to convert to SI.
@return a new UnitDefinition object representing the results of the
conversion.

C<opydetails> doc_note_static_methods


=item UnitDefinition::areIdentical

Predicate returning C<true> if two
UnitDefinition objects are identical.
For the purposes of performing this comparison, two UnitDefinition
objects are considered identical when they contain identical lists of
Unit objects.  Pairs of Unit objects in the lists are in turn
considered identical if they satisfy the predicate
Unit::areIdentical(@if java Unit, Unit@endif).
The predicate compares every attribute of the
Unit objects.
@param ud1 the first UnitDefinition object to compare.
@param ud2 the second UnitDefinition object to compare.
@return C<true> if all the Unit objects in ud1 are identical to the
Unit objects of ud2, C<false> otherwise.
C<opydetails> doc_note_static_methods
@see UnitDefinition::areEquivalent(const UnitDefinition   ud1, const UnitDefinition   ud2)
@see Unit::areIdentical(Unit   unit1, Unit   unit2)


=item UnitDefinition::areEquivalent

Predicate returning C<true> if two
UnitDefinition objects are equivalent.
For the purposes of performing this comparison, two UnitDefinition
objects are considered equivalent when they contain I<equivalent>
list of Unit objects.  Unit objects are in turn considered equivalent
if they satisfy the predicate
Unit::areEquivalent(@if java Unit, Unit@endif).
The predicate tests a subset of the objects's attributes.
@param ud1 the first UnitDefinition object to compare.
@param ud2 the second UnitDefinition object to compare.
@return C<true> if all the Unit objects in ud1 are equivalent
to the Unit objects in ud2, C<false> otherwise.
C<opydetails> doc_note_static_methods
@see UnitDefinition::areIdentical(const UnitDefinition   ud1, const UnitDefinition   ud2)
@see Unit::areEquivalent(Unit   unit1, Unit   unit2)


=item UnitDefinition::areIdenticalSIUnits

@internal


=item UnitDefinition::combine

Combines two UnitDefinition objects into a single UnitDefinition.
This takes UnitDefinition objects C<ud1> and C<ud2>, and creates a
UnitDefinition object that expresses the product of the units of @p
ud1 and C<ud2>.
@param ud1 the first UnitDefinition object.
@param ud2 the second UnitDefinition object.
@return a UnitDefinition which represents the product of the 
units of the two argument UnitDefinitions.
C<opydetails> doc_note_static_methods


=item UnitDefinition::divide

Combines two UnitDefinition objects into a single UnitDefinition as
a division.
This takes UnitDefinition objects C<ud1> and C<ud2>, and creates a
UnitDefinition object that expresses the division of the units of @p
ud1 and C<ud2>.
@param ud1 the first UnitDefinition object.
@param ud2 the second UnitDefinition object.
@return a UnitDefinition which represents the division of the 
units of the two argument UnitDefinitions.
C<opydetails> doc_note_static_methods


=item UnitDefinition::printUnits

Expresses the given definition in a plain-text form.
For example,
UnitDefinition::printUnits(@if java UnitDefinition@endif)
applied to
@verbatim
<unitDefinition>
<listOfUnits>
<unit kind="metre" exponent="1"/>
<unit kind="second" exponent="-2"/>
</listOfUnits>
<unitDefinition>
@endverbatim
will return the string C<"metre (exponent = 1, multiplier = 1,
scale = 0) second (exponent = -2, multiplier = 1, scale = 0)">
or, if the optional parameter C<compact> is given the value C<true>,
the string C<"(1 metre)^1 (1 second)^-2">.  This method may
be useful for printing unit information to human users, or in
debugging software, or other situations.
@param ud the UnitDefinition object.
@param compact boolean indicating whether the compact form
should be used (defaults to false).
@return a string expressing the unit definition defined by the given
UnitDefinition object C<ud>.
C<opydetails> doc_note_static_methods


=item UnitDefinition::writeElements

@internal


=item UnitDefinition::hasRequiredAttributes

Predicate returning C<true> if
all the required attributes for this UnitDefinition object
have been set.
The required attributes for a UnitDefinition object are:
@li "id"
@return C<true> if the required attributes have been set, C<false>
otherwise.


=item UnitDefinition::hasRequiredElements

Predicate returning C<true> if
all the required elements for this UnitDefinition object
have been set.
@note The required elements for a Constraint object are:
@li "listOfUnits" (required in SBML Level&nbsp;2 only, optional in Level&nbsp;3)
@return a boolean value indicating whether all the required
elements for this object have been defined.


=item UnitDefinition::createObject

@internal


=item UnitDefinition::addExpectedAttributes

@internal


=item UnitDefinition::readAttributes

@internal


=item UnitDefinition::readL1Attributes

@internal


=item UnitDefinition::readL2Attributes

@internal


=item UnitDefinition::readL3Attributes

@internal


=item UnitDefinition::writeAttributes

@internal


=item ListOfUnitDefinitions::ListOfUnitDefinitions

Creates a new ListOfUnitDefinitions object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level.
@param version the Version within the SBML Level.
C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item ListOfUnitDefinitions::ListOfUnitDefinitions

Creates a new ListOfUnitDefinitions object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfUnitDefinitions object to be created.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item ListOfUnitDefinitions::clone

Creates and returns a deep copy of this ListOfUnitDefinitions object.
@return the (deep) copy of this ListOfUnitDefinitions object.


=item ListOfUnitDefinitions::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., UnitDefinition objects, if the list is non-empty).
C<opydetails> doc_what_are_typecodes
@return the SBML type code for objects contained in this list:
@link SBMLTypeCode_t#SBML_UNIT_DEFINITION SBML_UNIT_DEFINITION@endlink (default).
@see getElementName()
@see getPackageName()


=item ListOfUnitDefinitions::getElementName

Returns the XML element name of this object.
For ListOfUnitDefinitions, the XML element name is @c
"listOfUnitDefinitions".

@return the name of this element, i.e., C<"listOfUnitDefinitions">.


=item ListOfUnitDefinitions::get

Get a UnitDefinition from the ListOfUnitDefinitions.
@param n the index number of the UnitDefinition to get.
@return the nth UnitDefinition in this ListOfUnitDefinitions.
@see size()


=item ListOfUnitDefinitions::get

Get a UnitDefinition from the ListOfUnitDefinitions.
@param n the index number of the UnitDefinition to get.
@return the nth UnitDefinition in this ListOfUnitDefinitions.
@see size()


=item ListOfUnitDefinitions::get

Get a UnitDefinition from the ListOfUnitDefinitions
based on its identifier.
@param sid a string representing the identifier 
of the UnitDefinition to get.
@return UnitDefinition in this ListOfUnitDefinitions
with the given C<sid> or C<NULL> if no such
UnitDefinition exists.
@see get(unsigned int n)
@see size()


=item ListOfUnitDefinitions::get

Get a UnitDefinition from the ListOfUnitDefinitions
based on its identifier.
@param sid a string representing the identifier 
of the UnitDefinition to get.
@return UnitDefinition in this ListOfUnitDefinitions
with the given C<sid> or C<NULL> if no such
UnitDefinition exists.
@see get(unsigned int n)
@see size()


=item ListOfUnitDefinitions::getElementBySId

Returns the first child element found that has the given C<id> in the
model-wide SId namespace, or C<NULL> if no such object is found.
Note that UnitDefinitions themselves are in the UnitId namespace, not
the SId namespace, so no UnitDefinition object will be returned from
this function (and is the reason we override the base
ListOf::getElementBySId function here).
@param id string representing the id of the object to find.
@return pointer to the first element found with the given C<id>.


=item ListOfUnitDefinitions::remove

Removes the nth item from this ListOfUnitDefinitions items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove.
@see size()


=item ListOfUnitDefinitions::remove

Removes item in this ListOfUnitDefinitions items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove.
@return the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfUnitDefinitions::getElementPosition

@internal


=item ListOfUnitDefinitions::createObject

@internal


=back

=head2 CompartmentType

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html A <em>compartment type</em> in SBML Level&nbsp;2.
SBML Level&nbsp;2 Versions&nbsp;2&ndash;4 provide the <em>compartment
type</em> as a grouping construct that can be used to establish a
relationship between multiple Compartment objects.  A CompartmentType
object only has an identity, and this identity can only be used to
indicate that particular Compartment objects in the model belong to this
type.  This may be useful for conveying a modeling intention, such as
when a model contains many similar compartments, either by their
biological function or the reactions they carry.  Without a compartment
type construct, it would be impossible within SBML itself to indicate
that all of the compartments share an underlying conceptual relationship
because each SBML compartment must be given a unique and separate
identity.  A CompartmentType has no mathematical meaning in
SBML---it has no effect on a model's mathematical interpretation.
Simulators and other numerical analysis software may ignore
CompartmentType definitions and references to them in a model.
There is no mechanism in SBML Level 2 for representing hierarchies of
compartment types.  One CompartmentType instance cannot be the subtype
of another CompartmentType instance; SBML provides no means of defining
such relationships.
As with other major structures in SBML, CompartmentType has a mandatory
attribute, "id", used to give the compartment type an identifier.  The
identifier must be a text string conforming to the identifer syntax
permitted in SBML.  CompartmentType also has an optional "name"
attribute, of type C<string>.  The "id" and "name" must be used
according to the guidelines described in the SBML specification (e.g.,
Section 3.3 in the Level 2 Version 4 specification).
CompartmentType was introduced in SBML Level 2 Version 2.  It is not
available in SBML Level&nbsp;1 nor in Level&nbsp;3.
@see Compartment
@see ListOfCompartmentTypes
@see SpeciesType
@see ListOfSpeciesTypes

=over


=back

=head2 ListOfCompartmentTypes

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html A list of CompartmentType objects.
C<opydetails> doc_what_is_listof

=over


=item CompartmentType::CompartmentType

Creates a new CompartmentType object using the given SBML C<level> and
C<version> values.
@param level an unsigned int, the SBML Level to assign to this
CompartmentType.

@param version an unsigned int, the SBML Version to assign to this
CompartmentType.

C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item CompartmentType::CompartmentType

Creates a new CompartmentType object using the given SBMLNamespaces
object C<sbmlns>.
C<opydetails> doc_what_are_sbmlnamespaces
It is worth emphasizing that although this constructor does not take an
identifier argument, in SBML Level&nbsp;2 and beyond, the "id"
(identifier) attribute of a CompartmentType object is required to have a
value.  Thus, callers are cautioned to assign a value after calling this
constructor.  Setting the identifier can be accomplished using the
method setId(@if java String@endif).
@param sbmlns an SBMLNamespaces object.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item CompartmentType::CompartmentType

Copy constructor; creates a copy of this CompartmentType object.
@param orig the object to copy.


=item CompartmentType::accept

@internal


=item CompartmentType::clone

Creates and returns a deep copy of this CompartmentType object.
@return the (deep) copy of this CompartmentType object.


=item CompartmentType::getId

Returns the value of the "id" attribute of this CompartmentType.
@note Because of the inconsistent behavior of this function with 
respect to assignments and rules, it is now recommended to
use the getIdAttribute() function instead.
C<opydetails> doc_id_attribute
@return the id of this CompartmentType.
@see getIdAttribute()
@see setIdAttribute(const std::string& sid)
@see isSetIdAttribute()
@see unsetIdAttribute()


=item CompartmentType::getName

Returns the value of the "name" attribute of this CompartmentType object.
C<opydetails> doc_get_name


=item CompartmentType::isSetId

Predicate returning C<true> if this CompartmentType object's "id"
attribute is set.
C<opydetails> doc_isset_id


=item CompartmentType::isSetName

Predicate returning C<true> if this CompartmentType object's "name"
attribute is set.
C<opydetails> doc_isset_name


=item CompartmentType::setId

Sets the value of the "id" attribute of this CompartmentType.
C<opydetails> doc_set_id


=item CompartmentType::setName

Sets the value of the "name" attribute of this CompartmentType.
C<opydetails> doc_set_name


=item CompartmentType::unsetName

Unsets the value of the "name" attribute of this CompartmentType object.
C<opydetails> doc_unset_name


=item CompartmentType::getTypeCode

Returns the libSBML type code for this SBML object.
C<opydetails> doc_what_are_typecodes
@return the SBML type code for this object:
@link SBMLTypeCode_t#SBML_COMPARTMENT_TYPE SBML_COMPARTMENT_TYPE@endlink (default).
C<opydetails> doc_warning_typecodes_not_unique
@see getElementName()
@see getPackageName()


=item CompartmentType::getElementName

Returns the XML element name of this object
For CompartmentType, the element name is always C<"compartmentType">.
@return the name of this element.
@see getTypeCode()
@see getPackageName()


=item CompartmentType::writeElements

@internal


=item CompartmentType::hasRequiredAttributes

Predicate returning C<true> if all the required attributes for this
CompartmentType object have been set.
The required attributes for a CompartmentType object are:
@li "id"
@return C<true> if the required attributes have been set, C<false>
otherwise.


=item CompartmentType::addExpectedAttributes

@internal


=item CompartmentType::readAttributes

@internal


=item CompartmentType::readL2Attributes

@internal


=item CompartmentType::writeAttributes

@internal


=item ListOfCompartmentTypes::ListOfCompartmentTypes

Creates a new ListOfCompartmentTypes object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level.
@param version the Version within the SBML Level.
C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item ListOfCompartmentTypes::ListOfCompartmentTypes

Creates a new ListOfCompartmentTypes object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfCompartmentTypes object to be created.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item ListOfCompartmentTypes::clone

Creates and returns a deep copy of this ListOfCompartmentTypes object.
@return the (deep) copy of this ListOfCompartmentTypes object.


=item ListOfCompartmentTypes::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., CompartmentType objects, if the list is non-empty).
C<opydetails> doc_what_are_typecodes
@return the SBML type code for the objects contained in this ListOf
instance: @link SBMLTypeCode_t#SBML_COMPARTMENT_TYPE SBML_COMPARTMENT_TYPE@endlink (default).
@see getElementName()
@see getPackageName()


=item ListOfCompartmentTypes::getElementName

Returns the XML element name of this object.
For ListOfCompartmentTypes, the XML element name is @c
"listOfCompartmentTypes".

@return the name of this element, i.e., C<"listOfCompartmentTypes">.


=item ListOfCompartmentTypes::get

Get a CompartmentType object from the ListOfCompartmentTypes.
@param n the index number of the CompartmentType object to get.
@return the nth CompartmentType object in this ListOfCompartmentTypes.
@see size()


=item ListOfCompartmentTypes::get

Get a CompartmentType object from the ListOfCompartmentTypes.
@param n the index number of the CompartmentType object to get.
@return the nth CompartmentType object in this ListOfCompartmentTypes.
@see size()


=item ListOfCompartmentTypes::get

Get a CompartmentType object from the ListOfCompartmentTypes
based on its identifier.
@param sid a string representing the identifier
of the CompartmentType object to get.
@return CompartmentType object in this ListOfCompartmentTypes
with the given C<sid> or C<NULL> if no such
CompartmentType object exists.
@see get(unsigned int n)
@see size()


=item ListOfCompartmentTypes::get

Get a CompartmentType object from the ListOfCompartmentTypes
based on its identifier.
@param sid a string representing the identifier
of the CompartmentType object to get.
@return CompartmentType object in this ListOfCompartmentTypes
with the given C<sid> or C<NULL> if no such
CompartmentType object exists.
@see get(unsigned int n)
@see size()


=item ListOfCompartmentTypes::remove

Removes the nth item from this ListOfCompartmentTypes items
and returns a pointer to it.
The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove.
@see size()


=item ListOfCompartmentTypes::remove

Removes item in this ListOfCompartmentTypes items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove.
@return the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfCompartmentTypes::getElementPosition

@internal


=item ListOfCompartmentTypes::createObject

@internal


=back

=head2 SpeciesType

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html A <em>species type</em> in SBML Level 2.
The term I<species> I<type> refers to reacting entities independent of
location.  These include simple ions (e.g., protons, calcium), simple
molecules (e.g., glucose, ATP), large molecules (e.g., RNA,
polysaccharides, and proteins), and others.
SBML Level&nbsp;2 Versions&nbsp;2&ndash;4 provide an explicit
SpeciesType class of object to enable Species objects of the same type
to be related together.  SpeciesType is a conceptual construct; the
existence of SpeciesType objects in a model has no effect on the model's
numerical interpretation.  Except for the requirement for uniqueness of
species/species type combinations located in compartments, simulators
and other numerical analysis software may ignore SpeciesType definitions
and references to them in a model.
There is no mechanism in SBML Level 2 for representing hierarchies of
species types.  One SpeciesType object cannot be the subtype of another
SpeciesType object; SBML provides no means of defining such
relationships.

As with other major structures in SBML, SpeciesType has a mandatory
attribute, "id", used to give the species type an identifier.  The
identifier must be a text string conforming to the identifer syntax
permitted in SBML.  SpeciesType also has an optional "name" attribute,
of type C<string>.  The "id" and "name" must be used according to the
guidelines described in the SBML specification (e.g., Section 3.3 in
the Level&nbsp;2 Version&nbsp;4 specification).
SpeciesType was introduced in SBML Level 2 Version 2.  It is not
available in SBML Level&nbsp;1 nor in Level&nbsp;3.
@see Species
@see ListOfSpeciesTypes
@see CompartmentType
@see ListOfCompartmentTypes

=over


=back

=head2 ListOfSpeciesTypes

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html A list of SpeciesType objects.
C<opydetails> doc_what_is_listof

=over


=item SpeciesType::SpeciesType

Creates a new SpeciesType using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this SpeciesType.
@param version an unsigned int, the SBML Version to assign to this
SpeciesType.

C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item SpeciesType::SpeciesType

Creates a new SpeciesType using the given SBMLNamespaces object
C<sbmlns>.
C<opydetails> doc_what_are_sbmlnamespaces 
It is worth emphasizing that although this constructor does not take
an identifier argument, in SBML Level&nbsp;2 and beyond, the "id"
(identifier) attribute of a SpeciesType object is required to have a value.
Thus, callers are cautioned to assign a value after calling this
constructor.  Setting the identifier can be accomplished using the
method SBase::setId(@if java String@endif).
@param sbmlns an SBMLNamespaces object.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item SpeciesType::SpeciesType

Copy constructor; creates a copy of this SpeciesType.
@param orig the object to copy.


=item SpeciesType::accept

@internal


=item SpeciesType::clone

Creates and returns a deep copy of this SpeciesType object.
@return the (deep) copy of this SpeciesType object.


=item SpeciesType::getId

Returns the value of the "id" attribute of this SpeciesType.
@note Because of the inconsistent behavior of this function with 
respect to assignments and rules, it is now recommended to
use the getIdAttribute() function instead.
C<opydetails> doc_id_attribute
@return the id of this SpeciesType.
@see getIdAttribute()
@see setIdAttribute(const std::string& sid)
@see isSetIdAttribute()
@see unsetIdAttribute()


=item SpeciesType::getName

Returns the value of the "name" attribute of this SpeciesType object.
C<opydetails> doc_get_name


=item SpeciesType::isSetId

Predicate returning C<true> if this
SpeciesType's "id" attribute is set.
C<opydetails> doc_isset_id


=item SpeciesType::isSetName

Predicate returning C<true> if this
SpeciesType's "name" attribute is set.
C<opydetails> doc_isset_name


=item SpeciesType::setId

Sets the value of the "id" attribute of this SpeciesType.
C<opydetails> doc_set_id


=item SpeciesType::setName

Sets the value of the "name" attribute of this SpeciesType.
C<opydetails> doc_set_name


=item SpeciesType::unsetName

Unsets the value of the "name" attribute of this SpeciesType.
C<opydetails> doc_unset_name


=item SpeciesType::getTypeCode

Returns the libSBML type code for this SBML object.
C<opydetails> doc_what_are_typecodes
@return the SBML type code for this object:
@link SBMLTypeCode_t#SBML_SPECIES_TYPE SBML_SPECIES_TYPE@endlink (default).
C<opydetails> doc_warning_typecodes_not_unique
@see getElementName()
@see getPackageName()


=item SpeciesType::getElementName

Returns the XML element name of this object, which for
SpeciesType, is always C<"compartmentType">.
@return the name of this element, i.e., C<"compartmentType">.


=item SpeciesType::writeElements

@internal


=item SpeciesType::hasRequiredAttributes

Predicate returning C<true> if
all the required attributes for this SpeciesType object
have been set.
The required attributes for a SpeciesType object are:
@li "id"
@return C<true> if the required attributes have been set, C<false>
otherwise.


=item SpeciesType::addExpectedAttributes

@internal


=item SpeciesType::readAttributes

@internal


=item SpeciesType::readL2Attributes

@internal


=item SpeciesType::writeAttributes

@internal


=item ListOfSpeciesTypes::ListOfSpeciesTypes

Creates a new ListOfSpeciesTypes object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level.
@param version the Version within the SBML Level.
C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item ListOfSpeciesTypes::ListOfSpeciesTypes

Creates a new ListOfSpeciesTypes object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfSpeciesTypes object to be created.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item ListOfSpeciesTypes::clone

Creates and returns a deep copy of this ListOfSpeciesTypes object.
@return the (deep) copy of this ListOfSpeciesTypes object.


=item ListOfSpeciesTypes::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., SpeciesType objects, if the list is non-empty).
C<opydetails> doc_what_are_typecodes
@return the SBML type code for objects contained in this list:
@link SBMLTypeCode_t#SBML_SPECIES_TYPE SBML_SPECIES_TYPE@endlink (default).
@see getElementName()
@see getPackageName()


=item ListOfSpeciesTypes::getElementName

Returns the XML element name of this object.
For ListOfSpeciesTypes, the XML element name is @c
"listOfSpeciesTypes".

@return the name of this element, i.e., C<"listOfSpeciesTypes">.


=item ListOfSpeciesTypes::get

Get a SpeciesType from the ListOfSpeciesTypes.
@param n the index number of the SpeciesType to get.
@return the nth SpeciesType in this ListOfSpeciesTypes.
@see size()


=item ListOfSpeciesTypes::get

Get a SpeciesType from the ListOfSpeciesTypes.
@param n the index number of the SpeciesType to get.
@return the nth SpeciesType in this ListOfSpeciesTypes.
@see size()


=item ListOfSpeciesTypes::get

Get a SpeciesType from the ListOfSpeciesTypes
based on its identifier.
@param sid a string representing the identifier 
of the SpeciesType to get.
@return SpeciesType in this ListOfSpeciesTypes
with the given C<sid> or C<NULL> if no such
SpeciesType exists.
@see get(unsigned int n)
@see size()


=item ListOfSpeciesTypes::get

Get a SpeciesType from the ListOfSpeciesTypes
based on its identifier.
@param sid a string representing the identifier 
of the SpeciesType to get.
@return SpeciesType in this ListOfSpeciesTypes
with the given C<sid> or C<NULL> if no such
SpeciesType exists.
@see get(unsigned int n)
@see size()


=item ListOfSpeciesTypes::remove

Removes the nth item from this ListOfSpeciesTypes items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove.
@see size()


=item ListOfSpeciesTypes::remove

Removes item in this ListOfSpeciesTypes items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove.
@return the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfSpeciesTypes::getElementPosition

@internal


=item ListOfSpeciesTypes::createObject

@internal


=back

=head2 Compartment

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html An SBML compartment, where species are located.
A compartment in SBML represents a bounded space in which species are
located.  Compartments do not necessarily have to correspond to actual
structures inside or outside of a biological cell.
It is important to note that although compartments are optional in the
overall definition of Model, every species in an SBML model must be
located in a compartment.  This in turn means that if a model defines
any species, the model must also define at least one compartment.  The
reason is simply that species represent physical things, and therefore
must exist I<somewhere>.  Compartments represent the I<somewhere>.
Compartment has one required attribute, "id", to give the compartment a
unique identifier by which other parts of an SBML model definition can
refer to it.  A compartment can also have an optional "name" attribute
of type C<string>.  Identifiers and names must be used according to the
guidelines described in the SBML specifications.
Compartment also has an optional attribute "spatialDimensions" that is
used to indicate the number of spatial dimensions possessed by the
compartment.  Most modeling scenarios involve compartments with integer
values of "spatialDimensions" of C<3> (i.e., a three-dimensional
compartment, which is to say, a volume), or 2 (a two-dimensional
compartment, a surface), or C<1> (a one-dimensional compartment, a
line).  In SBML Level&nbsp;3, the type of this attribute is C<double>,
there are no restrictions on the permitted values of the
"spatialDimensions" attribute, and there are no default values.  In SBML
Level&nbsp;2, the value must be a positive C<integer>, and the default
value is C<3>; the permissible values in SBML Level&nbsp;2 are C<3>, @c
2, C<1>, and C<0> (for a point).
Another optional attribute on Compartment is "size", representing the @em
initial total size of that compartment in the model.  The "size" attribute
must be a floating-point value and may represent a volume (if the
compartment is a three-dimensional one), or an area (if the compartment is
two-dimensional), or a length (if the compartment is one-dimensional).
There is no default value of compartment size in SBML Level&nbsp;2 or
Level&nbsp;3.  In particular, a missing "size" value <em>does not imply
that the compartment size is 1</em>.  (This is unlike the definition of
compartment "volume" in SBML Level&nbsp;1.)  When the compartment's
"spatialDimensions" attribute does not have a value of C<0>, a missing
value of "size" for a given compartment signifies that the value either is
unknown, or to be obtained from an external source, or determined by an
InitialAssignment, AssignmentRule, AlgebraicRule or RateRule
@if conly structure @else object@endif@~ elsewhere in the model.  In SBML
Level&nbsp;2, there are additional special requirements on the values of
"size"; we discuss them in a <a href="#comp-l2">separate section
below</a>.

The units associated with a compartment's "size" attribute value may be
set using the optional attribute "units".  The rules for setting and
using compartment size units differ between SBML Level&nbsp;2 and
Level&nbsp;3, and are discussed separately below.
Finally, the Compartment attribute named "constant" is used to
indicate whether the compartment's size stays constant after simulation
begins.  A value of C<true> indicates the compartment's "size" cannot be
changed by any other construct except InitialAssignment; a value of @c
false indicates the compartment's "size" can be changed by other
constructs in SBML.  In SBML Level&nbsp;2, there is an additional
explicit restriction that if "spatialDimensions"=C<"0">, the value
cannot be changed by InitialAssignment either.  Further, in
Level&nbsp;2, "constant" is optional, and has a default value of C<true>.  In SBML
Level&nbsp;3, there is no default value for the "constant" attribute,
and it is required.
@section comp-l2 Additional considerations in SBML Level&nbsp;2
In SBML Level&nbsp;2, the default units of compartment size, and the kinds
of units allowed as values of the attribute "units", interact with the
number of spatial dimensions of the compartment.  The value of the "units"
attribute of a Compartment @if conly structure @else object@endif@~ must
be one of the base units (see Unit), or the predefined unit identifiers @c
volume, C<area>, C<length> or C<dimensionless>, or a new unit defined by a
UnitDefinition @if conly structure @else object@endif@~ in the enclosing
Model, subject to the restrictions detailed in the following table:
<table border="0" class="centered text-table width80 normal-font alt-row-colors"
style="padding-bottom: 0.5em">
<caption class="top-caption">Restrictions on values permitted for
compartment C<size> and C<units> attributes.</caption>
<tr>
<th align="left" valign="bottom">
Value of<br>C<spatialDimensions>
</th>
<th align="left" valign="bottom">
C<size><br>allowed?
</th>
<th align="left" valign="bottom">
C<units><br>allowed?
</th>
<th align="left" valign="bottom">
Allowable kinds of units
</th>
<th align="left" valign="bottom">
Default value of attribute C<units>
</th>
</tr>
<tr>
<td>C<3></td>
<td>yes</td>
<td>yes</td>
<td>units of volume, or C<dimensionless></td>
<td>C<volume></td>
</tr>
<tr>
<td>C<2></td>
<td>yes</td>
<td>yes</td>
<td>units of area, or C<dimensionless></td>
<td>C<area></td>
</tr>
<tr>
<td>C<1></td>
<td>yes</td>
<td>yes</td>
<td>units of length, or C<dimensionless></td>
<td>C<length></td>
</tr>
<tr>
<td>C<0></td>
<td>no</td>
<td>no</td>
<td>(no units allowed)</td>
<td></td>
</tr>
</tr>
</table>
In SBML Level&nbsp;2, the units of the compartment size, as defined by the
"units" attribute or (if "units" is not set) the default value listed in
the table above, are used in the following ways when the compartment has
a "spatialDimensions" value greater than C<0>:
\n=over\n
\n=item\n\nThe value of the "units" attribute is used as the units of the
compartment identifier when the identifier appears as a numerical
quantity in a mathematical formula expressed in MathML.
\n=item\n\nThe C<math> element of an AssignmentRule or InitialAssignment
referring to this compartment I<must> (in Level&nbsp;2 Versions&nbsp;1-3)
or I<should> (in Level&nbsp;2 Version 4) have identical units.
\n=item\n\nIn RateRule objects that set the rate of change of the compartment's
size, the units of the rule's C<math> element I<must> (in Level&nbsp;2 
Versions&nbsp;1&ndash;3) or I<should> (in Level&nbsp;2 Version 4) be identical to the
compartment's units (whether defined by the "units" attribute or by taking the 
default value from the Model) divided by the default I<time> units.
(In other words, the units for the rate of change of compartment size
are <em>compartment size</em>/<em>time</em> units.
\n=item\n\nWhen a Species is to be treated in terms of concentrations or
density, the units of the spatial size portion of the concentration
value (i.e., the denominator in the units formula I<substance>/@em
size) are those indicated by the value of the "units" attribute on the
compartment in which the species is located.
\n=back\n

Compartments with "spatialDimensions"=C<0> require special treatment in
this framework.  As implied above, the "size" attribute must not have a
value on an SBML Level&nbsp;2 Compartment
@if conly structure @else object@endif@~ if the "spatialDimensions"
attribute has a value of C<0>.  An additional related restriction is that
the "constant" attribute must default to or be set to C<true> if the value
of the "spatialDimensions" attribute is C<0>, because a zero-dimensional
compartment cannot ever have a size.
If a compartment has no size or dimensional units, how should such a
compartment's identifier be interpreted when it appears in mathematical
formulas?  The answer is that such a compartment's identifier should not
appear in mathematical formulas in the first place---it has no
value, and its value cannot change.  Note also that a zero-dimensional
compartment is a point, and species located at points can only be
described in terms of amounts, not spatially-dependent measures such as
concentration.  Since SBML KineticLaw formulas are already in terms of
I<substance>/I<time> and not (say) I<concentration>/I<time>, volume
or other factors in principle are not needed for species located in
zero-dimensional compartments.
Finally, in SBML Level&nbsp;2 Versions 2&ndash;4, each compartment in a
model may optionally be designated as belonging to a particular
compartment I<type>.  The optional attribute "compartmentType" is used
identify the compartment type represented by the Compartment structure.
The "compartmentType" attribute's value must be the identifier of a
CompartmentType instance defined in the model.  If the "compartmentType"
attribute is not present on a particular compartment definition, a
unique virtual compartment type is assumed for that compartment, and no
other compartment can belong to that compartment type.  The values of
"compartmentType" attributes on compartments have no effect on the
numerical interpretation of a model.  Simulators and other numerical
analysis software may ignore "compartmentType" attributes.  The
"compartmentType" attribute and the CompartmentType
@if conly structures @else class of objects@endif@~ are
not present in SBML Level&nbsp;3 Core nor in SBML Level&nbsp;1.
@section comp-l3 Additional considerations in SBML Level&nbsp;3
One difference between SBML Level&nbsp;3 and lower Levels of SBML is
that there are no restrictions on the permissible values of the
"spatialDimensions" attribute, and there is no default value defined for
the attribute.  The value of "spatialDimensions" does not have to be an
integer, either; this is to allow for the possibility of representing
structures with fractal dimensions.
The number of spatial dimensions possessed by a compartment cannot enter
into mathematical formulas, and therefore cannot directly alter the
numerical interpretation of a model.  However, the value of
"spatialDimensions" I<does> affect the interpretation of the units
associated with a compartment's size.  Specifically, the value of
"spatialDimensions" is used to select among the Model attributes
"volumeUnits", "areaUnits" and "lengthUnits" when a Compartment
@if conly object @else structure@endif@~ does not define a value for its
"units" attribute.
The "units" attribute may be left unspecified for a given compartment in a
model; in that case, the compartment inherits the unit of measurement
specified by one of the attributes on the enclosing Model
@if conly structure @else object@endif@~ instance.  The applicable
attribute on Model depends on the value of the compartment's
"spatialDimensions" attribute; the relationship is shown in the table
below.  If the Model @if conly structure @else object@endif@~ does not
define the relevant attribute ("volumeUnits", "areaUnits" or
"lengthUnits") for a given "spatialDimensions" value, the unit associated
with that Compartment @if conly structure @else object@endif's size is
undefined.  If a given Compartment's "units" are left unset and 
the "spatialDimensions" either has a value other than C<1>, C<2>, or 
C<3> or is left unset itself (as it has no default value),
then no unit can be chosen from among the Model's "volumeUnits",
"areaUnits" or "lengthUnits" attributes (even if the Model instance
provides values for those attributes), because there is no basis to select
between them.
Leaving the units of compartments' sizes undefined in an SBML model does
not render the model invalid; however, as a matter of best practice, we
strongly recommend that all models specify the units of measurement for
all compartment sizes.
<table border="0" class="centered text-table width80 normal-font alt-row-colors"
style="padding-bottom: 0.5em">
<caption class="top-caption">Interpretation of the Compartment "units" attribute.</caption>
<tr>
<th align="left" valign="bottom">
Value of attribute<br>"spatialDimensions"
</th>
<th align="left" valign="bottom">
Attribute of Model used<br>for inheriting the unit
</th>
<th align="left" valign="bottom">
Recommended candidate units
</th>
</tr>
<tr>
<td>C<3></td>
<td>&quot;volumeUnits&quot;</td>
<td>units of volume, or C<dimensionless></td>
</tr>
<tr>
<td>C<2></td>
<td>&quot;areaUnits&quot;</td>
<td>units of area, or C<dimensionless></td>
</tr>
<tr>
<td>C<1></td>
<td>&quot;lengthUnits&quot;</td>
<td>units of length, or C<dimensionless></td>
</tr>
<tr>
<td><em>other</em></td>
<td><em>no units inherited</em></td>
<td><em>no specific recommendations</em></td>
</tr>
</tr>
</table>

The unit of measurement associated with a compartment's size, as defined
by the "units" attribute or (if "units" is not set) the inherited value
from Model according to the table above, is used in the following ways:
\n=over\n

\n=item\n\nWhen the identifier of the compartment appears as a numerical
quantity in a mathematical formula expressed in MathML, it represents
the size of the compartment, and the unit associated with the size is
the value of the "units" attribute.
\n=item\n\nWhen a Species is to be treated in terms of concentrations or
density, the unit associated with the spatial size portion of the
concentration value (i.e., the denominator in the formula
<em>amount</em>/<em>size</em>) is specified by the value of the "units"
attribute on the compartment in which the species is located.
\n=item\n\nThe "math" elements of AssignmentRule, InitialAssignment and
EventAssignment @if conly structures @else objects@endif@~ setting the
value of the compartment size should all have the same units as the unit
associated with the compartment's size.
\n=item\n\nIn a RateRule @if conly structure @else object@endif@~ that defines a
rate of change for a compartment's size, the unit of the rule's "math"
element should be identical to the compartment's "units" attribute divided
by the model-wide unit of <em>time</em>.  (In other words, {<em>unit of
compartment size</em>}/{<em>unit of time</em>}.)
\n=back\n


@section comp-other Other aspects of Compartment
In SBML Level&nbsp;1 and Level&nbsp;2, Compartment has an optional
attribute named "outside", whose value can be the identifier of another
Compartment @if conly structure @else object@endif@~ defined in the
enclosing Model @if conly structure @else object@endif@~.  Doing so means
that the other compartment contains it or is outside of it.  This enables
the representation of simple topological relationships between
compartments, for those simulation systems that can make use of the
information (e.g., for drawing simple diagrams of compartments).  It is
worth noting that in SBML, there is no relationship between compartment
sizes when compartment positioning is expressed using the "outside"
attribute.  The size of a given compartment does not in any sense include
the sizes of other compartments having it as the value of their "outside"
attributes.  In other words, if a compartment I<B> has the identifier of
compartment I<A> as its "outside" attribute value, the size of I<A> does
not include the size of I<B>.  The compartment sizes are separate.
In Level&nbsp;2, there are two restrictions on the "outside" attribute.
First, because a compartment with "spatialDimensions" of C<0> has no
size, such a compartment cannot act as the container of any other
compartment I<except> compartments that I<also> have
"spatialDimensions" values of C<0>.  Second, the directed graph formed
by representing Compartment structures as vertexes and the "outside"
attribute values as edges must be acyclic.  The latter condition is
imposed to prevent a compartment from being contained inside itself.  In
the absence of a value for "outside", compartment definitions in SBML
Level&nbsp;2 do not have any implied spatial relationships between each
other.

=over


=back

=head2 ListOfCompartments

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html A list of Compartment objects.
C<opydetails> doc_what_is_listof

=over


=item Compartment::Compartment

Creates a new Compartment object using the given SBML C<level> and @p
version values.
@param level an unsigned int, the SBML Level to assign to this Compartment.
@param version an unsigned int, the SBML Version to assign to this
Compartment.

C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item Compartment::Compartment

Creates a new Compartment object using the given SBMLNamespaces object
C<sbmlns>.
C<opydetails> doc_what_are_sbmlnamespaces
It is worth emphasizing that although this constructor does not take an
identifier argument, in SBML Level&nbsp;2 and beyond, the "id"
(identifier) attribute of a Compartment object is required to have a
value.  Thus, callers are cautioned to assign a value after calling this
constructor.  Setting the identifier can be accomplished using the
method @if java Compartment::setId(String id)@else setId()@endif.
@param sbmlns an SBMLNamespaces object.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item Compartment::Compartment

Copy constructor.
This creates a copy of a Compartment object.
@param orig the Compartment instance to copy.


=item Compartment::accept

@internal


=item Compartment::clone

Creates and returns a deep copy of this Compartment object.
@return the (deep) copy of this Compartment object.


=item Compartment::initDefaults

Initializes the fields of this Compartment object to "typical" default
values.

The SBML Compartment component has slightly different aspects and
default attribute values in different SBML Levels and Versions.
This method sets the values to certain common defaults, based
mostly on what they are in SBML Level&nbsp;2.  Specifically:
@li Sets attribute "spatialDimensions" to C<3>
@li Sets attribute "constant" to C<true>
@li (Applies to Level&nbsp;1 models only) Sets attribute "volume" to C<1>.0
@li (Applies to Level&nbsp;3 models only) Sets attribute "units" to C<litre>


=item Compartment::getId

Returns the value of the "id" attribute of this Compartment.
@note Because of the inconsistent behavior of this function with 
respect to assignments and rules, it is now recommended to
use the getIdAttribute() function instead.
C<opydetails> doc_id_attribute
@return the id of this Compartment.
@see getIdAttribute()
@see setIdAttribute(const std::string& sid)
@see isSetIdAttribute()
@see unsetIdAttribute()


=item Compartment::getName

Returns the value of the "name" attribute of this Compartment object.
C<opydetails> doc_get_name


=item Compartment::getCompartmentType

Get the value of the "compartmentType" attribute of this Compartment
object.

@return the value of the "compartmentType" attribute of this
Compartment object as a string.
@note The "compartmentType" attribute is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.
@see isSetCompartmentType()
@see setCompartmentType(@if java String@endif)
@see unsetCompartmentType()


=item Compartment::getSpatialDimensions

Get the number of spatial dimensions of this Compartment object.
@return the value of the "spatialDimensions" attribute of this
Compartment object as an unsigned integer.
C<opydetails> doc_note_spatial_dimensions_as_double
@see getSpatialDimensionsAsDouble()
@see setSpatialDimensions(@if java unsigned int@endif)
@see isSetSpatialDimensions()
@see unsetSpatialDimensions()


=item Compartment::getSpatialDimensionsAsDouble

Get the number of spatial dimensions of this Compartment object,
as a double.
@return the value of the "spatialDimensions" attribute of this
Compartment object as a double, or C<NaN> if this model is not in SBML
Level&nbsp;3 format.
C<opydetails> doc_note_spatial_dimensions_as_double
@see getSpatialDimensions()
@see setSpatialDimensions(@if java unsigned int@endif)
@see isSetSpatialDimensions()
@see unsetSpatialDimensions()


=item Compartment::getSize

Get the size of this Compartment object.
C<opydetails> doc_compartment_both_size_and_volume
@return the value of the "size" attribute ("volume" in Level&nbsp;1) of
this Compartment object as a floating-point number.
@note This method is identical to
@if java Compartment::getVolume()@else getVolume()@endif.
@see getVolume()
@see isSetSize()
@see setSize(@if java double@endif)
@see unsetSize()


=item Compartment::getVolume

Get the volume of this Compartment object.
C<opydetails> doc_compartment_both_size_and_volume
@return the value of the "volume" attribute ("size" in Level&nbsp;2) of
this Compartment object, as a floating-point number.
C<opydetails> doc_note_compartment_volume
@note This method is identical to
@if java Compartment::getSize()@else getSize()@endif.
@see getSize()
@see isSetVolume()
@see setVolume(@if java double@endif)
@see unsetVolume()


=item Compartment::getUnits

Get the units of this Compartment object's size.
The value of an SBML compartment's "units" attribute establishes the
unit of measurement associated with the compartment's size.
@return the value of the "units" attribute of this Compartment object,
as a string.  An empty string indicates that no units have been assigned
to the value of the size.
C<opydetails> doc_note_unassigned_unit_are_not_a_default
@see isSetUnits()
@see setUnits(@if java String@endif)
@see unsetUnits()


=item Compartment::getOutside

Get the identifier, if any, of the Compartment object that is designated
as being outside of I<this> one.
@return the value of the "outside" attribute of this Compartment object.
@note The "outside" attribute is defined in SBML Level&nbsp;1 and
Level&nbsp;2, but does not exist in SBML Level&nbsp;3.
@see isSetOutside()
@see setOutside(@if java String@endif)
@see unsetOutside()


=item Compartment::getConstant

Get the value of the "constant" attribute of this Compartment object.
@return C<true> if this Compartment object's size is flagged as being
constant, C<false> otherwise.
@see isSetConstant()
@see setConstant(@if java bool@endif)


=item Compartment::isSetId

Predicate returning C<true> if this Compartment object's "id" attribute
is set.
C<opydetails> doc_isset_id


=item Compartment::isSetName

Predicate returning C<true> if this Compartment object's "name"
attribute is set.
C<opydetails> doc_isset_name


=item Compartment::isSetCompartmentType

Predicate returning C<true> if this Compartment object's
"compartmentType" attribute is set.
@return C<true> if the "compartmentType" attribute of this Compartment
is set, C<false> otherwise.
@note The "compartmentType" attribute is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.
@see setCompartmentType(@if java String@endif)
@see getCompartmentType()
@see unsetCompartmentType()


=item Compartment::isSetSize

Predicate returning C<true> if this Compartment object's "size"
attribute is set.
This method is similar but not identical to
@if java Compartment::isSetVolume()@else isSetVolume()@endif.  The latter
should be used in the context of SBML Level&nbsp;1 models instead of
@if java Compartment::isSetSize()@else isSetSize()@endif@~
because @if java Compartment::isSetVolume()@else isSetVolume()@endif@~
performs extra processing to take into account the difference in
default values between SBML Levels&nbsp;1 and&nbsp;2.
@return C<true> if the "size" attribute ("volume" in Level&nbsp;2) of
this Compartment object is set, C<false> otherwise.
@see isSetVolume()
@see setSize(@if java double@endif)
@see getSize()
@see unsetSize()


=item Compartment::isSetVolume

Predicate returning C<true> if this Compartment object's "volume"
attribute is set.
This method is similar but not identical to
@if java Compartment::isSetSize()@else isSetSize()@endif.  The latter
should not be used in the context of SBML Level&nbsp;1 models because the
present method performs extra processing to take into account
the difference in default values between SBML Levels&nbsp;1 and&nbsp;2.
@return C<true> if the "volume" attribute ("size" in Level&nbsp;2 and
above) of this Compartment object is set, C<false> otherwise.
C<opydetails> doc_note_compartment_volume
@see isSetSize()
@see getVolume()
@see setVolume(@if java double@endif)
@see unsetVolume()


=item Compartment::isSetUnits

Predicate returning C<true> if this Compartment object's "units"
attribute is set.
@return C<true> if the "units" attribute of this Compartment object is
set, C<false> otherwise.
C<opydetails> doc_note_unassigned_unit_are_not_a_default
@see setUnits(@if java String@endif)
@see getUnits()
@see unsetUnits()


=item Compartment::isSetOutside

Predicate returning C<true> if this Compartment object's "outside"
attribute is set.
@return C<true> if the "outside" attribute of this Compartment object is
set, C<false> otherwise.
@note The "outside" attribute is defined in SBML Level&nbsp;1 and
Level&nbsp;2, but does not exist in SBML Level&nbsp;3.
@see getOutside()
@see setOutside(@if java String@endif)
@see unsetOutside()


=item Compartment::isSetSpatialDimensions

Predicate returning C<true> if this Compartment object's
"spatialDimensions" attribute is set.
@return C<true> if the "spatialDimensions" attribute of this
Compartment object is set, C<false> otherwise.
@see getSpatialDimensions()
@see setSpatialDimensions(@if java unsigned int@endif)
@see unsetSpatialDimensions()


=item Compartment::isSetConstant

Predicate returning C<true> if this Compartment object's "constant"
attribute is set.
@return C<true> if the "constant" attribute of this Compartment object is
set, C<false> otherwise.
@see getConstant()
@see setConstant(@if java bool@endif)


=item Compartment::setId

Sets the value of the "id" attribute of this Compartment object.
The string C<sid> is copied.
C<opydetails> doc_id_attribute
@param sid the string to use as the identifier of this Compartment object. If
the string is C<NULL>, this method will return
@link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@see getId()
@see unsetId()
@see isSetId()


=item Compartment::setName

Sets the value of the "name" attribute of this Compartment object.
C<opydetails> doc_set_name


=item Compartment::setCompartmentType

Sets the "compartmentType" attribute of this Compartment object.
@param sid the identifier of a CompartmentType object defined elsewhere
in this Model. If the string is C<NULL>, this method will return
@link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@note The "compartmentType" attribute is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.
@see isSetCompartmentType()
@see getCompartmentType()
@see unsetCompartmentType()


=item Compartment::setSpatialDimensions

Sets the "spatialDimensions" attribute of this Compartment object.
@param value an unsigned integer indicating the number of dimensions
of this compartment.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@see getSpatialDimensions()
@see isSetSpatialDimensions()
@see unsetSpatialDimensions()


=item Compartment::setSpatialDimensions

Sets the "spatialDimensions" attribute of this Compartment object as a double.
@param value a double indicating the number of dimensions
of this compartment.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@see getSpatialDimensions()
@see isSetSpatialDimensions()
@see unsetSpatialDimensions()


=item Compartment::setSize

Sets the "size" attribute (or "volume" in SBML Level&nbsp;1) of this
Compartment object.
@param value a C<double> representing the size of this compartment
instance in whatever units are in effect for the compartment.
C<opydetails> doc_returns_one_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@note This method is identical to
@if java Compartment::setVolume(double value)@else setVolume()@endif.
@see setVolume(@if java double@endif)
@see getSize()
@see isSetSize()
@see unsetSize()


=item Compartment::setVolume

Sets the "volume" attribute (or "size" in SBML Level&nbsp;2) of this
Compartment object.
This method is identical to
@if java Compartment::setSize(double value)@else setSize()@endif@~
and is provided for compatibility between SBML Level&nbsp;1 and
higher Levels of SBML.
@param value a C<double> representing the volume of this compartment
instance in whatever units are in effect for the compartment.
C<opydetails> doc_returns_one_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
C<opydetails> doc_note_compartment_volume
@see setSize(@if java double@endif)
@see getVolume()
@see isSetVolume()
@see unsetVolume()


=item Compartment::setUnits

Sets the "units" attribute of this Compartment object.
@param sid the identifier of the defined units to use.  If C<sid> is @c
NULL, then this method will return
@link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@see isSetUnits()
@see getUnits()
@see unsetUnits()


=item Compartment::setOutside

Sets the "outside" attribute of this Compartment object.
@param sid the identifier of a compartment that encloses this one. If @p
sid is C<NULL>, then this method will return
@link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@note The "outside" attribute is defined in SBML Level&nbsp;1 and
Level&nbsp;2, but does not exist in SBML Level&nbsp;3.
@see isSetOutside()
@see getOutside()
@see unsetOutside()


=item Compartment::setConstant

Sets the value of the "constant" attribute of this Compartment object.
@param value a boolean indicating whether the size/volume of this
compartment should be considered constant (C<true>) or variable
(C<false>).
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@see isSetConstant()
@see getConstant()


=item Compartment::renameSIdRefs

C<opydoc> doc_renamesidref_common


=item Compartment::renameUnitSIdRefs

C<opydoc> doc_renameunitsidref_common


=item Compartment::unsetName

Unsets the value of the "name" attribute of this Compartment object.
C<opydetails> doc_unset_name


=item Compartment::unsetCompartmentType

Unsets the value of the "compartmentType" attribute of this Compartment object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@note The "compartmentType" attribute is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.
@see setCompartmentType(@if java String@endif)
@see isSetCompartmentType()
@see getCompartmentType()


=item Compartment::unsetConstant

Unsets the value of the "constant" attribute of this Compartment object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@see isSetConstant()
@see setConstant(@if java bool@endif)
@see getConstant()


=item Compartment::unsetSize

Unsets the value of the "size" attribute of this Compartment object.
In SBML Level&nbsp;1, a compartment's volume has a default value (@c
1.0) and therefore <em>should always be set</em>.  Calling this method
on a Level&nbsp;1 model resets the value to C<1>.0 rather than actually
unsetting it.  In Level&nbsp;2, a compartment's "size" is optional with
no default value, and unsetting it will result in the compartment having
no defined size.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@note This method is identical to
@if java Compartment::unsetVolume()@else unsetVolume()@endif.
@see unsetVolume()
@see getSize()
@see isSetSize()
@see setSize(@if java double@endif)


=item Compartment::unsetVolume

Unsets the value of the "volume" attribute of this Compartment object.
This method is identical to
@if java Compartment::unsetSize()@else unsetSize()@endif.  Please refer
to that method's documentation for more information about its behavior.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
C<opydetails> doc_note_compartment_volume
@see unsetSize()
@see getVolume()
@see setVolume(@if java double@endif)
@see isSetVolume()


=item Compartment::unsetUnits

Unsets the value of the "units" attribute of this Compartment object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@see isSetUnits()
@see setUnits(@if java String@endif)
@see getUnits()


=item Compartment::unsetOutside

Unsets the value of the "outside" attribute of this Compartment object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@note The "outside" attribute is defined in SBML Level&nbsp;1 and
Level&nbsp;2, but does not exist in SBML Level&nbsp;3.
@see isSetOutside()
@see getOutside()
@see setOutside(@if java String@endif)


=item Compartment::unsetSpatialDimensions

Unsets the value of the "spatialDimensions" attribute of this
Compartment object.
In SBML Levels prior to Level&nbsp;3, compartments must always have a
value for the number of dimensions.  Consequently, calling this method
on a model of SBML Level 1&ndash;2 will result in a return value of
@link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@note This function is only valid for SBML Level&nbsp;3.
@see getSpatialDimensions()
@see isSetSpatialDimensions()
@see setSpatialDimensions(@if java unsigned int@endif)


=item Compartment::getDerivedUnitDefinition

Constructs and returns a UnitDefinition that corresponds to the units
of this Compartment object's designated size.
C<opydetails> doc_compartment_units
@return a UnitDefinition that expresses the units of this
Compartment object, or C<NULL> if one cannot be constructed.
C<opydetails> doc_note_unit_analysis_depends_on_model
@see isSetUnits()
@see getUnits()


=item Compartment::getDerivedUnitDefinition

Constructs and returns a UnitDefinition that corresponds to the units
of this Compartment object's designated size.
C<opydetails> doc_compartment_units
@return a UnitDefinition that expresses the units of this
Compartment object, or C<NULL> if one cannot be constructed.
C<opydetails> doc_note_unit_analysis_depends_on_model
@see isSetUnits()
@see getUnits()


=item Compartment::getTypeCode

Returns the libSBML type code for this SBML object.
C<opydetails> doc_what_are_typecodes
@return the SBML type code for this object:
@link SBMLTypeCode_t#SBML_COMPARTMENT SBML_COMPARTMENT@endlink (default).
C<opydetails> doc_warning_typecodes_not_unique
@see getElementName()
@see getPackageName()


=item Compartment::getElementName

Returns the XML element name of this object
For Compartment, the XML element name is always C<"compartment">.
@return the name of this element.


=item Compartment::writeElements

@internal


=item Compartment::hasRequiredAttributes

Predicate returning C<true> if all the required attributes for this
Compartment object have been set.
The required attributes for a Compartment object are:
@li "id" (or "name" in SBML Level&nbsp;1)
@li "constant" (in SBML Level&nbsp;3 only)
@return C<true> if the required attributes have been set, C<false>
otherwise.


=item Compartment::addExpectedAttributes

@internal


=item Compartment::readAttributes

@internal


=item Compartment::readL1Attributes

@internal


=item Compartment::readL2Attributes

@internal


=item Compartment::readL3Attributes

@internal


=item Compartment::writeAttributes

@internal


=item Compartment::isExplicitlySetSpatialDimensions

@internal


=item Compartment::isExplicitlySetConstant

@internal


=item ListOfCompartments::ListOfCompartments

Creates a new ListOfCompartments object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level.
@param version the Version within the SBML Level.
C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item ListOfCompartments::ListOfCompartments

Creates a new ListOfCompartments object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfCompartments object to be created.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item ListOfCompartments::clone

Creates and returns a deep copy of this ListOfCompartments object.
@return the (deep) copy of this ListOfCompartments object.


=item ListOfCompartments::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., Compartment objects, if the list is non-empty).
C<opydetails> doc_what_are_typecodes
@return the SBML type code for the objects contained in this ListOf
instance: @link SBMLTypeCode_t#SBML_COMPARTMENT SBML_COMPARTMENT@endlink (default).
@see getElementName()
@see getPackageName()


=item ListOfCompartments::getElementName

Returns the XML element name of this object.
For ListOfCompartments, the XML element name is always
C<"listOfCompartments">.
@return the name of this element.


=item ListOfCompartments::get

Get a Compartment object from the ListOfCompartments.
@param n the index number of the Compartment object to get.
@return the nth Compartment object in this ListOfCompartments.
@see size()


=item ListOfCompartments::get

Get a Compartment object from the ListOfCompartments.
@param n the index number of the Compartment object to get.
@return the nth Compartment object in this ListOfCompartments.
@see size()


=item ListOfCompartments::get

Get a Compartment object from the ListOfCompartments
based on its identifier.
@param sid a string representing the identifier
of the Compartment object to get.
@return Compartment object in this ListOfCompartments
with the given C<sid> or C<NULL> if no such
Compartment object exists.
@see get(unsigned int n)
@see size()


=item ListOfCompartments::get

Get a Compartment object from the ListOfCompartments
based on its identifier.
@param sid a string representing the identifier
of the Compartment object to get.
@return Compartment object in this ListOfCompartments
with the given C<sid> or C<NULL> if no such
Compartment object exists.
@see get(unsigned int n)
@see size()


=item ListOfCompartments::remove

Removes the nth item from this ListOfCompartments items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove.
@see size()


=item ListOfCompartments::remove

Removes item in this ListOfCompartments items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then
C<NULL> is returned.
@param sid the identifier of the item to remove.
@return the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfCompartments::getElementPosition

@internal


=item ListOfCompartments::createObject

@internal


=back

=head2 Species

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html An SBML <em>species</em> &ndash; a pool of entities.
A I<species> in SBML refers to a pool of entities that (a) are
considered indistinguishable from each other for the purposes of the
model, (b) participate in reactions, and (c) are located in a specific
I<compartment>.  The SBML Species object class is intended to represent
these pools.
As with other major constructs in SBML, Species has a mandatory
attribute, "id", used to give the species type an identifier in the
model.  The identifier must be a text string conforming to the identifer
syntax permitted in SBML.  Species also has an optional "name"
attribute, of type C<string>.  The "id" and "name" must be used
according to the guidelines described in the SBML specifications.
The required attribute "compartment" is used to identify the compartment
in which the species is located.  The attribute's value must be the
identifier of an existing Compartment object.  It is important to note
that there is no default value for the "compartment" attribute on
Species; every species in an SBML model must be assigned a compartment
I<explicitly>.  (This also implies that every model with one or more
Species objects must define at least one Compartment object.)
@section species-amounts The initial amount and concentration of a species
The optional attributes "initialAmount" and "initialConcentration", both
having a data type of C<double>, can be used to set the I<initial>
quantity of the species in the compartment where the species is located.
These attributes are mutually exclusive; i.e., <em>only one</em> can
have a value on any given instance of a Species object.  Missing
"initialAmount" and "initialConcentration" values implies that their
values either are unknown, or to be obtained from an external source, or
determined by an InitialAssignment or other SBML construct elsewhere in
the model.
A species' initial quantity in SBML is set by the "initialAmount" or
"initialConcentration" attribute exactly once.  If the "constant"
attribute is C<true>, then the value of the species' quantity is fixed
and cannot be changed except by an InitialAssignment.  These methods
differ in that the "initialAmount" and "initialConcentration" attributes
can only be used to set the species quantity to a literal floating-point
number, whereas the use of an InitialAssignment object allows the value
to be set using an arbitrary mathematical expression (which, thanks to
MathML's expressiveness, may evaluate to a rational number).  If the
species' "constant" attribute is C<false>, the species' quantity value
may be overridden by an InitialAssignment or changed by AssignmentRule
or AlgebraicRule, and in addition, for <em>t &gt; 0</em>, it may also be
changed by a RateRule, Event objects, and as a result of being a
reactant or product in one or more Reaction objects.  (However, some
constructs are mutually exclusive; see the SBML specifications for the
precise details.)  It is not an error to define "initialAmount" or
"initialConcentration" on a species and also redefine the value using an
InitialAssignment, but the "initialAmount" or "initialConcentration"
setting in that case is ignored.  The SBML specifications provide
additional information about the semantics of assignments, rules and
values for simulation time <em>t</em> \f$\leq\f$ <em>0</em>.
SBML Level&nbsp;2 additionally stipulates that in cases where a species'
compartment has a "spatialDimensions" value of C<0> (zero), the species
cannot have a value for "initialConcentration" because the concepts of
concentration and density break down when a container has zero
dimensions.

@section species-units The units of a species' amount or concentration
When the attribute "initialAmount" is set, the unit of measurement
associated with the value of "initialAmount" is specified by the Species
attribute "substanceUnits".  When the "initialConcentration" attribute
is set, the unit of measurement associated with this concentration value
is {<em>unit of amount</em>} divided by {<em>unit of size</em>}, where
the {<em>unit of amount</em>} is specified by the Species
"substanceUnits" attribute, and the {<em>unit of size</em>} is specified
by the "units" attribute of the Compartment object in which the species
is located.  Note that in either case, a unit of <em>amount</em> is
involved and determined by the "substanceUnits" attribute.  Note
<strong>these two attributes alone do not determine the units of the
species when the species identifier appears in a mathematical
expression</strong>; <em>that</em> aspect is determined by the attribute
"hasOnlySubstanceUnits" discussed below.
In SBML Level&nbsp;3, if the "substanceUnits" attribute is not set on a
given Species object instance, then the unit of <em>amount</em> for that
species is inherited from the "substanceUnits" attribute on the
enclosing Model object instance.  If that attribute on Model is not set
either, then the unit associated with the species' quantity is
undefined.

In SBML Level&nbsp;2, if the "substanceUnits" attribute is not set on a
given Species object instance, then the unit of <em>amount</em> for that
species is taken from the predefined SBML unit identifier @c
"substance".  The value assigned to "substanceUnits" must be chosen from
one of the following possibilities: one of the base unit identifiers
defined in SBML, the built-in unit identifier C<"substance">, or the
identifier of a new unit defined in the list of unit definitions in the
enclosing Model object.  The chosen units for "substanceUnits" must be
be C<"dimensionless">, C<"mole">, C<"item">, C<"kilogram">, C<"gram">,
or units derived from these.
As noted at the beginning of this section, simply setting
"initialAmount" or "initialConcentration" alone does I<not> determine
whether a species identifier represents an amount or a concentration
when it appears elsewhere in an SBML model.  The role of the attribute
"hasOnlySubstanceUnits" is to indicate whether the units of the species,
when the species identifier appears in mathematical formulas, are
intended to be concentration or amount.  The attribute takes on a
boolean value.  In SBML Level&nbsp;3, the attribute has no default value
and must always be set in a model; in SBML Level&nbsp;2, it has a
default value of C<false>.
The <em>units of the species</em> are used in the following ways:
\n=over\n

\n=item\n\nWhen the species' identifier appears in a MathML formula, it
represents the species' quantity, and the unit of measurement associated
with the quantity is as described above.
\n=item\n\nThe "math" elements of AssignmentRule, InitialAssignment and
EventAssignment objects referring to this species should all have the
same units as the unit of measurement associated with the species
quantity.

\n=item\n\nIn a RateRule object that defines the rate of change of the
species' quantity, the unit associated with the rule's "math" element
should be equal to the unit of the species' quantity divided by the
model-wide unit of <em>time</em>; in other words, {<em>unit of species
quantity</em>}/{<em>unit of time</em>}.
\n=back\n


@section species-constant The "constant" and "boundaryCondition" attributes
The Species object class has two boolean attributes named "constant" and
"boundaryCondition", used to indicate whether and how the quantity of
that species can vary during a simulation.  In SBML Level&nbsp;2 they
are optional; in SBML Level&nbsp;3 they are mandatory.  The following
table shows how to interpret the combined values of these attributes.
@htmlinclude species-boundarycondition.html
By default, when a species is a product or reactant of one or more
reactions, its quantity is determined by those reactions.  In SBML, it
is possible to indicate that a given species' quantity is <em>not</em>
determined by the set of reactions even when that species occurs as a
product or reactant; i.e., the species is on the <em>boundary</em> of
the reaction system, and its quantity is not determined by the
reactions.  The boolean attribute "boundaryCondition" can be used to
indicate this.  A value of C<false> indicates that the species I<is>
part of the reaction system.  In SBML Level&nbsp;2, the attribute has a
default value of C<false>, while in SBML Level&nbsp;3, it has no
default.

The "constant" attribute indicates whether the species' quantity can be
changed at all, regardless of whether by reactions, rules, or constructs
other than InitialAssignment.  A value of C<false> indicates that the
species' quantity can be changed.  (This is also a common value because
the purpose of most simulations is precisely to calculate changes in
species quantities.)  In SBML Level&nbsp;2, the attribute has a default
value of C<false>, while in SBML Level&nbsp;3, it has no default.  Note
that the initial quantity of a species can be set by an
InitialAssignment irrespective of the value of the "constant" attribute.
In practice, a "boundaryCondition" value of C<true> means a differential
equation derived from the reaction definitions should not be generated
for the species.  However, the species' quantity may still be changed by
AssignmentRule, RateRule, AlgebraicRule, Event, and InitialAssignment
constructs if its "constant" attribute is C<false>.  Conversely, if the
species' "constant" attribute is C<true>, then its value cannot be
changed by anything except InitialAssignment.
A species having "boundaryCondition"=C<false> and "constant"=C<false>
can appear as a product and/or reactant of one or more reactions in the
model.  If the species is a reactant or product of a reaction, it must
I<not> also appear as the target of any AssignmentRule or RateRule
object in the model.  If instead the species has "boundaryCondition"=@c
false and "constant"=C<true>, then it cannot appear as a reactant or
product, or as the target of any AssignmentRule, RateRule or
EventAssignment object in the model.
Finally, it is worth clarifying that while the constant and 
boundaryCondition attributes restrict whether and how the species 
amount changes, the same is not true of a species' concentration. In 
SBML, the concentration of a species is a quantity that depends on the 
size of the compartment in which it is located. A compartment's size 
may change, and therefore, so can the concentration of a species even 
if the amount of the species remains unchanged. A species' concentration 
may therefore vary even if the Species object's constant attribute is 
set to C<true> in a model.
@section species-l2-convfactor The conversionFactor attribute in SBML Level&nbsp;3
In SBML Level&nbsp;3, Species has an additional optional attribute,
"conversionFactor", that defines a conversion factor that applies to a
particular species.  The value must be the identifier of a Parameter
object instance defined in the model.  That Parameter object must be a
constant, meaning its "constant" attribute must be set to C<true>.
If a given Species object definition defines a value for its
"conversionFactor" attribute, it takes precedence over any factor
defined by the Model object's "conversionFactor" attribute.
The unit of measurement associated with a species' quantity can be
different from the unit of extent of reactions in the model.  SBML
Level&nbsp;3 avoids implicit unit conversions by providing an explicit
way to indicate any unit conversion that might be required.  The use of
a conversion factor in computing the effects of reactions on a species'
quantity is explained in detail in the SBML Level&nbsp;3 specification
document.  Because the value of the "conversionFactor" attribute is the
identifier of a Parameter object, and because parameters can have units
attached to them, the transformation from reaction extent units to
species units can be completely specified using this approach.
Note that the unit conversion factor is <strong>only applied when
calculating the effect of a reaction on a species</strong>.  It is not
used in any rules or other SBML constructs that affect the species, and
it is also not used when the value of the species is referenced in a
mathematical expression.
@section species-l2-type The speciesType attribute in SBML Level&nbsp;2 Versions&nbsp;2&ndash;4
In SBML Level&nbsp;2 Versions&nbsp;2&ndash;4, each species in a model
may optionally be designated as belonging to a particular species type.
The optional attribute "speciesType" is used to identify the species
type of the chemical entities that make up the pool represented by the
Species objects.  The attribute's value must be the identifier of an
existing SpeciesType object in the model.  If the "speciesType"
attribute is not present on a particular species definition, it means
the pool contains chemical entities of a type unique to that pool; in
effect, a virtual species type is assumed for that species, and no other
species can belong to that species type.  The value of "speciesType"
attributes on species have no effect on the numerical interpretation of
a model; simulators and other numerical analysis software may ignore
"speciesType" attributes.
There can be only one species of a given species type in any given
compartment of a model.  More specifically, for all Species objects
having a value for the "speciesType" attribute, the pair
<center>
("speciesType" attribute value, "compartment" attribute value)
</center>

must be unique across the set of all Species object in a model.
@section species-other The spatialSizeUnits attribute in SBML Level&nbsp;2 Versions&nbsp;1&ndash;2
In versions of SBML Level&nbsp;2 before Version&nbsp;3, the class
Species included an attribute called "spatialSizeUnits", which allowed
explicitly setting the units of size for initial concentration.  LibSBML
retains this attribute for compatibility with older definitions of
Level&nbsp;2, but its use is strongly discouraged because many software
tools do no properly interpret this unit declaration and it is
incompatible with all SBML specifications after Level&nbsp;2
Version&nbsp;3.


@section species-math Additional considerations for interpreting the numerical value of a species
Species are unique in SBML in that they have a kind of duality: a
species identifier may stand for either substance amount (meaning, a
count of the number of individual entities) or a concentration or
density (meaning, amount divided by a compartment size).  The previous
sections explain the meaning of a species identifier when it is
referenced in a mathematical formula or in rules or other SBML
constructs; however, it remains to specify what happens to a species
when the compartment in which it is located changes in size.
When a species definition has a "hasOnlySubstanceUnits" attribute value
of C<false> and the size of the compartment in which the species is
located changes, the default in SBML is to assume that it is the
concentration that must be updated to account for the size change.  This
follows from the principle that, all other things held constant, if a
compartment simply changes in size, the size change does not in itself
cause an increase or decrease in the number of entities of any species
in that compartment.  In a sense, the default is that the I<amount> of
a species is preserved across compartment size changes.  Upon such size
changes, the value of the concentration or density must be recalculated
from the simple relationship <em>concentration = amount / size</em> if
the value of the concentration is needed (for example, if the species
identifier appears in a mathematical formula or is otherwise referenced
in an SBML construct).  There is one exception: if the species' quantity
is determined by an AssignmentRule, RateRule, AlgebraicRule, or an
EventAssignment and the species has a "hasOnlySubstanceUnits" attribute
value of C<false>, it means that the <em>concentration</em> is assigned
by the rule or event; in that case, the <em>amount</em> must be
calculated when the compartment size changes.  (Events also require
additional care in this situation, because an event with multiple
assignments could conceivably reassign both a species quantity and a
compartment size simultaneously.  Please refer to the SBML
specifications for the details.)
Note that the above only matters if a species has a
"hasOnlySubstanceUnits" attribute value of C<false>, meaning that the
species identifier refers to a concentration wherever the identifier
appears in a mathematical formula.  If instead the attribute's value is
C<true>, then the identifier of the species <em>always</em> stands for
an amount wherever it appears in a mathematical formula or is referenced
by an SBML construct.  In that case, there is never a question about
whether an assignment or event is meant to affect the amount or
concentration: it is always the amount.
A particularly confusing situation can occur when the species has
"constant" attribute value of C<true> in combination with a
"hasOnlySubstanceUnits" attribute value of C<false>.  Suppose this
species is given a value for "initialConcentration".  Does a "constant"
value of C<true> mean that the concentration is held constant if the
compartment size changes?  No; it is still the amount that is kept
constant across a compartment size change.  The fact that the species
was initialized using a concentration value is irrelevant.

=over


=back

=head2 ListOfSpecies

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html A list of Species objects.
C<opydetails> doc_what_is_listof

=over


=item Species::Species

Creates a new Species using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this Species.
@param version an unsigned int, the SBML Version to assign to this
Species.

C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item Species::Species

Creates a new Species using the given SBMLNamespaces object
C<sbmlns>.
C<opydetails> doc_what_are_sbmlnamespaces 
It is worth emphasizing that although this constructor does not take
an identifier argument, in SBML Level&nbsp;2 and beyond, the "id"
(identifier) attribute of a Species is required to have a value.
Thus, callers are cautioned to assign a value after calling this
constructor.  Setting the identifier can be accomplished using the
method Species::setId(@if java String@endif).
@param sbmlns an SBMLNamespaces object.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item Species::Species

Copy constructor; creates a copy of this Species object.
@param orig the object to copy.


=item Species::accept

@internal


=item Species::clone

Creates and returns a deep copy of this Species object.
@return the (deep) copy of this Species object.


=item Species::initDefaults

Initializes the fields of this Species object to "typical" defaults
values.

The SBML Species component has slightly different aspects and
default attribute values in different SBML Levels and Versions.
This method sets the values to certain common defaults, based
mostly on what they are in SBML Level&nbsp;2.  Specifically:
\n=over\n
\n=item\n\nSets "boundaryCondition" to C<false>
\n=item\n\nSets "constant" to C<false>
\n=item\n\nsets "hasOnlySubstanceUnits" to C<false>
\n=item\n\n(Applies to Level&nbsp;3 models only) Sets attribute "substanceUnits" to C<mole>
\n=back\n


=item Species::getId

Returns the value of the "id" attribute of this Species.
@note Because of the inconsistent behavior of this function with 
respect to assignments and rules, it is now recommended to
use the getIdAttribute() function instead.
C<opydetails> doc_id_attribute
@return the id of this Species.
@see getIdAttribute()
@see setIdAttribute(const std::string& sid)
@see isSetIdAttribute()
@see unsetIdAttribute()


=item Species::getName

Returns the value of the "name" attribute of this Species object.
C<opydetails> doc_get_name


=item Species::getSpeciesType

Get the type of this Species object object.
@return the value of the "speciesType" attribute of this
Species as a string.
@note The "speciesType" attribute is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.


=item Species::getCompartment

Get the compartment in which this species is located.
The compartment is designated by its identifier.
@return the value of the "compartment" attribute of this Species
object, as a string.


=item Species::getInitialAmount

Get the value of the "initialAmount" attribute.
@return the initialAmount of this Species, as a float-point number.


=item Species::getInitialConcentration

Get the value of the "initialConcentration" attribute.
@return the initialConcentration of this Species,, as a float-point
number.

@note The attribute "initialConcentration" is only available in SBML
Level&nbsp;2 and&nbsp;3.  It does not exist on Species in Level&nbsp;1.


=item Species::getSubstanceUnits

Get the value of the "substanceUnits" attribute.
@return the value of the "substanceUnits" attribute of this Species,
as a string.  An empty string indicates that no units have been
assigned.

C<opydetails> doc_note_unassigned_unit_are_not_a_default
@see isSetSubstanceUnits()
@see setSubstanceUnits(const std::string& sid)


=item Species::getSpatialSizeUnits

Get the value of the "spatialSizeUnits" attribute.
@return the value of the "spatialSizeUnits" attribute of this Species
object, as a string.
C<opydetails> doc_warning_species_spatialSizeUnits


=item Species::getUnits

Get the value of the "units" attribute.
@return the units of this Species (L1 only).
C<opydetails> doc_note_species_units


=item Species::getHasOnlySubstanceUnits

Get the value of the "hasOnlySubstanceUnits" attribute.
@return C<true> if this Species' "hasOnlySubstanceUnits" attribute
value is nonzero, C<false> otherwise.
@note The "hasOnlySubstanceUnits" attribute does not exist in SBML
Level&nbsp;1.


=item Species::getBoundaryCondition

Get the value of the "boundaryCondition" attribute.
@return C<true> if this Species' "boundaryCondition" attribute value
is nonzero, C<false> otherwise.


=item Species::getCharge

Get the value of the "charge" attribute.
@return the charge of this Species object.
C<opydetails> doc_note_charge_deprecated


=item Species::getConstant

Get the value of the "constant" attribute.
@return C<true> if this Species's "constant" attribute value is
nonzero, C<false> otherwise.
@note The attribute "constant" is only available in SBML Levels&nbsp;2
and&nbsp;3.  It does not exist on Species in Level&nbsp;1.


=item Species::getConversionFactor

Get the value of the "conversionFactor" attribute.
@return the conversionFactor of this Species, as a string.
@note The "conversionFactor" attribute was introduced in SBML
Level&nbsp;3.  It does not exist on Species in SBML Levels&nbsp;1
and&nbsp;2.


=item Species::isSetId

Predicate returning C<true> if this
Species object's "id" attribute is set.
C<opydetails> doc_isset_id


=item Species::isSetName

Predicate returning C<true> if this
Species object's "name" attribute is set.
C<opydetails> doc_isset_name


=item Species::isSetSpeciesType

Predicate returning C<true> if this Species object's
"speciesType" attribute is set.
@return C<true> if the "speciesType" attribute of this Species is
set, C<false> otherwise.
@note The "speciesType" attribute is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.


=item Species::isSetCompartment

Predicate returning C<true> if this
Species object's "compartment" attribute is set.
@return C<true> if the "compartment" attribute of this Species is
set, C<false> otherwise.


=item Species::isSetInitialAmount

Predicate returning C<true> if this
Species object's "initialAmount" attribute is set.
@return C<true> if the "initialAmount" attribute of this Species is
set, C<false> otherwise.
@note In SBML Level&nbsp;1, Species' "initialAmount" is required and
therefore <em>should always be set</em>.  (However, in Level&nbsp;1, the
attribute has no default value either, so this method will not return
C<true> until a value has been assigned.)  In SBML Level&nbsp;2,
"initialAmount" is optional and as such may or may not be set.


=item Species::isSetInitialConcentration

Predicate returning C<true> if this
Species object's "initialConcentration" attribute is set.
@return C<true> if the "initialConcentration" attribute of this Species is
set, C<false> otherwise.
@note The attribute "initialConcentration" is only available in SBML
Level&nbsp;2 and&nbsp;3.  It does not exist on Species in Level&nbsp;1.


=item Species::isSetSubstanceUnits

Predicate returning C<true> if this
Species object's "substanceUnits" attribute is set.
@return C<true> if the "substanceUnits" attribute of this Species is
set, C<false> otherwise.


=item Species::isSetSpatialSizeUnits

Predicate returning C<true> if this
Species object's "spatialSizeUnits" attribute is set.
@return C<true> if the "spatialSizeUnits" attribute of this Species is
set, C<false> otherwise.
C<opydetails> doc_warning_species_spatialSizeUnits


=item Species::isSetUnits

Predicate returning C<true> if
this Species object's "units" attribute is set.
@return C<true> if the "units" attribute of this Species is
set, C<false> otherwise.


=item Species::isSetCharge

Predicate returning C<true> if this
Species object's "charge" attribute is set.
@return C<true> if the "charge" attribute of this Species is
set, C<false> otherwise.
C<opydetails> doc_note_charge_deprecated


=item Species::isSetConversionFactor

Predicate returning C<true> if this
Species object's "conversionFactor" attribute is set.
@return C<true> if the "conversionFactor" attribute of this Species is
set, C<false> otherwise.
@note The "conversionFactor" attribute was introduced in SBML
Level&nbsp;3.  It does not exist on Species in SBML Levels&nbsp;1
and&nbsp;2.


=item Species::isSetBoundaryCondition

Predicate returning C<true> if this
Species object's "boundaryCondition" attribute is set.
@return C<true> if the "boundaryCondition" attribute of this Species is
set, C<false> otherwise.


=item Species::isSetHasOnlySubstanceUnits

Predicate returning C<true> if this
Species object's "hasOnlySubstanceUnits" attribute is set.
@return C<true> if the "hasOnlySubstanceUnits" attribute of this Species is
set, C<false> otherwise.
@note The "hasOnlySubstanceUnits" attribute does not exist in SBML
Level&nbsp;1.


=item Species::isSetConstant

Predicate returning C<true> if this
Species object's "constant" attribute is set.
@return C<true> if the "constant" attribute of this Species is
set, C<false> otherwise.
@note The attribute "constant" is only available in SBML Levels&nbsp;2
and&nbsp;3.  It does not exist on Species in Level&nbsp;1.


=item Species::setId

Sets the value of the "id" attribute of this Species.
C<opydetails> doc_set_id


=item Species::setName

Sets the value of the "name" attribute of this Species.
C<opydetails> doc_set_name


=item Species::setSpeciesType

Sets the "speciesType" attribute of this Species object.
@param sid the identifier of a SpeciesType object defined elsewhere
in this Model.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@note The "speciesType" attribute is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.


=item Species::setCompartment

Sets the "compartment" attribute of this Species object.
@param sid the identifier of a Compartment object defined elsewhere
in this Model.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink


=item Species::setInitialAmount

Sets the "initialAmount" attribute of this Species and marks the field
as set.
This method also unsets the "initialConcentration" attribute.
@param value the value to which the "initialAmount" attribute should
be set.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink


=item Species::setInitialConcentration

Sets the "initialConcentration" attribute of this Species and marks
the field as set.
This method also unsets the "initialAmount" attribute.
@param value the value to which the "initialConcentration" attribute
should be set.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@note The attribute "initialConcentration" is only available in SBML
Level&nbsp;2 and&nbsp;3.  It does not exist on Species in Level&nbsp;1.


=item Species::setSubstanceUnits

Sets the "substanceUnits" attribute of this Species object.
@param sid the identifier of the unit to use.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink


=item Species::setSpatialSizeUnits

(SBML Level&nbsp;2 Versions&nbsp;1&ndash;2) Sets the "spatialSizeUnits" attribute of this Species object.
@param sid the identifier of the unit to use.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
C<opydetails> doc_warning_species_spatialSizeUnits


=item Species::setUnits

(SBML Level&nbsp;1 only) Sets the units of this Species object.
@param sname the identifier of the unit to use.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink


=item Species::setHasOnlySubstanceUnits

Sets the "hasOnlySubstanceUnits" attribute of this Species object.
@param value boolean value for the "hasOnlySubstanceUnits" attribute.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@note The "hasOnlySubstanceUnits" attribute does not exist in SBML
Level&nbsp;1.


=item Species::setBoundaryCondition

Sets the "boundaryCondition" attribute of this Species object.
@param value boolean value for the "boundaryCondition" attribute.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink


=item Species::setCharge

Sets the "charge" attribute of this Species object.
@param value an integer to which to set the "charge" to.
C<opydetails> doc_note_charge_deprecated 
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink


=item Species::setConstant

Sets the "constant" attribute of this Species object.
@param value a boolean value for the "constant" attribute.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@note The attribute "constant" is only available in SBML Levels&nbsp;2
and&nbsp;3.  It does not exist on Species in Level&nbsp;1.


=item Species::setConversionFactor

Sets the value of the "conversionFactor" attribute of this Species object.
The string in C<sid> is copied.
@param sid the new conversionFactor for the Species.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@note The "conversionFactor" attribute was introduced in SBML
Level&nbsp;3.  It does not exist on Species in SBML Levels&nbsp;1
and&nbsp;2.


=item Species::unsetName

Unsets the value of the "name" attribute of this Species object.
C<opydetails> doc_unset_name


=item Species::unsetConstant

Unsets the value of the "constant" attribute of this Species object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@see isSetConstant()
@see setConstant(@if java boolean@endif)
@see getConstant()


=item Species::unsetSpeciesType

Unsets the "speciesType" attribute value of this Species object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@note The attribute "speciesType" is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.


=item Species::unsetInitialAmount

Unsets the "initialAmount" attribute value of this Species object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink


=item Species::unsetInitialConcentration

Unsets the "initialConcentration" attribute value of this Species object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@note The attribute "initialConcentration" is only available in SBML
Level&nbsp;2 and&nbsp;3.  It does not exist on Species in Level&nbsp;1.


=item Species::unsetSubstanceUnits

Unsets the "substanceUnits" attribute value of this Species object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink


=item Species::unsetSpatialSizeUnits

Unsets the "spatialSizeUnits" attribute value of this Species object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
C<opydetails> doc_warning_species_spatialSizeUnits


=item Species::unsetUnits

Unsets the "units" attribute value of this Species object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink


=item Species::unsetCharge

Unsets the "charge" attribute
value of this Species object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
C<opydetails> doc_note_charge_deprecated


=item Species::unsetConversionFactor

Unsets the "conversionFactor" attribute value of this Species object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@note The "conversionFactor" attribute was introduced in SBML
Level&nbsp;3.  It does not exist on Species in SBML Levels&nbsp;1
and&nbsp;2.


=item Species::unsetCompartment

Unsets the "compartment" attribute value of this Species object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink


=item Species::unsetBoundaryCondition

Unsets the "boundaryCondition" attribute value of this Species object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink


=item Species::unsetHasOnlySubstanceUnits

Unsets the "hasOnlySubstanceUnits" attribute value of this Species object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink


=item Species::getDerivedUnitDefinition

Constructs and returns a UnitDefinition that corresponds to the units
of this Species' amount or concentration.
Species in SBML have an attribute ("substanceUnits") for declaring the
units of measurement intended for the species' amount or concentration
(depending on which one applies).  In the absence of a value given for
"substanceUnits", the units are taken from the enclosing Model's
definition of C<"substance"> or C<"substance">/<em>(size of the
compartment)</em> in which the species is located, or finally, if
these are not redefined by the Model, the relevant SBML default units
for those quantities.  Following that procedure, the method
@if java Species::getDerivedUnitDefinition()@else getDerivedUnitDefinition()@endif@~
returns a UnitDefinition based on the
interpreted units of this species's amount or concentration.
Note that the functionality that facilitates unit analysis depends 
on the model as a whole.  Thus, in cases where the object has not 
been added to a model or the model itself is incomplete,
unit analysis is not possible and this method will return C<NULL>.
Note also that unit declarations for Species are in terms of the @em
identifier of a unit, but this method returns a UnitDefinition object,
not a unit identifier.  It does this by constructing an appropriate
UnitDefinition.  Callers may find this particularly useful when used
in conjunction with the helper methods on UnitDefinition for comparing
different UnitDefinition objects.
In SBML Level&nbsp;2 specifications prior to Version&nbsp;3, Species
includes an additional attribute named "spatialSizeUnits", which
allows explicitly setting the units of size for initial concentration.
The @if java Species::getDerivedUnitDefinition()@else getDerivedUnitDefinition()@endif@~
takes this into account for models
expressed in SBML Level&nbsp;2 Versions&nbsp;1 and&nbsp;2.
@return a UnitDefinition that expresses the units of this 
Species, or C<NULL> if one cannot be constructed.
@see getSubstanceUnits()


=item Species::getDerivedUnitDefinition

Constructs and returns a UnitDefinition that corresponds to the units
of this Species' amount or concentration.
Species in SBML have an attribute ("substanceUnits") for declaring the
units of measurement intended for the species' amount or concentration
(depending on which one applies).  In the absence of a value given for
"substanceUnits", the units are taken from the enclosing Model's
definition of C<"substance"> or C<"substance">/<em>(size of the
compartment)</em> in which the species is located, or finally, if
these are not redefined by the Model, the relevant SBML default units
for those quantities.  Following that procedure, the method
@if java Species::getDerivedUnitDefinition()@else getDerivedUnitDefinition()@endif@~
returns a UnitDefinition based on the
interpreted units of this species's amount or concentration.
Note that the functionality that facilitates unit analysis depends 
on the model as a whole.  Thus, in cases where the object has not 
been added to a model or the model itself is incomplete,
unit analysis is not possible and this method will return C<NULL>.
Note also that unit declarations for Species are in terms of the @em
identifier of a unit, but this method returns a UnitDefinition object,
not a unit identifier.  It does this by constructing an appropriate
UnitDefinition.  Callers may find this particularly useful when used
in conjunction with the helper methods on UnitDefinition for comparing
different UnitDefinition objects.
In SBML Level&nbsp;2 specifications prior to Version&nbsp;3, Species
includes an additional attribute named "spatialSizeUnits", which
allows explicitly setting the units of size for initial concentration.
The @if java Species::getDerivedUnitDefinition()@else getDerivedUnitDefinition()@endif@~
takes this into account for models
expressed in SBML Level&nbsp;2 Versions&nbsp;1 and&nbsp;2.
@return a UnitDefinition that expresses the units of this 
Species, or C<NULL> if one cannot be constructed.
@see getSubstanceUnits()


=item Species::getTypeCode

Returns the libSBML type code for this SBML object.
C<opydetails> doc_what_are_typecodes
@return the SBML type code for this object:
@link SBMLTypeCode_t#SBML_SPECIES SBML_SPECIES@endlink (default).
C<opydetails> doc_warning_typecodes_not_unique
@see getElementName()
@see getPackageName()


=item Species::getElementName

Returns the XML element name of this object, which for Species, is
always C<"species">.
@return the name of this element, i.e., C<"species">.


=item Species::writeElements

@internal


=item Species::hasRequiredAttributes

Predicate returning C<true> if
all the required attributes for this Species object
have been set.
The required attributes for a Species object are:
@li "id" (or "name" in SBML Level&nbsp;1)
@li "compartment"
@li "initialAmount" (required in SBML Level&nbsp;1 only; optional otherwise)
@li "hasOnlySubstanceUnits" (required in SBML Level&nbsp;3; optional in SBML Level&nbsp;2)
@li "boundaryCondition" (required in SBML Level&nbsp;3; optional in Levels&nbsp;1 and&nbsp;2)
@li "constant" (required in SBML Level&nbsp;3; optional in SBML Level&nbsp;2)
@return C<true> if the required attributes have been set, C<false>
otherwise.


=item Species::renameSIdRefs

C<opydoc> doc_renamesidref_common


=item Species::renameUnitSIdRefs

C<opydoc> doc_renameunitsidref_common


=item Species::addExpectedAttributes

@internal


=item Species::readAttributes

@internal


=item Species::readL1Attributes

@internal


=item Species::readL2Attributes

@internal


=item Species::readL3Attributes

@internal


=item Species::writeAttributes

@internal


=item Species::isExplicitlySetBoundaryCondition

@internal


=item Species::isExplicitlySetConstant

@internal


=item Species::isExplicitlySetHasOnlySubsUnits

@internal


=item ListOfSpecies::ListOfSpecies

Creates a new ListOfSpecies object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level.
@param version the Version within the SBML Level.
C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item ListOfSpecies::ListOfSpecies

Creates a new ListOfSpecies object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfSpecies object to be created.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item ListOfSpecies::clone

Creates and returns a deep copy of this ListOfSpecies object.
@return the (deep) copy of this ListOfSpecies object.


=item ListOfSpecies::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., Species objects, if the list is non-empty).
C<opydetails> doc_what_are_typecodes
@return the SBML type code for objects contained in this list:
@link SBMLTypeCode_t#SBML_SPECIES SBML_SPECIES@endlink (default).
@see getElementName()
@see getPackageName()


=item ListOfSpecies::getElementName

Returns the XML element name of this object.
For ListOfSpeciess, the XML element name is C<"listOfSpeciess">.
@return the name of this element, i.e., C<"listOfSpeciess">.


=item ListOfSpecies::get

Get a Species from the ListOfSpecies.
@param n the index number of the Species to get.
@return the nth Species in this ListOfSpecies.
@see size()


=item ListOfSpecies::get

Get a Species from the ListOfSpecies.
@param n the index number of the Species to get.
@return the nth Species in this ListOfSpecies.
@see size()


=item ListOfSpecies::get

Get a Species from the ListOfSpecies
based on its identifier.
@param sid a string representing the identifier 
of the Species to get.
@return Species in this ListOfSpecies
with the given C<sid> or C<NULL> if no such
Species exists.
@see get(unsigned int n)
@see size()


=item ListOfSpecies::get

Get a Species from the ListOfSpecies
based on its identifier.
@param sid a string representing the identifier 
of the Species to get.
@return Species in this ListOfSpecies
with the given C<sid> or C<NULL> if no such
Species exists.
@see get(unsigned int n)
@see size()


=item ListOfSpecies::remove

Removes the nth item from this ListOfSpeciess items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove.
@see size()


=item ListOfSpecies::remove

Removes item in this ListOfSpeciess items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove.
@return the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfSpecies::getElementPosition

@internal


=item ListOfSpecies::createObject

@internal


=back

=head2 Parameter

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html An SBML parameter: a named symbol with a value.
A Parameter is used in SBML to define a symbol associated with a value;
this symbol can then be used in mathematical formulas in a model.  By
default, parameters have constant value for the duration of a
simulation, and for this reason are called I<parameters> instead of @em
variables in SBML, although it is crucial to understand that <em>SBML
parameters represent both concepts</em>.  Whether a given SBML
parameter is intended to be constant or variable is indicated by the
value of its "constant" attribute.
SBML's Parameter has a required attribute, "id", that gives the
parameter a unique identifier by which other parts of an SBML model
definition can refer to it.  A parameter can also have an optional
"name" attribute of type C<string>.  Identifiers and names must be used
according to the guidelines described in the SBML specifications.
The optional attribute "value" determines the value (of type C<double>)
assigned to the parameter.  A missing value for "value" implies that
the value either is unknown, or to be obtained from an external source,
or determined by an initial assignment.  The unit of measurement
associated with the value of the parameter can be specified using the
optional attribute "units".  Here we only mention briefly some notable
points about the possible unit choices, but readers are urged to consult
the SBML specification documents for more information:
\n=over\n

\n=item\n\nIn SBML Level&nbsp;3, there are no constraints on the units that
can be assigned to parameters in a model; there are also no units to
inherit from the enclosing Model object (unlike the case for, e.g.,
Species and Compartment).
\n=item\n\nIn SBML Level&nbsp;2, the value assigned to the parameter's "units"
attribute must be chosen from one of the following possibilities: one of
the base unit identifiers defined in SBML; one of the built-in unit
identifiers C<"substance">, C<"time">, C<"volume">, C<"area"> or @c
"length"; or the identifier of a new unit defined in the list of unit
definitions in the enclosing Model structure.  There are no constraints
on the units that can be chosen from these sets.  There are no default
units for parameters.
\n=back\n

The Parameter structure has another boolean attribute named "constant"
that is used to indicate whether the parameter's value can vary during a
simulation.  (In SBML Level&nbsp;3, the attribute is mandatory and must
be given a value; in SBML Levels below Level&nbsp;3, the attribute is
optional.)  A value of C<true> indicates the parameter's value cannot be
changed by any construct except InitialAssignment.  Conversely, if the
value of "constant" is C<false>, other constructs in SBML, such as rules
and events, can change the value of the parameter.
SBML Level&nbsp;3 uses a separate object class, LocalParameter, for
parameters that are local to a Reaction's KineticLaw.  In Levels prior
to SBML Level&nbsp;3, the Parameter class is used both for definitions
of global parameters, as well as reaction-local parameters stored in a
list within KineticLaw objects.  Parameter objects that are local to a
reaction (that is, those defined within the KineticLaw structure of a
Reaction) cannot be changed by rules and therefore are <em>implicitly
always constant</em>; consequently, in SBML Level&nbsp;2, parameter
definitions within Reaction structures should I<not> have their
"constant" attribute set to C<false>.
What if a global parameter has its "constant" attribute set to C<false>,
but the model does not contain any rules, events or other constructs
that ever change its value over time?  Although the model may be
suspect, this situation is not strictly an error.  A value of C<false>
for "constant" only indicates that a parameter I<can> change value, not
that it I<must>.
As with all other major SBML components, Parameter is derived from
SBase, and the methods defined on SBase are available on Parameter.
@note The use of the term I<parameter> in SBML sometimes leads to
confusion among readers who have a particular notion of what something
called "parameter" should be.  It has been the source of heated debate,
but despite this, no one has yet found an adequate replacement term that
does not have different connotations to different people and hence leads
to confusion among I<some> subset of users.  Perhaps it would have been
better to have two constructs, one called I<constants> and the other
called I<variables>.  The current approach in SBML is simply more
parsimonious, using a single Parameter construct with the boolean flag
"constant" indicating which flavor it is.  In any case, readers are
implored to look past their particular definition of a I<parameter> and
simply view SBML's Parameter as a single mechanism for defining both
constants and (additional) variables in a model.  (We write @em
additional because the species in a model are usually considered to be
the central variables.)  After all, software tools are not required to
expose to users the actual names of particular SBML constructs, and
thus tools can present to their users whatever terms their designers
feel best matches their target audience.
In SBML Level&nbsp;3 Version&nbsp;2, many restrictions were lifted 
requiring only Boolean values in Boolean contexts, and numeric
values in numeric contexts.  This means that a Parameter may now
be used as a Boolean, despite canonically having a numeric value.
To be consistent, one should always assign it a value of C<true>
or C<false>, and use it in Boolean contexts exclusively.  It would
be appropriate to give it an SBO value of 602 ('Logical parameter')
if one chooses to do this.
@see ListOfParameters

=over


=back

=head2 ListOfParameters

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html A list of Parameter objects.
C<opydetails> doc_what_is_listof

=over


=item Parameter::Parameter

Creates a new Parameter using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this Parameter.
@param version an unsigned int, the SBML Version to assign to this
Parameter.

C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item Parameter::Parameter

Creates a new Parameter using the given SBMLNamespaces object
C<sbmlns>.
C<opydetails> doc_what_are_sbmlnamespaces 
It is worth emphasizing that although this constructor does not take
an identifier argument, in SBML Level&nbsp;2 and beyond, the "id"
(identifier) attribute of a Parameter is required to have a value.
Thus, callers are cautioned to assign a value after calling this
constructor if no identifier is provided as an argument.  Setting the
identifier can be accomplished using the method
@if java setId(String id)@else setId()@endif.
@param sbmlns an SBMLNamespaces object.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item Parameter::Parameter

Copy constructor; creates a copy of a Parameter.
@param orig the Parameter instance to copy.


=item Parameter::accept

@internal


=item Parameter::clone

Creates and returns a deep copy of this Parameter object.
@return the (deep) copy of this Parameter object.


=item Parameter::initDefaults

Initializes the fields of this Parameter object to "typical" defaults
values.

The SBML Parameter component has slightly different aspects and
default attribute values in different SBML Levels and Versions.  Many
SBML object classes defined by libSBML have an initDefaults() method
to set the values to certain common defaults, based mostly on what
they are in SBML Level&nbsp;2.  In the case of Parameter, this method
only sets the value of the "constant" attribute to C<true>.
@see getConstant()
@see isSetConstant()
@see setConstant(@if java boolean@endif)


=item Parameter::getId

Returns the value of the "id" attribute of this Parameter.
@note Because of the inconsistent behavior of this function with 
respect to assignments and rules, it is now recommended to
use the getIdAttribute() function instead.
C<opydetails> doc_id_attribute
@return the id of this Parameter.
@see getIdAttribute()
@see setIdAttribute(const std::string& sid)
@see isSetIdAttribute()
@see unsetIdAttribute()


=item Parameter::getName

Returns the value of the "name" attribute of this Parameter object.
C<opydetails> doc_get_name


=item Parameter::getValue

Gets the numerical value of this Parameter.
@return the value of the "value" attribute of this Parameter, as a
number of type C<double>.
@note B<It is crucial> that callers not blindly call
Parameter::getValue() without first using Parameter::isSetValue() to
determine whether a value has ever been set.  Otherwise, the value
return by Parameter::getValue() may not actually represent a value
assigned to the parameter.  The reason is simply that the data type
C<double> in a program always has I<some> value.  A separate test is
needed to determine whether the value is a true model value, or
uninitialized data in a computer's memory location.
@see isSetValue()
@see setValue(double value)
@see getUnits()


=item Parameter::getUnits

Gets the units defined for this Parameter.
The value of an SBML parameter's "units" attribute establishes the
unit of measurement associated with the parameter's value.
@return the value of the "units" attribute of this Parameter, as a
string.  An empty string indicates that no units have been assigned.
C<opydetails> doc_note_unassigned_unit_are_not_a_default
@see isSetUnits()
@see setUnits(@if java String@endif)
@see getValue()


=item Parameter::getConstant

Gets the value of the "constant" attribute of this Parameter instance.
@return C<true> if this Parameter is declared as being constant,
C<false> otherwise.
C<opydetails> doc_note_parameter_about_constant
@see isSetConstant()
@see setConstant(@if java boolean@endif)


=item Parameter::isSetId

Predicate returning C<true> if this
Parameter's "id" attribute is set.
C<opydetails> doc_isset_id


=item Parameter::isSetName

Predicate returning C<true> if this
Parameter's "name" attribute is set.
C<opydetails> doc_isset_name


=item Parameter::isSetValue

Predicate returning C<true> if the
"value" attribute of this Parameter is set.
In SBML definitions after SBML Level&nbsp;1 Version&nbsp;1,
parameter values are optional and have no defaults.  If a model read
from a file does not contain a setting for the "value" attribute of a
parameter, its value is considered unset; it does not default to any
particular value.  Similarly, when a Parameter object is created in
libSBML, it has no value until given a value.  The
Parameter::isSetValue() method allows calling applications to
determine whether a given parameter's value has ever been set.
In SBML Level&nbsp;1 Version&nbsp;1, parameters are required to have
values and therefore, the value of a Parameter B<should always be
set>.  In Level&nbsp;1 Version&nbsp;2 and beyond, the value is
optional and as such, the "value" attribute may or may not be set.
@return C<true> if the value of this Parameter is set,
C<false> otherwise.
@see getValue()
@see setValue(double value)


=item Parameter::isSetUnits

Predicate returning C<true> if the
"units" attribute of this Parameter is set.
@return C<true> if the "units" attribute of this Parameter is
set, C<false> otherwise.
C<opydetails> doc_note_unassigned_unit_are_not_a_default


=item Parameter::isSetConstant

Predicate returning C<true> if the
"constant" attribute of this Parameter is set.
@return C<true> if the "constant" attribute of this Parameter is
set, C<false> otherwise.
C<opydetails> doc_note_parameter_about_constant
@see getConstant()
@see setConstant(@if java boolean@endif)


=item Parameter::setId

Sets the value of the "id" attribute of this Parameter.
C<opydetails> doc_set_id


=item Parameter::setName

Sets the value of the "name" attribute of this Parameter.
The string in C<name> is copied.
@param name the new name for the Parameter.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink


=item Parameter::setValue

Sets the "value" attribute of this Parameter to the given C<double>
value and marks the attribute as set.
@param value a C<double>, the value to assign.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink


=item Parameter::setUnits

Sets the "units" attribute of this Parameter to a copy of the given
units identifier C<units>.
@param units a string, the identifier of the units to assign to this
Parameter instance.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink


=item Parameter::setConstant

Sets the "constant" attribute of this Parameter to the given boolean
C<flag>.
@param flag a boolean, the value for the "constant" attribute of this
Parameter instance.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
C<opydetails> doc_note_parameter_about_constant
@see getConstant()
@see isSetConstant()


=item Parameter::unsetName

Unsets the value of the "name" attribute of this Parameter.
C<opydetails> doc_unset_name


=item Parameter::unsetConstant

Unsets the value of the "constant" attribute of this Parameter object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@see isSetConstant()
@see setConstant(@if java boolean@endif)
@see getConstant()


=item Parameter::unsetValue

Unsets the "value" attribute of this Parameter instance.
C<opydetails> doc_returns_one_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
In SBML Level&nbsp;1 Version&nbsp;1, parameters are required to have
values and therefore, the value of a Parameter B<should always be
set>.  In SBML Level&nbsp;1 Version&nbsp;2 and beyond, the value
is optional and as such, the "value" attribute may or may not be set.


=item Parameter::unsetUnits

Unsets the "units" attribute of this Parameter instance.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink


=item Parameter::getDerivedUnitDefinition

Constructs and returns a UnitDefinition that corresponds to the units
of this Parameter's value.
Parameters in SBML have an attribute ("units") for declaring the units
of measurement intended for the parameter's value.  B<No defaults are
defined> by SBML in the absence of a definition for "units".  This
method returns a UnitDefinition object based on the units declared for
this Parameter using its "units" attribute, or it returns C<NULL> if
no units have been declared.
Note that unit declarations for Parameter objects are specified in
terms of the I<identifier> of a unit (e.g., using setUnits()), but
I<this> method returns a UnitDefinition object, not a unit
identifier.  It does this by constructing an appropriate
UnitDefinition.For SBML Level&nbsp;2 models, it will do this even when
the value of the "units" attribute is one of the special SBML
Level&nbsp;2 unit identifiers C<"substance">, C<"volume">, C<"area">,
C<"length"> or C<"time">.  Callers may find this useful in conjunction
with the helper methods provided by the UnitDefinition class for
comparing different UnitDefinition objects.
@return a UnitDefinition that expresses the units of this 
Parameter, or C<NULL> if one cannot be constructed.
@note The libSBML system for unit analysis depends on the model as a
whole.  In cases where the Parameter object has not yet been added to
a model, or the model itself is incomplete, unit analysis is not
possible, and consequently this method will return C<NULL>.
@see isSetUnits()


=item Parameter::getDerivedUnitDefinition

Constructs and returns a UnitDefinition that corresponds to the units
of this Parameter's value.
Parameters in SBML have an attribute ("units") for declaring the units
of measurement intended for the parameter's value.  B<No defaults are
defined> by SBML in the absence of a definition for "units".  This
method returns a UnitDefinition object based on the units declared for
this Parameter using its "units" attribute, or it returns C<NULL> if
no units have been declared.
Note that unit declarations for Parameter objects are specified in
terms of the I<identifier> of a unit (e.g., using setUnits()), but
I<this> method returns a UnitDefinition object, not a unit
identifier.  It does this by constructing an appropriate
UnitDefinition.  For SBML Level&nbsp;2 models, it will do this even
when the value of the "units" attribute is one of the predefined SBML
units C<"substance">, C<"volume">, C<"area">, C<"length"> or @c
"time".  Callers may find this useful in conjunction with the helper
methods provided by the UnitDefinition class for comparing different
UnitDefinition objects.
@return a UnitDefinition that expresses the units of this 
Parameter, or C<NULL> if one cannot be constructed.
@note The libSBML system for unit analysis depends on the model as a
whole.  In cases where the Parameter object has not yet been added to
a model, or the model itself is incomplete, unit analysis is not
possible, and consequently this method will return C<NULL>.
@see isSetUnits()


=item Parameter::getTypeCode

Returns the libSBML type code for this SBML object.
C<opydetails> doc_what_are_typecodes
@return the SBML type code for this object:
@link SBMLTypeCode_t#SBML_PARAMETER SBML_PARAMETER@endlink (default).
C<opydetails> doc_warning_typecodes_not_unique
@see getElementName()
@see getPackageName()


=item Parameter::getElementName

Returns the XML element name of this object, which for Parameter, is
always C<"parameter">.
@return the name of this element, i.e., C<"parameter">.


=item Parameter::writeElements

@internal


=item Parameter::hasRequiredAttributes

Predicate returning C<true> if
all the required attributes for this Parameter object
have been set.
The required attributes for a Parameter object are:
@li "id" (or "name" in SBML Level&nbsp;1)
@li "value" (required in Level&nbsp;1, optional otherwise)
@return C<true> if the required attributes have been set, C<false>
otherwise.


=item Parameter::renameUnitSIdRefs

Renames all the C<UnitSIdRef> attributes on this element.
C<opydetails> doc_what_is_unitsidref
This method works by looking at all unit identifier attribute values
(including, if appropriate, inside mathematical formulas), comparing the
unit identifiers to the value of C<oldid>.  If any matches are found,
the matching identifiers are replaced with C<newid>.  The method does
I<not> descend into child elements.
@param oldid the old identifier.
@param newid the new identifier.


=item Parameter::setCalculatingUnits

@internal


=item Parameter::Parameter

@internal


=item Parameter::addExpectedAttributes

@internal


=item Parameter::readAttributes

@internal


=item Parameter::readL1Attributes

@internal


=item Parameter::readL2Attributes

@internal


=item Parameter::readL3Attributes

@internal


=item Parameter::writeAttributes

@internal


=item Parameter::isExplicitlySetConstant

@internal


=item Parameter::inferUnits

@internal


=item Parameter::inferUnitsFromAssignments

@internal


=item Parameter::inferUnitsFromRules

@internal


=item Parameter::inferUnitsFromReactions

@internal


=item Parameter::inferUnitsFromEvents

@internal


=item Parameter::inferUnitsFromEvent

@internal


=item Parameter::inferUnitsFromKineticLaw

@internal


=item Parameter::getCalculatingUnits

@internal


=item ListOfParameters::ListOfParameters

Creates a new ListOfParameters object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level.
@param version the Version within the SBML Level.
C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item ListOfParameters::ListOfParameters

Creates a new ListOfParameters object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfParameters object to be created.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item ListOfParameters::clone

Creates and returns a deep copy of this ListOfParameters object.
@return the (deep) copy of this ListOfParameters object.


=item ListOfParameters::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., Parameter objects, if the list is non-empty).
C<opydetails> doc_what_are_typecodes
@return the SBML type code for this objects contained in this list:
@link SBMLTypeCode_t#SBML_PARAMETER SBML_PARAMETER@endlink (default).
@see getElementName()
@see getPackageName()


=item ListOfParameters::getElementName

Returns the XML element name of this object.
For ListOfParameters, the XML element name is C<"listOfParameters">.
@return the name of this element, i.e., C<"listOfParameters">.


=item ListOfParameters::get

Returns the Parameter object located at position C<n> within this
ListOfParameters instance.
@param n the index number of the Parameter to get.
@return the nth Parameter in this ListOfParameters.  If the index C<n>
is out of bounds for the length of the list, then C<NULL> is returned.
@see size()
@see get(const std::string& sid)


=item ListOfParameters::get

Returns the Parameter object located at position C<n> within this
ListOfParameters instance.
@param n the index number of the Parameter to get.
@return the nth Parameter in this ListOfParameters.  If the index C<n>
is out of bounds for the length of the list, then C<NULL> is returned.
@see size()
@see get(const std::string& sid)


=item ListOfParameters::get

Returns the first Parameter object matching the given identifier.
@param sid a string, the identifier of the Parameter to get.
@return the Parameter object found.  The caller owns the returned
object and is responsible for deleting it.  If none of the items have
an identifier matching C<sid>, then C<NULL> is returned.
@see get(unsigned int n)
@see size()


=item ListOfParameters::get

Returns the first Parameter object matching the given identifier.
@param sid a string representing the identifier of the Parameter to
get.

@return the Parameter object found.  The caller owns the returned
object and is responsible for deleting it.  If none of the items have
an identifier matching C<sid>, then C<NULL> is returned.
@see get(unsigned int n)
@see size()


=item ListOfParameters::remove

Removes the nth item from this ListOfParameters, and returns a pointer
to it.
@param n the index of the item to remove.
@return the item removed.  The caller owns the returned object and is
responsible for deleting it.  If the index number C<n> is out of
bounds for the length of the list, then C<NULL> is returned.
@see size()


=item ListOfParameters::remove

Removes the first Parameter object in this ListOfParameters
matching the given identifier, and returns a pointer to it.
@param sid the identifier of the item to remove.
@return the item removed.  The caller owns the returned object and is
responsible for deleting it.  If none of the items have an identifier
matching C<sid>, then C<NULL> is returned.


=item ListOfParameters::getElementPosition

@internal


=item ListOfParameters::createObject

@internal


=back

=head2 LocalParameter

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html A parameter inside an SBML <em>reaction</em> definition.
LocalParameter has been introduced in SBML Level&nbsp;3 to serve as the
object class for parameter definitions that are intended to be local to
a Reaction.  Objects of class LocalParameter never appear at the Model
level; they are always contained within ListOfLocalParameters lists
which are in turn contained within KineticLaw objects.
Like its global Parameter counterpart, the LocalParameter object class
is used to define a symbol associated with a value; this symbol can then
be used in a model's mathematical formulas (and specifically, for
LocalParameter, reaction rate formulas).  Unlike Parameter, the
LocalParameter class does not have a "constant" attribute: local
parameters within reactions are I<always> constant.
LocalParameter has one required attribute, "id", to give the
parameter a unique identifier by which other parts of an SBML model
definition can refer to it.  A parameter can also have an optional
"name" attribute of type C<string>.  Identifiers and names must be used
according to the guidelines described in the SBML specifications.
The optional attribute "value" determines the value (of type C<double>)
assigned to the parameter.  A missing value for "value" implies that
the value either is unknown, or to be obtained from an external source,
or determined by an initial assignment.  The unit of measurement
associated with the value of the parameter can be specified using the
optional attribute "units".  Here we only mention briefly some notable
points about the possible unit choices, but readers are urged to consult
the SBML specification documents for more information:
\n=over\n

\n=item\n\nIn SBML Level&nbsp;3, there are no constraints on the units that
can be assigned to parameters in a model; there are also no units to
inherit from the enclosing Model object.
\n=item\n\nIn SBML Level&nbsp;2, the value assigned to the parameter's "units"
attribute must be chosen from one of the following possibilities: one of
the base unit identifiers defined in SBML; one of the built-in unit
identifiers C<"substance">, C<"time">, C<"volume">, C<"area"> or @c
"length"; or the identifier of a new unit defined in the list of unit
definitions in the enclosing Model structure.  There are no constraints
on the units that can be chosen from these sets.  There are no default
units for local parameters.
\n=back\n

As with all other major SBML components, LocalParameter is derived from
SBase, and the methods defined on SBase are available on LocalParameter.
In SBML Level&nbsp;3 Version&nbsp;2, the scope of the LocalParameter 
was expanded slightly to officially encompass the entire Reaction
instead of just the KineticLaw in which it appears.  This has no
effect on models using only SBML Level&nbsp;3 Core constructs,
but has the potential to allow SBML Level&nbsp;3 Packages to
include elements in a Reaction that could reference a
LocalParameter from that Reaction's KineticLaw.  It also means that
no LocalParameter may have the same C<"id"> as a referenced Species
in any SimpleSpeciesReference in that Reaction. 
@warning <span class="warning">LibSBML derives LocalParameter from
Parameter; however, this does not precisely match the object hierarchy
defined by SBML Level&nbsp;3, where LocalParameter is derived directly
from SBase and not Parameter.  We believe this arrangement makes it easier
for libSBML users to program applications that work with both SBML
Level&nbsp;2 and SBML Level&nbsp;3, but programmers should also keep in
mind this difference exists.  A side-effect of libSBML's scheme is that
certain methods on LocalParameter that are inherited from Parameter do not
actually have relevance to LocalParameter objects.  An example of this is
the methods pertaining to Parameter's attribute "constant" (i.e.,
isSetConstant(), setConstant(), and getConstant()).</span>
@see ListOfLocalParameters
@see KineticLaw

=over


=back

=head2 ListOfLocalParameters

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html A list of LocalParameter objects.
C<opydetails> doc_what_is_listof

=over


=item LocalParameter::LocalParameter

Creates a new LocalParameter object with the given SBML C<level> and
C<version> values.
@param level an unsigned int, the SBML Level to assign to this
LocalParameter.

@param version an unsigned int, the SBML Version to assign to this
LocalParameter.

C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item LocalParameter::LocalParameter

Creates a new LocalParameter object with the given SBMLNamespaces
object C<sbmlns>.
C<opydetails> doc_what_are_sbmlnamespaces 
It is worth emphasizing that although this constructor does not take
an identifier argument, in SBML Level&nbsp;2 and beyond, the "id"
(identifier) attribute of a LocalParameter is required to have a value.
Thus, callers are cautioned to assign a value after calling this
constructor if no identifier is provided as an argument.  Setting the
identifier can be accomplished using the method
@if java setId(String id)@else setId()@endif.
@param sbmlns an SBMLNamespaces object.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item LocalParameter::LocalParameter

Copy constructor; creates a copy of a given LocalParameter object.
@param orig the LocalParameter instance to copy.


=item LocalParameter::LocalParameter

Copy constructor; creates a LocalParameter object by copying
the attributes of a given Parameter object.
@param orig the Parameter instance to copy.


=item LocalParameter::accept

@internal


=item LocalParameter::clone

Creates and returns a deep copy of this LocalParameter object.
@return the (deep) copy of this LocalParameter object.


=item LocalParameter::getDerivedUnitDefinition

Constructs and returns a UnitDefinition that corresponds to the units
of this LocalParameter's value.
C<opydetails> doc_localparameter_units
@return a UnitDefinition that expresses the units of this 
LocalParameter, or C<NULL> if one cannot be constructed.
@note The libSBML system for unit analysis depends on the model as a
whole.  In cases where the LocalParameter object has not yet been
added to a model, or the model itself is incomplete, unit analysis is
not possible, and consequently this method will return C<NULL>.
@see isSetUnits()


=item LocalParameter::getDerivedUnitDefinition

Constructs and returns a UnitDefinition that corresponds to the units
of this LocalParameter's value.
C<opydetails> doc_localparameter_units
@return a UnitDefinition that expresses the units of this 
LocalParameter, or C<NULL> if one cannot be constructed.
@note The libSBML system for unit analysis depends on the model as a
whole.  In cases where the LocalParameter object has not yet been
added to a model, or the model itself is incomplete, unit analysis is
not possible, and consequently this method will return C<NULL>.
@see isSetUnits()


=item LocalParameter::getTypeCode

Returns the libSBML type code for this SBML object.
C<opydetails> doc_what_are_typecodes
@return the SBML type code for this object:
@link SBMLTypeCode_t#SBML_LOCAL_PARAMETER SBML_LOCAL_PARAMETER@endlink (default).
C<opydetails> doc_warning_typecodes_not_unique
@see getElementName()
@see getPackageName()


=item LocalParameter::getElementName

Returns the XML element name of this object, which for LocalParameter,
is always C<"localParameter">.
@return the name of this element, i.e., C<"localParameter">.


=item LocalParameter::hasRequiredAttributes

Predicate returning C<true> if all the required attributes for this
LocalParameter object have been set.
The required attributes for a LocalParameter object are:
@li "id"
@li "value"
@return C<true> if the required attributes have been set, C<false>
otherwise.


=item LocalParameter::getConstant

@internal


=item LocalParameter::isSetConstant

@internal


=item LocalParameter::setConstant

@internal


=item LocalParameter::unsetConstant

@internal


=item LocalParameter::addExpectedAttributes

@internal


=item LocalParameter::readAttributes

@internal


=item LocalParameter::readL3Attributes

@internal


=item LocalParameter::writeAttributes

@internal


=item ListOfLocalParameters::ListOfLocalParameters

Creates a new ListOfLocalParameters object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level.
@param version the Version within the SBML Level.
C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item ListOfLocalParameters::ListOfLocalParameters

Creates a new ListOfLocalParameters object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfLocalParameters object to be created.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item ListOfLocalParameters::clone

Creates and returns a deep copy of this ListOfLocalParameters object.
@return the (deep) copy of this ListOfLocalParameters object.


=item ListOfLocalParameters::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., LocalParameter objects, if the list is non-empty).
C<opydetails> doc_what_are_typecodes
@return the SBML type code for the objects contained in this ListOf:
@link SBMLTypeCode_t#SBML_LOCAL_PARAMETER SBML_LOCAL_PARAMETER@endlink (default).
@see getElementName()
@see getPackageName()


=item ListOfLocalParameters::getElementName

Returns the XML element name of this object.
For ListOfLocalParameters, the XML element name is C<"listOfLocalParameters">.
@return the name of this element, i.e., C<"listOfLocalParameters">.


=item ListOfLocalParameters::get

Returns the LocalParameter object located at position C<n> within this
ListOfLocalParameters instance.
@param n the index number of the LocalParameter to get.
@return the nth LocalParameter in this ListOfLocalParameters.  If the
index C<n> is out of bounds for the length of the list, then C<NULL>
is returned.
@see size()
@see get(const std::string& sid)


=item ListOfLocalParameters::get

Returns the LocalParameter object located at position C<n> within this
ListOfLocalParameters instance.
@param n the index number of the LocalParameter to get.
@return the item at position C<n>.  The caller owns the returned
object and is responsible for deleting it.  If the index number C<n>
is out of bounds for the length of the list, then C<NULL> is returned.
@see size()
@see get(const std::string& sid)


=item ListOfLocalParameters::get

Returns the first LocalParameter object matching the given identifier.
@param sid a string, the identifier of the LocalParameter to get.
@return the LocalParameter object found.  The caller owns the returned
object and is responsible for deleting it.  If none of the items have
an identifier matching C<sid>, then C<NULL> is returned.
@see get(unsigned int n)
@see size()


=item ListOfLocalParameters::get

Returns the first LocalParameter object matching the given identifier.
@param sid a string representing the identifier of the LocalParameter
to get.
@return the LocalParameter object found.  The caller owns the returned
object and is responsible for deleting it.  If none of the items have
an identifier matching C<sid>, then C<NULL> is returned.
@see get(unsigned int n)
@see size()


=item ListOfLocalParameters::getElementBySId

Returns the first child element found that has the given C<id> in the
model-wide SId namespace, or C<NULL> if no such object is found.
Note that LocalParameters, while they use the SId namespace, are not in
the model-wide SId namespace, so no LocalParameter object will be
returned from this function (and is the reason we override the base
ListOf::getElementBySId function here).
@param id string representing the id of the object to find.
@return pointer to the first element found with the given C<id>.


=item ListOfLocalParameters::remove

Removes the nth item from this ListOfLocalParameters, and returns a
pointer to it.
@param n the index of the item to remove.
@return the item removed.  The caller owns the returned object and is
responsible for deleting it.  If the index number C<n> is out of
bounds for the length of the list, then C<NULL> is returned.
@see size()
@see remove(const std::string& sid)


=item ListOfLocalParameters::remove

Removes the first LocalParameter object in this ListOfLocalParameters
matching the given identifier, and returns a pointer to it.
@param sid the identifier of the item to remove.
@return the item removed.  The caller owns the returned object and is
responsible for deleting it.  If none of the items have an identifier
matching C<sid>, then C<NULL> is returned.


=item ListOfLocalParameters::getElementPosition

@internal


=item ListOfLocalParameters::createObject

@internal


=back

=head2 InitialAssignment

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html An SBML <em>initial assignment</em>, evaluated once only.
SBML Level 2 Versions 2&ndash;4 and SBML Level&nbsp;3 provide two ways of assigning initial
values to entities in a model.  The simplest and most basic is to set
the values of the appropriate attributes in the relevant components; for
example, the initial value of a model parameter (whether it is a
constant or a variable) can be assigned by setting its "value" attribute
directly in the model definition.  However, this approach is not
suitable when the value must be calculated, because the initial value
attributes on different components such as species, compartments, and
parameters are single values and not mathematical expressions.  In those
situations, the InitialAssignment construct can be used; it permits the
calculation of the value of a constant or the initial value of a
variable from the values of I<other> quantities in a model.
As explained below, the provision of InitialAssignment does not mean
that models necessarily must use this construct when defining initial
values of quantities in a model.  If a value can be set directly using
the relevant attribute of a component in a model, then that
approach may be more efficient and more portable to other software
tools.  InitialAssignment should be used when the other mechanism is
insufficient for the needs of a particular model.
The InitialAssignment construct has some similarities to AssignmentRule.
The main differences are: (a) an InitialAssignment can set the value of
a constant whereas an AssignmentRule cannot, and (b) unlike
AssignmentRule, an InitialAssignment definition only applies up to and
including the beginning of simulation time, i.e., <em>t \f$\leq\f$ 0</em>,
while an AssignmentRule applies at all times.
InitialAssignment has a required attribute, "symbol", whose value must
follow the guidelines for identifiers described in the SBML
specification (e.g., Section 3.3 in the Level 2 Version 4
specification).  The value of this attribute in an InitialAssignment
object can be the identifier of a Compartment, Species, SpeciesReference 
(in SBML Level&nbsp;3),  global Parameter, or (as of SBML 
Level&nbsp;3 Version&nbsp;2) the identifier of a SBML Level&nbsp;3 
package element with mathematical meaning.  The InitialAssignment defines the
initial value of the constant or variable referred to by the "symbol"
attribute.  (The attribute's name is "symbol" rather than "variable"
because it may assign values to constants as well as variables in a
model.)  Note that an initial assignment cannot be made to reaction
identifiers, that is, the "symbol" attribute value of an
InitialAssignment cannot be an identifier that is the "id" attribute
value of a Reaction object in the model.  This is identical to a
restriction placed on rules.
InitialAssignment also has a "math" subelement that contains a
MathML expression used to calculate the value of the constant or the
initial value of the variable.  This subelement is required in SBML
Level&nbsp;2 and SBML Level&nbsp;3 Version&nbsp;1, but the requirement
was relaxed in SBML Level&nbsp;3 Version&nbsp;2, making it optional.
The units of the value computed by the formula in the "math" subelement 
should (in SBML Level&nbsp;2 Version&nbsp;4 and in SBML Level&nbsp;3) 
or must (in previous Versions) be identical to be the
units associated with the identifier given in the "symbol" attribute.
(That is, the units are the units of the species, compartment, or
parameter, as appropriate for the kind of object identified by the value
of "symbol".)
InitialAssignment was introduced in SBML Level 2 Version 2.  It is not
available in SBML Level&nbsp;2 Version&nbsp;1 nor in any version of Level 1.
@section initassign-semantics Semantics of Initial Assignments
The value calculated by an InitialAssignment object overrides the value
assigned to the given symbol by the object defining that symbol.  For
example, if a compartment's "size" attribute is set in its definition,
and the model also contains an InitialAssignment having that
compartment's identifier as its "symbol" attribute value, then the
interpretation is that the "size" assigned in the Compartment object
should be ignored and the value assigned based on the computation
defined in the InitialAssignment.  Initial assignments can take place
for Compartment, Species, global Parameter, SpeciesReference (in 
Level&nbsp;3), and SBML Level&nbsp;3 package elements (in 
Level&nbsp;3 Version&nbsp;2), regardless of the value of their 
"constant" attribute.
The actions of all InitialAssignment objects are in general terms
the same, but differ in the precise details depending on the type
of variable being set:
\n=over\n
\n=item\n\n<em>In the case of a species</em>, an InitialAssignment sets the
referenced species' initial quantity (concentration or amount of
substance) to the value determined by the formula in the "math"
subelement.    The overall units of the formula should (in SBML
Level&nbsp;2 Version&nbsp;4 and in SBML Level&nbsp;3) or must (in previous Versions) be the same
as the units specified for the species.
\n=item\n\n<em>In the case of a compartment</em>, an InitialAssignment sets
the referenced compartment's initial size to the size determined by the
formula in "math".  The overall units of the formula should (in SBML
Level&nbsp;2 Version&nbsp;4 and in SBML Level&nbsp;3) or must (in previous Versions) be the same
as the units specified for the size of the compartment.
\n=item\n\n<em>In the case of a parameter</em>, an InitialAssignment sets the
referenced parameter's initial value to that determined by the formula
in "math".  The overall units of the formula should (in SBML
Level&nbsp;2 Version&nbsp;4 and SBML Level&nbsp;3) or must (in previous Versions) be the same
as the units defined for the parameter.  
\n=item\n\n(For SBML Level&nbsp;3 only) <em>In the case of a species
reference</em>, an initial assignment sets the initial value of the 
stoichiometry of the referenced reactant or product to the value determined 
by the formula in "math".  The unit associated with the value produced by 
the "math" formula should be consistent with the unit "dimensionless",
because reactant and product stoichiometries in reactions are dimensionless
quantities.

<li>(For SBML Level&nbsp;3 Version&nbsp;2 only) <em>In the case 
of an object from an SBML Level&nbsp;3 package</em>, an InitialAssignment 
sets the referenced object's initial value (however such values are 
defined by the package) to the value of the formula in math. The unit 
of measurement associated with the value produced by the formula 
should be the same as that object's units attribute value (if it has 
such an attribute), or be equal to the units of model components of 
that type (if objects of that class are defined by the package as 
having the same units).
\n=back\n

If the symbol attribute of an InitialAssignment object references 
an object in an SBML namespace that is not understood by the 
interpreter reading a given SBML document (that is, if the object 
is defined by an SBML Level&nbsp;3 package that the software does 
not support), the assignment must be ignored--the object's initial 
value will not need to be set, as the interpreter could not understand 
that package. If an interpreter cannot establish whether a referenced 
object is missing from the model or instead is defined in an SBML 
namespace not understood by the interpreter, it may produce a 
warning to the user. (The latter situation may only arise if an SBML 
package is present in the SBML document with a package:required 
attribute of "true".)
In the context of a simulation, initial assignments establish values
that are in effect prior to and including the start of simulation time,
i.e., <em>t \f$\leq\f$ 0</em>.  Section 3.4.8 in the SBML Level&nbsp;2
Version&nbsp;4  and SBML Level&nbsp;3 specifications 
provides information about the interpretation of
assignments, rules, and entity values for simulation time up to and
including the start time <em>t = 0</em>; this is important for
establishing the initial conditions of a simulation if the model
involves expressions containing the <em>delay</em> "csymbol".
There cannot be two initial assignments for the same symbol in a model;
that is, a model must not contain two or more InitialAssignment objects
that both have the same identifier as their "symbol" attribute value.  A
model must also not define initial assignments <em>and</em> assignment
rules for the same entity.  That is, there cannot be <em>both</em> an
InitialAssignment and an AssignmentRule for the same symbol in a model,
because both kinds of constructs apply prior to and at the start of
simulated time---allowing both to exist for a given symbol would
result in indeterminism).
The ordering of InitialAssignment objects is not significant.  The
combined set of InitialAssignment, AssignmentRule and KineticLaw
objects form a set of assignment statements that must be considered as a
whole.  The combined set of assignment statements should not contain
algebraic loops: a chain of dependency between these statements should
terminate.  (More formally, consider the directed graph of assignment
statements where nodes are a model's assignment statements and directed
arcs exist for each occurrence of a symbol in an assignment statement
"math" attribute.  The directed arcs in this graph start from the
statement assigning the symbol and end at the statement that contains
the symbol in their math elements.  Such a graph must be acyclic.)
Finally, it is worth being explicit about the expected behavior in the
following situation.  Suppose (1) a given symbol has a value <em>x</em>
assigned to it in its definition, and (2) there is an initial assignment
having the identifier as its "symbol" value and reassigning the value to
<em>y</em>, <em>and</em> (3) the identifier is also used in the
mathematical formula of a second initial assignment.  What value should
the second initial assignment use?  It is <em>y</em>, the value assigned
to the symbol by the first initial assignment, not whatever value was
given in the symbol's definition.  This follows directly from the
behavior described above: if an InitialAssignment object exists for a
given symbol, then the symbol's value is overridden by that initial
assignment.

=over


=back

=head2 ListOfInitialAssignments

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html A list of InitialAssignment objects.
C<opydetails> doc_what_is_listof

=over


=item InitialAssignment::InitialAssignment

Creates a new InitialAssignment using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this InitialAssignment.
@param version an unsigned int, the SBML Version to assign to this
InitialAssignment.

C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item InitialAssignment::InitialAssignment

Creates a new InitialAssignment using the given SBMLNamespaces object
C<sbmlns>.
C<opydetails> doc_what_are_sbmlnamespaces 
@param sbmlns an SBMLNamespaces object.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item InitialAssignment::InitialAssignment

Copy constructor; creates a copy of this InitialAssignment.
@param orig the object to copy.


=item InitialAssignment::accept

@internal


=item InitialAssignment::clone

Creates and returns a deep copy of this InitialAssignment object.
@return the (deep) copy of this InitialAssignment object.


=item InitialAssignment::getSymbol

Get the value of the "symbol" attribute of this InitialAssignment.
@return the identifier string stored as the "symbol" attribute value
in this InitialAssignment.


=item InitialAssignment::getMath

Get the mathematical formula of this InitialAssignment.
@return an ASTNode, the value of the "math" subelement of this
InitialAssignment, or C<NULL> if the math is not set.


=item InitialAssignment::isSetSymbol

Predicate returning C<true> if this
InitialAssignment's "symbol" attribute is set.
@return C<true> if the "symbol" attribute of this InitialAssignment
is set, C<false> otherwise.


=item InitialAssignment::isSetMath

Predicate returning C<true> if this
InitialAssignment's "math" subelement contains a value.
@return C<true> if the "math" for this InitialAssignment is set,
C<false> otherwise.


=item InitialAssignment::setSymbol

Sets the "symbol" attribute value of this InitialAssignment.
@param sid the identifier of a Species, Compartment or Parameter
object defined elsewhere in this Model.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink


=item InitialAssignment::unsetSymbol

Unsets the "symbol" attribute value of this InitialAssignment.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink


=item InitialAssignment::setMath

Sets the "math" subelement of this InitialAssignment.
The AST passed in C<math> is copied.
@param math an AST containing the mathematical expression to
be used as the formula for this InitialAssignment.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink


=item InitialAssignment::getDerivedUnitDefinition

Calculates and returns a UnitDefinition that expresses the units
of measurement assumed for the "math" expression of this
InitialAssignment.

C<opydetails> doc_initialassignment_units
C<opydetails> doc_note_unit_inference_depends_on_model 
C<opydetails> doc_warning_initialassignment_math_literals
@return a UnitDefinition that expresses the units of the math 
expression of this InitialAssignment, or C<NULL> if one cannot be constructed.
@see containsUndeclaredUnits()


=item InitialAssignment::getDerivedUnitDefinition

Calculates and returns a UnitDefinition that expresses the units
of measurement assumed for the "math" expression of this
InitialAssignment.

C<opydetails> doc_initialassignment_units
C<opydetails> doc_note_unit_inference_depends_on_model 
C<opydetails> doc_warning_initialassignment_math_literals
@return a UnitDefinition that expresses the units of the math 
expression of this InitialAssignment, or C<NULL> if one cannot be constructed.
@see containsUndeclaredUnits()


=item InitialAssignment::containsUndeclaredUnits

Predicate returning C<true> if the math expression of this
InitialAssignment contains parameters/numbers with undeclared units.
@return C<true> if the math expression of this InitialAssignment
includes parameters/numbers 
with undeclared units, C<false> otherwise.
@note A return value of C<true> indicates that the UnitDefinition
returned by InitialAssignment::getDerivedUnitDefinition may not
accurately represent the units of the expression.
@see getDerivedUnitDefinition()


=item InitialAssignment::containsUndeclaredUnits

Predicate returning C<true> if the math expression of this
InitialAssignment contains parameters/numbers with undeclared units.
@return C<true> if the math expression of this InitialAssignment
includes parameters/numbers 
with undeclared units, C<false> otherwise.
@note A return value of C<true> indicates that the UnitDefinition
returned by InitialAssignment::getDerivedUnitDefinition may not
accurately represent the units of the expression.
@see getDerivedUnitDefinition()


=item InitialAssignment::getTypeCode

Returns the libSBML type code for this SBML object.
C<opydetails> doc_what_are_typecodes
@return the SBML type code for this object:
@link SBMLTypeCode_t#SBML_INITIAL_ASSIGNMENT SBML_INITIAL_ASSIGNMENT@endlink (default).
C<opydetails> doc_warning_typecodes_not_unique
@see getElementName()
@see getPackageName()


=item InitialAssignment::getElementName

Returns the XML element name of this object, which for
InitialAssignment, is always C<"initialAssignment">.
@return the name of this element, i.e., C<"initialAssignment">.


=item InitialAssignment::writeElements

@internal


=item InitialAssignment::hasRequiredAttributes

Predicate returning C<true> if all the required attributes for this
InitialAssignment object have been set.
The required attributes for an InitialAssignment object are:
@li "symbol"
@return C<true> if the required attributes have been set, C<false>
otherwise.


=item InitialAssignment::hasRequiredElements

Predicate returning C<true> if all the required elements for this
InitialAssignment object have been set.
@note The required elements for a InitialAssignment object are:
@li "math" inSBML Level&nbsp;2 and Level&nbsp;3 Version&nbsp;1.  
(In SBML Level&nbsp;3 Version&nbsp;2+, it is no longer required.)
@return a boolean value indicating whether all the required
elements for this object have been defined.


=item InitialAssignment::getId

Returns the value of the "symbol" attribute of this InitialAssignment (NOT the "id").
@note Because of the inconsistent behavior of this function with 
respect to assignments and rules, it is now recommended to
use the getIdAttribute() or InitialAssignment::getSymbol() 
functions instead.
The "symbol" attribute of an InitialAssignment indicates the element which
the results of the "math" are to be applied.
@return the symbol of this InitialAssignment.
@see getIdAttribute()
@see setIdAttribute(const std::string& sid)
@see isSetIdAttribute()
@see unsetIdAttribute()
@see getSymbol()


=item InitialAssignment::renameSIdRefs

C<opydoc> doc_renamesidref_common


=item InitialAssignment::renameUnitSIdRefs

C<opydoc> doc_renameunitsidref_common


=item InitialAssignment::replaceSIDWithFunction

@internal


=item InitialAssignment::divideAssignmentsToSIdByFunction

@internal


=item InitialAssignment::multiplyAssignmentsToSIdByFunction

@internal


=item InitialAssignment::readOtherXML

@internal


=item InitialAssignment::addExpectedAttributes

@internal


=item InitialAssignment::readAttributes

@internal


=item InitialAssignment::readL2Attributes

@internal


=item InitialAssignment::readL3Attributes

@internal


=item InitialAssignment::writeAttributes

@internal


=item ListOfInitialAssignments::ListOfInitialAssignments

Creates a new ListOfInitialAssignments object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level.
@param version the Version within the SBML Level.
C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item ListOfInitialAssignments::ListOfInitialAssignments

Creates a new ListOfInitialAssignments object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfInitialAssignments object to be created.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item ListOfInitialAssignments::clone

Creates and returns a deep copy of this ListOfInitialAssignments object.
@return the (deep) copy of this ListOfInitialAssignments object.


=item ListOfInitialAssignments::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., InitialAssignment objects, if the list is non-empty).
C<opydetails> doc_what_are_typecodes
@return the SBML type code for the objects contained in this ListOf:
@link SBMLTypeCode_t#SBML_INITIAL_ASSIGNMENT SBML_INITIAL_ASSIGNMENT@endlink (default).
@see getElementName()
@see getPackageName()


=item ListOfInitialAssignments::getElementName

Returns the XML element name of this object.
For ListOfInitialAssignments, the XML element name is @c
"listOfInitialAssignments".

@return the name of this element, i.e., C<"listOfInitialAssignments">.


=item ListOfInitialAssignments::get

Get a InitialAssignment from the ListOfInitialAssignments.
@param n the index number of the InitialAssignment to get.
@return the nth InitialAssignment in this ListOfInitialAssignments.
@see size()


=item ListOfInitialAssignments::get

Get a InitialAssignment from the ListOfInitialAssignments.
@param n the index number of the InitialAssignment to get.
@return the nth InitialAssignment in this ListOfInitialAssignments.
@see size()


=item ListOfInitialAssignments::get

Get a InitialAssignment from the ListOfInitialAssignments
based on its identifier.
@param sid a string representing the identifier 
of the InitialAssignment to get.
@return InitialAssignment in this ListOfInitialAssignments
with the given C<sid> or C<NULL> if no such
InitialAssignment exists.
@see get(unsigned int n)
@see size()


=item ListOfInitialAssignments::get

Get a InitialAssignment from the ListOfInitialAssignments
based on its identifier.
@param sid a string representing the identifier 
of the InitialAssignment to get.
@return InitialAssignment in this ListOfInitialAssignments
with the given C<sid> or C<NULL> if no such
InitialAssignment exists.
@see get(unsigned int n)
@see size()


=item ListOfInitialAssignments::remove

Removes the nth item from this ListOfInitialAssignments items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove.
@see size()


=item ListOfInitialAssignments::remove

Removes item in this ListOfInitialAssignments items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove.
@return the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfInitialAssignments::getElementBySId

Returns the first child element found that has the given C<id> in the
model-wide SId namespace, or C<NULL> if no such object is found.
Note that InitialAssignments do not actually have IDs, though the
libsbml interface pretends that they do: no initial assignment is
returned by this function.
@param id string representing the id of the object to find.
@return pointer to the first element found with the given C<id>.


=item ListOfInitialAssignments::getElementPosition

@internal


=item ListOfInitialAssignments::createObject

@internal


=back

=head2 Rule

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html Parent class for SBML <em>rules</em> in libSBML.
In SBML, I<rules> provide additional ways to define the values of
variables in a model, their relationships, and the dynamical behaviors
of those variables.  They enable encoding relationships that cannot be
expressed using Reaction nor InitialAssignment objects alone.
The libSBML implementation of rules mirrors the SBML Level&nbsp;3
definition (which is in turn is very similar to the
Level&nbsp;2 Version&nbsp;4 definition), with Rule being the parent
class of three subclasses as explained below.  The Rule class itself
cannot be instantiated by user programs and has no constructor; only the
subclasses AssignmentRule, AlgebraicRule and RateRule can be
instantiated directly.
C<opydetails> doc_rules_general_summary

=over


=back

=head2 ListOfRules

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html A list of Rule objects.
C<opydetails> doc_what_is_listof

=over


=item Rule::Rule

Copy constructor; creates a copy of this Rule.
@param orig the object to copy.


=item Rule::accept

@internal


=item Rule::clone

Creates and returns a deep copy of this Rule object.
@return the (deep) copy of this Rule object.


=item Rule::getFormula

Returns the mathematical expression of this Rule in text-string form.
The text string is produced by
@if java <code><a href="libsbml.html#formulaToString(org.sbml.libsbml.ASTNode)">libsbml.formulaToString()</a></code>@else SBML_formulaToString()@endif; please consult
the documentation for that function to find out more about the format
of the text-string formula.
@return the formula text string for this Rule.
@note The attribute "formula" is specific to SBML Level&nbsp;1; in
higher Levels of SBML, it has been replaced with a subelement named
"math".  However, libSBML provides a unified interface to the
underlying math expression and this method can be used for models
of all Levels of SBML.
@see getMath()


=item Rule::getMath

Get the mathematical formula of this Rule as an ASTNode tree.
@return an ASTNode, the value of the "math" subelement of this Rule,
or NULL if the math is not set.
@note The subelement "math" is present in SBML Levels&nbsp;2
and&nbsp;3.  In SBML Level&nbsp;1, the equivalent construct is the
attribute named "formula".  LibSBML provides a unified interface to
the underlying math expression and this method can be used for models
of all Levels of SBML.
@see getFormula()


=item Rule::getVariable

Get the value of the "variable" attribute of this Rule object.
C<opydetails> doc_rule_level_1
The "variable" attribute of a Rule indicates the element which
the results of the "math" are to be applied.  An AlgebraicRule has
no "variable", and will always return an empty string.
@return the identifier string stored as the "variable" attribute value
in this Rule, or C<NULL> if this object is an AlgebraicRule object, or if 
the attribute is unset.


=item Rule::getUnits

Returns the units for the
mathematical formula of this Rule.
@return the identifier of the units for the expression of this Rule.
@note The attribute "units" exists on SBML Level&nbsp;1 ParameterRule
objects only.  It is not present in SBML Levels&nbsp;2 and&nbsp;3.


=item Rule::isSetFormula

Predicate returning C<true> if this Rule's mathematical expression is
set.

This method is equivalent to isSetMath().  This version is present for
easier compatibility with SBML Level&nbsp;1, in which mathematical
formulas were written in text-string form.
@return C<true> if the mathematical formula for this Rule is
set, C<false> otherwise.
@note The attribute "formula" is specific to SBML Level&nbsp;1; in
higher Levels of SBML, it has been replaced with a subelement named
"math".  However, libSBML provides a unified interface to the
underlying math expression and this method can be used for models
of all Levels of SBML.
@see isSetMath()


=item Rule::isSetMath

Predicate returning C<true> if this Rule's mathematical expression is
set.

This method is equivalent to isSetFormula().
@return C<true> if the formula (or equivalently the math) for this
Rule is set, C<false> otherwise.
@note The subelement "math" is present in SBML Levels&nbsp;2
and&nbsp;3.  In SBML Level&nbsp;1, the equivalent construct is the
attribute named "formula".  LibSBML provides a unified interface to
the underlying math expression and this method can be used for models
of all Levels of SBML.
@see isSetFormula()


=item Rule::isSetVariable

Predicate returning C<true> if this Rule's "variable" attribute is set.
C<opydetails> doc_rule_level_1
@return C<true> if the "variable" attribute value of this Rule is
set, C<false> otherwise.


=item Rule::isSetUnits

Predicate returning C<true> if this Rule's "units" attribute is set.
@return C<true> if the units for this Rule is set, C<false>
otherwise.

@note The attribute "units" exists on SBML Level&nbsp;1 ParameterRule
objects only.  It is not present in SBML Levels&nbsp;2 and&nbsp;3.


=item Rule::setFormula

Sets the "math" subelement of this Rule to an expression in text-string
form.

This is equivalent to setMath(const ASTNode  math).  The provision of
using text-string formulas is retained for easier SBML Level&nbsp;1
compatibility.  The formula is converted to an ASTNode internally.
@param formula a mathematical formula in text-string form.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@note The attribute "formula" is specific to SBML Level&nbsp;1; in
higher Levels of SBML, it has been replaced with a subelement named
"math".  However, libSBML provides a unified interface to the
underlying math expression and this method can be used for models
of all Levels of SBML.
@see setMath(const ASTNode  math)


=item Rule::setMath

Sets the "math" subelement of this Rule to a copy of the given
ASTNode.

@param math the AST structure of the mathematical formula.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@note The subelement "math" is present in SBML Levels&nbsp;2
and&nbsp;3.  In SBML Level&nbsp;1, the equivalent construct is the
attribute named "formula".  LibSBML provides a unified interface to
the underlying math expression and this method can be used for models
of all Levels of SBML.
@see setFormula(const std::string& formula)


=item Rule::setVariable

Sets the "variable" attribute value of this Rule object.
C<opydetails> doc_rule_level_1
@param sid the identifier of a Compartment, Species or Parameter
elsewhere in the enclosing Model object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink


=item Rule::setUnits

Sets the units for this Rule.
@param sname the identifier of the units.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@note The attribute "units" exists on SBML Level&nbsp;1 ParameterRule
objects only.  It is not present in SBML Levels&nbsp;2 and&nbsp;3.


=item Rule::unsetVariable

Unsets the value of the "variable" attribute of this Rule object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@see setVariable(const std::string& sid)
@see isSetVariable()
@see getVariable()


=item Rule::unsetUnits

Unsets the "units" for this Rule.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@note The attribute "units" exists on SBML Level&nbsp;1 ParameterRule
objects only.  It is not present in SBML Levels&nbsp;2 and&nbsp;3.


=item Rule::getDerivedUnitDefinition

Calculates and returns a UnitDefinition that expresses the units of
measurement assumed for the "math" expression of this Rule.
C<opydetails> doc_rule_units 
C<opydetails> doc_note_unit_inference_depends_on_model 
C<opydetails> doc_warning_rule_math_literals
@return a UnitDefinition that expresses the units of the math 
expression of this Rule, or C<NULL> if one cannot be constructed.
@see containsUndeclaredUnits()


=item Rule::getDerivedUnitDefinition

Calculates and returns a UnitDefinition that expresses the units of
measurement assumed for the "math" expression of this Rule.
C<opydetails> doc_rule_units 
C<opydetails> doc_note_unit_inference_depends_on_model 
C<opydetails> doc_warning_rule_math_literals
@return a UnitDefinition that expresses the units of the math 
expression of this Rule, or C<NULL> if one cannot be constructed.
@see containsUndeclaredUnits()


=item Rule::containsUndeclaredUnits

Predicate returning C<true> if the math expression of this Rule contains
parameters/numbers with undeclared units.
@return C<true> if the math expression of this Rule includes
parameters/numbers with undeclared units, C<false> otherwise.
@note A return value of C<true> indicates that the UnitDefinition
returned by getDerivedUnitDefinition() may not accurately represent
the units of the expression.
@see getDerivedUnitDefinition()


=item Rule::containsUndeclaredUnits

Predicate returning C<true> if the math expression of this Rule contains
parameters/numbers with undeclared units.
@return C<true> if the math expression of this Rule includes
parameters/numbers with undeclared units, C<false> otherwise.
@note A return value of C<true> indicates that the UnitDefinition
returned by getDerivedUnitDefinition() may not accurately represent the
units of the expression.
@see getDerivedUnitDefinition()


=item Rule::getType

Returns a code representing the type of rule this is.
@return the rule type, which will be one of the following three possible
values:
@li @link RuleType_t#RULE_TYPE_RATE RULE_TYPE_RATE@endlink
@li @link RuleType_t#RULE_TYPE_SCALAR RULE_TYPE_SCALAR@endlink
@li @link RuleType_t#RULE_TYPE_INVALID RULE_TYPE_INVALID@endlink
@note The attribute "type" on Rule objects is present only in SBML
Level&nbsp;1.  In SBML Level&nbsp;2 and later, the type has been
replaced by subclassing the Rule object.


=item Rule::isAlgebraic

Predicate returning C<true> if this Rule is an AlgebraicRule.
@return C<true> if this Rule is an AlgebraicRule, C<false> otherwise.


=item Rule::isAssignment

Predicate returning C<true> if this Rule is an AssignmentRule.
@return C<true> if this Rule is an AssignmentRule, C<false> otherwise.


=item Rule::isCompartmentVolume

Predicate returning C<true> if this Rule is an CompartmentVolumeRule
or equivalent.
This libSBML method works for SBML Level&nbsp;1 models (where there is
such a thing as an explicit CompartmentVolumeRule), as well as other Levels of
SBML.  For Levels above Level&nbsp;1, this method checks the symbol
being affected by the rule, and returns C<true> if the symbol is the
identifier of a Compartment object defined in the model.
@return C<true> if this Rule is a CompartmentVolumeRule, C<false>
otherwise.


=item Rule::isParameter

Predicate returning C<true> if this Rule is an ParameterRule or
equivalent.

This libSBML method works for SBML Level&nbsp;1 models (where there is
such a thing as an explicit ParameterRule), as well as other Levels of
SBML.  For Levels above Level&nbsp;1, this method checks the symbol
being affected by the rule, and returns C<true> if the symbol is the
identifier of a Parameter object defined in the model.
@return C<true> if this Rule is a ParameterRule, C<false>
otherwise.


=item Rule::isRate

Predicate returning C<true> if this Rule is a RateRule (SBML
Levels&nbsp;2&ndash;3) or has a "type" attribute value of C<"rate">
(SBML Level&nbsp;1).
@return C<true> if this Rule is a RateRule (Level&nbsp;2) or has
type "rate" (Level&nbsp;1), C<false> otherwise.


=item Rule::isScalar

Predicate returning C<true> if this Rule is an AssignmentRule (SBML
Levels&nbsp;2&ndash;3) or has a "type" attribute value of C<"scalar">
(SBML Level&nbsp;1).
@return C<true> if this Rule is an AssignmentRule (Level&nbsp;2) or has
type "scalar" (Level&nbsp;1), C<false> otherwise.


=item Rule::isSpeciesConcentration

Predicate returning C<true> if this Rule is a SpeciesConcentrationRule
or equivalent.
This libSBML method works for SBML Level&nbsp;1 models (where there is
such a thing as an explicit SpeciesConcentrationRule), as well as
other Levels of SBML.  For Levels above Level&nbsp;1, this method
checks the symbol being affected by the rule, and returns C<true> if
the symbol is the identifier of a Species object defined in the model.
@return C<true> if this Rule is a SpeciesConcentrationRule, C<false>
otherwise.


=item Rule::getTypeCode

Returns the libSBML type code for this SBML object.
C<opydetails> doc_what_are_typecodes
@return the SBML type code for this object, either
@link SBMLTypeCode_t#SBML_ASSIGNMENT_RULE SBML_ASSIGNMENT_RULE@endlink,
@link SBMLTypeCode_t#SBML_RATE_RULE SBML_RATE_RULE@endlink, or
@link SBMLTypeCode_t#SBML_ALGEBRAIC_RULE SBML_ALGEBRAIC_RULE@endlink 
for SBML Core.
C<opydetails> doc_warning_typecodes_not_unique
@see getElementName()
@see getPackageName()


=item Rule::getL1TypeCode

Returns the SBML Level&nbsp;1 type code for this Rule object.
This method only applies to SBML Level&nbsp;1 model objects.  If this is
not an SBML Level&nbsp;1 rule object, this method will return
@link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink.
@return the SBML Level&nbsp;1 type code for this Rule (namely,
@link SBMLTypeCode_t#SBML_COMPARTMENT_VOLUME_RULE SBML_COMPARTMENT_VOLUME_RULE@endlink,
@link SBMLTypeCode_t#SBML_PARAMETER_RULE SBML_PARAMETER_RULE@endlink,
@link SBMLTypeCode_t#SBML_SPECIES_CONCENTRATION_RULE SBML_SPECIES_CONCENTRATION_RULE@endlink, or
@link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink).


=item Rule::getElementName

Returns the XML element name of this object.
The returned value can be any of a number of different strings,
depending on the SBML Level in use and the kind of Rule object this
is.  The rules as of libSBML version @htmlinclude libsbml-version.html
are the following:
\n=over\n
\n=item\n\n(Level&nbsp;2 and&nbsp;3) RateRule: returns C<"rateRule">
\n=item\n\n(Level&nbsp;2 and&nbsp;3) AssignmentRule: returns C<"assignmentRule"> 
\n=item\n\n(Level&nbsp;2 and&nbsp;3) AlgebraicRule: returns C<"algebraicRule">
\n=item\n\n(Level&nbsp;1 Version&nbsp;1) SpecieConcentrationRule: returns C<"specieConcentrationRule">
\n=item\n\n(Level&nbsp;1 Version&nbsp;2) SpeciesConcentrationRule: returns C<"speciesConcentrationRule">
\n=item\n\n(Level&nbsp;1) CompartmentVolumeRule: returns C<"compartmentVolumeRule">
\n=item\n\n(Level&nbsp;1) ParameterRule: returns C<"parameterRule">
\n=item\n\nUnknown rule type: returns C<"unknownRule">
\n=back\n

Beware that the last (C<"unknownRule">) is not a valid SBML element
name.

@return the name of this element.


=item Rule::writeElements

@internal


=item Rule::setL1TypeCode

Sets the SBML Level&nbsp;1 type code for this Rule.
@param type the SBML Level&nbsp;1 type code for this Rule. The allowable
values are @link SBMLTypeCode_t#SBML_COMPARTMENT_VOLUME_RULE SBML_COMPARTMENT_VOLUME_RULE@endlink,
@link SBMLTypeCode_t#SBML_PARAMETER_RULE SBML_PARAMETER_RULE@endlink, and
@link SBMLTypeCode_t#SBML_SPECIES_CONCENTRATION_RULE SBML_SPECIES_CONCENTRATION_RULE@endlink.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
if given C<type> value is not one of the above.


=item Rule::hasRequiredElements

Predicate returning C<true> if all the required elements for this Rule
object have been set.
The only required element for a Rule object is the "math" subelement in
SBML Level&nbsp;2 and Level&nbsp;3 Version&nbsp;1.  In SBML Level&nbsp;3
Version&nbsp;2+, it is no longer required.
@return a boolean value indicating whether all the required
elements for this object have been defined.


=item Rule::hasRequiredAttributes

Predicate returning C<true> if all the required attributes for this Rule
object have been set.
The required attributes for a Rule object depend on the type of Rule
it is.  For AssignmentRule and RateRule objects (and SBML
Level&nbsp;1's SpeciesConcentrationRule, CompartmentVolumeRule, and
ParameterRule objects), the required attribute is "variable"; for
AlgebraicRule objects, there is no required attribute.
@return C<true> if the required attributes have been set, C<false>
otherwise.


=item Rule::renameSIdRefs

C<opydoc> doc_renamesidref_common


=item Rule::renameUnitSIdRefs

C<opydoc> doc_renameunitsidref_common


=item Rule::getInternalId

@internal


=item Rule::setInternalId

@internal


=item Rule::getId

Returns the value of the "variable" attribute of this Rule (NOT the "id").
@note Because of the inconsistent behavior of this function with 
respect to assignments and rules, it is now recommended to
use the getIdAttribute() or the getVariable() function instead.
The "variable" attribute of a Rule indicates the element which
the results of the "math" are to be applied.  An AlgebraicRule has
no "variable", and will always return an empty string.
@return the variable of this Rule.
@see getIdAttribute()
@see setIdAttribute(const std::string& sid)
@see isSetIdAttribute()
@see unsetIdAttribute()
@see getVariable()


=item Rule::replaceSIDWithFunction

@internal


=item Rule::divideAssignmentsToSIdByFunction

@internal


=item Rule::multiplyAssignmentsToSIdByFunction

@internal


=item Rule::Rule

@internal


=item Rule::Rule

@internal


=item Rule::readOtherXML

@internal


=item Rule::addExpectedAttributes

@internal


=item Rule::readAttributes

@internal


=item Rule::readL1Attributes

@internal


=item Rule::readL2Attributes

@internal


=item Rule::readL3Attributes

@internal


=item Rule::writeAttributes

@internal


=item ListOfRules::ListOfRules

Creates a new ListOfRules object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level.
@param version the Version within the SBML Level.
C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item ListOfRules::ListOfRules

Creates a new ListOfRules object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfRules object to be created.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item ListOfRules::clone

Creates and returns a deep copy of this ListOfRules object.
@return the (deep) copy of this ListOfRules object.


=item ListOfRules::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., Rule objects, if the list is non-empty).
C<opydetails> doc_what_are_typecodes
@return the SBML type code for objects contained in this list:
@link SBMLTypeCode_t#SBML_RULE SBML_RULE@endlink (default).
@see getElementName()
@see getPackageName()


=item ListOfRules::getElementName

Returns the XML element name of this object.
For ListOfRules, the XML element name is C<"listOfRules">.
@return the name of this element, i.e., C<"listOfRules">.


=item ListOfRules::get

Get a Rule from the ListOfRules.
@param n the index number of the Rule to get.
@return the nth Rule in this ListOfRules.
@see size()


=item ListOfRules::get

Get a Rule from the ListOfRules.
@param n the index number of the Rule to get.
@return the nth Rule in this ListOfRules.
@see size()


=item ListOfRules::get

Get a Rule from the ListOfRules based on its identifier.
@param sid a string representing the identifier of the Rule to get.
@return Rule in this ListOfRules with the given C<id> or C<NULL> if no
such Rule exists.
@see get(unsigned int n)
@see size()


=item ListOfRules::get

Get a Rule from the ListOfRules based on its identifier.
@param sid a string representing the identifier of the Rule to get.
@return Rule in this ListOfRules with the given C<sid> or C<NULL> if no
such Rule exists.
@see get(unsigned int n)
@see size()


=item ListOfRules::remove

Removes the nth item from this ListOfRules items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove.
@see size()


=item ListOfRules::getElementBySId

Returns the first child element found that has the given C<id> in the
model-wide SId namespace, or C<NULL> if no such object is found.
Note that AssignmentRules and RateRules do not actually have IDs, but
the libsbml interface pretends that they do: no assignment rule or rate
rule is returned by this function.
@param id string representing the id of the object to find.
@return pointer to the first element found with the given C<id>.


=item ListOfRules::remove

Removes item in this ListOfRules items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove.
@return the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfRules::getElementPosition

@internal


=item ListOfRules::createObject

@internal


=item ListOfRules::isValidTypeForList

@internal


=back

=head2 AlgebraicRule

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html An SBML <em>algebraic rule</em> representing <em>0 = f(B<W>)</em>.
The rule type AlgebraicRule is derived from the parent class Rule.  It
is used to express equations that are neither assignments of model
variables nor rates of change.  AlgebraicRule does not add any
attributes to the basic Rule; its role is simply to distinguish this
case from the other cases.
In the context of a simulation, algebraic rules are in effect at all
times, <em>t</em> \f$\geq\f$ <em>0</em>.  For purposes of evaluating
expressions that involve the delay "csymbol" (see the SBML
specification), algebraic rules are considered to apply also at
<em>t</em> \f$\leq\f$ <em>0</em>.  Please consult the relevant SBML
specification for additional information about the semantics of
assignments, rules, and entity values for simulation time <em>t</em>
\f$\leq\f$ <em>0</em>.
An SBML model must not be overdetermined.  The ability to define
arbitrary algebraic expressions in an SBML model introduces the
possibility that a model is mathematically overdetermined by the overall
system of equations constructed from its rules, reactions and events.
Therefore, if an algebraic rule is introduced in a model, for at least
one of the entities referenced in the rule's "math" element the value of
that entity must not be completely determined by other constructs in the
model.  This means that at least this entity must not have the attribute
"constant"=C<true> and there must also not be a rate rule or assignment
rule for it.  Furthermore, if the entity is a Species object, its value
must not be determined by reactions, which means that it must either
have the attribute "boundaryCondition"=C<true> or else not be involved
in any reaction at all.  These restrictions are explained in more detail
in the SBML specification documents.
In SBML Levels 2 and&nbsp;3, Reaction object identifiers can be
referenced in the "math" expression of an algebraic rule, but reaction
rates can never be <em>determined</em> by algebraic rules.  This is true
even when a reaction does not contain a KineticLaw
@if conly structure @else object@endif.  (In such cases of missing
kinetic law definitions, the model is valid but incomplete; the rates of
reactions lacking kinetic laws are simply undefined, and not determined by
the algebraic rule.)
In SBML Level&nbsp;2 and Level&nbsp;3 Version&nbsp;1, the "math"
subelement of the AlgebraicRule is required.  In SBML Level&nbsp;3
Version&nbsp;2, this rule is relaxed, and the subelement is
optional.  If an AlgebraicRule with no "math" child is present
in the model, no additional mathematical constraints on the model are
added by the rule.  This may represent a situation where the model itself
is unfinished, or the missing information may be provided by an
SBML Level&nbsp;3 package.
Finally, any symbol that appears as the target of a rateOf csymbol 
(@link ASTNodeType_t#AST_FUNCTION_RATE_OF AST_FUNCTION_RATE_OF@endlink, introduced in 
SBML Level&nbsp;3 Version&nbsp;2) may 
not be determined by an AlgebraicRule. This is because the rateOf 
csymbol is defined as applying only to symbols whose rates of change 
are easily determinable.
Users should note that these rules about what symbols may not be 
determined by an AlgebraicRule may be used to discover what symbol 
is being determined by an AlgebraicRule. If three symbols appear in 
the math element of an AlgebraicRule, the first of which is flagged 
constant=C<true>, and the second of which appears as the target of a
rateOf csymbol, one may conclude that the AlgebraicRule must be used 
to determine the value of the third symbol. This is, in fact, a 
principle use (outside of validation) of the constant attribute: its 
use in allowing software to properly identify the dependent variable 
in an AlgebraicRule.
C<opydetails> doc_rules_general_summary

=over


=item AlgebraicRule::AlgebraicRule

Creates a new AlgebraicRule object using the given SBML C<level> and @p
version values.
@param level the SBML Level to assign to this AlgebraicRule object.
@param version the SBML Version to assign to this AlgebraicRule object.
C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item AlgebraicRule::AlgebraicRule

Creates a new AlgebraicRule object using the given SBMLNamespaces object
C<sbmlns>.
C<opydetails> doc_what_are_sbmlnamespaces 
@param sbmlns an SBMLNamespaces object.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item AlgebraicRule::clone

Creates and returns a deep copy of this AlgebraicRule object.
@return the (deep) copy of this Rule object.


=item AlgebraicRule::accept

@internal


=item AlgebraicRule::setInternalIdOnly

@internal


=item AlgebraicRule::getInternalIdOnly

@internal


=item AlgebraicRule::hasRequiredAttributes

Predicate returning C<true> if all the required attributes for this
AlgebraicRule object have been set.
In SBML Levels&nbsp;2&ndash;3, there is no required attribute
for an AlgebraicRule object.  For Level&nbsp;1, the only required
attribute is "formula".
@return C<true> if the required attributes have been set, C<false>
otherwise.


=back

=head2 AssignmentRule

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html An SBML <em>assignment rule</em> representing <em>x = f(B<Y>)</em>.
The rule type AssignmentRule is derived from the parent class Rule.  It
is used to express equations that set the values of variables.  The
left-hand side (the attribute named "variable") of an assignment rule
must refer to the identifier of a Species, SpeciesReference (in SBML
Level&nbsp;3), Compartment, or global Parameter
@if conly structure @else object@endif@~ in the model (but not a
Reaction).  In SBML Level&nbsp;3 Version&nbsp;2, it may also refer to
the SId of an element defined in an SBML Level&nbsp;3 package with 
mathematical meaning and the ability to be assigned.
The entity identified must have its "constant" attribute set
to C<false>.  The effects of an assignment rule construct are in general
terms the same, but differ in the precise details depending on the type of
SBML component being set:
\n=over\n

\n=item\n\n<em>In the case of a species</em>, an SBML assignment rule sets the
referenced species' quantity (whether a "concentration" or "amount") to
the value determined by the formula in the MathML subelement "math".
The unit associated with the value produced by the "math" formula @em
should (in SBML Level&nbsp;2 Version&nbsp;4 and in SBML Level&nbsp;3) or I<must> (in
SBML releases prior to Level&nbsp;2 version&nbsp;4) be equal to the unit
associated with the species' quantity.  <em>Restrictions</em>: There
must not be both an AssignmentRule "variable" attribute and a
SpeciesReference "species" attribute having the same value in a model,
unless the referenced Species @if conly structure @else object@endif@~ has
its "boundaryCondition" attribute set to C<true>.  In other words, an
assignment rule cannot be defined for a species that is created or
destroyed in a reaction unless that species is defined as a boundary
condition in the model.
\n=item\n\n(For SBML Level&nbsp;3 only) <em>In the case of a species
reference</em>, an assignment rule sets the stoichiometry of the
referenced reactant or product to the value determined by the formula in
"math".  The unit associated with the value produced by the "math"
formula should be consistent with the unit "dimensionless", because
reactant and product stoichiometries in reactions are dimensionless
quantities.

\n=item\n\n<em>In the case of a compartment</em>, an SBML assignment rule sets
the referenced compartment's size to the value determined by the formula
in the "math" subelement of the AssignmentRule
@if conly structure @else object@endif@~.  The overall units of the
formula in "math" I<should> (in SBML Level&nbsp;2 Version&nbsp;4 and in
SBML Level&nbsp;3) or I<must> (in SBML releases prior to Level&nbsp;2
version&nbsp;4) be the same as the units of the size of the compartment.
\n=item\n\n<em>In the case of a parameter</em>, an assignment rule sets the
referenced parameter's value to that determined by the formula in the
"math" subelement of the AssignmentRule
@if conly structure @else object@endif@~.  The overall units of the
formula in the "math" subelement I<should> (in SBML Level&nbsp;2
Version&nbsp;4 and in SBML Level&nbsp;3) or I<must> (in SBML releases
prior to Level&nbsp;2 version&nbsp;4) be the same as the units defined for
the parameter.  
\n=item\n\n(For SBML Level&nbsp;3 Version&nbsp;2 only) <em>In the case of 
an object from an SBML Level&nbsp;3 package</em>, an AssignmentRule sets 
the referenced object's value (as defined by that package) to the 
value of the formula in math. The unit of measurement associated 
with the value produced by the formula should be the same as that 
object's units attribute value (if it has such an attribute), or be 
equal to the units of model components of that type (if objects of 
that class are defined by the package as having the same units).
\n=back\n

In SBML Level&nbsp;2 and Level&nbsp;3 Version&nbsp;1, the "math" 
subelement of the AssignmentRule is required.  In SBML Level&nbsp;3
Version&nbsp;2, this rule is relaxed, and the subelement is
optional.  If an AssignmentRule with no "math" child is present
in the model, the value of its referenced "variable" is 
undefined.  This may represent a situation where the model itself
is unfinished, or the missing information may be provided by an
SBML Level&nbsp;3 package.
If the variable attribute of an AssignmentRule object references an 
object in an SBML namespace not understood by the interpreter reading 
a given SBML document (that is, if the object is defined by an SBML 
Level&nbsp;3 package that the software does not support), the assignment 
rule must be ignored--the object's value will not need to be set, as the 
interpreter could not understand that package. If an interpreter cannot 
establish whether a referenced object is missing from the model or 
instead is defined in an SBML namespace not understood by the interpreter, 
it may produce a warning to the user. (The latter situation may only 
arise if an SBML package is present in the SBML document with a 
package:required attribute of "true".)
In the context of a simulation, assignment rules are in effect at all
times, <em>t</em> \f$\geq\f$ <em>0</em>.  For purposes of evaluating
expressions that involve the <em>delay</em> "csymbol" (see the SBML
Level&nbsp;2 specification), assignment rules are considered to apply
also at <em>t</em> \f$\leq\f$ <em>0</em>.  Please consult the relevant
SBML specification for additional information about the semantics of
assignments, rules, and entity values for simulation time <em>t</em>
\f$\leq\f$ <em>0</em>.
A model must not contain more than one AssignmentRule or RateRule
@if conly structure @else object@endif@~ having the same value of
"variable"; in other words, in the set of all assignment rules and rate
rules in an SBML model, each variable appearing in the left-hand sides can
only appear once.  This simply follows from the fact that an indeterminate
system would result if a model contained more than one assignment rule for
the same variable or both an assignment rule and a rate rule for the same
variable.

Similarly, a model must also not contain <em>both</em> an AssignmentRule
and an InitialAssignment definition for the same variable, because both
kinds of constructs apply prior to and at the start of simulation time,
i.e., <em>t</em> \f$\leq\f$ <em>0</em>.  If a model contained both an
initial assignment and an assignment rule for the same variable, an
indeterminate system would result.
The value calculated by an AssignmentRule
@if conly structure @else object@endif@~ overrides the value assigned to
the given symbol by the model component defining that symbol.  For
example, if a Compartment @if conly structure @else object@endif's
"size" attribute value is set in its definition, and the model also
contains an AssignmentRule @if conly structure @else object@endif@~ 
having that compartment's "id" as its "variable" value, then the "size"
assigned in the Compartment @if conly structure @else object@endif@~
definition is ignored and the value assigned based on the computation
defined in the AssignmentRule.  This does <em>not</em> mean that a
definition for a given symbol can be omitted if there is an AssignmentRule
@if conly structure @else object@endif@~ involving it.  For example, 
there must be a Parameter @if conly structure @else object@endif@~
definition for a given parameter if there is an AssignmentRule definition
for that parameter.  It is only a question of which value definition takes
precedence.

C<opydetails> doc_rules_general_summary

=over


=item AssignmentRule::AssignmentRule

Creates a new AssignmentRule using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this AssignmentRule.
@param version an unsigned int, the SBML Version to assign to this
AssignmentRule.

C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item AssignmentRule::AssignmentRule

Creates a new AssignmentRule using the given SBMLNamespaces object
C<sbmlns>.
C<opydetails> doc_what_are_sbmlnamespaces
@param sbmlns an SBMLNamespaces object.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item AssignmentRule::clone

Creates and returns a deep copy of this AssignmentRule object.
@return the (deep) copy of this Rule object.


=item AssignmentRule::accept

@internal


=item AssignmentRule::hasRequiredAttributes

Predicate returning C<true> if all the required attributes for this
AssignmentRule object have been set.
In SBML Levels&nbsp;2&ndash;3, the only required attribute for
an AssignmentRule object is "variable".  For Level&nbsp;1, where the
equivalent attribute is known by different names ("compartment",
"species", or "name", depending on the type of object), there is an
additional required attribute called "formula".
@return C<true> if the required attributes have been set, C<false>
otherwise.


=item AssignmentRule::renameSIdRefs

C<opydoc> doc_renamesidref_common


=back

=head2 RateRule

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html An SBML <em>rate rule</em> representing <em>dx/dt = f(B<Y>)</em>.
The rule type RateRule is derived from the parent class Rule.  It is
used to express equations that determine the rates of change of
variables.  The left-hand side (the "variable" attribute) can refer to
the identifier of a species, compartment, or parameter (but not a
reaction).  The entity identified must have its "constant" attribute set
to C<false>.  The effects of a RateRule are in general terms the same,
but differ in the precise details depending on which variable is being
set:

\n=over\n \n=item\n\n<em>In the case of a species</em>, a RateRule sets the rate of
change of the species' quantity (<em>concentration</em> or <em>amount of
substance</em>) to the value determined by the formula in the "math"
subelement of the RateRule object.  The overall units of the formula in
"math" I<should> (in SBML Level&nbsp;2 Version&nbsp;4 and in SBML Level&nbsp;3) or @em
must (in SBML releases prior to Level&nbsp;2 version&nbsp;4) be equal to
the unit of <em>species quantity</em> divided by the model-wide unit of
<em>time</em>.  <em>Restrictions</em>: There must not be both a RateRule
"variable" attribute and a SpeciesReference "species" attribute having
the same value, unless that species has its "boundaryCondition"
attribute is set to C<true>.  This means a rate rule cannot be defined
for a species that is created or destroyed in a reaction, unless that
species is defined as a boundary condition in the model.
\n=item\n\n(For SBML Level&nbsp;3 only) <em>In the case of a species
reference</em>, a RateRule sets the rate of change of the stoichiometry
of the referenced reactant or product to the value determined by the
formula in "math".  The unit associated with the value produced by the
"math" formula should be consistent with the unit "dimensionless"
divided by the model-wide unit of <em>time</em>.
\n=item\n\n<em>In the case of a compartment</em>, a RateRule sets the rate of
change of the compartment's size to the value determined by the formula
in the "math" subelement of the RateRule object.  The overall units of
the formula I<should> (in SBML Level&nbsp;2 Version&nbsp;4 and in SBML
Level&nbsp;3) or I<must> (in SBML releases prior to Level&nbsp;2
version&nbsp;4) be the units of the compartment's <em>size</em> divided
by the model-wide unit of <em>time</em>.
\n=item\n\n<em>In the case of a parameter</em>, a RateRule sets the rate of
change of the parameter's value to that determined by the formula in the
"math" subelement of the RateRule object.  The overall units of the
formula I<should> (in SBML Level&nbsp;2 Version&nbsp;4 and in SBML
Level&nbsp;3) or I<must> (in SBML releases prior to Level&nbsp;2
version&nbsp;4) be the Parameter object's "unit" attribute value divided
by the model-wide unit of <em>time</em>.  
\n=item\n\n(For SBML Level&nbsp;3 Version&nbsp;2 only) <em>In the case of 
an object from an SBML Level&nbsp;3 package</em>, a RateRule sets the rate 
of change of the referenced object's value (as defined by that package) 
to the value of the formula in "math".  The unit of measurement associated 
with the value produced by the formula should be the same as that object's 
units attribute value (if it has such an attribute) divided by the 
model-wide unit of I<time>, or be equal to the units of model components 
of that type (if objects of that class are defined by the package as having 
the same units) divided by the model-wide unit of I<time>.
\n=back\n

In SBML Level&nbsp;2 and Level&nbsp;3 Version&nbsp;1, the "math" 
subelement of the RateRule is required.  In SBML Level&nbsp;3
Version&nbsp;2, this rule is relaxed, and the subelement is
optional.  If a RateRule with no "math" child is present in the model, 
the rate at which its referenced "variable" changes over time is 
undefined.  This may represent a situation where the model itself
is unfinished, or the missing information may be provided by an
SBML Level&nbsp;3 package.
If the variable attribute of a RateRule object references an object in 
an SBML namespace that is not understood by the interpreter reading a 
given SBML document (that is, if the object is defined by an SBML 
Level&nbsp;3 package that the software does not support), the rate rule 
must be ignored--the object's value will not need to be set, as the 
interpreter could not understand that package. If an interpreter cannot 
establish whether a referenced object is missing from the model or 
instead is defined in an SBML namespace not understood by the interpreter, 
it may produce a warning to the user. (The latter situation may only 
arise if an SBML package is present in the SBML document with a 
package:required attribute of "true".)
In the context of a simulation, rate rules are in effect for simulation
time <em>t</em> &gt; <em>0</em>.  Please consult the relevant SBML
specification for additional information about the semantics of
assignments, rules, and entity values for simulation time <em>t</em>
\f$\leq\f$ <em>0</em>.
As mentioned in the description of AssignmentRule, a model must not
contain more than one RateRule or AssignmentRule object having the same
value of "variable"; in other words, in the set of all assignment rules
and rate rules in an SBML model, each variable appearing in the
left-hand sides can only appear once.  This simply follows from the fact
that an indeterminate system would result if a model contained more than
one assignment rule for the same variable or both an assignment rule and
a rate rule for the same variable.
C<opydetails> doc_rules_general_summary

=over


=item RateRule::RateRule

Creates a new RateRule using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this RateRule.
@param version an unsigned int, the SBML Version to assign to this
RateRule.

C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item RateRule::RateRule

Creates a new RateRule using the given SBMLNamespaces object
C<sbmlns>.
C<opydetails> doc_what_are_sbmlnamespaces 
@param sbmlns an SBMLNamespaces object.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item RateRule::clone

Creates and returns a deep copy of this RateRule object.
@return the (deep) copy of this RateRule object.


=item RateRule::accept

@internal


=item RateRule::hasRequiredAttributes

Predicate returning C<true> if
all the required attributes for this RateRule object
have been set.
In SBML Levels&nbsp;2&ndash;3, the only required attribute for a
RateRule object is "variable".  For Level&nbsp;1, where the equivalent
attribute is known by different names ("compartment", "species", or
"name", depending on the type of object), there is an additional
required attribute called "formula".
@return C<true> if the required attributes have been set, C<false>
otherwise.


=item RateRule::renameSIdRefs

C<opydoc> doc_renamesidref_common


=back

=head2 Constraint

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html An SBML <em>constraint</em>, for stating validity assumptions.
The Constraint object class was introduced in SBML Level&nbsp;2
Version&nbsp;2 as a mechanism for stating the assumptions under which a
model is designed to operate.  The <em>constraints</em> are statements
about permissible values of different quantities in a model.
Constraints are not used to compute dynamical values for simulation or
analysis, but rather, they serve an advisory role for
simulation/analysis tools.
SBML's Constraint object class has one required attribute, "id", to
give the parameter a unique identifier by which other parts of an SBML
model definition can refer to it.  A Constraint object can also have an
optional "name" attribute of type C<string>.  Identifiers and names must
be used according to the guidelines described in the SBML specification
(e.g., Section 3.3 in the Level&nbsp;2 Version 4 specification).  
Constraint has one subelement, "math", containing a MathML
formula defining the condition of the constraint.  This formula will
return a Boolean value of C<true> when the model is a <em>valid</em>
state.  The formula can be an arbitrary expression referencing the
variables and other entities in an SBML model.  The evaluation of "math"
and behavior of constraints are described in more detail below.
In SBML Level&nbsp;2 and SBML Level&nbsp;3 Version&nbsp;1, the "math"
subelement is required, and its formula must be a Boolean value.  In
SBML Level&nbsp;3 Version&nbsp;2, these restrictions were relaxed:
the "math" subelement is optional, and numeric values are allowed
in Boolean contexts (a '0' is interpreted as C<false>, and all other
values are interpreted as C<true>).  If a Constraint with no "math"
is present in a Model, no restriction on the Model's behavior is
implied or enforced.
A Constraint structure also has an optional subelement called "message".
This can contain a message in XHTML format that may be displayed to the
user when the condition of the formula in the "math" subelement
evaluates to a value of C<false>.  Software tools are not required to
display the message, but it is recommended that they do so as a matter
of best practice.  The XHTML content within a "message" subelement must
follow the same restrictions as for the "notes" element on SBase
described in in the SBML Level&nbsp;2 specification; please consult the
<a target="_blank" href="http://sbml.org/Documents/Specifications">SBML
specification document</a> corresponding to the SBML Level and Version
of your model for more information about the requirements for "notes"
content.

Constraint was introduced in SBML Level&nbsp;2 Version&nbsp;2.  It is
not available in earlier versions of Level&nbsp;2 nor in any version of
Level&nbsp;1.

@section constraint-semantics Semantics of Constraints
In the context of a simulation, a Constraint has effect at all times
<em>t \f$\geq\f$ 0</em>.  Each Constraint's "math" subelement is first
evaluated after any InitialAssignment definitions in a model at <em>t =
0</em> and can conceivably trigger at that point.  (In other words, a
simulation could fail a constraint immediately.)
Constraint structures <em>cannot and should not</em> be used to compute
the dynamical behavior of a model as part of, for example, simulation.
Constraints may be used as input to non-dynamical analysis, for instance
by expressing flux constraints for flux balance analysis.
The results of a simulation of a model containing a constraint are
invalid from any simulation time at and after a point when the function
given by the "math" subelement returns a value of C<false>.  Invalid
simulation results do not make a prediction of the behavior of the
biochemical reaction network represented by the model.  The precise
behavior of simulation tools is left undefined with respect to
constraints.  If invalid results are detected with respect to a given
constraint, the "message" subelement may optionally be displayed to the
user.  The simulation tool may also halt the simulation or clearly
delimit in output data the simulation time point at which the simulation
results become invalid.
SBML does not impose restrictions on duplicate Constraint definitions or
the order of evaluation of Constraint objects in a model.  It is
possible for a model to define multiple constraints all with the same
mathematical expression.  Since the failure of any constraint indicates
that the model simulation has entered an invalid state, a system is not
required to attempt to detect whether other constraints in the model
have failed once any one constraint has failed.

=over


=back

=head2 ListOfConstraints

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html A list of Constraint objects.
C<opydetails> doc_what_is_listof

=over


=item Constraint::Constraint

Creates a new Constraint using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this Constraint.
@param version an unsigned int, the SBML Version to assign to this
Constraint.

C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item Constraint::Constraint

Creates a new Constraint using the given SBMLNamespaces object
C<sbmlns>.
C<opydetails> doc_what_are_sbmlnamespaces
@param sbmlns an SBMLNamespaces object.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item Constraint::Constraint

Copy constructor; creates a copy of this Constraint.
@param orig the object to copy.


=item Constraint::accept

@internal


=item Constraint::clone

Creates and returns a deep copy of this Constraint object.
@return the (deep) copy of this Constraint object.


=item Constraint::getMessage

Get the message, if any, associated with this Constraint
@return the message for this Constraint, as an XMLNode.


=item Constraint::getMessageString

Get the message string, if any, associated with this Constraint
@return the message for this Constraint, as a string.


=item Constraint::getMath

Get the mathematical expression of this Constraint
@return the math for this Constraint, as an ASTNode, or C<NULL> if the math is not set.


=item Constraint::isSetMessage

Predicate returning C<true> if a
message is defined for this Constraint.
@return C<true> if the message of this Constraint is set,
C<false> otherwise.


=item Constraint::isSetMath

Predicate returning C<true> if a
mathematical formula is defined for this Constraint.
@return C<true> if the "math" subelement for this Constraint is
set, C<false> otherwise.


=item Constraint::setMessage

Sets the message of this Constraint.
The XMLNode tree passed in C<xhtml> is copied.
@param xhtml an XML tree containing XHTML content.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink


=item Constraint::setMessage

Sets the message of this Constraint.
@param message an XML string that is to be used as the content of the
"message" subelement of this object.
@param addXHTMLMarkup a boolean indicating whether to wrap the contents
of the C<message> argument with XHTML paragraph (C<&lt;p&gt;>)
tags.  This is appropriate when the string in C<message> does not already
containg the appropriate XHTML markup.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink


=item Constraint::setMath

Sets the mathematical expression of this Constraint to a copy of the
AST given as C<math>.
@param math an ASTNode expression to be assigned as the "math"
subelement of this Constraint.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink


=item Constraint::unsetMessage

Unsets the "message" subelement of this Constraint.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink


=item Constraint::renameSIdRefs

C<opydoc> doc_renamesidref_common


=item Constraint::renameUnitSIdRefs

C<opydoc> doc_renameunitsidref_common


=item Constraint::replaceSIDWithFunction

@internal


=item Constraint::getTypeCode

Returns the libSBML type code for this SBML object.
C<opydetails> doc_what_are_typecodes
@return the SBML type code for this object:
@link SBMLTypeCode_t#SBML_CONSTRAINT SBML_CONSTRAINT@endlink (default).
C<opydetails> doc_warning_typecodes_not_unique
@see getElementName()
@see getPackageName()


=item Constraint::getElementName

Returns the XML element name of this object, which for Constraint, is
always C<"constraint">.
@return the name of this element, i.e., C<"constraint">.


=item Constraint::writeElements

@internal


=item Constraint::hasRequiredElements

Predicate returning C<true> if
all the required elements for this Constraint object
have been set.
@note The required elements for a Constraint object are:
@li 'math' (through SBML Level&nbsp;3 Version&nbsp;1 only; not 
required in Level&nbsp;3 Version&nbsp;2+.)
@return a boolean value indicating whether all the required
elements for this object have been defined.


=item Constraint::readOtherXML

@internal


=item Constraint::addExpectedAttributes

@internal


=item Constraint::readAttributes

@internal


=item Constraint::readL2Attributes

@internal


=item Constraint::readL3Attributes

@internal


=item Constraint::writeAttributes

@internal


=item ListOfConstraints::ListOfConstraints

Creates a new ListOfConstraints object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level.
@param version the Version within the SBML Level.
C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item ListOfConstraints::ListOfConstraints

Creates a new ListOfConstraints object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfConstraints object to be created.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item ListOfConstraints::clone

Creates and returns a deep copy of this ListOfConstraints object.
@return the (deep) copy of this ListOfConstraints object.


=item ListOfConstraints::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., Constraint objects, if the list is non-empty).
C<opydetails> doc_what_are_typecodes
@return the SBML type code for the objects contained in this ListOf
instance: @link SBMLTypeCode_t#SBML_CONSTRAINT SBML_CONSTRAINT@endlink (default).
@see getElementName()
@see getPackageName()


=item ListOfConstraints::getElementName

Returns the XML element name of this object.
For ListOfConstraints, the XML element name is C<"listOfConstraints">.
@return the name of this element.


=item ListOfConstraints::get

Get a Constraint from the ListOfConstraints.
@param n the index number of the Constraint to get.
@return the nth Constraint in this ListOfConstraints.
@see size()


=item ListOfConstraints::get

Get a Constraint from the ListOfConstraints.
@param n the index number of the Constraint to get.
@return the nth Constraint in this ListOfConstraints.
@see size()


=item ListOfConstraints::remove

Removes the nth item from this ListOfConstraints items and returns a
pointer to it.
The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove.
@see size()


=item ListOfConstraints::getElementPosition

@internal


=item ListOfConstraints::createObject

@internal


=back

=head2 Reaction

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html An SBML reaction between species in an SBML model.
A I<reaction> represents any transformation, transport or binding
process, typically a chemical reaction, that can change the quantity of
one or more species.  In SBML, a reaction is defined primarily in terms
of the participating reactants and products (and their corresponding
stoichiometries), along with optional modifier species, an optional rate
at which the reaction takes place, and optional parameters.
As with other major objects in SBML, Reaction has a mandatory attribute,
"id", used to give the compartment type an identifier.  The identifier
must be a text string conforming to the identifer syntax permitted in
SBML.  In SBML Level&nbsp;2 and Level&nbsp;3, the reaction "id"
identifier can be used in mathematical formulas elsewhere in an SBML
model to represent the rate of that reaction; this usage is explained
below.  Reaction also has an optional "name" attribute, of type @c
string.  The "id" and "name" must be used according to the guidelines
described in the SBML specification.
The species participating as reactants, products, and/or modifiers in a
reaction are declared using lists of SpeciesReference and/or
ModifierSpeciesReference instances stored in subelements
"listOfReactants", "listOfProducts" and "listOfModifiers".  Certain
restrictions are placed on the appearance of species in reaction
definitions:
\n=over\n
\n=item\n\nThe ability of a species to appear as a reactant or product of any
reaction in a model is governed by certain flags in that species'
definition; see the definition of Species for more information.
\n=item\n\nAny species appearing in the mathematical formula of the subelement
"kineticLaw" (described below) of a Reaction must be declared in at
least one of that Reaction's lists of reactants, products, and/or
modifiers.  Put another way, it is an error for a reaction's kinetic law
formula to refer to species that have not been declared for that
reaction.

\n=item\n\nFor SBML Levels 1, 2, and SBML Level&nbsp;3 Version&nbsp;1, a 
reaction definition can contain an empty list of reactants
<em>or</em> an empty list of products, but it must have at least one
reactant or product; in other words, a reaction without any reactant or
product species is not permitted.  (This restriction does not apply to
modifier species, which remain optional in all cases.)  In SBML 
Level&nbsp;3 Version&nbsp;2, this requirement was dropped, allowing 
the creation of reactions with neither reactants nor products.
\n=back\n

A reaction can contain up to one KineticLaw object in a subelement named
"kineticLaw".  It defines the speed at which the process defined by the
reaction takes place.  The description of KineticLaw provides more
details about its use.  Note that although the inclusion of a KineticLaw
object in an instance of a Reaction component is optional, there is no
useful default that can be substituted in place of a missing rate
expression in a reaction.  Moreover, a reaction's rate cannot be defined
in any other way in SBML---InitialAssignment, AssignmentRule,
RateRule, AlgebraicRule, Event, and other constructs in SBML cannot be
used to set the reaction rate separately.  Nevertheless, for some
modeling applications, reactions without any defined rate can be
perfectly acceptable.
Reaction also has a boolean attribute named "reversible" for indicating
whether the reaction is reversible.  This attribute is optional in SBML
Level&nbsp;2, with a default of C<true>; it is mandatory in SBML
Level&nbsp;3 (with no default value).  To say that a reaction is @em
reversible is to say it can proceed in either the forward or the reverse
direction.  Although the reversibility of a reaction can sometimes be
deduced by inspecting its rate expression, this is not always the case,
especially for complicated expressions.  Moreover, the need in SBML to
allow rate expressions (i.e., KineticLaw) to be optional leads to the
need for a separate flag indicating reversibility.  Note that labeling a
reaction as irreversible is an assertion that the reaction always
proceeds in the given forward direction.  (Why else would it be flagged
as irreversible?)  This implies the rate expression in the KineticLaw
always has a non-negative value during simulations.  Software tools
could provide a means of optionally testing that this condition holds.
The presence of reversibility information in two places (i.e., the rate
expression and the "reversible" attribute on Reaction) leaves open the
possibility that a model could contain contradictory information, but
the creation of such a model would be an error on the part of the
software generating it.
The Reaction object class has another boolean attribute called "fast".
This attribute is optional in SBML Level&nbsp;2, with a default of @c
false; it is mandatory in SBML Level&nbsp;3 (with no default value).  
In SBML Level&nbsp;3 Version&nbsp;2, a value of C<true> for the "fast"
attribute is deprecated in favor of all reactions having a "fast" value 
of C<false>.  It
is used to indicate that a reaction occurs on a vastly faster time scale
than others in a system.  Readers are directed to the SBML Level&nbsp;2
Version&nbsp;4 specification, which provides more detail about the
conditions under which a reaction can be considered to be fast in this
sense.  SBML Level&nbsp;1
and Level&nbsp;2 Version&nbsp;1 incorrectly claimed that software tools
could ignore this attribute if they did not implement support for the
corresponding concept; however, further research in SBML has revealed
that this is not true, and "fast" <em>cannot be ignored</em> if it is
set to C<true>.  SBML Level&nbsp;2 Versions&nbsp;2&ndash;4 therefore
stipulate that if a model has any reactions with "fast" set to C<true>,
a software tool must be able to respect the attribute or else indicate
to the user that it does not have the capacity to do so.  Analysis
software cannot ignore the value of the "fast" attribute because doing
so may lead to different results as compared to a software system that
<em>does</em> make use of "fast".
C<opydetails> doc_fast_attribute_deprecated
In SBML Level&nbsp;3, the Reaction object has an
additional optional attribute named "compartment", whose value must be
the identifier of a compartment defined in the enclosing Model object.
The "compartment" attribute can be used to indicate the compartment in
which the reaction is assumed to take place.  If the attribute is
present, its value must be the identifier of a Compartment object
defined in the enclosing Model object.  Similar to the "reversible"
attribute, the value of the "compartment" attribute has no direct impact
on the construction of mathematical equations for the SBML model.  When
a kinetic law is given for a reaction, the compartment location may
already be implicit in the kinetic law (although this cannot always be
guaranteed).  Nevertheless, software tools may find the "compartment"
attribute value useful for such purposes as analyzing the structure of
the model, guiding the modeler in constructing correct rate formulas,
and visualization purposes.
Readers are urged to read the SBML specification for more details about
the proper use of Reaction.

=over


=back

=head2 ListOfReactions

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html A list of Reaction objects.
C<opydetails> doc_what_is_listof

=over


=item Reaction::Reaction

Creates a new Reaction using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this Reaction.
@param version an unsigned int, the SBML Version to assign to this
Reaction.

C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item Reaction::Reaction

Creates a new Reaction using the given SBMLNamespaces object
C<sbmlns>.
C<opydetails> doc_what_are_sbmlnamespaces
@param sbmlns an SBMLNamespaces object.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item Reaction::Reaction

Copy constructor; creates a copy of this Reaction.
@param orig the object to copy.


=item Reaction::accept

@internal


=item Reaction::clone

Creates and returns a deep copy of this Reaction object.
@return the (deep) copy of this Reaction object.


=item Reaction::getElementBySId

Returns the first child element found that has the given C<id> in the
model-wide SId namespace, or C<NULL> if no such object is found.
@param id string representing the id of the object to find.
@return pointer to the first element found with the given C<id>.


=item Reaction::getElementByMetaId

Returns the first child element it can find with the given C<metaid>, or
C<NULL> if no such object is found.
@param metaid string representing the metaid of the object to find.
@return pointer to the first element found with the given C<metaid>.


=item Reaction::getAllElements

Returns a List of all child SBase objects, including those nested to an
arbitrary depth
@param filter a pointer to an ElementFilter, which causes the function 
to return only elements that match a particular set of constraints.  
If NULL (the default), the function will return all child objects.
@return a List of pointers to all children objects.


=item Reaction::renameSIdRefs

C<opydoc> doc_renamesidref_common


=item Reaction::initDefaults

Initializes the fields of this Reaction object to "typical" default
values.

The SBML Reaction component has slightly different aspects and
default attribute values in different SBML Levels and Versions.
This method sets the values to certain common defaults, based
mostly on what they are in SBML Level&nbsp;2.  Specifically:
@li Sets the "reversible" attribute to C<true>
@li Sets the "fast" attribute to C<false>
@li Marks the "fast" attribute as I<not> having been set
C<opydetails> doc_warning_reaction_cant_ignore_fast


=item Reaction::getId

Returns the value of the "id" attribute of this Reaction.
@note Because of the inconsistent behavior of this function with 
respect to assignments and rules, it is now recommended to
use the getIdAttribute() function instead.
C<opydetails> doc_id_attribute
@return the id of this Reaction.
@see getIdAttribute()
@see setIdAttribute(const std::string& sid)
@see isSetIdAttribute()
@see unsetIdAttribute()


=item Reaction::getName

Returns the value of the "name" attribute of this Reaction object.
C<opydetails> doc_get_name


=item Reaction::getKineticLaw

Returns the KineticLaw object contained in this Reaction.
@return the KineticLaw instance.


=item Reaction::getKineticLaw

Returns the KineticLaw object contained in this Reaction.
@return the KineticLaw instance.


=item Reaction::getReversible

Returns the value of the "reversible" attribute on the Reaction as a
boolean value.
@return the reversibility status of this Reaction.


=item Reaction::getFast

Returns the value of the "fast" attribute of this Reaction.
C<opydetails> doc_fast_attribute_deprecated
@return the "fast" status of this Reaction.
C<opydetails> doc_warning_reaction_cant_ignore_fast


=item Reaction::getCompartment

(SBML Level&nbsp;3 only) Returns the value of the "compartment"
attribute on the Reaction.
@return the compartment of this Reaction.
@note The "compartment" attribute is available in SBML Level&nbsp;3,
but is not present on Reaction in lower Levels of
SBML.


=item Reaction::isSetId

Predicate returning C<true> if this
Reaction's "id" attribute is set.
C<opydetails> doc_isset_id


=item Reaction::isSetName

Predicate returning C<true> if this
Reaction's "name" attribute is set.
C<opydetails> doc_isset_name


=item Reaction::isSetKineticLaw

Predicate returning C<true> if this
Reaction contains a kinetic law object.
@return C<true> if a KineticLaw is present in this Reaction,, C<false>
otherwise.


=item Reaction::isSetFast

Predicate returning C<true> if the value of
the "fast" attribute on this Reaction is set.
C<opydetails> doc_fast_attribute_deprecated
@return C<true> if the "fast" attribute is set, C<false> otherwise.
C<opydetails> doc_warning_reaction_cant_ignore_fast


=item Reaction::isSetCompartment

Predicate returning C<true> if this
Reaction's "compartment" attribute is set.
@return C<true> if the "compartment" attribute of this Reaction is
set, C<false> otherwise.
@note The "compartment" attribute is available in SBML
Level&nbsp;3, but is not present on Reaction in
lower Levels of SBML.


=item Reaction::isSetReversible

Predicate returning C<true> if this
Reaction's "reversible" attribute is set.
@return C<true> if the "reversible" attribute of this Reaction is
set, C<false> otherwise.


=item Reaction::setId

Sets the value of the "id" attribute of this Reaction.
C<opydetails> doc_set_id


=item Reaction::setName

Sets the value of the "name" attribute of this Reaction.
C<opydetails> doc_set_name


=item Reaction::setKineticLaw

Sets the "kineticLaw" subelement of this Reaction to a copy of the
given KineticLaw object.
@param kl the KineticLaw object to use.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink


=item Reaction::setReversible

Sets the value of the "reversible" attribute of this Reaction.
@param value the value of the "reversible" attribute.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink


=item Reaction::setFast

Sets the value of the "fast" attribute of this Reaction.
C<opydetails> doc_fast_attribute_deprecated
Calling this function with an argument of C<true> for an
SBML Level&nbsp;3 Version&nbsp;2 Reaction will set 
the value, but will result in a return value of 
@link OperationReturnValues_t#LIBSBML_DEPRECATED_ATTRIBUTE LIBSBML_DEPRECATED_ATTRIBUTE@endlink.
@param value the value of the "fast" attribute.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_DEPRECATED_ATTRIBUTE LIBSBML_DEPRECATED_ATTRIBUTE@endlink
C<opydetails> doc_warning_reaction_cant_ignore_fast


=item Reaction::setCompartment

Sets the value of the "compartment" attribute of this Reaction.
The string C<sid> is copied.  
@param sid the string to use as the compartment of this Reaction.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@note The "compartment" attribute is available in SBML
Level&nbsp;3, but is not present on Reaction in
lower Levels of SBML.


=item Reaction::unsetName

Unsets the value of the "name" attribute of this Reaction.
C<opydetails> doc_unset_name


=item Reaction::unsetKineticLaw

Unsets the "kineticLaw" subelement of this Reaction.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink


=item Reaction::unsetFast

Unsets the value of the "fast" attribute of this Reaction.
C<opydetails> doc_fast_attribute_deprecated
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
C<opydetails> doc_warning_reaction_cant_ignore_fast


=item Reaction::unsetCompartment

Unsets the value of the "compartment" attribute of this Reaction.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@note The "compartment" attribute is available in SBML
Level&nbsp;3, but is not present on Reaction in
lower Levels of SBML.


=item Reaction::unsetReversible

Unsets the value of the "reversible" attribute of this Reaction.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink


=item Reaction::addReactant

Adds a given SpeciesReference object as a reactant in this Reaction.
The SpeciesReference instance in C<sr> is copied.
@param sr a SpeciesReference object referring to a Species in the
enclosing Model.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
C<opydetails> doc_note_object_is_copied 
@see createReactant()


=item Reaction::addReactant

Adds the given species as a reactant with the given stoichiometry
@param species the species to be added as reactant.
@param stoichiometry an optional parameter specifying the
stoichiometry of the product (defaulting to 1).
@param id an optional id to be given to the species reference that will
be created. (defaulting to empty string, i.e. not set).
@param constant an attribute specifying whether the species reference is
constant or not (defaulting to true).
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
C<opydetails> doc_note_object_is_copied
@note the Species object itself is NOT added to the model
@see createProduct()


=item Reaction::addProduct

Adds a given SpeciesReference object as a product in this Reaction.
The SpeciesReference instance in C<sr> is copied.
@param sr a SpeciesReference object referring to a Species in the
enclosing Model.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
C<opydetails> doc_note_object_is_copied 
@see createProduct()


=item Reaction::addProduct

Adds the given species as a product with the given stoichiometry
@param species the species to be added as product.
@param stoichiometry an optional parameter specifying the
stoichiometry of the product (defaulting to 1).
@param id an optional id to be given to the species reference that will
be created. (defaulting to empty string, i.e. not set).
@param constant an attribute specifying whether the species reference is
constant or not (defaulting to true).
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
C<opydetails> doc_note_object_is_copied
@note the Species object itself is NOT added to the model
@see createProduct()


=item Reaction::addModifier

Adds a given ModifierSpeciesReference object as a product in this
Reaction.

The ModifierSpeciesReference instance in C<msr> is copied.
@param msr a ModifierSpeciesReference object referring to a Species in
the enclosing Model.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
C<opydetails> doc_note_object_is_copied 
@see createModifier()


=item Reaction::addModifier

Adds the given species as a modifier to this reaction
@param species the species to be added as modifier.
@param id an optional id to be given to the species reference that will
be created. (defaulting to empty string, i.e. not set).
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
C<opydetails> doc_note_object_is_copied
@note the Species object itself is NOT added to the model
@see createModifier()


=item Reaction::createReactant

Creates a new SpeciesReference, adds it to this Reaction's list of
reactants, and returns it.
@return a new SpeciesReference object.


=item Reaction::createProduct

Creates a new SpeciesReference, adds it to this Reaction's list of
products, and returns it.
@return a new SpeciesReference object.


=item Reaction::createModifier

Creates a new ModifierSpeciesReference, adds it to this Reaction's
list of modifiers and returns it.
@return a new ModifierSpeciesReference object.


=item Reaction::createKineticLaw

Creates a new KineticLaw object, installs it as this Reaction's
"kineticLaw" subelement, and returns it.
If this Reaction had a previous KineticLaw, it will be destroyed.
@return the new KineticLaw object.


=item Reaction::getListOfReactants

Returns the list of reactants in this Reaction object.
@return the ListOfSpeciesReferences containing the references to the
species acting as reactants in this reaction.


=item Reaction::getListOfReactants

Returns the list of reactants in this Reaction object.
@return the ListOfSpeciesReferences containing the references to the
species acting as reactants in this reaction.


=item Reaction::getListOfProducts

Returns the list of products in this Reaction object.
@return the ListOfSpeciesReferences containing the references to the
species acting as products in this reaction.


=item Reaction::getListOfProducts

Returns the list of products in this Reaction object.
@return the ListOfSpeciesReferences containing the references to the
species acting as products in this reaction.


=item Reaction::getListOfModifiers

Returns the list of modifiers in this Reaction object.
@return the ListOfSpeciesReferences containing the references to the
species acting as modifiers in this reaction.


=item Reaction::getListOfModifiers

Returns the list of modifiers in this Reaction object.
@return the ListOfSpeciesReferences containing the references to the
species acting as modifiers in this reaction.


=item Reaction::getReactant

Returns the nth reactant species (as a SpeciesReference object) in 
the list of reactants in this Reaction.
Callers should first call getNumReactants() to find out how many
reactants there are, to avoid using an invalid index number.
@param n the index of the reactant sought.
@return the nth reactant (as a SpeciesReference object) of this
Reaction.


=item Reaction::getReactant

Returns the nth reactant species (as a SpeciesReference object) 
in the list of reactants in this Reaction.
Callers should first call getNumReactants() to find out how many
reactants there are, to avoid using an invalid index number.
@param n the index of the reactant sought.
@return the nth reactant (as a SpeciesReference object) of this
Reaction.


=item Reaction::getReactant

Returns the reactant species (as a SpeciesReference object) having 
a specific identifier in this Reaction.
@param species the identifier of the reactant Species ("species" 
attribute of the reactant SpeciesReference object).
@return a SpeciesReference object, or C<NULL> if no species with the
given identifier C<species> appears as a reactant in this Reaction.


=item Reaction::getReactant

Returns the reactant species (as a SpeciesReference object) having 
a specific identifier in this Reaction.
@param species the identifier of the reactant Species ("species" 
attribute of the reactant SpeciesReference object).
@return a SpeciesReference object, or C<NULL> if no species with the
given identifier C<species> appears as a reactant in this Reaction.


=item Reaction::getProduct

Returns the nth product species (as a SpeciesReference object) in 
the list of products in this Reaction.
Callers should first call getNumProducts() to find out how many
products there are, to avoid using an invalid index number.
@param n the index of the product sought.
@return the nth product (as a SpeciesReference object) of this
Reaction.


=item Reaction::getProduct

Returns the nth product species (as a SpeciesReference object) 
in the list of products in this Reaction.
Callers should first call getNumProducts() to find out how many
products there are, to avoid using an invalid index number.
@param n the index of the product sought.
@return the nth product (as a SpeciesReference object) of this
Reaction.


=item Reaction::getProduct

Returns the product species (as a SpeciesReference object) having 
a specific identifier in this Reaction.
@param species the identifier of the product Species ("species"
attribute of the product SpeciesReference object).
@return a SpeciesReference object, or C<NULL> if no species with the
given identifier C<species> appears as a product in this Reaction.


=item Reaction::getProduct

Returns the product species (as a SpeciesReference object) having 
a specific identifier in this Reaction.
@param species the identifier of the product Species ("species"
attribute of the product SpeciesReference object).
@return a SpeciesReference object, or C<NULL> if no species with the
given identifier C<species> appears as a product in this Reaction.


=item Reaction::getModifier

Returns the nth modifier species (as a ModifierSpeciesReference object) 
in the list of modifiers of this Reaction.
Callers should first call getNumModifiers() to find out how many
modifiers there are, to avoid using an invalid index number.
@param n the index of the modifier species sought.
@return the nth modifier (as a ModifierSpeciesReference object) of
this Reaction.


=item Reaction::getModifier

Returns the nth modifier species (as a ModifierSpeciesReference object) 
in the list of modifiers of this Reaction.
Callers should first call getNumModifiers() to find out how many
modifiers there are, to avoid using an invalid index number.
@param n the index of the modifier species sought.
@return the nth modifier (as a ModifierSpeciesReference object) of
this Reaction.


=item Reaction::getModifier

Returns the modifier species (as a ModifierSpeciesReference object) 
having a specific identifier in this Reaction.
@param species the identifier of the modifier Species ("species" 
attribute of the ModifierSpeciesReference object).
@return a ModifierSpeciesReference object, or C<NULL> if no species with
the given identifier C<species> appears as a modifier in this
Reaction.


=item Reaction::getModifier

Returns the modifier species (as a ModifierSpeciesReference object) 
having a specific identifier in this Reaction.
@param species the identifier of the modifier Species ("species" 
attribute of the ModifierSpeciesReference object).
@return a ModifierSpeciesReference object, or C<NULL> if no species with
the given identifier C<species> appears as a modifier in this
Reaction.


=item Reaction::getNumReactants

Returns the number of reactant species in this Reaction.
@return the number of reactants in this Reaction.


=item Reaction::getNumProducts

Returns the number of product species in this Reaction.
@return the number of products in this Reaction.


=item Reaction::getNumModifiers

Returns the number of modifier species in this Reaction.
@return the number of modifiers in this Reaction.


=item Reaction::removeReactant

Removes the nth reactant species (SpeciesReference object) in the list of 
reactants in this Reaction and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
The caller should first call getNumReactants() to find out how many
reactants there are, to avoid using an invalid index number.
@param n the index of the reactant SpeciesReference object to remove.
@return the removed reactant SpeciesReference object, or C<NULL> if the 
given index is out of range.


=item Reaction::removeReactant

Removes the reactant species (SpeciesReference object) having the given  
"species" attribute in this Reaction and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param species the "species" attribute of the reactant SpeciesReference 
object.

@return the removed reactant SpeciesReference object, or C<NULL> if no 
reactant SpeciesReference object with the given "species" attribute 
C<species> exists in this Reaction.


=item Reaction::removeProduct

Removes the nth product species (SpeciesReference object) in the list of 
products in this Reaction and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
The caller should first call getNumProducts() to find out how many
products there are, to avoid using an invalid index number.
@param n the index of the product SpeciesReference object to remove.
@return the removed product SpeciesReference object, or C<NULL> if the 
given index is out of range.


=item Reaction::removeProduct

Removes the product species (SpeciesReference object) having the given  
"species" attribute in this Reaction and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param species the "species" attribute of the product SpeciesReference 
object.

@return the removed product SpeciesReference object, or C<NULL> if no 
product SpeciesReference object with the given "species" attribute 
C<species> exists in this Reaction.


=item Reaction::removeModifier

Removes the nth modifier species (ModifierSpeciesReference object) in 
the list of  modifiers in this Reaction and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
The caller should first call getNumModifiers() to find out how many
modifiers there are, to avoid using an invalid index number.
@param n the index of the ModifierSpeciesReference object to remove.
@return the removed ModifierSpeciesReference object, or C<NULL> if the 
given index is out of range.


=item Reaction::removeModifier

Removes the modifier species (ModifierSpeciesReference object) having 
the given "species" attribute in this Reaction and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param species the "species" attribute of the ModifierSpeciesReference 
object.

@return the removed ModifierSpeciesReference object, or C<NULL> if no 
ModifierSpeciesReference object with the given "species" attribute @p 
species exists in this Reaction.


=item Reaction::setSBMLDocument

@internal


=item Reaction::enablePackageInternal

@internal


=item Reaction::getTypeCode

Returns the libSBML type code for this SBML object.
C<opydetails> doc_what_are_typecodes
@return the SBML type code for this object:
@link SBMLTypeCode_t#SBML_REACTION SBML_REACTION@endlink (default).
C<opydetails> doc_warning_typecodes_not_unique
@see getElementName()
@see getPackageName()


=item Reaction::getElementName

Returns the XML element name of this object, which for Reaction, is
always C<"reaction">.
@return the name of this element, i.e., C<"reaction">.


=item Reaction::writeElements

@internal


=item Reaction::hasRequiredAttributes

Predicate returning C<true> if all the required attributes for this
Reaction object have been set.
The required attributes for a Reaction object are:
@li "id" (or "name" in SBML Level&nbsp;1)
@li "fast" (in Level&nbsp;3 only, where it is defined as a required attribute)
@li "reversible" (in Level&nbsp;3 only, where it is defined as a required attribute)
@return C<true> if the required attributes have been set, C<false>
otherwise.


=item Reaction::createObject

@internal


=item Reaction::addExpectedAttributes

@internal


=item Reaction::readAttributes

@internal


=item Reaction::readL1Attributes

@internal


=item Reaction::readL2Attributes

@internal


=item Reaction::readL3Attributes

@internal


=item Reaction::writeAttributes

@internal


=item Reaction::isExplicitlySetReversible

@internal


=item Reaction::isExplicitlySetFast

@internal


=item ListOfReactions::ListOfReactions

Creates a new ListOfReactions object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level.
@param version the Version within the SBML Level.
C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item ListOfReactions::ListOfReactions

Creates a new ListOfReactions object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfReactions object to be created.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item ListOfReactions::clone

Creates and returns a deep copy of this ListOfReactions object.
@return the (deep) copy of this ListOfReactions object.


=item ListOfReactions::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., Reaction objects, if the list is non-empty).
C<opydetails> doc_what_are_typecodes
@return the SBML type code for objects contained in this list:
@link SBMLTypeCode_t#SBML_REACTION SBML_REACTION@endlink (default).
@see getElementName()
@see getPackageName()


=item ListOfReactions::getElementName

Returns the XML element name of this object
For ListOfReactions, the XML element name is C<"listOfReactions">.
@return the name of this element, i.e., C<"listOfReactions">.


=item ListOfReactions::get

Get a Reaction from the ListOfReactions.
@param n the index number of the Reaction to get.
@return the nth Reaction in this ListOfReactions.
@see size()


=item ListOfReactions::get

Get a Reaction from the ListOfReactions.
@param n the index number of the Reaction to get.
@return the nth Reaction in this ListOfReactions.
@see size()


=item ListOfReactions::get

Get a Reaction from the ListOfReactions based on its identifier.
@param sid a string representing the identifier of the Reaction to get.
@return Reaction in this ListOfReactions with the given C<sid> or @c
NULL if no such Reaction exists.
@see get(unsigned int n)
@see size()


=item ListOfReactions::get

Get a Reaction from the ListOfReactions based on its identifier.
@param sid a string representing the identifier of the Reaction to get.
@return Reaction in this ListOfReactions with the given C<sid> or @c
NULL if no such Reaction exists.
@see get(unsigned int n)
@see size()


=item ListOfReactions::remove

Removes the nth item from this ListOfReactions items and returns a
pointer to it.
The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove.
@see size()


=item ListOfReactions::remove

Removes item in this ListOfReactions items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then
NULL is returned.
@param sid the identifier of the item to remove.
@return the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfReactions::getElementPosition

@internal


=item ListOfReactions::createObject

@internal


=back

=head2 KineticLaw

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html The rate expression for an SBML reaction.
An object of class KineticLaw is used to describe the rate at which the
process defined by a given Reaction takes place.  KineticLaw has
subelements called "math" (for MathML content) and "listOfParameters"
(of class ListOfParameters), in addition to the attributes and
subelements it inherits from SBase.
KineticLaw's "math" subelement for holding a MathML formula (required 
through SBML Level&nbsp;3 Version&nbsp;1, but optional as of SBML 
Level&nbsp;3 Version&nbsp;2) defines the
rate of the reaction.  The formula may refer to other entities in a
model as well as local parameter definitions within the scope of the
Reaction (see below).  It is important to keep in mind, however, that
the only Species identifiers that can be used in this formula are those
declared in the lists of reactants, products and modifiers in the
Reaction structure.  (In other words, before a species can be referenced
in the KineticLaw, it must be declared in one of those lists.)
KineticLaw provides a way to define I<local> parameters whose
identifiers can be used in the "math" formula of that KineticLaw
instance.  Prior to SBML Level&nbsp;3, these parameter definitions are
stored inside a "listOfParameters" subelement containing Parameter
objects; in SBML Level&nbsp;3, this is achieved using a specialized
object class called LocalParameter and the containing subelement is
called "listOfLocalParameters".  In both cases, the parameters so
defined are only visible within the KineticLaw (or, as of SBML
Level&nbsp;3 Version&nbsp;2, only visible within the parent Reaction); 
they cannot be accessed
outside.  A local parameter within one reaction is not visible from
within another reaction, nor is it visible to any other construct
outside of the KineticLaw in which it is defined.  In addition, another
important feature is that if such a Parameter (or in Level&nbsp;3,
LocalParameter) object has the same identifier as another object in the
scope of the enclosing Model, the definition inside the KineticLaw takes
precedence.  In other words, within the KineticLaw's "math" formula,
references to local parameter identifiers <strong>shadow any identical
global identifiers</strong>.
The values of local parameters defined within KineticLaw objects cannot
change.  In SBML Level&nbsp;3, this quality is built into the
LocalParameter construct.  In Level&nbsp;2, where the same kind of
Parameter object class is used as for global parameters, the Parameter
objects' "constant" attribute must always have a value of C<true>
(either explicitly or left to its default value).
@section shadowing-warning A warning about identifier shadowing
A common misconception is that different classes of objects (e.g.,
species, compartments, parameters) in SBML have different identifier
scopes.  They do not.  The implication is that if a KineticLaw's local
parameter definition uses an identifier identical to I<any> other
identifier defined in the model outside the KineticLaw, even if the
other identifier does I<not> belong to a parameter type of object, the
local parameter's identifier takes precedence within that KineticLaw's
"math" formula.  It is not an error in SBML for identifiers to shadow
each other this way, but can lead to confusing and subtle errors.
@section version-diffs SBML Level/Version differences
In SBML Level&nbsp;2 Version&nbsp;1, the SBML specification
included two additional attributes on KineticLaw called "substanceUnits"
and "timeUnits".  They were removed beginning with SBML Level&nbsp;2
Version&nbsp;2 because further research determined they introduced many
problems.  The most significant problem was that their use could easily
lead to the creation of valid models whose reactions nevertheless could
not be integrated into a system of equations without outside knowledge
for converting the quantities used.  Examination of real-life models
revealed that a common reason for using "substanceUnits" on KineticLaw
was to set the units of all reactions to the same set of substance
units, something that is better achieved by using UnitDefinition to
redefine C<"substance"> for the whole Model.
As mentioned above, in SBML Level&nbsp;2 Versions 2&ndash;4, local
parameters are of class Parameter.  In SBML Level&nbsp;3, the class of
object is LocalParameter.
In SBML Level&nbsp;3 Version&nbsp;2, the scope of the LocalParameter
was expanded to the entire Reaction, instead of just the KineticLaw.  
This introduced a single new restriction: an L3v2 LocalParameter may 
not now shadow the C<id> of any Species referenced by a SpeciesReference
in the same Reaction.  Other than that, there is no difference in any 
core construct.  However, packages may take advantage of this new scope by 
adding elements to the Reaction that may now reference a LocalParameter 
defined in the same Reaction.

=over


=item KineticLaw::KineticLaw

Creates a new KineticLaw using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this KineticLaw.
@param version an unsigned int, the SBML Version to assign to this
KineticLaw.

C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item KineticLaw::KineticLaw

Creates a new KineticLaw using the given SBMLNamespaces object
C<sbmlns>.
C<opydetails> doc_what_are_sbmlnamespaces
@param sbmlns an SBMLNamespaces object.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item KineticLaw::KineticLaw

Copy constructor; creates a copy of this KineticLaw.
@param orig the object to copy.


=item KineticLaw::accept

@internal


=item KineticLaw::clone

Creates and returns a deep copy of this KineticLaw object.
@return the (deep) copy of this KineticLaw object.


=item KineticLaw::getElementBySId

Returns the first child element found that has the given C<id> in the
model-wide SId namespace, or C<NULL> if no such object is found.
@param id string representing the id of the object to find.
@return pointer to the first element found with the given C<id>.


=item KineticLaw::getElementByMetaId

Returns the first child element it can find with the given C<metaid>, or
C<NULL> if no such object is found.
@param metaid string representing the metaid of the object to find.
@return pointer to the first element found with the given C<metaid>.


=item KineticLaw::getAllElements

Returns a List of all child SBase objects, including those nested to an
arbitrary depth
@param filter a pointer to an ElementFilter, which causes the function 
to return only elements that match a particular set of constraints.  
If NULL (the default), the function will return all child objects.
@return a List of pointers to all children objects.


=item KineticLaw::getFormula

Returns the mathematical formula for this KineticLaw object and return
it as as a text string.
This is fundamentally equivalent to
@if java KineticLaw::getMath()@else getMath()@endif.
This variant is provided principally for compatibility compatibility
with SBML Level&nbsp;1.
@return a string representing the formula of this KineticLaw.
@note @htmlinclude level-1-uses-text-string-math.html
@see getMath()


=item KineticLaw::getMath

Returns the mathematical formula for this KineticLaw object and return
it as as an AST.
This is fundamentally equivalent to
@if java KineticLaw::getFormula()@else getFormula()@endif.
The latter is provided principally for compatibility compatibility
with SBML Level&nbsp;1, which represented mathematical formulas in
text-string form.
@return the ASTNode representation of the mathematical formula, 
or NULL if the math is not set.
@see getFormula()


=item KineticLaw::getTimeUnits

(SBML Level&nbsp;2 Version&nbsp;1 only) Returns the value of the
"timeUnits" attribute of this KineticLaw object.
@return the "timeUnits" attribute value.
C<opydetails> doc_note_timeunits_substanceunits


=item KineticLaw::getSubstanceUnits

(SBML Level&nbsp;2 Version&nbsp;1 only) Returns the value of the
"substanceUnits" attribute of this KineticLaw object.
@return the "substanceUnits" attribute value.
C<opydetails> doc_note_timeunits_substanceunits


=item KineticLaw::isSetFormula

Predicate returning C<true> if this KineticLaw's "formula" attribute is
set.

This is functionally identical to the method
@if java KineticLaw::isSetMath()@else isSetMath()@endif.  It is
provided in order to mirror the parallel between
@if java KineticLaw::getFormula()@else getFormula()@endif@~ and
@if java KineticLaw::getMath()@else getMath()@endif.
@return C<true> if the formula (meaning the C<math> subelement) of
this KineticLaw is set, C<false> otherwise.
@note @htmlinclude level-1-uses-text-string-math.html
@see isSetMath()


=item KineticLaw::isSetMath

Predicate returning C<true> if this Kinetic's "math" subelement is set.
This is identical to the method
@if java KineticLaw::isSetFormula()@else isSetFormula()@endif.
It is provided in order to mirror the parallel between
@if java KineticLaw::getFormula()@else getFormula()@endif@~ and
@if java KineticLaw::getMath()@else getMath()@endif.
@return C<true> if the formula (meaning the C<math> subelement) of
this KineticLaw is set, C<false> otherwise.
@see isSetFormula()


=item KineticLaw::isSetTimeUnits

(SBML Level&nbsp;2 Version&nbsp;1 only) Predicate returning C<true> if
this SpeciesReference's "timeUnits" attribute is set.
@return C<true> if the "timeUnits" attribute of this KineticLaw object
is set, C<false> otherwise.
C<opydetails> doc_note_timeunits_substanceunits


=item KineticLaw::isSetSubstanceUnits

(SBML Level&nbsp;2 Version&nbsp;1 only) Predicate returning C<true> if
this SpeciesReference's "substanceUnits" attribute is set.
@return C<true> if the "substanceUnits" attribute of this KineticLaw
object is set, C<false> otherwise.
C<opydetails> doc_note_timeunits_substanceunits


=item KineticLaw::setFormula

Sets the mathematical expression of this KineticLaw instance to the
given C<formula>.
The given C<formula> string is copied.  Internally, libSBML stores the
mathematical expression as an ASTNode.
@param formula the mathematical expression to use, represented in
text-string form.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@note @htmlinclude level-1-uses-text-string-math.html
@see setMath(const ASTNode  math)


=item KineticLaw::setMath

Sets the mathematical expression of this KineticLaw instance to a copy
of the given ASTNode.
This is fundamentally identical to
@if java KineticLaw::setFormula(String formula)@else getFormula()@endif.
The latter is provided principally for compatibility compatibility with
SBML Level&nbsp;1, which represented mathematical formulas in text-string
form.

@param math an ASTNode representing a formula tree.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@see setFormula(const std::string& formula)


=item KineticLaw::setTimeUnits

(SBML Level&nbsp;2 Version&nbsp;1 only) Sets the "timeUnits" attribute
of this KineticLaw object to a copy of the identifier in C<sid>.
@param sid the identifier of the units to use.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
C<opydetails> doc_note_timeunits_substanceunits


=item KineticLaw::setSubstanceUnits

(SBML Level&nbsp;2 Version&nbsp;1 only) Sets the "substanceUnits"
attribute of this KineticLaw object to a copy of the identifier given
in C<sid>.
@param sid the identifier of the units to use.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
C<opydetails> doc_note_timeunits_substanceunits


=item KineticLaw::unsetTimeUnits

(SBML Level&nbsp;2 Version&nbsp;1 only) Unsets the "timeUnits"
attribugte of this KineticLaw object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
C<opydetails> doc_note_timeunits_substanceunits


=item KineticLaw::unsetSubstanceUnits

(SBML Level&nbsp;2 Version&nbsp;1 only) Unsets the "substanceUnits"
attribute of this KineticLaw object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
C<opydetails> doc_note_timeunits_substanceunits


=item KineticLaw::addParameter

Adds a copy of the given Parameter object to the list of local
parameters in this KineticLaw.
@param p the Parameter to add.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
C<opydetails> doc_note_object_is_copied 
@see createParameter()


=item KineticLaw::addLocalParameter

Adds a copy of the given LocalParameter object to the list of local
parameters in this KineticLaw.
@param p the LocalParameter to add.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
C<opydetails> doc_note_object_is_copied 
@see createLocalParameter()


=item KineticLaw::createParameter

Creates a new Parameter object, adds it to this KineticLaw's list of
local parameters, and returns the Parameter object created.
@return a new Parameter object instance.
@see addParameter(const Parameter  p)


=item KineticLaw::createLocalParameter

Creates a new LocalParameter object, adds it to this KineticLaw's list
of local parameters, and returns the LocalParameter object created.
@return a new LocalParameter object instance.
@see addLocalParameter(const LocalParameter  p)


=item KineticLaw::getListOfParameters

Returns the list of local parameters in this KineticLaw object.
@return the list of Parameters for this KineticLaw.


=item KineticLaw::getListOfParameters

Returns the list of local parameters in this KineticLaw object.
@return the list of Parameters for this KineticLaw.


=item KineticLaw::getListOfLocalParameters

Returns the list of local parameters in this KineticLaw object.
@return the list of LocalParameters for this KineticLaw.


=item KineticLaw::getListOfLocalParameters

Returns the list of local parameters in this KineticLaw object.
@return the list of LocalParameters for this KineticLaw.


=item KineticLaw::getParameter

Returns the nth Parameter object in the list of local parameters in
this KineticLaw instance.
@param n the index of the Parameter object sought.
@return the nth Parameter of this KineticLaw.


=item KineticLaw::getParameter

Returns the nth Parameter object in the list of local parameters in
this KineticLaw instance.
@param n the index of the Parameter object sought.
@return the nth Parameter of this KineticLaw.


=item KineticLaw::getLocalParameter

Returns the nth LocalParameter object in the list of local parameters in
this KineticLaw instance.
@param n the index of the LocalParameter object sought.
@return the nth LocalParameter of this KineticLaw.


=item KineticLaw::getLocalParameter

Returns the nth LocalParameter object in the list of local parameters in
this KineticLaw instance.
@param n the index of the LocalParameter object sought.
@return the nth LocalParameter of this KineticLaw.


=item KineticLaw::getParameter

Returns a local parameter based on its identifier.
@param sid the identifier of the Parameter being sought.
@return the Parameter object in this KineticLaw instace having the
given "id", or C<NULL> if no such Parameter exists.


=item KineticLaw::getParameter

Returns a local parameter based on its identifier.
@param sid the identifier of the Parameter being sought.
@return the Parameter object in this KineticLaw instace having the
given "id", or C<NULL> if no such Parameter exists.


=item KineticLaw::getLocalParameter

Returns a local parameter based on its identifier.
@param sid the identifier of the LocalParameter being sought.
@return the LocalParameter object in this KineticLaw instace having the
given "id", or C<NULL> if no such LocalParameter exists.


=item KineticLaw::getLocalParameter

Returns a local parameter based on its identifier.
@param sid the identifier of the LocalParameter being sought.
@return the LocalParameter object in this KineticLaw instace having the
given "id", or C<NULL> if no such LocalParameter exists.


=item KineticLaw::getNumParameters

Returns the number of local parameters in this KineticLaw instance.
@return the number of Parameters in this KineticLaw.


=item KineticLaw::getNumLocalParameters

Returns the number of local parameters in this KineticLaw instance.
@return the number of LocalParameters in this KineticLaw.


=item KineticLaw::getDerivedUnitDefinition

Calculates and returns a UnitDefinition that expresses the units of
measurement assumed for the "math" expression of this KineticLaw.
C<opydetails> doc_kineticlaw_units 
C<opydetails> doc_note_unit_inference_depends_on_model 
C<opydetails> doc_warning_kineticlaw_math_literals
@return a UnitDefinition that expresses the units of the math 
expression of this KineticLaw, or C<NULL> if one cannot be constructed.
@see containsUndeclaredUnits()


=item KineticLaw::getDerivedUnitDefinition

Calculates and returns a UnitDefinition that expresses the units of
measurement assumed for the "math" expression of this KineticLaw.
C<opydetails> doc_kineticlaw_units 
C<opydetails> doc_note_unit_inference_depends_on_model 
C<opydetails> doc_warning_kineticlaw_math_literals
@return a UnitDefinition that expresses the units of the math 
expression of this KineticLaw, or C<NULL> if one cannot be constructed.
@see containsUndeclaredUnits()


=item KineticLaw::containsUndeclaredUnits

Predicate returning C<true> if the math expression of this KineticLaw
contains parameters/numbers with undeclared units.
@return C<true> if the math expression of this KineticLaw
includes parameters/numbers 
with undeclared units, C<false> otherwise.
@note A return value of C<true> indicates that the UnitDefinition
returned by
@if java KineticLaw::getDerivedUnitDefinition()@else getDerivedUnitDefinition()@endif@~
may not accurately represent the units of the expression.
@see getDerivedUnitDefinition()


=item KineticLaw::containsUndeclaredUnits

Predicate returning C<true> if the math expression of this KineticLaw
contains parameters/numbers with undeclared units.
@return C<true> if the math expression of this KineticLaw
includes parameters/numbers 
with undeclared units, C<false> otherwise.
@note A return value of C<true> indicates that the UnitDefinition
returned by
@if java KineticLaw::getDerivedUnitDefinition()@else getDerivedUnitDefinition()@endif@~
may not accurately represent the units of the expression.
@see getDerivedUnitDefinition()


=item KineticLaw::removeParameter

Removes the nth Parameter object in the list of local parameters 
in this KineticLaw instance and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the Parameter object to remove.
@return the Parameter object removed.  As mentioned above, 
the caller owns the returned item. C<NULL> is returned if the given index 
is out of range.


=item KineticLaw::removeLocalParameter

Removes the nth LocalParameter object in the list of local parameters 
in this KineticLaw instance and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the LocalParameter object to remove.
@return the LocalParameter object removed.  As mentioned above, 
the caller owns the returned item. C<NULL> is returned if the given index 
is out of range.


=item KineticLaw::removeParameter

Removes a Parameter object with the given identifier in the list of
local parameters in this KineticLaw instance and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param sid the identifier of the Parameter to remove.
@return the Parameter object removed.  As mentioned above, the 
caller owns the returned object. C<NULL> is returned if no Parameter
object with the identifier exists in this KineticLaw instance.


=item KineticLaw::removeLocalParameter

Removes a LocalParameter object with the given identifier in the list of
local parameters in this KineticLaw instance and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param sid the identifier of the LocalParameter to remove.
@return the LocalParameter object removed.  As mentioned above, the 
caller owns the returned object. C<NULL> is returned if no LocalParameter
object with the identifier exists in this KineticLaw instance.


=item KineticLaw::setSBMLDocument

@internal


=item KineticLaw::enablePackageInternal

@internal


=item KineticLaw::getTypeCode

Returns the libSBML type code for this SBML object.
C<opydetails> doc_what_are_typecodes
@return the SBML type code for this object:
@link SBMLTypeCode_t#SBML_KINETIC_LAW SBML_KINETIC_LAW@endlink (default).
C<opydetails> doc_warning_typecodes_not_unique
@see getElementName()
@see getPackageName()


=item KineticLaw::getElementName

Returns the XML element name of this object, which for Species, is
always C<"kineticLaw">.
@return the name of this element, i.e., C<"kineticLaw">.


=item KineticLaw::getElementPosition

@internal


=item KineticLaw::writeElements

@internal


=item KineticLaw::hasRequiredAttributes

Predicate returning C<true> if all the required attributes for this
KineticLaw object have been set.
The required attributes for a KineticLaw object are:
@li "formula" (SBML Level&nbsp;1 only)
@return C<true> if the required attributes have been set, C<false>
otherwise.


=item KineticLaw::hasRequiredElements

Predicate returning C<true> if all the required elements for this
KineticLaw object have been set.
@note The required elements for a KineticLaw object are:
@li "math" inSBML Level&nbsp;2 and Level&nbsp;3 Version&nbsp;1.  
(In SBML Level&nbsp;3 Version&nbsp;2+, it is no longer required.)
@return a boolean value indicating whether all the required
elements for this object have been defined.


=item KineticLaw::removeFromParentAndDelete

Finds this KineticLaw's Reaction parent and calls unsetKineticLaw() on
it, indirectly deleting itself.
Overridden from the SBase function since the parent is not a ListOf.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink


=item KineticLaw::renameSIdRefs

C<opydoc> doc_renamesidref_common


=item KineticLaw::renameUnitSIdRefs

C<opydoc> doc_renameunitsidref_common


=item KineticLaw::getInternalId

@internal


=item KineticLaw::setInternalId

@internal


=item KineticLaw::replaceSIDWithFunction

@internal


=item KineticLaw::divideAssignmentsToSIdByFunction

@internal


=item KineticLaw::multiplyAssignmentsToSIdByFunction

@internal


=item KineticLaw::createObject

@internal


=item KineticLaw::readOtherXML

@internal


=item KineticLaw::addExpectedAttributes

@internal


=item KineticLaw::readAttributes

@internal


=item KineticLaw::readL1Attributes

@internal


=item KineticLaw::readL2Attributes

@internal


=item KineticLaw::readL3Attributes

@internal


=item KineticLaw::writeAttributes

@internal


=back

=head2 SimpleSpeciesReference

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html Abstract class for references to species in reactions.
As mentioned in the description of Reaction, every species that enters
into a given reaction must appear in that reaction's lists of reactants,
products and/or modifiers.  In an SBML model, all species that may
participate in any reaction are listed in the "listOfSpecies" element of
the top-level Model object.  Lists of products, reactants and modifiers
in Reaction objects do not introduce new species, but rather, they refer
back to those listed in the model's top-level "listOfSpecies".  For
reactants and products, the connection is made using SpeciesReference
objects; for modifiers, it is made using ModifierSpeciesReference
objects.  SimpleSpeciesReference is an abstract type that serves as the
parent class of both SpeciesReference and ModifierSpeciesReference.  It
is used simply to hold the attributes and elements that are common to
the latter two structures.
The SimpleSpeciesReference structure has a mandatory attribute,
"species", which must be a text string conforming to the identifer
syntax permitted in SBML.  This attribute is inherited by the
SpeciesReference and ModifierSpeciesReference subclasses derived from
SimpleSpeciesReference.  The value of the "species" attribute must be
the identifier of a species defined in the enclosing Model.  The species
is thereby declared as participating in the reaction being defined.  The
precise role of that species as a reactant, product, or modifier in the
reaction is determined by the subclass of SimpleSpeciesReference (i.e.,
either SpeciesReference or ModifierSpeciesReference) in which the
identifier appears.
SimpleSpeciesReference also contains an optional attribute, "id",
allowing instances to be referenced from other structures.  No SBML
structures currently do this; however, such structures are anticipated
in future SBML Levels.

=over


=item SimpleSpeciesReference::SimpleSpeciesReference

Creates a new SimpleSpeciesReference using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this SimpleSpeciesReference.
@param version an unsigned int, the SBML Version to assign to this
SimpleSpeciesReference.

C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item SimpleSpeciesReference::SimpleSpeciesReference

Copy constructor; creates a copy of this SimpleSpeciesReference.
@param orig the object to copy.


=item SimpleSpeciesReference::accept

@internal


=item SimpleSpeciesReference::getId

Returns the value of the "id" attribute of this SimpleSpeciesReference.
@note Because of the inconsistent behavior of this function with 
respect to assignments and rules, it is now recommended to
use the getIdAttribute() function instead.
C<opydetails> doc_id_attribute
@return the id of this SimpleSpeciesReference.
@see getIdAttribute()
@see setIdAttribute(const std::string& sid)
@see isSetIdAttribute()
@see unsetIdAttribute()


=item SimpleSpeciesReference::getName

Returns the value of the "name" attribute of this SimpleSpeciesReference object.
C<opydetails> doc_get_name


=item SimpleSpeciesReference::getSpecies

Get the value of the "species" attribute.
@return the value of the attribute "species" for this
SimpleSpeciesReference.


=item SimpleSpeciesReference::isSetId

Predicate returning C<true> if this
SimpleSpeciesReference's "id" attribute is set.
C<opydetails> doc_isset_id


=item SimpleSpeciesReference::isSetName

Predicate returning C<true> if this
SimpleSpeciesReference's "name" attribute is set.
C<opydetails> doc_isset_name


=item SimpleSpeciesReference::isSetSpecies

Predicate returning C<true> if this
SimpleSpeciesReference's "species" attribute is set.
@return C<true> if the "species" attribute of this
SimpleSpeciesReference is set, C<false> otherwise.


=item SimpleSpeciesReference::setSpecies

Sets the "species" attribute of this SimpleSpeciesReference.
The identifier string passed in C<sid> is copied.
@param sid the identifier of a species defined in the enclosing
Model's ListOfSpecies.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink


=item SimpleSpeciesReference::setId

Sets the value of the "id" attribute of this SimpleSpeciesReference.
C<opydetails> doc_set_id


=item SimpleSpeciesReference::setName

Sets the value of the "name" attribute of this SimpleSpeciesReference.
C<opydetails> doc_set_name


=item SimpleSpeciesReference::unsetId

Unsets the value of the "id" attribute of this SimpleSpeciesReference.
C<opydetails> doc_unset_id


=item SimpleSpeciesReference::unsetName

Unsets the value of the "name" attribute of this SimpleSpeciesReference.
C<opydetails> doc_unset_name


=item SimpleSpeciesReference::unsetSpecies

Unsets the value of the "species" attribute of this SimpleSpeciesReference.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink


=item SimpleSpeciesReference::isModifier

Predicate returning C<true> if this
is a ModifierSpeciesReference.
@return C<true> if this SimpleSpeciesReference's subclass is
ModiferSpeciesReference, C<false> if it is a plain SpeciesReference.


=item SimpleSpeciesReference::renameSIdRefs

C<opydoc> doc_renamesidref_common


=item SimpleSpeciesReference::hasRequiredAttributes

@internal


=item SimpleSpeciesReference::SimpleSpeciesReference

@internal


=item SimpleSpeciesReference::addExpectedAttributes

@internal


=item SimpleSpeciesReference::readAttributes

@internal


=item SimpleSpeciesReference::readL1Attributes

@internal


=item SimpleSpeciesReference::readL2Attributes

@internal


=item SimpleSpeciesReference::readL3Attributes

@internal


=item SimpleSpeciesReference::writeAttributes

@internal


=back

=head2 SpeciesReference

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html A reference to an SBML species in a reaction.
The Reaction structure provides a way to express which species act as
reactants and which species act as products in a reaction.  In a given
reaction, references to those species acting as reactants and/or
products are made using instances of SpeciesReference structures in a
Reaction object's lists of reactants and products.
A species can occur more than once in the lists of reactants and
products of a given Reaction instance.  The effective stoichiometry for
a species in a reaction is the sum of the stoichiometry values given on
the SpeciesReference object in the list of products minus the sum of
stoichiometry values given on the SpeciesReference objects in the list
of reactants.  A positive value indicates the species is effectively a
product and a negative value indicates the species is effectively a
reactant.  SBML places no restrictions on the effective stoichiometry of
a species in a reaction; for example, it can be zero.  In the following
SBML fragment, the two reactions have the same effective stoichiometry
for all their species:
@verbatim
<reaction id="x">
<listOfReactants>
<speciesReference species="a"/>
<speciesReference species="a"/>
<speciesReference species="b"/>
</listOfReactants>
<listOfProducts>
<speciesReference species="c"/>
<speciesReference species="b"/>
</listProducts>
</reaction>
<reaction id="y">
<listOfReactants>
<speciesReference species="a" stoichiometry="2"/>
</listOfReactants>
<listOfProducts>
<speciesReference species="c"/>
</listProducts>
</reaction>
@endverbatim

The precise structure of SpeciesReference differs between SBML
Level&nbsp;2 and Level&nbsp;3.  We discuss the two variants in separate
sections below.
@section spr-l2 SpeciesReference in SBML Level 2
The mandatory "species" attribute of SpeciesReference must have as its
value the identifier of an existing species defined in the enclosing
Model.  The species is thereby designated as a reactant or product in
the reaction.  Which one it is (i.e., reactant or product) is indicated
by whether the SpeciesReference appears in the Reaction's "reactant" or
"product" lists.
Product and reactant stoichiometries can be specified using
<em>either</em> "stoichiometry" or "stoichiometryMath" in a
SpeciesReference object.  The "stoichiometry" attribute is of type
double and should contain values greater than zero (0).  The
"stoichiometryMath" element is implemented as an element containing a
MathML expression.  These two are mutually exclusive; only one of
"stoichiometry" or "stoichiometryMath" should be defined in a given
SpeciesReference instance.  When neither the attribute nor the element
is present, the value of "stoichiometry" in the SpeciesReference
instance defaults to C<1>.
For maximum interoperability, the "stoichiometry" attribute should be
used in preference to "stoichiometryMath" when a species' stoichiometry
is a simple scalar number (integer or decimal).  When the stoichiometry
is a rational number, or when it is a more complicated formula,
"stoichiometryMath" must be used.  The MathML expression in
"stoichiometryMath" may also refer to identifiers of entities in a model
(except reaction identifiers).  However, the only species identifiers
that can be used in "stoichiometryMath" are those referenced in the
Reaction list of reactants, products and modifiers.
The following is a simple example of a species reference for species @c
X0, with stoichiometry C<2>, in a list of reactants within a reaction
having the identifier C<J1>:
@verbatim
<model>
...
<listOfReactions>
<reaction id="J1">
<listOfReactants>
<speciesReference species="X0" stoichiometry="2">
</listOfReactants>
...
</reaction>
...
</listOfReactions>
...
</model>
@endverbatim
The following is a more complex example of a species reference for
species X0, with a stoichiometry formula consisting of the parameter
C<x>:
@verbatim
<model>
...
<listOfReactions>
<reaction id="J1">
<listOfReactants>
<speciesReference species="X0">
<stoichiometryMath>
<math xmlns="http://www.w3.org/1998/Math/MathML">
<ci>x</ci>
</math>
</stoichiometryMath>
</speciesReference>
</listOfReactants>
...
</reaction>
...
</listOfReactions>
...
</model>
@endverbatim
@section spr-l3 SpeciesReference in SBML Level 3
In Level 2's definition of a reaction, the stoichiometry attribute of a
SpeciesReference is actually a combination of two factors, the standard
biochemical stoichiometry and a conversion factor that may be needed to
translate the units of the species quantity to the units of the reaction
rate. Unfortunately, Level&nbsp;2 offers no direct way of decoupling
these two factors, or for explicitly indicating the units. The only way
to do it in Level&nbsp;2 is to use the StoichiometryMath object
associated with SpeciesReferences, and to reference SBML Parameter
objects from within the StoichiometryMath formula. This works because
Parameter offers a way to attach units to a numerical value, but the
solution is indirect and awkward for something that should be a simple
matter.  Moreover, the question of how to properly encode
stoichiometries in SBML reactions has caused much confusion among
implementors of SBML software.
SBML Level&nbsp;3 approaches this problem differently.  It (1) extends
the the use of the SpeciesReference identifier to represent the value of
the "stoichiometry" attribute, (2) makes the "stoichiometry" attribute
optional, (3) removes StoichiometryMath, and (4) adds a new "constant"
boolean attribute on SpeciesReference.
As in Level&nbsp;2, the "stoichiometry" attribute is of type
C<double> and should contain values greater than zero (C<0>).  A
missing "stoichiometry" implies that the stoichiometry is either
unknown, or to be obtained from an external source, or determined by an
InitialAssignment object or other SBML construct elsewhere in the model.
A species reference's stoichiometry is set by its "stoichiometry"
attribute exactly once.  If the SpeciesReference object's "constant"
attribute has the value C<true>, then the stoichiometry is fixed and
cannot be changed except by an InitialAssignment object.  These two
methods of setting the stoichiometry (i.e., using "stoichiometry"
directly, or using InitialAssignment) differ in that the "stoichiometry"
attribute can only be set to a literal floating-point number, whereas
InitialAssignment allows the value to be set using an arbitrary
mathematical expression.  (As an example, the approach could be used to
set the stoichiometry to a rational number of the form I<p>/I<q>,
where I<p> and I<q> are integers, something that is occasionally
useful in the context of biochemical reaction networks.)  If the species
reference's "constant" attribute has the value C<false>, the species
reference's value may be overridden by an InitialAssignment or changed
by AssignmentRule or AlgebraicRule, and in addition, for simulation time
<em>t &gt; 0</em>, it may also be changed by a RateRule or Event
objects.  (However, some of these constructs are mutually exclusive; see
the SBML Level&nbsp;3 Core specifiation for more
details.)  It is not an error to define "stoichiometry" on a species
reference and also redefine the stoichiometry using an
InitialAssignment, but the "stoichiometry" attribute in that case is
ignored.

The value of the "id" attribute of a SpeciesReference can be used as the
content of a C<&lt;ci&gt;> element in MathML formulas
elsewhere in the model.  When the identifier appears in a MathML
C<&lt;ci&gt;> element, it represents the stoichiometry of the
corresponding species in the reaction where the SpeciesReference object
instance appears.  More specifically, it represents the value of the
"stoichiometry" attribute on the SpeciesReference object.
In SBML Level 3, the unit of measurement associated with the value of a
species' stoichiometry is always considered to be C<dimensionless>.
This has the following implications:
\n=over\n

\n=item\n\nWhen a species reference's identifier appears in mathematical
formulas elsewhere in the model, the unit associated with that value is
C<dimensionless>.
\n=item\n\nThe units of the "math" elements of AssignmentRule,
InitialAssignment and EventAssignment objects setting the stoichiometry
of the species reference should be C<dimensionless>.
\n=item\n\nIf a species reference's identifier is the subject of a RateRule,
the unit associated with the RateRule object's value should be
C<dimensionless>/<em>time</em>, where <em>time</em> is the
model-wide unit of time set on the Model object.
\n=back\n

=over


=back

=head2 ListOfSpeciesReferences

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html A list of SpeciesReference objects.
C<opydetails> doc_what_is_listof

=over


=item SpeciesReference::SpeciesReference

Creates a new SpeciesReference using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this SpeciesReference.
@param version an unsigned int, the SBML Version to assign to this
SpeciesReference.

C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item SpeciesReference::SpeciesReference

Creates a new SpeciesReference using the given SBMLNamespaces object
C<sbmlns>.
@param sbmlns an SBMLNamespaces object.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item SpeciesReference::SpeciesReference

Copy constructor; creates a copy of this SpeciesReference.
@param orig the SpeciesReference instance to copy.


=item SpeciesReference::accept

@internal


=item SpeciesReference::clone

Creates and returns a deep copy of this SpeciesReference object.
@return the (deep) copy of this SpeciesReference object.


=item SpeciesReference::initDefaults

Initializes the fields of this SpeciesReference object to "typical"
default values.
The SBML SpeciesReference component has slightly different aspects and
default attribute values in different SBML Levels and Versions.
This method sets the values to certain common defaults, based
mostly on what they are in SBML Level&nbsp;2.  Specifically:
\n=over\n
\n=item\n\nSets attribute "stoichiometry" to C<1>.0
\n=item\n\n(Applies to Level&nbsp;1 models only) Sets attribute "denominator" to C<1>
\n=back\n

@see getDenominator()
@see setDenominator(int value)
@see getStoichiometry()
@see setStoichiometry(double value)
@see getStoichiometryMath()
@see setStoichiometryMath(const StoichiometryMath  math)


=item SpeciesReference::getStoichiometry

Get the value of the "stoichiometry" attribute.
In SBML Level 2, product and reactant stoichiometries can be specified
using <em>either</em> "stoichiometry" or "stoichiometryMath" in a
SpeciesReference object.  The former is to be used when a
stoichiometry is simply a scalar number, while the latter is for
occasions when it needs to be a rational number or it needs to
reference other mathematical expressions.  The "stoichiometry"
attribute is of type C<double> and should contain values greater than
zero (C<0>).  The "stoichiometryMath" element is implemented as an
element containing a MathML expression.  These two are mutually
exclusive; only one of "stoichiometry" or "stoichiometryMath" should
be defined in a given SpeciesReference instance.  When neither the
attribute nor the element is present, the value of "stoichiometry" in
the SpeciesReference instance defaults to C<1>.  For maximum
interoperability between different software tools, the "stoichiometry"
attribute should be used in preference to "stoichiometryMath" when a
species' stoichiometry is a simple scalar number (integer or
decimal).

In SBML Level 3, there is no StoichiometryMath, and SpeciesReference
objects have only the "stoichiometry" attribute.
@return the value of the (scalar) "stoichiometry" attribute of this
SpeciesReference.

@see getStoichiometryMath()


=item SpeciesReference::getStoichiometryMath

Get the content of the "stoichiometryMath" subelement as an ASTNode
tree.

The "stoichiometryMath" element exists only in SBML Level 2.  There,
product and reactant stoichiometries can be specified using
<em>either</em> "stoichiometry" or "stoichiometryMath" in a
SpeciesReference object.  The former is to be used when a
stoichiometry is simply a scalar number, while the latter is for
occasions when it needs to be a rational number or it needs to
reference other mathematical expressions.  The "stoichiometry"
attribute is of type C<double> and should contain values greater than
zero (C<0>).  The "stoichiometryMath" element is implemented as an
element containing a MathML expression.  These two are mutually
exclusive; only one of "stoichiometry" or "stoichiometryMath" should
be defined in a given SpeciesReference instance.  When neither the
attribute nor the element is present, the value of "stoichiometry" in
the SpeciesReference instance defaults to C<1>.  For maximum
interoperability between different software tools, the "stoichiometry"
attribute should be used in preference to "stoichiometryMath" when a
species' stoichiometry is a simple scalar number (integer or decimal).
@return the content of the "stoichiometryMath" subelement of this
SpeciesReference.


=item SpeciesReference::getStoichiometryMath

Get the content of the "stoichiometryMath" subelement as an ASTNode
tree.

The "stoichiometryMath" element exists only in SBML Level 2.  There,
product and reactant stoichiometries can be specified using
<em>either</em> "stoichiometry" or "stoichiometryMath" in a
SpeciesReference object.  The former is to be used when a
stoichiometry is simply a scalar number, while the latter is for
occasions when it needs to be a rational number or it needs to
reference other mathematical expressions.  The "stoichiometry"
attribute is of type C<double> and should contain values greater than
zero (C<0>).  The "stoichiometryMath" element is implemented as an
element containing a MathML expression.  These two are mutually
exclusive; only one of "stoichiometry" or "stoichiometryMath" should
be defined in a given SpeciesReference instance.  When neither the
attribute nor the element is present, the value of "stoichiometry" in
the SpeciesReference instance defaults to C<1>.  For maximum
interoperability between different software tools, the "stoichiometry"
attribute should be used in preference to "stoichiometryMath" when a
species' stoichiometry is a simple scalar number (integer or decimal).
@return the content of the "stoichiometryMath" subelement of this
SpeciesReference.

@see getStoichiometry()


=item SpeciesReference::getDenominator

Get the value of the "denominator" attribute, for the case of a
rational-numbered stoichiometry or a model in SBML Level&nbsp;1.
The "denominator" attribute is only actually written out in the case
of an SBML Level&nbsp;1 model.  In SBML Level&nbsp;2, rational-number
stoichiometries are written as MathML elements in the
"stoichiometryMath" subelement.  However, as a convenience to users,
libSBML allows the creation and manipulation of rational-number
stoichiometries by supplying the numerator and denominator directly
rather than having to manually create an ASTNode object.  LibSBML
will write out the appropriate constructs (either a combination of
"stoichiometry" and "denominator" in the case of SBML Level&nbsp;1, or a
"stoichiometryMath" subelement in the case of SBML Level&nbsp;2).
@return the value of the "denominator" attribute of this
SpeciesReference.


=item SpeciesReference::getConstant

Get the value of the "constant" attribute.
@return the value of the "constant" attribute of this
SpeciesReference.


=item SpeciesReference::isSetStoichiometryMath

Predicate returning C<true> if this
SpeciesReference's "stoichiometryMath" subelement is set
@return C<true> if the "stoichiometryMath" subelement of this
SpeciesReference is set, C<false> otherwise.


=item SpeciesReference::isSetConstant

Predicate returning C<true> if this
SpeciesReference's "constant" attribute is set
@return C<true> if the "constant" attribute of this
SpeciesReference is set, C<false> otherwise.


=item SpeciesReference::isSetStoichiometry

Predicate returning C<true> if this
SpeciesReference's "stoichiometry" attribute is set.
@return C<true> if the "stoichiometry" attribute of this
SpeciesReference is set, C<false> otherwise.


=item SpeciesReference::setStoichiometry

Sets the value of the "stoichiometry" attribute of this
SpeciesReference.

In SBML Level 2, product and reactant stoichiometries can be specified
using <em>either</em> "stoichiometry" or "stoichiometryMath" in a
SpeciesReference object.  The former is to be used when a
stoichiometry is simply a scalar number, while the latter is for
occasions when it needs to be a rational number or it needs to
reference other mathematical expressions.  The "stoichiometry"
attribute is of type C<double> and should contain values greater than
zero (C<0>).  The "stoichiometryMath" element is implemented as an
element containing a MathML expression.  These two are mutually
exclusive; only one of "stoichiometry" or "stoichiometryMath" should
be defined in a given SpeciesReference instance.  When neither the
attribute nor the element is present, the value of "stoichiometry" in
the SpeciesReference instance defaults to C<1>.  For maximum
interoperability between different software tools, the "stoichiometry"
attribute should be used in preference to "stoichiometryMath" when a
species' stoichiometry is a simple scalar number (integer or
decimal).

In SBML Level 3, there is no StoichiometryMath, and SpeciesReference
objects have only the "stoichiometry" attribute.
@param value the new value of the "stoichiometry" attribute.
@note In SBML Level&nbsp;2, the "stoichiometryMath" subelement of this
SpeciesReference object will be unset because the "stoichiometry"
attribute and the stoichiometryMath" subelement are mutually
exclusive.

C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink


=item SpeciesReference::setStoichiometryMath

Sets the "stoichiometryMath" subelement of this SpeciesReference.
The Abstract Syntax Tree in C<math> is copied.
In SBML Level 2, product and reactant stoichiometries can be specified
using <em>either</em> "stoichiometry" or "stoichiometryMath" in a
SpeciesReference object.  The former is to be used when a
stoichiometry is simply a scalar number, while the latter is for
occasions when it needs to be a rational number or it needs to
reference other mathematical expressions.  The "stoichiometry"
attribute is of type C<double> and should contain values greater than
zero (C<0>).  The "stoichiometryMath" element is implemented as an
element containing a MathML expression.  These two are mutually
exclusive; only one of "stoichiometry" or "stoichiometryMath" should
be defined in a given SpeciesReference instance.  When neither the
attribute nor the element is present, the value of "stoichiometry" in
the SpeciesReference instance defaults to C<1>.  For maximum
interoperability between different software tools, the "stoichiometry"
attribute should be used in preference to "stoichiometryMath" when a
species' stoichiometry is a simple scalar number (integer or
decimal).

In SBML Level 3, there is no StoichiometryMath, and SpeciesReference
objects have only the "stoichiometry" attribute.
@param math the StoichiometryMath expression that is to be copied as the
content of the "stoichiometryMath" subelement.
@note In SBML Level&nbsp;2, the "stoichiometry" attribute of this
SpeciesReference object will be unset (isSetStoichiometry() will
return C<false> although getStoichiometry() will return C<1>.0) if the
given math is not null because the "stoichiometry" attribute and the
stoichiometryMath" subelement are mutually exclusive.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink


=item SpeciesReference::setDenominator

Set the value of the "denominator" attribute, for the case of a
rational-numbered stoichiometry or a model in SBML Level&nbsp;1.
The "denominator" attribute is only actually written out in the case
of an SBML Level&nbsp;1 model.  In SBML Level&nbsp;2, rational-number
stoichiometries are written as MathML elements in the
"stoichiometryMath" subelement.  However, as a convenience to users,
libSBML allows the creation and manipulation of rational-number
stoichiometries by supplying the numerator and denominator directly
rather than having to manually create an ASTNode object.  LibSBML
will write out the appropriate constructs (either a combination of
"stoichiometry" and "denominator" in the case of SBML Level&nbsp;1, or
a "stoichiometryMath" subelement in the case of SBML Level&nbsp;2).
@param value the scalar value.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink


=item SpeciesReference::setConstant

Sets the "constant" attribute of this SpeciesReference to the given boolean
C<flag>.
@param flag a boolean, the value for the "constant" attribute of this
SpeciesReference instance.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink


=item SpeciesReference::unsetStoichiometryMath

Unsets the "stoichiometryMath" subelement of this SpeciesReference.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
In SBML Level 2, product and reactant stoichiometries can be specified
using <em>either</em> "stoichiometry" or "stoichiometryMath" in a
SpeciesReference object.  The former is to be used when a
stoichiometry is simply a scalar number, while the latter is for
occasions when it needs to be a rational number or it needs to
reference other mathematical expressions.  The "stoichiometry"
attribute is of type C<double> and should contain values greater than
zero (C<0>).  The "stoichiometryMath" element is implemented as an
element containing a MathML expression.  These two are mutually
exclusive; only one of "stoichiometry" or "stoichiometryMath" should
be defined in a given SpeciesReference instance.  When neither the
attribute nor the element is present, the value of "stoichiometry" in
the SpeciesReference instance defaults to C<1>.  For maximum
interoperability between different software tools, the "stoichiometry"
attribute should be used in preference to "stoichiometryMath" when a
species' stoichiometry is a simple scalar number (integer or
decimal).

In SBML Level 3, there is no StoichiometryMath, and SpeciesReference
objects have only the "stoichiometry" attribute.
@note In SBML Level&nbsp;2, the "stoichiometry" attribute of this
SpeciesReference object will be reset to a default value (C<1>.0) if
the "stoichiometry" attribute has not been set.


=item SpeciesReference::unsetStoichiometry

Unsets the "stoichiometry" attribute of this SpeciesReference.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@note In SBML Level&nbsp;1, the "stoichiometry" attribute of this
SpeciesReference object will be just reset to a default value (C<1>.0)
and isSetStoichiometry() will still return C<true>.  In SBML
Level&nbsp;2, the "stoichiometry" attribute of this object will be
unset (which will result in isSetStoichiometry() returning C<false>,
although getStoichiometry() will return C<1>.0) if the
"stoichiometryMath" subelement is set, otherwise the attribute
will be just reset to the default value (C<1>.0) (and
isSetStoichiometry() will still return C<true>).  In SBML
Level&nbsp;3, the "stoichiometry" attribute of this object will be set
to C<NaN> and isSetStoichiometry() will return C<false>.


=item SpeciesReference::unsetConstant

Unsets the "constant" attribute of this SpeciesReference.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink


=item SpeciesReference::createStoichiometryMath

Creates a new, empty StoichiometryMath object, adds it to this
SpeciesReference, and returns it.
@return the newly created StoichiometryMath object instance.
@see Reaction::addReactant(const SpeciesReference  sr)
@see Reaction::addProduct(const SpeciesReference  sr)


=item SpeciesReference::setAnnotation

Sets the value of the "annotation" subelement of this SBML object to a
copy of C<annotation>.
Any existing content of the "annotation" subelement is discarded.
Unless you have taken steps to first copy and reconstitute any
existing annotations into the C<annotation> that is about to be
assigned, it is likely that performing such wholesale replacement is
unfriendly towards other software applications whose annotations are
discarded.  An alternative may be to use appendAnnotation().
@param annotation an XML structure that is to be used as the content
of the "annotation" subelement of this object.
C<opydetails> doc_returns_one_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@see appendAnnotation(const XMLNode  annotation)
@see appendAnnotation(const std::string& annotation)


=item SpeciesReference::setAnnotation

Sets the value of the "annotation" subelement of this SBML object to a
copy of C<annotation>.
Any existing content of the "annotation" subelement is discarded.
Unless you have taken steps to first copy and reconstitute any
existing annotations into the C<annotation> that is about to be
assigned, it is likely that performing such wholesale replacement is
unfriendly towards other software applications whose annotations are
discarded.  An alternative may be to use appendAnnotation().
@param annotation an XML string that is to be used as the content
of the "annotation" subelement of this object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@see appendAnnotation(const XMLNode  annotation)
@see appendAnnotation(const std::string& annotation)


=item SpeciesReference::appendAnnotation

Appends annotation content to any existing content in the "annotation"
subelement of this object.
The content in C<annotation> is copied.  Unlike
SpeciesReference::setAnnotation(@if java String@endif),
this method allows other annotations to be preserved when an application
adds its own data.
@param annotation an XML structure that is to be copied and appended
to the content of the "annotation" subelement of this object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@see setAnnotation(const std::string& annotation)
@see setAnnotation(const XMLNode  annotation)


=item SpeciesReference::appendAnnotation

Appends annotation content to any existing content in the "annotation"
subelement of this object.
The content in C<annotation> is copied.  Unlike
SpeciesReference::setAnnotation(@if java String@endif), this
method allows other annotations to be preserved when an application
adds its own data.
@param annotation an XML string that is to be copied and appended
to the content of the "annotation" subelement of this object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@see setAnnotation(const std::string& annotation)
@see setAnnotation(const XMLNode  annotation)


=item SpeciesReference::getTypeCode

Returns the libSBML type code for this SBML object.
C<opydetails> doc_what_are_typecodes
@return the SBML type code for this object:
@link SBMLTypeCode_t#SBML_SPECIES_REFERENCE SBML_SPECIES_REFERENCE@endlink (default).
@see getElementName()
@see getPackageName()


=item SpeciesReference::getElementName

Returns the XML element name of this object, which for
SpeciesReference, is always C<"speciesReference">.
@return the name of this element, i.e., C<"speciesReference">.


=item SpeciesReference::writeElements

@internal


=item SpeciesReference::sortMath

@internal


=item SpeciesReference::hasRequiredAttributes

Predicate returning C<true> if
all the required attributes for this SpeciesReference object
have been set.
The required attributes for a SpeciesReference object are:
@li "species"
@li "constant" (only available SBML Level&nbsp;3)
@return C<true> if the required attributes have been set, C<false>
otherwise.


=item SpeciesReference::createObject

@internal


=item SpeciesReference::readOtherXML

@internal


=item SpeciesReference::addExpectedAttributes

@internal


=item SpeciesReference::readAttributes

@internal


=item SpeciesReference::readL1Attributes

@internal


=item SpeciesReference::readL2Attributes

@internal


=item SpeciesReference::readL3Attributes

@internal


=item SpeciesReference::writeAttributes

@internal


=item SpeciesReference::syncAnnotation

@internal


=item SpeciesReference::isExplicitlySetStoichiometry

@internal


=item SpeciesReference::isExplicitlySetDenominator

@internal


=item ListOfSpeciesReferences::ListOfSpeciesReferences

Creates a new, empty ListOfSpeciesReferences object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level.
@param version the Version within the SBML Level.
C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item ListOfSpeciesReferences::ListOfSpeciesReferences

Creates a new ListOfSpeciesReferences object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfSpeciesReferences object to be created.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item ListOfSpeciesReferences::clone

Creates and returns a deep copy of this ListOfSpeciesReferences object.
@return the (deep) copy of this ListOfSpeciesReferences object.


=item ListOfSpeciesReferences::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., SpeciesReference objects, if the list is non-empty).
C<opydetails> doc_what_are_typecodes
@return the SBML type code for objects contained in this list:
@link SBMLTypeCode_t#SBML_SPECIES_REFERENCE SBML_SPECIES_REFERENCE@endlink (default).
@see getElementName()
@see getPackageName()


=item ListOfSpeciesReferences::getElementName

Returns the XML element name of this object.
For ListOfSpeciesReferences, the XML element name is @c
"listOfSpeciesReferences".

@return the name of this element, i.e., C<"listOfSpeciesReferences">.


=item ListOfSpeciesReferences::get

Get a SpeciesReference from the ListOfSpeciesReferences.
@param n the index number of the SpeciesReference to get.
@return the nth SpeciesReference in this ListOfSpeciesReferences.
@see size()


=item ListOfSpeciesReferences::get

Get a SpeciesReference from the ListOfSpeciesReferences.
@param n the index number of the SpeciesReference to get.
@return the nth SpeciesReference in this ListOfSpeciesReferences.
@see size()


=item ListOfSpeciesReferences::get

Get a SpeciesReference from the ListOfSpeciesReferences
based on its identifier.
@param sid a string representing the identifier 
of the SpeciesReference to get.
@return SpeciesReference in this ListOfSpeciesReferences
with the given C<sid> or C<NULL> if no such
SpeciesReference exists.
@see get(unsigned int n)
@see size()


=item ListOfSpeciesReferences::get

Get a SpeciesReference from the ListOfSpeciesReferences
based on its identifier.
@param sid a string representing the identifier 
of the SpeciesReference to get.
@return SpeciesReference in this ListOfSpeciesReferences
with the given C<sid> or C<NULL> if no such
SpeciesReference exists.
@see get(unsigned int n)
@see size()


=item ListOfSpeciesReferences::remove

Removes the nth item from this ListOfSpeciesReferences items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove.
@see size()


=item ListOfSpeciesReferences::remove

Removes item in this ListOfSpeciesReferences items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove.
@return the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfSpeciesReferences::getElementPosition

@internal


=item ListOfSpeciesReferences::getType

@internal


=item ListOfSpeciesReferences::setType

@internal


=item ListOfSpeciesReferences::createObject

@internal


=back

=head2 ModifierSpeciesReference

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html A reference to an SBML <em>modifier species</em>.
Sometimes a species appears in the kinetic rate formula of a reaction
but is itself neither created nor destroyed in that reaction (for
example, because it acts as a catalyst or inhibitor).  In SBML, all such
species are simply called I<modifiers> without regard to the detailed
role of those species in the model.  The Reaction structure provides a
way to express which species act as modifiers in a given reaction.  This
is the purpose of the list of modifiers available in Reaction.  The list
contains instances of ModifierSpeciesReference structures.
The ModifierSpeciesReference structure inherits the mandatory attribute
"species" and optional attributes "id" and "name" from the parent class
SimpleSpeciesReference.  See the description of SimpleSpeciesReference
for more information about these.
The value of the "species" attribute must be the identifier of a species
defined in the enclosing Model; this species is designated as a modifier
for the current reaction.  A reaction may have any number of modifiers.
It is permissible for a modifier species to appear simultaneously in the
list of reactants and products of the same reaction where it is
designated as a modifier, as well as to appear in the list of reactants,
products and modifiers of other reactions in the model.

=over


=item ModifierSpeciesReference::ModifierSpeciesReference

Creates a new ModifierSpeciesReference using the given SBML C<level> and
C<version> values.
@param level an unsigned int, the SBML Level to assign to this
ModifierSpeciesReference.

@param version an unsigned int, the SBML Version to assign to this
ModifierSpeciesReference.

C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item ModifierSpeciesReference::ModifierSpeciesReference

Creates a new ModifierSpeciesReference using the given SBMLNamespaces
object C<sbmlns>.
@param sbmlns an SBMLNamespaces object.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item ModifierSpeciesReference::accept

@internal


=item ModifierSpeciesReference::clone

Creates and returns a deep copy of this ModifierSpeciesReference object.
@return the (deep) copy of this ModifierSpeciesReference object.


=item ModifierSpeciesReference::getTypeCode

Returns the libSBML type code for this SBML object.
C<opydetails> doc_what_are_typecodes
@return the SBML type code for this object:
@link SBMLTypeCode_t#SBML_MODIFIER_SPECIES_REFERENCE SBML_MODIFIER_SPECIES_REFERENCE@endlink (default).
C<opydetails> doc_warning_typecodes_not_unique
@see getElementName()
@see getPackageName()


=item ModifierSpeciesReference::getElementName

Returns the XML element name of this object, which for Species, is
always C<"modifierSpeciesReference">.
@return the name of this element, i.e., C<"modifierSpeciesReference">.


=item ModifierSpeciesReference::hasRequiredAttributes

Predicate returning C<true> if
all the required attributes for this ModifierSpeciesReference object
have been set.
The required attributes for a ModifierSpeciesReference object are:
species

@return C<true> if the required attributes have been set, C<false>
otherwise.


=back

=head2 Event

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html A discontinuous SBML <em>event</em>.
An SBML Event object defines when the event can occur, the variables
that are affected by it, how the variables are affected, and the event's
relationship to other events.  The effect of the event can optionally be
delayed after the occurrence of the condition which invokes it.
The operation of Event is divided into two phases (even when the event
is not delayed): one when the event is I<triggered>, and the other when
the event is I<executed>.  Trigger objects define the conditions for
triggering an event, Delay objects define when the event is actually
executed, EventAssignment objects define the effects of executing the
event, and (in SBML Level&nbsp;3) Priority objects influence the order
of EventAssignment performance in cases of simultaneous events.  Please
consult the descriptions of Trigger, Delay, EventAssignment and Priority
for more information.
@section event-version-diffs SBML Level/Version differences
@subsection sbml-l2 SBML Level 2
In SBML Level&nbsp;2 versions before Version&nbsp;4, the semantics of
Event time delays were defined such that the expressions in the event's
assignments were always evaluated at the time the event was
<em>triggered</em>.  This definition made it difficult to define an event
whose assignment formulas were meant to be evaluated at the time the
event was <em>executed</em> (i.e., after the time period defined
by the value of the Delay element, or after any other simultaneous
event may have been <em>executed</em> and changed the model state).
In SBML Level&nbsp;2 Version&nbsp;4 and in
Level&nbsp;3, the attribute "useValuesFromTriggerTime" on Event was added 
to allow a model to indicate the time at which the event's assignments 
are to be calculated, whether at the moment the event is triggered (if
the value of the attribute is C<true>), or at the moment of execution
(if "useValuesFromTriggerTime"=C<false>).  If the event has a delay,
the "useValuesFromTriggerTime" is likely to make a significant difference
in the values used in the assignment, but the possibility of simultaneous
events mean that even zero-delay events can have different results
depending on the value of this attribute.
The definition of Event in SBML Level&nbsp;2 Versions 1 and 2 includes
an additional attribute called "timeUnits", which allowed the time units
of the Delay to be set explicitly.  Later Versions of SBML Level&nbsp;2
as well as SBML Level&nbsp;3 do not define this attribute.  LibSBML
supports this attribute for compatibility with previous versions of SBML
Level&nbsp;2; however, if a model in SBML Level&nbsp;3 or Level&nbsp;2
Versions&nbsp;3&ndash;4 format sets the attribute, the
consistency-checking method SBMLDocument::checkConsistency() will report
an error.
The attribute "useValuesFromTriggerTime" was introduced in SBML
Level&nbsp;2 Version&nbsp;4.  Models defined in prior Versions of SBML
Level&nbsp;2 cannot use this attribute, and
SBMLDocument::checkConsistency() will report an error if they do.
@subsection sbml-l3 SBML Level 3
SBML Level 3 introduces several changes to the structure and components
of Events compared to SBML Level&nbsp;2.  These changes fall into two
main categories: changes to what is optional or required, and additions
of new attributes and elements.
\n=over\n
\n=item\n\nThe attribute "useValuesFromTriggerTime" on Event is mandatory (it
was optional in Level&nbsp;2 and had a default value of C<true>);
\n=item\n\nEvent's "listOfEventAssignments" element (of class
ListOfEventAssignments) is optional (it was mandatory in Level&nbsp;2);
\n=item\n\nEvent's "priority" element (of class Priority) is new in
Level&nbsp;3; and
\n=item\n\nThe Trigger object gains new mandatory attributes (described as part
of the definition of Trigger).
\n=item\n\nIn SBML Level&nbsp;3 Version&nbsp;2, the Trigger object became 
optional.  An Event with no Trigger will simply not fire.
\n=back\n

The changes to the attributes of Event are described below; the changes
to Trigger and Priority are described in their respective sections.
@section semantics Semantics of events in SBML Level&nbsp;3 Version&nbsp;1
The detailed semantics of events are described in the specification
documents for each SBML Level/Version.  Here we include the description
from the SBML Level&nbsp;1 Version&nbsp;1.
Any transition of a Trigger object's "math" formula from the value @c
false to C<true> will cause the enclosing Event object to
<em>trigger</em>.  Such a transition is not possible at the very start
of a simulation (i.e., at time <em>t = 0</em>) unless the Trigger
object's "initialValue" attribute has a value of C<false>; this defines
the value of the trigger formula to be C<false> immediately prior to the
start of simulation, thereby giving it the potential to change in value
from C<false> to C<true> when the formula is evaluated at <em>t =
0</em>.  If "initialValue"=C<true>, then the trigger expression cannot
transition from C<false> to C<true> at <em>t = 0</em> but may do so at
some time <em>t E<gt> 0</em>.
Consider an Event object definition <EM>E</EM> with delay <em>d</em> in
which the Trigger object's "math" formula makes a transition in value
from C<false> to C<true> at times <em>t<sub>1</sub></em> and
<em>t<sub>2</sub></em>.  The EventAssignment within the Event object
will have effect at <em>t<sub>1</sub> + d</em> and
<em>t<sub>2</sub> + d</em> irrespective of the relative times of
<em>t<sub>1</sub></em> and <em>t<sub>2</sub></em>.  For example, events
can "overlap" so that <em>t<sub>1</sub> E<lt> t<sub>2</sub> <
t<sub>1</sub> + d</em> still causes an event assignments to occur at
<em>t<sub>1</sub> + d</em> and <em>t<sub>2</sub> + d</em>.
It is entirely possible for two events to be executed simultaneously,
and it is possible for events to trigger other events (i.e., an event
assignment can cause an event to trigger).  This leads to several
points:
\n=over\n
\n=item\n\nA software package should retest all event triggers after executing
an event assignment in order to account for the possibility that the
assignment causes another event trigger to transition from C<false> to
C<true>.  This check should be made after each individual Event object's
execution, even when several events are to be executed simultaneously.
\n=item\n\nAny Event object whose Trigger "persistent" attribute has the value
C<false> must have its trigger expression reevaluated continuously
between when the event is triggered and when it is executed.  If
its trigger expression ever evaluates to C<false>, it must be removed
from the queue of events pending execution and treated as any other
event whose trigger expression evaluates to C<false>.
\n=item\n\nAlthough the precise time at which events are executed is not
resolved beyond the given execution point in simulated time, it is
assumed that the order in which the events occur <em>is</em> resolved.
This order can be significant in determining the overall outcome of a
given simulation.  When an event <EM>X</EM> <em>triggers</em> another
event <EM>Y</EM> and event <EM>Y</EM> has zero delay, then event
<EM>Y</EM> is added to the existing set of simultaneous events that are
pending <em>execution</em>.  Events <EM>X</EM> and <EM>Y</EM> form a
cascade of events at the same point in simulation time.  An event such
as <EM>Y</EM> may have a special priority if it contains a Priority
subobject.

\n=item\n\nAll events in a model are open to being in a cascade.  The position
of an event in the event queue does not affect whether it can be in the
cascade: event <EM>Y</EM> can be triggered whether it is before or after
<EM>X</EM> in the queue of events pending execution.  A cascade of
events can be potentially infinite (never terminate); when this occurs a
simulator should indicate this has occurred---it is incorrect for a
simulator to break a cascade arbitrarily and continue the simulation
without at least indicating that the infinite cascade occurred.
\n=item\n\nSimultaneous events having no defined priorities are executed in an
undefined order.  This does not mean that the behavior of the simulation
is completely undefined; merely that the <em>order</em> of execution of
these particular events is undefined.  A given simulator may use any
algorithm to choose an order as long as every event is executed exactly
once.

\n=item\n\nEvents with defined priorities are executed in the order implied by
their Priority "math" formula values, with events having higher
priorities being executed ahead of events with lower priorities, and
events with identical priorities being executed in a random order with
respect to one another (as determined at run-time by some random
algorithm equivalent to coin-flipping).  Newly-triggered events that are
to be executed immediately (i.e., if they define no delays) should be
inserted into the queue of events pending execution according to their
priorities: events with higher priority values value must be inserted
ahead of events with lower priority values and after any pending events
with even higher priorities, and inserted randomly among pending events
with the same priority values.  Events without Priority objects must be
inserted into the queue in some fashion, but the algorithm used to place
it in the queue is undefined.  Similarly, there is no restriction on the
order of a newly-inserted event with a defined Priority with respect to
any other pending Event without a defined Priority.
\n=item\n\nA model variable that is the target of one or more event
assignments can change more than once when simultaneous events are
processed at some time point <em>t</em>.  The model's behavior (output)
for such a variable is the value of the variable at the end of
processing all the simultaneous events at time <em>t</em>.
\n=back\n

@section l3v2_restrictions Restrictions relaxed in SBML Level&nbsp;3 Version&nbsp;2
In SBML Level&nbsp;3 Version&nbsp;2, several restrictions were lifted 
that have the potential to affect the semantics of an Event:
\n=over\n
\n=item\n\nThe Trigger subobject of an Event is optional.  If missing,
an Event is never I<triggered>, unless an alternate triggering 
scheme is introduced by an SBML Level&nbsp;3 package.
\n=item\n\nThe "math" subelements of an Event Trigger, Delay, Priority,
and EventAssignment are all optional.  If any of these elements lack 
a "math" subelement, and that information is not supplied in an SBML
Level&nbsp;3 package, it is mathematically equivalent to the Trigger, 
Delay, Priority, or EventAssignment not being present at all.
\n=item\n\nThe ListOfEventAssignments may be empty, which is mathematically 
equivalent to the Event not having a ListOfEventAssignments at all.
\n=item\n\nAny "math" subelement may return a Boolean or a numeric value
in any context.  If a numeric value is used in a Boolean context,
a "0" is interpreted as C<false>, and all other values are
interpreted as C<true>.  If a Boolean value is used in a numeric 
context, a C<true> is interpreted as a 1, and a C<false> is 
interpreted as a 0.  This means (for example) that a Trigger value 
that changes from 0.0 to anything else is equivalent to changing 
from C<false> to C<true>.
\n=back\n

@see Trigger
@see Priority
@see Delay
@see EventAssignment

=over


=back

=head2 ListOfEvents

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html A list of Event objects.
C<opydetails> doc_what_is_listof

=over


=item Event::Event

Creates a new Event using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this Event.
@param version an unsigned int, the SBML Version to assign to this
Event.

C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item Event::Event

Creates a new Event using the given SBMLNamespaces object
C<sbmlns>.
C<opydetails> doc_what_are_sbmlnamespaces 
@param sbmlns an SBMLNamespaces object.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item Event::Event

Copy constructor; creates a copy of this Event.
@param orig the object to copy.


=item Event::accept

@internal


=item Event::clone

Creates and returns a deep copy of this Event object.
@return the (deep) copy of this Event object.


=item Event::initDefaults

Initializes the fields of this Event object to "typical" default
values.

The SBML Event component has slightly different aspects and
default attribute values in different SBML Levels and Versions.
This method sets the values to certain common defaults, based
mostly on what they are in SBML Level&nbsp;2.  Specifically:
@li Sets attribute "useValuesFromTriggerTime" to C<true>


=item Event::getElementBySId

Returns the first child element found that has the given C<id> in the
model-wide SId namespace, or C<NULL> if no such object is found.
@param id string representing the id of the object to find.
@return pointer to the first element found with the given C<id>.


=item Event::getElementByMetaId

Returns the first child element it can find with the given C<metaid>, or
C<NULL> if no such object is found.
@param metaid string representing the metaid of the object to find.
@return pointer to the first element found with the given C<metaid>.


=item Event::getAllElements

Returns a List of all child SBase objects, including those nested to an
arbitrary depth.
@param filter a pointer to an ElementFilter, which causes the function 
to return only elements that match a particular set of constraints.  
If NULL (the default), the function will return all child objects.
@return a List of pointers to all children objects.


=item Event::getId

Returns the value of the "id" attribute of this Event.
@note Because of the inconsistent behavior of this function with 
respect to assignments and rules, it is now recommended to
use the getIdAttribute() function instead.
C<opydetails> doc_id_attribute
@return the id of this Event.
@see getIdAttribute()
@see setIdAttribute(const std::string& sid)
@see isSetIdAttribute()
@see unsetIdAttribute()


=item Event::getName

Returns the value of the "name" attribute of this Event.
C<opydetails> doc_get_name


=item Event::getTrigger

Get the event trigger portion of this Event.
@return the Trigger object of this Event, or C<NULL> if the trigger is not set.


=item Event::getTrigger

Get the event trigger portion of this Event.
@return the Trigger object of this Event.


=item Event::getDelay

Get the assignment delay portion of this Event, if there is one.
@return the delay of this Event if one is defined, or C<NULL> if none
is defined.


=item Event::getDelay

Get the assignment delay portion of this Event, if there is one.
@return the delay of this Event if one is defined, or C<NULL> if none
is defined.


=item Event::getPriority

(SBML Level&nbsp;3 only) Get the event priority portion of this
Event.

@return the Priority object of this Event, or NULL if the Priority
has not been set.
@note The element "priority" is available in SBML Level&nbsp;3,
but is not present in lower Levels of SBML.


=item Event::getPriority

(SBML Level&nbsp;3 only) Get the event priority portion of this
Event.

@return the Priority object of this Event, or NULL if the Priority
has not been set.
@note The element "priority" is available in SBML Level&nbsp;3,
but is not present in lower Levels of SBML.


=item Event::getTimeUnits

Get the value of the "timeUnits" attribute of this Event, if it has one.
@return the value of the attribute "timeUnits" as a string.
C<opydetails> doc_warning_event_timeUnits


=item Event::getUseValuesFromTriggerTime

Get the value of the "useValuesFromTriggerTime" attribute of this Event.
C<opydetails> doc_event_using_useValuesFromTriggerTime
@return the value of the attribute "useValuesFromTriggerTime" as a boolean.
C<opydetails> doc_warning_useValuesFromTriggerTime


=item Event::isSetId

Predicate returning C<true> if this
Event's "id" attribute is set.
C<opydetails> doc_isset_id


=item Event::isSetName

Predicate returning C<true> if this
Event's "name" attribute is set.
C<opydetails> doc_isset_name


=item Event::isSetTrigger

Predicate for testing whether the trigger for this Event is set.
@return C<true> if the trigger of this Event is set, C<false>
otherwise.


=item Event::isSetDelay

Predicate for testing whether the delay for this Event is set.
@return C<true> if the delay of this Event is set, C<false>
otherwise.


=item Event::isSetPriority

(SBML Level&nbsp;3 only) Predicate for testing whether the priority
for this Event is set.
@return C<true> if the priority of this Event is set, C<false>
otherwise.

@note The element "priority" is available in SBML Level&nbsp;3,
but is not present in lower Levels of SBML.


=item Event::isSetTimeUnits

Predicate for testing whether the "timeUnits" attribute of this Event
is set.
@return C<true> if the "timeUnits" attribute of this Event is
set, C<false> otherwise.
C<opydetails> doc_warning_event_timeUnits


=item Event::isSetUseValuesFromTriggerTime

Predicate for testing whether the "useValuesFromTriggerTime" attribute of this Event
is set.
@return C<true> if the "useValuesFromTriggerTime" attribute of this Event is
set, C<false> otherwise.
@note In SBML Level&nbsp;2, this attribute is optional and has a default value of
C<true>, whereas in Level&nbsp;3, this optional is mandatory and
has no default value.


=item Event::setId

Sets the value of the "id" attribute of this Event.
C<opydetails> doc_set_id


=item Event::setName

Sets the value of the "name" attribute of this Event.
C<opydetails> doc_set_name


=item Event::setTrigger

Sets the trigger definition of this Event to a copy of the given
Trigger object instance.
@param trigger the Trigger object instance to use.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink


=item Event::setDelay

Sets the delay definition of this Event to a copy of the given Delay
object instance.
@param delay the Delay object instance to use.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink


=item Event::setPriority

(SBML Level&nbsp;3 only) Sets the priority definition of this Event
to a copy of the given Priority object instance.
@param priority the Priority object instance to use.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@note The element "priority" is available in SBML Level&nbsp;3,
but is not present in lower Levels of SBML.


=item Event::setTimeUnits

Sets the "timeUnits" attribute of this Event to a copy of C<sid>.
@param sid the identifier of the time units to use.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
C<opydetails> doc_warning_event_timeUnits


=item Event::setUseValuesFromTriggerTime

Sets the "useValuesFromTriggerTime" attribute of this Event to a C<value>.
C<opydetails> doc_event_using_useValuesFromTriggerTime
@param value the value of useValuesFromTriggerTime to use.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
C<opydetails> doc_warning_useValuesFromTriggerTime


=item Event::unsetId

Unsets the value of the "id" attribute of this Event.
C<opydetails> doc_unset_id


=item Event::unsetName

Unsets the value of the "name" attribute of this Event.
C<opydetails> doc_unset_name


=item Event::unsetUseValuesFromTriggerTime

Unsets the value of the "useValuesFromTriggerTime" attribute of this Event.
C<opydetails> doc_event_using_useValuesFromTriggerTime
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
C<opydetails> doc_warning_useValuesFromTriggerTime


=item Event::unsetDelay

Unsets the Delay of this Event.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink


=item Event::unsetPriority

(SBML Level&nbsp;3 only) Unsets the Priority of this Event.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@note The element "priority" is available in SBML Level&nbsp;3,
but is not present in lower Levels of SBML.


=item Event::unsetTrigger

Unsets the Trigger of this Event.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@note The element "priority" is available in SBML Level&nbsp;3,
but is not present in lower Levels of SBML.


=item Event::unsetTimeUnits

Unsets the "timeUnits" attribute of this Event.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
C<opydetails> doc_warning_event_timeUnits


=item Event::addEventAssignment

Appends a copy of the given EventAssignment to this Event.
@param ea the EventAssignment object to add.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
C<opydetails> doc_note_object_is_copied 
@see createEventAssignment()


=item Event::createEventAssignment

Creates a new, empty EventAssignment, adds it to this Event's list of
event assignments and returns the EventAssignment.
@return the newly created EventAssignment object instance.
@see addEventAssignment(const EventAssignment  ea)


=item Event::createTrigger

Creates a new, empty Trigger, adds it to this Event and 
returns the Trigger.
@return the newly created Trigger object instance.


=item Event::createDelay

Creates a new, empty Delay, adds it to this Event and 
returns the Delay.
@return the newly created Delay object instance.


=item Event::createPriority

(SBML Level&nbsp;3 only) Creates a new, empty Priority, adds it to this
Event and returns the Priority.
@return the newly created Priority object instance, or NULL if the SBML
level and version used for this Event does not define Priority children.
@note The element "priority" is available in SBML Level&nbsp;3,
but is not present in lower Levels of SBML.


=item Event::getListOfEventAssignments

Returns the list of event assignments for this Event.
@return the list of EventAssignments for this Event.


=item Event::getListOfEventAssignments

Returns the list of event assignments for this Event.
@return the list of EventAssignments for this Event.


=item Event::getEventAssignment

Return a specific EventAssignment object of this Event.
@param n an integer, the index of the EventAssignment object to return.
@return the C<n>th EventAssignment of this Event.


=item Event::getEventAssignment

Return a specific EventAssignment object of this Event.
@param n an integer, the index of the EventAssignment object to return.
@return the C<n>th EventAssignment of this Event.


=item Event::getEventAssignment

Return the event assignment indicated by the given C<variable>.
@param variable a string, the identifier of the variable whose
EventAssignment is being sought.
@return the EventAssignment for the given C<variable>, or C<NULL> if
no such EventAssignment exits.


=item Event::getEventAssignment

Return the event assignment indicated by the given C<variable>.
@param variable a string, the identifier of the variable whose
EventAssignment is being sought.
@return the EventAssignment for the given C<variable>, or C<NULL> if
no such EventAssignment exits.


=item Event::getNumEventAssignments

Returns the number of EventAssignment objects attached to this
Event.

@return the number of EventAssignments in this Event.


=item Event::removeEventAssignment

Removes the nth EventAssignment object from this Event object and
returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the EventAssignment object to remove.
@return the EventAssignment object removed.  As mentioned above, 
the caller owns the returned item. C<NULL> is returned if the given index 
is out of range.


=item Event::removeEventAssignment

Removes the EventAssignment object with the given "variable" attribute 
from this Event object and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
If none of the EventAssignment objects in this Event object have the 
"variable" attribute C<variable>, then C<NULL> is returned.
@param variable the "variable" attribute of the EventAssignment object 
to remove.
@return the EventAssignment object removed.  As mentioned above, the 
caller owns the returned object. C<NULL> is returned if no EventAssignment
object with the "variable" attribute exists in this Event object.


=item Event::setSBMLDocument

@internal


=item Event::enablePackageInternal

@internal


=item Event::getTypeCode

Returns the libSBML type code of this object instance.
C<opydetails> doc_what_are_typecodes
@return the SBML type code for this object:
@link SBMLTypeCode_t#SBML_EVENT SBML_EVENT@endlink (default).
C<opydetails> doc_warning_typecodes_not_unique
@see getElementName()
@see getPackageName()


=item Event::getElementName

Returns the XML element name of this object, which for Event, is
always C<"event">.
@return the name of this element, i.e., C<"event">.


=item Event::writeElements

@internal


=item Event::hasRequiredAttributes

Predicate returning C<true> if all the required attributes for this
Event object have been set.
The required attributes for an Event object are:
@li "useValuesfromTriggerTime" (required in SBML Level&nbsp;3)
@return C<true> if the required attributes have been set, C<false>
otherwise.


=item Event::hasRequiredElements

Predicate returning C<true> if all the required elements for this Event
object have been set.
@note The required elements for an Event object are:
@li "trigger" (required in SBML Level&nbsp;2 and Level&nbsp;3 Version&nbsp;1,
optional in SBML Level&nbsp;3 Version&nbsp;2+
@li "listOfEventAssignments" (required in SBML Level&nbsp;2, optional in Level&nbsp;3)


=item Event::getInternalId

@internal


=item Event::setInternalId

@internal


=item Event::createObject

@internal


=item Event::addExpectedAttributes

@internal


=item Event::readAttributes

@internal


=item Event::readL2Attributes

@internal


=item Event::readL3Attributes

@internal


=item Event::writeAttributes

@internal


=item Event::isExplicitlySetUVFTT

@internal


=item ListOfEvents::ListOfEvents

Creates a new ListOfEvents object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level.
@param version the Version within the SBML Level.
C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item ListOfEvents::ListOfEvents

Creates a new ListOfEvents object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfEvents object to be created.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item ListOfEvents::clone

Creates and returns a deep copy of this ListOfEvents object.
@return the (deep) copy of this ListOfEvents object.


=item ListOfEvents::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., Event objects, if the list is non-empty).
C<opydetails> doc_what_are_typecodes
@return the SBML type code for the objects contained in this ListOf:
@link SBMLTypeCode_t#SBML_EVENT SBML_EVENT@endlink (default).
@see getElementName()
@see getPackageName()


=item ListOfEvents::getElementName

Returns the XML element name of this object.
For ListOfEvents, the XML element name is C<"listOfEvents">.
@return the name of this element, i.e., C<"listOfEvents">.


=item ListOfEvents::get

Get an Event from the ListOfEvents.
@param n the index number of the Event to get.
@return the C<n>th Event in this ListOfEvents.
@see size()


=item ListOfEvents::get

Get an Event from the ListOfEvents.
@param n the index number of the Event to get.
@return the C<n>th Event in this ListOfEvents.
@see size()


=item ListOfEvents::get

Get an Event from the ListOfEvents
based on its identifier.
@param sid a string representing the identifier 
of the Event to get.
@return Event in this ListOfEvents
with the given C<sid> or C<NULL> if no such
Event exists.
@see get(unsigned int n)
@see size()


=item ListOfEvents::get

Get an Event from the ListOfEvents
based on its identifier.
@param sid a string representing the identifier 
of the Event to get.
@return Event in this ListOfEvents
with the given C<sid> or C<NULL> if no such
Event exists.
@see get(unsigned int n)
@see size()


=item ListOfEvents::remove

Removes the nth item from this ListOfEvents items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove.
@see size()


=item ListOfEvents::remove

Removes item in this ListOfEvents items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then
C<NULL> is returned.
@param sid the identifier of the item to remove.
@return the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfEvents::getElementPosition

@internal


=item ListOfEvents::createObject

@internal


=back

=head2 EventAssignment

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html An assignment to a variable by an SBML <em>event</em>.
Event contains an optional element called "listOfEventAssignments", of
class ListOfEventAssignments.  In every instance of an event definition
in a model, the object's "listOfEventAssignments" element must have a
non-empty list of one or more "eventAssignment" elements of class
EventAssignment.  The object class EventAssignment has one required
attribute, "variable", and a required element, "math".  Being derived
from SBase, it also has all the usual attributes and elements of its
parent class.
An Event object defines when the event can occur, the variables that are
affected by the event, and how the variables are affected.  The purpose
of the EventAssignment object class is to define how variables are
affected by an Event.  In SBML Level&nbsp;2, every Event object instance
must have a nonempty list of event assignments; in SBML Level&nbsp;3,
the list of assignments is optional.
The operation of an Event is divided into two phases (regardless of
whether a delay is involved): one phase when the event is I<triggered>,
and the other when the event is I<executed>.   EventAssignment objects
are interpreted when an event is executed.  The effects are described
below.

@section event-variable The attribute "variable"
The EventAssignment attribute "variable" must be the identifier of an
existing Compartment, Species, SpeciesReference, or Parameter
instance defined in the model.  In SBML Level&nbsp;3 Version&nbsp;2,
this list was expanded to include identifiers of SBML Level&nbsp;3
package variables that have both mathematical meaning and the 
ability to be assigned.  When the event is executed, the value of
the model component identified by "variable" is changed by the
EventAssignment to the value computed by the "math" element; that is, a
species' quantity, species reference's stoichiometry, compartment's size
or parameter's value are reset to the value computed by "math".
Certain restrictions are placed on what can appear in "variable":
\n=over\n
\n=item\n\nThe object identified by the value of the EventAssignment attribute
"variable" must not have its "constant" attribute set to or default to
C<true>.  (Constants cannot be affected by events.)
\n=item\n\nThe "variable" attribute must not contain the identifier of a
reaction.  In SBML Level&nbsp;2 and SBML Level&nbsp;3 Version&nbsp;1,
only species, species references, compartment and parameter
values may be set by an Event.  In SBML Level&nbsp;3 Version&nbsp;2,
the "variable" attribute may also be the identifier of an SBML
Level&nbsp;3 package element with mathematical meaning and the
ability to be assigned a value.  This situation may only arise if 
the SBML package is present in the SBML document with a 
package:required attribute of C<true>
\n=item\n\nThe value of every "variable" attribute must be unique among the set
of EventAssignment structures within a given Event structure.  In other
words, a single event cannot have multiple EventAssignment objects
assigning the same variable.  (All of them would be performed at the
same time when that particular Event triggers, resulting in
indeterminacy.)  However, I<separate> Event instances can refer to the
same variable.
\n=item\n\nA variable cannot be assigned a value in an EventAssignment object
instance and also be assigned a value by an AssignmentRule; i.e., the
value of an EventAssignment's "variable" attribute cannot be the same as
the value of a AssignmentRule' "variable" attribute.  (Assignment rules
hold at all times, therefore it would be inconsistent to also define an
event that reassigns the value of the same variable.)
\n=back\n

If the variable attribute of an EventAssignment object references an 
object in an SBML namespace that is not understood by the interpreter 
reading a given SBML document (that is, if the object is defined by an 
SBML Level&nbsp;3 package that the software does not support), the 
event assignment must be ignored--the object's value will not need to 
be set, as the interpreter could not understand that package. If an 
interpreter cannot establish whether a referenced object is missing 
from the model or instead is defined in an SBML namespace not 
understood by the interpreter, it may produce a warning to the user. 
(The latter situation may only arise if an SBML package is present in 
the SBML document with a package:required attribute of "true".)
Note that the time of assignment of the object identified by the
value of the "variable" attribute is always the time at which the Event
is <em>executed</em>, not when it is <em>triggered</em>.  The timing is
controlled by the optional Delay in an Event.  The time of
assignment is not affected by the "useValuesFromTriggerTime"
attribute on Event---that attribute affects the time at which the
EventAssignment's "math" expression is I<evaluated>.  In other
words, SBML allows decoupling the time at which the
"variable" is assigned from the time at which its value
expression is calculated.
@section event-math The "math" subelement in an EventAssignment
The MathML expression contained in an EventAssignment defines the new
value of the variable being assigned by the Event.
As mentioned above, the time at which the expression in "math" is
evaluated is determined by the attribute "useValuesFromTriggerTime" on
Event.  If the attribute value is C<true>, the expression must be
evaluated when the event is I<triggered>; more precisely, the values of
identifiers occurring in MathML C<&lt;ci&gt;> elements in the
EventAssignment's "math" expression are the values they have at the
point when the event I<triggered>.  If, instead,
"useValuesFromTriggerTime"'s value is C<false>, it means the values at
I<execution> time should be used; that is, the values of identifiers
occurring in MathML C<&lt;ci&gt;> elements in the
EventAssignment's "math" expression are the values they have at the
point when the event I<executed>.
@section eventassignment-version-diffs SBML Level/Version differences
Between Version&nbsp;4 and previous versions of SBML Level&nbsp;2, the
requirements regarding the matching of units between an
EvengAssignment's formula and the units of the object identified by the
"variable" attribute changed.  Previous versions required consistency,
but in SBML Level&nbsp;2 Version&nbsp;4 and in SBML Level&nbsp;3, unit
consistency is only I<recommended>.  More precisely:
\n=over\n

\n=item\n\nIn the case of a species, an EventAssignment sets the referenced
species' quantity (concentration or amount of substance) to the value
determined by the formula in the EventAssignment's "math" subelement.
The units of the "math" formula should (in SBML Level&nbsp;2
Version&nbsp;4 and in Level&nbsp;3) or must (in previous Versions of
Level&nbsp;2) be identical to the units of the species.
\n=item\n\n(SBML Level&nbsp;3 only.) In the case of a species reference, an
EventAssignment sets the stoichiometry of the reactant or product
referenced by the SpeciesReference object to the value determined by the
formula in the "math" element.  The unit associated with the value
produced by the "math" formula should be C<dimensionless>, because
reactant and product stoichiometries in reactions are dimensionless
quantities.

\n=item\n\nIn the case of a compartment, an EventAssignment sets the
referenced compartment's size to the size determined by the formula in
the "math" subelement of the EventAssignment.  The overall units of the
formula should (in SBML Level&nbsp;2 Version&nbsp;4 and in Level&nbsp;3)
or must (in previous Versions of Level&nbsp;2) be identical to the units
specified for the size of the compartment identified by the
EventAssignment's "variable" attribute.
\n=item\n\nIn the case of a parameter, an EventAssignment sets the referenced
parameter's value to that determined by the formula in "math".  The
overall units of the formula should (in SBML Level&nbsp;2 Version&nbsp;4
and Level&nbsp;3) or must (in previous Versions of Level&nbsp;2) be
identical to the units defined for the parameter.
\n=item\n\n(For SBML Level&nbsp;3 Version&nbsp;2 only) <em>In the case of 
an object from an SBML Level&nbsp;3 package</em>, an EventAssignment sets 
the referenced object's value (as defined by that package) to the 
value of the formula in "math". The unit of measurement associated 
with the value produced by the formula should be the same as that 
object's units attribute value (if it has such an attribute), or be 
equal to the units of model components of that type (if objects of 
that class are defined by the package as having the same units).
\n=back\n

Note that the formula placed in the "math" element <em>has no assumed
units</em>.  The consistency of the units of the formula, and the units
of the entity which the assignment affects, must be explicitly
established just as in the case of the value of the Delay subelement.
An approach similar to the one discussed in the context of Delay may be
used for the formula of an EventAssignment.
@section event-asnt-restrictions Restrictions relaxed in SBML Level&nbsp;3 Version&nbsp;2
In SBML Level&nbsp;3 Version&nbsp;2, the requirement that an EventAssignment
have a "math" subelement was relaxed, making it optional.  In
this case, the EventAssignment remains undefined, and unless that information
is provided in some other form (such as with an SBML Level&nbsp;3
package), the Event behaves as if it had no EventAssignment.
@see Event

=over


=back

=head2 ListOfEventAssignments

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html A list of EventAssignment objects.
C<opydetails> doc_what_is_listof

=over


=item EventAssignment::EventAssignment

Creates a new EventAssignment using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this EventAssignment.
@param version an unsigned int, the SBML Version to assign to this
EventAssignment.

C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item EventAssignment::EventAssignment

Creates a new EventAssignment using the given SBMLNamespaces object
C<sbmlns>.
C<opydetails> doc_what_are_sbmlnamespaces 
@param sbmlns an SBMLNamespaces object.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item EventAssignment::EventAssignment

Copy constructor; creates a copy of this EventAssignment.
@param orig the object to copy.


=item EventAssignment::accept

@internal


=item EventAssignment::clone

Creates and returns a deep copy of this EventAssignment object.
@return the (deep) copy of this EventAssignment object.


=item EventAssignment::getVariable

Get the value of this EventAssignment's "variable" attribute.
@return the identifier stored in the "variable" attribute of this
EventAssignment.


=item EventAssignment::getMath

Get the mathematical expression in this EventAssignment's "math"
subelement.

@return the top ASTNode of an abstract syntax tree representing the
mathematical formula in this EventAssignment, or C<NULL> if the math is not set.


=item EventAssignment::isSetVariable

Predicate for testing whether the attribute "variable" of this
EventAssignment is set.
@return C<true> if the "variable" attribute of this EventAssignment
is set, C<false> otherwise.


=item EventAssignment::isSetMath

Predicate for testing whether the "math" subelement of this
EventAssignment is set.
@return C<true> if this EventAssignment has a "math" subelement,
C<false> otherwise.


=item EventAssignment::setVariable

Sets the attribute "variable" of this EventAssignment to a copy of
the given identifier string.
@param sid the identifier of a Compartment, Species or (global)
Parameter defined in this model.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink


=item EventAssignment::unsetVariable

Unsets the attribute "variable" of this EventAssignment.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink


=item EventAssignment::setMath

Sets the "math" subelement of this EventAssignment to a copy of the
given ASTNode.
@param math an ASTNode that will be copied and stored as the
mathematical formula for this EventAssignment.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink


=item EventAssignment::getDerivedUnitDefinition

Calculates and returns a UnitDefinition that expresses the units of
measurement assumed for the "math" expression of this EventAssignment.
C<opydetails> doc_eventassignment_units 
C<opydetails> doc_note_unit_inference_depends_on_model 
C<opydetails> doc_warning_eventassignment_math_literals
@return a UnitDefinition that expresses the units of the math 
expression of this EventAssignment, or C<NULL> if one cannot be constructed.
@see containsUndeclaredUnits()


=item EventAssignment::getDerivedUnitDefinition

Calculates and returns a UnitDefinition that expresses the units of
measurement assumed for the "math" expression of this EventAssignment.
C<opydetails> doc_eventassignment_units 
C<opydetails> doc_note_unit_inference_depends_on_model 
C<opydetails> doc_warning_eventassignment_math_literals
@return a UnitDefinition that expresses the units of the math 
expression of this EventAssignment, or C<NULL> if one cannot be constructed.
@see containsUndeclaredUnits()


=item EventAssignment::containsUndeclaredUnits

Predicate returning C<true> if the math expression of this
EventAssignment contains literal numbers or parameters with undeclared
units.

C<opydetails> doc_eventassignment_units
If the expression contains literal numbers or parameters with undeclared
units, libSBML may not be able to compute the full units of the
expression and will only return what it can compute.  Callers should
always use containsUndeclaredUnits() when using
getDerivedUnitDefinition() to decide whether the
returned units may be incomplete.
@return C<true> if the math expression of this EventAssignment
includes parameters/numbers 
with undeclared units, C<false> otherwise.
@note A return value of C<true> indicates that the UnitDefinition
returned by getDerivedUnitDefinition() may not
accurately represent the units of the expression.
@see getDerivedUnitDefinition()


=item EventAssignment::containsUndeclaredUnits

Predicate returning C<true> if the math expression of this
EventAssignment contains literal numbers or parameters with undeclared
units.

C<opydetails> doc_eventassignment_units
If the expression contains literal numbers or parameters with undeclared
units, libSBML may not be able to compute the full units of the
expression and will only return what it can compute.  Callers should
always use containsUndeclaredUnits() when using
getDerivedUnitDefinition() to decide whether the
returned units may be incomplete.
@return C<true> if the math expression of this EventAssignment
exists and includes parameters/numbers 
with undeclared units, C<false> otherwise.
@note A return value of C<true> indicates that the UnitDefinition
returned by getDerivedUnitDefinition() may not
accurately represent the units of the expression.
@see getDerivedUnitDefinition()


=item EventAssignment::getTypeCode

Returns the libSBML type code of this object instance.
C<opydetails> doc_what_are_typecodes
@return the SBML type code for this object:
@link SBMLTypeCode_t#SBML_EVENT_ASSIGNMENT SBML_EVENT_ASSIGNMENT@endlink (default).
C<opydetails> doc_warning_typecodes_not_unique
@see getElementName()
@see getPackageName()


=item EventAssignment::getElementName

Returns the XML element name of this object, which for
EventAssignment, is always C<"eventAssignment">.
@return the name of this element, i.e., C<"eventAssignment">.


=item EventAssignment::writeElements

@internal


=item EventAssignment::hasRequiredAttributes

Predicate returning C<true> if all the required attributes for this
EventAssignment object have been set.
The required attributes for a EventAssignment object are:
@li "variable"
@return C<true> if the required attributes have been set, C<false>
otherwise.


=item EventAssignment::hasRequiredElements

Predicate returning C<true> if all the required elements for this
EventAssignment object have been set.
@note The required elements for an EventAssignment object are:
@li "math" in SBML Level&nbsp;2 and Level&nbsp;3 Version&nbsp;1.  
(In SBML Level&nbsp;3 Version&nbsp;2+, it is no longer required.)
@return a boolean value indicating whether all the required
elements for this object have been defined.


=item EventAssignment::getId

Returns the value of the "variable" attribute of this EventAssignment (NOT the "id").
@note Because of the inconsistent behavior of this function with 
respect to assignments and rules, it is now recommended to
use the getIdAttribute() or getVariable() instead.
The "variable" attribute of an EventAssignment indicates the element which
the results of the "math" are to be applied upon Event execution.
@return the variable of this EventAssignment.
@see getIdAttribute()
@see setIdAttribute(const std::string& sid)
@see isSetIdAttribute()
@see unsetIdAttribute()
@see getVariable()


=item EventAssignment::renameSIdRefs

C<opydoc> doc_renamesidref_common


=item EventAssignment::renameUnitSIdRefs

C<opydoc> doc_renameunitsidref_common


=item EventAssignment::replaceSIDWithFunction

@internal


=item EventAssignment::divideAssignmentsToSIdByFunction

@internal


=item EventAssignment::multiplyAssignmentsToSIdByFunction

@internal


=item EventAssignment::readOtherXML

@internal


=item EventAssignment::addExpectedAttributes

@internal


=item EventAssignment::readAttributes

@internal


=item EventAssignment::readL2Attributes

@internal


=item EventAssignment::readL3Attributes

@internal


=item EventAssignment::writeAttributes

@internal


=item ListOfEventAssignments::ListOfEventAssignments

Creates a new ListOfEventAssignments object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level.
@param version the Version within the SBML Level.
C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item ListOfEventAssignments::ListOfEventAssignments

Creates a new ListOfEventAssignments object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfEventAssignments object to be created.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item ListOfEventAssignments::clone

Creates and returns a deep copy of this ListOfEventAssignments object.
@return the (deep) copy of this ListOfEventAssignments object.


=item ListOfEventAssignments::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., EventAssignment objects, if the list is non-empty).
C<opydetails> doc_what_are_typecodes
@return the SBML type code for the objects contained in this ListOf:
@link SBMLTypeCode_t#SBML_EVENT_ASSIGNMENT SBML_EVENT_ASSIGNMENT@endlink (default).
@see getElementName()
@see getPackageName()


=item ListOfEventAssignments::getElementName

Returns the XML element name of this object.
For ListOfEventAssignments, the XML element name is @c
"listOfEventAssignments".

@return the name of this element, i.e., C<"listOfEventAssignments">.


=item ListOfEventAssignments::get

Get a EventAssignment from the ListOfEventAssignments.
@param n the index number of the EventAssignment to get.
@return the nth EventAssignment in this ListOfEventAssignments.
@see size()


=item ListOfEventAssignments::get

Get a EventAssignment from the ListOfEventAssignments.
@param n the index number of the EventAssignment to get.
@return the nth EventAssignment in this ListOfEventAssignments.
@see size()


=item ListOfEventAssignments::get

Get a EventAssignment from the ListOfEventAssignments
based on its identifier.
@param sid a string representing the identifier 
of the EventAssignment to get.
@return EventAssignment in this ListOfEventAssignments
with the given C<sid> or C<NULL> if no such
EventAssignment exists.
@see get(unsigned int n)
@see size()


=item ListOfEventAssignments::get

Get a EventAssignment from the ListOfEventAssignments
based on its identifier.
@param sid a string representing the identifier 
of the EventAssignment to get.
@return EventAssignment in this ListOfEventAssignments
with the given C<sid> or C<NULL> if no such
EventAssignment exists.
@see get(unsigned int n)
@see size()


=item ListOfEventAssignments::remove

Removes the nth item from this ListOfEventAssignments items and returns
a pointer to it.
The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove.
@see size()


=item ListOfEventAssignments::remove

Removes item in this ListOfEventAssignments items with the given
identifier.

The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove.
@return the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfEventAssignments::getElementBySId

Returns the first child element found that has the given C<id> in the
model-wide SId namespace, or C<NULL> if no such object is found.
Note that EventAssignments do not actually have IDs, but the libsbml
interface pretends that they do: no event assignment is returned by this
function.

@param id string representing the id of the object to find.
@return pointer to the first element found with the given C<id>.


=item ListOfEventAssignments::getElementPosition

@internal


=item ListOfEventAssignments::createObject

@internal


=back

=head2 Trigger

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html The trigger expression for an SBML <em>event</em>.
An Event object defines when the event can occur, the variables that are
affected by the event, and how the variables are affected.  The Trigger
construct in SBML is used to define a mathematical expression that
determines when an Event is I<triggered>.
A Trigger object in SBML Level&nbsp;2 and Level&nbsp;3 contains one
subelement named "math" containing a MathML expression.  The expression
is evaluated as a value of type C<boolean>.  The exact moment at which
the expression evaluates to C<true> is the time point when the Event is
I<triggered>.  In SBML Level&nbsp;3, Trigger has additional attributes
that must be assigned values; they are discussed in a separate section
below.

In SBML Level&nbsp;2 and SBML Level&nbsp;3 Version&nbsp;1, the "math"
subelement is required, and it must evaluate to a C<boolean> expression.
In SBML Level&nbsp;3 Version&nbsp;2, those restrictions are relaxed:
the "math" element is optional, and numeric values are allowed in 
Boolean contexts (a '0' is interpreted as C<false>, and all other
values are interpreted as C<true>).  If a Trigger with no "math"
is present in an Event, that Event will never I<trigger>, unless that
missing information is included in an SBML Level&nbsp;3 package.
An event only I<triggers> when its Trigger expression makes the
transition in value from C<false> to C<true>.  The event will also
trigger at any subsequent time points when the trigger makes this
transition; in other words, an event can be triggered multiple times
during a simulation if its trigger condition makes the transition from
C<false> to C<true> more than once.  In SBML Level&nbsp;3, the behavior
at the very start of simulation (i.e., at <em>t = 0</em>, where
<em>t</em> stands for time) is determined in part by the boolean flag
"initialValue".  This and other additional features introduced in SBML
Level&nbsp;3 are discussed further below.
@section trigger-version-diffs Version differences
SBML Level&nbsp;3 Version&nbsp;1 introduces two required attributes
on the Trigger object: "persistent" and "initialValue".  The rest of
this introduction describes these two attributes.
@subsection trigger-persistent The "persistent" attribute on Trigger
In the interval between when an Event object <em>triggers</em> (i.e.,
its Trigger object expression transitions in value from C<false> to
C<true>) and when its assignments are to be <em>executed</em>, conditions
in the model may change such that the trigger expression transitions
back from C<true> to C<false>.  Should the event's assignments still be
made if this happens?  Answering this question is the purpose of the
"persistent" attribute on Trigger.
If the boolean attribute "persistent" has a value of C<true>, then once
the event is triggered, all of its assignments are always performed when
the time of execution is reached.  The name I<persistent> is meant to
evoke the idea that the trigger expression does not have to be
re-checked after it triggers if "persistent"=C<true>.  Conversely, if
the attribute value is C<false>, then the trigger expression is not
assumed to persist: if the expression transitions in value back to @c
false at any time between when the event triggered and when it is to be
executed, the event is no longer considered to have triggered and its
assignments are not executed.  (If the trigger expression transitions
once more to C<true> after that point, then the event is triggered, but
this then constitutes a whole new event trigger-and-execute sequence.)
The "persistent" attribute can be especially useful when Event objects
contain Delay objects, but it is relevant even in a model without delays
if the model contains two or more events.  As explained in the
introduction to this section, the operation of all events in SBML
(delayed or not) is conceptually divided into two phases,
<em>triggering</em> and <em>execution</em>; however, unless events have
priorities associated with them, SBML does not mandate a particular
ordering of event execution in the case of simultaneous events.  Models
with multiple events can lead to situations where the execution of one
event affects another event's trigger expression value.  If that other
event has "persistent"=C<false>, and its trigger expression evaluates to
C<false> before it is to be executed, the event must not be executed
after all.
@subsection trigger-initialvalue The "initialValue" attribute on Trigger
As mentioned above, an event <em>triggers</em> when the mathematical
expression in its Trigger object transitions in value from C<false> to
C<true>.  An unanswered question concerns what happens at the start of a
simulation: can event triggers make this transition at <em>t = 0</em>,
where <em>t</em> stands for time?
In order to determine whether an event may trigger at <em>t = 0</em>, it
is necessary to know what value the Trigger object's "math" expression
had immediately prior to <em>t = 0</em>.  This starting value of the
trigger expression is determined by the value of the boolean attribute
"initialValue".  A value of C<true> means the trigger expression is
taken to have the value C<true> immediately prior to <em>t = 0</em>.  In
that case, the trigger cannot transition in value from C<false> to @c
true at the moment simulation begins (because it has the value C<true>
both before and after <em>t = 0</em>), and can only make the transition
from C<false> to C<true> sometime <em>after</em> <em>t = 0</em>.  (To do
that, it would also first have to transition to C<false> before it could
make the transition from C<false> back to C<true>.)  Conversely, if
"initialValue"=C<false>, then the trigger expression is assumed to start
with the value C<false>, and therefore may trigger at <em>t = 0</em> if
the expression evaluates to C<true> at that moment.
@see Event
@see Delay
@see EventAssignment

=over


=item Trigger::Trigger

Creates a new Trigger using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this Trigger.
@param version an unsigned int, the SBML Version to assign to this
Trigger.

C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item Trigger::Trigger

Creates a new Trigger using the given SBMLNamespaces object
C<sbmlns>.
C<opydetails> doc_what_are_sbmlnamespaces 
@param sbmlns an SBMLNamespaces object.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item Trigger::Trigger

Copy constructor; creates a copy of this Trigger.
@param orig the object to copy.


=item Trigger::accept

@internal


=item Trigger::clone

Creates and returns a deep copy of this Trigger object.
@return the (deep) copy of this Trigger object.


=item Trigger::getMath

Get the mathematical formula for the trigger and return it
as an AST.
@return the math of this Trigger, or C<NULL> if the math is not set.


=item Trigger::getInitialValue

(SBML Level&nbsp;3 only) Get the value of the "initialValue" attribute
of this Trigger.
@return the boolean value stored as the "initialValue" attribute value
in this Trigger.
@note The attribute "initialValue" is available in SBML Level&nbsp;3,
but is not present in lower Levels of SBML.


=item Trigger::getPersistent

(SBML Level&nbsp;3 only) Get the value of the "persistent" attribute
of this Trigger.
@return the boolean value stored as the "persistent" attribute value
in this Trigger.
@note The attribute "persistent" is available in SBML Level&nbsp;3,
but is not present in lower Levels of SBML.


=item Trigger::isSetMath

Predicate to test whether the math for this trigger is set.
@return C<true> if the formula (meaning the "math" subelement) of
this Trigger is set, C<false> otherwise.


=item Trigger::isSetInitialValue

(SBML Level&nbsp;3 only) Predicate to test whether the "initialValue"
attribute for this trigger is set.
@return C<true> if the initialValue attribute of
this Trigger is set, C<false> otherwise.
@note The attribute "initialValue" is available in SBML Level&nbsp;3,
but is not present in lower Levels of SBML.


=item Trigger::isSetPersistent

(SBML Level&nbsp;3 only) Predicate to test whether the "persistent"
attribute for this trigger is set.
@return C<true> if the persistent attribute of
this Trigger is set, C<false> otherwise.
@note The attribute "persistent" is available in SBML Level&nbsp;3,
but is not present in lower Levels of SBML.


=item Trigger::setMath

Sets the trigger expression of this Trigger instance to a copy of the given
ASTNode.

@param math an ASTNode representing a formula tree.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink


=item Trigger::setInitialValue

(SBML Level&nbsp;3 only) Sets the "initialValue" attribute of this Trigger instance.
@param initialValue a boolean representing the initialValue to be set.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@note The attribute "initialValue" is available in SBML Level&nbsp;3,
but is not present in lower Levels of SBML.


=item Trigger::setPersistent

(SBML Level&nbsp;3 only) Sets the "persistent" attribute of this Trigger instance.
@param persistent a boolean representing the persistent value to be set.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@note The attribute "persistent" is available in SBML Level&nbsp;3,
but is not present in lower Levels of SBML.


=item Trigger::unsetInitialValue

(SBML Level&nbsp;3 only) Unsets the "initialValue" attribute of this 
Trigger instance.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@note The attribute "initialValue" is available in SBML Level&nbsp;3,
but is not present in lower Levels of SBML.


=item Trigger::unsetPersistent

(SBML Level&nbsp;3 only) Unsets the "persistent" attribute of this 
Trigger instance.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@note The attribute "persistent" is available in SBML Level&nbsp;3,
but is not present in lower Levels of SBML.


=item Trigger::getTypeCode

Returns the libSBML type code of this object instance.
C<opydetails> doc_what_are_typecodes
@return the SBML type code for this object:
@link SBMLTypeCode_t#SBML_TRIGGER SBML_TRIGGER@endlink (default).
C<opydetails> doc_warning_typecodes_not_unique
@see getElementName()
@see getPackageName()


=item Trigger::getElementName

Returns the XML element name of this object, which for Trigger, is
always C<"trigger">.
@return the name of this element, i.e., C<"trigger">.


=item Trigger::renameSIdRefs

C<opydoc> doc_renamesidref_common


=item Trigger::renameUnitSIdRefs

C<opydoc> doc_renameunitsidref_common


=item Trigger::replaceSIDWithFunction

@internal


=item Trigger::getElementPosition

@internal


=item Trigger::writeElements

@internal


=item Trigger::hasRequiredElements

Predicate returning C<true> if
all the required elements for this Trigger object
have been set.
@note The required elements for a Trigger object are:
@li "math" inSBML Level&nbsp;2 and Level&nbsp;3 Version&nbsp;1.  
(In SBML Level&nbsp;3 Version&nbsp;2+, it is no longer required.)
@return a boolean value indicating whether all the required
elements for this object have been defined.


=item Trigger::hasRequiredAttributes

Predicate returning C<true> if
all the required attributes for this Trigger object
have been set.
The required attributes for a Trigger object are:
@li "persistent" (required in SBML Level&nbsp;3)
@li "initialValue" (required in SBML Level&nbsp;3)
@return a boolean value indicating whether all the required
attributes for this object have been defined.


=item Trigger::removeFromParentAndDelete

Finds this Trigger's Event parent and calls unsetTrigger() on it, indirectly deleting itself.  Overridden from the SBase function since the parent is not a ListOf.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink


=item Trigger::readOtherXML

@internal


=item Trigger::addExpectedAttributes

@internal


=item Trigger::readAttributes

@internal


=item Trigger::readL2Attributes

@internal


=item Trigger::readL3Attributes

@internal


=item Trigger::writeAttributes

@internal


=back

=head2 Delay

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html A delay on the time of execution of an SBML <em>event</em>.
An Event object defines when the event can occur, the variables that
are affected by the event, and how the variables are affected.  The
effect of the event can optionally be delayed after the occurrence of
the condition which invokes it.  An event delay is defined using an
object of class Delay.
The object class Delay is derived from SBase and adds a single
subelement called "math".  This subelement is used to hold MathML
content.  The mathematical formula represented by "math" must evaluate
to a numerical value.  It is used as the length of time between when the
event is I<triggered> and when the event's assignments are
actually I<executed>.  If no delay is present on a given Event, a time
delay of zero is assumed.
The expression in "math" must be evaluated at the time the event is @em
triggered.  The expression must always evaluate to a nonnegative number
(otherwise, a nonsensical situation could arise where an event is
defined to execute before it is triggered!).
@section delay-units The units of the mathematical expression in a Delay
In SBML Level&nbsp;2 versions before Version&nbsp;4, the units of the
numerical value computed by the Delay's "math" expression are @em
required to be in units of time, or the model is considered to have a
unit consistency error.  In Level&nbsp;2 Version&nbsp;4 as well as SBML
Level&nbsp;3, this requirement is relaxed; these
specifications only stipulate that the units of the numerical value
computed by a Delay instance's "math" expression I<should> match the
model's units of time (meaning the definition of the C<time> units in
the model).  LibSBML respects these requirements, and depending on
whether an earlier Version of SBML Level&nbsp;2 is in use, libSBML may
or may not flag unit inconsistencies as errors or merely warnings.
Note that <em>units are not predefined or assumed</em> for the contents
of "math" in a Delay object; rather, they must be defined explicitly for
each instance of a Delay object in a model.  This is an important point
to bear in mind when literal numbers are used in delay expressions.  For
example, the following Event instance would result in a warning logged
by SBMLDocument::checkConsistency() about the fact that libSBML cannot
verify the consistency of the units of the expression.  The reason is
that the formula inside the "math" element does not have any declared
units, whereas what is expected in this context is units of time:
@verbatim
<model>
...
<listOfEvents>
<event useValuesFromTriggerTime="true">
...
<delay>
<math xmlns="http://www.w3.org/1998/Math/MathML">
<cn> 1 </cn>
</math>
</delay>
...
</event>
</listOfEvents>
...
</model>
@endverbatim
The C<&lt;cn&gt; 1 &lt;/cn&gt;> within the mathematical formula
of the C<delay> above has <em>no units declared</em>.  To make the
expression have the needed units of time, literal numbers should be
avoided in favor of defining Parameter objects for each quantity, and
declaring units for the Parameter values.  The following fragment of
SBML illustrates this approach:
@verbatim
<model>
...
<listOfParameters>
<parameter id="transcriptionDelay" value="10" units="second"/>
</listOfParameters>
...
<listOfEvents>
<event useValuesFromTriggerTime="true">
...
<delay>
<math xmlns="http://www.w3.org/1998/Math/MathML">
<ci> transcriptionDelay </ci>
</math>
</delay>
...
</event>
</listOfEvents>
...
</model>
@endverbatim
In SBML Level&nbsp;3, an alternative approach is available in the form
of the C<units> attribute, which SBML Level&nbsp;3 allows to appear on
MathML C<cn> elements.  The value of this attribute can be used to
indicate the unit of measurement to be associated with the number in the
content of a C<cn> element.  The attribute is named C<units> but,
because it appears inside MathML element (which is in the XML namespace
for MathML and not the namespace for SBML), it must always be prefixed
with an XML namespace prefix for an SBML Level&nbsp;3
namespace.  The following is an example of this approach:
@verbatim
<model timeUnits="second" ...>
...
<listOfEvents>
<event useValuesFromTriggerTime="true">
...
<delay>
<math xmlns="http://www.w3.org/1998/Math/MathML"
xmlns:sbml="http://www.sbml.org/sbml/level3/version1/core">
<cn sbml:units="second"> 10 </cn>
</math>
</delay>
...
</event>
</listOfEvents>
...
</model>
@endverbatim
@section delay-restrictions Restrictions relaxed in SBML Level&nbsp;3 Version&nbsp;2
In SBML Level&nbsp;3 Version&nbsp;2, the requirement that a Delay
have a "math" subelement was relaxed, making it optional.  In
this case, the Delay remains undefined, and unless that information
is provided in some other form (such as with an SBML Level&nbsp;3
package), the Event behaves as if it had no Delay.

=over


=item Delay::Delay

Creates a new Delay using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this Delay.
@param version an unsigned int, the SBML Version to assign to this
Delay.

C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv


=item Delay::Delay

Creates a new Delay using the given SBMLNamespaces object
C<sbmlns>.
C<opydetails> doc_what_are_sbmlnamespaces
@param sbmlns an SBMLNamespaces object.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv


=item Delay::Delay

Copy constructor; creates a copy of this Delay.
@param orig the object to copy.


=item Delay::accept

@internal


=item Delay::clone

Creates and returns a deep copy of this Delay object.
@return the (deep) copy of this Delay object.


=item Delay::getMath

Get the mathematical formula for the delay and return it
as an AST.
@return the math of this Delay, or C<NULL> if the math is not set.


=item Delay::isSetMath

Predicate to test whether the formula for this delay is set.
@return C<true> if the formula (meaning the C<math> subelement) of
this Delay is set, C<false> otherwise.


=item Delay::setMath

Sets the delay expression of this Delay instance to a copy of the given
ASTNode.

@param math an ASTNode representing a formula tree.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink


=item Delay::getDerivedUnitDefinition

Calculates and returns a UnitDefinition that expresses the units
of measurement assumed for the "math" expression of this Delay.
C<opydetails> doc_delay_units
C<opydetails> doc_note_unit_inference_depends_on_model 
C<opydetails> doc_warning_delay_math_literals
@return a UnitDefinition that expresses the units of the math 
expression of this Delay, or C<NULL> if one cannot be constructed.
@see containsUndeclaredUnits()


=item Delay::getDerivedUnitDefinition

Calculates and returns a UnitDefinition that expresses the units
of measurement assumed for the "math" expression of this Delay.
C<opydetails> doc_delay_units
C<opydetails> doc_note_unit_inference_depends_on_model 
C<opydetails> doc_warning_delay_math_literals
@return a UnitDefinition that expresses the units of the math 
expression of this Delay, or C<NULL> if one cannot be constructed.
@see containsUndeclaredUnits()


=item Delay::containsUndeclaredUnits

Predicate returning C<true> if the "math" expression in this Delay
instance contains parameters with undeclared units or literal numbers.
C<opydetails> doc_delay_units
If the expression contains literal numbers or parameters with undeclared
units, <strong>libSBML may not be able to compute the full units of the
expression</strong> and will only return what it can compute.  Callers
should always use Delay::containsUndeclaredUnits() when using
Delay::getDerivedUnitDefinition() to decide whether the returned units
may be incomplete.
@return C<true> if the math expression of this Delay includes
numbers/parameters with undeclared units, C<false> otherwise.
@note A return value of C<true> indicates that the UnitDefinition
returned by Delay::getDerivedUnitDefinition() may not accurately
represent the units of the expression.
@see getDerivedUnitDefinition()


=item Delay::containsUndeclaredUnits

Predicate returning C<true> if the "math" expression in this Delay
instance contains parameters with undeclared units or literal numbers.
C<opydetails> doc_delay_units
If the expression contains literal numbers or parameters with undeclared
units, <strong>libSBML may not be able to compute the full units of the
expression</strong> and will only return what it can compute.  Callers
should always use Delay::containsUndeclaredUnits() when using
Delay::getDerivedUnitDefinition() to decide whether the returned units
may be incomplete.
@return C<true> if the math expression of this Delay includes
numbers/parameters with undeclared units, C<false> otherwise.
@note A return value of C<true> indicates that the UnitDefinition
returned by Delay::getDerivedUnitDefinition() may not accurately
represent the units of the expression.
@see getDerivedUnitDefinition()


=item Delay::getTypeCode

Returns the libSBML type code of this object instance.
C<opydetails> doc_what_are_typecodes
@return the SBML type code for this object:
@link SBMLTypeCode_t#SBML_DELAY SBML_DELAY@endlink (default).
C<opydetails> doc_warning_typecodes_not_unique
@see getElementName()
@see getPackageName()


=item Delay::getElementName

Returns the XML element name of this object, which for Delay, is
always C<"delay">.
@return the name of this element, i.e., C<"delay">.
@see getTypeCode()


=item Delay::getElementPosition

@internal


=item Delay::writeElements

@internal


=item Delay::hasRequiredElements

Predicate returning C<true> if
all the required elements for this Delay object
have been set.
@note The required elements for a Delay object are:
@li "math" inSBML Level&nbsp;2 and Level&nbsp;3 Version&nbsp;1.  
(In SBML Level&nbsp;3 Version&nbsp;2+, it is no longer required.)
@return a boolean value indicating whether all the required
elements for this object have been defined.


=item Delay::removeFromParentAndDelete

Finds this Delay's Event parent and calls unsetDelay() on it, indirectly
deleting itself.
Overridden from the SBase function since the parent is not a ListOf.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink


=item Delay::renameSIdRefs

C<opydoc> doc_renamesidref_common


=item Delay::renameUnitSIdRefs

C<opydoc> doc_renameunitsidref_common


=item Delay::replaceSIDWithFunction

@internal


=item Delay::getInternalId

@internal


=item Delay::setInternalId

@internal


=item Delay::readOtherXML

@internal


=item Delay::addExpectedAttributes

@internal


=item Delay::readAttributes

@internal


=item Delay::readL2Attributes

@internal


=item Delay::readL3Attributes

@internal


=item Delay::writeAttributes

@internal


=back

=head2 Priority

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html The priority of execution of an SBML <em>event</em>.
The Priority object class (which was introduced in SBML Level&nbsp;3
Version&nbsp;1), like Delay, is derived from SBase and contains a MathML
formula stored in the element "math".  This formula is used to compute a
dimensionless numerical value that influences the order in which a
simulator is to perform the assignments of two or more events that
happen to be executed simultaneously.  The formula may evaluate to any
C<double> value (and thus may be a positive or negative number, or
zero), with positive numbers taken to signifying a higher priority than
zero or negative numbers.  If no Priority object is present on a given
Event object, no priority is defined for that event.
@section priority-interp The interpretation of priorities on events in a model
For the purposes of SBML, <em>simultaneous event execution</em> is
defined as the situation in which multiple events have identical
times of execution.  The time of execution is calculated as the
sum of the time at which a given event's Trigger is <em>triggered</em>
plus its Delay duration, if any.  Here, <em>identical times</em> means
<em>mathematically equal</em> instants in time.  (In practice,
simulation software adhering to this specification may have to
rely on numerical equality instead of strict mathematical
equality; robust models will ensure that this difference will not
cause significant discrepancies from expected behavior.)
If no Priority subobjects are defined for two or more Event objects,
then those events are still executed simultaneously but their order of
execution is <em>undefined by the SBML Level&nbsp;3
specification</em>.  A software implementation may choose to execute
such simultaneous events in any order, as long as each event is executed
only once and the requirements of checking the "persistent" attribute
(and acting accordingly) are satisfied.
If Priority subobjects are defined for two or more
simultaneously-triggered events, the order in which those particular
events must be executed is dictated by their Priority objects,
as follows.  If the values calculated using the two Priority
objects' "math" expressions differ, then the event having
the higher priority value must be executed before the event with
the lower value.  If, instead, the two priority values are
mathematically equal, then the two events must be triggered in a
<em>random</em> order.  It is important to note that a <em>random
order is not the same as an undefined order</em>: given multiple
runs of the same model with identical conditions, an undefined
ordering would permit a system to execute the events in (for
example) the same order every time (according to whatever scheme
may have been implemented by the system), whereas the explicit
requirement for random ordering means that the order of execution
in different simulation runs depends on random chance.  In other
words, given two events <em>A</em> and <em>B</em>, a randomly-determined
order must lead to an equal chance of executing <em>A</em> first or
<em>B</em> first, every time those two events are executed
simultaneously.

A model may contain a mixture of events, some of which have
Priority subobjects and some do not.  Should a combination of
simultaneous events arise in which some events have priorities
defined and others do not, the set of events with defined
priorities must trigger in the order determined by their Priority
objects, and the set of events without Priority objects must be
executed in an <em>undefined</em> order with respect to each other
and with respect to the events with Priority subobjects.  (Note
that <em>undefined order</em> does not necessarily mean random
order, although a random ordering would be a valid implementation
of this requirement.)
The following example may help further clarify these points.
Suppose a model contains four events that should be executed
simultaneously, with two of the events having Priority objects
with the same value and the other two events having Priority
objects with the same, but different, value.  The two events with
the higher priorities must be executed first, in a random order
with respect to each other, and the remaining two events must be
executed after them, again in a random order, for a total of four
possible and equally-likely event executions: A-B-C-D, A-B-D-C,
B-A-C-D, and B-A-D-C.  If, instead, the model contains four events
all having the same Priority values, there are 4! or 24
possible orderings, each of which must be equally likely to be
chosen.  Finally, if none of the four events has a Priority
subobject defined, or even if exactly one of the four events has a
defined Priority, there are again 24 possible orderings, but the
likelihood of choosing any particular ordering is undefined; the
simulator can choose between events as it wishes.  (The SBML
specification only defines the effects of priorities on Event
objects with respect to <em>other</em> Event objects with
priorities.  Putting a priority on a <em>single</em> Event object
in a model does not cause it to fall within that scope.)
@section priority-eval Evaluation of Priority expressions
An event's Priority object "math" expression must be
evaluated at the time the Event is to be <em>executed</em>.  During
a simulation, all simultaneous events have their Priority values
calculated, and the event with the highest priority is selected for
next execution.  Note that it is possible for the execution of one
Event object to cause the Priority value of another
simultaneously-executing Event object to change (as well as to
trigger other events, as already noted).  Thus, after executing
one event, and checking whether any other events in the model have
been triggered, all remaining simultaneous events that
<em>either</em> (i) have Trigger objects with attributes
"persistent"=C<false> <em>or</em> (ii) have Trigger
expressions that did not transition from C<true> to
C<false>, must have their Priority expression reevaluated.
The highest-priority remaining event must then be selected for 
execution next.
@section priority-units Units of Priority object's mathematical expressions
The unit associated with the value of a Priority object's
"math" expression should be C<dimensionless>.  This is
because the priority expression only serves to provide a relative
ordering between different events, and only has meaning with
respect to other Priority object expressions.  The value of
Priority objects is not comparable to any other kind of object in
an SBML model.
@note The Priority construct exists only in SBML Level&nbsp;3; it cannot
be used in SBML Level&nbsp;2 or Level&nbsp;1 models.
@section priority-restrictions Restrictions relaxed in SBML Level&nbsp;3 Version&nbsp;2
In SBML Level&nbsp;3 Version&nbsp;2, the requirement that a Priority
have a "math" subelement was relaxed, making it optional.  In
this case, the Priority remains undefined, and unless that information
is provided in some other form (such as with an SBML Level&nbsp;3
package), the Event behaves as if it had no Priority.
@see Event
@see Delay
@see EventAssignment

=over


=item Priority::Priority

Creates a new Priority object using the given SBML C<level> and @p
version values.
@param level an unsigned int, the SBML Level to assign to this Priority.
@param version an unsigned int, the SBML Version to assign to this
Priority.

C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_setting_lv
C<opydetails> doc_note_priority_only_l3


=item Priority::Priority

Creates a new Priority object using the given SBMLNamespaces object
C<sbmlns>.
C<opydetails> doc_what_are_sbmlnamespaces 
@param sbmlns an SBMLNamespaces object.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_setting_lv
C<opydetails> doc_note_priority_only_l3


=item Priority::Priority

Copy constructor; creates a copy of this Priority.
@param orig the object to copy.


=item Priority::accept

@internal


=item Priority::clone

Creates and returns a deep copy of this Priority object.
@return the (deep) copy of this Priority object.


=item Priority::getMath

Get the mathematical formula for the priority and return it
as an AST.
@return the math of this Priority, or C<NULL> if the math is not set.


=item Priority::isSetMath

Predicate to test whether the formula for this delay is set.
@return C<true> if the formula (meaning the C<math> subelement) of
this Priority is set, C<false> otherwise.


=item Priority::setMath

Sets the math expression of this Priority instance to a copy of the given
ASTNode.

@param math an ASTNode representing a formula tree.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink


=item Priority::getTypeCode

Returns the libSBML type code of this object instance.
C<opydetails> doc_what_are_typecodes
@return the SBML type code for this object:
@link SBMLTypeCode_t#SBML_PRIORITY SBML_PRIORITY@endlink (default).\
C<opydetails> doc_warning_typecodes_not_unique
@see getElementName()
@see getPackageName()


=item Priority::getElementName

Returns the XML element name of this object, which for Priority, is
always C<"priority">.
@return the name of this element, i.e., C<"priority">.
@see getTypeCode()


=item Priority::getElementPosition

@internal


=item Priority::writeElements

@internal


=item Priority::hasRequiredElements

Predicate returning C<true> if all the required elements for this
Priority object have been set.
@note The required elements for a Priority object are:
@li "math" inSBML Level&nbsp;2 and Level&nbsp;3 Version&nbsp;1.  
(In SBML Level&nbsp;3 Version&nbsp;2+, it is no longer required.)
@return a boolean value indicating whether all the required
elements for this object have been defined.


=item Priority::removeFromParentAndDelete

Finds this Priority's Event parent and calls unsetPriority() on it,
indirectly deleting itself.
Overridden from the SBase function since the parent is not a ListOf.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink


=item Priority::renameSIdRefs

C<opydoc> doc_renamesidref_common


=item Priority::renameUnitSIdRefs

C<opydoc> doc_renameunitsidref_common


=item Priority::replaceSIDWithFunction

@internal


=item Priority::getInternalId

@internal


=item Priority::setInternalId

@internal


=item Priority::readOtherXML

@internal


=item Priority::addExpectedAttributes

@internal


=item Priority::readAttributes

@internal


=item Priority::readL3Attributes

@internal


=item Priority::writeAttributes

@internal


=back

=head2 SBO

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html Facilities for using the Systems Biology Ontology.
@htmlinclude not-sbml-warning.html
The values of "id" attributes on SBML components allow the components to
be cross-referenced within a model. The values of "name" attributes on
SBML components provide the opportunity to assign them meaningful labels
suitable for display to humans.  The specific identifiers and labels
used in a model necessarily must be unrestricted by SBML, so that
software and users are free to pick whatever they need.  However, this
freedom makes it more difficult for software tools to determine, without
additional human intervention, the semantics of models more precisely
than the semantics provided by the SBML object classes defined in other
sections of this document.  For example, there is nothing inherent in a
parameter with identifier C<k> that would indicate to a
software tool it is a first-order rate constant (if that's what
C<k> happened to be in some given model).  However, one may
need to convert a model between different representations (e.g.,
Henri-Michaelis-Menten versus elementary steps), or to use it with
different modeling approaches (discrete or continuous).  One may also
need to relate the model components with other description formats such
as SBGN (<a target="_blank"
href="http://www.sbgn.org/">http://www.sbgn.org/</a>) using deeper
semantics.  Although an advanced software tool <em>might</em> be able to
deduce the semantics of some model components through detailed analysis
of the kinetic rate expressions and other parts of the model, this
quickly becomes infeasible for any but the simplest of models.
An approach to solving this problem is to associate model components
with terms from carefully curated controlled vocabularies (CVs).  This
is the purpose of the optional "sboTerm" attribute provided on the SBML
class SBase.  The "sboTerm" attribute always refers to terms belonging
to the Systems Biology Ontology (SBO).
@section use Use of SBO
Labeling model components with terms from shared controlled vocabularies
allows a software tool to identify each component using identifiers that
are not tool-specific.  An example of where this is useful is the desire
by many software developers to provide users with meaningful names for
reaction rate equations.  Software tools with editing interfaces
frequently provide these names in menus or lists of choices for users.
However, without a standardized set of names or identifiers shared
between developers, a given software package cannot reliably interpret
the names or identifiers of reactions used in models written by other
tools.

The first solution that might come to mind is to stipulate that certain
common reactions always have the same name (e.g., "Michaelis-Menten"), but
this is simply impossible to do: not only do humans often disagree on
the names themselves, but it would not allow for correction of errors or
updates to the list of predefined names except by issuing new releases
of the SBML specification---to say nothing of many other limitations
with this approach.  Moreover, the parameters and variables that appear
in rate expressions also need to be identified in a way that software
tools can interpret mechanically, implying that the names of these
entities would also need to be regulated.
The Systems Biology Ontology (SBO) provides terms for identifying most
elements of SBML. The relationship implied by an "sboTerm" on an SBML
model component is <em>is-a</em> between the characteristic of the
component meant to be described by SBO on this element and the SBO
term identified by the value of the "sboTerm". By adding SBO term
references on the components of a model, a software tool can provide
additional details using independent, shared vocabularies that can
enable <em>other</em> software tools to recognize precisely what the
component is meant to be.  Those tools can then act on that information.
For example, if the SBO identifier C<"SBO>:0000049" is assigned
to the concept of "first-order irreversible mass-action kinetics,
continuous framework", and a given KineticLaw object in a model has an
"sboTerm" attribute with this value, then regardless of the identifier
and name given to the reaction itself, a software tool could use this to
inform users that the reaction is a first-order irreversible mass-action
reaction.  This kind of reverse engineering of the meaning of reactions
in a model would be difficult to do otherwise, especially for more
complex reaction types.
The presence of SBO labels on Compartment, Species, and Reaction
objects in SBML can help map those entities to equivalent concepts in
other standards, such as (but not limited to) BioPAX (<a target="_blank"
href="http://www.biopax.org/">http://www.biopax.org/</a>), PSI-MI (<a
target="_blank"
href="http://www.psidev.info/index.php?q=node/60">http://www.psidev.info</a>),
or the Systems Biology Graphical Notation (SBGN, <a target="_blank"
href="http://www.sbgn.org/">http://www.sbgn.org/</a>).  Such mappings
can be used in conversion procedures, or to build interfaces, with SBO
becoming a kind of "glue" between standards of representation.
The presence of the label on a kinetic expression can also allow
software tools to make more intelligent decisions about reaction rate
expressions.  For example, an application could recognize certain types
of reaction formulas as being ones it knows how to solve with optimized
procedures.  The application could then use internal, optimized code
implementing the rate formula indexed by identifiers such as
C<"SBO>:0000049" appearing in SBML models.
Finally, SBO labels may be very valuable when it comes to model
integration, by helping identify interfaces, convert mathematical
expressions and parameters etc.
Although the use of SBO can be beneficial, it is critical to keep in
mind that the presence of an "sboTerm" value on an object <em>must not
change the fundamental mathematical meaning</em> of the model.  An SBML
model must be defined such that it stands on its own and does not depend
on additional information added by SBO terms for a correct mathematical
interpretation.  SBO term definitions will not imply any alternative
mathematical semantics for any SBML object labeled with that term.  Two
important reasons motivate this principle.  First, it would be too
limiting to require all software tools to be able to understand the SBO
vocabularies in addition to understanding SBML.  Supporting SBO is not
only additional work for the software developer; for some kinds of
applications, it may not make sense.  If SBO terms on a model are
optional, it follows that the SBML model <em>must</em> remain
unambiguous and fully interpretable without them, because an application
reading the model may ignore the terms.  Second, we believe allowing the
use of "sboTerm" to alter the mathematical meaning of a model would
allow too much leeway to shoehorn inconsistent concepts into SBML
objects, ultimately reducing the interoperability of the models.
@section relationship Relationships between SBO and SBML
The goal of SBO labeling for SBML is to clarify to the fullest extent
possible the nature of each element in a model.  The approach taken in
SBO begins with a hierarchically-structured set of controlled
vocabularies with six main divisions: (1) entity, (2) participant role,
(3) quantitative parameter, (4) modeling framework, (5) mathematical
expression, and (6) interaction.  The web site for SBO (<a
target="_blank"
href="http://biomodels.net/sbo">http://biomodels.net</a>) should be
consulted for the current version of the ontology.
The Systems Biology Ontology (SBO) is not part of SBML; it is being
developed separately, to allow the modeling community to evolve the
ontology independently of SBML.  However, the terms in the ontology are
being designed keeping SBML components in mind, and are classified into
subsets that can be directly related with SBML components such as
reaction rate expressions, parameters, and others.  The use of "sboTerm"
attributes is optional, and the presence of "sboTerm" on an element does
not change the way the model is <em>interpreted</em>.  Annotating SBML
elements with SBO terms adds additional semantic information that may
be used to <em>convert</em> the model into another model, or another
format.  Although SBO support provides an important source of
information to understand the meaning of a model, software does not need
to support "sboTerm" to be considered SBML-compliant.

=over


=item SBO::readTerm

@internal


=item SBO::writeTerm

@internal


=item SBO::isQuantitativeParameter

Returns C<true> if the given term identifier comes from the stated branch of SBO.
@note The I<"quantitative> parameter" SBO term is now known as "systems description parameter".
@return C<true> if C<term> is-a SBO <em>"quantiative parameter"</em>, C<false>
otherwise.

C<opydetails> doc_note_static_methods


=item SBO::isParticipantRole

Returns C<true> if the given term identifier comes from the stated branch of SBO.
@return C<true> if C<term> is-a SBO <em>"participant role"</em>, C<false> otherwise.
C<opydetails> doc_note_static_methods


=item SBO::isModellingFramework

Returns C<true> if the given term identifier comes from the stated branch of SBO.
@return C<true> if C<term> is-a SBO <em>"modeling framework"</em>, C<false> otherwise.
C<opydetails> doc_note_static_methods


=item SBO::isMathematicalExpression

Returns C<true> if the given term identifier comes from the stated branch of SBO.
@return C<true> if C<term> is-a SBO <em>"mathematical expression"</em>, C<false> otherwise.
C<opydetails> doc_note_static_methods


=item SBO::isKineticConstant

Returns C<true> if the given term identifier comes from the stated branch of SBO.
@return C<true> if C<term> is-a SBO <em>"kinetic constant"</em>, C<false> otherwise.
C<opydetails> doc_note_static_methods


=item SBO::isReactant

Returns C<true> if the given term identifier comes from the stated branch of SBO.
@return C<true> if C<term> is-a SBO <em>"reactant"</em>, C<false> otherwise.
C<opydetails> doc_note_static_methods


=item SBO::isProduct

Returns C<true> if the given term identifier comes from the stated branch of SBO.
@return C<true> if C<term> is-a SBO <em>"product"</em>, C<false> otherwise.
C<opydetails> doc_note_static_methods


=item SBO::isModifier

Returns C<true> if the given term identifier comes from the stated branch of SBO.
@return C<true> if C<term> is-a SBO <em>"modifier"</em>, C<false> otherwise.
C<opydetails> doc_note_static_methods


=item SBO::isRateLaw

Returns C<true> if the given term identifier comes from the stated branch of SBO.
@return C<true> if C<term> is-a SBO <em>"rate law"</em>, C<false> otherwise.
C<opydetails> doc_note_static_methods


=item SBO::isEvent

Returns C<true> if the given term identifier comes from the stated branch of SBO.
@return C<true> if C<term> is-a SBO <em>"event"</em>, C<false> otherwise.
C<opydetails> doc_note_static_methods


=item SBO::isPhysicalParticipant

Returns C<true> if the given term identifier comes from the stated branch of SBO.
@return C<true> if C<term> is-a SBO <em>"physical participant</em>, C<false> otherwise.
C<opydetails> doc_note_static_methods


=item SBO::isParticipant

Returns C<true> if the given term identifier comes from the stated branch of SBO.
@return C<true> if C<term> is-a SBO <em>"participant"</em>, C<false> otherwise.
C<opydetails> doc_note_static_methods


=item SBO::isInteraction

Returns C<true> if the given term identifier comes from the stated branch of SBO.
@note The I<"interaction"> SBO term is now known as "occurring entity representation".
@return C<true> if C<term> is-a SBO <em>"interaction"</em>, C<false> otherwise.
C<opydetails> doc_note_static_methods


=item SBO::isEntity

Returns C<true> if the given term identifier comes from the stated branch of SBO.
@note The I<"entity"> SBO term is now known as "physical entity representation".
@return C<true> if C<term> is-a SBO <em>"entity"</em>, C<false> otherwise.
C<opydetails> doc_note_static_methods


=item SBO::isFunctionalEntity

Returns C<true> if the given term identifier comes from the stated branch of SBO.
@return C<true> if C<term> is-a SBO <em>"functional entity"</em>, C<false> otherwise.
C<opydetails> doc_note_static_methods


=item SBO::isMaterialEntity

Returns C<true> if the given term identifier comes from the stated branch of SBO.
@return C<true> if C<term> is-a SBO <em>"material entity"</em>, C<false> otherwise.
C<opydetails> doc_note_static_methods


=item SBO::isConservationLaw

Returns C<true> if the given term identifier comes from the stated branch of SBO.
@return C<true> if C<term> is-a SBO <em>"conservation law"</em>, C<false> otherwise.
C<opydetails> doc_note_static_methods


=item SBO::isSteadyStateExpression

Returns C<true> if the given term identifier comes from the stated branch of SBO.
@return C<true> if C<term> is-a SBO <em>"steady state expression"</em>, C<false> otherwise.
C<opydetails> doc_note_static_methods


=item SBO::isFunctionalCompartment

Returns C<true> if the given term identifier comes from the stated branch of SBO.
@return C<true> if C<term> is-a SBO <em>"functional compartment"</em>, C<false> otherwise.
C<opydetails> doc_note_static_methods


=item SBO::isContinuousFramework

Returns C<true> if the given term identifier comes from the stated branch of SBO.
@return C<true> if C<term> is-a SBO <em>"continuous framework"</em>, C<false> otherwise.
C<opydetails> doc_note_static_methods


=item SBO::isDiscreteFramework

Returns C<true> if the given term identifier comes from the stated branch of SBO.
@return C<true> if C<term> is-a SBO <em>"discrete framework"</em>, C<false> otherwise.
C<opydetails> doc_note_static_methods


=item SBO::isLogicalFramework

Returns C<true> if the given term identifier comes from the stated branch of SBO.
@return C<true> if C<term> is-a SBO <em>"logical framework"</em>, C<false> otherwise.
C<opydetails> doc_note_static_methods


=item SBO::isMetadataRepresentation

Returns C<true> if the given term identifier comes from the stated branch of SBO.
@return C<true> if C<term> is-a SBO <em>"metadata representation"</em>, C<false> otherwise.
C<opydetails> doc_note_static_methods


=item SBO::isOccurringEntityRepresentation

Returns C<true> if the given term identifier comes from the stated branch of SBO.
@return C<true> if C<term> is-a SBO <em>"occurring entity representation"</em>, C<false> otherwise.
C<opydetails> doc_note_static_methods


=item SBO::isPhysicalEntityRepresentation

Returns C<true> if the given term identifier comes from the stated branch of SBO.
@return C<true> if C<term> is-a SBO <em>"physical entity representation"</em>, C<false> otherwise.
C<opydetails> doc_note_static_methods


=item SBO::isSystemsDescriptionParameter

Returns C<true> if the given term identifier comes from the stated branch of SBO.
@return C<true> if C<term> is-a SBO <em>"systems description parameter"</em>, C<false> otherwise.
C<opydetails> doc_note_static_methods


=item SBO::isQuantitativeSystemsDescriptionParameter

Returns C<true> if the given term identifier comes from the stated branch of SBO.
@return C<true> if C<term> is-a SBO <em>"quantiative systems description parameter"</em>, C<false>
otherwise.

C<opydetails> doc_note_static_methods


=item SBO::isObselete

Predicate for checking whether the given term is obsolete.
@return C<true> if C<term> is-a SBO <em>"obsolete"</em> term, C<false> otherwise.
C<opydetails> doc_note_static_methods


=item SBO::intToString

Returns the integer as a correctly formatted SBO identifier string.
@return the given integer sboTerm as a zero-padded seven digit string.
@note If the sboTerm is not in the correct range
(0000000&ndash;9999999), an empty string is returned.
C<opydetails> doc_note_static_methods


=item SBO::stringToInt

Returns the string as a correctly formatted SBO integer portion.
@return the given string sboTerm as an integer.  If the sboTerm is not
in the correct format (a zero-padded, seven digit string), C<-1> is
returned.

C<opydetails> doc_note_static_methods


=item SBO::checkTerm

Checks the format of the given SBO identifier string.
@return C<true> if sboTerm is in the correct format (a zero-padded, seven
digit string), C<false> otherwise.
C<opydetails> doc_note_static_methods


=item SBO::checkTerm

Checks the format of the given SBO identifier, given in the form of
the integer portion alone.
@return C<true> if sboTerm is in the range (0000000&ndash;9999999), C<false>
otherwise.

C<opydetails> doc_note_static_methods


=item SBO::getParentBranch

@internal


=item SBO::isChildOf

@internal


=item SBO::populateSBOTree

@internal


=back

=head2 SyntaxChecker

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html Methods for checking the validity of SBML identifiers.
@htmlinclude not-sbml-warning.html
This utility class provides static methods for checking the syntax of
identifiers and other text used in an SBML model.  The methods allow
callers to verify that strings such as SBML identifiers and XHTML notes
text conform to the SBML specifications.

=over


=item SyntaxChecker::isValidSBMLSId

Returns C<true> or C<false> depending on whether the argument
string conforms to the syntax of SBML identifiers.
C<opydetails> doc_what_is_sid 
This method provides programs with the ability to test explicitly that
the identifier strings they create conform to the SBML identifier
syntax.

@param sid string to be checked for conformance to SBML identifier
syntax.

@return C<true> if the string conforms to type SBML data type
C<SId>, C<false> otherwise.
The identifier given by an object's "id" attribute value
is used to identify the object within the SBML model definition.
Other objects can refer to the component using this identifier.  The
data type of "id" is always C<SId> or a type derived
from that, such as C<UnitSId>, depending on the object in 
question.  All data types are defined as follows:
<pre style="margin-left: 2em; border: none; font-weight: bold; color: black">
letter ::= 'a'..'z','A'..'Z'
digit  ::= '0'..'9'
idChar ::= letter | digit | '_'
SId    ::= ( letter | '_' ) idChar 
</pre>

The equality of C<SId> and C<SId>-derived values
in SBML is determined by an exact character sequence match; i.e.,
comparisons of these identifiers must be performed in a case-sensitive
manner.  This applies to all uses of C<SId>, 
C<SIdRef>, and derived types.
C<opydetails> doc_note_static_methods
@see @if clike isValidUnitSId(std::string sid) @else SyntaxChecker::isValidUnitSId(std::string sid) @endif@~
@see @if clike isValidXMLID(std::string sid) @else SyntaxChecker::isValidXMLID(std::string sid) @endif@~


=item SyntaxChecker::isValidXMLID

Returns C<true> or C<false> depending on whether the argument string
conforms to the XML data type C<ID>.
C<opydetails> doc_what_is_metaid 
This method provides programs with the ability to test explicitly that
the identifier strings they create conform to the SBML identifier
syntax.

@param id string to be checked for conformance to the syntax of
<a target="_blank" href="http://www.w3.org/TR/REC-xml/#id">XML ID</a>.
@return C<true> if the string is a syntactically-valid value for the
XML type <a target="_blank"
href="http://www.w3.org/TR/REC-xml/#id">ID</a>, C<false> otherwise.
@note @htmlinclude xmlid-syntax.html
C<opydetails> doc_note_static_methods
@see @if clike isValidSBMLSId(std::string sid) @else SyntaxChecker::isValidSBMLSId(std::string sid) @endif@~
@see @if clike isValidUnitSId(std::string sid) @else SyntaxChecker::isValidUnitSId(std::string sid) @endif@~


=item SyntaxChecker::isValidXMLanyURI

Returns C<true> or C<false> depending on whether the C<uri> argument string
conforms to the XML data type C<anyURI>.
Type anyURI is defined by XML Schema 1.0. It is a character string 
data type whose values are interpretable as URIs (Universal Resource 
Identifiers) as described by the W3C document RFC 3986.  LibSBML
does not provide an explicit XML C<anyURI> data type; it uses
ordinary character strings, which is easier for applications to
support.  LibSBML does, however, test for anyURI validity at
various times, such as when reading in models from files and data
streams.

This method provides programs with the ability to test explicitly that
the strings they create conform to the XML anyURI syntax.
@param uri string to be checked for conformance to the syntax of
<a target="_blank" 
href="http://www.w3.org/TR/xmlschema-2/#anyURI">anyURI</a>.

@return C<true> if the string is a syntactically-valid value for the
XML type <a target="_blank"
href="http://www.w3.org/TR/xmlschema-2/#anyURI">anyURI</a>, 
C<false> otherwise.
C<opydetails> doc_note_static_methods


=item SyntaxChecker::isValidUnitSId

Returns C<true> or C<false> depending on whether the argument string
conforms to the syntax of SBML unit identifiers.
In SBML, the identifiers of units (of both the predefined units and
user-defined units) must conform to a data type called
C<UnitSId> in the SBML specifications.  LibSBML does not
provide an explicit C<UnitSId> data type; it uses ordinary
character strings, which is easier for applications to support.
LibSBML does, however, test for identifier validity at various times,
such as when reading in models from files and data streams.
This method provides programs with the ability to test explicitly that
the identifier strings they create conform to the SBML identifier
syntax.

@param units string to be checked for conformance to SBML unit
identifier syntax.
@return C<true> if the string conforms to type SBML data type
C<UnitSId>, C<false> otherwise.
@note @htmlinclude unitid-syntax.html
C<opydetails> doc_note_static_methods
@see @if clike isValidSBMLSId(std::string sid) @else SyntaxChecker::isValidSBMLSId(std::string sid) @endif@~
@see @if clike isValidXMLID(std::string sid) @else SyntaxChecker::isValidXMLID(std::string sid) @endif@~


=item SyntaxChecker::hasExpectedXHTMLSyntax

Returns C<true> or C<false> depending on whether the given XMLNode
object contains valid XHTML content.
C<opydetails> doc_what_are_notes
An aspect of XHTML validity is that the content is declared to be in
the XML namespace for XHTML&nbsp;1.0.  There is more than one way in
which this can be done in XML.  In particular, a model might not
contain the declaration within the "notes" or "message" subelement
itself, but might instead place the declaration on an enclosing
element and use an XML namespace prefix within the "notes" element to
refer to it.  In other words, the following is valid:
@verbatim
<sbml xmlns="http://www.sbml.org/sbml/level2/version3" level="2" version="3"
xmlns:xhtml="http://www.w3.org/1999/xhtml">
<model>
<notes>
<xhtml:body>
<xhtml:center><xhtml:h2>A Simple Mitotic Oscillator</xhtml:h2></xhtml:center>
<xhtml:p>A minimal cascade model for the mitotic oscillator.</xhtml:p>
</xhtml:body>
</notes>
... rest of model ...
</sbml>
@endverbatim
Contrast the above with the following, self-contained version, which
places the XML namespace declaration within the C<&lt;notes&gt;>
element itself:
@verbatim
<sbml xmlns="http://www.sbml.org/sbml/level2/version3" level="2" version="3">
<model>
<notes>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title/>
</head>
<body>
<center><h2>A Simple Mitotic Oscillator</h2></center>
<p>A minimal cascade model for the mitotic oscillator.</p>
</body>
</html>
</notes>
... rest of model ...
</sbml>
@endverbatim
Both of the above are valid XML.  The purpose of the C<sbmlns>
argument to this method is to allow callers to check the validity of
"notes" and "message" subelements whose XML namespace declarations
have been put elsewhere in the manner illustrated above.  Callers can
can pass in the SBMLNamespaces object of a higher-level model
component if the XMLNode object does not itself have the XML namespace
declaration for XHTML&nbsp;1.0.
@param xhtml the XMLNode to be checked for conformance.
@param sbmlns the SBMLNamespaces associated with the object.
@return C<true> if the XMLNode content conforms, C<false> otherwise.
C<opydetails> doc_note_static_methods
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item SyntaxChecker::isValidInternalSId

@internal


=item SyntaxChecker::isValidInternalUnitSId

@internal


=item SyntaxChecker::isAllowedElement

@internal


=item SyntaxChecker::hasDeclaredNS

@internal


=item SyntaxChecker::isCorrectHTMLNode

@internal


=item SyntaxChecker::isUnicodeLetter

@internal


=item SyntaxChecker::isUnicodeDigit

@internal


=item SyntaxChecker::isCombiningChar

@internal


=item SyntaxChecker::isExtender

@internal


=back

=head2 StoichiometryMath

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html Stochiometry expressions in SBML Level 2 reactions.
@section l2-stoichiometries Stoichiometries in SBML Level 2
In SBML Level 2, product and reactant stoichiometries can be specified
using I<either> the "stoichiometry" attribute or a "stoichiometryMath"
element in a SpeciesReference object.  The "stoichiometry" attribute is
of type C<double> and should contain values greater than zero (0).  The
"stoichiometryMath" element is implemented as an element containing a
MathML expression.  These two are mutually exclusive; only one of
"stoichiometry" or "stoichiometryMath" should be defined in a given
SpeciesReference instance.  When neither the attribute nor the element
is present, the value of "stoichiometry" in the enclosing
SpeciesReference instance defaults to C<1>.
For maximum interoperability, SpeciesReference's "stoichiometry"
attribute should be used in preference to "stoichiometryMath" when a
species' stoichiometry is a simple scalar number (integer or decimal).
When the stoichiometry is a rational number, or when it is a more
complicated formula, "stoichiometryMath" must be used.  The MathML
expression in "stoichiometryMath" may also refer to identifiers of
entities in a model (except reaction identifiers).  However, the only
species identifiers that can be used in "stoichiometryMath" are those
referenced in the enclosing Reaction's list of reactants, products and
modifiers.

The "stoichiometry" attribute and the "stoichiometryMath" element, when
either is used, is each interpreted as a factor applied to the reaction
rate to produce the rate of change of the species identified by the
"species" attribute in the enclosing SpeciesReference.  This is the
normal interpretation of a stoichiometry, but in SBML, one additional
consideration has to be taken into account.  The reaction rate, which is
the result of the KineticLaw's "math" element, is always in the model's
I<substance> per I<time> units.  However, the rate of change of the
species will involve the species' I<substance> units (i.e., the units
identified by the Species object's "substanceUnits" attribute), and
these units may be different from the model's default I<substance>
units.  If the units I<are> different, the stoichiometry must
incorporate a conversion factor for converting the model's I<substance>
units to the species' I<substance> units.  The conversion factor is
assumed to be included in the scalar value of the "stoichiometry"
attribute if "stoichiometry" is used.  If instead "stoichiometryMath" is
used, then the product of the model's "substance" units times the
"stoichiometryMath" units must match the I<substance> units of the
species.  Note that in either case, if the species' units and the
model's default I<substance> units are the same, the stoichiometry ends
up being a dimensionless number and equivalent to the standard chemical
stoichiometry found in textbooks.  Examples and more explanations of
this are given in the SBML specification.
The following is a simple example of a species reference for species @c
"X0", with stoichiometry C<2>, in a list of reactants within a reaction
having the identifier C<"J1">:
@verbatim
<model>
...
<listOfReactions>
<reaction id="J1">
<listOfReactants>
<speciesReference species="X0" stoichiometry="2">
</listOfReactants>
...
</reaction>
...
</listOfReactions>
...
</model>
@endverbatim
The following is a more complex example of a species reference for
species C<"X0">, with a stoichiometry formula consisting of
a rational number:
@verbatim
<model>
...
<listOfReactions>
<reaction id="J1">
<listOfReactants>
<speciesReference species="X0">
<stoichiometryMath>
<math xmlns="http://www.w3.org/1998/Math/MathML"> 
<cn type="rational"> 3 <sep/> 2 </cn>
</math>
</stoichiometryMath>
</speciesReference>
</listOfReactants>
...
</reaction>
...
</listOfReactions>
...
</model>
@endverbatim

Additional discussions of stoichiometries and implications for species
and reactions are included in the documentation of SpeciesReference
class.

@section l3-stoichiometries Stoichiometries in SBML Level 3
The StoichiometryMath construct is not defined in SBML Level&nbsp;3.
Instead, Level&nbsp;3 defines the identifier of
SpeciesReference objects as a stand-in for the stoichiometry of the
reactant or product being referenced, and allows that identifier to be
used elsewhere in SBML models, including (for example) InitialAssignment
objects.  This makes it possible to achieve the same effect as
StoichiometryMath, but with other SBML objects.  For instance, to
produce a stoichiometry value that is a rational number, a model can use
InitialAssignment to assign the identifier of a SpeciesReference object
to a MathML expression evaluating to a rational number.  This is
analogous to the same way that, in Level&nbsp;2, the model would use
StoichiometryMath with a MathML expression evaluating to a rational
number.

In SBML Level 2, the stoichiometry of a reactant or product is a
combination of both a <em>biochemical stoichiometry</em> (meaning, the
standard stoichiometry of a species in a reaction) and any necessary
unit conversion factors. The introduction of an explicit attribute on
the Species object for a conversion factor allows Level&nbsp;3 to avoid
having to overload the meaning of stoichiometry.  In Level&nbsp;3, the
stoichiometry given by a SpeciesReference object in a reaction is a
"proper" biochemical stoichiometry, meaning a dimensionless number free
of unit conversions.
@see SpeciesReference
@see Reaction

=over


=item StoichiometryMath::StoichiometryMath

Creates a new StoichiometryMath object using the given SBML C<level>
values.

@param level an unsigned int, the SBML Level to assign to this StoichiometryMath.
@param version an unsigned int, the SBML Version to assign to this
StoichiometryMath.

C<opydetails> doc_throw_exception_lv
C<opydetails> doc_note_stoichiometrymath_availability
C<opydetails> doc_note_setting_lv


=item StoichiometryMath::StoichiometryMath

Creates a new StoichiometryMath object using the given SBMLNamespaces object
C<sbmlns>.
C<opydetails> doc_what_are_sbmlnamespaces 
@param sbmlns an SBMLNamespaces object.
C<opydetails> doc_throw_exception_namespace
C<opydetails> doc_note_stoichiometrymath_availability
C<opydetails> doc_note_setting_lv


=item StoichiometryMath::StoichiometryMath

Copy constructor; creates a copy of this StoichiometryMath.
@param orig the object to copy.


=item StoichiometryMath::accept

@internal


=item StoichiometryMath::clone

Creates and returns a deep copy of this StoichiometryMath object.
@return the (deep) copy of this StoichiometryMath object.


=item StoichiometryMath::getMath

Retrieves the mathematical formula within this StoichiometryMath and
return it as an AST.
@return the math of this StoichiometryMath, or C<NULL> if the math is not set.
C<opydetails> doc_note_stoichiometrymath_availability


=item StoichiometryMath::isSetMath

Predicate to test whether the math for this StoichiometryMath object
is set.
@return C<true> if the formula (meaning the C<math> subelement) of
this StoichiometryMath is set, C<false> otherwise.
C<opydetails> doc_note_stoichiometrymath_availability


=item StoichiometryMath::setMath

Sets the 'math' expression of this StoichiometryMath instance to a
copy of the given ASTNode.
@param math an ASTNode representing a formula tree.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
C<opydetails> doc_note_stoichiometrymath_availability


=item StoichiometryMath::getDerivedUnitDefinition

Calculates and returns a UnitDefinition object that expresses the
units returned by the math expression in this StoichiometryMath
object.

The units are calculated based on the mathematical expression in the
StoichiometryMath and the model quantities referenced by
C<&lt;ci&gt;> elements used within that expression.  The
StoichiometryMath::getDerivedUnitDefinition() method returns the
calculated units.
Note that the functionality that facilitates unit analysis depends 
on the model as a whole.  Thus, in cases where the object has not 
been added to a model or the model itself is incomplete,
unit analysis is not possible and this method will return C<NULL>.
@return a UnitDefinition that expresses the units of the math, 
or C<NULL> if one cannot be constructed.
@warning <span class="warning">Note that it is possible the "math"
expression in the StoichiometryMath instance contains literal numbers or
parameters with undeclared units.  In those cases, it is not possible to
calculate the units of the overall expression without making
assumptions.  LibSBML does not make assumptions about the units, and
StoichiometryMath::getDerivedUnitDefinition() only returns the units as
far as it is able to determine them.  For example, in an expression
<em>X + Y</em>, if <em>X</em> has unambiguously-defined units and
<em>Y</em> does not, it will return the units of <em>X</em>.  When using
this method, <strong>it is critical that callers also invoke the
method</strong> StoichiometryMath::containsUndeclaredUnits() <strong>to
determine whether this situation holds</strong>.  Callers should take
suitable action in those situations.</span>
@see containsUndeclaredUnits()


=item StoichiometryMath::getDerivedUnitDefinition

Calculates and returns a UnitDefinition object that expresses the
units returned by the math expression in this StoichiometryMath
object.

The units are calculated based on the mathematical expression in the
StoichiometryMath and the model quantities referenced by
C<&lt;ci&gt;> elements used within that expression.  The
StoichiometryMath::getDerivedUnitDefinition() method returns the
calculated units.
Note that the functionality that facilitates unit analysis depends 
on the model as a whole.  Thus, in cases where the object has not 
been added to a model or the model itself is incomplete,
unit analysis is not possible and this method will return C<NULL>.
@return a UnitDefinition that expresses the units of the math,
or C<NULL> if one cannot be constructed.
@warning <span class="warning">Note that it is possible the "math"
expression in the StoichiometryMath instance contains literal numbers or
parameters with undeclared units.  In those cases, it is not possible to
calculate the units of the overall expression without making
assumptions.  LibSBML does not make assumptions about the units, and
StoichiometryMath::getDerivedUnitDefinition() only returns the units as
far as it is able to determine them.  For example, in an expression
<em>X + Y</em>, if <em>X</em> has unambiguously-defined units and
<em>Y</em> does not, it will return the units of <em>X</em>.  When using
this method, <strong>it is critical that callers also invoke the
method</strong> StoichiometryMath::containsUndeclaredUnits() <strong>to
determine whether this situation holds</strong>.  Callers should take
suitable action in those situations.</span>
@see containsUndeclaredUnits()


=item StoichiometryMath::containsUndeclaredUnits

Predicate returning C<true> if the math
expression of this StoichiometryMath object contains literal numbers
or parameters with undeclared units.
The StoichiometryMath::getDerivedUnitDefinition() method returns what
libSBML computes the units of the Stoichiometry to be, to the extent
that libSBML can compute them.  However, if the expression contains
literal numbers or parameters with undeclared units, libSBML may not
be able to compute the full units of the expression and will only
return what it can compute.  Callers should always use
StoichiometryMath::containsUndeclaredUnits() when using
StoichiometryMath::getDerivedUnitDefinition() to decide whether the
returned units may be incomplete.
@return C<true> if the math expression of this StoichiometryMath
includes numbers/parameters with undeclared units, C<false> otherwise.
@note A return value of C<true> indicates that the UnitDefinition
returned by StoichiometryMath::getDerivedUnitDefinition() may not
accurately represent the units of the expression.
@see getDerivedUnitDefinition()


=item StoichiometryMath::containsUndeclaredUnits

Predicate returning C<true> if the math
expression of this StoichiometryMath object contains literal numbers
or parameters with undeclared units.
The StoichiometryMath::getDerivedUnitDefinition() method returns what
libSBML computes the units of the Stoichiometry to be, to the extent
that libSBML can compute them.  However, if the expression contains
literal numbers or parameters with undeclared units, libSBML may not
be able to compute the full units of the expression and will only
return what it can compute.  Callers should always use
StoichiometryMath::containsUndeclaredUnits() when using
StoichiometryMath::getDerivedUnitDefinition() to decide whether the
returned units may be incomplete.
@return C<true> if the math expression of this StoichiometryMath
includes numbers/parameters with undeclared units, C<false> otherwise.
@note A return value of C<true> indicates that the UnitDefinition
returned by StoichiometryMath::getDerivedUnitDefinition() may not
accurately represent the units of the expression.
@see getDerivedUnitDefinition()


=item StoichiometryMath::getTypeCode

Returns the libSBML type code of this object instance.
C<opydetails> doc_what_are_typecodes
@return the SBML type code for this object:
@link SBMLTypeCode_t#SBML_STOICHIOMETRY_MATH SBML_STOICHIOMETRY_MATH@endlink (default).
C<opydetails> doc_warning_typecodes_not_unique
@see getElementName()
@see getPackageName()


=item StoichiometryMath::getElementName

Returns the XML element name of this object, which for StoichiometryMath, is
always C<"stoichiometryMath">.
@return the name of this element, i.e., C<"stoichiometryMath">.


=item StoichiometryMath::getElementPosition

@internal


=item StoichiometryMath::writeElements

@internal


=item StoichiometryMath::hasRequiredElements

Predicate returning C<true> if
all the required elements for this StoichiometryMath object
have been set.
@note The required elements for a StoichiometryMath object are:
@li "math"
@return a boolean value indicating whether all the required
elements for this object have been defined.


=item StoichiometryMath::removeFromParentAndDelete

Finds this StoichiometryMath's SpeciesReference parent and calls
unsetStoichiometryMath() on it, indirectly deleting itself.
Overridden from the SBase function since the parent is not a ListOf.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink


=item StoichiometryMath::renameSIdRefs

C<opydoc> doc_renamesidref_common


=item StoichiometryMath::renameUnitSIdRefs

C<opydoc> doc_renameunitsidref_common


=item StoichiometryMath::replaceSIDWithFunction

@internal


=item StoichiometryMath::getInternalId

@internal


=item StoichiometryMath::setInternalId

@internal


=item StoichiometryMath::readOtherXML

@internal


=item StoichiometryMath::addExpectedAttributes

@internal


=item StoichiometryMath::readAttributes

@internal


=item StoichiometryMath::readL2Attributes

@internal


=item StoichiometryMath::writeAttributes

@internal


=back

=head2 SBMLNamespaces

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html Set of SBML Level + Version + namespace triples.
@htmlinclude not-sbml-warning.html
There are differences in the definitions of components between different
SBML Levels, as well as Versions within Levels.  For example, the
"sboTerm" attribute was not introduced until Level&nbsp;2
Version&nbsp;2, and then only on certain component classes; the SBML
Level&nbsp;2 Version&nbsp;3 specification moved the "sboTerm" attribute
to the SBase class, thereby allowing nearly all components to have SBO
annotations.  As a result of differences such as those, libSBML needs to
track the SBML Level and Version of every object created.
The purpose of the SBMLNamespaces object class is to make it easier to
communicate SBML Level and Version data between libSBML constructors and
other methods.  The SBMLNamespaces object class tracks 3-tuples
(triples) consisting of SBML Level, Version, and the corresponding SBML
XML namespace.
The plural name (SBMLNamespaces) is not a mistake, because in SBML
Level&nbsp;3, objects may have extensions added by Level&nbsp;3 packages
used by a given model and therefore may have multiple namespaces
associated with them; however, until the introduction of SBML
Level&nbsp;3, the SBMLNamespaces object only records one SBML
Level/Version/namespace combination at a time.  Most constructors for
SBML objects in libSBML take a SBMLNamespaces object as an argument,
thereby allowing the constructor to produce the proper combination of
attributes and other internal data structures for the given SBML Level
and Version.

=over


=item SBMLNamespaces::SBMLNamespaces

Creates a new SBMLNamespaces object corresponding to the given SBML
C<level> and C<version>.
C<opydetails> doc_sbmlnamespaces_what_is_it 
@param level the SBML level.
@param version the SBML version.
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item SBMLNamespaces::SBMLNamespaces

(For extensions) Creates a new SBMLNamespaces object corresponding to
the combination of (1) the given SBML C<level> and C<version>, and (2)
the given C<package> with the C<package> C<version>.
C<opydetails> doc_sbmlnamespaces_what_is_it 
@param level   the SBML Level.
@param version the SBML Version.
@param pkgName the string of package name (e.g. "layout", "multi").
@param pkgVersion the package version.
@param pkgPrefix the prefix of the package namespace (e.g. "layout", "multi") to be added.
The package's name will be used if the given string is empty (default).
@throws SBMLExtensionException if the extension module that supports the
combination of the given SBML Level, SBML Version, package name, and
package version has not been registered with libSBML.


=item SBMLNamespaces::SBMLNamespaces

Copy constructor; creates a copy of a SBMLNamespaces.
@param orig the SBMLNamespaces instance to copy.


=item SBMLNamespaces::clone

Creates and returns a deep copy of this SBMLNamespaces object.
@return the (deep) copy of this SBMLNamespaces object.


=item SBMLNamespaces::getSBMLNamespaceURI

Returns a string representing the SBML XML namespace for the 
given C<level> and C<version> of SBML.
@param level the SBML level.
@param version the SBML version.
@return a string representing the SBML namespace that reflects the
SBML Level and Version specified.
C<opydetails> doc_note_static_methods


=item SBMLNamespaces::getSupportedNamespaces

Returns a list of all supported SBMLNamespaces in this version of 
libsbml. 

@return a list with supported SBML namespaces.
C<opydetails> doc_note_static_methods


=item SBMLNamespaces::freeSBMLNamespaces

Frees the list of supported namespaces as generated by
getSupportedNamespaces().

@param supportedNS the list to be freed.
C<opydetails> doc_note_static_methods


=item SBMLNamespaces::getURI

Returns a string representing the SBML XML namespace of this
object.

@return a string representing the SBML namespace that reflects the
SBML Level and Version of this object.


=item SBMLNamespaces::getLevel

Get the SBML Level of this SBMLNamespaces object.
@return the SBML Level of this SBMLNamespaces object.


=item SBMLNamespaces::getLevel

Get the SBML Level of this SBMLNamespaces object.
@return the SBML Level of this SBMLNamespaces object.


=item SBMLNamespaces::getVersion

Get the SBML Version of this SBMLNamespaces object.
@return the SBML Version of this SBMLNamespaces object.


=item SBMLNamespaces::getVersion

Get the SBML Version of this SBMLNamespaces object.
@return the SBML Version of this SBMLNamespaces object.


=item SBMLNamespaces::getNamespaces

Get the XML namespaces list for this SBMLNamespaces object.
C<opydetails> doc_sbmlnamespaces_what_is_it
@return the XML namespaces of this SBMLNamespaces object.


=item SBMLNamespaces::getNamespaces

Get the XML namespaces list for this SBMLNamespaces object.
C<opydetails> doc_sbmlnamespaces_what_is_it
@return the XML namespaces of this SBMLNamespaces object.


=item SBMLNamespaces::addNamespaces

Add the given XML namespaces list to the set of namespaces within this
SBMLNamespaces object.
The following code gives an example of how one could add the XHTML
namespace to the list of namespaces recorded by the top-level
C<&lt;sbml&gt;> element of a model.  It gives the new
namespace a prefix of C<html>.
@if cpp
C<ode{>.cpp}
SBMLDocument  sd;
try
{
sd = new SBMLDocument(3, 1);
}
catch (SBMLConstructorException e)
{
// Here, have code to handle a truly exceptional situation. Candidate
// causes include invalid combinations of SBML Level and Version
// (impossible if hardwired as given here), running out of memory, and
// unknown system exceptions.
}
SBMLNamespaces sn = sd->getNamespaces();
if (sn != NULL)
{
sn->add("http://www.w3.org/1999/xhtml", "html");
}
else
{
// Handle another truly exceptional situation.
}
@endcode
@endif
@if java
C<ode{>.java}
SBMLDocument sd;
try
{
sd = new SBMLDocument(3, 1);
}
catch (SBMLConstructorException e)
{
// Here, have code to handle a truly exceptional situation. Candidate
// causes include invalid combinations of SBML Level and Version
// (impossible if hardwired as given here), running out of memory, and
// unknown system exceptions.
}
SBMLNamespaces sn = sd.getNamespaces();
if (sn != null)
{
sn.add("http://www.w3.org/1999/xhtml", "html");
}
else
{
// Handle another truly exceptional situation.
}
@endcode
@endif
@if python
C<ode{>.py}
sbmlDoc = None
try:
sbmlDoc = SBMLDocument(3, 1)
except ValueError:
# Do something to handle exceptional situation.  Candidate
# causes include invalid combinations of SBML Level and Version
# (impossible if hardwired as given here), running out of memory, and
# unknown system exceptions.
namespaces = sbmlDoc.getNamespaces()
if namespaces == None:
# Do something to handle case of no namespaces.
status = namespaces.add("http://www.w3.org/1999/xhtml", "html")
if status != LIBSBML_OPERATION_SUCCESS:
# Do something to handle failure.
@endcode
@endif
@if csharp
C<ode{>.cs}
SBMLDocument sd = null;
try
{
sd = new SBMLDocument(3, 1);
}
catch (SBMLConstructorException e)
{
// Here, have code to handle a truly exceptional situation.
// Candidate causes include invalid combinations of SBML
// Level and Version (impossible if hardwired as given here),
// running out of memory, and unknown system exceptions.
}
XMLNamespaces sn = sd.getNamespaces();
if (sn != null)
{
sn.add("http://www.w3.org/1999/xhtml", "html");
}
else
{
// Handle another truly exceptional situation.
}
@endcode
@endif@~

@param xmlns the XML namespaces to be added.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink


=item SBMLNamespaces::addNamespace

Add an XML namespace (a pair of URI and prefix) to the set of namespaces
within this SBMLNamespaces object.
@param uri    the XML namespace to be added.
@param prefix the prefix of the namespace to be added.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink


=item SBMLNamespaces::removeNamespace

Removes an XML namespace from the set of namespaces within this 
SBMLNamespaces object.
@param uri    the XML namespace to be added.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink


=item SBMLNamespaces::addPackageNamespace

Add an XML namespace (a pair of URI and prefix) of a package extension
to the set of namespaces within this SBMLNamespaces object.
The SBML Level and SBML Version of this object is used.
@param pkgName the string of package name (e.g. "layout", "multi").
@param pkgVersion the package version.
@param prefix the prefix of the package namespace to be added.
The package's name will be used if the given string is empty (default).
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@note An XML namespace of a non-registered package extension can't be
added by this function (@link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink 
will be returned).
@see addNamespace(@if java String, String@endif)


=item SBMLNamespaces::addPackageNamespaces

Add the XML namespaces of package extensions in the given XMLNamespace
object to the set of namespaces within this SBMLNamespaces object
(Non-package XML namespaces are not added by this function).
@param xmlns the XML namespaces to be added.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@note XML namespaces of a non-registered package extensions are not
added (just ignored) by this function. @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink will be returned if the given
xmlns is null.


=item SBMLNamespaces::removePackageNamespace

Removes an XML namespace of a package extension from the set of namespaces 
within this SBMLNamespaces object.
@param level   the SBML level.
@param version the SBML version.
@param pkgName the string of package name (e.g. "layout", "multi").
@param pkgVersion the package version.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@li @link OperationReturnValues_t#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink


=item SBMLNamespaces::addPkgNamespace

@internal


=item SBMLNamespaces::addPkgNamespaces

@internal


=item SBMLNamespaces::removePkgNamespace

@internal


=item SBMLNamespaces::isSBMLNamespace

Predicate returning C<true> if the given URL is one of SBML XML
namespaces.

@param uri the URI of namespace.
@return C<true> if the "uri" is one of SBML namespaces, C<false> otherwise.
C<opydetails> doc_note_static_methods


=item SBMLNamespaces::isValidCombination

Predicate returning C<true> if the given set of namespaces represent a
valid set
@return C<true> if the set of namespaces is valid, C<false> otherwise.


=item SBMLNamespaces::setLevel

@internal


=item SBMLNamespaces::setVersion

@internal


=item SBMLNamespaces::setNamespaces

@internal


=item SBMLNamespaces::getPackageName

Returns the name of the main package for this namespace.
@return the name of the main package for this namespace.
"core" will be returned if this namespace is defined in the SBML 
core.


=item SBMLNamespaces::initSBMLNamespace

@internal


=back

=head2 SBMLTransforms

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html Methods for transform elements of SBML
@internal

=over


=item SBMLTransforms::replaceFD

@internal


=item SBMLTransforms::replaceFD

@internal


=item SBMLTransforms::expandInitialAssignments

@internal


=item SBMLTransforms::evaluateASTNode

@internal


=item SBMLTransforms::expandL3V2InitialAssignments

@internal


=back

=head2 SBMLConstructorException

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html Exceptions thrown by some libSBML constructors.
In some situations, constructors for SBML objects may need to indicate to
callers that the creation of the object failed.  The failure may be for
different reasons, such as an attempt to use invalid parameters or a
system condition such as a memory error.  To communicate this to callers,
those classes will throw an SBMLConstructorException.
In languages that don't have an exception mechanism (e.g., C), the
constructors generally try to return an error code instead of throwing
an exception.

=over


=item SBMLConstructorException::SBMLConstructorException

@internal


=item SBMLConstructorException::SBMLConstructorException

@internal


=item SBMLConstructorException::SBMLConstructorException

@internal


=item SBMLConstructorException::getSBMLErrMsg

Returns the message associated with this SBML exception.
@return the message string.


=back

=head2 ConversionOption

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html A single configuration setting for an SBML converter.
@htmlinclude libsbml-facility-only-warning.html
LibSBML provides a number of converters that can perform transformations
on SBML documents.  These converters allow their behaviors to be
controlled by setting property values.  Converter properties are
communicated using objects of class ConversionProperties, and within
such objects, individual options are encapsulated using ConversionOption
objects.

A ConversionOption @if conly structure @else object@endif@~ consists of
four parts:
@li A I<key>, acting as the name of the option.
@li A I<value> of this option.
@li A I<type> for the value; the type code is chosen from @if clike
an enumeration @else a set of integer constants@endif@~ whose names all
begin with the prefix C<CNV_TYPE_>.  (See the separate <a
class="el" href="#ConversionOptionType_t">subsection</a> below for more
information.)
@li A I<description> consisting of a text string that describes the
option in some way.
There are no constraints on the values of keys or descriptions;
authors of SBML converters are free to choose them as they see fit.
@section ConversionOptionType_t Conversion option data types
An option in ConversionOption must have a data type declared, to
indicate whether it is a string value, an integer, and so forth.  The
possible types of values are taken from
@if clike the enumeration #ConversionOptionType_t @else a set of
constants whose symbol names begin with the prefix
C<CNV_TYPE_>@endif. The following are the possible values:
<p>
<center>
<table width="90%" cellspacing="1" cellpadding="1" border="0" class="normal-font">
<tr style="background: lightgray" class="normal-font">
<td><strong>Enumerator</strong></td>
<td><strong>Meaning</strong></td>
</tr>
<tr>
<td>C<@link ConversionOptionType_t#CNV_TYPE_BOOL CNV_TYPE_BOOL@endlink></td>
<td>Indicates the value type is a Boolean.</td>
</tr>
<tr>
<td>C<@link ConversionOptionType_t#CNV_TYPE_DOUBLE CNV_TYPE_DOUBLE@endlink></td>
<td>Indicates the value type is a double-sized float.</td>
</tr>
<tr>
<td>C<@link ConversionOptionType_t#CNV_TYPE_INT CNV_TYPE_INT@endlink></td>
<td>Indicates the value type is an integer.</td>
</tr>
<tr>
<td>C<@link ConversionOptionType_t#CNV_TYPE_SINGLE CNV_TYPE_SINGLE@endlink></td>
<td>Indicates the value type is a float.</td>
</tr>
<tr>
<td>C<@link ConversionOptionType_t#CNV_TYPE_STRING CNV_TYPE_STRING@endlink></td>
<td>Indicates the value type is a string.</td>
</tr>
</table>
</center>

@see ConversionProperties

=over


=item ConversionOption::ConversionOption

Creates a new ConversionOption.
This is the general constructor, taking arguments for all aspects of
an option.  Other constructors exist with different arguments.
C<opydetails> doc_cnv_type
@param key the key for this option.
@param value an optional value for this option.
@param type the type of this option.
@param description the description for this option.
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item ConversionOption::ConversionOption

Creates a new ConversionOption specialized for string-type options.
@param key the key for this option.
@param value the value for this option.
@param description an optional description.
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item ConversionOption::ConversionOption

Creates a new ConversionOption specialized for Boolean-type options.
@param key the key for this option.
@param value the value for this option.
@param description an optional description.
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item ConversionOption::ConversionOption

Creates a new ConversionOption specialized for double-type options.
@param key the key for this option.
@param value the value for this option.
@param description an optional description.
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item ConversionOption::ConversionOption

Creates a new ConversionOption specialized for float-type options.
@param key the key for this option.
@param value the value for this option.
@param description an optional description.
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item ConversionOption::ConversionOption

Creates a new ConversionOption specialized for integer-type options.
@param key the key for this option.
@param value the value for this option.
@param description an optional description.
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item ConversionOption::ConversionOption

Copy constructor; creates a copy of an ConversionOption object.
@param orig the ConversionOption object to copy.


=item ConversionOption::clone

Creates and returns a deep copy of this ConversionOption object.
@return the (deep) copy of this ConversionOption object.


=item ConversionOption::getKey

Returns the key for this option.
@return the key, as a string.


=item ConversionOption::setKey

Sets the key for this option.
@param key a string representing the key to set.


=item ConversionOption::getValue

Returns the value of this option.
@return the value of this option, as a string.


=item ConversionOption::setValue

Sets the value for this option.
@param value the value to set, as a string.


=item ConversionOption::getDescription

Returns the description string for this option.
@return the description of this option.


=item ConversionOption::setDescription

Sets the description text for this option.
@param description the description to set for this option.


=item ConversionOption::getType

Returns the type of this option
@return the type of this option.


=item ConversionOption::setType

Sets the type of this option.
C<opydetails> doc_cnv_type
@param type the type value to use.


=item ConversionOption::getBoolValue

Returns the value of this option as a Boolean.
@return the value of this option.


=item ConversionOption::setBoolValue

Set the value of this option to a given Boolean value.
Invoking this method will also set the type of the option to
@link ConversionOptionType_t#CNV_TYPE_BOOL CNV_TYPE_BOOL@endlink.
@param value the Boolean value to set.


=item ConversionOption::getDoubleValue

Returns the value of this option as a C<double>.
@return the value of this option.


=item ConversionOption::setDoubleValue

Set the value of this option to a given C<double> value.
Invoking this method will also set the type of the option to
@link ConversionOptionType_t#CNV_TYPE_DOUBLE CNV_TYPE_DOUBLE@endlink.
@param value the value to set.


=item ConversionOption::getFloatValue

Returns the value of this option as a C<float>.
@return the value of this option as a float.


=item ConversionOption::setFloatValue

Set the value of this option to a given C<float> value.
Invoking this method will also set the type of the option to
@link ConversionOptionType_t#CNV_TYPE_SINGLE CNV_TYPE_SINGLE@endlink.
@param value the value to set.


=item ConversionOption::getIntValue

Returns the value of this option as an C<integer>.
@return the value of this option, as an int.


=item ConversionOption::setIntValue

Set the value of this option to a given C<int> value.
Invoking this method will also set the type of the option to
@link ConversionOptionType_t#CNV_TYPE_INT CNV_TYPE_INT@endlink.
@param value the value to set.


=back

=head2 ConversionProperties

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html Set of configuration option values for a converter.
@htmlinclude libsbml-facility-only-warning.html
LibSBML provides a number of converters that can perform transformations
on SBML documents. The properties of SBML converters are communicated
using objects of class ConversionProperties, and within such objects,
individual options are encapsulated using ConversionOption objects.  The
ConversionProperties class provides numerous methods for setting and
getting options.
ConversionProperties objects are also used to determine the target SBML
namespace when an SBML converter's behavior depends on the intended
Level+Version combination of SBML.  In addition, it is conceivable that
conversions may be affected by SBML Level&nbsp;3 packages being used by an
SBML document; consequently, the packages in use are also communicated by
the values of the SBML namespaces set on a ConversionProperties object.
C<opydetails> doc_section_using_sbml_converters
@see ConversionOption
@see SBMLNamespaces

=over


=item ConversionProperties::ConversionProperties

Constructor that initializes the conversion properties
with a specific SBML target namespace.
@param targetNS the target namespace to convert to.
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item ConversionProperties::ConversionProperties

Copy constructor.
@param orig the object to copy.


=item ConversionProperties::clone

Creates and returns a deep copy of this ConversionProperties object.
@return the (deep) copy of this ConversionProperties object.


=item ConversionProperties::getTargetNamespaces

Returns the current target SBML namespace.
@return the SBMLNamepaces object expressing the target namespace.


=item ConversionProperties::hasTargetNamespaces

Returns C<true> if the target SBML namespace has been set.
@return C<true> if the target namespace has been set, C<false>
otherwise.


=item ConversionProperties::setTargetNamespaces

Sets the target namespace.
@param targetNS the target namespace to use.


=item ConversionProperties::getDescription

Returns the description string for a given option in this properties
object.

@param key the key for the option.
@return the description text of the option with the given key.


=item ConversionProperties::getType

Returns the type of a given option in this properties object.
@param key the key for the option.
@return the type of the option with the given key.


=item ConversionProperties::getOption

Returns the ConversionOption object for a given key.
@param key the key for the option.
@return the option with the given key.


=item ConversionProperties::getOption

Returns the ConversionOption object for the given index.
@param index the index for the option.
@return the option with the given index.


=item ConversionProperties::addOption

Adds a copy of the given option to this properties object.
@param option the option to add.


=item ConversionProperties::addOption

Adds a new ConversionOption object with the given parameters.
@param key the key for the new option.
@param value (optional) the value of that option.
@param type (optional) the type of the option (see the documentation
for ConversionOption for more information about the types).
@param description (optional) the description for the option.
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item ConversionProperties::addOption

Adds a new ConversionOption object with the given parameters.
@param key the key for the new option.
@param value the string value of that option.
@param description (optional) the description for the option.
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item ConversionProperties::addOption

Adds a new ConversionOption object with the given parameters.
@param key the key for the new option.
@param value the boolean value of that option.
@param description (optional) the description for the option.
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item ConversionProperties::addOption

Adds a new ConversionOption object with the given parameters.
@param key the key for the new option.
@param value the double value of that option.
@param description (optional) the description for the option.
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item ConversionProperties::addOption

Adds a new ConversionOption object with the given parameters.
@param key the key for the new option.
@param value the float value of that option.
@param description (optional) the description for the option.
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item ConversionProperties::addOption

Adds a new ConversionOption object with the given parameters.
@param key the key for the new option.
@param value the integer value of that option.
@param description (optional) the description for the option.
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item ConversionProperties::removeOption

Removes the option with the given key from this properties object.
@param key the key for the new option to remove.
@return the removed option.


=item ConversionProperties::hasOption

Returns C<true> if this properties object contains an option with
the given key.
@param key the key of the option to find.
@return C<true> if an option with the given C<key> exists in
this properties object, C<false> otherwise.


=item ConversionProperties::getValue

Returns the value of the given option as a string.
@param key the key for the option.
@return the string value of the option with the given key.


=item ConversionProperties::setValue

Sets the value of the given option to a string.
@param key the key for the option.
@param value the new value.


=item ConversionProperties::getBoolValue

Returns the value of the given option as a Boolean.
@param key the key for the option.
@return the boolean value of the option with the given key.


=item ConversionProperties::setBoolValue

Sets the value of the given option to a Boolean.
@param key the key for the option.
@param value the new Boolean value.


=item ConversionProperties::getDoubleValue

Returns the value of the given option as a C<double>.
@param key the key for the option.
@return the double value of the option with the given key.


=item ConversionProperties::setDoubleValue

Sets the value of the given option to a C<double>.
@param key the key for the option.
@param value the new double value.


=item ConversionProperties::getFloatValue

Returns the value of the given option as a C<float>.
@param key the key for the option.
@return the float value of the option with the given key.


=item ConversionProperties::setFloatValue

Sets the value of the given option to a C<float>.
@param key the key for the option.
@param value the new float value.


=item ConversionProperties::getIntValue

Returns the value of the given option as an integer.
@param key the key for the option.
@return the int value of the option with the given key.


=item ConversionProperties::setIntValue

Sets the value of the given option to an integer.
@param key the key for the option.
@param value the new integer value.


=item ConversionProperties::getNumOptions

Returns the number of options in this Conversion Properties object
@return the number of options in this properties object.


=back

=head2 SBMLConverter

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html Base class for SBML converters.
@htmlinclude libsbml-facility-only-warning.html
The SBMLConverter class is the base class for the various SBML @em
converters: classes of objects that transform or convert SBML documents.
These transformations can involve essentially anything that can be written
algorithmically; examples include converting the units of measurement in a
model, or converting from one Level+Version combination of SBML to
another.  Applications can also create their own converters by subclassing
SBMLConverter and following the examples of the existing converters.
C<opydetails> doc_section_using_sbml_converters

=over


=item SBMLConverter::SBMLConverter

Creates a new SBMLConverter object.


=item SBMLConverter::SBMLConverter

Creates a new SBMLConverter object with a given name.
@param name the name for the converter to create.


=item SBMLConverter::SBMLConverter

Copy constructor.
This creates a copy of an SBMLConverter object.
@param orig the SBMLConverter object to copy.


=item SBMLConverter::clone

Creates and returns a deep copy of this SBMLConverter object.
@return the (deep) copy of this SBMLConverter object.


=item SBMLConverter::getDocument

Returns the SBML document that is the subject of the conversions.
@return the current SBMLDocument object.


=item SBMLConverter::getDocument

Returns the SBML document that is the subject of the conversions.
@return the current SBMLDocument object.


=item SBMLConverter::getDefaultProperties

Returns the default properties of this converter.
A given converter exposes one or more properties that can be adjusted
in order to influence the behavior of the converter.  This method
returns the I<default> property settings for this converter.  It is
meant to be called in order to discover all the settings for the
converter object.  The run-time properties of the converter object can
be adjusted by using the method
SBMLConverter::setProperties(const ConversionProperties  props).
@return the default properties for the converter.
@see setProperties(@if java ConversionProperties@endif)
@see matchesProperties(@if java ConversionProperties@endif)


=item SBMLConverter::getTargetNamespaces

Returns the target SBML namespaces of the currently set properties.
SBML namespaces are used by libSBML to express the Level+Version of the
SBML document (and, possibly, any SBML Level&nbsp;3 packages in
use). Some converters' behavior is affected by the SBML namespace
configured in the converter.  For example, in SBMLLevelVersionConverter
(the converter for converting SBML documents from one Level+Version
combination to another), the actions are fundamentally dependent on the
SBML namespaces targeted.
@return the SBMLNamespaces object that describes the SBML namespaces
in effect, or C<NULL> if none are set.


=item SBMLConverter::matchesProperties

Returns C<true> if this converter matches the given properties.
Given a ConversionProperties object C<props>, this method checks that @p
props possesses an option value to enable this converter.  If it does,
this method returns C<true>.
@param props the properties to match.
@return C<true> if the properties C<props> would match the necessary
properties for this type of converter, C<false> otherwise.


=item SBMLConverter::setDocument

Sets the SBML document to be converted.
@param doc the document to use for this conversion.
@return integer value indicating the success/failure of the operation.
@if clike The value is drawn from the enumeration
#OperationReturnValues_t. @endif@~ The set of possible values that may
be returned ultimately depends on the specific subclass of
SBMLConverter being used, but the default method can return the
following:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@if cpp
@warning Even though the argument C<doc> is 'const', it is immediately
cast to a non-const version, which is then usually changed by the
converter upon a successful conversion.  This variant of the
setDocument() method is here solely to preserve backwards compatibility.
@endif


=item SBMLConverter::setDocument

Sets the SBML document to be converted.
@param doc the document to use for this conversion.
@return integer value indicating the success/failure of the operation.
@if clike The value is drawn from the enumeration
#OperationReturnValues_t. @endif@~ The set of possible values that may
be returned ultimately depends on the specific subclass of
SBMLConverter being used, but the default method can return the
following:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink


=item SBMLConverter::setProperties

Sets the configuration properties to be used by this converter.
@param props the ConversionProperties object defining the properties
to set.
@return integer value indicating the success/failure of the operation.
@if clike The value is drawn from the enumeration
#OperationReturnValues_t. @endif@~ The set of possible values that may
be returned ultimately depends on the specific subclass of
SBMLConverter being used, but the default method can return the
following values:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@see getProperties()
@see matchesProperties(@if java ConversionProperties@endif)


=item SBMLConverter::getProperties

Returns the current properties in effect for this converter.
A given converter exposes one or more properties that can be adjusted
in order to influence the behavior of the converter.  This method
returns the current properties for this converter; in other words, the
settings in effect at this moment.  To change the property values, you
can use SBMLConverter::setProperties(const ConversionProperties  props).
@return the currently set configuration properties.
@see setProperties(@if java ConversionProperties@endif)
@see matchesProperties(@if java ConversionProperties@endif)


=item SBMLConverter::convert

Perform the conversion.
This method causes the converter to do the actual conversion work,
that is, to convert the SBMLDocument object set by
SBMLConverter::setDocument(@if java const SBMLDocument@endif) and
with the configuration options set by
SBMLConverter::setProperties(@if java const ConversionProperties@endif).
@return  integer value indicating the success/failure of the operation.
@if clike The value is drawn from the enumeration
#OperationReturnValues_t. @endif@~ The set of possible values that may
be returned depends on the converter subclass; please consult
the documentation for the relevant class to find out what the
possibilities are.


=item SBMLConverter::getName

Returns the name of this converter.
@return a string, the name of this converter.


=back

=head2 SBMLConverterRegistry

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html Registry of all libSBML SBML converters.
@htmlinclude libsbml-facility-only-warning.html
LibSBML provides facilities for transforming and converting SBML
documents in various ways.  These transformations can involve
essentially anything that can be written algorithmically; examples
include converting the units of measurement in a model, or converting
from one Level+Version combination of SBML to another.  Converters are
implemented as objects derived from the class SBMLConverter.
The converter registry, implemented as a singleton object of class
SBMLConverterRegistry, maintains a list of known converters and provides
methods for discovering them.  Callers can use the method
SBMLConverterRegistry::getNumConverters() to find out how many
converters are registered, then use
SBMLConverterRegistry::getConverterByIndex(@if java int@endif) to
iterate over each one; alternatively, callers can use
SBMLConverterRegistry::getConverterFor(@if java const ConversionProperties@endif)
to search for a converter having specific properties.

=over


=item SBMLConverterRegistry::getInstance

Returns the singleton instance for the converter registry.
Prior to using the registry, callers have to obtain a copy of the
registry.  This static method provides the means for doing that.
@return the singleton for the converter registry.


=item SBMLConverterRegistry::addConverter

Adds the given converter to the registry of SBML converters.
@param converter the converter to add to the registry.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink


=item SBMLConverterRegistry::getConverterByIndex

Returns the converter with the given index number.
Converters are given arbitrary index numbers by the registry.  Callers
can use the method SBMLConverterRegistry::getNumConverters() to find
out how many converters are registered, then use this method to
iterate over the list and obtain each one in turn.
@param index the zero-based index of the converter to fetch.
@return the converter with the given index number, or C<NULL> if the
number is less than C<0> or there is no converter at the given index
position.


=item SBMLConverterRegistry::getConverterFor

Returns the converter that best matches the given configuration
properties.

Many converters provide the ability to configure their behavior.  This
is realized through the use of I<properties> that offer different @em
options.  The present method allows callers to search for converters
that have specific property values.  Callers can do this by creating a
ConversionProperties object, adding the desired option(s) to the
object, then passing the object to this method.
@param props a ConversionProperties object defining the properties
to match against.
@return the converter matching the properties, or C<NULL> if no
suitable converter is found.
@see getConverterByIndex(@if java int@endif)


=item SBMLConverterRegistry::getNumConverters

Returns the number of converters known by the registry.
@return the number of registered converters.
@see getConverterByIndex(@if java int@endif)


=item SBMLConverterRegistry::SBMLConverterRegistry

@internal


=back

=head2 SBMLFunctionDefinitionConverter

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html Converter to expand user-defined functions in-line.
@htmlinclude libsbml-facility-only-warning.html
This converter manipulates user-defined functions in an SBML file.  When
invoked on a model, it performs the following operations:
@li Reads the list of user-defined functions in the model (i.e., the list
of FunctionDefinition objects);
@li Looks for invocations of the function in mathematical expressions
throughout the model; and
@li For each invocation found, replaces the invocation with a in-line copy
of the function's body, similar to how macro expansions might be performed
in scripting and programming languages.
For example, suppose the model contains a function definition
representing the function C<f(x, y) = x   y>.  Further
suppose this functions invoked somewhere else in the model, in
a mathematical formula, as C<f(s, p)>.  The outcome of running
SBMLFunctionDefinitionConverter on the model will be to replace
the call to C<f> with the expression C<s   p>.
@section usage Configuration and use of SBMLFunctionDefinitionConverter
SBMLFunctionDefinitionConverter is enabled by creating a
ConversionProperties object with the option @c
"expandFunctionDefinitions", and passing this properties object to
SBMLDocument::convert(@if java ConversionProperties@endif).
The converter accepts one option:
@li C<"skipIds">: if set, it should be a string containing a
comma-separated list of identifiers (SBML "id" values) that are to be
skipped during function conversion.  Functions whose identifiers are
found in this list will not be converted.
C<opydetails> doc_section_using_sbml_converters

=over


=item SBMLFunctionDefinitionConverter::init

@internal


=item SBMLFunctionDefinitionConverter::SBMLFunctionDefinitionConverter

Creates a new SBMLFunctionDefinitionConverter object.


=item SBMLFunctionDefinitionConverter::SBMLFunctionDefinitionConverter

Copy constructor; creates a copy of an SBMLFunctionDefinitionConverter
object.

@param obj the SBMLFunctionDefinitionConverter object to copy.


=item SBMLFunctionDefinitionConverter::clone

Creates and returns a deep copy of this SBMLFunctionDefinitionConverter
object.

@return a (deep) copy of this converter.


=item SBMLFunctionDefinitionConverter::matchesProperties

Returns C<true> if this converter object's properties match the given
properties.

A typical use of this method involves creating a ConversionProperties
object, setting the options desired, and then calling this method on
an SBMLFunctionDefinitionConverter object to find out if the object's
property values match the given ones.  This method is also used by
SBMLConverterRegistry::getConverterFor(@if java ConversionProperties@endif)
to search across all registered converters for one matching particular
properties.

@param props the properties to match.
@return C<true> if this converter's properties match, C<false>
otherwise.


=item SBMLFunctionDefinitionConverter::convert

Perform the conversion.
This method causes the converter to do the actual conversion work,
that is, to convert the SBMLDocument object set by
SBMLConverter::setDocument(@if java SBMLDocument@endif) and
with the configuration options set by
SBMLConverter::setProperties(@if java ConversionProperties@endif).
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@li @link OperationReturnValues_t#LIBSBML_CONV_INVALID_SRC_DOCUMENT LIBSBML_CONV_INVALID_SRC_DOCUMENT@endlink


=item SBMLFunctionDefinitionConverter::getDefaultProperties

Returns the default properties of this converter.
A given converter exposes one or more properties that can be adjusted
in order to influence the behavior of the converter.  This method
returns the I<default> property settings for this converter.  It is
meant to be called in order to discover all the settings for the
converter object.
@return the ConversionProperties object describing the default properties
for this converter.


=item SBMLFunctionDefinitionConverter::expandFD_errors

@internal


=back

=head2 SBMLIdConverter

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html Converter for replacing object identifiers.
@htmlinclude libsbml-facility-only-warning.html
This converter translates all instances of a given identifier (i.e., SBML object "id"
attribute value) of type "SId" in a Model to another identifier.  It does this based on a list of source
identifiers, translating each one to its corresponding replacement value
in a list of replacement identifiers.  It also updates all references to
the identifiers so replaced.  (More technically, it replaces all values
known as type C<SIdRef> in the SBML Level&nbsp;3 specifications.)
This converter only searches the global SId namespace for the Model child of the 
SBMLDocument.  It does not replace any IDs or SIdRefs for LocalParameters, nor
does it replace any UnitSIds or UnitSIdRefs.  It likewise does not replace any IDs
in a new namespace introduced by a package, such as the PortSId namespace
from the Hierarchical Model Composition package, nor any Model objects that are
not the direct child of the SBMLDocument, such as the ModelDefinitions from 
the Hierarchical Model Composition package.
If, however, a package introduces a new element with an "id" attribute
of type SId, any attribute of type SIdRef, or child of type SIdRef (such as 
a new Math child of a package element), those IDs will be replaced if they
match a source identifier.
@section SBMLIdConverter-usage Configuration and use of SBMLIdConverter
SBMLIdConverter is enabled by creating a ConversionProperties object with
the option C<"renameSIds">, and passing this properties object to
SBMLDocument::convert(@if java ConversionProperties@endif).
The converter accepts two options, and both must
be set or else no conversion is performed:
@li C<"currentIds">: A comma-separated list of identifiers to replace.
@li C<"newIds">: A comma-separated list of identifiers to use as the
replacements.  The values should correspond one-to-one with the identifiers
in C<"currentIds"> that should be replaced.
C<opydetails> doc_section_using_sbml_converters

=over


=item SBMLIdConverter::init

@internal


=item SBMLIdConverter::SBMLIdConverter

Creates a new SBMLIdConverter object.


=item SBMLIdConverter::SBMLIdConverter

Copy constructor; creates a copy of an SBMLIdConverter
object.

@param obj the SBMLIdConverter object to copy.


=item SBMLIdConverter::clone

Creates and returns a deep copy of this SBMLIdConverter
object.

@return a (deep) copy of this converter.


=item SBMLIdConverter::matchesProperties

Returns C<true> if this converter object's properties match the given
properties.

A typical use of this method involves creating a ConversionProperties
object, setting the options desired, and then calling this method on
an SBMLIdConverter object to find out if the object's
property values match the given ones.  This method is also used by
SBMLConverterRegistry::getConverterFor(@if java ConversionProperties@endif)
to search across all registered converters for one matching particular
properties.

@param props the properties to match.
@return C<true> if this converter's properties match, C<false>
otherwise.


=item SBMLIdConverter::convert

Perform the conversion.
This method causes the converter to do the actual conversion work,
that is, to convert the SBMLDocument object set by
SBMLConverter::setDocument(@if java SBMLDocument@endif) and
with the configuration options set by
SBMLConverter::setProperties(@if java ConversionProperties@endif).
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink


=item SBMLIdConverter::getDefaultProperties

Returns the default properties of this converter.
A given converter exposes one or more properties that can be adjusted
in order to influence the behavior of the converter.  This method
returns the I<default> property settings for this converter.  It is
meant to be called in order to discover all the settings for the
converter object.
@return the ConversionProperties object describing the default properties
for this converter.


=back

=head2 SBMLInferUnitsConverter

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html Converter for inferring and setting parameter units.
@htmlinclude libsbml-facility-only-warning.html
This SBML converter takes an SBML document and attempts to infer units for
any Parameter objects whose units are undeclared.  It then sets the
"units" attribute of those parameters to the units inferred (if necessary,
creating new UnitDefinition objects on the model in the process).
@section SBMLInferUnitsConverter-usage Configuration and use of SBMLInferUnitsConverter
SBMLInferUnitsConverter is enabled by creating a ConversionProperties
object with the option C<"inferUnits">, and passing this
properties object to SBMLDocument::convert(@if java ConversionProperties@endif).
The converter offers no other options.
C<opydetails> doc_section_using_sbml_converters

=over


=item SBMLInferUnitsConverter::init

@internal


=item SBMLInferUnitsConverter::SBMLInferUnitsConverter

Creates a new SBMLInferUnitsConverter object.


=item SBMLInferUnitsConverter::SBMLInferUnitsConverter

Copy constructor; creates a copy of an SBMLInferUnitsConverter
object.

@param obj the SBMLInferUnitsConverter object to copy.


=item SBMLInferUnitsConverter::clone

Creates and returns a deep copy of this SBMLInferUnitsConverter
object.

@return a (deep) copy of this converter.


=item SBMLInferUnitsConverter::matchesProperties

Returns C<true> if this converter object's properties match the given
properties.

A typical use of this method involves creating a ConversionProperties
object, setting the options desired, and then calling this method on
an SBMLInferUnitsConverter object to find out if the object's
property values match the given ones.  This method is also used by
SBMLConverterRegistry::getConverterFor(@if java ConversionProperties@endif)
to search across all registered converters for one matching particular
properties.

@param props the properties to match.
@return C<true> if this converter's properties match, C<false>
otherwise.


=item SBMLInferUnitsConverter::convert

Perform the conversion.
This method causes the converter to do the actual conversion work,
that is, to convert the SBMLDocument object set by
SBMLConverter::setDocument(@if java SBMLDocument@endif) and
with the configuration options set by
SBMLConverter::setProperties(@if java ConversionProperties@endif).
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@li @link OperationReturnValues_t#LIBSBML_CONV_INVALID_SRC_DOCUMENT LIBSBML_CONV_INVALID_SRC_DOCUMENT@endlink


=item SBMLInferUnitsConverter::getDefaultProperties

Returns the default properties of this converter.
A given converter exposes one or more properties that can be adjusted
in order to influence the behavior of the converter.  This method
returns the I<default> property settings for this converter.  It is
meant to be called in order to discover all the settings for the
converter object.
@return the ConversionProperties object describing the default properties
for this converter.


=item SBMLInferUnitsConverter::existsAlready

@internal


=back

=head2 SBMLInitialAssignmentConverter

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html Converter that removes SBML <em>initial assignments</em>.
@htmlinclude libsbml-facility-only-warning.html
This is an SBML converter for replacing InitialAssignment objects, when
possible, by setting the initial value attributes on the model objects
being assigned.  In other words, for every object that is the target of an
initial assignment in the model, the converter evaluates the mathematical
expression of the assignment to get a I<numerical> value, and then sets
the corresponding attribute of the object to the value.  The effects for
different kinds of SBML components are as follows:
<center>
<table border="0" class="text-table width80 normal-font alt-row-colors">
<tr style="background: lightgray; font-size: 14px;">
<th align="left" width="200">Component</th>
<th align="left">Effect</th>
</tr>
<tr>
<td>Compartment</td>
<td>Sets the value of the C<size> attribute.</td>
</tr>
<tr>
<td>Species</td>
<td>Sets the value of either the C<initialAmount>
or the C<initialConcentration> attributes, depending
on the value of the Species object's
C<hasOnlySubstanceUnits> attribute.</td>
</tr>
<tr>
<td>Parameter</td>
<td>Sets the value of the C<value> attribute.</td>
</tr>
<tr>
<td>SpeciesReference</td>
<td>Sets the value of the C<stoichiometry> attribute
in the Reaction object where the SpeciesReference object appears.</td>
</tr>
</table>
</center>

@section SBMLInitialAssignmentConverter-usage Configuration and use of SBMLInitialAssignmentConverter
SBMLInitialAssignmentConverter is enabled by creating a
ConversionProperties object with the option C<"expandInitialAssignments">,
and passing this properties object to SBMLDocument::convert(@if java
ConversionProperties@endif).  The converter offers no other options.
C<opydetails> doc_section_using_sbml_converters

=over


=item SBMLInitialAssignmentConverter::init

@internal


=item SBMLInitialAssignmentConverter::SBMLInitialAssignmentConverter

Creates a new SBMLInitialAssignmentConverter object.


=item SBMLInitialAssignmentConverter::SBMLInitialAssignmentConverter

Copy constructor; creates a copy of an SBMLInitialAssignmentConverter
object.

@param obj the SBMLInitialAssignmentConverter object to copy.


=item SBMLInitialAssignmentConverter::clone

Creates and returns a deep copy of this SBMLInitialAssignmentConverter
object.

@return a (deep) copy of this converter.


=item SBMLInitialAssignmentConverter::matchesProperties

Returns C<true> if this converter object's properties match the given
properties.

A typical use of this method involves creating a ConversionProperties
object, setting the options desired, and then calling this method on
an SBMLInitialAssignmentConverter object to find out if the object's
property values match the given ones.  This method is also used by
SBMLConverterRegistry::getConverterFor(@if java ConversionProperties@endif)
to search across all registered converters for one matching particular
properties.

@param props the properties to match.
@return C<true> if this converter's properties match, C<false>
otherwise.


=item SBMLInitialAssignmentConverter::convert

Perform the conversion.
This method causes the converter to do the actual conversion work,
that is, to convert the SBMLDocument object set by
SBMLConverter::setDocument(@if java SBMLDocument@endif) and
with the configuration options set by
SBMLConverter::setProperties(@if java ConversionProperties@endif).
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink


=item SBMLInitialAssignmentConverter::getDefaultProperties

Returns the default properties of this converter.
A given converter exposes one or more properties that can be adjusted
in order to influence the behavior of the converter.  This method
returns the I<default> property settings for this converter.  It is
meant to be called in order to discover all the settings for the
converter object.
@return the ConversionProperties object describing the default properties
for this converter.


=back

=head2 SBMLLevelVersionConverter

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html Whole-document SBML Level/Version converter.
@htmlinclude libsbml-facility-only-warning.html
This SBML converter takes an SBML document having one SBML Level+Version
combination, and attempts to convert it to an SBML document having a
different Level+Version combination.
This class is also the basis for
SBMLDocument::setLevelAndVersion(@if java long, long, boolean@endif).
@section SBMLLevelVersionConverter-usage Configuration and use of SBMLLevelVersionConverter
SBMLLevelVersionConverter is enabled by creating a ConversionProperties
object with the option C<"setLevelAndVersion">, and passing this
properties object to SBMLDocument::convert(@if java
ConversionProperties@endif).  The target SBML Level and Version
combination are determined by the value of the SBML namespace set on the
ConversionProperties object (using
ConversionProperties::setTargetNamespaces(SBMLNamespaces  targetNS)).
In addition, this converter offers the following options:
@li C<"strict">: If this option has the value C<true>, then the validity
of the SBML document will be strictly preserved.  This means that SBML
validation will be performed, and if the original model is not valid or
semantics cannot be preserved in the converted model, then conversion will
not be performed.  Conversely, if this option is set to C<false>, model
conversion will always be performed; if any errors are detected related to
altered semantics, the errors will be logged in the usual way (i.e., the
error log on the SBMLDocument object).
@li C<"addDefaultUnits">: By default, a conversion from SBML Level&nbsp;2
to Level&nbsp;3 will explicitly add UnitDefinition objects and unit
attributes on the Model object to define units that are implicitly defined
in SBML Level&nbsp;2.  This is usually desirable because in SBML
Level&nbsp;3, there are no default units and a conversion from
Level&nbsp;2 that did I<not> add unit definitions would actually result
in a loss of information.  However, some users or software tools may not
need or want this, or worse, may be fooled into thinking that libSBML has
somehow inferred the proper units for model quantities.  (It has not; it
merely adds generic predefined units.)  This option lets callers control
this behavior.
C<opydetails> doc_section_using_sbml_converters

=over


=item SBMLLevelVersionConverter::init

@internal


=item SBMLLevelVersionConverter::SBMLLevelVersionConverter

Creates a new SBMLLevelVersionConverter object.


=item SBMLLevelVersionConverter::SBMLLevelVersionConverter

Copy constructor; creates a copy of an SBMLLevelVersionConverter
object.

@param obj the SBMLLevelVersionConverter object to copy.


=item SBMLLevelVersionConverter::clone

Creates and returns a deep copy of this SBMLLevelVersionConverter
object.

@return a (deep) copy of this converter.


=item SBMLLevelVersionConverter::matchesProperties

Returns C<true> if this converter object's properties match the given
properties.

A typical use of this method involves creating a ConversionProperties
object, setting the options desired, and then calling this method on
an SBMLLevelVersionConverter object to find out if the object's
property values match the given ones.  This method is also used by
SBMLConverterRegistry::getConverterFor(@if java ConversionProperties@endif)
to search across all registered converters for one matching particular
properties.

@param props the properties to match.
@return C<true> if this converter's properties match, C<false>
otherwise.


=item SBMLLevelVersionConverter::convert

Perform the conversion.
This method causes the converter to do the actual conversion work,
that is, to convert the SBMLDocument object set by
SBMLConverter::setDocument(@if java SBMLDocument@endif) and
with the configuration options set by
SBMLConverter::setProperties(@if java ConversionProperties@endif).
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@li @link OperationReturnValues_t#LIBSBML_CONV_INVALID_TARGET_NAMESPACE LIBSBML_CONV_INVALID_TARGET_NAMESPACE@endlink
@li @link OperationReturnValues_t#LIBSBML_CONV_PKG_CONVERSION_NOT_AVAILABLE LIBSBML_CONV_PKG_CONVERSION_NOT_AVAILABLE@endlink
@li @link OperationReturnValues_t#LIBSBML_CONV_INVALID_SRC_DOCUMENT LIBSBML_CONV_INVALID_SRC_DOCUMENT@endlink


=item SBMLLevelVersionConverter::getDefaultProperties

Returns the default properties of this converter.
A given converter exposes one or more properties that can be adjusted
in order to influence the behavior of the converter.  This method
returns the I<default> property settings for this converter.  It is
meant to be called in order to discover all the settings for the
converter object.
@return the ConversionProperties object describing the default properties
for this converter.


=item SBMLLevelVersionConverter::getTargetLevel

Returns the target SBML Level for the conversion.
@return an integer indicating the SBML Level.


=item SBMLLevelVersionConverter::getTargetVersion

Returns the target SBML Version for the conversion.
@return an integer indicating the Version within the SBML Level.


=item SBMLLevelVersionConverter::getValidityFlag

Returns the flag indicating whether the conversion has been set to "strict".
@return C<true> if strict validity has been requested, C<false>
otherwise.


=item SBMLLevelVersionConverter::getAddDefaultUnits

Returns the flag indicating whether default units should be added when
converting to L3 or not.
@return C<true> if default units should be added, C<false>
otherwise.


=item SBMLLevelVersionConverter::conversion_errors

@internal


=item SBMLLevelVersionConverter::hasStrictUnits

@internal


=item SBMLLevelVersionConverter::hasStrictSBO

@internal


=item SBMLLevelVersionConverter::performConversion

@internal


=item SBMLLevelVersionConverter::validateConvertedDocument

@internal


=item SBMLLevelVersionConverter::has_fatal_errors

@internal


=item SBMLLevelVersionConverter::speciesReferenceIdUsed

@internal


=item SBMLLevelVersionConverter::collectSpeciesReferenceIds

@internal


=item MathFilter::MathFilter

@internal


=item MathFilter::filter

@internal


=back

=head2 SBMLLevel1Version1Converter

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html Whole-document SBML Level/Version converter.
@htmlinclude libsbml-facility-only-warning.html
This SBML converter takes an SBML document having one SBML Level+Version
combination, and attempts to convert it to an SBML document having a
different Level+Version combination.  This converter
(SBMLLevel1Version1Converter) converts models to SBML Level&nbsp;1
Version&nbsp;1, to the extent possible by the limited features of
that Level/Version combination of SBML.
@section SBMLLevel1Version1Converter-usage Configuration and use of SBMLLevel1Version1Converter
SBMLLevel1Version1Converter is enabled by creating a ConversionProperties
object with the option C<"convertToL1V1">, and passing this
properties object to SBMLDocument::convert(@if java
ConversionProperties@endif).  The target SBML Level and Version
combination are determined by the value of the SBML namespace set on the
ConversionProperties object (using
ConversionProperties::setTargetNamespaces(SBMLNamespaces  targetNS)).
In addition, this converter offers the following options:
@li C<"changePow">: Mathematical expressions for exponentiation of
the form C<pow(s1, 2)> will be converted to the expression
C<s1^2>.
  
@li C<"inlineCompartmentSizes">: Back in the days of SBML Level&nbsp;1
Version&nbsp;1, many software tools assumed that the "kinetic laws" of
SBML were written in terms of units of
<em>concentration</em>/<em>time</em>.  These tools would not expect (and
thus not handle) rate expressions such as
C<CompartmentOfS1   k   S1>.
When the option C<"inlineCompartmentSizes"> is enabled, libSBML will
replace the references to compartments (such as C<"CompartmentOfS1"> in
this example) with their initial sizes.  This is not strictly correct in
all cases; in particular, if the compartment volume varies during
simulation, this conversion will not reflect the expected behavior.
However, many models do not have time-varying compartment sizes, so this
option makes it easy to get modern SBML rate expressions into a form that
old software tools may better understand.
C<opydetails> doc_section_using_sbml_converters

=over


=item SBMLLevel1Version1Converter::init

@internal


=item SBMLLevel1Version1Converter::SBMLLevel1Version1Converter

Creates a new SBMLLevel1Version1Converter object.


=item SBMLLevel1Version1Converter::SBMLLevel1Version1Converter

Copy constructor; creates a copy of an SBMLLevel1Version1Converter
object.
    
@param obj the SBMLLevel1Version1Converter object to copy.


=item SBMLLevel1Version1Converter::clone

Creates and returns a deep copy of this SBMLLevel1Version1Converter
object.
    
@return a (deep) copy of this converter.


=item SBMLLevel1Version1Converter::matchesProperties

Returns C<true> if this converter object's properties match the given
properties.
    
A typical use of this method involves creating a ConversionProperties
object, setting the options desired, and then calling this method on
an SBMLLevel1Version1Converter object to find out if the object's
property values match the given ones.  This method is also used by
SBMLConverterRegistry::getConverterFor(@if java ConversionProperties@endif)
to search across all registered converters for one matching particular
properties.
    
@param props the properties to match.
@return C<true> if this converter's properties match, C<false
>
otherwise.


=item SBMLLevel1Version1Converter::convert

Perform the conversion.
This method causes the converter to do the actual conversion work,
that is, to convert the SBMLDocument object set by
SBMLConverter::setDocument(@if java SBMLDocument@endif) and
with the configuration options set by
SBMLConverter::setProperties(@if java ConversionProperties@endif).
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@li @link OperationReturnValues_t#LIBSBML_CONV_INVALID_TARGET_NAMESPACE LIBSBML_CONV_INVALID_TARGET_NAMESPACE@endlink
@li @link OperationReturnValues_t#LIBSBML_CONV_PKG_CONVERSION_NOT_AVAILABLE LIBSBML_CONV_PKG_CONVERSION_NOT_AVAILABLE@endlink
@li @link OperationReturnValues_t#LIBSBML_CONV_INVALID_SRC_DOCUMENT LIBSBML_CONV_INVALID_SRC_DOCUMENT@endlink


=item SBMLLevel1Version1Converter::getDefaultProperties

Returns the default properties of this converter.
A given converter exposes one or more properties that can be adjusted
in order to influence the behavior of the converter.  This method
returns the I<default> property settings for this converter.  It is
meant to be called in order to discover all the settings for the
converter object.
@return the ConversionProperties object describing the default properties
for this converter.


=item SBMLLevel1Version1Converter::inlineCompartmentSizes

@internal


=item SBMLLevel1Version1Converter::shouldChangePow

@internal


=back

=head2 SBMLLocalParameterConverter

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html Converter to turn local parameters into global ones.
@htmlinclude libsbml-facility-only-warning.html
This converter essentially promotes local parameters to global parameters.
It works by examining every Reaction object for LocalParameter objects,
then creating Parameter objects on the model for each one found, and
finally removing the original LocalParameter objects.  It creates new
identifiers for the fresh Parameter objects by concatenating the
identifier of the reaction with the identifier of the original
LocalParameter object.
This converter can be useful for software applications that do not have
the ability to handle local parameters on reactions.  Such applications
could check incoming models for local parameters and run those models
through this converter before proceeding with other steps.
@section SBMLLocalParameterConverter-usage Configuration and use of SBMLLocalParameterConverter
SBMLLocalParameterConverter is enabled by creating a ConversionProperties
object with the option C<"promoteLocalParameters">, and passing this
properties object to SBMLDocument::convert(@if java
ConversionProperties@endif).  The converter offers no other options.
C<opydetails> doc_section_using_sbml_converters

=over


=item SBMLLocalParameterConverter::init

@internal


=item SBMLLocalParameterConverter::SBMLLocalParameterConverter

Creates a new SBMLLocalParameterConverter object.


=item SBMLLocalParameterConverter::SBMLLocalParameterConverter

Copy constructor; creates a copy of an SBMLLocalParameterConverter
object.

@param obj the SBMLLocalParameterConverter object to copy.


=item SBMLLocalParameterConverter::clone

Creates and returns a deep copy of this SBMLLocalParameterConverter
object.

@return a (deep) copy of this converter.


=item SBMLLocalParameterConverter::matchesProperties

Returns C<true> if this converter object's properties match the given
properties.

A typical use of this method involves creating a ConversionProperties
object, setting the options desired, and then calling this method on
an SBMLLocalParameterConverter object to find out if the object's
property values match the given ones.  This method is also used by
SBMLConverterRegistry::getConverterFor(@if java ConversionProperties@endif)
to search across all registered converters for one matching particular
properties.

@param props the properties to match.
@return C<true> if this converter's properties match, C<false>
otherwise.


=item SBMLLocalParameterConverter::convert

Perform the conversion.
This method causes the converter to do the actual conversion work,
that is, to convert the SBMLDocument object set by
SBMLConverter::setDocument(@if java SBMLDocument@endif) and
with the configuration options set by
SBMLConverter::setProperties(@if java ConversionProperties@endif).
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink


=item SBMLLocalParameterConverter::getDefaultProperties

Returns the default properties of this converter.
A given converter exposes one or more properties that can be adjusted
in order to influence the behavior of the converter.  This method
returns the I<default> property settings for this converter.  It is
meant to be called in order to discover all the settings for the
converter object.
@return the ConversionProperties object describing the default properties
for this converter.


=back

=head2 SBMLReactionConverter

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html Converter to replace reactions with SBML <em>rate rules</em>.
@htmlinclude libsbml-facility-only-warning.html
This converter will take an SBML model and replace the definitions of
reactions in the model with definitions of SBML rate rules.  Equivalent
RateRule objects are only created for species mentioned in reactions that
have KineticLaw subobjects, since those are the only reactions that have
an effect on the rates of change of species in the model; however, the
converter removes all Reaction objects in the model after it is done.
@section SBMLReactionConverter-usage Configuration and use of SBMLReactionConverter
SBMLReactionConverter is enabled by creating a ConversionProperties object
with the option C<"replaceReactions">, and passing this properties object
to SBMLDocument::convert(@if java ConversionProperties@endif).  This
converter does not offer any additional configuration options.
C<opydetails> doc_section_using_sbml_converters

=over


=item SBMLReactionConverter::init

@internal


=item SBMLReactionConverter::SBMLReactionConverter

Creates a new SBMLReactionConverter object.


=item SBMLReactionConverter::SBMLReactionConverter

Copy constructor; creates a copy of an SBMLReactionConverter
object.

@param obj the SBMLReactionConverter object to copy.


=item SBMLReactionConverter::clone

Creates and returns a deep copy of this SBMLReactionConverter
object.

@return a (deep) copy of this converter.


=item SBMLReactionConverter::matchesProperties

Returns C<true> if this converter object's properties match the given
properties.

A typical use of this method involves creating a ConversionProperties
object, setting the options desired, and then calling this method on
an SBMLReactionConverter object to find out if the object's
property values match the given ones.  This method is also used by
SBMLConverterRegistry::getConverterFor(@if java ConversionProperties@endif)
to search across all registered converters for one matching particular
properties.

@param props the properties to match.
@return C<true> if this converter's properties match, C<false>
otherwise.


=item SBMLReactionConverter::convert

Perform the conversion.
This method causes the converter to do the actual conversion work,
that is, to convert the SBMLDocument object set by
SBMLConverter::setDocument(@if java SBMLDocument@endif) and
with the configuration options set by
SBMLConverter::setProperties(@if java ConversionProperties@endif).
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@li @link OperationReturnValues_t#LIBSBML_CONV_INVALID_SRC_DOCUMENT LIBSBML_CONV_INVALID_SRC_DOCUMENT@endlink


=item SBMLReactionConverter::getDefaultProperties

Returns the default properties of this converter.
A given converter exposes one or more properties that can be adjusted
in order to influence the behavior of the converter.  This method
returns the I<default> property settings for this converter.  It is
meant to be called in order to discover all the settings for the
converter object.
@return the ConversionProperties object describing the default properties
for this converter.


=item SBMLReactionConverter::setDocument

Sets the current SBML document to the given SBMLDocument object.
@param doc the document to use for this conversion.
@warning Even though the C<doc> is 'const', it is immediately cast
to a non-const version, which is then usually changed by the
converter upon a successful conversion.  This function is here
solely to preserve backwards compatibility.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink


=item SBMLReactionConverter::setDocument

Sets the current SBML document to the given SBMLDocument object.
@param doc the document to use for this conversion.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink


=item SBMLReactionConverter::createRateRuleMathForSpecies

@internal


=item SBMLReactionConverter::determineStoichiometryNode

@internal


=item SBMLReactionConverter::createRateRule

@internal


=item SBMLReactionConverter::replaceReactions

@internal


=item SBMLReactionConverter::isDocumentValid

@internal


=back

=head2 SBMLRuleConverter

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html Converter that sorts SBML rules and assignments.
@htmlinclude libsbml-facility-only-warning.html
This converter reorders assignments in a model.  Specifically, it sorts
the list of assignment rules (i.e., the AssignmentRule objects contained
in the ListOfAssignmentRules within the Model object) and the initial
assignments (i.e., the InitialAssignment objects contained in the
ListOfInitialAssignments) such that, within each set, assignments that
depend on I<prior> values are placed I<after> the values are set.  For
example, if there is an assignment rule stating <i>a = b + 1</i>, and
another rule stating <i>b = 3</i>, the list of rules is sorted and the
rules are arranged so that the rule for <i>b = 3</i> appears I<before>
the rule for <i>a = b + 1</i>.  Similarly, if dependencies of this
sort exist in the list of initial assignments in the model, the initial
assignments are sorted as well.
Beginning with SBML Level 2, assignment rules have no ordering
required---the order in which the rules appear in an SBML file has
no significance.  Software tools, however, may need to reorder
assignments for purposes of evaluating them.  For example, for
simulators that use time integration methods, it would be a good idea to
reorder assignment rules such as the following,
<i>b = a + 10 seconds</i><br>
<i>a = time</i>
so that the evaluation of the rules is independent of integrator
step sizes. (This is due to the fact that, in this case, the order in
which the rules are evaluated changes the result.)  SBMLRuleConverter
can be used to reorder the SBML objects regardless of whether the
input file contained them in the desired order.
Note that the two sets of SBML assignments (list of assignment rules on
the one hand, and list of initial assignments on the other hand) are
handled I<independently>.  In an SBML model, these entities are treated
differently and no amount of sorting can deal with inter-dependencies
between assignments of the two kinds.
@section SBMLRuleConverter-usage Configuration and use of SBMLRuleConverter
SBMLRuleConverter is enabled by creating a ConversionProperties object
with the option C<"sortRules">, and passing this properties object to
SBMLDocument::convert(@if java ConversionProperties@endif).  This
converter offers no other options.
C<opydetails> doc_section_using_sbml_converters

=over


=item SBMLRuleConverter::init

@internal


=item SBMLRuleConverter::SBMLRuleConverter

Creates a new SBMLLevelVersionConverter object.


=item SBMLRuleConverter::SBMLRuleConverter

Copy constructor; creates a copy of an SBMLLevelVersionConverter
object.

@param obj the SBMLLevelVersionConverter object to copy.


=item SBMLRuleConverter::clone

Creates and returns a deep copy of this SBMLLevelVersionConverter
object.

@return a (deep) copy of this converter.


=item SBMLRuleConverter::matchesProperties

Returns C<true> if this converter object's properties match the given
properties.

A typical use of this method involves creating a ConversionProperties
object, setting the options desired, and then calling this method on
an SBMLLevelVersionConverter object to find out if the object's
property values match the given ones.  This method is also used by
SBMLConverterRegistry::getConverterFor(@if java ConversionProperties@endif)
to search across all registered converters for one matching particular
properties.

@param props the properties to match.
@return C<true> if this converter's properties match, C<false>
otherwise.


=item SBMLRuleConverter::convert

Perform the conversion.
This method causes the converter to do the actual conversion work,
that is, to convert the SBMLDocument object set by
SBMLConverter::setDocument(@if java SBMLDocument@endif) and
with the configuration options set by
SBMLConverter::setProperties(@if java ConversionProperties@endif).
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@li @link OperationReturnValues_t#LIBSBML_CONV_INVALID_SRC_DOCUMENT LIBSBML_CONV_INVALID_SRC_DOCUMENT@endlink


=item SBMLRuleConverter::getDefaultProperties

Returns the default properties of this converter.
A given converter exposes one or more properties that can be adjusted
in order to influence the behavior of the converter.  This method
returns the I<default> property settings for this converter.  It is
meant to be called in order to discover all the settings for the
converter object.
@return the ConversionProperties object describing the default properties
for this converter.


=back

=head2 SBMLStripPackageConverter

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html Converter that removes SBML Level 3 packages.
@htmlinclude libsbml-facility-only-warning.html
This SBML converter takes an SBML document and removes (strips) an SBML
Level&nbsp;3 package from it.  No conversion is performed; the package
constructs are simply removed from the SBML document.  The package to be
stripped is determined by the value of the option C<"package"> on the
conversion properties.
@section SBMLStripPackageConverter-usage Configuration and use of SBMLStripPackageConverter
SBMLStripPackageConverter is enabled by creating a ConversionProperties
object with the option C<"stripPackage">, and passing this properties
object to SBMLDocument::convert(@if java ConversionProperties@endif).
This converter takes one required option:
@li C<"package">: the value of this option should be a text string, the
nickname of the SBML Level&nbsp;3 package to be stripped from the model.
In addition, the converter understands an additional optional:
@li C<"stripAllUnrecognized">: if set to C<true>, the converter will
remove all SBML Level&nbsp;3 package constructs for Level&nbsp;3 packages
that this copy of libSBML does not recognize.  Note that what a given copy
of libSBML recognizes is determined by which plug-ins it has been
configured to include.  If this option is enabled, it may remove SBML
Level&nbsp;3 package constructs that are legitimate in the sense that they
are officially defined SBML constructs, but not recognized because the
running copy of libSBML has not had support enabled for them.
C<opydetails> doc_section_using_sbml_converters

=over


=item SBMLStripPackageConverter::init

@internal


=item SBMLStripPackageConverter::SBMLStripPackageConverter

Creates a new SBMLStripPackageConverter object.


=item SBMLStripPackageConverter::SBMLStripPackageConverter

Copy constructor; creates a copy of an SBMLStripPackageConverter
object.

@param obj the SBMLStripPackageConverter object to copy.


=item SBMLStripPackageConverter::clone

Creates and returns a deep copy of this SBMLStripPackageConverter
object.

@return the (deep) copy of this converter object.


=item SBMLStripPackageConverter::matchesProperties

Returns C<true> if this converter object's properties match the given
properties.

A typical use of this method involves creating a ConversionProperties
object, setting the options desired, and then calling this method on
an SBMLStripPackageConverter object to find out if the object's
property values match the given ones.  This method is also used by
SBMLConverterRegistry::getConverterFor(@if java ConversionProperties@endif)
to search across all registered converters for one matching particular
properties.

@param props the properties to match.
@return C<true> if this converter's properties match, C<false>
otherwise.


=item SBMLStripPackageConverter::convert

Perform the conversion.
This method causes the converter to do the actual conversion work,
that is, to convert the SBMLDocument object set by
SBMLConverter::setDocument(@if java SBMLDocument@endif) and
with the configuration options set by
SBMLConverter::setProperties(@if java ConversionProperties@endif).
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
@li @link OperationReturnValues_t#LIBSBML_CONV_PKG_CONSIDERED_UNKNOWN LIBSBML_CONV_PKG_CONSIDERED_UNKNOWN@endlink


=item SBMLStripPackageConverter::getDefaultProperties

Returns the default properties of this converter.
A given converter exposes one or more properties that can be adjusted
in order to influence the behavior of the converter.  This method
returns the I<default> property settings for this converter.  It is
meant to be called in order to discover all the settings for the
converter object.
@return the ConversionProperties object describing the default properties
for this converter.


=item SBMLStripPackageConverter::getPackageToStrip

@return the package to be stripped.


=item SBMLStripPackageConverter::isStripAllUnrecognizedPackages

@return a boolean indicating whether all unrecognized packages should be removed.


=item SBMLStripPackageConverter::stripPackage

@internal


=back

=head2 SBMLUnitsConverter

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html Converts a model's existing units to SI units.
@htmlinclude libsbml-facility-only-warning.html
This SBML converter converts the units in a model to base SI units, that
is, using only the units metre, kilogram, second, ampere, kelvin, mole and
candela.

Unit conversion will only be performed on models that are fully unit
consistent, meaning that all objects have units associated with them and
there are no literal numbers with unspecified units.  In the case of an
SBML Level&nbsp;3 model involving math expressions, this means that the @c
timeUnits attribute on the Model object must be set, and if there are any
reactions in the model, the C<extentUnits> attribute on the Model object
must also be set.
@section SBMLUnitsConverter-usage Configuration and use of SBMLUnitsConverter
SBMLUnitsConverter is enabled by creating a ConversionProperties object
with the option C<"units">, and passing this properties object to
SBMLDocument::convert(@if java ConversionProperties@endif).  This
converter takes one optional option:
@li C<"removeUnusedUnits">: the value of this property should be a
Boolean.  If it is C<true>, it tells the unit convert to remove any unused
UnitDefinition objects after conversion is complete.  ("Unused" units are
units that are not referenced by any object in the model.)  If the value
is C<false>, unused UnitDefinition objects are not removed from the model.
The default is C<true>.
C<opydetails> doc_section_using_sbml_converters

=over


=item SBMLUnitsConverter::init

@internal


=item SBMLUnitsConverter::SBMLUnitsConverter

Creates a new SBMLUnitsConverter object.


=item SBMLUnitsConverter::SBMLUnitsConverter

Copy constructor; creates a copy of an SBMLUnitsConverter
object.

@param obj the SBMLUnitsConverter object to copy.


=item SBMLUnitsConverter::clone

Creates and returns a deep copy of this SBMLUnitsConverter
object.

@return a (deep) copy of this converter.


=item SBMLUnitsConverter::matchesProperties

Returns C<true> if this converter object's properties match the given
properties.

A typical use of this method involves creating a ConversionProperties
object, setting the options desired, and then calling this method on
an SBMLUnitsConverter object to find out if the object's
property values match the given ones.  This method is also used by
SBMLConverterRegistry::getConverterFor(@if java ConversionProperties@endif)
to search across all registered converters for one matching particular
properties.

@param props the properties to match.
@return C<true> if this converter's properties match, C<false>
otherwise.


=item SBMLUnitsConverter::convert

Perform the conversion.
This method causes the converter to do the actual conversion work,
that is, to convert the SBMLDocument object set by
SBMLConverter::setDocument(@if java SBMLDocument@endif) and
with the configuration options set by
SBMLConverter::setProperties(@if java ConversionProperties@endif).
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@li @link OperationReturnValues_t#LIBSBML_CONV_CONVERSION_NOT_AVAILABLE LIBSBML_CONV_CONVERSION_NOT_AVAILABLE@endlink
@li @link OperationReturnValues_t#LIBSBML_CONV_INVALID_SRC_DOCUMENT LIBSBML_CONV_INVALID_SRC_DOCUMENT@endlink


=item SBMLUnitsConverter::getDefaultProperties

Returns the default properties of this converter.
A given converter exposes one or more properties that can be adjusted
in order to influence the behavior of the converter.  This method
returns the I<default> property settings for this converter.  It is
meant to be called in order to discover all the settings for the
converter object.
@return the ConversionProperties object describing the default properties
for this converter.


=item SBMLUnitsConverter::convertUnits

@internal


=item SBMLUnitsConverter::convertUnits

@internal


=item SBMLUnitsConverter::applyNewUnitDefinition

@internal


=item SBMLUnitsConverter::existsAlready

@internal


=item SBMLUnitsConverter::getRemoveUnusedUnitsFlag

@internal


=item SBMLUnitsConverter::removeUnusedUnitDefinitions

@internal


=item SBMLUnitsConverter::convertGlobalUnits

@internal


=item SBMLUnitsConverter::convertCnUnits

@internal


=item SBMLUnitsConverter::isUsed

@internal


=item SBMLUnitsConverter::unacceptable_errors

@internal


=item SBMLUnitsConverter::hasCnUnits

@internal


=item SBMLUnitsConverter::mathHasCnUnits

@internal


=item SBMLUnitsConverter::matchesCnUnits

@internal


=item SBMLUnitsConverter::mathMatchesCnUnits

@internal


=item SBMLUnitsConverter::convertAST

@internal


=back

=head2 SBMLValidator

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html Base class for SBML validators.
@htmlinclude not-sbml-warning.html
LibSBML implements facilities for verifying that a given SBML document
is valid according to the SBML specifications; it also exposes the
validation interface so that user programs and SBML Level&nbsp;3 package
authors may use the facilities to implement new validators.  There are
two main interfaces to libSBML's validation facilities, based on the
classes Validator and SBMLValidator.
The Validator class is the basis of the system for validating an SBML
document against the validation rules defined in the SBML
specifications.  The scheme used by Validator relies is compact and uses
the I<visitor> programming pattern, but it relies on C/C++ features and
is not directly accessible from language bindings.  SBMLValidator offers
a framework for straightforward class-based extensibility, so that user
code can subclass SBMLValidator to implement new validation systems,
different validators can be introduced or turned off at run-time, and
interfaces can be provided in the libSBML language bindings.
SBMLValidator can call Validator functionality internally (as is the
case in the current implementation of SBMLInternalValidator) or use
entirely different implementation approaches, as necessary.
Users of libSBML may already be familiar with the facilities encompassed
by the validation system, in the form of the consistency-checking methods
defined on SBMLDocument.  The methods SBMLDocument::setConsistencyChecks(@if java int, boolean@endif),
SBMLDocument::checkConsistency(), SBMLDocument::checkInternalConsistency()
and other method of that sort are in fact implemented via SBMLValidator,
specifically as methods on the class SBMLInternalValidator.
Authors may use SBMLValidator as the base class for their own validator
extensions to libSBML.  The class SBMLInternalValidator may serve as a
code example for how to implement such things.

=over


=item SBMLValidator::SBMLValidator

Creates a new SBMLValidator.


=item SBMLValidator::SBMLValidator

Copy constructor; creates a copy of an SBMLValidator object.
@param orig the object to copy.


=item SBMLValidator::clone

Creates and returns a deep copy of this SBMLValidator object.
@return the (deep) copy of this SBMLValidator object.


=item SBMLValidator::getDocument

Returns the current SBML document in use by this validator.
@return the current SBML document.
@see setDocument(@if java SBMLDocument@endif)


=item SBMLValidator::getDocument

Returns the current SBML document in use by this validator.
@return a const reference to the current SBML document.
@see setDocument(@if java SBMLDocument@endif)


=item SBMLValidator::setDocument

Sets the current SBML document to the given SBMLDocument object.
@param doc the document to use for this validation.
C<opydetails> doc_returns_one_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@see getDocument()


=item SBMLValidator::validate

Runs this validator on the current SBML document.
@return an integer value indicating the success/failure of the
validation.  @if clike The value is drawn from the enumeration
#OperationReturnValues_t. @endif@~ The possible values returned by this
function are determined by the specific subclasses of this class.


=item SBMLValidator::clearFailures

Clears this validator's list of failures.
If you are validating multiple SBML documents with the same validator,
call this method after you have processed the list of failures from
the last validation run and before validating the next document.
@if clike @see getFailures() @endif@~


=item SBMLValidator::getFailures

Returns a list of SBMLError objects (if any) that were logged by the
last run of this validator.
@return a list of errors, warnings and other diagnostics logged during
validation.

@see clearFailures()


=item SBMLValidator::logFailure

Adds the given failure to this list of Validators failures.
@param err an SBMLError object representing an error or warning.
@if clike @see getFailures() @endif@~


=item SBMLValidator::validate

Validates the given SBMLDocument object.
This is identical to calling setDocument(@if java SBMLDocument @endif)
followed by validate().
@param d the SBML document to validate.
@return the number of validation failures that occurred.  The objects
describing the actual failures can be retrieved using getFailures().


=item SBMLValidator::validate

Validates the SBML document located at the given C<filename>.
This is a convenience method that saves callers the trouble of
using SBMLReader to read the document first.
@param filename the path to the file to be read and validated.
@return the number of validation failures that occurred.  The objects
describing the actual failures can be retrieved using getFailures().


=item SBMLValidator::getErrorLog

Returns the list of errors or warnings logged during parsing,
consistency checking, or attempted translation of this model.
Note that this refers to the SBMLDocument object's error log (i.e.,
the list returned by SBMLDocument::getErrorLog()).  I<That> list of
errors and warnings is I<separate> from the validation failures
tracked by this validator (i.e., the list returned by getFailures()).
@return the SBMLErrorLog used for the SBMLDocument.
@if clike @see getFailures() @endif@~


=item SBMLValidator::getModel

Returns the Model object stored in the SBMLDocument.
It is important to note that this method <em>does not create</em> a
Model instance.  The model in the SBMLDocument must have been created
at some prior time, for example using SBMLDocument::createModel() 
or SBMLDocument::setModel(@if java Model@endif).
This method returns C<NULL> if a model does not yet exist.
@return the Model contained in this validator's SBMLDocument object.
@see SBMLDocument::setModel(@if java Model@endif)
@see SBMLDocument::createModel()


=item SBMLValidator::getModel

Returns the Model object stored in the SBMLDocument.
It is important to note that this method <em>does not create</em> a
Model instance.  The model in the SBMLDocument must have been created
at some prior time, for example using SBMLDocument::createModel() 
or SBMLDocument::setModel(@if java Model@endif).
This method returns C<NULL> if a model does not yet exist.
@return the Model contained in this validator's SBMLDocument object.
@see SBMLDocument::setModel(@if java Model@endif)
@see SBMLDocument::createModel()


=item SBMLValidator::getNumFailures

Returns the number of failures encountered in the last validation run.
This method returns the number of failures logged by this validator.
This number only reflects I<this> validator's actions; the number may
not be the same as the number of errors and warnings logged on the
SBMLDocument object's error log (i.e., the object returned by
SBMLDocument::getErrorLog()), because other parts of libSBML may log
errors and warnings beyond those found by this validator.
@return the number of errors logged by this validator.


=item SBMLValidator::getFailure

Returns the failure object at index n in this validator's list of
failures logged during the last run.
Callers should use getNumFailures() first, to find out the number
of entries in this validator's list of failures.
@param n an integer indicating the index of the object to return from
the failures list; index values start at 0.
@return the failure at the given index number.
@see getNumFailures()


=back

=head2 SBMLExternalValidator

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html 
@internal

=over


=item SBMLExternalValidator::SBMLExternalValidator

@internal


=item SBMLExternalValidator::SBMLExternalValidator

@internal


=item SBMLExternalValidator::clone

@internal


=item SBMLExternalValidator::validate

@internal


=item SBMLExternalValidator::getProgram

@internal


=item SBMLExternalValidator::setProgram

@internal


=item SBMLExternalValidator::getOutputFileName

@internal


=item SBMLExternalValidator::setOutputFileName

@internal


=item SBMLExternalValidator::getSBMLFileName

@internal


=item SBMLExternalValidator::setSBMLFileName

@internal


=item SBMLExternalValidator::clearArguments

@internal


=item SBMLExternalValidator::addArgument

@internal


=item SBMLExternalValidator::getNumArguments

@internal


=item SBMLExternalValidator::getArgument

@internal


=item SBMLExternalValidator::getArguments

@internal


=item SBMLExternalValidator::setArguments

@internal


=back

=head2 XMLAttributes

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html A list of attributes on an XML element.
@htmlinclude not-sbml-warning.html
In libSBML's XML interface layer, attributes on an element are stored as a
list of values kept in an XMLAttributes object.  XMLAttributes has methods
for adding and removing individual attributes as well as performing other
actions on the list of attributes.  Classes in libSBML that represent nodes
in an XML document (i.e., XMLNode and its parent class, XMLToken) use
XMLAttributes objects to manage attributes on XML elements.
Attributes on an XML element can be written in one of two forms:
@li C<name="value">
@li C<prefix:name="value">
An attribute in XML must always have a value, and the value must always be
a quoted string; i.e., it is always C<name="value"> and not
C<name=value>.  An empty value is represented simply as an
empty string; i.e., C<name="">.
In cases when a C<prefix> is provided with an attribute name,
general XML validity rules require that the prefix is an XML namespace
prefix that has been declared somewhere else (possibly as an another
attribute on the same element).  However, the XMLAttributes class does
I<not> test for the proper existence or declaration of XML
namespaces&mdash;callers must arrange to do this themselves in some other
way.  This class only provides facilities for tracking and manipulating
attributes and their prefix/URI/name/value components.
C<opydetails> doc_note_attributes_are_unordered
@see XMLTriple
@see XMLNode
@see XMLToken

=over


=item XMLAttributes::XMLAttributes

Creates a new, empty XMLAttributes object.


=item XMLAttributes::XMLAttributes

Copy constructor; creates a copy of this XMLAttributes object.
C<orig> the XMLAttributes object to copy.


=item XMLAttributes::clone

Creates and returns a deep copy of this XMLAttributes object.
@return the (deep) copy of this XMLAttributes object.


=item XMLAttributes::add

Adds an attribute to this list of attributes.
C<opydetails> doc_add_behavior_explanation
@param name a string, the unprefixed name of the attribute.
@param value a string, the value of the attribute.
@param namespaceURI a string, the namespace URI of the attribute.
@param prefix a string, a prefix for the XML namespace.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
&ndash; this value is returned if any of the arguments are C<NULL>.  To
set an empty C<prefix> and/or C<name> value, use an empty string rather
than C<NULL>.
C<opydetails> doc_note_overwrites_existing_values
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~
@see add(const XMLTriple& triple, const std::string& value)
@see getIndex(const std::string& name, const std::string& uri) const
@see getIndex(const XMLTriple& triple) const
@see hasAttribute(const std::string name, const std::string uri) const
@see hasAttribute(const XMLTriple& triple) const


=item XMLAttributes::add

Adds an attribute to this list of attributes.
C<opydetails> doc_add_behavior_explanation
@param triple an XMLTriple object describing the attribute to be added.
@param value a string, the value of the attribute.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
&ndash; this value is returned if any of the arguments are C<NULL>.  To
set an empty value for the attribute, use an empty string rather than @c
NULL.

C<opydetails> doc_note_overwrites_existing_values
@see add(const std::string& name, const std::string& value, const std::string& namespaceURI, const std::string& prefix)
@see getIndex(const std::string& name, const std::string& uri) const
@see getIndex(const XMLTriple& triple) const
@see hasAttribute(const std::string name, const std::string uri) const
@see hasAttribute(const XMLTriple& triple) const


=item XMLAttributes::addResource

@internal


=item XMLAttributes::removeResource

@internal


=item XMLAttributes::remove

Removes the <em>n</em>th attribute from this list of attributes.
@param n an integer the index of the resource to be deleted.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink
The value @link   OperationReturnValues_t#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink is returned if there is no attribute at the
given index C<n>.
C<opydetails> doc_note_attributes_are_unordered
@see getLength()
@see remove(const XMLTriple& triple)
@see remove(const std::string& name, const std::string& uri)


=item XMLAttributes::remove

Removes a named attribute from this list of attributes.
@param name a string, the unprefixed name of the attribute to be
removed.

@param uri a string, the namespace URI of the attribute to be removed.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink
The value @link   OperationReturnValues_t#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink is returned if there is no attribute with the
given C<name> (and C<uri> if specified).
@see remove(int n)
@see remove(const XMLTriple& triple)


=item XMLAttributes::remove

Removes a specific attribute from this list of attributes.
@param triple an XMLTriple describing the attribute to be removed.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink
The value @link   OperationReturnValues_t#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink is returned if there is no attribute matching
the properties of the given C<triple>.
@see remove(int n)
@see remove(const std::string& name, const std::string& uri)


=item XMLAttributes::clear

Removes all attributes in this XMLAttributes object.
C<opydetails> doc_returns_one_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@see remove(int n)
@see remove(const XMLTriple& triple)
@see remove(const std::string& name, const std::string& uri)


=item XMLAttributes::getIndex

Returns the index of an attribute having a given name.
@note This method does not check XML namespaces.  Thus, if there are
multiple attributes with the same local C<name> but different
namespaces, this method will return the first one found.  Callers should
use the more specific methods
XMLAttributes::getIndex(const std::string& name, const std::string& uri) const
or XMLAttributes::getIndex(const XMLTriple& triple) const
to find attributes in particular namespaces.
@param name a string, the name of the attribute whose index is begin
sought.

@return the index of an attribute with the given local name, or
C<-1> if no such attribute is present.
@see hasAttribute(const std::string name, const std::string uri) const
@see hasAttribute(const XMLTriple& triple) const


=item XMLAttributes::getIndex

Returns the index of the attribute having a given name and XML namespace
URI.

@param name a string, the name of the attribute being sought.
@param uri  a string, the namespace URI of the attribute being sought.
@return the index of an attribute with the given local name and
namespace URI, or C<-1> if no such attribute is present.
@see hasAttribute(const std::string name, const std::string uri) const
@see hasAttribute(const XMLTriple& triple) const


=item XMLAttributes::getIndex

Returns the index of the attribute defined by the given XMLTriple object.
@param triple an XMLTriple describing the attribute being sought.
@return the index of an attribute described by the given XMLTriple
object, or C<-1> if no such attribute is present.
@see hasAttribute(const std::string name, const std::string uri) const
@see hasAttribute(const XMLTriple& triple) const


=item XMLAttributes::getLength

Returns the number of attributes in this list of attributes.
@return the number of attributes contained in this XMLAttributes object.


=item XMLAttributes::getNumAttributes

Returns the number of attributes in this list of attributes.
This function is merely an alias of XMLAttributes::getLength()
introduced for consistency with other libXML classes.
@return the number of attributes contained in this XMLAttributes object.


=item XMLAttributes::getName

Returns the name of the <em>n</em>th attribute in this list of
attributes.

@param index an integer, the position of the attribute whose name
is being sought.
@return the local name of the <em>n</em>th attribute.
C<opydetails> doc_note_check_number_first
C<opydetails> doc_note_attributes_are_unordered
@see getLength()
@see hasAttribute(int index) const


=item XMLAttributes::getPrefix

Returns the namespace prefix of the <em>n</em>th attribute in this
attribute set.
@param index an integer, the position of the attribute whose namespace
prefix is being sought.
@return the XML namespace prefix of the <em>n</em>th attribute.
C<opydetails> doc_note_check_number_first
C<opydetails> doc_note_attributes_are_unordered
@see getLength()
@see hasAttribute(int index) const


=item XMLAttributes::getPrefixedName

Returns the prefix name of the <em>n</em>th attribute in this attribute
set.

@param index an integer, the position of the attribute whose prefixed
name is being sought.
@return the prefixed name of the <em>n</em>th attribute.
C<opydetails> doc_note_check_number_first
C<opydetails> doc_note_attributes_are_unordered
@see getLength()
@see hasAttribute(int index) const


=item XMLAttributes::getURI

Returns the XML namespace URI of the <em>n</em>th attribute in this
attribute set.
@param index an integer, the position of the attribute whose namespace
URI is being sought.
@return the XML namespace URI of the <em>n</em>th attribute.
C<opydetails> doc_note_check_number_first
C<opydetails> doc_note_attributes_are_unordered
@see getLength()
@see hasAttribute(int index) const


=item XMLAttributes::getValue

Returns the value of the <em>n</em>th attribute in this list of attributes.
@param index an integer, the position of the attribute whose value is
being sought.
@return the XML value of the <em>n</em>th attribute.
C<opydetails> doc_note_check_number_first
C<opydetails> doc_note_attributes_are_unordered
@see getLength()
@see hasAttribute(int index) const


=item XMLAttributes::getValue

Returns a named attribute's value.
@param name a string, the unprefixed name of the attribute whose value
is being sought.
@return The attribute value as a string.
@note If an attribute with the given local C<name> does not exist in
this XMLAttributes object, this method will return an empty string.
Callers can use
XMLAttributes::hasAttribute(const std::string name, const std::string uri) const
to test for an attribute's existence.  This method also does not check
the XML namespace of the named attribute.  Thus, if there are multiple
attributes with the same local C<name> but different namespaces, this
method will return the value of the first such attribute found.  Callers
should use the more specific methods
XMLAttributes::getIndex(const std::string& name, const std::string& uri) const
or XMLAttributes::getIndex(const XMLTriple& triple) const to find
attributes in particular namespaces.
@see hasAttribute(const std::string name, const std::string uri) const
@see hasAttribute(const XMLTriple& triple) const


=item XMLAttributes::getValue

Returns a named attribute's value.
@param name a string, the name of the attribute whose value is being sought.
@param uri  a string, the XML namespace URI of the attribute.
@return The attribute value as a string.
@note If an attribute with the given C<name> and namespace C<uri> does
not exist in this XMLAttributes object, this method will return an empty
string.  Callers can use
XMLAttributes::hasAttribute(const std::string name, const std::string uri) const
to test for an attribute's existence.
@see hasAttribute(const std::string name, const std::string uri) const
@see hasAttribute(const XMLTriple& triple) const


=item XMLAttributes::getValue

Return the value of an attribute described by a given XMLTriple object.
@param triple an XMLTriple describing the attribute whose value is being
sought.

@return The attribute value as a string.
@note If an attribute with the properties given by C<triple> does not
exist in this XMLAttributes object, this method will return an empty
string.  Callers can use
XMLAttributes::hasAttribute(const std::string name, const std::string uri) const
to test for an attribute's existence.
@see hasAttribute(const std::string name, const std::string uri) const
@see hasAttribute(const XMLTriple& triple) const


=item XMLAttributes::hasAttribute

Returns C<true> if an attribute exists at a given index.
@param index an integer, the position of the attribute to be tested.
@return C<true> if an attribute with the given index exists in this
XMLAttributes object, C<false> otherwise.
C<opydetails> doc_note_attributes_are_unordered


=item XMLAttributes::hasAttribute

Returns C<true> if an attribute with a given name and namespace URI
exists.

@param name a string, the unprefixed name of the attribute.
@param uri  a string, the XML namespace URI of the attribute.
@return C<true> if an attribute with the given local name and XML
namespace URI exists in this XMLAttributes object, C<false> otherwise.
@see add(const std::string& name, const std::string& value, const std::string& namespaceURI, const std::string& prefix)
@see add(const XMLTriple& triple, const std::string& value)


=item XMLAttributes::hasAttribute

Returns C<true> if an attribute with the given properties exists.
@param triple an XMLTriple describing the attribute to be tested.
@return C<true> if an attribute with the given XML triple exists in this
XMLAttributes object, C<false> otherwise.
@see add(const std::string& name, const std::string& value, const std::string& namespaceURI, const std::string& prefix)
@see add(const XMLTriple& triple, const std::string& value)


=item XMLAttributes::isEmpty

Returns C<true> if this list of attributes is empty.
@return C<true> if this XMLAttributes object is empty, C<false>
otherwise.


=item XMLAttributes::readInto

Interprets an attribute as a Boolean value.
This method reads the value associated with the attribute C<name> in
this XMLAttributes object and attempts to interpret it as a Boolean.  If
successful, this method stores the value into the variable passed in as
C<value>.  If no attribute named C<name> can be found in this
XMLAttributes object or the value of the attribute could not be
interpreted as a Boolean, C<value> is left unmodified.
According to the specification of <a target="_blank"
href="http://www.w3.org/TR/xmlschema-2/#boolean">XML Schema</a>, the
valid Boolean values are: C<"true">, C<"false">,
C<"1">, and C<"0">, read in a case-insensitive
manner.

Errors in attempting to interpret the format are logged to C<log>, if an
error log object is supplied.  If the parameter C<required> is C<true>,
then if no attribute named C<name> exists, an error will be logged to @p
log with a description that explains the error is due to a missing
required attribute.  If the parameter C<required> is C<false> (the
default), then if no attribute C<name> exists, no error will be logged
and this method will simply return C<false> to indicate an unsuccessful
assignment.  Finally, if C<log> is provided, C<name> exists, but the
value associated with C<name> could not be parsed as a Boolean, then the
error logged to C<log> indicates that a value type mismatch occurred.
Values are read using the "C" locale.
@param name a string, the name of the attribute.
@param value a Boolean, the return parameter into which the value should
be assigned.
@param log an XMLErrorLog object, an optional error log for reporting
problems.

@param required a Boolean flag, to indicate whether it should be
considered an error if the attribute C<name> cannot be found in this
XMLAttributes object.
@param line an unsigned int, the line number at which the error
occurred.  Callers can supply this value if it makes sense for their
applications.

@param column an unsigned int, the column number at which the error
occurred.  Callers can supply this value if it makes sense for their
applications.

@returns C<true> if the attribute was successfully read into value, @c
false otherwise.
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item XMLAttributes::readInto

Interprets an attribute as a Boolean value.
This method reads the value associated with the attribute described by
C<triple> in this XMLAttributes object and attempts to interpret it as a
Boolean.  If successful, this method stores the value into the variable
passed in as C<value>.  If no attribute named C<name> can be found in
this XMLAttributes object or the value of the attribute could not be
interpreted as a Boolean, C<value> is left unmodified.
According to the specification of <a target="_blank"
href="http://www.w3.org/TR/xmlschema-2/#boolean">XML Schema</a>, the
valid Boolean values are: C<"true">, C<"false">,
C<"1">, and C<"0">, read in a case-insensitive
manner.

Errors in attempting to interpret the format are logged to C<log>, if an
error log object is supplied.  If the parameter C<required> is C<true>,
then if no attribute named C<name> exists, an error will be logged to @p
log with a description that explains the error is due to a missing
required attribute.  If the parameter C<required> is C<false> (the
default), then if no attribute C<name> exists, no error will be logged
and this method will simply return C<false> to indicate an unsuccessful
assignment.  Finally, if C<log> is provided, C<name> exists, but the
value associated with C<name> could not be parsed as a Boolean, then the
error logged to C<log> indicates that a value type mismatch occurred.
Values are read using the "C" locale.
@param triple an XMLTriple object describing the attribute to read.
@param value a Boolean, the return parameter into which the value should
be assigned.
@param log an XMLErrorLog object, an optional error log for reporting
problems.

@param required a Boolean flag, to indicate whether it should be
considered an error if the attribute C<name> cannot be found in this
XMLAttributes object.
@param line an unsigned int, the line number at which the error
occurred.  Callers can supply this value if it makes sense for their
applications.

@param column an unsigned int, the column number at which the error
occurred.  Callers can supply this value if it makes sense for their
applications.

@returns C<true> if the attribute was successfully read into value, @c
false otherwise.
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item XMLAttributes::readInto

Interprets an attribute as a C<double> value.
This method reads the value associated with the attribute C<name> in
this XMLAttributes object and attempts to interpret it as a
C<double>.  If successful, this method stores the value into
the variable passed in as C<value>.  If no attribute named C<name> can
be found in this XMLAttributes object or the value of the attribute
could not be interpreted as a C<double>, C<value> is left
unmodified.

According to the specification of <a target="_blank"
href="http://www.w3.org/TR/xmlschema-2/#double">XML Schema</a>, valid
doubles are the same as valid doubles for the C language and in
addition, the special values C<"INF">, C<"-INF">,
and C<"NaN">, read in a case-insensitive manner.
Errors in attempting to interpret the format are logged to C<log>, if an
error log object is supplied.  If the parameter C<required> is C<true>,
then if no attribute named C<name> exists, an error will be logged to @p
log with a description that explains the error is due to a missing
required attribute.  If the parameter C<required> is C<false> (the
default), then if no attribute C<name> exists, no error will be logged
and this method will simply return C<false> to indicate an unsuccessful
assignment.  Finally, if C<log> is provided, C<name> exists, but the
value associated with C<name> could not be parsed as a
C<double>, then the error logged to C<log> indicates that a
value type mismatch occurred.
Values are read using the "C" locale.
@param name a string, the name of the attribute.
@param value a C<double>, the return parameter into which the
value should be assigned.
@param log an XMLErrorLog object, an optional error log for reporting
problems.

@param required a Boolean flag, to indicate whether it should be
considered an error if the attribute C<name> cannot be found in this
XMLAttributes object.
@param line an unsigned int, the line number at which the error
occurred.  Callers can supply this value if it makes sense for their
applications.

@param column an unsigned int, the column number at which the error
occurred.  Callers can supply this value if it makes sense for their
applications.

@returns C<true> if the attribute was successfully read into value, @c
false otherwise.
C<opydetails> doc_note_read_methods_and_namespaces 
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item XMLAttributes::readInto

Interprets an attribute as a C<double> value.
This method reads the value associated with the attribute described by
C<triple> in this XMLAttributes object and attempts to interpret it as a
C<double>.  If successful, this method stores the value into
the variable passed in as C<value>.  If no attribute named C<name> can
be found in this XMLAttributes object or the value of the attribute
could not be interpreted as a C<double>, C<value> is left
unmodified.

According to the specification of <a target="_blank"
href="http://www.w3.org/TR/xmlschema-2/#double">XML Schema</a>, valid
doubles are the same as valid doubles for the C language and in
addition, the special values C<"INF">, C<"-INF">,
and C<"NaN">, read in a case-insensitive manner.
Errors in attempting to interpret the format are logged to C<log>, if an
error log object is supplied.  If the parameter C<required> is C<true>,
then if no attribute named C<name> exists, an error will be logged to @p
log with a description that explains the error is due to a missing
required attribute.  If the parameter C<required> is C<false> (the
default), then if no attribute C<name> exists, no error will be logged
and this method will simply return C<false> to indicate an unsuccessful
assignment.  Finally, if C<log> is provided, C<name> exists, but the
value associated with C<name> could not be parsed as a
C<double>, then the error logged to C<log> indicates that a
value type mismatch occurred.
Values are read using the "C" locale.
@param triple an XMLTriple object describing the attribute to read.
@param value a C<double>, the return parameter into which the
value should be assigned.
@param log an XMLErrorLog object, an optional error log for reporting
problems.

@param required a Boolean flag, to indicate whether it should be
considered an error if the attribute C<name> cannot be found in this
XMLAttributes object.
@param line an unsigned int, the line number at which the error
occurred.  Callers can supply this value if it makes sense for their
applications.

@param column an unsigned int, the column number at which the error
occurred.  Callers can supply this value if it makes sense for their
applications.

@returns C<true> if the attribute was successfully read into value, @c
false otherwise.
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item XMLAttributes::readInto

Interprets an attribute as a C<long> integer value.
This method reads the value associated with the attribute C<name> in
this XMLAttributes object and attempts to interpret it as a
C<long>.  If successful, this method stores the value into the
variable passed in as C<value>.  If no attribute named C<name> can be
found in this XMLAttributes object or the value of the attribute could
not be interpreted as a C<long>, C<value> is left unmodified.
According to the specification of <a target="_blank"
href="http://www.w3.org/TR/xmlschema-2/#integer">XML Schema</a>, valid
C<long>-type values are zero, all positive whole numbers and
all negative whole numbers.  This is unfortunately a larger space of
values than can be represented in a long integer, so libSBML limits the
possible values to those that can be stored in a C<long> data
type.

Errors in attempting to interpret the format are logged to C<log>, if an
error log object is supplied.  If the parameter C<required> is C<true>,
then if no attribute named C<name> exists, an error will be logged to @p
log with a description that explains the error is due to a missing
required attribute.  If the parameter C<required> is C<false> (the
default), then if no attribute C<name> exists, no error will be logged
and this method will simply return C<false> to indicate an unsuccessful
assignment.  Finally, if C<log> is provided, C<name> exists, but the
value associated with C<name> could not be parsed as a
C<long>, then the error logged to C<log> indicates that a
value type mismatch occurred.
Values are read using the "C" locale.
@param name a string, the name of the attribute.
@param value a C<long>, the return parameter into which the
value should be assigned.
@param log an XMLErrorLog object, an optional error log for reporting
problems.

@param required a Boolean flag, to indicate whether it should be
considered an error if the attribute C<name> cannot be found in this
XMLAttributes object.
@param line an unsigned int, the line number at which the error
occurred.  Callers can supply this value if it makes sense for their
applications.

@param column an unsigned int, the column number at which the error
occurred.  Callers can supply this value if it makes sense for their
applications.

@returns C<true> if the attribute was successfully read into value, @c
false otherwise.
C<opydetails> doc_note_read_methods_and_namespaces 
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item XMLAttributes::readInto

Interprets an attribute as a C<long> integer value.
This method reads the value associated with the attribute described by
C<triple> in this XMLAttributes object and attempts to interpret it as a
C<long>.  If successful, this method stores the value into the
variable passed in as C<value>.  If no attribute named C<name> can be
found in this XMLAttributes object or the value of the attribute could
not be interpreted as a C<long>, C<value> is left unmodified.
According to the specification of <a target="_blank"
href="http://www.w3.org/TR/xmlschema-2/#integer">XML Schema</a>, valid
C<long>-type values are zero, all positive whole numbers and
all negative whole numbers.  This is unfortunately a larger space of
values than can be represented in a long, so libSBML limits the possible
values to those that can be stored in a C<long> data type.
Errors in attempting to interpret the format are logged to C<log>, if an
error log object is supplied.  If the parameter C<required> is C<true>,
then if no attribute named C<name> exists, an error will be logged to @p
log with a description that explains the error is due to a missing
required attribute.  If the parameter C<required> is C<false> (the
default), then if no attribute C<name> exists, no error will be logged
and this method will simply return C<false> to indicate an unsuccessful
assignment.  Finally, if C<log> is provided, C<name> exists, but the
value associated with C<name> could not be parsed as a
C<long>, then the error logged to C<log> indicates that a
value type mismatch occurred.
Values are read using the "C" locale.
@param triple an XMLTriple object describing the attribute
@param value a C<long>, the return parameter into which the
value should be assigned.
@param log an XMLErrorLog object, an optional error log for reporting
problems.

@param required a Boolean flag, to indicate whether it should be
considered an error if the attribute C<name> cannot be found in this
XMLAttributes object.
@param line an unsigned int, the line number at which the error
occurred.  Callers can supply this value if it makes sense for their
applications.

@param column an unsigned int, the column number at which the error
occurred.  Callers can supply this value if it makes sense for their
applications.

@returns C<true> if the attribute was successfully read into value, @c
false otherwise.
C<opydetails> doc_note_read_methods_and_namespaces 
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item XMLAttributes::readInto

Interprets an attribute as a C<int> value.
This method reads the value associated with the attribute C<name> in
this XMLAttributes object and attempts to interpret it as an
C<int>.  If successful, this method stores the value into the
variable passed in as C<value>.  If no attribute named C<name> can be
found in this XMLAttributes object or the value of the attribute could
not be interpreted as an C<int>, C<value> is left unmodified.
According to the specification of <a target="_blank"
href="http://www.w3.org/TR/xmlschema-2/#integer">XML Schema</a>, valid
C<long>-type values are zero, all positive whole numbers and
all negative whole numbers.  The present method is designed to interpret
numbers as signed C<int> values and cannot represent larger
values.  Note that variant methods on XMLAttributes are available to
work with C<unsigned int> type and C<long> type
values; users may wish to investigate those methods if they need to
handle larger integer values.
Errors in attempting to interpret the format are logged to C<log>, if an
error log object is supplied.  If the parameter C<required> is C<true>,
then if no attribute named C<name> exists, an error will be logged to @p
log with a description that explains the error is due to a missing
required attribute.  If the parameter C<required> is C<false> (the
default), then if no attribute C<name> exists, no error will be logged
and this method will simply return C<false> to indicate an unsuccessful
assignment.  Finally, if C<log> is provided, C<name> exists, but the
value associated with C<name> could not be parsed as a
C<long>, then the error logged to C<log> indicates that a
value type mismatch occurred.
Values are read using the "C" locale.
@param name a string, the name of the attribute.
@param value an C<int>, the return parameter into which the
value should be assigned.
@param log an XMLErrorLog object, an optional error log for reporting
problems.

@param required a Boolean flag, to indicate whether it should be
considered an error if the attribute C<name> cannot be found in this
XMLAttributes object.
@param line an unsigned int, the line number at which the error
occurred.  Callers can supply this value if it makes sense for their
applications.

@param column an unsigned int, the column number at which the error
occurred.  Callers can supply this value if it makes sense for their
applications.

@returns C<true> if the attribute was successfully read into value, @c
false otherwise.
C<opydetails> doc_note_read_methods_and_namespaces 
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item XMLAttributes::readInto

Interprets an attribute as a C<int> value.
This method reads the value associated with the attribute described by
C<triple> in this XMLAttributes object and attempts to interpret it as an
C<int>.  If successful, this method stores the value into the
variable passed in as C<value>.  If no attribute named C<name> can be
found in this XMLAttributes object or the value of the attribute could
not be interpreted as an C<int>, C<value> is left unmodified.
According to the specification of <a target="_blank"
href="http://www.w3.org/TR/xmlschema-2/#integer">XML Schema</a>, valid
C<long>-type values are zero, all positive whole numbers and
all negative whole numbers.  The present method is designed to interpret
numbers as signed C<int> values and cannot represent larger
values.  Note that variant methods on XMLAttributes are available to
work with C<unsigned int> type and C<long> type
values; users may wish to investigate those methods if they need to
handle larger integer values.
Errors in attempting to interpret the format are logged to C<log>, if an
error log object is supplied.  If the parameter C<required> is C<true>,
then if no attribute named C<name> exists, an error will be logged to @p
log with a description that explains the error is due to a missing
required attribute.  If the parameter C<required> is C<false> (the
default), then if no attribute C<name> exists, no error will be logged
and this method will simply return C<false> to indicate an unsuccessful
assignment.  Finally, if C<log> is provided, C<name> exists, but the
value associated with C<name> could not be parsed as a
C<long>, then the error logged to C<log> indicates that a
value type mismatch occurred.
Values are read using the "C" locale.
@param triple an XMLTriple object describing the attribute
@param value an C<int>, the return parameter into which the
value should be assigned.
@param log an XMLErrorLog object, an optional error log for reporting
problems.

@param required a Boolean flag, to indicate whether it should be
considered an error if the attribute C<name> cannot be found in this
XMLAttributes object.
@param line an unsigned int, the line number at which the error
occurred.  Callers can supply this value if it makes sense for their
applications.

@param column an unsigned int, the column number at which the error
occurred.  Callers can supply this value if it makes sense for their
applications.

@returns C<true> if the attribute was successfully read into value, @c
false otherwise.
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item XMLAttributes::readInto

Interprets an attribute as a C<unsigned int> value.
This method reads the value associated with the attribute C<name> in
this XMLAttributes object and attempts to interpret it as an
C<unsigned int>.  If successful, this method stores the value
into the variable passed in as C<value>.  If no attribute named C<name>
can be found in this XMLAttributes object or the value of the attribute
could not be interpreted as an C<unsigned int>, C<value> is
left unmodified.
According to the specification of <a target="_blank"
href="http://www.w3.org/TR/xmlschema-2/#integer">XML Schema</a>, valid
C<long>-type values are zero, all positive whole numbers and
all negative whole numbers.  The present method is designed to interpret
numbers as C<unsigned int> and cannot represent larger values.
Note that a variant method on XMLAttributes is available to work with
C<long> type values; users may wish to investigate that method
if they need to handle large integer values.
Errors in attempting to interpret the format are logged to C<log>, if an
error log object is supplied.  If the parameter C<required> is C<true>,
then if no attribute named C<name> exists, an error will be logged to @p
log with a description that explains the error is due to a missing
required attribute.  If the parameter C<required> is C<false> (the
default), then if no attribute C<name> exists, no error will be logged
and this method will simply return C<false> to indicate an unsuccessful
assignment.  Finally, if C<log> is provided, C<name> exists, but the
value associated with C<name> could not be parsed as a
C<long>, then the error logged to C<log> indicates that a
value type mismatch occurred.
Values are read using the "C" locale.
@param name a string, the name of the attribute.
@param value an C<int>, the return parameter into which the
value should be assigned.
@param log an XMLErrorLog object, an optional error log for reporting
problems.

@param required a Boolean flag, to indicate whether it should be
considered an error if the attribute C<name> cannot be found in this
XMLAttributes object.
@param line an unsigned int, the line number at which the error
occurred.  Callers can supply this value if it makes sense for their
applications.

@param column an unsigned int, the column number at which the error
occurred.  Callers can supply this value if it makes sense for their
applications.

@returns C<true> if the attribute was successfully read into value, @c
false otherwise.
C<opydetails> doc_note_read_methods_and_namespaces 
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item XMLAttributes::readInto

Interprets an attribute as a C<unsigned int> value.
This method reads the value associated with the attribute described by
C<triple> in this XMLAttributes object and attempts to interpret it as an
C<unsigned int>.  If successful, this method stores the value
into the variable passed in as C<value>.  If no attribute named C<name>
can be found in this XMLAttributes object or the value of the attribute
could not be interpreted as an C<unsigned int>, C<value> is
left unmodified.
According to the specification of <a target="_blank"
href="http://www.w3.org/TR/xmlschema-2/#integer">XML Schema</a>, valid
C<long>-type values are zero, all positive whole numbers and
all negative whole numbers.  The present method is designed to interpret
numbers as C<unsigned int> and cannot represent larger values.
Note that a variant method on XMLAttributes is available to work with
C<long> type values; users may wish to investigate that method
if they need to handle large integer values.
Errors in attempting to interpret the format are logged to C<log>, if an
error log object is supplied.  If the parameter C<required> is C<true>,
then if no attribute named C<name> exists, an error will be logged to @p
log with a description that explains the error is due to a missing
required attribute.  If the parameter C<required> is C<false> (the
default), then if no attribute C<name> exists, no error will be logged
and this method will simply return C<false> to indicate an unsuccessful
assignment.  Finally, if C<log> is provided, C<name> exists, but the
value associated with C<name> could not be parsed as a
C<long>, then the error logged to C<log> indicates that a
value type mismatch occurred.
Values are read using the "C" locale.
@param triple an XMLTriple object describing the attribute
@param value an C<int>, the return parameter into which the
value should be assigned.
@param log an XMLErrorLog object, an optional error log for reporting
problems.

@param required a Boolean flag, to indicate whether it should be
considered an error if the attribute C<name> cannot be found in this
XMLAttributes object.
@param line an unsigned int, the line number at which the error
occurred.  Callers can supply this value if it makes sense for their
applications.

@param column an unsigned int, the column number at which the error
occurred.  Callers can supply this value if it makes sense for their
applications.

@returns C<true> if the attribute was successfully read into value, @c
false otherwise.
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item XMLAttributes::readInto

Interprets an attribute as a string value.
This method reads the value associated with the attribute C<name> in
this XMLAttributes object and stores the value into the variable passed
in as C<value>.  If no attribute named C<name> can be found in this
XMLAttributes object, C<value> is left unmodified.
Unlike the other variant methods on XMLAttributes, there are no format
errors possible when reading strings, since XML attribute values I<are>
strings.  However, the case of a missing attribute can still occur.
Errors will be logged to C<log>, if an error log object is supplied.  If
the parameter C<required> is C<true>, then if no attribute named C<name>
exists, an error will be logged to C<log> with a description that
explains the error is due to a missing required attribute.  If the
parameter C<required> is C<false> (the default), then if no attribute @p
name exists, no error will be logged and this method will simply return
C<false> to indicate an unsuccessful assignment.
Values are read using the "C" locale.
@param name a string, the name of the attribute.
@param value a string, the return parameter into which the value should
be assigned.
@param log an XMLErrorLog object, an optional error log for reporting
problems.

@param required a Boolean flag, to indicate whether it should be
considered an error if the attribute C<name> cannot be found in this
XMLAttributes object.
@param line an unsigned int, the line number at which the error
occurred.  Callers can supply this value if it makes sense for their
applications.

@param column an unsigned int, the column number at which the error
occurred.  Callers can supply this value if it makes sense for their
applications.

@returns C<true> if the attribute was successfully read into value, @c
false otherwise.
C<opydetails> doc_note_read_methods_and_namespaces 
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item XMLAttributes::readInto

Interprets an attribute as a string value.
This method reads the value associated with the attribute described by
C<triple> in this XMLAttributes object and stores the value into the
variable passed in as C<value>.  If no attribute named C<name> can be
found in this XMLAttributes object, C<value> is left unmodified.
Unlike the other variant methods on XMLAttributes, there are no format
errors possible when reading strings, since XML attribute values I<are>
strings.  However, the case of a missing attribute can still occur.
Errors will be logged to C<log>, if an error log object is supplied.  If
the parameter C<required> is C<true>, then if no attribute named C<name>
exists, an error will be logged to C<log> with a description that
explains the error is due to a missing required attribute.  If the
parameter C<required> is C<false> (the default), then if no attribute @p
name exists, no error will be logged and this method will simply return
C<false> to indicate an unsuccessful assignment.
Values are read using the "C" locale.
@param triple an XMLTriple object describing the attribute
@param value a string, the return parameter into which the value should
be assigned.
@param log an XMLErrorLog object, an optional error log for reporting
problems.

@param required a Boolean flag, to indicate whether it should be
considered an error if the attribute C<name> cannot be found in this
XMLAttributes object.
@param line an unsigned int, the line number at which the error
occurred.  Callers can supply this value if it makes sense for their
applications.

@param column an unsigned int, the column number at which the error
occurred.  Callers can supply this value if it makes sense for their
applications.

@returns C<true> if the attribute was successfully read into value, @c
false otherwise.
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item XMLAttributes::write

@internal


=item XMLAttributes::setErrorLog

@internal


=item XMLAttributes::attributeTypeError

@internal


=item XMLAttributes::attributeRequiredError

@internal


=item XMLAttributes::readInto

@internal


=item XMLAttributes::readInto

@internal


=item XMLAttributes::readInto

@internal


=item XMLAttributes::readInto

@internal


=item XMLAttributes::readInto

@internal


=item XMLAttributes::readInto

@internal


=back

=head2 XMLConstructorException

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html Exceptions thrown by some libSBML constructors.
@htmlinclude not-sbml-warning.html
In some situations, constructors for SBML objects may need to indicate
to callers that the creation of the object failed.  The failure may be
for different reasons, such as an attempt to use invalid parameters or a
system condition such as a memory error.  To communicate this to
callers, those classes will throw an XMLConstructorException.  @if cpp
Callers can use the standard C++ C<std::exception> method
C<what()> to extract the diagnostic message stored with the
exception.@endif@~
<p>
In languages that don't have an exception mechanism (e.g., C), the
constructors generally try to return an error code instead of throwing
an exception.
@see SBMLConstructorException

=over


=item XMLConstructorException::XMLConstructorException

@internal


=back

=head2 XMLNamespaces

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html An XML Namespace.
@htmlinclude not-sbml-warning.html
This class serves to organize functionality for tracking XML namespaces
in a document or data stream.  The namespace declarations are stored as
a list of pairs of XML namespace URIs and prefix strings.  These
correspond to the parts of a namespace declaration on an XML element.
For example, in the following XML fragment,
@verbatim
<annotation>
<mysim:nodecolors xmlns:mysim="urn:lsid:mysim.org"
mysim:bgcolor="green" mysim:fgcolor="white"/>
</annotation>
@endverbatim
there is one namespace declaration.  Its URI is
C<urn:lsid:mysim.org> and its prefix is C<mysim>.
This pair could be stored as one item in an XMLNamespaces list.
XMLNamespaces provides various methods for manipulating the list of
prefix-URI pairs.  Individual namespaces stored in a given XMLNamespace
object instance can be retrieved based on their index using
XMLNamespaces::getPrefix(int index), or by their characteristics such as
their URI or position in the list.

=over


=item XMLNamespaces::XMLNamespaces

Creates a new empty list of XML namespace declarations.


=item XMLNamespaces::XMLNamespaces

Copy constructor; creates a copy of this XMLNamespaces list.
@param orig the XMLNamespaces object to copy.


=item XMLNamespaces::clone

Creates and returns a deep copy of this XMLNamespaces object.
@return the (deep) copy of this XMLNamespaces object.


=item XMLNamespaces::add

Appends an XML namespace prefix and URI pair to this list of namespace
declarations.

An XMLNamespaces object stores a list of pairs of namespaces and their
prefixes.  If there is an XML namespace with the given C<uri> prefix
in this list, then its corresponding URI will be overwritten by the
new C<uri> unless the uri represents the core sbml namespace.
Calling programs could use one of the other XMLNamespaces
methods, such as
XMLNamespaces::hasPrefix(@if java String@endif) and 
XMLNamespaces::hasURI(@if java String@endif) to
inquire whether a given prefix and/or URI
is already present in this XMLNamespaces object.
If the C<uri> represents the sbml namespaces then it will not be
overwritten, as this has potentially serious consequences. If it
is necessary to replace the sbml namespace the namespace should be removed
prior to adding the new namespace.
@param uri a string, the uri for the namespace.
@param prefix a string, the prefix for the namespace.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item XMLNamespaces::remove

Removes an XML Namespace stored in the given position of this list.
@param index an integer, position of the namespace to remove.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink


=item XMLNamespaces::remove

Removes an XML Namespace with the given prefix.
@param prefix a string, prefix of the required namespace.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink
@see remove(int index)


=item XMLNamespaces::clear

Clears (deletes) all XML namespace declarations in this XMLNamespaces
object.

C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@see remove(int index)


=item XMLNamespaces::getIndex

Look up the index of an XML namespace declaration by URI.
An XMLNamespaces object stores a list of pairs of namespaces and their
prefixes.  If this XMLNamespaces object contains a pair with the given
URI C<uri>, this method returns its index in the list.
@param uri a string, the URI of the sought-after namespace.
@return the index of the given declaration, or C<-1> if not
present.


=item XMLNamespaces::containsUri

Tests whether the given uri is contained in this set of namespaces.


=item XMLNamespaces::getIndexByPrefix

Look up the index of an XML namespace declaration by prefix.
An XMLNamespaces object stores a list of pairs of namespaces and their
prefixes.  If this XMLNamespaces object contains a pair with the given
prefix C<prefix>, this method returns its index in the list.
@param prefix a string, the prefix string of the sought-after
namespace.

@return the index of the given declaration, or C<-1> if not
present.


=item XMLNamespaces::getLength

Returns the total number of URI-and-prefix pairs stored in this
particular XMLNamespaces instance.
@return the number of namespaces in this list.


=item XMLNamespaces::getNumNamespaces

Returns the total number of URI-and-prefix pairs stored in this
particular XMLNamespaces instance.
@return the number of namespaces in this list.
This function is an alias for getLength introduced for consistency
with other XML classes.


=item XMLNamespaces::getPrefix

Look up the prefix of an XML namespace declaration by its position.
An XMLNamespaces object stores a list of pairs of namespaces and their
prefixes.  This method returns the prefix of the C<n>th
element in that list (if it exists).  Callers should use
XMLAttributes::getLength() first to find out how many namespaces are
stored in the list.
@param index an integer, position of the sought-after prefix.
@return the prefix of an XML namespace declaration in this list (by
position), or an empty string if the C<index> is out of range.
@see getLength()


=item XMLNamespaces::getPrefix

Look up the prefix of an XML namespace declaration by its URI.
An XMLNamespaces object stores a list of pairs of namespaces and their
prefixes.  This method returns the prefix for a pair that has the
given C<uri>.
@param uri a string, the URI of the prefix being sought.
@return the prefix of an XML namespace declaration given its URI, or
an empty string if no such C<uri> exists in this XMLNamespaces object.


=item XMLNamespaces::getURI

Look up the URI of an XML namespace declaration by its position.
An XMLNamespaces object stores a list of pairs of namespaces and their
prefixes.  This method returns the URI of the C<n>th element
in that list (if it exists).  Callers should use
XMLAttributes::getLength() first to find out how many namespaces are
stored in the list.
@param index an integer, position of the required URI.
@return the URI of an XML namespace declaration in this list (by
position), or an empty string if the C<index> is out of range.
@see getLength()


=item XMLNamespaces::getURI

Look up the URI of an XML namespace declaration by its prefix.
An XMLNamespaces object stores a list of pairs of namespaces and their
prefixes.  This method returns the namespace URI for a pair that has
the given C<prefix>.
@param prefix a string, the prefix of the required URI.
@return the URI of an XML namespace declaration having the given @p
prefix, or an empty string if no such prefix-and-URI pair exists
in this XMLNamespaces object.
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~
@see getURI()


=item XMLNamespaces::isEmpty

Predicate returning C<true> or C<false> depending on whether this
XMLNamespaces list is empty.
@return C<true> if this XMLNamespaces list is empty, C<false> otherwise.


=item XMLNamespaces::hasURI

Predicate returning C<true> or C<false> depending on whether an XML
Namespace with the given URI is contained in this XMLNamespaces list.
@param uri a string, the uri for the namespace.
@return C<true> if an XML Namespace with the given URI is contained in
this XMLNamespaces list, C<false> otherwise.


=item XMLNamespaces::hasPrefix

Predicate returning C<true> or C<false> depending on whether an XML
Namespace with the given prefix is contained in this XMLNamespaces
list.

@param prefix a string, the prefix for the namespace.
@return C<true> if an XML Namespace with the given URI is contained in
this XMLNamespaces list, C<false> otherwise.


=item XMLNamespaces::hasNS

Predicate returning C<true> or C<false> depending on whether an XML
Namespace with the given URI and prefix pair is contained in this
XMLNamespaces list.
@param uri a string, the URI for the namespace.
@param prefix a string, the prefix for the namespace.
@return C<true> if an XML Namespace with the given uri/prefix pair is
contained in this XMLNamespaces list, C<false> otherwise.


=item XMLNamespaces::removeDefault

@internal


=item XMLNamespaces::containIdenticalSetNS

@internal


=back

=head2 XMLToken

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html A token in an XML stream.
@htmlinclude not-sbml-warning.html
The libSBML XML parser interface can read an XML file or data stream and
convert the contents into tokens.  The tokens represent items in the XML
stream, either XML elements (start or end tags) or text that appears as
content inside an element.  The XMLToken class is libSBML's low-level
representation of these entities.
Each XMLToken has the following information associated with it:
<ol>
\n=item\n\n<em>Qualified name</em>: every XML element or XML attribute has a
name (e.g., for the element C<&lt;mytag&gt;>, the name is
C<"mytag">), but this name may be qualified with a namespace
(e.g., it may appear as C<&lt;someNamespace:mytag&gt;> in the
input).  An XMLToken stores the name of a token, along with any namespace
qualification present, through the use of an XMLTriple object.  This
object stores the bare name of the element, its XML namespace prefix (if
any), and the XML namespace with which that prefix is associated.
\n=item\n\nI<Namespaces>: An XML token can have one or more XML namespaces
associated with it.  These namespaces may be specified explicitly on the
element or inherited from parent elements.  In libSBML, a list of
namespaces is stored in an XMLNamespaces object.  An XMLToken possesses a
field for storing an XMLNamespaces object.
\n=item\n\nI<Attributes>: XML elements can have attributes associated with
them, and these attributes can have values assigned to them.  The set of
attribute-value pairs is stored in an XMLAttributes object stored in an
XMLToken object.  (Note: only elements can have attributes&mdash;text
blocks cannot have them in XML.)
\n=item\n\nI<Line> number: the line number in the input where the token appears.
\n=item\n\nI<Column> number: the column number in the input where the token appears.
</ol>

The XMLToken class serves as base class for XMLNode.  XML lends itself to
a tree-structured representation, and in libSBML, the nodes in an XML
document tree are XMLNode objects.  Most higher-level libSBML classes and
methods that offer XML-level functionality (such as the methods on SBase
for interacting with annotations) work with XMLNode objects rather than
XMLToken objects directly.
@see XMLNode
@see XMLTriple
@see XMLAttributes
@see XMLNamespaces

=over


=item XMLToken::XMLToken

Creates a new empty XMLToken object.


=item XMLToken::XMLToken

Creates an XML start element with attributes and namespace declarations.
@param triple an XMLTriple object describing the start tag.
@param attributes XMLAttributes, the attributes to set on the element to
be created.
@param namespaces XMLNamespaces, the namespaces to set on the element to
be created.
@param line an unsigned int, the line number to associate with the
token (default = 0).
@param column an unsigned int, the column number to associate with the
token (default = 0).
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item XMLToken::XMLToken

Creates an XML start element with attributes.
@param triple an XMLTriple object describing the start tag.
@param attributes XMLAttributes, the attributes to set on the element to
be created.
@param line an unsigned int, the line number to associate with the
token (default = 0).
@param column an unsigned int, the column number to associate with the
token (default = 0).
The XML namespace component of this XMLToken object will be left empty.
See the other variants of the XMLToken constructors for versions that
take namespace arguments.
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item XMLToken::XMLToken

Creates an XML end element.
@param triple an XMLTriple object describing the end tag.
@param line an unsigned int, the line number to associate with the
token (default = 0).
@param column an unsigned int, the column number to associate with the
token (default = 0).
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item XMLToken::XMLToken

Creates a text object.
@param chars a string, the text to be added to the XMLToken object.
@param line an unsigned int, the line number to associate with the
token (default = 0).
@param column an unsigned int, the column number to associate with the
token (default = 0).
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item XMLToken::XMLToken

Copy constructor; creates a copy of this XMLToken object.
@param orig the XMLToken object to copy.


=item XMLToken::clone

Creates and returns a deep copy of this XMLToken object.
@return the (deep) copy of this XMLToken object.


=item XMLToken::getAttributes

Returns the attributes of the XML element represented by this token.
@return the attributes of this XML element, stored in an XMLAttributes
object.


=item XMLToken::setAttributes

Sets the attributes on the XML element represented by this token.
C<opydetails> doc_only_for_start_elements
@param attributes an XMLAttributes object to be assigned to this
XMLToken object, thereby setting the XML attributes associated with this
token.

C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@note This function replaces any existing XMLAttributes object
on this XMLToken object with the one given by C<attributes>.


=item XMLToken::addAttr

Adds an attribute to the XML element represented by this token.
C<opydetails> doc_only_for_start_elements
@param name a string, the so-called "local part" of the attribute name;
that is, the attribute name without any namespace qualifier or prefix.
@param value a string, the value assigned to the attribute.
@param namespaceURI a string, the XML namespace URI of the attribute.
@param prefix a string, the prefix for the XML namespace.
Recall that in XML, the complete form of an attribute on an XML element
is the following:
<center>
C<prefix:name="value">
</center>
The C<name> part is the name of the attribute, the
C<"value"> part is the value assigned to the attribute (and
it is always a quoted string), and the C<prefix> part is
an optional XML namespace prefix.  Internally in libSBML, this data
is stored in an XMLAttributes object associated with this XMLToken.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink
C<opydetails> doc_note_overwrites_existing_attribute
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item XMLToken::addAttr

Adds an attribute to the XML element represented by this token.
C<opydetails> doc_only_for_start_elements
@param triple an XMLTriple object defining the attribute, its value,
and optionally its XML namespace (if any is provided).
@param value a string, the value assigned to the attribute.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink
C<opydetails> doc_note_overwrites_existing_attribute


=item XMLToken::removeAttr

Removes the <em>n</em>th attribute from the XML element represented by
this token.
C<opydetails> doc_only_for_start_elements
@param n an integer the index of the resource to be deleted.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink
@li @link OperationReturnValues_t#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink
The value @link   OperationReturnValues_t#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink is returned if there is no attribute on this
element at the given index C<n>.
@see getAttrIndex(const XMLTriple& triple) const
@see getAttrIndex(const std::string& name, const std::string& uri) const
@see getAttributesLength()


=item XMLToken::removeAttr

Removes an attribute from the XML element represented by this token.
C<opydetails> doc_only_for_start_elements
@param name   a string, the name of the attribute to be removed.
@param uri    a string, the XML namespace URI of the attribute to be removed.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink
@li @link OperationReturnValues_t#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink
The value @link   OperationReturnValues_t#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink is returned if there is no attribute on this
element with the given C<name> (and C<uri> if specified).
@see hasAttr(const std::string name, const std::string uri) const


=item XMLToken::removeAttr

Removes an attribute from the XML element represented by this token.
C<opydetails> doc_only_for_start_elements
@param triple an XMLTriple describing the attribute to be removed.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink
@li @link OperationReturnValues_t#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink
The value @link   OperationReturnValues_t#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink is returned if there is no attribute on this
element matching the properties of the given C<triple>.
@see hasAttr(const XMLTriple& triple) const


=item XMLToken::clearAttributes

Removes all attributes of this XMLToken object.
C<opydetails> doc_only_for_start_elements
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink


=item XMLToken::getAttrIndex

Returns the index of the attribute with the given name and namespace
URI.

@param name a string, the name of the attribute.
@param uri  a string, the namespace URI of the attribute.
@return the index of an attribute with the given local name and
namespace URI, or C<-1> if it is not present on this token.
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item XMLToken::getAttrIndex

Returns the index of the attribute defined by the given XMLTriple
object.

@param triple the XMLTriple object that defines the attribute whose
index is being sought.
@return the index of an attribute with the given XMLTriple object, or
C<-1> if no such attribute is present on this token.


=item XMLToken::getAttributesLength

Returns the number of attributes on this XMLToken object.
@return the number of attributes possessed by this token.
@see hasAttr(@if java int@endif)


=item XMLToken::getAttrName

Returns the name of the <em>n</em>th attribute in this token's list of
attributes.

@param index an integer, the position of the attribute whose name
is being sought.
@return the name of the attribute located at position C<n> in the list
of attributes possessed by this XMLToken object.
C<opydetails> doc_note_index_out_of_range_behavior 
@see hasAttr(@if java int@endif)
@see getAttributesLength()


=item XMLToken::getAttrPrefix

Returns the prefix of the <em>n</em>th attribute in this token's list of
attributes.

@param index an integer, the position of the attribute whose prefix is
being sought.
@return the XML namespace prefix of the attribute located at position @p
n in the list of attributes possessed by this XMLToken object.
C<opydetails> doc_note_index_out_of_range_behavior
@see hasAttr(@if java int@endif)
@see getAttributesLength()


=item XMLToken::getAttrPrefixedName

Returns the prefixed name of the <em>n</em>th attribute in this token's
list of attributes.
In this context, <em>prefixed name</em> means the name of the attribute
prefixed with the XML namespace prefix assigned to the attribute.  This
will be a string of the form C<prefix:name>.
@param index an integer, the position of the attribute whose prefixed
name is being sought.
@return the prefixed name of the attribute located at position @p
n in the list of attributes possessed by this XMLToken object.
C<opydetails> doc_note_index_out_of_range_behavior


=item XMLToken::getAttrURI

Returns the XML namespace URI of the <em>n</em>th attribute in this
token's list of attributes.
@param index an integer, the position of the attribute whose namespace
URI is being sought.
@return the XML namespace URI of the attribute located at position C<n>
in the list of attributes possessed by this XMLToken object.
C<opydetails> doc_note_index_out_of_range_behavior


=item XMLToken::getAttrValue

Returns the value of the <em>n</em>th attribute in this token's list of
attributes.

@param index an integer, the position of the attribute whose value is
required.

@return the value of the attribute located at position C<n> in the list
of attributes possessed by this XMLToken object.
C<opydetails> doc_note_index_out_of_range_behavior


=item XMLToken::getAttrValue

Returns the value of the attribute with a given name and XML namespace URI.
@param name a string, the name of the attribute whose value is being
sought.

@param uri a string, the XML namespace URI of the attribute.
@return The value of the attribute, as a string.
@note If an attribute with the given C<name> and C<uri> does not exist
on this token object, this method will return an empty string.
XMLToken::hasAttr(@if java String, String@endif) can be used to test
explicitly for the presence of an attribute with a given name and
namespace.

@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item XMLToken::getAttrValue

Returns the value of the attribute specified by a given XMLTriple object.
@param triple an XMLTriple describing the attribute whose value is being
sought.

@return The value of the attribute, as a string.
@note If an attribute defined by the given C<triple> does not exist on
this token object, this method will return an empty string.
XMLToken::hasAttr(@if java XMLTriple@endif) can be used to test
explicitly for the existence of an attribute with the properties of
a given triple.


=item XMLToken::hasAttr

Returns C<true> if an attribute with the given index exists.
@param index an integer, the position of the attribute.
@return C<true> if this token object possesses an attribute with the
given index, C<false> otherwise.


=item XMLToken::hasAttr

Returns C<true> if an attribute with a given name and namespace URI
exists.

@param name a string, the name of the attribute being sought.
@param uri a string, the XML namespace URI of the attribute being
sought.

@return C<true> if an attribute with the given local name and namespace
URI exists in the list of attributes on this token object, C<false>
otherwise.

@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item XMLToken::hasAttr

Returns C<true> if an attribute defined by a given XMLTriple object
exists.

@param triple an XMLTriple object describing the attribute being sought.
@return C<true> if an attribute matching the properties of the given
XMLTriple object exists in the list of attributes on this token, @c
false otherwise.


=item XMLToken::isAttributesEmpty

Returns C<true> if this token has no attributes.
@return C<true> if the list of attributes on XMLToken object is empty,
C<false> otherwise.


=item XMLToken::getNamespaces

Returns the XML namespaces declared for this token.
@return the XML namespace declarations for this XML element.


=item XMLToken::setNamespaces

Sets the XML namespaces on this XML element.
C<opydetails> doc_only_for_start_elements
@param namespaces the XMLNamespaces object to be assigned to this XMLToken object.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
@note This function replaces any existing XMLNamespaces object on this
XMLToken object with the new one given by C<namespaces>.


=item XMLToken::addNamespace

Appends an XML namespace declaration to this token.
The namespace added will be defined by the given XML namespace URI and
an optional prefix.  If this XMLToken object already possesses an XML
namespace declaration with the given C<prefix>, then the existing XML
namespace URI will be overwritten by the new one given by C<uri>.
C<opydetails> doc_only_for_start_elements
@param uri a string, the XML namespace URI for the namespace.
@param prefix a string, the namespace prefix to use.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item XMLToken::removeNamespace

Removes the <em>n</em>th XML namespace declaration.
C<opydetails> doc_only_for_start_elements
@param index an integer, the position of the namespace to be removed.
The position in this context refers to the position of the namespace in
the XMLNamespaces object stored in this XMLToken object.  Callers can
use one of the C<getNamespace___()> methods to find the index
number of a given namespace.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink
@li @link OperationReturnValues_t#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink
@see getNamespaceIndex(@if java String uri@endif)
@see getNamespaceIndexByPrefix(@if java String prefix@endif)
@see getNamespacesLength()


=item XMLToken::removeNamespace

Removes an XML namespace declaration having a given prefix.
C<opydetails> doc_only_for_start_elements
@param prefix a string, the prefix of the namespace to be removed.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink
@li @link OperationReturnValues_t#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink
The value @link OperationReturnValues_t#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink
is returned if there is no namespace with the given C<prefix> on this
element.

@see getNamespaceIndexByPrefix(@if java String prefix@endif)


=item XMLToken::clearNamespaces

Removes all XML namespace declarations from this token.
C<opydetails> doc_only_for_start_elements 
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink


=item XMLToken::getNamespaceIndex

Returns the index of an XML namespace declaration based on its URI.
@param uri a string, the XML namespace URI of the sought-after namespace.
@return the index of the given declaration, or C<-1> if
no such namespace URI is present on this XMLToken object.


=item XMLToken::getNamespaceIndexByPrefix

Returns the index of an XML namespace declaration based on its prefix.
@param prefix a string, the prefix of the sought-after XML namespace.
@return the index of the given declaration, or C<-1> if
no such namespace URI is present on this XMLToken object.


=item XMLToken::getNamespacesLength

Returns the number of XML namespaces declared on this token.
@return the number of XML namespaces stored in the XMLNamespaces
object of this XMLToken object.


=item XMLToken::getNamespacePrefix

Returns the prefix of the <em>n</em>th XML namespace declaration.
@param index an integer, position of the required prefix.
@return the prefix of an XML namespace declaration in the XMLNamespaces
(by position).
@note If C<index> is out of range, this method will return an empty
string.  XMLToken::getNamespacesLength() can be used to find out how
many namespaces are defined on this XMLToken object.
@see getNamespacesLength()


=item XMLToken::getNamespacePrefix

Returns the prefix associated with a given XML namespace URI on this
token.

@param uri a string, the URI of the namespace whose prefix is being
sought.

@return the prefix of an XML namespace declaration on this XMLToken object.
@note If there is no XML namespace with the given C<uri> declared on
this XMLToken object, this method will return an empty string.


=item XMLToken::getNamespaceURI

Returns the URI of the <em>n</em>th XML namespace declared on this token. 
@param index an integer, the position of the sought-after XML namespace URI.
@return the URI of the <em>n</em>th XML namespace stored in the
XMLNamespaces object in this XMLToken object.
@note If C<index> is out of range, this method will return an empty string.
@see getNamespacesLength()


=item XMLToken::getNamespaceURI

Returns the URI of an XML namespace with a given prefix.
@param prefix a string, the prefix of the sought-after XML namespace URI.
@return the URI of an XML namespace declaration given its prefix.
@note If there is no XML namespace with the given C<prefix> stored in
the XMLNamespaces object of this XMLToken object, this method will
return an empty string.
@ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif@~


=item XMLToken::isNamespacesEmpty

Returns C<true> if there are no namespaces declared on this token.
@return C<true> if the XMLNamespaces object stored in this XMLToken
token is empty, C<false> otherwise.


=item XMLToken::hasNamespaceURI

Returns C<true> if this token has an XML namespace with a given URI.
@param uri a string, the URI of the XML namespace.
@return C<true> if an XML namespace with the given URI is contained in
the XMLNamespaces object of this XMLToken object, C<false> otherwise.


=item XMLToken::hasNamespacePrefix

Returns C<true> if this token has an XML namespace with a given prefix.
@param prefix a string, the prefix for the XML namespace.
@return C<true> if an XML Namespace with the given URI is contained in the
XMLNamespaces of this XMLToken, C<false> otherwise.


=item XMLToken::hasNamespaceNS

Returns C<true> if this token has an XML namespace with a given prefix
and URI combination.
@param uri a string, the URI for the namespace.
@param prefix a string, the prefix for the namespace.
@return C<true> if an XML namespace with the given URI/prefix pair is
contained in the XMLNamespaces object of this XMLToken object, C<false>
otherwise.


=item XMLToken::setTriple

Sets the name, namespace prefix and namespace URI of this token.
C<opydetails> doc_only_for_start_elements
@param triple the new XMLTriple to use for this XMLToken object.  If
this XMLToken already had an XMLTriple object stored within it, that
object will be replaced.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink


=item XMLToken::getName

Returns the (unqualified) name of token.
@return the (unqualified) name of token.


=item XMLToken::getPrefix

Returns the XML namespace prefix of token.
@return the XML namespace prefix of token.
@note If no XML namespace prefix has been assigned to this token, this
method will return an empty string.


=item XMLToken::getURI

Returns the XML namespace URI of token.
@return the XML namespace URI of token.


=item XMLToken::getCharacters

Returns the character text of token.
@return the characters of this XML token.  If this token is not a
text token (i.e., it's an XML element and not character content),
then this will return an empty string.
@see isText()
@see isElement()


=item XMLToken::setCharacters

Sets the characters for this XMLToken
This method only makes sense for XMLToken objects that contains text.
If this method is called on a token that represents an XML start or end
tag, it will return the code @link   OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink.
@param chars string, characters to append to the text of this token.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@see isText()
@see isElement()


=item XMLToken::append

Appends characters to the text content of token.
This method only makes sense for XMLToken objects that contains text.
If this method is called on a token that represents an XML start or end
tag, it will return the code @link   OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink.
@param chars string, characters to append to the text of this token.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@see isText()
@see isElement()


=item XMLToken::getColumn

Returns the column number at which this token occurs in the input.
@return the column at which this XMLToken occurred.


=item XMLToken::getLine

Returns the line number at which this token occurs in the input.
@return the line at which this XMLToken occurred.


=item XMLToken::isElement

Returns C<true> if this token represents an XML element.
This generic predicate returns C<true> if the element is either a start
or end tag, and C<false> if it's a text object.  The related methods
XMLToken:isStart(), XMLToken::isEnd() and XMLToken::isText() are more
specific predicates.
@return C<true> if this XMLToken object represents an XML element, @c
false otherwise.
@see isStart()
@see isEnd()
@see isText()


=item XMLToken::isEnd

Returns C<true> if this token represents an XML end element.
@return C<true> if this XMLToken object represents an XML end element,
C<false> otherwise.
@see isStart()
@see isElement()
@see isText()


=item XMLToken::isEndFor

Returns C<true> if this token represents an XML end element for a
particular start element.
@param element XMLToken, the element with which the current object
should be compared to determined whether the current object is a
start element for the given one.
@return C<true> if this XMLToken object represents an XML end tag for
the start tag given by C<element>, C<false> otherwise.
@see isElement()
@see isStart()
@see isEnd()
@see isText()


=item XMLToken::isEOF

Returns C<true> if this token is an end of file marker.
@return C<true> if this XMLToken object represents the end of the input,
C<false> otherwise.
@see setEOF()


=item XMLToken::isStart

Returns C<true> if this token represents an XML start element.
@return C<true> if this XMLToken is an XML start element, C<false> otherwise.
@see isElement()
@see isEnd()
@see isText()


=item XMLToken::isText

Returns C<true> if this token represents an XML text element.
@return C<true> if this XMLToken is an XML text element, C<false> otherwise.
@see isElement()
@see isStart()
@see isEnd()


=item XMLToken::setEnd

Declares that this token represents an XML element end tag.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@see isStart()
@see isEnd()


=item XMLToken::setEOF

Declares that this token is an end-of-file/input marker.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
@see isEOF()


=item XMLToken::unsetEnd

Declares that this token no longer represents an XML start/end element.
C<opydetails> doc_returns_success_code
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink


=item XMLToken::write

@internal


=item XMLToken::toString

Prints a string representation of the underlying token stream.
This method is intended for debugging purposes.
@return a text string representing this XMLToken object.


=back

=head2 XMLNode

@sbmlpackage{core}

@htmlinclude pkg-marker-core.html A node in libSBML's XML document tree.
LibSBML implements an XML abstraction layer.  This layer presents a
uniform XML interface to calling programs regardless of which underlying
XML parser libSBML has actually been configured to use.  The basic data
object in the XML abstraction is a I<node>, represented by XMLNode.
An XMLNode can contain any number of children.  Each child is another
XMLNode, thereby forming a tree.  The methods XMLNode::getNumChildren()
and XMLNode::getChild(@if java long@endif) can be used to access the tree
structure starting from a given node.
Each XMLNode is subclassed from XMLToken, and thus has 