/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 *  A user-defined function in an SBML model.
 <p>
 * The {@link FunctionDefinition} structure associates an identifier with a
 * function definition.  This identifier can then be used as the function
 * called in subsequent MathML content elsewhere in an SBML model.
 <p>
 * {@link FunctionDefinition} has one required attribute, 'id', to give the
 * function a unique identifier by which other parts of an SBML model
 * definition can refer to it.  A {@link FunctionDefinition} instance can also have
 * an optional 'name' attribute of type <code>string.</code>  Identifiers and names
 * must be used according to the guidelines described in the SBML
 * specification (e.g., Section 3.3 in the Level 2 Version 4
 * specification).
 <p>
 * {@link FunctionDefinition} has a 'math' subelement containing a MathML
 * expression defining the function body.  In SBML Level&nbsp;2 and SBML
 * Level&nbsp;3 Version&nbsp;1, that 'math' subelement is required;
 * in SBML Level&nbsp;3 Version&nbsp;2, this restriction was relaxed,
 * making the 'math' subelement optional.  The content of this element can
 * only be a MathML 'lambda' element.  The 'lambda' element must begin with
 * zero or more 'bvar' elements, followed by any other of the elements in
 * the MathML subset allowed in SBML Level 2 <em>except</em> 'lambda' (i.e., a
 * 'lambda' element cannot contain another 'lambda' element).  This is the
 * only place in SBML where a 'lambda' element can be used.  The function
 * defined by a {@link FunctionDefinition} is only available for use in other
 * MathML elements that <em>follow</em> the {@link FunctionDefinition} definition in the
 * model.  (These restrictions prevent recursive and mutually-recursive
 * functions from being expressed.)
 <p>
 * A further restriction on the content of 'math' is that it cannot contain
 * references to variables other than the variables declared to the
 * 'lambda' itself.  That is, the contents of MathML 'ci' elements inside
 * the body of the 'lambda' can only be the variables declared by its
 * 'bvar' elements, or the identifiers of other {@link FunctionDefinition}
 * instances in the model.  This means must be written so that all
 * variables or parameters used in the MathML content are passed to them
 * via their function parameters.  In SBML Level&nbsp;2, this restriction
 * applies also to the MathML <code>csymbol</code> elements for <em>time</em> and 
 * <em>delay</em>; in SBML Level&nbsp;3, it additionally applies to the <code>csymbol</code>
 * element for <em>avogadro</em>.
 <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, if no math element is present in 
 * the {@link FunctionDefinition}, the function has no mathematical meaning 
 * defined in SBML Level&nbsp;3 Core. This situation may arise when models 
 * are incomplete, or when additional meanings are provided by an SBML 
 * Level&nbsp;3 package.
 <p>
 * @note Function definitions (also informally known as user-defined
 * functions) were introduced in SBML Level 2.  They have purposefully
 * limited capabilities.  A function cannot reference parameters or other
 * model quantities outside of itself; values must be passed as parameters
 * to the function.  Moreover, recursive and mutually-recursive functions
 * are not permitted.  The purpose of these limitations is to balance power
 * against complexity of implementation.  With the restrictions as they
 * are, function definitions could be implemented as textual
 * substitutions&mdash;they are simply macros.  Software implementations
 * therefore do not need the full function-definition machinery typically
 * associated with programming languages.
 * <br><br>
 * Another important point to note is {@link FunctionDefinition} does not
 * have a separate attribute for defining the units of the value returned
 * by the function.  The units associated with the function's return value,
 * when the function is called from within MathML expressions elsewhere in
 * SBML, are simply the overall units of the expression in
 * {@link FunctionDefinition}'s 'math' subelement when applied to the arguments
 * supplied in the call to the function.  Ascertaining these units requires
 * performing dimensional analysis on the expression.  (Readers may wonder
 * why there is no attribute.  The reason is that having a separate
 * attribute for declaring the units would not only be redundant, but also
 * lead to the potential for having conflicting information.  In the case
 * of a conflict between the declared units and those of the value actually
 * returned by the function, the only logical resolution rule would be to
 * assume that the correct units are those of the expression anyway.)
 */

public class FunctionDefinition extends SBase {
   private long swigCPtr;

   protected FunctionDefinition(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.FunctionDefinition_SWIGUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(FunctionDefinition obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (FunctionDefinition obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_FunctionDefinition(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  
/**
   * Creates a new {@link FunctionDefinition} using the given SBML <code>level</code> and <code>version</code>
   * values.
   <p>
   * @param level a long integer, the SBML Level to assign to this {@link FunctionDefinition}.
   <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link FunctionDefinition}.
   <p>
   * <p>
 * @throws SBMLConstructorException
 * Thrown if the given <code>level</code> and <code>version</code> combination are invalid
 * or if this object is incompatible with the given level and version.
   <p>
   * <p>
 * @note Attempting to add an object to an {@link SBMLDocument} having a different
 * combination of SBML Level, Version and XML namespaces than the object
 * itself will result in an error at the time a caller attempts to make the
 * addition.  A parent object must have compatible Level, Version and XML
 * namespaces.  (Strictly speaking, a parent may also have more XML
 * namespaces than a child, but the reverse is not permitted.)  The
 * restriction is necessary to ensure that an SBML model has a consistent
 * overall structure.  This requires callers to manage their objects
 * carefully, but the benefit is increased flexibility in how models can be
 * created by permitting callers to create objects bottom-up if desired.  In
 * situations where objects are not yet attached to parents (e.g.,
 * {@link SBMLDocument}), knowledge of the intented SBML Level and Version help
 * libSBML determine such things as whether it is valid to assign a
 * particular value to an attribute.
   */ public
 FunctionDefinition(long level, long version) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_FunctionDefinition__SWIG_0(level, version), true);
  }

  
/**
   * Creates a new {@link FunctionDefinition} using the given {@link SBMLNamespaces} object
   * <code>sbmlns</code>.
   <p>
   * <p>
 * The {@link SBMLNamespaces} object encapsulates SBML Level/Version/namespaces
 * information.  It is used to communicate the SBML Level, Version, and (in
 * Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.  A
 * common approach to using libSBML's {@link SBMLNamespaces} facilities is to create an
 * {@link SBMLNamespaces} object somewhere in a program once, then hand that object
 * as needed to object constructors that accept {@link SBMLNamespaces} as arguments. 
   <p>
   * @param sbmlns an {@link SBMLNamespaces} object.
   <p>
   * <p>
 * @throws SBMLConstructorException
 * Thrown if the given <code>sbmlns</code> is inconsistent or incompatible
 * with this object.
   <p>
   * <p>
 * @note Attempting to add an object to an {@link SBMLDocument} having a different
 * combination of SBML Level, Version and XML namespaces than the object
 * itself will result in an error at the time a caller attempts to make the
 * addition.  A parent object must have compatible Level, Version and XML
 * namespaces.  (Strictly speaking, a parent may also have more XML
 * namespaces than a child, but the reverse is not permitted.)  The
 * restriction is necessary to ensure that an SBML model has a consistent
 * overall structure.  This requires callers to manage their objects
 * carefully, but the benefit is increased flexibility in how models can be
 * created by permitting callers to create objects bottom-up if desired.  In
 * situations where objects are not yet attached to parents (e.g.,
 * {@link SBMLDocument}), knowledge of the intented SBML Level and Version help
 * libSBML determine such things as whether it is valid to assign a
 * particular value to an attribute.
   */ public
 FunctionDefinition(SBMLNamespaces sbmlns) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_FunctionDefinition__SWIG_1(SBMLNamespaces.getCPtr(sbmlns), sbmlns), true);
  }

  
/**
   * Copy constructor; creates a copy of this {@link FunctionDefinition}.
   <p>
   * @param orig the object to copy.
   */ public
 FunctionDefinition(FunctionDefinition orig) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_FunctionDefinition__SWIG_2(FunctionDefinition.getCPtr(orig), orig), true);
  }

  
/**
   * Creates and returns a deep copy of this {@link FunctionDefinition} object.
   <p>
   * @return the (deep) copy of this {@link FunctionDefinition} object.
   */ public
 FunctionDefinition cloneObject() {
    long cPtr = libsbmlJNI.FunctionDefinition_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new FunctionDefinition(cPtr, true);
  }

  
/**
   * Returns the value of the 'id' attribute of this {@link FunctionDefinition}.
   <p>
   * @note Because of the inconsistent behavior of this function with 
   * respect to assignments and rules, it is now recommended to
   * use the getIdAttribute() function instead.
   <p>
   * <p>
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter .= 'a'..'z','A'..'Z'
 *   digit  .= '0'..'9'
 *   idChar .= letter | digit | '_'
 *   SId    .= ( letter | '_' ) idChar*
 * </pre>
 <p>
 * The characters <code>(</code> and <code>)</code> are used for grouping, the
 * character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
 * determined by an exact character sequence match; i.e., comparisons must be
 * performed in a case-sensitive manner.  This applies to all uses of <code>SId</code>, 
 * <code>SIdRef</code>, and derived types.
 <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to {@link SBase} directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on {@link SBase} itself to get, set, check, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all {@link SBase} objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 <p>
 * The exception to this rule is that for {@link InitialAssignment}, {@link EventAssignment}, 
 * {@link AssignmentRule}, and {@link RateRule} objects, the getId() function and the isSetId() 
 * functions (though not the setId() or unsetId() functions) would instead 
 * reference the value of the 'variable' attribute (for the rules and event 
 * assignments) or the 'symbol' attribute (for initial assignments).  
 * The {@link AlgebraicRule} fell into this category as well, though because it 
 * contained neither a 'variable' nor a 'symbol' attribute, getId() would 
 * always return an empty string, and isSetId() would always return <code>false.</code>
 * For this reason, four new functions are now provided 
 * (getIdAttribute(), setIdAttribute(String), 
 * isSetIdAttribute(), and unsetIdAttribute()) that will always
 * act on the actual 'id' attribute, regardless of the object's type.  The
 * new functions should be used instead of the old ones unless the old behavior
 * is somehow necessary.
 <p>
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * identifiers).  If the object in question does not posess an 'id' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the identifier to be set, nor will it read or 
 * write 'id' attributes for those objects.
   <p>
   * @return the id of this {@link FunctionDefinition}.
   <p>
   * @see #getIdAttribute()
   * @see #setIdAttribute(String sid)
   * @see #isSetIdAttribute()
   * @see #unsetIdAttribute()
   */ public
 String getId() {
    return libsbmlJNI.FunctionDefinition_getId(swigCPtr, this);
  }

  
/**
   * Returns the value of the 'name' attribute of this {@link FunctionDefinition} object.
   <p>
   * <p>
 * <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to {@link SBase} directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on {@link SBase} itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all {@link SBase} objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 <p>
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 <p>
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 <p>
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 <p>
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 <p>
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 <p>
 * @return the name of this SBML object, or the empty string if not set or unsettable.
 <p>
 * @see #getIdAttribute()
 * @see #isSetName()
 * @see #setName(String sid)
 * @see #unsetName()
   */ public
 String getName() {
    return libsbmlJNI.FunctionDefinition_getName(swigCPtr, this);
  }

  
/**
   * Get the mathematical formula of this {@link FunctionDefinition}.
   <p>
   * @return an {@link ASTNode}, the value of the 'math' subelement of this
   * {@link FunctionDefinition}, or <code>null</code> if the math is not set.
   */ public
 ASTNode getMath() {
    long cPtr = libsbmlJNI.FunctionDefinition_getMath(swigCPtr, this);
    return (cPtr == 0) ? null : new ASTNode(cPtr, false);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * {@link FunctionDefinition}'s 'id' attribute is set.
   <p>
   * <p>
 * @note Because of the inconsistent behavior of this function with 
 * respect to assignments and rules, it is now recommended to
 * use the isSetIdAttribute() function instead.
 <p>
 * <p>
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter .= 'a'..'z','A'..'Z'
 *   digit  .= '0'..'9'
 *   idChar .= letter | digit | '_'
 *   SId    .= ( letter | '_' ) idChar*
 * </pre>
 <p>
 * The characters <code>(</code> and <code>)</code> are used for grouping, the
 * character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
 * determined by an exact character sequence match; i.e., comparisons must be
 * performed in a case-sensitive manner.  This applies to all uses of <code>SId</code>, 
 * <code>SIdRef</code>, and derived types.
 <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to {@link SBase} directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on {@link SBase} itself to get, set, check, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all {@link SBase} objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 <p>
 * The exception to this rule is that for {@link InitialAssignment}, {@link EventAssignment}, 
 * {@link AssignmentRule}, and {@link RateRule} objects, the getId() function and the isSetId() 
 * functions (though not the setId() or unsetId() functions) would instead 
 * reference the value of the 'variable' attribute (for the rules and event 
 * assignments) or the 'symbol' attribute (for initial assignments).  
 * The {@link AlgebraicRule} fell into this category as well, though because it 
 * contained neither a 'variable' nor a 'symbol' attribute, getId() would 
 * always return an empty string, and isSetId() would always return <code>false.</code>
 * For this reason, four new functions are now provided 
 * (getIdAttribute(), setIdAttribute(String), 
 * isSetIdAttribute(), and unsetIdAttribute()) that will always
 * act on the actual 'id' attribute, regardless of the object's type.  The
 * new functions should be used instead of the old ones unless the old behavior
 * is somehow necessary.
 <p>
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * identifiers).  If the object in question does not posess an 'id' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the identifier to be set, nor will it read or 
 * write 'id' attributes for those objects.
 <p>
 * @return <code>true</code> if the 'id' attribute of this SBML object is
 * set, <code>false</code> otherwise.
 <p>
 * @see #getIdAttribute()
 * @see #setIdAttribute(String sid)
 * @see #unsetIdAttribute()
 * @see #isSetIdAttribute()
   */ public
 boolean isSetId() {
    return libsbmlJNI.FunctionDefinition_isSetId(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * {@link FunctionDefinition}'s 'name' attribute is set.
   <p>
   * <p>
 * <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to {@link SBase} directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on {@link SBase} itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all {@link SBase} objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 <p>
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 <p>
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 <p>
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 <p>
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 <p>
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 <p>
 * @return <code>true</code> if the 'name' attribute of this SBML object is
 * set, <code>false</code> otherwise.
 <p>
 * @see #getName()
 * @see #setName(String sid)
 * @see #unsetName()
   */ public
 boolean isSetName() {
    return libsbmlJNI.FunctionDefinition_isSetName(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * {@link FunctionDefinition}'s 'math' subelement contains a value.
   <p>
   * @return <code>true</code> if the 'math' for this {@link FunctionDefinition} is set,
   * <code>false</code> otherwise.
   */ public
 boolean isSetMath() {
    return libsbmlJNI.FunctionDefinition_isSetMath(swigCPtr, this);
  }

  
/**
   * Sets the value of the 'id' attribute of this {@link FunctionDefinition}.
   <p>
   * <p>
 * The string <code>sid</code> is copied.
 <p>
 * <p>
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter .= 'a'..'z','A'..'Z'
 *   digit  .= '0'..'9'
 *   idChar .= letter | digit | '_'
 *   SId    .= ( letter | '_' ) idChar*
 * </pre>
 <p>
 * The characters <code>(</code> and <code>)</code> are used for grouping, the
 * character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
 * determined by an exact character sequence match; i.e., comparisons must be
 * performed in a case-sensitive manner.  This applies to all uses of <code>SId</code>, 
 * <code>SIdRef</code>, and derived types.
 <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to {@link SBase} directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on {@link SBase} itself to get, set, check, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all {@link SBase} objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 <p>
 * The exception to this rule is that for {@link InitialAssignment}, {@link EventAssignment}, 
 * {@link AssignmentRule}, and {@link RateRule} objects, the getId() function and the isSetId() 
 * functions (though not the setId() or unsetId() functions) would instead 
 * reference the value of the 'variable' attribute (for the rules and event 
 * assignments) or the 'symbol' attribute (for initial assignments).  
 * The {@link AlgebraicRule} fell into this category as well, though because it 
 * contained neither a 'variable' nor a 'symbol' attribute, getId() would 
 * always return an empty string, and isSetId() would always return <code>false.</code>
 * For this reason, four new functions are now provided 
 * (getIdAttribute(), setIdAttribute(String), 
 * isSetIdAttribute(), and unsetIdAttribute()) that will always
 * act on the actual 'id' attribute, regardless of the object's type.  The
 * new functions should be used instead of the old ones unless the old behavior
 * is somehow necessary.
 <p>
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * identifiers).  If the object in question does not posess an 'id' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the identifier to be set, nor will it read or 
 * write 'id' attributes for those objects.
 <p>
 * @param sid the string to use as the identifier of this object.
 <p>
 * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
 * <ul>
 * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
 * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
 * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
 *
 * </ul> <p>
 * @see #getIdAttribute()
 * @see #setIdAttribute(String sid)
 * @see #isSetIdAttribute()
 * @see #unsetIdAttribute()
   */ public
 int setId(String sid) {
    return libsbmlJNI.FunctionDefinition_setId(swigCPtr, this, sid);
  }

  
/**
   * Sets the value of the 'name' attribute of this {@link FunctionDefinition}.
   <p>
   * <p>
 * The string in <code>name</code> is copied.
 <p>
 * @param name the new name for the SBML object.
 <p>
 * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
 * <ul>
 * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
 * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
 *
 * </ul>
   */ public
 int setName(String name) {
    return libsbmlJNI.FunctionDefinition_setName(swigCPtr, this, name);
  }

  
/**
   * Sets the 'math' subelement of this {@link FunctionDefinition} to the Abstract
   * Syntax Tree given in <code>math</code>.
   <p>
   * @param math an AST containing the mathematical expression to
   * be used as the formula for this {@link FunctionDefinition}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * </ul>
   */ public
 int setMath(ASTNode math) {
    return libsbmlJNI.FunctionDefinition_setMath(swigCPtr, this, ASTNode.getCPtr(math), math);
  }

  
/**
   * Unsets the value of the 'name' attribute of this {@link FunctionDefinition}.
   <p>
   * <p>
 * <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to {@link SBase} directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on {@link SBase} itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all {@link SBase} objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 <p>
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 <p>
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 <p>
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 <p>
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 <p>
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 <p>
 * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
 * <ul>
 * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
 * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
 *
 * </ul> <p>
 * @see #getName()
 * @see #setName(String sid)
 * @see #isSetName()
   */ public
 int unsetName() {
    return libsbmlJNI.FunctionDefinition_unsetName(swigCPtr, this);
  }

  
/**
   * Get the <code>n</code>th argument to this function.
   <p>
   * Callers should first find out the number of arguments to the function
   * by calling getNumArguments().
   <p>
   * @param n an integer index for the argument sought.
   <p>
   * @return the nth argument (bound variable) passed to this
   * {@link FunctionDefinition}.
   <p>
   * @see #getNumArguments()
   */ public
 ASTNode getArgument(long n) {
    long cPtr = libsbmlJNI.FunctionDefinition_getArgument__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new ASTNode(cPtr, false);
  }

  
/**
   * Get the argument named <code>name</code> to this {@link FunctionDefinition}.
   <p>
   * @param name the exact name (case-sensitive) of the sought-after
   * argument.
   <p>
   * @return the argument (bound variable) having the given name, or <code>null</code> if
   * no such argument exists.
   */ public
 ASTNode getArgument(String name) {
    long cPtr = libsbmlJNI.FunctionDefinition_getArgument__SWIG_1(swigCPtr, this, name);
    return (cPtr == 0) ? null : new ASTNode(cPtr, false);
  }

  
/**
   * Get the mathematical expression that is the body of this
   * {@link FunctionDefinition} object.
   <p>
   * @return the body of this {@link FunctionDefinition} as an Abstract Syntax
   * Tree, or <code>null</code> if no body is defined.
   */ public
 ASTNode getBody() {
    long cPtr = libsbmlJNI.FunctionDefinition_getBody__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ASTNode(cPtr, false);
  }

  
/**
   * Predicate returning <code>true</code> if the body of this
   * {@link FunctionDefinition} has set.
   <p>
   * @return <code>true</code> if the body of this {@link FunctionDefinition} is 
   * set, <code>false</code> otherwise.
   */ public
 boolean isSetBody() {
    return libsbmlJNI.FunctionDefinition_isSetBody(swigCPtr, this);
  }

  
/**
   * Get the number of arguments (bound variables) taken by this
   * {@link FunctionDefinition}.
   <p>
   * @return the number of arguments (bound variables) that must be passed
   * to this {@link FunctionDefinition}.
   */ public
 long getNumArguments() {
    return libsbmlJNI.FunctionDefinition_getNumArguments(swigCPtr, this);
  }

  
/**
   * Returns the libSBML type code for this SBML object.
   <p>
   * <p>
 * LibSBML attaches an identifying code to every kind of SBML object.  These
 * are integer constants known as <em>SBML type codes</em>.  The names of all
 * the codes begin with the characters <code>SBML_</code>.
 * In the Java language interface for libSBML, the
 * type codes are defined as static integer constants in the interface class
 * {@link libsbmlConstants}.    Note that different Level&nbsp;3
 * package plug-ins may use overlapping type codes; to identify the package
 * to which a given object belongs, call the <code>getPackageName()</code>
 * method on the object.
   <p>
   * @return the SBML type code for this object:
   * {@link libsbmlConstants#SBML_FUNCTION_DEFINITION SBML_FUNCTION_DEFINITION} (default).
   <p>
   * <p>
 * @warning <span class='warning'>The specific integer values of the possible
 * type codes may be reused by different libSBML plug-ins for SBML Level&nbsp;3.
 * packages,  To fully identify the correct code, <strong>it is necessary to
 * invoke both getTypeCode() and getPackageName()</strong>.</span>
   <p>
   * @see #getElementName()
   * @see #getPackageName()
   */ public
 int getTypeCode() {
    return libsbmlJNI.FunctionDefinition_getTypeCode(swigCPtr, this);
  }

  
/**
   * Returns the XML element name of this object, which for
   * {@link FunctionDefinition}, is always <code>'functionDefinition'.</code>
   <p>
   * @return the name of this element, i.e., <code>'functionDefinition'.</code>
   */ public
 String getElementName() {
    return libsbmlJNI.FunctionDefinition_getElementName(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if
   * all the required attributes for this {@link FunctionDefinition} object
   * have been set.
   <p>
   * The required attributes for a {@link FunctionDefinition} object are:
   * <ul>
   * <li> 'id'
   *
   * </ul> <p>
   * @return <code>true</code> if the required attributes have been set, <code>false</code>
   * otherwise.
   */ public
 boolean hasRequiredAttributes() {
    return libsbmlJNI.FunctionDefinition_hasRequiredAttributes(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if
   * all the required elements for this {@link FunctionDefinition} object
   * have been set.
   <p>
   * @note The required elements for a {@link FunctionDefinition} object are:
   * <ul>
   * <li> 'math' inSBML Level&nbsp;2 and Level&nbsp;3 Version&nbsp;1.  
   *     (In SBML Level&nbsp;3 Version&nbsp;2+, it is no longer required.)
   *
   * </ul> <p>
   * @return a boolean value indicating whether all the required
   * elements for this object have been defined.
   */ public
 boolean hasRequiredElements() {
    return libsbmlJNI.FunctionDefinition_hasRequiredElements(swigCPtr, this);
  }

  
/**
   * Renames all the <code>UnitSIdRef</code> attributes on this element.
   <p>
   * <p>
 * In SBML, unit definitions have identifiers of type <code>UnitSId</code>.  In
 * SBML Level&nbsp;3, an explicit data type called <code>UnitSIdRef</code> was
 * introduced for attribute values that refer to <code>UnitSId</code> values; in
 * previous Levels of SBML, this data type did not exist and attributes were
 * simply described to as 'referring to a unit identifier', but the effective
 * data type was the same as <code>UnitSIdRef</code> in Level&nbsp;3.  These and
 * other methods of libSBML refer to the type <code>UnitSIdRef</code> for all
 * Levels of SBML, even if the corresponding SBML specification did not
 * explicitly name the data type.
   <p>
   * This method works by looking at all unit identifier attribute values
   * (including, if appropriate, inside mathematical formulas), comparing the
   * unit identifiers to the value of <code>oldid</code>.  If any matches are found,
   * the matching identifiers are replaced with <code>newid</code>.  The method does
   * <em>not</em> descend into child elements.
   <p>
   * @param oldid the old identifier.
   * @param newid the new identifier.
   */ public
 void renameUnitSIdRefs(String oldid, String newid) {
    libsbmlJNI.FunctionDefinition_renameUnitSIdRefs(swigCPtr, this, oldid, newid);
  }

}
