using System;
using System.Runtime.InteropServices;
 
/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace libsbmlcs {

 using System;
 using System.Runtime.InteropServices;

/** 
 * @sbmlpackage{core}
 *
@htmlinclude pkg-marker-core.html SBML's <em>%SBase</em> class, base class of most SBML objects.
 *
 * Most components in SBML are derived from a single abstract base type,
 * SBase.  In addition to serving as the parent class for most other
 * classes of objects in SBML, this base type is designed to allow a
 * modeler or a software package to attach arbitrary information to each
 * major element or list in an SBML model.
 *
 * SBase has an optional subelement called 'notes'.  It is intended to
 * serve as a place for storing optional information intended to be seen by
 * humans.  An example use of the 'notes' element would be to contain
 * formatted user comments about the model element in which the 'notes'
 * element is enclosed.  There are certain conditions on the XHTML content
 * permitted inside the 'notes' element; please consult the <a
 * target='_blank' href='http://sbml.org/Documents/Specifications'>SBML
 * specification document</a> corresponding to the SBML Level and Version
 * of your model for more information about the requirements for 'notes'
 * content.
 *
 * SBase has another optional subelement called 'annotation'.  Whereas the
 * 'notes' element described above is a container for content to be shown
 * directly to humans, the 'annotation' element is a container for optional
 * software-generated content @em not meant to be shown to humans.  The
 * element's content type is <a target='_blank'
 * href='http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls'>XML type
 * 'any'</a>, allowing essentially arbitrary data content.  SBML places
 * only a few restrictions on the organization of the content; these are
 * intended to help software tools read and write the data as well as help
 * reduce conflicts between annotations added by different tools.  As is
 * the case with 'notes', it is important to refer to the <a
 * target='_blank' href='http://sbml.org/Documents/Specifications'>SBML
 * specification document</a> corresponding to the SBML Level and Version
 * of your model for more information about the requirements for
 * 'annotation' content.
 * 
 * It is worth pointing out that the 'annotation' element in the definition
 * of SBase exists in order that software developers may attach optional
 * application-specific data to the elements in an SBML model.  However, it
 * is important that this facility not be misused.  In particular, it is
 * <em>critical</em> that data essential to a model definition or that can
 * be encoded in existing SBML elements is <em>not</em> stored in
 * 'annotation'. Parameter values, functional dependencies between model
 * elements, etc., should not be recorded as annotations.  It is crucial to
 * keep in mind the fact that data placed in annotations can be freely
 * ignored by software applications.  If such data affects the
 * interpretation of a model, then software interoperability is greatly
 * impeded.
 *
 * SBML Level 2 introduced an optional SBase attribute named 'metaid' for
 * supporting metadata annotations using RDF (<a target='_blank'
 * href='http://www.w3.org/RDF/'>Resource Description Format</a>). The
 * attribute value has the data type <a
 * href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, the XML identifier
 * type, which means each 'metaid' value must be globally unique within an
 * SBML file.  (Importantly, this uniqueness criterion applies across any
 * attribute with type <a href='http://www.w3.org/TR/REC-xml/#id'>XML
 * ID</a>, not just the 'metaid' attribute used by SBML---something to
 * be aware of if your application-specific XML content inside the
 * 'annotation' subelement happens to use <a
 * href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>.)  The 'metaid' value
 * serves to identify a model component for purposes such as referencing
 * that component from metadata placed within 'annotation' subelements.
 *
 * Beginning with SBML Level 2 Version 3, SBase also has an optional
 * attribute named 'sboTerm' for supporting the use of the Systems Biology
 * Ontology.  In SBML proper, the data type of the attribute is a string of
 * the form 'SBO:NNNNNNN', where 'NNNNNNN' is a seven digit integer number;
 * libSBML simplifies the representation by only storing the 'NNNNNNN'
 * integer portion.  Thus, in libSBML, the 'sboTerm' attribute on SBase has
 * data type @c int, and SBO identifiers are stored simply as integers.
 * (For convenience, SBase offers methods for returning both the integer
 * form and a text-string form of the SBO identifier.)  SBO terms are a
 * type of optional annotation, and each different class of SBML object
 * derived from SBase imposes its own requirements about the values
 * permitted for 'sboTerm'.  Please consult the SBML Level&nbsp;2
 * Version&nbsp;4 specification for more information about the use of SBO
 * and the 'sboTerm' attribute.
 *
 * Finally, note that, in the list of methods on SBase, there is no public
 * constructor because SBase is an abstract class.  The constructors reside
 * in the subclasses derived from SBase.
 *
 *
 * @section sbase-miriam Standard format for annotations linking data resources
 *
 * SBML Level 2 Versions 2, 3 and 4, and Level&nbsp;3, define a proposed
 * regular format for encoding two particular categories of annotations:
 * (a) references to controlled vocabulary terms and database identifiers
 * which define and describe biological and biochemical entities in a
 * model; and (b) descriptions of the provenance of a model, including its
 * author(s) and modification history.
 */

public class SBase : IDisposable {
	private HandleRef swigCPtr;
	protected bool swigCMemOwn;
	
	internal SBase(IntPtr cPtr, bool cMemoryOwn)
	{
		swigCMemOwn = cMemoryOwn;
		swigCPtr    = new HandleRef(this, cPtr);
	}
	
	internal static HandleRef getCPtr(SBase obj)
	{
		return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
	}
	
	internal static HandleRef getCPtrAndDisown (SBase obj)
	{
		HandleRef ptr = new HandleRef(null, IntPtr.Zero);
		
		if (obj != null)
		{
			ptr             = obj.swigCPtr;
			obj.swigCMemOwn = false;
		}
		
		return ptr;
	}

  ~SBase() {
    Dispose();
  }

  public virtual void Dispose() {
    lock(this) {
      if (swigCPtr.Handle != IntPtr.Zero) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          libsbmlPINVOKE.delete_SBase(swigCPtr);
        }
        swigCPtr = new HandleRef(null, IntPtr.Zero);
      }
      GC.SuppressFinalize(this);
    }
  }

  public static bool operator==(SBase lhs, SBase rhs)
  {
    if((Object)lhs == (Object)rhs)
    {
      return true;
    }

    if( ((Object)lhs == null) || ((Object)rhs == null) )
    {
      return false;
    }

    return (getCPtr(lhs).Handle.ToString() == getCPtr(rhs).Handle.ToString());
  }

  public static bool operator!=(SBase lhs, SBase rhs)
  {
    return !(lhs == rhs);
  }

  public override bool Equals(Object sb)
  {
    if ( ! (sb is SBase) )
    {
      return false;
    }

    return this == (SBase)sb;
  }

  public override int GetHashCode()
  {
    return swigCPtr.Handle.ToInt32();
  }

  
/**
   * Creates and returns a deep copy of this SBase object.
   *
   * @return the (deep) copy of this SBase object.
   */ public new
 SBase clone() {
	SBase ret = (SBase) libsbml.DowncastSBase(libsbmlPINVOKE.SBase_clone(swigCPtr), true);
	return ret;
}

  
/**
   * Returns the first child element found that has the given @p id in the
   * model-wide @c SId namespace, or @c null if no such object is found.
   *
   * @param id string representing the 'id' attribute value of the object
   * to find.
   *
   * @return pointer to the first element found with the given identifier.
   */ public new
 SBase getElementBySId(string id) {
	SBase ret = (SBase) libsbml.DowncastSBase(libsbmlPINVOKE.SBase_getElementBySId__SWIG_0(swigCPtr, id), false);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
	return ret;
}

  
/**
   * Returns the first child element it can find with a specific 'metaid'
   * attribute value, or @c null if no such object is found.
   *
   *
 * 
 * The optional attribute named 'metaid', present on every major SBML
 * component type, is for supporting metadata annotations using RDF (<a
 * href='http://www.w3.org/RDF/'>Resource Description Format</a>).  The
 * attribute value has the data type <a
 * href='http://www.w3.org/TR/REC-xml/#id'>XML <code>ID</code></a>, the XML
 * identifier type, which means each 'metaid' value must be globally unique
 * within an SBML file.  The latter point is important, because the
 * uniqueness criterion applies across <em>any</em> attribute with type
 * <code>ID</code> anywhere in the file, not just the 'metaid' attribute used
 * by SBML---something to be aware of if your application-specific XML
 * content inside the 'annotation' subelement happens to use the XML
 * <code>ID</code> type.  Although SBML itself specifies the use of <a
 * href='http://www.w3.org/TR/REC-xml/#id'>XML <code>ID</code></a> only for
 * the 'metaid' attribute, SBML-compatible applications should be careful if
 * they use XML <code>ID</code>'s in XML portions of a model that are not
 * defined by SBML, such as in the application-specific content of the
 * 'annotation' subelement.  Finally, note that LibSBML does not provide an
 * explicit XML <code>ID</code> data type; it uses ordinary character
 * strings, which is easier for applications to support.
 *
 *
   *
   * @param metaid string representing the 'metaid' attribute value of the
   * object to find.
   *
   * @return pointer to the first element found with the given meta-identifier.
   */ public new
 SBase getElementByMetaId(string metaid) {
	SBase ret = (SBase) libsbml.DowncastSBase(libsbmlPINVOKE.SBase_getElementByMetaId__SWIG_0(swigCPtr, metaid), false);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
	return ret;
}

  
/**
   *
 * Replaces all uses of a given @c SIdRef type attribute value with another
 * value.
 *
 *
 * 

 * In SBML, object identifiers are of a data type called <code>SId</code>.
 * In SBML Level&nbsp;3, an explicit data type called <code>SIdRef</code> was
 * introduced for attribute values that refer to <code>SId</code> values; in
 * previous Levels of SBML, this data type did not exist and attributes were
 * simply described to as 'referring to an identifier', but the effective
 * data type was the same as <code>SIdRef</code> in Level&nbsp;3.  These and
 * other methods of libSBML refer to the type <code>SIdRef</code> for all
 * Levels of SBML, even if the corresponding SBML specification did not
 * explicitly name the data type.
 *
 *
 *
 * This method works by looking at all attributes and (if appropriate)
 * mathematical formulas in MathML content, comparing the referenced
 * identifiers to the value of @p oldid.  If any matches are found, the
 * matching values are replaced with @p newid.  The method does @em not
 * descend into child elements.
 *
 * @param oldid the old identifier.
 * @param newid the new identifier.
 *
 *
   */ public new
 void renameSIdRefs(string oldid, string newid) {
    libsbmlPINVOKE.SBase_renameSIdRefs(swigCPtr, oldid, newid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   *
 * Replaces all uses of a given meta identifier attribute value with
 * another value.
 *
 *
 * 
 * In SBML, object 'meta' identifiers are of the XML data type <code>ID</code>;
 * the SBML object attribute itself is typically named <code>metaid</code>.  All
 * attributes that hold values <em>referring</em> to values of type
 * <code>ID</code> are of the XML data type <code>IDREF</code>.  They are also
 * sometimes informally referred to as 'metaid refs', in analogy to the
 * SBML-defined type <code>SIdRef</code>.
 *
 *
 *
 * This method works by looking at all meta-identifier attribute values,
 * comparing the identifiers to the value of @p oldid.  If any matches are
 * found, the matching identifiers are replaced with @p newid.  The method
 * does @em not descend into child elements.
 *
 * @param oldid the old identifier.
 * @param newid the new identifier.
 *
 *
   */ public new
 void renameMetaIdRefs(string oldid, string newid) {
    libsbmlPINVOKE.SBase_renameMetaIdRefs(swigCPtr, oldid, newid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   *
 * Replaces all uses of a given @c UnitSIdRef type attribute value with
 * another value.
 *
 *
 * 
 * In SBML, unit definitions have identifiers of type <code>UnitSId</code>.  In
 * SBML Level&nbsp;3, an explicit data type called <code>UnitSIdRef</code> was
 * introduced for attribute values that refer to <code>UnitSId</code> values; in
 * previous Levels of SBML, this data type did not exist and attributes were
 * simply described to as 'referring to a unit identifier', but the effective
 * data type was the same as <code>UnitSIdRef</code> in Level&nbsp;3.  These and
 * other methods of libSBML refer to the type <code>UnitSIdRef</code> for all
 * Levels of SBML, even if the corresponding SBML specification did not
 * explicitly name the data type.
 *
 *
 *
 * This method works by looking at all unit identifier attribute values
 * (including, if appropriate, inside mathematical formulas), comparing the
 * referenced unit identifiers to the value of @p oldid.  If any matches
 * are found, the matching values are replaced with @p newid.  The method
 * does @em not descend into child elements.
 *
 * @param oldid the old identifier.
 * @param newid the new identifier.
 *
 *
   */ public new
 void renameUnitSIdRefs(string oldid, string newid) {
    libsbmlPINVOKE.SBase_renameUnitSIdRefs(swigCPtr, oldid, newid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/** */ /* libsbml-internal */ public new
 void replaceSIDWithFunction(string id, ASTNode function) {
    libsbmlPINVOKE.SBase_replaceSIDWithFunction(swigCPtr, id, ASTNode.getCPtr(function));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/** */ /* libsbml-internal */ public new
 void divideAssignmentsToSIdByFunction(string id, ASTNode function) {
    libsbmlPINVOKE.SBase_divideAssignmentsToSIdByFunction(swigCPtr, id, ASTNode.getCPtr(function));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/** */ /* libsbml-internal */ public new
 void multiplyAssignmentsToSIdByFunction(string id, ASTNode function) {
    libsbmlPINVOKE.SBase_multiplyAssignmentsToSIdByFunction(swigCPtr, id, ASTNode.getCPtr(function));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/** */ /* libsbml-internal */ public new
 SBase getElementFromPluginsBySId(string id) {
	SBase ret = (SBase) libsbml.DowncastSBase(libsbmlPINVOKE.SBase_getElementFromPluginsBySId(swigCPtr, id), false);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
	return ret;
}

  
/** */ /* libsbml-internal */ public new
 SBase getElementFromPluginsByMetaId(string metaid) {
	SBase ret = (SBase) libsbml.DowncastSBase(libsbmlPINVOKE.SBase_getElementFromPluginsByMetaId(swigCPtr, metaid), false);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
	return ret;
}

  
/** */ /* libsbml-internal */ public new
 bool hasNonstandardIdentifierBeginningWith(string prefix) {
    bool ret = libsbmlPINVOKE.SBase_hasNonstandardIdentifierBeginningWith(swigCPtr, prefix);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/** */ /* libsbml-internal */ public new
 int prependStringToAllIdentifiers(string prefix) {
    int ret = libsbmlPINVOKE.SBase_prependStringToAllIdentifiers(swigCPtr, prefix);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/** */ /* libsbml-internal */ public new
 int transformIdentifiers(IdentifierTransformer idTransformer) {
    int ret = libsbmlPINVOKE.SBase_transformIdentifiers(swigCPtr, IdentifierTransformer.getCPtr(idTransformer));
    return ret;
  }

  
/**
   * Returns the value of the 'metaid' attribute of this SBML object.
   *
   *
 * 
 * The optional attribute named 'metaid', present on every major SBML
 * component type, is for supporting metadata annotations using RDF (<a
 * href='http://www.w3.org/RDF/'>Resource Description Format</a>).  The
 * attribute value has the data type <a
 * href='http://www.w3.org/TR/REC-xml/#id'>XML <code>ID</code></a>, the XML
 * identifier type, which means each 'metaid' value must be globally unique
 * within an SBML file.  The latter point is important, because the
 * uniqueness criterion applies across <em>any</em> attribute with type
 * <code>ID</code> anywhere in the file, not just the 'metaid' attribute used
 * by SBML---something to be aware of if your application-specific XML
 * content inside the 'annotation' subelement happens to use the XML
 * <code>ID</code> type.  Although SBML itself specifies the use of <a
 * href='http://www.w3.org/TR/REC-xml/#id'>XML <code>ID</code></a> only for
 * the 'metaid' attribute, SBML-compatible applications should be careful if
 * they use XML <code>ID</code>'s in XML portions of a model that are not
 * defined by SBML, such as in the application-specific content of the
 * 'annotation' subelement.  Finally, note that LibSBML does not provide an
 * explicit XML <code>ID</code> data type; it uses ordinary character
 * strings, which is easier for applications to support.
 *
 *
   *  
   * @return the meta-identifier of this SBML object.
   *
   * @see isSetMetaId()
   * @see setMetaId(string metaid)
   */ public
 string getMetaId() {
    string ret = libsbmlPINVOKE.SBase_getMetaId(swigCPtr);
    return ret;
  }

  
/**
   * Returns the value of the 'id' attribute of this SBML object, if it has one, 
   * or the 'variable' attribute of a Rule, or the 'symbol' attribute of
   * an InitialAssignment.
   *
   * @note Because of the inconsistent behavior of this function with 
   * respect to assignments and rules, it is now recommended to
   * use the getIdAttribute() function instead.
   *
   *
 * 
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter ::= 'a'..'z','A'..'Z'
 *   digit  ::= '0'..'9'
 *   idChar ::= letter | digit | '_'
 *   SId    ::= ( letter | '_' ) idChar*
 * </pre>
 *
 * The characters <code>(</code> and <code>)</code> are used for grouping, the
 * character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
 * determined by an exact character sequence match; i.e., comparisons must be
 * performed in a case-sensitive manner.  This applies to all uses of <code>SId</code>, 
 * <code>SIdRef</code>, and derived types.
 *
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on SBase itself to get, set, check, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The exception to this rule is that for InitialAssignment, EventAssignment, 
 * AssignmentRule, and RateRule objects, the getId() function and the isSetId() 
 * functions (though not the setId() or unsetId() functions) would instead 
 * reference the value of the 'variable' attribute (for the rules and event 
 * assignments) or the 'symbol' attribute (for initial assignments).  
 * The AlgebraicRule fell into this category as well, though because it 
 * contained neither a 'variable' nor a 'symbol' attribute, getId() would 
 * always return an empty string, and isSetId() would always return @c false.
 * For this reason, four new functions are now provided 
 * (getIdAttribute(), setIdAttribute(@if java String@endif), 
 * isSetIdAttribute(), and unsetIdAttribute()) that will always
 * act on the actual 'id' attribute, regardless of the object's type.  The
 * new functions should be used instead of the old ones unless the old behavior
 * is somehow necessary.
 * 
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * identifiers).  If the object in question does not posess an 'id' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the identifier to be set, nor will it read or 
 * write 'id' attributes for those objects.
 *
 *
   *
   * @return the id of this SBML object, or the 'variable' if the object 
   * is a Rule, or the 'symbol' if the object is an InitialAssignment.
   *
   * @see getIdAttribute()
   * @see setIdAttribute(string sid)
   * @see isSetIdAttribute()
   * @see unsetIdAttribute()
   */ public new
 string getId() {
    string ret = libsbmlPINVOKE.SBase_getId(swigCPtr);
    return ret;
  }

  
/**
   * Returns the value of the 'id' attribute of this SBML object.
   *
   * @note Because of the inconsistent behavior of the old SBase::getId()
   * function with respect to assignments and rules, it is now 
   * recommended to use this getIdAttribute() function instead.
   * 
   *
 * 
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter ::= 'a'..'z','A'..'Z'
 *   digit  ::= '0'..'9'
 *   idChar ::= letter | digit | '_'
 *   SId    ::= ( letter | '_' ) idChar*
 * </pre>
 *
 * The characters <code>(</code> and <code>)</code> are used for grouping, the
 * character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
 * determined by an exact character sequence match; i.e., comparisons must be
 * performed in a case-sensitive manner.  This applies to all uses of <code>SId</code>, 
 * <code>SIdRef</code>, and derived types.
 *
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on SBase itself to get, set, check, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The exception to this rule is that for InitialAssignment, EventAssignment, 
 * AssignmentRule, and RateRule objects, the getId() function and the isSetId() 
 * functions (though not the setId() or unsetId() functions) would instead 
 * reference the value of the 'variable' attribute (for the rules and event 
 * assignments) or the 'symbol' attribute (for initial assignments).  
 * The AlgebraicRule fell into this category as well, though because it 
 * contained neither a 'variable' nor a 'symbol' attribute, getId() would 
 * always return an empty string, and isSetId() would always return @c false.
 * For this reason, four new functions are now provided 
 * (getIdAttribute(), setIdAttribute(@if java String@endif), 
 * isSetIdAttribute(), and unsetIdAttribute()) that will always
 * act on the actual 'id' attribute, regardless of the object's type.  The
 * new functions should be used instead of the old ones unless the old behavior
 * is somehow necessary.
 * 
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * identifiers).  If the object in question does not posess an 'id' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the identifier to be set, nor will it read or 
 * write 'id' attributes for those objects.
 *
 *
   *
   * @return the id of this SBML object, if set and valid for this
   * level and version of SBML; an empty string otherwise.
   *
   * @see setIdAttribute(string sid)
   * @see isSetIdAttribute()
   * @see unsetIdAttribute()
   */ public
 string getIdAttribute() {
    string ret = libsbmlPINVOKE.SBase_getIdAttribute(swigCPtr);
    return ret;
  }

  
/**
   * Returns the value of the 'name' attribute of this SBML object.
   *
   *
 *
 * 
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on SBase itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 *
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 * 
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 * 
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 *
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 *
 *
 *
 * @return the name of this SBML object, or the empty string if not set or unsettable.
 *
 * @see getIdAttribute()
 * @see isSetName()
 * @see setName(string sid)
 * @see unsetName()
 * 
 *
   */ public new
 string getName() {
    string ret = libsbmlPINVOKE.SBase_getName(swigCPtr);
    return ret;
  }

  
/**
   * Returns the content of the 'notes' subelement of this object as
   * a tree of XMLNode objects.
   *
   *
 * 
 * The optional SBML element named 'notes', present on every major SBML
 * component type (and in SBML Level&nbsp;3, the 'message' subelement of
 * Constraint), is intended as a place for storing optional information
 * intended to be seen by humans.  An example use of the 'notes' element
 * would be to contain formatted user comments about the model element in
 * which the 'notes' element is enclosed.  Every object derived directly or
 * indirectly from type SBase can have a separate value for 'notes', allowing
 * users considerable freedom when adding comments to their models.
 *
 * The format of 'notes' elements conform to the definition of <a
 * target='_blank' href='http://www.w3.org/TR/xhtml1/'>XHTML&nbsp;1.0</a>.
 * However, the content cannot be @em entirely free-form; it must satisfy
 * certain requirements defined in the <a target='_blank'
 * href='http://sbml.org/Documents/Specifications'>SBML specifications</a>
 * for specific SBML Levels.  To help verify the formatting of 'notes'
 * content, libSBML provides the static utility method
 * SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode@endif); this
 * method implements a verification process that lets callers check whether
 * the content of a given XMLNode object conforms to the SBML requirements
 * for 'notes' and 'message' structure.  Developers are urged to consult the
 * appropriate <a target='_blank'
 * href='http://sbml.org/Documents/Specifications'>SBML specification
 * document</a> for the Level and Version of their model for more in-depth
 * explanations of using 'notes' in SBML.  The SBML Level&nbsp;2 and&nbsp;3
 * specifications have considerable detail about how 'notes' element content
 * must be structured.
 *
 * 
   *
   * The 'notes' element content returned by this method will be in XML
   * form, but libSBML does not provide an object model specifically for
   * the content of notes.  Callers will need to traverse the XML tree
   * structure using the facilities available on XMLNode and related
   * objects.  For an alternative method of accessing the notes, see
   * getNotesString().
   *
   * @return the content of the 'notes' subelement of this SBML object as a
   * tree structure composed of XMLNode objects.
   *
   * @see getNotesString()
   * @see isSetNotes()
   * @see setNotes(XMLNode notes)
   * @see setNotes(string notes, bool addXHTMLMarkup)
   * @see appendNotes(XMLNode notes)
   * @see appendNotes(string notes)
   * @see unsetNotes()
   * @see SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode@endif)
   */ public
 XMLNode getNotes() {
    IntPtr cPtr = libsbmlPINVOKE.SBase_getNotes__SWIG_0(swigCPtr);
    XMLNode ret = (cPtr == IntPtr.Zero) ? null : new XMLNode(cPtr, false);
    return ret;
  }

  
/**
   * Returns the content of the 'notes' subelement of this object as a
   * string.
   *
   *
 * 
 * The optional SBML element named 'notes', present on every major SBML
 * component type (and in SBML Level&nbsp;3, the 'message' subelement of
 * Constraint), is intended as a place for storing optional information
 * intended to be seen by humans.  An example use of the 'notes' element
 * would be to contain formatted user comments about the model element in
 * which the 'notes' element is enclosed.  Every object derived directly or
 * indirectly from type SBase can have a separate value for 'notes', allowing
 * users considerable freedom when adding comments to their models.
 *
 * The format of 'notes' elements conform to the definition of <a
 * target='_blank' href='http://www.w3.org/TR/xhtml1/'>XHTML&nbsp;1.0</a>.
 * However, the content cannot be @em entirely free-form; it must satisfy
 * certain requirements defined in the <a target='_blank'
 * href='http://sbml.org/Documents/Specifications'>SBML specifications</a>
 * for specific SBML Levels.  To help verify the formatting of 'notes'
 * content, libSBML provides the static utility method
 * SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode@endif); this
 * method implements a verification process that lets callers check whether
 * the content of a given XMLNode object conforms to the SBML requirements
 * for 'notes' and 'message' structure.  Developers are urged to consult the
 * appropriate <a target='_blank'
 * href='http://sbml.org/Documents/Specifications'>SBML specification
 * document</a> for the Level and Version of their model for more in-depth
 * explanations of using 'notes' in SBML.  The SBML Level&nbsp;2 and&nbsp;3
 * specifications have considerable detail about how 'notes' element content
 * must be structured.
 *
 * 
   *
   * For an alternative method of accessing the notes, see getNotes(),
   * which returns the content as an XMLNode tree structure.  Depending on
   * an application's needs, one or the other method may be more
   * convenient.
   *
   * @return the content of the 'notes' subelement of this SBML object as a
   * string.
   *
   * @see getNotes()
   * @see isSetNotes()
   * @see setNotes(XMLNode notes)
   * @see setNotes(string notes, bool addXHTMLMarkup)
   * @see appendNotes(XMLNode notes)
   * @see appendNotes(string notes)
   * @see unsetNotes()
   * @see SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode@endif)
   */ public
 string getNotesString() {
    string ret = libsbmlPINVOKE.SBase_getNotesString__SWIG_0(swigCPtr);
    return ret;
  }

  
/**
   * Returns the content of the 'annotation' subelement of this object as
   * a tree of XMLNode objects.
   *
   *
 * 
 * Whereas the SBML 'notes' subelement is a container for content to be
 * shown directly to humans, the 'annotation' element is a container for
 * optional software-generated content @em not meant to be shown to
 * humans.  Every object derived from SBase can have its own value for
 * 'annotation'.  The element's content type is <a target='_blank'
 * href='http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls'>XML type
 * 'any'</a>, allowing essentially arbitrary well-formed XML data
 * content.
 *
 * SBML places a few restrictions on the organization of the content of
 * annotations; these are intended to help software tools read and write
 * the data as well as help reduce conflicts between annotations added by
 * different tools.  Please see the SBML specifications for more details.
 *
 * 
   *
   * The annotations returned by this method will be in XML form.  LibSBML
   * provides an object model and related interfaces for certain specific
   * kinds of annotations, namely model history information and RDF
   * content.  See the ModelHistory, CVTerm and RDFAnnotationParser classes
   * for more information about the facilities available.
   *
   * @return the annotation of this SBML object as a tree of XMLNode objects.
   *
   * @see getAnnotationString()
   * @see isSetAnnotation()
   * @see setAnnotation(XMLNode annotation)
   * @see setAnnotation(string annotation)
   * @see appendAnnotation(XMLNode annotation)
   * @see appendAnnotation(string annotation)
   * @see unsetAnnotation()
   */ public
 XMLNode getAnnotation() {
    IntPtr cPtr = libsbmlPINVOKE.SBase_getAnnotation__SWIG_0(swigCPtr);
    XMLNode ret = (cPtr == IntPtr.Zero) ? null : new XMLNode(cPtr, false);
    return ret;
  }

  
/**
   * Returns the content of the 'annotation' subelement of this object as a
   * character string.
   *
   *
 * 
 * Whereas the SBML 'notes' subelement is a container for content to be
 * shown directly to humans, the 'annotation' element is a container for
 * optional software-generated content @em not meant to be shown to
 * humans.  Every object derived from SBase can have its own value for
 * 'annotation'.  The element's content type is <a target='_blank'
 * href='http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls'>XML type
 * 'any'</a>, allowing essentially arbitrary well-formed XML data
 * content.
 *
 * SBML places a few restrictions on the organization of the content of
 * annotations; these are intended to help software tools read and write
 * the data as well as help reduce conflicts between annotations added by
 * different tools.  Please see the SBML specifications for more details.
 *
 * 
   *
   * The annotations returned by this method will be in string form.  See the
   * method getAnnotation() for a version that returns annotations in XML form.
   *
   * @return the annotation of this SBML object as a character string.
   *
   * @see getAnnotation()
   * @see isSetAnnotation()
   * @see setAnnotation(XMLNode annotation)
   * @see setAnnotation(string annotation)
   * @see appendAnnotation(XMLNode annotation)
   * @see appendAnnotation(string annotation)
   * @see unsetAnnotation()
   */ public
 string getAnnotationString() {
    string ret = libsbmlPINVOKE.SBase_getAnnotationString__SWIG_0(swigCPtr);
    return ret;
  }

  
/**
   * Returns a list of the XML Namespaces declared on the SBML document
   * owning this object.
   *
   * The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
   * information.  It is used to communicate the SBML Level, Version, and (in
   * Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
   *
   * @return the XML Namespaces associated with this SBML object, or @c null
   * in certain very usual circumstances where a namespace is not set.
   *
   * @see getLevel()
   * @see getVersion()
   */ public new
 XMLNamespaces getNamespaces() {
    IntPtr cPtr = libsbmlPINVOKE.SBase_getNamespaces(swigCPtr);
    XMLNamespaces ret = (cPtr == IntPtr.Zero) ? null : new XMLNamespaces(cPtr, false);
    return ret;
  }

  
/**
   * Returns the SBMLDocument object containing this object instance.
   *
   *
 * 
 * LibSBML uses the class SBMLDocument as a top-level container for
 * storing SBML content and data associated with it (such as warnings and
 * error messages).  An SBML model in libSBML is contained inside an
 * SBMLDocument object.  SBMLDocument corresponds roughly to the class
 * <i>SBML</i> defined in the SBML Level&nbsp;3 and Level&nbsp;2
 * specifications, but it does not have a direct correspondence in SBML
 * Level&nbsp;1.  (But, it is created by libSBML no matter whether the
 * model is Level&nbsp;1, Level&nbsp;2 or Level&nbsp;3.)
 *
 *
   *
   * This method allows the caller to obtain the SBMLDocument for the
   * current object.
   * 
   * @return the parent SBMLDocument object of this SBML object.
   *
   * @see getParentSBMLObject()
   * @see getModel()
   */ public
 SBMLDocument getSBMLDocument() {
    IntPtr cPtr = libsbmlPINVOKE.SBase_getSBMLDocument__SWIG_0(swigCPtr);
    SBMLDocument ret = (cPtr == IntPtr.Zero) ? null : new SBMLDocument(cPtr, false);
    return ret;
  }

  
/**
   * Returns the parent SBML object containing this object.
   *
   * This returns the immediately-containing object.  This method is
   * convenient when holding an object nested inside other objects in an
   * SBML model.  
   * 
   * @return the parent SBML object of this SBML object.
   *
   * @see getSBMLDocument()
   * @see getModel()
   */ public
 SBase getParentSBMLObject() {
	SBase ret = (SBase) libsbml.DowncastSBase(libsbmlPINVOKE.SBase_getParentSBMLObject__SWIG_0(swigCPtr), false);
	return ret;
}

  
/**
   * Returns the first ancestor object that has the given SBML type code from the given package.
   *
   * @if clike LibSBML attaches an identifying code to every kind of SBML
   * object.  These are known as <em>SBML type codes</em>.  The set of
   * possible type codes is defined in the enumeration #SBMLTypeCode_t.
   * The names of the type codes all begin with the characters @c
   * SBML_. @endif@if java LibSBML attaches an identifying code to every
   * kind of SBML object.  These are known as <em>SBML type codes</em>.  In
   * other languages, the set of type codes is stored in an enumeration; in
   * the Java language interface for libSBML, the type codes are defined as
   * static integer constants in the interface class {@link
   * libsbmlConstants}.  The names of the type codes all begin with the
   * characters @c SBML_. @endif@if python LibSBML attaches an identifying
   * code to every kind of SBML object.  These are known as <em>SBML type
   * codes</em>.  In the Python language interface for libSBML, the type
   * codes are defined as static integer constants in the interface class
   * @link libsbml@endlink.  The names of the type codes all begin with the
   * characters @c SBML_. @endif@if csharp LibSBML attaches an identifying
   * code to every kind of SBML object.  These are known as <em>SBML type
   * codes</em>.  In the C# language interface for libSBML, the type codes
   * are defined as static integer constants in the interface class @link
   * libsbmlcs.libsbml libsbml@endlink.  The names of the type codes all begin with
   * the characters @c SBML_. @endif
   *
   * This method searches the tree of objects that are parents of this
   * object, and returns the first one that has the given SBML type code from 
   * the given @p pkgName.
   *
   * @param type the SBML type code of the object sought.
   *
   * @param pkgName (optional) the short name of an SBML Level&nbsp;3
   * package to which the sought-after object must belong.
   * 
   * @return the ancestor SBML object of this SBML object that corresponds
   * to the given @if clike #SBMLTypeCode_t value@else SBML object type
   * code@endif, or @c null if no ancestor exists.
   *
   * @warning The optional argument @p pkgName must be used for all type codes
   * from SBML Level&nbsp;3 packages.  Otherwise, the function will search the 
   * 'core' namespace alone, not find any corresponding elements, and return 
   * null.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 SBase getAncestorOfType(int type, string pkgName) {
	SBase ret = (SBase) libsbml.DowncastSBase(libsbmlPINVOKE.SBase_getAncestorOfType__SWIG_0(swigCPtr, type, pkgName), false);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
	return ret;
}

  
/**
   * Returns the first ancestor object that has the given SBML type code from the given package.
   *
   * @if clike LibSBML attaches an identifying code to every kind of SBML
   * object.  These are known as <em>SBML type codes</em>.  The set of
   * possible type codes is defined in the enumeration #SBMLTypeCode_t.
   * The names of the type codes all begin with the characters @c
   * SBML_. @endif@if java LibSBML attaches an identifying code to every
   * kind of SBML object.  These are known as <em>SBML type codes</em>.  In
   * other languages, the set of type codes is stored in an enumeration; in
   * the Java language interface for libSBML, the type codes are defined as
   * static integer constants in the interface class {@link
   * libsbmlConstants}.  The names of the type codes all begin with the
   * characters @c SBML_. @endif@if python LibSBML attaches an identifying
   * code to every kind of SBML object.  These are known as <em>SBML type
   * codes</em>.  In the Python language interface for libSBML, the type
   * codes are defined as static integer constants in the interface class
   * @link libsbml@endlink.  The names of the type codes all begin with the
   * characters @c SBML_. @endif@if csharp LibSBML attaches an identifying
   * code to every kind of SBML object.  These are known as <em>SBML type
   * codes</em>.  In the C# language interface for libSBML, the type codes
   * are defined as static integer constants in the interface class @link
   * libsbmlcs.libsbml libsbml@endlink.  The names of the type codes all begin with
   * the characters @c SBML_. @endif
   *
   * This method searches the tree of objects that are parents of this
   * object, and returns the first one that has the given SBML type code from 
   * the given @p pkgName.
   *
   * @param type the SBML type code of the object sought.
   *
   * @param pkgName (optional) the short name of an SBML Level&nbsp;3
   * package to which the sought-after object must belong.
   * 
   * @return the ancestor SBML object of this SBML object that corresponds
   * to the given @if clike #SBMLTypeCode_t value@else SBML object type
   * code@endif, or @c null if no ancestor exists.
   *
   * @warning The optional argument @p pkgName must be used for all type codes
   * from SBML Level&nbsp;3 packages.  Otherwise, the function will search the 
   * 'core' namespace alone, not find any corresponding elements, and return 
   * null.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 SBase getAncestorOfType(int type) {
	SBase ret = (SBase) libsbml.DowncastSBase(libsbmlPINVOKE.SBase_getAncestorOfType__SWIG_1(swigCPtr, type), false);
	return ret;
}

  
/**
   * Returns the integer portion of the value of the 'sboTerm' attribute of
   * this object.
   *
   * Beginning with SBML Level 2 Version 3, objects derived from SBase have
   * an optional attribute named 'sboTerm' for supporting the use of the
   * Systems Biology Ontology.  In SBML proper, the data type of the
   * attribute is a string of the form 'SBO:NNNNNNN', where 'NNNNNNN' is a
   * seven digit integer number; libSBML simplifies the representation by
   * only storing the 'NNNNNNN' integer portion.  Thus, in libSBML, the
   * 'sboTerm' attribute on SBase has data type @c int, and SBO identifiers
   * are stored simply as integers.  (For convenience, libSBML offers
   * methods for returning both the integer form and a text-string form of
   * the SBO identifier.)
   *
   * SBO terms are a type of optional annotation, and each different class
   * of SBML object derived from SBase imposes its own requirements about
   * the values permitted for 'sboTerm'.  Please consult the SBML
   * Level&nbsp;2 Version&nbsp;4 specification for more information about
   * the use of SBO and the 'sboTerm' attribute.
   *
   * @return the value of the 'sboTerm' attribute as an integer, or @c -1
   * if the value is not set.
   */ public
 int getSBOTerm() {
    int ret = libsbmlPINVOKE.SBase_getSBOTerm(swigCPtr);
    return ret;
  }

  
/**
   * Returns the string representation of the 'sboTerm' attribute of
   * this object.
   *
   * Beginning with SBML Level 2 Version 3, objects derived from SBase have
   * an optional attribute named 'sboTerm' for supporting the use of the
   * Systems Biology Ontology.  In SBML proper, the data type of the
   * attribute is a string of the form 'SBO:NNNNNNN', where 'NNNNNNN' is a
   * seven digit integer number; libSBML simplifies the representation by
   * only storing the 'NNNNNNN' integer portion.  Thus, in libSBML, the
   * 'sboTerm' attribute on SBase has data type @c int, and SBO identifiers
   * are stored simply as integers.  This method returns the entire SBO
   * identifier as a text string in the form 'SBO:NNNNNNN'.
   *
   * SBO terms are a type of optional annotation, and each different class
   * of SBML object derived from SBase imposes its own requirements about
   * the values permitted for 'sboTerm'.  Please consult the SBML
   * Level&nbsp;2 Version&nbsp;4 specification for more information about
   * the use of SBO and the 'sboTerm' attribute.
   *
   * @return the value of the 'sboTerm' attribute as a string (its value
   * will be of the form 'SBO:NNNNNNN'), or an empty string if
   * the value is not set.
   */ public
 string getSBOTermID() {
    string ret = libsbmlPINVOKE.SBase_getSBOTermID(swigCPtr);
    return ret;
  }

  
/**
   * Returns the URL representation of the 'sboTerm' attribute of this
   * object.
   *
   * This method returns the entire SBO identifier as a text string in the
   * form <code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://identifiers.org/biomodels.sbo/SBO:NNNNNNN'</code>.
   *
   * SBO terms are a type of optional annotation, and each different class
   * of SBML object derived from SBase imposes its own requirements about
   * the values permitted for 'sboTerm'.  Please consult the SBML
   * Level&nbsp;2 Version&nbsp;4 specification for more information about
   * the use of SBO and the 'sboTerm' attribute.
   *
   * @return the value of the 'sboTerm' attribute as an identifiers.org URL,
   * or an empty string if the value is not set.
   */ public
 string getSBOTermAsURL() {
    string ret = libsbmlPINVOKE.SBase_getSBOTermAsURL(swigCPtr);
    return ret;
  }

  
/**
   * Returns the line number where this object first appears in the XML
   * representation of the SBML document.
   *
   * @return the line number of this SBML object.  If this object was
   * created programmatically and not read from a file, this method will
   * return the value @c 0.
   *
   * @note The line number for each construct in an SBML model is set upon
   * reading the model.  The accuracy of the line number depends on the
   * correctness of the XML representation of the model, and on the
   * particular XML parser library being used.  The former limitation
   * relates to the following problem: if the model is actually invalid
   * XML, then the parser may not be able to interpret the data correctly
   * and consequently may not be able to establish the real line number.
   * The latter limitation is simply that different parsers seem to have
   * their own accuracy limitations, and out of all the parsers supported
   * by libSBML, none have been 100% accurate in all situations. (At this
   * time, libSBML supports the use of <a target='_blank'
   * href='http://xmlsoft.org'>libxml2</a>, <a target='_blank'
   * href='http://expat.sourceforge.net/'>Expat</a> and <a target='_blank'
   * href='http://xerces.apache.org/xerces-c/'>Xerces</a>.)
   *
   * @see getColumn()
   */ public
 long getLine() { return (long)libsbmlPINVOKE.SBase_getLine(swigCPtr); }

  
/**
   * Returns the column number where this object first appears in the XML
   * representation of the SBML document.
   *
   * @return the column number of this SBML object.  If this object was
   * created programmatically and not read from a file, this method will
   * return the value @c 0.
   *
   * @note The column number for each construct in an SBML model is set
   * upon reading the model.  The accuracy of the column number depends on
   * the correctness of the XML representation of the model, and on the
   * particular XML parser library being used.  The former limitation
   * relates to the following problem: if the model is actually invalid
   * XML, then the parser may not be able to interpret the data correctly
   * and consequently may not be able to establish the real column number.
   * The latter limitation is simply that different parsers seem to have
   * their own accuracy limitations, and out of all the parsers supported
   * by libSBML, none have been 100% accurate in all situations. (At this
   * time, libSBML supports the use of <a target='_blank'
   * href='http://xmlsoft.org'>libxml2</a>, <a target='_blank'
   * href='http://expat.sourceforge.net/'>Expat</a> and <a target='_blank'
   * href='http://xerces.apache.org/xerces-c/'>Xerces</a>.)
   * 
   * @see getLine()
   */ public
 long getColumn() { return (long)libsbmlPINVOKE.SBase_getColumn(swigCPtr); }

  
/**
   * Returns the ModelHistory object, if any, attached to this object.
   *
   * @return the ModelHistory object attached to this object, or @c null if
   * none exist.
   * 
   * @note In SBML Level&nbsp;2, model history annotations were only
   * permitted on the Model element.  In SBML Level&nbsp;3, they are
   * permitted on all SBML components derived from SBase.
   */ public
 ModelHistory getModelHistory() {
    IntPtr cPtr = libsbmlPINVOKE.SBase_getModelHistory__SWIG_0(swigCPtr);
    ModelHistory ret = (cPtr == IntPtr.Zero) ? null : new ModelHistory(cPtr, false);
    return ret;
  }

  
/**
   * Predicate returning @c true if this object's 'metaid' attribute is set.
   *
   *
 * 
 * The optional attribute named 'metaid', present on every major SBML
 * component type, is for supporting metadata annotations using RDF (<a
 * href='http://www.w3.org/RDF/'>Resource Description Format</a>).  The
 * attribute value has the data type <a
 * href='http://www.w3.org/TR/REC-xml/#id'>XML <code>ID</code></a>, the XML
 * identifier type, which means each 'metaid' value must be globally unique
 * within an SBML file.  The latter point is important, because the
 * uniqueness criterion applies across <em>any</em> attribute with type
 * <code>ID</code> anywhere in the file, not just the 'metaid' attribute used
 * by SBML---something to be aware of if your application-specific XML
 * content inside the 'annotation' subelement happens to use the XML
 * <code>ID</code> type.  Although SBML itself specifies the use of <a
 * href='http://www.w3.org/TR/REC-xml/#id'>XML <code>ID</code></a> only for
 * the 'metaid' attribute, SBML-compatible applications should be careful if
 * they use XML <code>ID</code>'s in XML portions of a model that are not
 * defined by SBML, such as in the application-specific content of the
 * 'annotation' subelement.  Finally, note that LibSBML does not provide an
 * explicit XML <code>ID</code> data type; it uses ordinary character
 * strings, which is easier for applications to support.
 *
 * 
   *
   * @return @c true if the 'metaid' attribute of this SBML object is
   * set, @c false otherwise.
   *
   * @see getMetaId()
   * @see setMetaId(string metaid)
   */ public
 bool isSetMetaId() {
    bool ret = libsbmlPINVOKE.SBase_isSetMetaId(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if a call to getId() returns a 
   * non-empty string.  This means that for most objects, this 
   * function will return @c true if its 'id' attribute is set, and
   * @c false if it is not, or if the object has no 'id' attribute
   * at all.  However, for an EventAssignment or a Rule, isSetId() 
   * checks whether the 'variable' attribute is set, and for an
   * InitialAssignment, it checks whether the 'symbol' attribute
   * is set.  Because those elements will also have an 'id'
   * attribute in SBML Level&nbsp;3 Version&nbsp;2 which isSetId()
   * will not check, the function itself is deprecated, and it
   * is recommended to use isSetIdAttribute() in all cases where
   * one needs to know whether the 'id' attribute is set, and
   * to use EventAssignment::isSetVariable(), Rule::isSetVariable()
   * and InitialAssignment::isSetSymbol() when the status of the
   * 'variable' or 'symbol' attributes need to be checked.
   *
   *
 * @note Because of the inconsistent behavior of this function with 
 * respect to assignments and rules, it is now recommended to
 * use the isSetIdAttribute() function instead.
 *
 *
 * 
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter ::= 'a'..'z','A'..'Z'
 *   digit  ::= '0'..'9'
 *   idChar ::= letter | digit | '_'
 *   SId    ::= ( letter | '_' ) idChar*
 * </pre>
 *
 * The characters <code>(</code> and <code>)</code> are used for grouping, the
 * character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
 * determined by an exact character sequence match; i.e., comparisons must be
 * performed in a case-sensitive manner.  This applies to all uses of <code>SId</code>, 
 * <code>SIdRef</code>, and derived types.
 *
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on SBase itself to get, set, check, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The exception to this rule is that for InitialAssignment, EventAssignment, 
 * AssignmentRule, and RateRule objects, the getId() function and the isSetId() 
 * functions (though not the setId() or unsetId() functions) would instead 
 * reference the value of the 'variable' attribute (for the rules and event 
 * assignments) or the 'symbol' attribute (for initial assignments).  
 * The AlgebraicRule fell into this category as well, though because it 
 * contained neither a 'variable' nor a 'symbol' attribute, getId() would 
 * always return an empty string, and isSetId() would always return @c false.
 * For this reason, four new functions are now provided 
 * (getIdAttribute(), setIdAttribute(@if java String@endif), 
 * isSetIdAttribute(), and unsetIdAttribute()) that will always
 * act on the actual 'id' attribute, regardless of the object's type.  The
 * new functions should be used instead of the old ones unless the old behavior
 * is somehow necessary.
 * 
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * identifiers).  If the object in question does not posess an 'id' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the identifier to be set, nor will it read or 
 * write 'id' attributes for those objects.
 *
 *
 * 
 * @return @c true if the 'id' attribute of this SBML object is
 * set, @c false otherwise.
 *
 * @see getIdAttribute()
 * @see setIdAttribute(string sid)
 * @see unsetIdAttribute()
 * @see isSetIdAttribute()
 *
 *
   */ public new
 bool isSetId() {
    bool ret = libsbmlPINVOKE.SBase_isSetId(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this object's 'id' attribute is set.
   *
   *
 * 
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter ::= 'a'..'z','A'..'Z'
 *   digit  ::= '0'..'9'
 *   idChar ::= letter | digit | '_'
 *   SId    ::= ( letter | '_' ) idChar*
 * </pre>
 *
 * The characters <code>(</code> and <code>)</code> are used for grouping, the
 * character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
 * determined by an exact character sequence match; i.e., comparisons must be
 * performed in a case-sensitive manner.  This applies to all uses of <code>SId</code>, 
 * <code>SIdRef</code>, and derived types.
 *
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on SBase itself to get, set, check, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The exception to this rule is that for InitialAssignment, EventAssignment, 
 * AssignmentRule, and RateRule objects, the getId() function and the isSetId() 
 * functions (though not the setId() or unsetId() functions) would instead 
 * reference the value of the 'variable' attribute (for the rules and event 
 * assignments) or the 'symbol' attribute (for initial assignments).  
 * The AlgebraicRule fell into this category as well, though because it 
 * contained neither a 'variable' nor a 'symbol' attribute, getId() would 
 * always return an empty string, and isSetId() would always return @c false.
 * For this reason, four new functions are now provided 
 * (getIdAttribute(), setIdAttribute(@if java String@endif), 
 * isSetIdAttribute(), and unsetIdAttribute()) that will always
 * act on the actual 'id' attribute, regardless of the object's type.  The
 * new functions should be used instead of the old ones unless the old behavior
 * is somehow necessary.
 * 
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * identifiers).  If the object in question does not posess an 'id' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the identifier to be set, nor will it read or 
 * write 'id' attributes for those objects.
 *
 *
   * 
   * @return @c true if the 'id' attribute of this SBML object is
   * set, @c false otherwise.
   *
   * @see getIdAttribute()
   * @see setIdAttribute(string sid)
   * @see unsetIdAttribute()
   */ public
 bool isSetIdAttribute() {
    bool ret = libsbmlPINVOKE.SBase_isSetIdAttribute(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * object's 'name' attribute is set.
   * 
   *
 *
 * 
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on SBase itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 *
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 * 
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 * 
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 *
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 *
 *
 * 
 * @return @c true if the 'name' attribute of this SBML object is
 * set, @c false otherwise.
 *
 * @see getName()
 * @see setName(string sid)
 * @see unsetName()
 *
 *
   */ public new
 bool isSetName() {
    bool ret = libsbmlPINVOKE.SBase_isSetName(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * object's 'notes' subelement exists and has content.
   *
   * The optional SBML element named 'notes', present on every major SBML
   * component type, is intended as a place for storing optional
   * information intended to be seen by humans.  An example use of the
   * 'notes' element would be to contain formatted user comments about the
   * model element in which the 'notes' element is enclosed.  Every object
   * derived directly or indirectly from type SBase can have a separate
   * value for 'notes', allowing users considerable freedom when adding
   * comments to their models.
   *
   * The format of 'notes' elements must be <a target='_blank'
   * href='http://www.w3.org/TR/xhtml1/'>XHTML&nbsp;1.0</a>.  To help
   * verify the formatting of 'notes' content, libSBML provides the static
   * utility method SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode xhtml@endif); however,
   * readers are urged to consult the appropriate <a target='_blank'
   * href='http://sbml.org/Documents/Specifications'>SBML specification
   * document</a> for the Level and Version of their model for more
   * in-depth explanations.  The SBML Level&nbsp;2 and&nbsp;3
   * specifications have considerable detail about how 'notes' element
   * content must be structured.
   *
   * @return @c true if a 'notes' subelement exists, @c false otherwise.
   * 
   * @see getNotes()
   * @see getNotesString()
   * @see setNotes(XMLNode notes)
   * @see setNotes(string notes, bool addXHTMLMarkup)
   * @see appendNotes(XMLNode notes)
   * @see appendNotes(string notes)
   * @see unsetNotes()
   * @see SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode@endif)
   */ public
 bool isSetNotes() {
    bool ret = libsbmlPINVOKE.SBase_isSetNotes(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * object's 'annotation' subelement exists and has content.
   *
   * Whereas the SBase 'notes' subelement is a container for content to be
   * shown directly to humans, the 'annotation' element is a container for
   * optional software-generated content @em not meant to be shown to
   * humans.  Every object derived from SBase can have its own value for
   * 'annotation'.  The element's content type is <a target='_blank'
   * href='http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls'>XML type
   * 'any'</a>, allowing essentially arbitrary well-formed XML data
   * content.
   *
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   *
   * @return @c true if a 'annotation' subelement exists, @c false
   * otherwise.
   * 
   * @see getAnnotation()
   * @see getAnnotationString()
   * @see setAnnotation(XMLNode annotation)
   * @see setAnnotation(string annotation)
   * @see appendAnnotation(XMLNode annotation)
   * @see appendAnnotation(string annotation)
   * @see unsetAnnotation()
   */ public
 bool isSetAnnotation() {
    bool ret = libsbmlPINVOKE.SBase_isSetAnnotation(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * object's 'sboTerm' attribute is set.
   *
   * @return @c true if the 'sboTerm' attribute of this SBML object is
   * set, @c false otherwise.
   */ public
 bool isSetSBOTerm() {
    bool ret = libsbmlPINVOKE.SBase_isSetSBOTerm(swigCPtr);
    return ret;
  }

  
/**
   * Sets the value of the meta-identifier attribute of this SBML object.
   *
   *
 * 
 * The optional attribute named 'metaid', present on every major SBML
 * component type, is for supporting metadata annotations using RDF (<a
 * href='http://www.w3.org/RDF/'>Resource Description Format</a>).  The
 * attribute value has the data type <a
 * href='http://www.w3.org/TR/REC-xml/#id'>XML <code>ID</code></a>, the XML
 * identifier type, which means each 'metaid' value must be globally unique
 * within an SBML file.  The latter point is important, because the
 * uniqueness criterion applies across <em>any</em> attribute with type
 * <code>ID</code> anywhere in the file, not just the 'metaid' attribute used
 * by SBML---something to be aware of if your application-specific XML
 * content inside the 'annotation' subelement happens to use the XML
 * <code>ID</code> type.  Although SBML itself specifies the use of <a
 * href='http://www.w3.org/TR/REC-xml/#id'>XML <code>ID</code></a> only for
 * the 'metaid' attribute, SBML-compatible applications should be careful if
 * they use XML <code>ID</code>'s in XML portions of a model that are not
 * defined by SBML, such as in the application-specific content of the
 * 'annotation' subelement.  Finally, note that LibSBML does not provide an
 * explicit XML <code>ID</code> data type; it uses ordinary character
 * strings, which is easier for applications to support.
 *
 * 
   *
   * The string @p metaid is copied.  
   *
   * @param metaid the identifier string to use as the value of the
   * 'metaid' attribute.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   * 
   * @see getMetaId()
   * @see isSetMetaId()
   */ public
 int setMetaId(string metaid) {
    int ret = libsbmlPINVOKE.SBase_setMetaId(swigCPtr, metaid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * object has a ModelHistory object attached to it.
   *
   * @return @c true if the ModelHistory of this object is set, @c
   * false otherwise.
   * 
   * @note In SBML Level&nbsp;2, model history annotations were only
   * permitted on the Model element.  In SBML Level&nbsp;3, they are
   * permitted on all SBML components derived from SBase.
   */ public
 bool isSetModelHistory() {
    bool ret = libsbmlPINVOKE.SBase_isSetModelHistory(swigCPtr);
    return ret;
  }

  
/**
   * Sets the value of the 'id' attribute of this SBML object.
   *
   *
 * 
 * The string @p sid is copied.
 *
 *
 * 
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter ::= 'a'..'z','A'..'Z'
 *   digit  ::= '0'..'9'
 *   idChar ::= letter | digit | '_'
 *   SId    ::= ( letter | '_' ) idChar*
 * </pre>
 *
 * The characters <code>(</code> and <code>)</code> are used for grouping, the
 * character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
 * determined by an exact character sequence match; i.e., comparisons must be
 * performed in a case-sensitive manner.  This applies to all uses of <code>SId</code>, 
 * <code>SIdRef</code>, and derived types.
 *
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on SBase itself to get, set, check, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The exception to this rule is that for InitialAssignment, EventAssignment, 
 * AssignmentRule, and RateRule objects, the getId() function and the isSetId() 
 * functions (though not the setId() or unsetId() functions) would instead 
 * reference the value of the 'variable' attribute (for the rules and event 
 * assignments) or the 'symbol' attribute (for initial assignments).  
 * The AlgebraicRule fell into this category as well, though because it 
 * contained neither a 'variable' nor a 'symbol' attribute, getId() would 
 * always return an empty string, and isSetId() would always return @c false.
 * For this reason, four new functions are now provided 
 * (getIdAttribute(), setIdAttribute(@if java String@endif), 
 * isSetIdAttribute(), and unsetIdAttribute()) that will always
 * act on the actual 'id' attribute, regardless of the object's type.  The
 * new functions should be used instead of the old ones unless the old behavior
 * is somehow necessary.
 * 
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * identifiers).  If the object in question does not posess an 'id' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the identifier to be set, nor will it read or 
 * write 'id' attributes for those objects.
 *
 *
 * 
 * @param sid the string to use as the identifier of this object.
 *
 *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
 * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
 * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
 *
 * @see getIdAttribute()
 * @see setIdAttribute(string sid)
 * @see isSetIdAttribute()
 * @see unsetIdAttribute()
 * 
 *
   */ public new
 int setId(string sid) {
    int ret = libsbmlPINVOKE.SBase_setId(swigCPtr, sid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Sets the value of the 'id' attribute of this SBML object.
   *
   *
 * 
 * The string @p sid is copied.
 *
 *
 * 
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter ::= 'a'..'z','A'..'Z'
 *   digit  ::= '0'..'9'
 *   idChar ::= letter | digit | '_'
 *   SId    ::= ( letter | '_' ) idChar*
 * </pre>
 *
 * The characters <code>(</code> and <code>)</code> are used for grouping, the
 * character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
 * determined by an exact character sequence match; i.e., comparisons must be
 * performed in a case-sensitive manner.  This applies to all uses of <code>SId</code>, 
 * <code>SIdRef</code>, and derived types.
 *
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on SBase itself to get, set, check, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The exception to this rule is that for InitialAssignment, EventAssignment, 
 * AssignmentRule, and RateRule objects, the getId() function and the isSetId() 
 * functions (though not the setId() or unsetId() functions) would instead 
 * reference the value of the 'variable' attribute (for the rules and event 
 * assignments) or the 'symbol' attribute (for initial assignments).  
 * The AlgebraicRule fell into this category as well, though because it 
 * contained neither a 'variable' nor a 'symbol' attribute, getId() would 
 * always return an empty string, and isSetId() would always return @c false.
 * For this reason, four new functions are now provided 
 * (getIdAttribute(), setIdAttribute(@if java String@endif), 
 * isSetIdAttribute(), and unsetIdAttribute()) that will always
 * act on the actual 'id' attribute, regardless of the object's type.  The
 * new functions should be used instead of the old ones unless the old behavior
 * is somehow necessary.
 * 
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * identifiers).  If the object in question does not posess an 'id' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the identifier to be set, nor will it read or 
 * write 'id' attributes for those objects.
 *
 *
 * 
 * @param sid the string to use as the identifier of this object.
 *
 *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
 * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
 * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
 *
 * @see getIdAttribute()
 * @see setIdAttribute(string sid)
 * @see isSetIdAttribute()
 * @see unsetIdAttribute()
 * 
 *
   */ public new
 int setIdAttribute(string sid) {
    int ret = libsbmlPINVOKE.SBase_setIdAttribute(swigCPtr, sid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Sets the value of the 'name' attribute of this SBML object.
   *
   *
 * 
 *
 * The string in @p name is copied.
 *
 * @param name the new name for the SBML object.
 *
 *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
 * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
 *
 *
   */ public new
 int setName(string name) {
    int ret = libsbmlPINVOKE.SBase_setName(swigCPtr, name);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Sets the value of the 'annotation' subelement of this SBML object.
   *
   * The content of @p annotation is copied, and any previous content of
   * this object's 'annotation' subelement is deleted.
   * 
   * Whereas the SBase 'notes' subelement is a container for content to be
   * shown directly to humans, the 'annotation' element is a container for
   * optional software-generated content @em not meant to be shown to
   * humans.  Every object derived from SBase can have its own value for
   * 'annotation'.  The element's content type is <a target='_blank'
   * href='http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls'>XML type
   * 'any'</a>, allowing essentially arbitrary well-formed XML data
   * content.
   *
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   *
   * Call this method will result in any existing content of the
   * 'annotation' subelement to be discarded.  Unless you have taken steps
   * to first copy and reconstitute any existing annotations into the @p
   * annotation that is about to be assigned, it is likely that performing
   * such wholesale replacement is unfriendly towards other software
   * applications whose annotations are discarded.  An alternative may be
   * to use SBase::appendAnnotation(XMLNode annotation) or
   * SBase::appendAnnotation(string annotation).
   *
   * @param annotation an XML structure that is to be used as the new content
   * of the 'annotation' subelement of this object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif This particular
 * function only does one thing irrespective of user input or 
 * object state, and thus will only return a single value:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   *
   * @see getAnnotationString()
   * @see isSetAnnotation()
   * @see setAnnotation(string annotation)
   * @see appendAnnotation(XMLNode annotation)
   * @see appendAnnotation(string annotation)
   * @see unsetAnnotation()
   */ public new
 int setAnnotation(XMLNode annotation) {
    int ret = libsbmlPINVOKE.SBase_setAnnotation__SWIG_0(swigCPtr, XMLNode.getCPtr(annotation));
    return ret;
  }

  
/**
   * Sets the value of the 'annotation' subelement of this SBML object.
   *
   * The content of @p annotation is copied, and any previous content of
   * this object's 'annotation' subelement is deleted.
   * 
   * Whereas the SBase 'notes' subelement is a container for content to be
   * shown directly to humans, the 'annotation' element is a container for
   * optional software-generated content @em not meant to be shown to
   * humans.  Every object derived from SBase can have its own value for
   * 'annotation'.  The element's content type is <a target='_blank'
   * href='http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls'>XML type
   * 'any'</a>, allowing essentially arbitrary well-formed XML data
   * content.
   *
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   *
   * Call this method will result in any existing content of the
   * 'annotation' subelement to be discarded.  Unless you have taken steps
   * to first copy and reconstitute any existing annotations into the @p
   * annotation that is about to be assigned, it is likely that performing
   * such wholesale replacement is unfriendly towards other software
   * applications whose annotations are discarded.  An alternative may be
   * to use SBase::appendAnnotation(XMLNode annotation) or
   * SBase::appendAnnotation(string annotation).
   *
   * @param annotation an XML string that is to be used as the content
   * of the 'annotation' subelement of this object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   * @see getAnnotationString()
   * @see isSetAnnotation()
   * @see setAnnotation(XMLNode annotation)
   * @see appendAnnotation(XMLNode annotation)
   * @see appendAnnotation(string annotation)
   * @see unsetAnnotation()
   */ public new
 int setAnnotation(string annotation) {
    int ret = libsbmlPINVOKE.SBase_setAnnotation__SWIG_1(swigCPtr, annotation);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Appends the given @p annotation to the 'annotation' subelement of this
   * object.
   * 
   * Whereas the SBase 'notes' subelement is a container for content to be
   * shown directly to humans, the 'annotation' element is a container for
   * optional software-generated content @em not meant to be shown to
   * humans.  Every object derived from SBase can have its own value for
   * 'annotation'.  The element's content type is <a
   * target='_blank'
   * href='http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls'>XML type 'any'</a>,
   * allowing essentially arbitrary well-formed XML data content.
   *
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   *
   * Unlike SBase::setAnnotation(XMLNode annotation) or
   * SBase::setAnnotation(string annotation), this method
   * allows other annotations to be preserved when an application adds its
   * own data.
   *
   * @param annotation an XML structure that is to be copied and appended
   * to the content of the 'annotation' subelement of this object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   * (if the parent element does not have the 'metaid' attribute set)
   * @li @link libsbml#LIBSBML_DUPLICATE_ANNOTATION_NS LIBSBML_DUPLICATE_ANNOTATION_NS@endlink
   * (if the parent was already annotated with the annotation in question)
   *
   * @see getAnnotationString()
   * @see isSetAnnotation()
   * @see setAnnotation(XMLNode annotation)
   * @see setAnnotation(string annotation)
   * @see appendAnnotation(string annotation)
   * @see unsetAnnotation()
   */ public new
 int appendAnnotation(XMLNode annotation) {
    int ret = libsbmlPINVOKE.SBase_appendAnnotation__SWIG_0(swigCPtr, XMLNode.getCPtr(annotation));
    return ret;
  }

  
/**
   * Appends the given @p annotation to the 'annotation' subelement of this
   * object.
   *
   * Whereas the SBase 'notes' subelement is a container for content to be
   * shown directly to humans, the 'annotation' element is a container for
   * optional software-generated content @em not meant to be shown to
   * humans.  Every object derived from SBase can have its own value for
   * 'annotation'.  The element's content type is <a
   * target='_blank'
   * href='http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls'>XML type 'any'</a>,
   * allowing essentially arbitrary well-formed XML data content.
   *
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   *
   * Unlike SBase::setAnnotation(XMLNode annotation) or
   * SBase::setAnnotation(string annotation), this method
   * allows other annotations to be preserved when an application adds its
   * own data.
   *
   * @param annotation an XML string that is to be copied and appended
   * to the content of the 'annotation' subelement of this object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   * (if the parent element does not have the 'metaid' attribute set)
   * @li @link libsbml#LIBSBML_DUPLICATE_ANNOTATION_NS LIBSBML_DUPLICATE_ANNOTATION_NS@endlink
   * (if the parent was already annotated with the annotation in question)
   *
   * @see getAnnotationString()
   * @see isSetAnnotation()
   * @see setAnnotation(XMLNode annotation)
   * @see setAnnotation(string annotation)
   * @see appendAnnotation(XMLNode annotation)
   * @see unsetAnnotation()
   */ public new
 int appendAnnotation(string annotation) {
    int ret = libsbmlPINVOKE.SBase_appendAnnotation__SWIG_1(swigCPtr, annotation);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Removes the top-level element within the 'annotation' subelement of this
   * SBML object with the given name and optional URI.
   *
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   *
   * Calling this method allows a particular annotation element to be removed
   * whilst the remaining annotations remain intact.
   *
   * @param elementName a string representing the name of the top level
   * annotation element that is to be removed.
   * @param elementURI an optional string that is used to check both the name
   * and URI of the top level element to be removed.
   * @param removeEmpty if after removing of the element, the annotation is 
   * empty, and the removeEmpty argument is true, the annotation node will be 
   * deleted (default). 
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   * @li @link libsbml#LIBSBML_ANNOTATION_NAME_NOT_FOUND LIBSBML_ANNOTATION_NAME_NOT_FOUND@endlink
   * @li @link libsbml#LIBSBML_ANNOTATION_NS_NOT_FOUND LIBSBML_ANNOTATION_NS_NOT_FOUND@endlink
   *
   * @see replaceTopLevelAnnotationElement(XMLNode )
   * @see replaceTopLevelAnnotationElement(string)
   */ public
 int removeTopLevelAnnotationElement(string elementName, string elementURI, bool removeEmpty) {
    int ret = libsbmlPINVOKE.SBase_removeTopLevelAnnotationElement__SWIG_0(swigCPtr, elementName, elementURI, removeEmpty);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Removes the top-level element within the 'annotation' subelement of this
   * SBML object with the given name and optional URI.
   *
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   *
   * Calling this method allows a particular annotation element to be removed
   * whilst the remaining annotations remain intact.
   *
   * @param elementName a string representing the name of the top level
   * annotation element that is to be removed.
   * @param elementURI an optional string that is used to check both the name
   * and URI of the top level element to be removed.
   * @param removeEmpty if after removing of the element, the annotation is 
   * empty, and the removeEmpty argument is true, the annotation node will be 
   * deleted (default). 
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   * @li @link libsbml#LIBSBML_ANNOTATION_NAME_NOT_FOUND LIBSBML_ANNOTATION_NAME_NOT_FOUND@endlink
   * @li @link libsbml#LIBSBML_ANNOTATION_NS_NOT_FOUND LIBSBML_ANNOTATION_NS_NOT_FOUND@endlink
   *
   * @see replaceTopLevelAnnotationElement(XMLNode )
   * @see replaceTopLevelAnnotationElement(string)
   */ public
 int removeTopLevelAnnotationElement(string elementName, string elementURI) {
    int ret = libsbmlPINVOKE.SBase_removeTopLevelAnnotationElement__SWIG_1(swigCPtr, elementName, elementURI);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Removes the top-level element within the 'annotation' subelement of this
   * SBML object with the given name and optional URI.
   *
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   *
   * Calling this method allows a particular annotation element to be removed
   * whilst the remaining annotations remain intact.
   *
   * @param elementName a string representing the name of the top level
   * annotation element that is to be removed.
   * @param elementURI an optional string that is used to check both the name
   * and URI of the top level element to be removed.
   * @param removeEmpty if after removing of the element, the annotation is 
   * empty, and the removeEmpty argument is true, the annotation node will be 
   * deleted (default). 
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   * @li @link libsbml#LIBSBML_ANNOTATION_NAME_NOT_FOUND LIBSBML_ANNOTATION_NAME_NOT_FOUND@endlink
   * @li @link libsbml#LIBSBML_ANNOTATION_NS_NOT_FOUND LIBSBML_ANNOTATION_NS_NOT_FOUND@endlink
   *
   * @see replaceTopLevelAnnotationElement(XMLNode )
   * @see replaceTopLevelAnnotationElement(string)
   */ public
 int removeTopLevelAnnotationElement(string elementName) {
    int ret = libsbmlPINVOKE.SBase_removeTopLevelAnnotationElement__SWIG_2(swigCPtr, elementName);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Replaces the given top-level element within the 'annotation' 
   * subelement of this SBML object and with the annotation element supplied.
   *
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   *
   * This method determines the name of the element to be replaced from the
   * annotation argument. Functionally it is equivalent to calling <code>
   * removeTopLevelAnnotationElement(name)</code> followed by calling
   * <code>appendAnnotation(annotation_with_name)</code>, with the exception
   * that the placement of the annotation element remains the same.
   *
   * @param annotation XMLNode representing the replacement top level annotation.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   *
   * @see removeTopLevelAnnotationElement(string elementName, string elementURI, bool removeEmpty)
   * @see replaceTopLevelAnnotationElement(string)
   */ public
 int replaceTopLevelAnnotationElement(XMLNode annotation) {
    int ret = libsbmlPINVOKE.SBase_replaceTopLevelAnnotationElement__SWIG_0(swigCPtr, XMLNode.getCPtr(annotation));
    return ret;
  }

  
/**
   * Replaces the given top-level element within the 'annotation' 
   * subelement of this SBML object and with the annotation element supplied.
   *
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   *
   * This method determines the name of the element to be replaced from the
   * annotation argument. Functionally it is equivalent to calling <code>
   * removeTopLevelAnnotationElement(name)</code> followed by calling
   * <code>appendAnnotation(annotation_with_name)</code>, with the exception
   * that the placement of the annotation element remains the same.
   *
   * @param annotation string representing the replacement top level annotation.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   *
   * @see removeTopLevelAnnotationElement(string elementName, string elementURI)
   * @see replaceTopLevelAnnotationElement(XMLNode)
   */ public
 int replaceTopLevelAnnotationElement(string annotation) {
    int ret = libsbmlPINVOKE.SBase_replaceTopLevelAnnotationElement__SWIG_1(swigCPtr, annotation);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Sets the value of the 'notes' subelement of this SBML object.
   *
   * The content of @p notes is copied, and any existing content of this
   * object's 'notes' subelement is deleted.
   *
   * The optional SBML element named 'notes', present on every major SBML
   * component type, is intended as a place for storing optional
   * information intended to be seen by humans.  An example use of the
   * 'notes' element would be to contain formatted user comments about the
   * model element in which the 'notes' element is enclosed.  Every object
   * derived directly or indirectly from type SBase can have a separate
   * value for 'notes', allowing users considerable freedom when adding
   * comments to their models.
   *
   * The format of 'notes' elements must be <a target='_blank'
   * href='http://www.w3.org/TR/xhtml1/'>XHTML&nbsp;1.0</a>.  To help
   * verify the formatting of 'notes' content, libSBML provides the static
   * utility method SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode xhtml@endif); however,
   * readers are urged to consult the appropriate <a target='_blank'
   * href='http://sbml.org/Documents/Specifications'>SBML specification
   * document</a> for the Level and Version of their model for more
   * in-depth explanations.  The SBML Level&nbsp;2 and&nbsp;3
   * specifications have considerable detail about how 'notes' element
   * content must be structured.
   *
   * @param notes an XML structure that is to be used as the content of the
   * 'notes' subelement of this object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   *
   * @see getNotesString()
   * @see isSetNotes()
   * @see setNotes(string notes, bool addXHTMLMarkup)
   * @see appendNotes(XMLNode notes)
   * @see appendNotes(string notes)
   * @see unsetNotes()
   * @see SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode@endif)
   */ public
 int setNotes(XMLNode notes) {
    int ret = libsbmlPINVOKE.SBase_setNotes__SWIG_0(swigCPtr, XMLNode.getCPtr(notes));
    return ret;
  }

  
/**
   * Sets the value of the 'notes' subelement of this SBML object to a copy
   * of the string @p notes.
   *
   * The content of @p notes is copied, and any existing content of this
   * object's 'notes' subelement is deleted.
   *
   * The optional SBML element named 'notes', present on every major SBML
   * component type, is intended as a place for storing optional
   * information intended to be seen by humans.  An example use of the
   * 'notes' element would be to contain formatted user comments about the
   * model element in which the 'notes' element is enclosed.  Every object
   * derived directly or indirectly from type SBase can have a separate
   * value for 'notes', allowing users considerable freedom when adding
   * comments to their models.
   *
   * The format of 'notes' elements must be <a target='_blank'
   * href='http://www.w3.org/TR/xhtml1/'>XHTML&nbsp;1.0</a>.  To help
   * verify the formatting of 'notes' content, libSBML provides the static
   * utility method SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode@endif); however,
   * readers are urged to consult the appropriate <a target='_blank'
   * href='http://sbml.org/Documents/Specifications'>SBML specification
   * document</a> for the Level and Version of their model for more
   * in-depth explanations.  The SBML Level&nbsp;2 and&nbsp;3
   * specifications have considerable detail about how 'notes' element
   * content must be structured.
   *
   * The following code illustrates a very simple way of setting the notes
   * using this method.  Here, the object being annotated is the whole SBML
   * document, but that is for illustration purposes only; you could of
   * course use this same approach to annotate any other SBML component.
   * @if cpp
@code{.cpp}
SBMLDocument s = new SBMLDocument(3, 1);
s->setNotes('<body xmlns='http://www.w3.org/1999/xhtml'><p>here is my note</p></body>');
@endcode
@endif
@if java
@code{.java}
SBMLDocument s = new SBMLDocument(3, 1);
s.setNotes('<body xmlns='http://www.w3.org/1999/xhtml'><p>here is my note</p></body>');
@endcode
@endif
@if python
@code{.py}
try:
  sbmlDoc = SBMLDocument(3, 1)
except ValueError:
  print('Could not create SBMLDocument object')
  sys.exit(1)

note = '<body xmlns='http://www.w3.org/1999/xhtml'><p>here is my note</p></body>'

status = sbmlDoc.setNotes(note)
if status != LIBSBML_OPERATION_SUCCESS:
  # Do something to handle the error here.
  print('Unable to set notes on the SBML document object')
  sys.exit(1)
@endcode
@endif
@if csharp
@code
SBMLDocument s = new SBMLDocument(3, 1);
s.setNotes('<body xmlns='http://www.w3.org/1999/xhtml'><p>here is my note</p></body>');
@endcode
@endif
   *
   * @param notes an XML string that is to be used as the content of the
   * 'notes' subelement of this object.
   *
   * @param addXHTMLMarkup a boolean indicating whether to wrap the contents
   * of the @p notes argument with XHTML paragraph (<code>&lt;p&gt;</code>)
   * tags.  This is appropriate when the string in @p notes does not already
   * containg the appropriate XHTML markup.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   * @see getNotesString()
   * @see isSetNotes()
   * @see setNotes(XMLNode notes)
   * @see appendNotes(XMLNode notes)
   * @see appendNotes(string notes)
   * @see unsetNotes()
   * @see SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode@endif)
   */ public
 int setNotes(string notes, bool addXHTMLMarkup) {
    int ret = libsbmlPINVOKE.SBase_setNotes__SWIG_1(swigCPtr, notes, addXHTMLMarkup);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Sets the value of the 'notes' subelement of this SBML object to a copy
   * of the string @p notes.
   *
   * The content of @p notes is copied, and any existing content of this
   * object's 'notes' subelement is deleted.
   *
   * The optional SBML element named 'notes', present on every major SBML
   * component type, is intended as a place for storing optional
   * information intended to be seen by humans.  An example use of the
   * 'notes' element would be to contain formatted user comments about the
   * model element in which the 'notes' element is enclosed.  Every object
   * derived directly or indirectly from type SBase can have a separate
   * value for 'notes', allowing users considerable freedom when adding
   * comments to their models.
   *
   * The format of 'notes' elements must be <a target='_blank'
   * href='http://www.w3.org/TR/xhtml1/'>XHTML&nbsp;1.0</a>.  To help
   * verify the formatting of 'notes' content, libSBML provides the static
   * utility method SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode@endif); however,
   * readers are urged to consult the appropriate <a target='_blank'
   * href='http://sbml.org/Documents/Specifications'>SBML specification
   * document</a> for the Level and Version of their model for more
   * in-depth explanations.  The SBML Level&nbsp;2 and&nbsp;3
   * specifications have considerable detail about how 'notes' element
   * content must be structured.
   *
   * The following code illustrates a very simple way of setting the notes
   * using this method.  Here, the object being annotated is the whole SBML
   * document, but that is for illustration purposes only; you could of
   * course use this same approach to annotate any other SBML component.
   * @if cpp
@code{.cpp}
SBMLDocument s = new SBMLDocument(3, 1);
s->setNotes('<body xmlns='http://www.w3.org/1999/xhtml'><p>here is my note</p></body>');
@endcode
@endif
@if java
@code{.java}
SBMLDocument s = new SBMLDocument(3, 1);
s.setNotes('<body xmlns='http://www.w3.org/1999/xhtml'><p>here is my note</p></body>');
@endcode
@endif
@if python
@code{.py}
try:
  sbmlDoc = SBMLDocument(3, 1)
except ValueError:
  print('Could not create SBMLDocument object')
  sys.exit(1)

note = '<body xmlns='http://www.w3.org/1999/xhtml'><p>here is my note</p></body>'

status = sbmlDoc.setNotes(note)
if status != LIBSBML_OPERATION_SUCCESS:
  # Do something to handle the error here.
  print('Unable to set notes on the SBML document object')
  sys.exit(1)
@endcode
@endif
@if csharp
@code
SBMLDocument s = new SBMLDocument(3, 1);
s.setNotes('<body xmlns='http://www.w3.org/1999/xhtml'><p>here is my note</p></body>');
@endcode
@endif
   *
   * @param notes an XML string that is to be used as the content of the
   * 'notes' subelement of this object.
   *
   * @param addXHTMLMarkup a boolean indicating whether to wrap the contents
   * of the @p notes argument with XHTML paragraph (<code>&lt;p&gt;</code>)
   * tags.  This is appropriate when the string in @p notes does not already
   * containg the appropriate XHTML markup.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   * @see getNotesString()
   * @see isSetNotes()
   * @see setNotes(XMLNode notes)
   * @see appendNotes(XMLNode notes)
   * @see appendNotes(string notes)
   * @see unsetNotes()
   * @see SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode@endif)
   */ public
 int setNotes(string notes) {
    int ret = libsbmlPINVOKE.SBase_setNotes__SWIG_2(swigCPtr, notes);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Appends the given @p notes to the 'notes' subelement of this object.
   *
   * The content of @p notes is copied.
   *
   * The optional SBML element named 'notes', present on every major SBML
   * component type, is intended as a place for storing optional
   * information intended to be seen by humans.  An example use of the
   * 'notes' element would be to contain formatted user comments about the
   * model element in which the 'notes' element is enclosed.  Every object
   * derived directly or indirectly from type SBase can have a separate
   * value for 'notes', allowing users considerable freedom when adding
   * comments to their models.
   *
   * The format of 'notes' elements must be <a target='_blank'
   * href='http://www.w3.org/TR/xhtml1/'>XHTML&nbsp;1.0</a>.  To help
   * verify the formatting of 'notes' content, libSBML provides the static
   * utility method SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode@endif); however,
   * readers are urged to consult the appropriate <a target='_blank'
   * href='http://sbml.org/Documents/Specifications'>SBML specification
   * document</a> for the Level and Version of their model for more
   * in-depth explanations.  The SBML Level&nbsp;2 and&nbsp;3
   * specifications have considerable detail about how 'notes' element
   * content must be structured.
   * 
   * @param notes an XML node structure that is to appended to the content
   * of the 'notes' subelement of this object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   * @see getNotesString()
   * @see isSetNotes()
   * @see setNotes(XMLNode notes)
   * @see setNotes(string notes, bool addXHTMLMarkup)
   * @see appendNotes(string notes)
   * @see unsetNotes()
   * @see SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode@endif)
   */ public
 int appendNotes(XMLNode notes) {
    int ret = libsbmlPINVOKE.SBase_appendNotes__SWIG_0(swigCPtr, XMLNode.getCPtr(notes));
    return ret;
  }

  
/**
   * Appends the given @p notes to the 'notes' subelement of this object.
   *
   * The content of the parameter @p notes is copied.
   *
   * The optional SBML element named 'notes', present on every major SBML
   * component type, is intended as a place for storing optional
   * information intended to be seen by humans.  An example use of the
   * 'notes' element would be to contain formatted user comments about the
   * model element in which the 'notes' element is enclosed.  Every object
   * derived directly or indirectly from type SBase can have a separate
   * value for 'notes', allowing users considerable freedom when adding
   * comments to their models.
   *
   * The format of 'notes' elements must be <a target='_blank'
   * href='http://www.w3.org/TR/xhtml1/'>XHTML&nbsp;1.0</a>.  To help
   * verify the formatting of 'notes' content, libSBML provides the static
   * utility method SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode@endif); however,
   * readers are urged to consult the appropriate <a target='_blank'
   * href='http://sbml.org/Documents/Specifications'>SBML specification
   * document</a> for the Level and Version of their model for more
   * in-depth explanations.  The SBML Level&nbsp;2 and&nbsp;3
   * specifications have considerable detail about how 'notes' element
   * content must be structured.
   *
   * @param notes an XML string that is to appended to the content of
   * the 'notes' subelement of this object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   * @see getNotesString()
   * @see isSetNotes()
   * @see setNotes(XMLNode notes)
   * @see setNotes(string notes, bool addXHTMLMarkup)
   * @see appendNotes(XMLNode notes)
   * @see unsetNotes()
   * @see SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode@endif)
   */ public
 int appendNotes(string notes) {
    int ret = libsbmlPINVOKE.SBase_appendNotes__SWIG_1(swigCPtr, notes);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Sets the ModelHistory of this object.
   *
   * The content of @p history is copied, and this object's existing model
   * history content is deleted.
   *
   * @param history ModelHistory of this object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * 
   * @note In SBML Level&nbsp;2, model history annotations were only
   * permitted on the Model element.  In SBML Level&nbsp;3, they are
   * permitted on all SBML components derived from SBase.
   */ public
 int setModelHistory(ModelHistory history) {
    int ret = libsbmlPINVOKE.SBase_setModelHistory(swigCPtr, ModelHistory.getCPtr(history));
    return ret;
  }

  
/** */ /* libsbml-internal */ public new
 void connectToParent(SBase parent) {
    libsbmlPINVOKE.SBase_connectToParent(swigCPtr, SBase.getCPtr(parent));
  }

  public virtual void connectToChild() {
    libsbmlPINVOKE.SBase_connectToChild(swigCPtr);
  }

  
/**
   * Sets the value of the 'sboTerm' attribute.
   *
   * Beginning with SBML Level 2 Version 3, objects derived from SBase have
   * an optional attribute named 'sboTerm' for supporting the use of the
   * Systems Biology Ontology.  In SBML proper, the data type of the
   * attribute is a string of the form 'SBO:NNNNNNN', where 'NNNNNNN' is a
   * seven digit integer number; libSBML simplifies the representation by
   * only storing the 'NNNNNNN' integer portion.  Thus, in libSBML, the
   * 'sboTerm' attribute on SBase has data type @c int, and SBO identifiers
   * are stored simply as integers. 
   *
   * SBO terms are a type of optional annotation, and each different class
   * of SBML object derived from SBase imposes its own requirements about
   * the values permitted for 'sboTerm'.  Please consult the SBML
   * Level&nbsp;2 Version&nbsp;4 specification for more information about
   * the use of SBO and the 'sboTerm' attribute.
   *
   * @param value the NNNNNNN integer portion of the SBO identifier.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   *
   * @see setSBOTerm(string &sboid)
   */ public new
 int setSBOTerm(int value) {
    int ret = libsbmlPINVOKE.SBase_setSBOTerm__SWIG_0(swigCPtr, value);
    return ret;
  }

  
/**
   * Sets the value of the 'sboTerm' attribute by string.
   *
   * Beginning with SBML Level 2 Version 3, objects derived from SBase have
   * an optional attribute named 'sboTerm' for supporting the use of the
   * Systems Biology Ontology.  In SBML proper, the data type of the
   * attribute is a string of the form 'SBO:NNNNNNN', where 'NNNNNNN' is a
   * seven digit integer number; libSBML simplifies the representation by
   * only storing the 'NNNNNNN' integer portion.  Thus, in libSBML, the
   * 'sboTerm' attribute on SBase has data type @c int, and SBO identifiers
   * are stored simply as integers.  This method lets you set the value of
   * 'sboTerm' as a complete string of the form 'SBO:NNNNNNN', whereas
   * SBase::setSBOTerm(int value) allows you to set it using the integer form.
   *
   * SBO terms are a type of optional annotation, and each different class
   * of SBML object derived from SBase imposes its own requirements about
   * the values permitted for 'sboTerm'.  Please consult the SBML
   * Level&nbsp;2 Version&nbsp;4 specification for more information about
   * the use of SBO and the 'sboTerm' attribute.
   *
   * @param sboid the SBO identifier string of the form 'SBO:NNNNNNN'.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   *
   * @see setSBOTerm(int value)
   */ public new
 int setSBOTerm(string sboid) {
    int ret = libsbmlPINVOKE.SBase_setSBOTerm__SWIG_1(swigCPtr, sboid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Sets the namespaces relevant of this SBML object.
   *
   * The content of @p xmlns is copied, and this object's existing
   * namespace content is deleted.
   *
   * The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
   * information.  It is used to communicate the SBML Level, Version, and
   * (in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
   * 
   * @param xmlns the namespaces to set.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   */ public
 int setNamespaces(XMLNamespaces xmlns) {
    int ret = libsbmlPINVOKE.SBase_setNamespaces(swigCPtr, XMLNamespaces.getCPtr(xmlns));
    return ret;
  }

  
/**
   * Unsets the value of the 'metaid' attribute of this SBML object.
   *
   *
 * 
 * The optional attribute named 'metaid', present on every major SBML
 * component type, is for supporting metadata annotations using RDF (<a
 * href='http://www.w3.org/RDF/'>Resource Description Format</a>).  The
 * attribute value has the data type <a
 * href='http://www.w3.org/TR/REC-xml/#id'>XML <code>ID</code></a>, the XML
 * identifier type, which means each 'metaid' value must be globally unique
 * within an SBML file.  The latter point is important, because the
 * uniqueness criterion applies across <em>any</em> attribute with type
 * <code>ID</code> anywhere in the file, not just the 'metaid' attribute used
 * by SBML---something to be aware of if your application-specific XML
 * content inside the 'annotation' subelement happens to use the XML
 * <code>ID</code> type.  Although SBML itself specifies the use of <a
 * href='http://www.w3.org/TR/REC-xml/#id'>XML <code>ID</code></a> only for
 * the 'metaid' attribute, SBML-compatible applications should be careful if
 * they use XML <code>ID</code>'s in XML portions of a model that are not
 * defined by SBML, such as in the application-specific content of the
 * 'annotation' subelement.  Finally, note that LibSBML does not provide an
 * explicit XML <code>ID</code> data type; it uses ordinary character
 * strings, which is easier for applications to support.
 *
 * 
   *  
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   */ public
 int unsetMetaId() {
    int ret = libsbmlPINVOKE.SBase_unsetMetaId(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'id' attribute of this SBML object.
   *
   *
 *
 * 
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter ::= 'a'..'z','A'..'Z'
 *   digit  ::= '0'..'9'
 *   idChar ::= letter | digit | '_'
 *   SId    ::= ( letter | '_' ) idChar*
 * </pre>
 *
 * The characters <code>(</code> and <code>)</code> are used for grouping, the
 * character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
 * determined by an exact character sequence match; i.e., comparisons must be
 * performed in a case-sensitive manner.  This applies to all uses of <code>SId</code>, 
 * <code>SIdRef</code>, and derived types.
 *
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on SBase itself to get, set, check, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The exception to this rule is that for InitialAssignment, EventAssignment, 
 * AssignmentRule, and RateRule objects, the getId() function and the isSetId() 
 * functions (though not the setId() or unsetId() functions) would instead 
 * reference the value of the 'variable' attribute (for the rules and event 
 * assignments) or the 'symbol' attribute (for initial assignments).  
 * The AlgebraicRule fell into this category as well, though because it 
 * contained neither a 'variable' nor a 'symbol' attribute, getId() would 
 * always return an empty string, and isSetId() would always return @c false.
 * For this reason, four new functions are now provided 
 * (getIdAttribute(), setIdAttribute(@if java String@endif), 
 * isSetIdAttribute(), and unsetIdAttribute()) that will always
 * act on the actual 'id' attribute, regardless of the object's type.  The
 * new functions should be used instead of the old ones unless the old behavior
 * is somehow necessary.
 * 
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * identifiers).  If the object in question does not posess an 'id' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the identifier to be set, nor will it read or 
 * write 'id' attributes for those objects.
 *
 *
 * 
 *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
 * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
 *
 * @see getIdAttribute()
 * @see setIdAttribute(string sid)
 * @see isSetIdAttribute()
 * @see unsetIdAttribute()
 *
 *
   */ public new
 int unsetId() {
    int ret = libsbmlPINVOKE.SBase_unsetId(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'id' attribute of this SBML object.
   *
   * Most (but not all) objects in SBML include two common attributes: 'id'
   * and 'name'.  The identifier given by an object's 'id' attribute value
   * is used to identify the object within the SBML model definition.
   * Other objects can refer to the component using this identifier.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   * @see getIdAttribute()
   * @see setIdAttribute(string sid)
   * @see isSetIdAttribute()
   */ public
 int unsetIdAttribute() {
    int ret = libsbmlPINVOKE.SBase_unsetIdAttribute(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'name' attribute of this SBML object.
   *
   *
 *
 * 
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on SBase itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 *
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 * 
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 * 
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 *
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 *
 *
 * 
 *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
 * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
 *
 * @see getName()
 * @see setName(string sid)
 * @see isSetName()
 *
 *
   */ public new
 int unsetName() {
    int ret = libsbmlPINVOKE.SBase_unsetName(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'notes' subelement of this SBML object.
   *
   * The optional SBML element named 'notes', present on every major SBML
   * component type, is intended as a place for storing optional
   * information intended to be seen by humans.  An example use of the
   * 'notes' element would be to contain formatted user comments about the
   * model element in which the 'notes' element is enclosed.  Every object
   * derived directly or indirectly from type SBase can have a separate
   * value for 'notes', allowing users considerable freedom when adding
   * comments to their models.
   *
   * The format of 'notes' elements must be <a target='_blank'
   * href='http://www.w3.org/TR/xhtml1/'>XHTML&nbsp;1.0</a>.  To help
   * verify the formatting of 'notes' content, libSBML provides the static
   * utility method SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode@endif); however,
   * readers are urged to consult the appropriate <a target='_blank'
   * href='http://sbml.org/Documents/Specifications'>SBML specification
   * document</a> for the Level and Version of their model for more
   * in-depth explanations.  The SBML Level&nbsp;2 and&nbsp;3
   * specifications have considerable detail about how 'notes' element
   * content must be structured.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif This particular
 * function only does one thing irrespective of user input or 
 * object state, and thus will only return a single value:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   *
   * @see getNotesString()
   * @see isSetNotes()
   * @see setNotes(XMLNode notes)
   * @see setNotes(string notes, bool addXHTMLMarkup)
   * @see appendNotes(XMLNode notes)
   * @see appendNotes(string notes)
   * @see SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode@endif)
   */ public
 int unsetNotes() {
    int ret = libsbmlPINVOKE.SBase_unsetNotes(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'annotation' subelement of this SBML object.
   *
   * Whereas the SBase 'notes' subelement is a container for content to be
   * shown directly to humans, the 'annotation' element is a container for
   * optional software-generated content @em not meant to be shown to
   * humans.  Every object derived from SBase can have its own value for
   * 'annotation'.  The element's content type is <a target='_blank'
   * href='http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls'>XML type
   * 'any'</a>, allowing essentially arbitrary well-formed XML data
   * content.
   *
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif This particular
 * function only does one thing irrespective of user input or 
 * object state, and thus will only return a single value:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   *
   * @see getAnnotation()
   * @see getAnnotationString()
   * @see isSetAnnotation()
   * @see setAnnotation(XMLNode annotation)
   * @see setAnnotation(string annotation)
   * @see appendAnnotation(XMLNode annotation)
   * @see appendAnnotation(string annotation)
   */ public
 int unsetAnnotation() {
    int ret = libsbmlPINVOKE.SBase_unsetAnnotation(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'sboTerm' attribute of this SBML object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   */ public
 int unsetSBOTerm() {
    int ret = libsbmlPINVOKE.SBase_unsetSBOTerm(swigCPtr);
    return ret;
  }

  
/**
   * Adds a copy of the given CVTerm object to this SBML object.
   *
   * @param term the CVTerm to assign.
   *
   * @param newBag if @c true, creates a new RDF bag with the same identifier
   * as a previous bag, and if @c false, adds the term to an existing
   * RDF bag with the same type of qualifier as the term being added.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink, if
   * this object lacks a 'metaid' attribute
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   *
   * @note Since the CV Term uses the 'metaid' attribute of the object as a
   * reference, if the object has no 'metaid' attribute value set, then the
   * CVTerm will not be added.
   *
   *
 * @note This method should be used with some caution.  The fact that this
 * method @em copies the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
 *
 *
   * 
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 int addCVTerm(CVTerm term, bool newBag) {
    int ret = libsbmlPINVOKE.SBase_addCVTerm__SWIG_0(swigCPtr, CVTerm.getCPtr(term), newBag);
    return ret;
  }

  
/**
   * Adds a copy of the given CVTerm object to this SBML object.
   *
   * @param term the CVTerm to assign.
   *
   * @param newBag if @c true, creates a new RDF bag with the same identifier
   * as a previous bag, and if @c false, adds the term to an existing
   * RDF bag with the same type of qualifier as the term being added.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink, if
   * this object lacks a 'metaid' attribute
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   *
   * @note Since the CV Term uses the 'metaid' attribute of the object as a
   * reference, if the object has no 'metaid' attribute value set, then the
   * CVTerm will not be added.
   *
   *
 * @note This method should be used with some caution.  The fact that this
 * method @em copies the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
 *
 *
   * 
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 int addCVTerm(CVTerm term) {
    int ret = libsbmlPINVOKE.SBase_addCVTerm__SWIG_1(swigCPtr, CVTerm.getCPtr(term));
    return ret;
  }

  
/**
   * Returns a list of CVTerm objects in the annotations of this SBML
   * object.
   * 
   * @return the list of CVTerms for this SBML object.
   */ public
  CVTermList  getCVTerms() { 
  IntPtr cPtr = libsbmlPINVOKE.SBase_getCVTerms__SWIG_0(swigCPtr);
  return (cPtr == IntPtr.Zero) ? null : new CVTermList(cPtr, true);
}

  
/**
   * Returns the number of CVTerm objects in the annotations of this SBML
   * object.
   * 
   * @return the number of CVTerms for this SBML object.
   */ public
 long getNumCVTerms() { return (long)libsbmlPINVOKE.SBase_getNumCVTerms(swigCPtr); }

  
/**
   * Returns the nth CVTerm in the list of CVTerms of this SBML
   * object.
   * 
   * @param n unsigned int the index of the CVTerm to retrieve.
   *
   * @return the nth CVTerm in the list of CVTerms for this SBML object.
   */ public
 CVTerm getCVTerm(long n) {
    IntPtr cPtr = libsbmlPINVOKE.SBase_getCVTerm(swigCPtr, n);
    CVTerm ret = (cPtr == IntPtr.Zero) ? null : new CVTerm(cPtr, false);
    return ret;
  }

  
/**
   * Clears the list of CVTerm objects attached to this SBML object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   */ public
 int unsetCVTerms() {
    int ret = libsbmlPINVOKE.SBase_unsetCVTerms(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the ModelHistory object attached to this object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   * 
   * @note In SBML Level&nbsp;2, model history annotations were only
   * permitted on the Model element.  In SBML Level&nbsp;3, they are
   * permitted on all SBML components derived from SBase.
   */ public
 int unsetModelHistory() {
    int ret = libsbmlPINVOKE.SBase_unsetModelHistory(swigCPtr);
    return ret;
  }

  
/**
   * Returns the MIRIAM <em>biological qualifier</em> associated with the
   * given resource.
   *
   * In <a target='_blank' href='http://biomodels.net/miriam'>MIRIAM</a>,
   * qualifiers are an optional means of indicating the relationship
   * between a model component and its annotations.  There are two broad
   * kinds of annotations: <em>model</em> and <em>biological</em>.  The
   * latter kind is used to qualify the relationship between a model
   * component and a biological entity which it represents.  Examples of
   * relationships include 'is' and 'has part', but many others are
   * possible.  MIRIAM defines <a target='_blank'
   * href='http://www.ebi.ac.uk/miriam/main/qualifiers/'>numerous
   * relationship qualifiers</a> to enable different software tools to
   * qualify biological annotations in the same standardized way.  In
   * libSBML, the MIRIAM controlled-vocabulary annotations on an SBML model
   * element are represented using lists of CVTerm objects, and the
   * the MIRIAM biological qualifiers are represented using
   * values @if clike from the enumeration
   * type #BiolQualifierType_t.@endif@if python whose
   * names begin with <code>BQB_</code> in the interface class
   * @link libsbml libsbml@endlink.@endif@if java whose
   * names begin with <code>BQB_</code> in the interface class
   * {@link libsbmlConstants}.@endif@if csharp whose
   * names begin with <code>BQB_</code> in the interface class
   * @link libsbmlcs.libsbml libsbml@endlink.@endif
   *
   * This method searches the controlled-vocabulary annotations
   * (i.e., the list of CVTerm objects) on the present object, then out of
   * those that have biological qualifiers, looks for an annotation to the
   * given @p resource.  If such an annotation is found, it returns the
   * type of biological qualifier associated with that resource as a 
   * value @if clike from the enumeration type
   * #BiolQualifierType_t.@endif@if python whose name begins with
   * <code>BQB_</code> from the interface
   * class @link libsbml libsbml@endlink.@endif@if java whose name
   * begins with <code>BQB_</code> from the interface
   * class {@link libsbmlConstants}.@endif@if csharp whose
   * names begin with <code>BQB_</code> in the interface class
   * @link libsbmlcs.libsbml libsbml@endlink.@endif
   *
   * @param resource string representing the resource; e.g.,
   * <code>'http://www.geneontology.org/#GO:0005892'</code>.
   *
   * @return the qualifier associated with the resource,
   * or @link libsbml#BQB_UNKNOWN BQB_UNKNOWN@endlink if the
   * resource does not exist.
   *
   * @if clike
   * @note The set of MIRIAM biological qualifiers grows over
   * time, although relatively slowly.  The values in the enumeration
   * #BiolQualifierType_t are up to date with MIRIAM at the time of a given
   * libSBML release.  The set of values may be expanded in later libSBML
   * releases, to match the values defined by MIRIAM at that later time.
   * @endif@if python
   * @note The set of MIRIAM biological qualifiers grows over
   * time, although relatively slowly.  The values are up to date with
   * MIRIAM at the time of a given libSBML release.  The set of values in
   * list of <code>BQB_</code> constants defined in @link libsbml
   * libsbml@endlink may be expanded in later libSBML releases, to match
   * the values defined by MIRIAM at that later time.
   * @endif@if java
   * @note The set of MIRIAM biological qualifiers grows over
   * time, although relatively slowly.  The values are up to date with
   * MIRIAM at the time of a given libSBML release.  The set of values in
   * list of <code>BQB_</code> constants defined in {@link libsbmlConstants}
   * may be expanded in later libSBML releases, to match
   * the values defined by MIRIAM at that later time.
   * @endif@if csharp
   * @note The set of MIRIAM biological qualifiers grows over
   * time, although relatively slowly.  The values are up to date with
   * MIRIAM at the time of a given libSBML release.  The set of values in
   * list of <code>BQB_</code> constants defined in @link libsbmlcs.libsbml libsbml@endlink
   * may be expanded in later libSBML releases, to match
   * the values defined by MIRIAM at that later time.
   * @endif
   */ public
 int getResourceBiologicalQualifier(string resource) {
    int ret = libsbmlPINVOKE.SBase_getResourceBiologicalQualifier(swigCPtr, resource);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Returns the MIRIAM <em>model qualifier</em> associated with the
   * given resource.
   *
   * In <a target='_blank' href='http://biomodels.net/miriam'>MIRIAM</a>,
   * qualifiers are an optional means of indicating the relationship
   * between a model component and its annotations.  There are two broad
   * kinds of annotations: <em>model</em> and <em>biological</em>.  The
   * former kind is used to qualify the relationship between a model
   * component and another modeling object.  An example qualifier is
   * 'isDerivedFrom', to indicate that a given component of the model is
   * derived from the modeling object represented by the referenced
   * resource.  MIRIAM defines <a target='_blank'
   * href='http://www.ebi.ac.uk/miriam/main/qualifiers/'>numerous
   * relationship qualifiers</a> to enable different software tools to
   * qualify model annotations in the same standardized way.  In libSBML,
   * the MIRIAM controlled-vocabulary annotations on an SBML model element
   * are represented using lists of CVTerm objects, and the 
   * the MIRIAM model qualifiers are represented using
   * values @if clike from the enumeration
   * type #ModelQualifierType_t.@endif@if python whose
   * names begin with <code>BQM_</code> in the interface class
   * @link libsbml libsbml@endlink.@endif@if java whose
   * names begin with <code>BQM_</code> in the interface class
   * {@link libsbmlConstants}.@endif@if csharp whose
   * names begin with <code>BQB_</code> in the interface class
   * @link libsbmlcs.libsbml libsbml@endlink.@endif
   *
   * This method method searches the controlled-vocabulary annotations
   * (i.e., the list of CVTerm objects) on the present object, then out of
   * those that have model qualifiers, looks for an annotation to the given
   * @p resource.  If such an annotation is found, it returns the type of
   * type of model qualifier associated with that resource as a 
   * value @if clike from the enumeration type
   * #ModelQualifierType_t.@endif@if python whose name begins with
   * <code>BQM_</code> from the interface
   * class @link libsbml libsbml@endlink.@endif@if java whose name
   * begins with <code>BQM_</code> from the interface
   * class {@link libsbmlConstants}.@endif@if csharp whose
   * names begin with <code>BQB_</code> in the interface class
   * @link libsbmlcs.libsbml libsbml@endlink.@endif
   *
   * @param resource string representing the resource; e.g.,
   * <code>'http://www.geneontology.org/#GO:0005892'</code>.
   *
   * @return the @if clike #ModelQualifierType_t value@else model qualifier
   * type@endif associated with the resource, or @link libsbml#BQM_UNKNOWN BQM_UNKNOWN@endlink if the resource does not exist.
   *
   * @if clike
   * @note The set of MIRIAM biological qualifiers grows over
   * time, although relatively slowly.  The values in the enumeration
   * #ModelQualifierType_t are up to date with MIRIAM at the time of a given
   * libSBML release.  The set of values may be expanded in later libSBML
   * releases, to match the values defined by MIRIAM at that later time.
   * @endif@if python
   * @note The set of MIRIAM model qualifiers grows over
   * time, although relatively slowly.  The values are up to date with
   * MIRIAM at the time of a given libSBML release.  The set of values in
   * list of <code>BQM_</code> constants defined in @link libsbml
   * libsbml@endlink may be expanded in later libSBML releases, to match
   * the values defined by MIRIAM at that later time.
   * @endif@if java
   * @note The set of MIRIAM model qualifiers grows over
   * time, although relatively slowly.  The values are up to date with
   * MIRIAM at the time of a given libSBML release.  The set of values in
   * list of <code>BQM_</code> constants defined in {@link libsbmlConstants}
   * may be expanded in later libSBML releases, to match
   * the values defined by MIRIAM at that later time.
   * @endif@if csharp
   * @note The set of MIRIAM model qualifiers grows over
   * time, although relatively slowly.  The values are up to date with
   * MIRIAM at the time of a given libSBML release.  The set of values in
   * list of <code>BQM_</code> constants defined in @link libsbmlcs.libsbml libsbml@endlink
   * may be expanded in later libSBML releases, to match
   * the values defined by MIRIAM at that later time.
   * @endif
   */ public
 int getResourceModelQualifier(string resource) {
    int ret = libsbmlPINVOKE.SBase_getResourceModelQualifier(swigCPtr, resource);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Returns the Model object for the SBML Document in which the current object is located.
   * 
   * @return the Model object for the SBML Document of this SBML object.
   *
   * @see getParentSBMLObject()
   * @see getSBMLDocument()
   */ public
 Model getModel() {
    IntPtr cPtr = libsbmlPINVOKE.SBase_getModel(swigCPtr);
    Model ret = (cPtr == IntPtr.Zero) ? null : new Model(cPtr, false);
    return ret;
  }

  
/**
   * Returns the SBML Level of the SBMLDocument object containing @em this
   * object.
   * 
   *
 * 
 * LibSBML uses the class SBMLDocument as a top-level container for
 * storing SBML content and data associated with it (such as warnings and
 * error messages).  An SBML model in libSBML is contained inside an
 * SBMLDocument object.  SBMLDocument corresponds roughly to the class
 * <i>SBML</i> defined in the SBML Level&nbsp;3 and Level&nbsp;2
 * specifications, but it does not have a direct correspondence in SBML
 * Level&nbsp;1.  (But, it is created by libSBML no matter whether the
 * model is Level&nbsp;1, Level&nbsp;2 or Level&nbsp;3.)
 *
 *
   * 
   * @return the SBML level of this SBML object.
   * 
   * @see getVersion()
   * @see getNamespaces()
   * @see getPackageVersion()
   */ public
 long getLevel() { return (long)libsbmlPINVOKE.SBase_getLevel(swigCPtr); }

  
/**
   * Returns the Version within the SBML Level of the SBMLDocument object
   * containing @em this object.
   * 
   *
 * 
 * LibSBML uses the class SBMLDocument as a top-level container for
 * storing SBML content and data associated with it (such as warnings and
 * error messages).  An SBML model in libSBML is contained inside an
 * SBMLDocument object.  SBMLDocument corresponds roughly to the class
 * <i>SBML</i> defined in the SBML Level&nbsp;3 and Level&nbsp;2
 * specifications, but it does not have a direct correspondence in SBML
 * Level&nbsp;1.  (But, it is created by libSBML no matter whether the
 * model is Level&nbsp;1, Level&nbsp;2 or Level&nbsp;3.)
 *
 *
   * 
   * @return the SBML version of this SBML object.
   *
   * @see getLevel()
   * @see getNamespaces()
   */ public
 long getVersion() { return (long)libsbmlPINVOKE.SBase_getVersion(swigCPtr); }

  
/**
  * Returns the Version within the SBML Level of the actual object.
  *
  *
 * 
 * LibSBML uses the class SBMLDocument as a top-level container for
 * storing SBML content and data associated with it (such as warnings and
 * error messages).  An SBML model in libSBML is contained inside an
 * SBMLDocument object.  SBMLDocument corresponds roughly to the class
 * <i>SBML</i> defined in the SBML Level&nbsp;3 and Level&nbsp;2
 * specifications, but it does not have a direct correspondence in SBML
 * Level&nbsp;1.  (But, it is created by libSBML no matter whether the
 * model is Level&nbsp;1, Level&nbsp;2 or Level&nbsp;3.)
 *
 *
  *
  * @return the SBML version of this SBML object.
  */ public
 long getObjectVersion() { return (long)libsbmlPINVOKE.SBase_getObjectVersion(swigCPtr); }

  
/**
   * Returns the Version of the SBML Level&nbsp;3 package to which this
   * element belongs to.
   *
   * @return the version of the SBML Level&nbsp;3 package to which this
   * element belongs. The value @c 0 will be returned if this element
   * belongs to the SBML Level&nbsp;3 Core package.
   *
   * @see getLevel()
   * @see getVersion()
   */ public
 long getPackageVersion() { return (long)libsbmlPINVOKE.SBase_getPackageVersion(swigCPtr); }

  
/**
   * Returns the name of the SBML Level&nbsp;3 package in which this element
   * is defined.
   *
   * @return the name of the SBML package in which this element is defined.
   * The string <code>&quot;core&quot;</code> will be returned if this
   * element is defined in SBML Level&nbsp;3 Core. The string
   * <code>&quot;unknown&quot;</code> will be returned if this element is
   * not defined in any SBML package.
   */ public
 string getPackageName() {
    string ret = libsbmlPINVOKE.SBase_getPackageName(swigCPtr);
    return ret;
  }

  
/**
   * Returns the libSBML type code for this object.
   *
   *
 * 
 * LibSBML attaches an identifying code to every kind of SBML object.  These
 * are integer constants known as <em>SBML type codes</em>.  The names of all
 * the codes begin with the characters <code>SBML_</code>.
 * @if clike The set of possible type codes for core elements is defined in
 * the enumeration #SBMLTypeCode_t, and in addition, libSBML plug-ins for
 * SBML Level&nbsp;3 packages define their own extra enumerations of type
 * codes (e.g., #SBMLLayoutTypeCode_t for the Level&nbsp;3 Layout
 * package).@endif@if java In the Java language interface for libSBML, the
 * type codes are defined as static integer constants in the interface class
 * {@link libsbmlConstants}.  @endif@if python In the Python language
 * interface for libSBML, the type codes are defined as static integer
 * constants in the interface class @link libsbml@endlink.@endif@if csharp In
 * the C# language interface for libSBML, the type codes are defined as
 * static integer constants in the interface class
 * @link libsbmlcs.libsbml@endlink.@endif  Note that different Level&nbsp;3
 * package plug-ins may use overlapping type codes; to identify the package
 * to which a given object belongs, call the <code>getPackageName()</code>
 * method on the object.
 *
 *
   *
   *
 * 
 * Here follow some additional general information about libSBML type codes:
 *
 * @li The codes are the possible return values (integers) for the following
 * functions:
 * <ul>
 *     <li> SBase::getTypeCode()
 *     <li> ListOf::getItemTypeCode()
 * </ul>
 * (Compatibility note: in libSBML 5, the type of return values of these
 * functions changed from an enumeration to an integer for extensibility
 * in the face of different programming languages.)
 *
 * @li Each package extension must define similar sets of values for each
 * SBase subclass (e.g. <code>SBMLLayoutTypeCode_t</code> for the SBML Level&nbsp;3
 * %Layout extension, <code>SBMLFbcTypeCode_t</code> for the SBML Level&nbsp;3 Flux
 * Balance Constraints extension, etc.).
 *
 * @li The value of each package-specific type code can be duplicated between
 * those of different packages.  (This is necessary because the development
 * of libSBML extensions for different SBML packages may be undertaken by
 * different developers at different times; requiring the developers to
 * coordinate their use of type codes would be nettlesome and probably
 * doomed to failure.)
 *
 * @li To distinguish between the type codes of different packages, both the
 * return value of SBase::getTypeCode() and SBase::getPackageName() must be
 * checked.  This is particularly important for functions that take an SBML
 * type code as an argument, such as
 * SBase::getAncestorOfType(@if java int, String@endif), which by
 * default assumes you are handing it a core type, and will return @c null if
 * the value you give it is actually from a package.
 *
 * The following example code illustrates the combined use of
 * SBase::getPackageName() and SBase::getTypeCode():
 * @if cpp
 * @code{.cpp}
 void example (SBase sb)
 {
   cons string pkgName = sb->getPackageName();
   if (pkgName == 'core')
   {
     switch (sb->getTypeCode())
     {
       case SBML_MODEL:
          ....
          break;
       case SBML_REACTION:
          ....
     }
   }
   else if (pkgName == 'layout')
   {
     switch (sb->getTypeCode())
     {
       case SBML_LAYOUT_LAYOUT:
          ....
          break;
       case SBML_LAYOUT_REACTIONGLYPH:
          ....
     }
   }
   ...
 }
@endcode
@endif
@if python
@code{.py}
def example(item):
  pkg_name  = item.getPackageName()
  type_code = item.getTypeCode()
  if pkg_name == 'core':
    print('Got a ' + SBMLTypeCode_toString(type_code, 'core') + ' object')
    if type_code == SBML_MODEL:
      print('This is a very, very nice model')
      # Do whatever the application wants to do with the model.
    elif type_code == SBML_COMPARTMENT:
      print('This is a very, very nice compartment')
      # Do whatever the application wants to do with the compartment.
    elif type_code == SBML_SPECIES:
      print('This is a very, very nice species')
      # Do whatever the application wants to do with the species.
    elif ...
      ...
  elif pkg_name == 'layout':
    print('Got a ' + SBMLTypeCode_toString(type_code, 'layout') + ' object')
    if type_code == SBML_LAYOUT_POINT:
      print('This is a very, very nice layout point')
      # Do whatever the application wants to do with the layout point.
    elif type_code == SBML_LAYOUT_BOUNDINGBOX:
      print('This is a very, very nice layout bounding box')
      # Do whatever the application wants to do with the layout bounding box.
    elif ...
      ...
  elif pkg_name == 'unknown':
    print('Something went wrong -- libSBML did not recognize the object type')
    # Handle errors
@endcode
@endif
@if java
@code{.java}
void example (SBase sb)
{
  String pkgName = sb.getPackageName();
  if (pkgName.equals('core'))
  {
    switch (sb.getTypeCode())
    {
      case libsbml.SBML_MODEL:
         ....
         break;
      case libsbml.SBML_REACTION:
         ....
    }
  }
  else if (pkgName.equals('layout'))
  {
    switch (sb.getTypeCode())
    {
      case libsbml.SBML_LAYOUT_LAYOUT:
         ....
         break;
      case libsbml.SBML_LAYOUT_REACTIONGLYPH:
         ....
    }
  }
  ...
}
@endcode
@endif
 *
 *
   *
   * @return the @if clike #SBMLTypeCode_t value@else SBML object type
   * code@endif of this SBML object, or @link libsbml#SBML_UNKNOWN SBML_UNKNOWN@endlink (the default).  The latter is possible because
   * subclasses of SBase are not required to implement this method to return
   * a type code.
   *
   *
 * @warning <span class='warning'>The specific integer values of the possible
 * type codes may be reused by different libSBML plug-ins for SBML Level&nbsp;3.
 * packages,  To fully identify the correct code, <strong>it is necessary to
 * invoke both getTypeCode() and getPackageName()</strong>.</span>
 *
 *
   *
   * @see getPackageName()
   * @see getElementName()
   */ public new
 int getTypeCode() {
    int ret = libsbmlPINVOKE.SBase_getTypeCode(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this object's level/version and namespace
   * values correspond to a valid SBML specification.
   *
   * The valid combinations of SBML Level, Version and Namespace as of this
   * release of libSBML are the following:
   * <ul>
   * <li> Level&nbsp;1 Version&nbsp;2: &quot;<code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://www.sbml.org/sbml/level1</code>&quot;
   * <li> Level&nbsp;2 Version&nbsp;1: &quot;<code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://www.sbml.org/sbml/level2</code>&quot;
   * <li> Level&nbsp;2 Version&nbsp;2: &quot;<code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://www.sbml.org/sbml/level2/version2</code>&quot;
   * <li> Level&nbsp;2 Version&nbsp;3: &quot;<code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://www.sbml.org/sbml/level2/version3</code>&quot;
   * <li> Level&nbsp;2 Version&nbsp;4: &quot;<code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://www.sbml.org/sbml/level2/version4</code>&quot;
   * <li> Level&nbsp;2 Version&nbsp;5: &quot;<code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://www.sbml.org/sbml/level2/version5</code>&quot;
   * <li> Level&nbsp;3 Version&nbsp;1 Core: &quot;<code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://www.sbml.org/sbml/level3/version1/core</code>&quot;
   * <li> Level&nbsp;3 Version&nbsp;2 Core: &quot;<code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://www.sbml.org/sbml/level3/version2/core</code>&quot;
   * </ul>
   *
   * @return @c true if the level, version and namespace values of this 
   * SBML object correspond to a valid set of values, @c false otherwise.
   */ public
 bool hasValidLevelVersionNamespaceCombination() {
    bool ret = libsbmlPINVOKE.SBase_hasValidLevelVersionNamespaceCombination(swigCPtr);
    return ret;
  }

  
/**
   * Returns the XML element name of this object.
   *
   * This is overridden by subclasses to return a string appropriate to the
   * SBML component.  For example, Model defines it as returning @c
   * 'model', CompartmentType defines it as returning @c 'compartmentType',
   * and so on.
   */ public new
 string getElementName() {
    string ret = libsbmlPINVOKE.SBase_getElementName(swigCPtr);
    return ret;
  }

  
/**
   * Returns a string consisting of a partial SBML corresponding to just
   * this object.
   * 
   * @return the partial SBML that describes this SBML object.
   *
   * @warning <span class='warning'>This is primarily provided for testing
   * and debugging purposes.  It may be removed in a future version of
   * libSBML.</span>
   */ public
 string toSBML() {
    string ret = libsbmlPINVOKE.SBase_toSBML(swigCPtr);
    return ret;
  }

  
/**
   * Returns this element as an XMLNode.
   *
   * @return this element as an XMLNode.
   *
   * @warning <span class='warning'>This operation is computationally
   * expensive, because the element has to be fully serialized to a string
   * and then parsed into the XMLNode structure.  Attempting to convert a
   * large tree structure (e.g., a large Model) may consume significant
   * computer memory and time.</span>
   */ public
 XMLNode toXMLNode() {
    IntPtr cPtr = libsbmlPINVOKE.SBase_toXMLNode(swigCPtr);
    XMLNode ret = (cPtr == IntPtr.Zero) ? null : new XMLNode(cPtr, false);
    return ret;
  }

  
/**
   * Returns a plug-in object (extension interface) for an SBML Level&nbsp;3
   * package extension with the given package name or URI.
   *
   *
 * 
 * SBML Level&nbsp;3 consists of a <em>Core</em> definition that can be extended
 * via optional SBML Level&nbsp;3 <em>packages</em>.  A given model may indicate
 * that it uses one or more SBML packages, and likewise, a software tool may be
 * able to support one or more packages.  LibSBML does not come preconfigured
 * with all possible packages included and enabled, in part because not all
 * package specifications have been finalized.  To support the ability for
 * software systems to enable support for the Level&nbsp;3 packages they choose,
 * libSBML features a <em>plug-in</em> mechanism.  Each SBML Level&nbsp;3
 * package is implemented in a separate code plug-in that can be enabled by the
 * application to support working with that SBML package.  A given SBML model
 * may thus contain not only objects defined by SBML Level&nbsp;3 Core, but also
 * objects created by libSBML plug-ins supporting additional Level&nbsp;3
 * packages.
 *
 *
   *
   * @param package the name or URI of the package.
   *
   * @return the plug-in object (the libSBML extension interface) of
   * a package extension with the given package name or URI.
   *
   * @see getPlugin(unsigned int n)
   */ public
 SBasePlugin getPlugin(string package) {
        SBasePlugin ret = (SBasePlugin) libsbml.DowncastSBasePlugin(libsbmlPINVOKE.SBase_getPlugin__SWIG_0(swigCPtr, package), false);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
        return ret;
}

  
/**
   * Returns the nth plug-in object (extension interface) for an SBML Level&nbsp;3
   * package extension.
   *
   *
 * 
 * SBML Level&nbsp;3 consists of a <em>Core</em> definition that can be extended
 * via optional SBML Level&nbsp;3 <em>packages</em>.  A given model may indicate
 * that it uses one or more SBML packages, and likewise, a software tool may be
 * able to support one or more packages.  LibSBML does not come preconfigured
 * with all possible packages included and enabled, in part because not all
 * package specifications have been finalized.  To support the ability for
 * software systems to enable support for the Level&nbsp;3 packages they choose,
 * libSBML features a <em>plug-in</em> mechanism.  Each SBML Level&nbsp;3
 * package is implemented in a separate code plug-in that can be enabled by the
 * application to support working with that SBML package.  A given SBML model
 * may thus contain not only objects defined by SBML Level&nbsp;3 Core, but also
 * objects created by libSBML plug-ins supporting additional Level&nbsp;3
 * packages.
 *
 *
   *
   * @param n the index of the plug-in to return.
   *
   * @return the nth plug-in object (the libSBML extension interface) of a
   * package extension.
   *
   * @see getNumPlugins()
   * @see getPlugin(string package)
   */ public
 SBasePlugin getPlugin(long n) {
        SBasePlugin ret = (SBasePlugin) libsbml.DowncastSBasePlugin(libsbmlPINVOKE.SBase_getPlugin__SWIG_2(swigCPtr, n), false);
        return ret;
}

  
/**
   * Returns the nth disabled plug-in object (extension interface) for an SBML Level&nbsp;3
   * package extension.
   *
   *
 * 
 * SBML Level&nbsp;3 consists of a <em>Core</em> definition that can be extended
 * via optional SBML Level&nbsp;3 <em>packages</em>.  A given model may indicate
 * that it uses one or more SBML packages, and likewise, a software tool may be
 * able to support one or more packages.  LibSBML does not come preconfigured
 * with all possible packages included and enabled, in part because not all
 * package specifications have been finalized.  To support the ability for
 * software systems to enable support for the Level&nbsp;3 packages they choose,
 * libSBML features a <em>plug-in</em> mechanism.  Each SBML Level&nbsp;3
 * package is implemented in a separate code plug-in that can be enabled by the
 * application to support working with that SBML package.  A given SBML model
 * may thus contain not only objects defined by SBML Level&nbsp;3 Core, but also
 * objects created by libSBML plug-ins supporting additional Level&nbsp;3
 * packages.
 *
 *
   *
   *
 * 
 * If a plugin is <em>disabled</em>, the package information it contains is
 * no longer considered to be part of the SBML document for the purposes of
 * searching the document or writing out the document.  However, the information
 * is still retained, so if the plugin is enabled again, the same information
 * will once again be available, and will be written out to the final model.
 *
 *
   *
   * @param n the index of the disabled plug-in to return.
   *
   * @return the nth disabled plug-in object (the libSBML extension interface) of a
   * package extension.
   *
   * @see getNumDisabledPlugins()
   * @see getPlugin(string package)
   */ public
 SBasePlugin getDisabledPlugin(long n) {
        SBasePlugin ret = (SBasePlugin) libsbml.DowncastSBasePlugin(libsbmlPINVOKE.SBase_getDisabledPlugin__SWIG_0(swigCPtr, n), false);
        return ret;
}

  
/**
   * Returns the number of plug-in objects (extenstion interfaces) for SBML
   * Level&nbsp;3 package extensions known.
   *
   *
 * 
 * SBML Level&nbsp;3 consists of a <em>Core</em> definition that can be extended
 * via optional SBML Level&nbsp;3 <em>packages</em>.  A given model may indicate
 * that it uses one or more SBML packages, and likewise, a software tool may be
 * able to support one or more packages.  LibSBML does not come preconfigured
 * with all possible packages included and enabled, in part because not all
 * package specifications have been finalized.  To support the ability for
 * software systems to enable support for the Level&nbsp;3 packages they choose,
 * libSBML features a <em>plug-in</em> mechanism.  Each SBML Level&nbsp;3
 * package is implemented in a separate code plug-in that can be enabled by the
 * application to support working with that SBML package.  A given SBML model
 * may thus contain not only objects defined by SBML Level&nbsp;3 Core, but also
 * objects created by libSBML plug-ins supporting additional Level&nbsp;3
 * packages.
 *
 *
   *
   * @return the number of plug-in objects (extension interfaces) of
   * package extensions known by this instance of libSBML.
   *
   * @see getPlugin(unsigned int n)
   */ public
 long getNumPlugins() { return (long)libsbmlPINVOKE.SBase_getNumPlugins(swigCPtr); }

  
/**
   * Returns the number of disabled plug-in objects (extension interfaces) 
   * for SBML Level&nbsp;3 package extensions known.
   *
   *
 * 
 * SBML Level&nbsp;3 consists of a <em>Core</em> definition that can be extended
 * via optional SBML Level&nbsp;3 <em>packages</em>.  A given model may indicate
 * that it uses one or more SBML packages, and likewise, a software tool may be
 * able to support one or more packages.  LibSBML does not come preconfigured
 * with all possible packages included and enabled, in part because not all
 * package specifications have been finalized.  To support the ability for
 * software systems to enable support for the Level&nbsp;3 packages they choose,
 * libSBML features a <em>plug-in</em> mechanism.  Each SBML Level&nbsp;3
 * package is implemented in a separate code plug-in that can be enabled by the
 * application to support working with that SBML package.  A given SBML model
 * may thus contain not only objects defined by SBML Level&nbsp;3 Core, but also
 * objects created by libSBML plug-ins supporting additional Level&nbsp;3
 * packages.
 *
 *
   *
   *
 * 
 * If a plugin is <em>disabled</em>, the package information it contains is
 * no longer considered to be part of the SBML document for the purposes of
 * searching the document or writing out the document.  However, the information
 * is still retained, so if the plugin is enabled again, the same information
 * will once again be available, and will be written out to the final model.
 *
 *
   *
   * @return the number of disabled plug-in objects (extension interfaces) 
   * of package extensions known by this instance of libSBML.
   *
   */ public
 long getNumDisabledPlugins() { return (long)libsbmlPINVOKE.SBase_getNumDisabledPlugins(swigCPtr); }

  
/**
   * Deletes all information stored in disabled plugins.  If the plugin is 
   * re-enabled later, it will then not have any previously-stored information.
   *
   *
 * 
 * SBML Level&nbsp;3 consists of a <em>Core</em> definition that can be extended
 * via optional SBML Level&nbsp;3 <em>packages</em>.  A given model may indicate
 * that it uses one or more SBML packages, and likewise, a software tool may be
 * able to support one or more packages.  LibSBML does not come preconfigured
 * with all possible packages included and enabled, in part because not all
 * package specifications have been finalized.  To support the ability for
 * software systems to enable support for the Level&nbsp;3 packages they choose,
 * libSBML features a <em>plug-in</em> mechanism.  Each SBML Level&nbsp;3
 * package is implemented in a separate code plug-in that can be enabled by the
 * application to support working with that SBML package.  A given SBML model
 * may thus contain not only objects defined by SBML Level&nbsp;3 Core, but also
 * objects created by libSBML plug-ins supporting additional Level&nbsp;3
 * packages.
 *
 *
   *
   *
 * 
 * If a plugin is <em>disabled</em>, the package information it contains is
 * no longer considered to be part of the SBML document for the purposes of
 * searching the document or writing out the document.  However, the information
 * is still retained, so if the plugin is enabled again, the same information
 * will once again be available, and will be written out to the final model.
 *
 *
   *
   * @param recursive if @c true, the disabled information will be deleted
   * also from all child elements, otherwise only from this SBase element.
   *
   * @see getNumDisabledPlugins()
   */ public
 void deleteDisabledPlugins(bool recursive) {
    libsbmlPINVOKE.SBase_deleteDisabledPlugins__SWIG_0(swigCPtr, recursive);
  }

  
/**
   * Deletes all information stored in disabled plugins.  If the plugin is 
   * re-enabled later, it will then not have any previously-stored information.
   *
   *
 * 
 * SBML Level&nbsp;3 consists of a <em>Core</em> definition that can be extended
 * via optional SBML Level&nbsp;3 <em>packages</em>.  A given model may indicate
 * that it uses one or more SBML packages, and likewise, a software tool may be
 * able to support one or more packages.  LibSBML does not come preconfigured
 * with all possible packages included and enabled, in part because not all
 * package specifications have been finalized.  To support the ability for
 * software systems to enable support for the Level&nbsp;3 packages they choose,
 * libSBML features a <em>plug-in</em> mechanism.  Each SBML Level&nbsp;3
 * package is implemented in a separate code plug-in that can be enabled by the
 * application to support working with that SBML package.  A given SBML model
 * may thus contain not only objects defined by SBML Level&nbsp;3 Core, but also
 * objects created by libSBML plug-ins supporting additional Level&nbsp;3
 * packages.
 *
 *
   *
   *
 * 
 * If a plugin is <em>disabled</em>, the package information it contains is
 * no longer considered to be part of the SBML document for the purposes of
 * searching the document or writing out the document.  However, the information
 * is still retained, so if the plugin is enabled again, the same information
 * will once again be available, and will be written out to the final model.
 *
 *
   *
   * @param recursive if @c true, the disabled information will be deleted
   * also from all child elements, otherwise only from this SBase element.
   *
   * @see getNumDisabledPlugins()
   */ public
 void deleteDisabledPlugins() {
    libsbmlPINVOKE.SBase_deleteDisabledPlugins__SWIG_1(swigCPtr);
  }

  
/**
   * Enables or disables the given SBML Level&nbsp;3 package on this object.
   *
   * This method enables the specified package on this object and other
   * objects connected by child-parent links in the same SBMLDocument object.
   * This method is the converse of
   * SBase::disablePackage(string pkgURI, string pkgPrefix).
   *
   * @param pkgURI the URI of the package.
   * 
   * @param pkgPrefix the XML prefix of the package.
   * 
   * @param flag whether to enable (@c true) or disable (@c false) the package.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_PKG_UNKNOWN LIBSBML_PKG_UNKNOWN@endlink
   * @li @link libsbml#LIBSBML_PKG_VERSION_MISMATCH LIBSBML_PKG_VERSION_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_PKG_CONFLICTED_VERSION LIBSBML_PKG_CONFLICTED_VERSION@endlink
   *
   * @see disablePackage(string pkgURI, string pkgPrefix)
   */ public
 int enablePackage(string pkgURI, string pkgPrefix, bool flag) {
    int ret = libsbmlPINVOKE.SBase_enablePackage(swigCPtr, pkgURI, pkgPrefix, flag);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Disables the given SBML Level&nbsp;3 package on this object.
   *
   * This method disables the specified package on this object
   * and other objects connected by child-parent links in the same
   * SBMLDocument object.
   * 
   * An example of when this may be useful is during construction of model
   * components when mixing existing and new models.  Suppose your
   * application read an SBML document containing a model that used the SBML
   * Hierarchical %Model Composition (&ldquo;comp&rdquo;) package, and
   * extracted parts of that model in order to construct a new model in
   * memory.  The new, in-memory model will not accept a component drawn from
   * an other SBMLDocument with different package namespace declarations.
   * You could reconstruct the same namespaces in the in-memory model first,
   * but as a shortcut, you could also disable the package namespace on the
   * object being added.  Here is a code example to help clarify this:
   * @if cpp
@code{.cpp}
// We read in an SBML L3V1 model that uses the 'comp'
// package namespace.
doc = readSBML('sbml-file-with-comp-elements.xml');

// We extract one of the species from the model.
Species s1 = doc->getModel()->getSpecies(0);

// We construct a new model.  This model does not use the
// 'comp' package.
Model  newModel = new Model(3,1);

// The following will fail with an error, because addSpecies()
// will first check that the parent of the given object has
// namespaces declared, and will discover that s1 does but
// newModel does not.

// newModel->addSpecies(s1);

// However, if we disable the 'comp' package on s1, then
// the call to addSpecies will work.

s1->disablePackage('http://www.sbml.org/sbml/level3/version1/comp/version1',
                   'comp');
newModel->addSpecies(s1);
@endcode
@endif
@if python
@code{.py}
import sys
import os.path
from libsbml import *

# We read an SBML L3V1 model that uses the 'comp' package.

doc = readSBML('sbml-file-with-comp-elements.xml');
if doc.getNumErrors() > 0:
  print('readSBML encountered errors while reading the file.')
  doc.printErrors()
  sys.exit(1)

# We extract one of the species from the model.

model = doc.getModel()
if model == None:
  print('Unable to retrieve Model object')
  sys.exit(1)

s1 = model.getSpecies(0)
if s1 == None:
  print('Unable to retrieve Species object')
  sys.exit(1)

# We construct a new model.
# This model does not use the 'comp' package.

try:
  newDoc = SBMLDocument(3, 1)
except ValueError:
  print('Could not create SBMLDocument object')
  sys.exit(1)

newModel = newDoc.createModel()
if newModel == None:
  print('Unable to create new Model object')
  sys.exit(1)

# The following would normally fail with an error, because
# addSpecies() would first check that the parent of the given
# object has namespaces declared, and will discover that s1
# does but newModel does not.

#   newModel.addSpecies(s1)

# However, if we disable the 'comp' package on s1, then the
# call to addSpecies will work.

compNS = 'http://www.sbml.org/sbml/level3/version1/comp/version1'
status = s1.disablePackage(compNS, 'comp')
if status != LIBSBML_OPERATION_SUCCESS:
  print('Unable to disable package.')
  sys.exit(1)

newSpecies = newModel.addSpecies(s1)   # This will work now.
if newSpecies == None:
  print('Could not add Species')       # (This will not happen,
  sys.exit(1)                          # but always check errors.)
@endcode
@endif
@if java
@code{.java}
// We read in an SBML L3V1 model that uses the 'comp' package namespace
SBMLReader reader = new SBMLReader();
SBMLDocument doc = reader.readSBML('sbml-file-with-comp-elements.xml');

// We extract one of the species from the model we just read in.
Species s1 = doc.getModel().getSpecies(0);

// We construct a new model.  This model does not use the 'comp' package.
Model newModel = new Model(3,1);

// The following will fail with an error, because addSpecies() will
// first check that the parent of the given object has namespaces
// declared, and will discover that s1 does but newModel does not.

// newModel->addSpecies(s1);

// However, if we disable the 'comp' package on s1, then the call
// to addSpecies will work.

s1->disablePackage('http://www.sbml.org/sbml/level3/version1/comp/version1',
                   'comp');
newModel.addSpecies(s1);
@endcode
@endif
   *
   * @param pkgURI the URI of the package.
   * 
   * @param pkgPrefix the XML prefix of the package.
   * 
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_PKG_UNKNOWN LIBSBML_PKG_UNKNOWN@endlink
   * @li @link libsbml#LIBSBML_PKG_VERSION_MISMATCH LIBSBML_PKG_VERSION_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_PKG_CONFLICTED_VERSION LIBSBML_PKG_CONFLICTED_VERSION@endlink
   *
   * @see enablePackage(string pkgURI, string pkgPrefix, bool flag)
   */ public
 int disablePackage(string pkgURI, string pkgPrefix) {
    int ret = libsbmlPINVOKE.SBase_disablePackage(swigCPtr, pkgURI, pkgPrefix);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/** */ /* libsbml-internal */ public new
 void enablePackageInternal(string pkgURI, string pkgPrefix, bool flag) {
    libsbmlPINVOKE.SBase_enablePackageInternal(swigCPtr, pkgURI, pkgPrefix, flag);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Predicate returning @c true if an SBML Level&nbsp;3 package with the
   * given URI is enabled with this object.
   *
   * @param pkgURI the URI of the package.
   *
   * @return @c true if the given package is enabled within this object, @c 
   * false otherwise.
   *
   * @see isPackageEnabled(@if java String@endif)
   */ public
 bool isPackageURIEnabled(string pkgURI) {
    bool ret = libsbmlPINVOKE.SBase_isPackageURIEnabled(swigCPtr, pkgURI);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Predicate returning @c true if the given SBML Level&nbsp;3 package is
   * enabled with this object.
   *
   * The search ignores the package version.
   *
   * @param pkgName the name of the package.
   *
   * @return @c true if the given package is enabled within this object, @c
   * false otherwise.
   *
   * @see isPackageURIEnabled(@if java String@endif)
   */ public
 bool isPackageEnabled(string pkgName) {
    bool ret = libsbmlPINVOKE.SBase_isPackageEnabled(swigCPtr, pkgName);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Predicate returning @c true if an SBML Level&nbsp;3 package with the
   * given URI is enabled with this object.
   *
   * @param pkgURI the URI of the package.
   *
   * @return @c true if the given package is enabled within this object, @c 
   * false otherwise.
   *
   * @deprecated Replaced in libSBML 5.2.0 by
   * SBase::isPackageURIEnabled(@if java String@endif).
   *
   * @see isPkgEnabled(@if java String@endif)
   */ public
 bool isPkgURIEnabled(string pkgURI) {
    bool ret = libsbmlPINVOKE.SBase_isPkgURIEnabled(swigCPtr, pkgURI);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Predicate returning @c true if the given SBML Level&nbsp;3 package is
   * enabled with this object.
   *
   * The search ignores the package version.
   *
   * @param pkgName the name of the package.
   *
   * @return @c true if the given package is enabled within this object, @c
   * false otherwise.
   *
   * @deprecated Replaced in libSBML 5.2.0 by
   * SBase::isPackageEnabled(@if java String@endif).
   *
   * @see isPkgURIEnabled(@if java String@endif)
   */ public
 bool isPkgEnabled(string pkgName) {
    bool ret = libsbmlPINVOKE.SBase_isPkgEnabled(swigCPtr, pkgName);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/** */ /* libsbml-internal */ public new
 void writeExtensionElements(XMLOutputStream stream) {
    libsbmlPINVOKE.SBase_writeExtensionElements(swigCPtr, XMLOutputStream.getCPtr(stream));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/** */ /* libsbml-internal */ public new
 bool hasRequiredAttributes() {
    bool ret = libsbmlPINVOKE.SBase_hasRequiredAttributes(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public new
 bool hasRequiredElements() {
    bool ret = libsbmlPINVOKE.SBase_hasRequiredElements(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 int checkCompatibility(SBase arg0) {
    int ret = libsbmlPINVOKE.SBase_checkCompatibility(swigCPtr, SBase.getCPtr(arg0));
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 void setSBMLNamespacesAndOwn(SBMLNamespaces disownedNs) {
    libsbmlPINVOKE.SBase_setSBMLNamespacesAndOwn(swigCPtr, SBMLNamespaces.getCPtrAndDisown(disownedNs));
  }

  
/** */ /* libsbml-internal */ public new
 SBMLNamespaces getSBMLNamespaces() {
	SBMLNamespaces ret
	    = (SBMLNamespaces) libsbml.DowncastSBMLNamespaces(libsbmlPINVOKE.SBase_getSBMLNamespaces(swigCPtr), false);
	return ret;
}

  
/** */ /* libsbml-internal */ public
 string checkMathMLNamespace(XMLToken elem) {
    string ret = libsbmlPINVOKE.SBase_checkMathMLNamespace(swigCPtr, XMLToken.getCPtr(elem));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/** */ /* libsbml-internal */ public new
 UnitDefinition getDerivedUnitDefinition() {
    IntPtr cPtr = libsbmlPINVOKE.SBase_getDerivedUnitDefinition(swigCPtr);
    UnitDefinition ret = (cPtr == IntPtr.Zero) ? null : new UnitDefinition(cPtr, false);
    return ret;
  }

  
/** */ /* libsbml-internal */ public new
 bool containsUndeclaredUnits() {
    bool ret = libsbmlPINVOKE.SBase_containsUndeclaredUnits(swigCPtr);
    return ret;
  }

  
/**
   * Removes this object from its parent.
   *
   * If the parent was storing this object as a pointer, it is deleted.  If
   * not, it is simply cleared (as in ListOf objects).  This is a pure
   * virtual method, as every SBase element has different parents, and
   * therefore different methods of removing itself.  Will fail (and not
   * delete itself) if it has no parent object.  This function is designed to
   * be overridden, but for all objects whose parent is of the class ListOf,
   * the default implementation will work.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   */ public new
 int removeFromParentAndDelete() {
    int ret = libsbmlPINVOKE.SBase_removeFromParentAndDelete(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this object's set of XML namespaces are the same
   * as the given object's XML namespaces.
   *
   *
 * 
 * The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
 * information.  It is used to communicate the SBML Level, Version, and (in
 * Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.  A
 * common approach to using libSBML's SBMLNamespaces facilities is to create an
 * SBMLNamespaces object somewhere in a program once, then hand that object
 * as needed to object constructors that accept SBMLNamespaces as arguments.
 *
 *
   *
   * @param sb an object to compare with respect to namespaces.
   *
   * @return boolean, @c true if this object's collection of namespaces is
   * the same as @p sb's, @c false otherwise.
   */ public
 bool matchesSBMLNamespaces(SBase sb) {
    bool ret = libsbmlPINVOKE.SBase_matchesSBMLNamespaces__SWIG_0(swigCPtr, SBase.getCPtr(sb));
    return ret;
  }

  
/**
   * Returns @c true if this object's set of XML namespaces are a subset
   * of the given object's XML namespaces.
   *
   *
 * 
 * The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
 * information.  It is used to communicate the SBML Level, Version, and (in
 * Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.  A
 * common approach to using libSBML's SBMLNamespaces facilities is to create an
 * SBMLNamespaces object somewhere in a program once, then hand that object
 * as needed to object constructors that accept SBMLNamespaces as arguments.
 *
 *
   *
   * @param sb an object to compare with respect to namespaces.
   *
   * @return boolean, @c true if this object's collection of namespaces is
   * a subset of @p sb's, @c false otherwise.
   */ public
 bool matchesRequiredSBMLNamespacesForAddition(SBase sb) {
    bool ret = libsbmlPINVOKE.SBase_matchesRequiredSBMLNamespacesForAddition__SWIG_0(swigCPtr, SBase.getCPtr(sb));
    return ret;
  }

  
/**
   * Predicate returning true or false depending on whether
   * the user data of this element has been set.
   *
   *
 * 
 * The user data associated with an SBML object can be used by an application
 * developer to attach custom information to that object in the model.  In case
 * of a deep copy, this data will passed as-is.  The data attribute will never
 * be interpreted by libSBML.
   *
   * @return boolean, @c true if this object's user data has been set,
   * @c false otherwise.
   */ public
 bool isSetUserData() {
    bool ret = libsbmlPINVOKE.SBase_isSetUserData(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the user data of this element.
   *
   *
 * 
 * The user data associated with an SBML object can be used by an application
 * developer to attach custom information to that object in the model.  In case
 * of a deep copy, this data will passed as-is.  The data attribute will never
 * be interpreted by libSBML.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   */ public
 int unsetUserData() {
    int ret = libsbmlPINVOKE.SBase_unsetUserData(swigCPtr);
    return ret;
  }

  
/**
   * Gets the namespace URI to which this element belongs to.
   *
   * For example, all elements that belong to SBML Level&nbsp;3 Version&nbsp;1 Core
   * must would have the URI <code>'http://www.sbml.org/sbml/level3/version1/core'</code>;
   * all elements that belong to Layout Extension Version 1 for SBML Level&nbsp;3
   * Version&nbsp;1 Core must would have the URI
   * <code>'http://www.sbml.org/sbml/level3/version1/layout/version1'</code>.
   *
   * This function first returns the URI for this element by looking into the
   * SBMLNamespaces object of the document with the its package name.  If not
   * found, it will then look for the namespace associated with the element
   * itself.
   *
   * @return the URI of this element, as a text string.
   *
   * @see getSBMLDocument()
   * @see getPackageName()
   */ public
 string getURI() {
    string ret = libsbmlPINVOKE.SBase_getURI(swigCPtr);
    return ret;
  }

  
/**
   * Returns the XML namespace prefix of this element.
   *
   * This reports the XML namespace prefix chosen for this class of object in
   * the current SBML document.  This may be an empty string if the component
   * has no explicit prefix (for instance, if it is a core SBML object placed
   * in the default SBML namespace of the document).  If it is not empty, then
   * it corresponds to the XML namespace prefix used set the object, whatever
   * that may be in a given SBML document.
   *
   * @return a text string representing the XML namespace prefix.
   */ public
 string getPrefix() {
    string ret = libsbmlPINVOKE.SBase_getPrefix(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public new
 bool hasOptionalAttributes() {
    bool ret = libsbmlPINVOKE.SBase_hasOptionalAttributes(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public new
 bool hasOptionalElements() {
    bool ret = libsbmlPINVOKE.SBase_hasOptionalElements(swigCPtr);
    return ret;
  }

  public SBaseList getListOfAllElements(ElementFilter filter) {
    IntPtr cPtr = libsbmlPINVOKE.SBase_getListOfAllElements__SWIG_0(swigCPtr, ElementFilter.getCPtr(filter));
    SBaseList ret = (cPtr == IntPtr.Zero) ? null : new SBaseList(cPtr, false);
    return ret;
  }

  public SBaseList getListOfAllElements() {
    IntPtr cPtr = libsbmlPINVOKE.SBase_getListOfAllElements__SWIG_1(swigCPtr);
    SBaseList ret = (cPtr == IntPtr.Zero) ? null : new SBaseList(cPtr, false);
    return ret;
  }

  public SBaseList getListOfAllElementsFromPlugins(ElementFilter filter) {
    IntPtr cPtr = libsbmlPINVOKE.SBase_getListOfAllElementsFromPlugins__SWIG_0(swigCPtr, ElementFilter.getCPtr(filter));
    SBaseList ret = (cPtr == IntPtr.Zero) ? null : new SBaseList(cPtr, false);
    return ret;
  }

  public SBaseList getListOfAllElementsFromPlugins() {
    IntPtr cPtr = libsbmlPINVOKE.SBase_getListOfAllElementsFromPlugins__SWIG_1(swigCPtr);
    SBaseList ret = (cPtr == IntPtr.Zero) ? null : new SBaseList(cPtr, false);
    return ret;
  }

}

}
