/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 *  Overall SBML container object.
 <p>
 * LibSBML uses the class {@link SBMLDocument} as a top-level
 * container for storing SBML content and data associated with it (such as
 * warnings and error messages).  The two primary means of reading an SBML
 * model, {@link SBMLReader#readSBML(String filename)} and
 * {@link SBMLReader#readSBMLFromString(String xml)}, both return an {@link SBMLDocument}
 * object.  From there, callers can inquire about any errors encountered
 * (e.g., using {@link SBMLDocument#getNumErrors()}), access the {@link Model} object, and
 * perform other actions such as consistency-checking and model
 * translation.
 <p>
 * When creating fresh models programmatically, the starting point is
 * typically the creation of an {@link SBMLDocument} object instance.  The
 * {@link SBMLDocument} constructor accepts arguments for the SBML Level and
 * Version of the model to be created.  After creating the {@link SBMLDocument}
 * object, calling programs then typically call {@link SBMLDocument#createModel()}
 * almost immediately, and then proceed to call the methods on the {@link Model}
 * object to fill out the model's contents.
 <p>
 * {@link SBMLDocument} corresponds roughly to the class <i>Sbml</i> defined in the
 * SBML Level&nbsp;2 specification and <i>SBML</i> in the Level&nbsp;3
 * specification.  It does not have a direct correspondence in SBML
 * Level&nbsp;1.  (However, to make matters simpler for applications,
 * libSBML creates an {@link SBMLDocument} no matter whether the model is
 * Level&nbsp;1, Level&nbsp;2 or Level&nbsp;3.)  In its barest form, when written out in
 * XML format for (e.g.) SBML Level&nbsp;2 Version&nbsp;4, the corresponding
 * structure is the following:
 * <pre class='fragment'>
&lt;sbml xmlns='http://www.sbml.org/sbml/level2/version4' level='2' version='4'&gt;
  ...
&lt;/sbml&gt;</pre>
 <p>
 * {@link SBMLDocument} is derived from {@link SBase}, and therefore contains the usual {@link SBase}
 * attributes (in SBML Level&nbsp;2 and Level&nbsp;3) of 'metaid' and 'sboTerm', as
 * well as the subelements 'notes' and 'annotation'.  It also contains the
 * attributes 'level' and 'version' indicating the Level and Version of the
 * SBML data structure.  These can be accessed using the methods defined by
 * the {@link SBase} class for that purpose.
 <p>
 * <h2>Checking consistency and adherence to SBML specifications</h2>
 <p>
 * One of the most important features of libSBML is its ability to perform
 * SBML validation to ensure that a model adheres to the SBML specification
 * for whatever Level+Version combination the model uses.  {@link SBMLDocument}
 * provides the methods for running consistency-checking and validation
 * rules on the SBML content.
 <p>
 * First, a brief explanation of the rationale is in order.  In libSBML
 * versions up to and including the version&nbsp;3.3.x series, the
 * individual methods for creating and setting attributes and other
 * components were quite lenient, and allowed a caller to compose SBML
 * entities that might not, in the end, represent valid SBML.  This allowed
 * applications the freedom to do things such as save incomplete models
 * (which is useful when models are being developed over long periods of
 * time).  In the version&nbsp;4.x series, libSBML is somewhat stricter,
 * but still permits structures to be created independently and the results
 * to be combined in a separate step.  In all these cases, it means that a
 * separate validation step is necessary when a calling program finally
 * wants to finish a complete SBML document.
 <p>
 * The primary interface to this validation facility is {@link SBMLDocument}'s
 * {@link SBMLDocument#checkInternalConsistency()} and
 * {@link SBMLDocument#checkConsistency()}.  The former verifies the basic
 * internal consistency and syntax of an SBML document, and the latter
 * implements more elaborate validation rules (both those defined by the
 * SBML specifications, as well as additional rules offered by libSBML).
 <p>
 * The checks performed by {@link SBMLDocument#checkInternalConsistency()} are
 * hardwired and cannot be changed by calling programs, but the validation
 * performed by {@link SBMLDocument#checkConsistency()} is under program control
 * using the method {@link SBMLDocument#setConsistencyChecks(int categ, boolean
 * onoff)}.  Applications can selectively disable specific kinds of checks
 * that they may not be interested by calling
 * {@link SBMLDocument#setConsistencyChecks(int categ, boolean onoff)} with
 * appropriate parameters.
 <p>
 * These methods have slightly different relevance depending on whether a
 * model is created programmaticaly from scratch, or whether it is read in
 * from a file or data stream.  The following list summarizes the possible
 * scenarios.
 <p>
 * <em>Scenario 1: Creating a model from scratch</em>.  Before writing out
 * the model, 
 <p>
 * <ul>
 * <li> Call {@link SBMLDocument#checkInternalConsistency()}, then inquire about
 * the results by calling {@link SBMLDocument#getNumErrors()}
 <p>
 * <li> Call {@link SBMLDocument#setConsistencyChecks(int categ, boolean
 * onoff)}  to configure
 * which checks will be performed by {@link SBMLDocument#checkConsistency()}
 <p>
 * <li> Call {@link SBMLDocument#checkConsistency()}, then inquire about the results by
 * calling {@link SBMLDocument#getNumErrors()}
 *
 * </ul> <p>
 * <em>Scenario 2: Reading a model from a file or data stream.</em> After
 * reading the model,
 <p>
 * <ul>
 * <li> Basic consistency checks will have been performed automatically by
 * libSBML upon reading the content, so you only need to inquire about the
 * results by using {@link SBMLDocument#getNumErrors()}
 <p>
 * <li> Call {@link SBMLDocument#setConsistencyChecks(int categ, boolean
 * onoff)}  to configure
 * which checks are performed by {@link SBMLDocument#checkConsistency()}
 <p>
 * <li> Call {@link SBMLDocument#checkConsistency()}, then inquire about the results
 * by calling {@link SBMLDocument#getNumErrors()}
 *
 * </ul> <p>
 * <h2>Converting documents between Levels and Versions of SBML</h2>
 <p>
 * LibSBML provides facilities for limited translation of SBML between
 * Levels and Versions of the SBML specifications.  The method for doing is
 * is {@link SBMLDocument#setLevelAndVersion(long lev, long ver, boolean strict)} .  In 
 * general, models can be converted upward without difficulty (e.g., from
 * SBML Level&nbsp;1 to Level&nbsp;2, or from an earlier Version of
 * Level&nbsp;2 to the latest Version of Level&nbsp;2).  Sometimes models
 * can be translated downward as well, if they do not use constructs
 * specific to more advanced Levels of SBML.
 <p>
 * Calling {@link SBMLDocument#setLevelAndVersion(long lev, long ver, boolean strict)}  will not <em>necessarily</em> lead
 * to a successful conversion.  The method will return a boolean value
 * to indicate success or failure.  Callers must check the error log (see 
 * next section) attached to the {@link SBMLDocument} object after calling
 * {@link SBMLDocument#setLevelAndVersion(long lev, long ver)}  in order to assess whether any
 * problems arose.
 <p>
 * If an application is interested in translating to a lower Level and/or
 * Version of SBML within a Level, the following methods allow for prior
 * assessment of whether there is sufficient compatibility to make a
 * translation possible:
 <p>
 * <ul>
 * <li> {@link SBMLDocument#checkL1Compatibility()},
 * <li> {@link SBMLDocument#checkL2v1Compatibility()},
 * <li> {@link SBMLDocument#checkL2v2Compatibility()},
 * <li> {@link SBMLDocument#checkL2v3Compatibility()}, 
 * <li> {@link SBMLDocument#checkL2v4Compatibility()}, and
 * <li> {@link SBMLDocument#checkL3v1Compatibility()}.
 *
 * </ul> <p>
 * Some changes between Versions of SBML Level&nbsp;2 may lead to
 * unexpected behaviors when attempting conversions in either direction.
 * For example, SBML Level&nbsp;2 Version&nbsp;4 relaxed the requirement
 * for consistency in units of measurement between expressions annd
 * quantities in a model.  As a result, a model written in Version&nbsp;4,
 * if converted to Version&nbsp;3 with no other changes, may fail
 * validation as a Version&nbsp;3 model because Version&nbsp;3 imposed
 * stricter requirements on unit consistency.
 <p>
 * Other changes between SBML Level 2 and Level 3 make downward conversions
 * challenging.  In some cases, it means that a model converted to
 * Level&nbsp;2 from Level&nbsp;3 will contain attributes that were not
 * explicitly given in the Level&nbsp;3 model, because in Level&nbsp;2
 * these attributes may have been optional or have default values.
 <p>
 * <h2>Error handling</h2>
 <p>
 * Upon reading a model, {@link SBMLDocument} logs any problems encountered while
 * reading the model from the file or data stream.  The log contains
 * objects that record diagnostic information about any notable issues that
 * arose.  Whether the problems are warnings or errors, they are both
 * reported through a single common interface involving the object class
 * {@link SBMLError}.
 <p>
 * The methods {@link SBMLDocument#getNumErrors()}, {@link SBMLDocument#getError(long n)}  and
 * {@link SBMLDocument#printErrors()} allow callers to interact with the warnings
 * or errors logged.  Alternatively, callers may retrieve the entire log as
 * an {@link SBMLErrorLog} object using the method {@link SBMLDocument#getErrorLog()}.
 * The {@link SBMLErrorLog} object provides some alternative methods for
 * interacting with the set of errors and warnings.  In either case,
 * applications typically should first call {@link SBMLDocument#getNumErrors()} to
 * find out if any issues have been logged after specific libSBML
 * operations such as the ones discussed in the sections above.  If they
 * have, then an application will should proceed to inspect the individual
 * reports using either the direct interfaces on {@link SBMLDocument} or using the
 * methods on the {@link SBMLErrorLog} object.
 */

public class SBMLDocument extends SBase {
   private long swigCPtr;

   protected SBMLDocument(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.SBMLDocument_SWIGUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(SBMLDocument obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (SBMLDocument obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_SBMLDocument(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  
/**
   * The default SBML Level of new {@link SBMLDocument} objects.
   <p>
   * <p>
 * This 'default Level' corresponds to the most recent SBML specification
 * Level available at the time libSBML version 5.13.0 was released.  The default Level is used by
 * {@link SBMLDocument} if no Level is explicitly specified at the time of the
 * construction of an {@link SBMLDocument} instance.
   <p>
   * @return an integer indicating the most recent SBML specification Level
   <p>
   * 
   <p>
   * @see SBMLDocument#getDefaultVersion() 
   */ public
 static long getDefaultLevel() {
    return libsbmlJNI.SBMLDocument_getDefaultLevel();
  }

  
/**
   * The default Version of new {@link SBMLDocument} objects.
   <p>
   * <p>
 * This 'default Version' corresponds to the most recent Version within the
 * most recent Level of SBML available at the time libSBML version
 * 5.13.0 was released.  The default Version is
 * used by {@link SBMLDocument} if no Version is explicitly specified at the time of
 * the construction of an {@link SBMLDocument} instance. 
   <p>
   * @return an integer indicating the most recent SBML specification
   * Version
   <p>
   * 
   <p>
   * @see SBMLDocument#getDefaultLevel() 
   */ public
 static long getDefaultVersion() {
    return libsbmlJNI.SBMLDocument_getDefaultVersion();
  }

  
/**
   * Creates a new {@link SBMLDocument}, optionally with given values for the SBML
   * Level and Version.
   <p>
   * If <em>both</em> the SBML Level and Version attributes are not
   * specified, the SBML document is treated as having the latest Level and
   * Version of SBML as determined by {@link SBMLDocument#getDefaultLevel()} and
   * {@link SBMLDocument#getDefaultVersion()}; <em>however</em>, the {@link SBMLDocument}
   * object is otherwise left blank.  In particular, the blank {@link SBMLDocument}
   * object has no associated XML attributes, including (but not limited
   * to) an XML namespace declaration.  The XML namespace declaration is
   * not added until the model is written out, <em>or</em> the method
   * {@link SBMLDocument#setLevelAndVersion(long, long, boolean)}
   * is called.  This may be important to keep in mind
   * if an application needs to add additional XML namespace declarations
   * on the <code>&lt;sbml&gt;</code> element.  Application writers should
   * either provide values for <code>level</code> and <code>version</code> on the call to this
   * constructor, or else call
   * {@link SBMLDocument#setLevelAndVersion(long, long, boolean)}
   * shortly after creating the {@link SBMLDocument} object.
   <p>
   * @param level an integer for the SBML Level
   <p>
   * @param version an integer for the Version within the SBML Level
   <p>
   * <p>
 * @throws SBMLConstructorException
 * Thrown if the given <code>level</code> and <code>version</code> combination are invalid
 * or if this object is incompatible with the given level and version.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   <p>
   * @see SBMLDocument#setLevelAndVersion(long, long, boolean)
   * @see #getDefaultLevel()
   * @see #getDefaultVersion()
   */ public
 SBMLDocument(long level, long version) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_SBMLDocument__SWIG_0(level, version), true);
  }

  
/**
   * Creates a new {@link SBMLDocument}, optionally with given values for the SBML
   * Level and Version.
   <p>
   * If <em>both</em> the SBML Level and Version attributes are not
   * specified, the SBML document is treated as having the latest Level and
   * Version of SBML as determined by {@link SBMLDocument#getDefaultLevel()} and
   * {@link SBMLDocument#getDefaultVersion()}; <em>however</em>, the {@link SBMLDocument}
   * object is otherwise left blank.  In particular, the blank {@link SBMLDocument}
   * object has no associated XML attributes, including (but not limited
   * to) an XML namespace declaration.  The XML namespace declaration is
   * not added until the model is written out, <em>or</em> the method
   * {@link SBMLDocument#setLevelAndVersion(long, long, boolean)}
   * is called.  This may be important to keep in mind
   * if an application needs to add additional XML namespace declarations
   * on the <code>&lt;sbml&gt;</code> element.  Application writers should
   * either provide values for <code>level</code> and <code>version</code> on the call to this
   * constructor, or else call
   * {@link SBMLDocument#setLevelAndVersion(long, long, boolean)}
   * shortly after creating the {@link SBMLDocument} object.
   <p>
   * @param level an integer for the SBML Level
   <p>
   * @param version an integer for the Version within the SBML Level
   <p>
   * <p>
 * @throws SBMLConstructorException
 * Thrown if the given <code>level</code> and <code>version</code> combination are invalid
 * or if this object is incompatible with the given level and version.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   <p>
   * @see SBMLDocument#setLevelAndVersion(long, long, boolean)
   * @see #getDefaultLevel()
   * @see #getDefaultVersion()
   */ public
 SBMLDocument(long level) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_SBMLDocument__SWIG_1(level), true);
  }

  
/**
   * Creates a new {@link SBMLDocument}, optionally with given values for the SBML
   * Level and Version.
   <p>
   * If <em>both</em> the SBML Level and Version attributes are not
   * specified, the SBML document is treated as having the latest Level and
   * Version of SBML as determined by {@link SBMLDocument#getDefaultLevel()} and
   * {@link SBMLDocument#getDefaultVersion()}; <em>however</em>, the {@link SBMLDocument}
   * object is otherwise left blank.  In particular, the blank {@link SBMLDocument}
   * object has no associated XML attributes, including (but not limited
   * to) an XML namespace declaration.  The XML namespace declaration is
   * not added until the model is written out, <em>or</em> the method
   * {@link SBMLDocument#setLevelAndVersion(long, long, boolean)}
   * is called.  This may be important to keep in mind
   * if an application needs to add additional XML namespace declarations
   * on the <code>&lt;sbml&gt;</code> element.  Application writers should
   * either provide values for <code>level</code> and <code>version</code> on the call to this
   * constructor, or else call
   * {@link SBMLDocument#setLevelAndVersion(long, long, boolean)}
   * shortly after creating the {@link SBMLDocument} object.
   <p>
   * @param level an integer for the SBML Level
   <p>
   * @param version an integer for the Version within the SBML Level
   <p>
   * <p>
 * @throws SBMLConstructorException
 * Thrown if the given <code>level</code> and <code>version</code> combination are invalid
 * or if this object is incompatible with the given level and version.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   <p>
   * @see SBMLDocument#setLevelAndVersion(long, long, boolean)
   * @see #getDefaultLevel()
   * @see #getDefaultVersion()
   */ public
 SBMLDocument() throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_SBMLDocument__SWIG_2(), true);
  }

  
/**
   * Creates a new {@link SBMLDocument} using the given {@link SBMLNamespaces} object 
   * <code>sbmlns</code>.
   <p>
   * <p>
 * The {@link SBMLNamespaces} object encapsulates SBML Level/Version/namespaces
 * information.  It is used to communicate the SBML Level, Version, and (in
 * Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.  A
 * common approach to using libSBML's {@link SBMLNamespaces} facilities is to create an
 * {@link SBMLNamespaces} object somewhere in a program once, then hand that object
 * as needed to object constructors that accept {@link SBMLNamespaces} as arguments. 
   <p>
   * @param sbmlns an {@link SBMLNamespaces} object.
   <p>
   * <p>
 * @throws SBMLConstructorException
 * Thrown if the given <code>sbmlns</code> is inconsistent or incompatible
 * with this object.
   */ public
 SBMLDocument(SBMLNamespaces sbmlns) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_SBMLDocument__SWIG_3(SBMLNamespaces.getCPtr(sbmlns), sbmlns), true);
  }

  
/**
   * Copy constructor; creates a copy of this {@link SBMLDocument}.
   <p>
   * @param orig the object to copy.
   */ public
 SBMLDocument(SBMLDocument orig) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_SBMLDocument__SWIG_4(SBMLDocument.getCPtr(orig), orig), true);
  }

  
/**
   * Creates and returns a deep copy of this {@link SBMLDocument} object.
   <p>
   * @return the (deep) copy of this {@link SBMLDocument} object.
   */ public
 SBMLDocument cloneObject() {
    long cPtr = libsbmlJNI.SBMLDocument_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new SBMLDocument(cPtr, true);
  }

  
/**
  * Returns <code>true</code> if the {@link Model} object has been set, otherwise 
  * returns <code>false.</code>
  <p>
  * @return <code>true</code> if the {@link Model} object has been set
  */ public
 boolean isSetModel() {
    return libsbmlJNI.SBMLDocument_isSetModel(swigCPtr, this);
  }

  
/**
   * Returns the {@link Model} object stored in this {@link SBMLDocument}.
   <p>
   * It is important to note that this method <em>does not create</em> a
   * {@link Model} instance.  The model in the {@link SBMLDocument} must have been created
   * at some prior time, for example using {@link SBMLDocument#createModel()} 
   * or {@link SBMLDocument#setModel(Model)}.
   * This method returns <code>null</code> if a model does not yet exist.
   <p>
   * @return the {@link Model} contained in this {@link SBMLDocument}.
   <p>
   * @see #createModel()
   */ public
 Model getModel() {
    long cPtr = libsbmlJNI.SBMLDocument_getModel__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new Model(cPtr, false);
  }

  
/**
   * Returns the first child element found that has the given <code>id</code> in the
   * model-wide SId namespace, or <code>null</code> if no such object is found.
   <p>
   * @param id string representing the id of objects to find
   <p>
   * @return pointer to the first element found with the given <code>id</code>.
   */ public
 SBase getElementBySId(String id) {
  return libsbml.DowncastSBase(libsbmlJNI.SBMLDocument_getElementBySId(swigCPtr, this, id), false);
}

  
/**
   * Returns the first child element it can find with the given <code>metaid</code>, or
   * itself if it has the given <code>metaid</code>, or <code>null</code> if no such object is
   * found.
   <p>
   * @param metaid string representing the metaid of objects to find
   <p>
   * @return pointer to the first element found with the given <code>metaid</code>.
   */ public
 SBase getElementByMetaId(String metaid) {
  return libsbml.DowncastSBase(libsbmlJNI.SBMLDocument_getElementByMetaId(swigCPtr, this, metaid), false);
}

  
/**
   * Removes {@link FunctionDefinition} constructs from the document and expands
   * any instances of their use within <code>&lt;math&gt;</code> elements.
   <p>
   * For example, suppose a {@link Model} contains a {@link FunctionDefinition} with
   * identifier <code>'f'</code> representing the math expression: <em>f(x, y) = x *
   * y</em>.  Suppose further that there is a reaction in which the
   * <code>&lt;math&gt;</code> element of the {@link KineticLaw} object contains
   * <code>f(s, p)</code>, where <code>s</code> and <code>p</code> are other identifiers
   * defined in the model.  The outcome of invoking this method is that the
   * <code>&lt;math&gt;</code> of the {@link KineticLaw} now represents the
   * expression <em>s * p</em> and the model no longer contains any
   * {@link FunctionDefinition} objects.
   <p>
   * @return boolean <code>true</code> if the transformation was successful, 
   * <code>false</code>, otherwise.
   <p>
   * @note This function will check the consistency of a model before
   * attemptimg the transformation.  If the model is not valid SBML, the
   * transformation will not be performed and the function will return 
   * <code>false.</code>
   */ public
 boolean expandFunctionDefinitions() {
    return libsbmlJNI.SBMLDocument_expandFunctionDefinitions(swigCPtr, this);
  }

  
/**
   * Removes {@link InitialAssignment} constructs from the document and
   * replaces them with appropriate values.
   <p>
   * For example, suppose a {@link Model} contains a {@link InitialAssignment} to a symbol
   * <code>'k'</code> where <code>'k'</code> is the identifier of a {@link Parameter}.  The outcome of
   * invoking this method is that the 'value' attribute of the {@link Parameter}
   * definition is set to the result calculated using the {@link InitialAssignment}
   * object's <code>&lt;math&gt;</code> formula, and the corresponding
   * {@link InitialAssignment} is then removed from the {@link Model}.
   <p>
   * @return boolean <code>true</code> if the transformation was successful, 
   * <code>false</code>, otherwise.
   <p>
   * @note This function will check the consistency of a model before
   * attemptimg the transformation.  If the model is not valid SBML, the
   * transformation will not be performed and the function will return 
   * <code>false.</code>  As part of that process, this method will check that it has
   * values for any components referred to by the <code>&lt;math&gt;</code>
   * elements of {@link InitialAssignment} objects.  In cases where not all of the
   * values have been declared (e.g., if the mathematical expression refers
   * to model entities that have no declared values), the {@link InitialAssignment}
   * in question will <em>not</em> be removed and this method will return 
   * <code>false.</code>
   */ public
 boolean expandInitialAssignments() {
    return libsbmlJNI.SBMLDocument_expandInitialAssignments(swigCPtr, this);
  }

  
/**
   * Sets the SBML Level and Version of this {@link SBMLDocument} instance,
   * attempting to convert the model as needed.
   <p>
   * This method is the principal way in libSBML to convert models between
   * Levels and Versions of SBML.  Generally, models can be converted
   * upward without difficulty (e.g., from SBML Level&nbsp;1 to
   * Level&nbsp;2, or from an earlier Version of Level&nbsp;2 to the latest
   * Version of Level&nbsp;2).  Sometimes models can be translated downward
   * as well, if they do not use constructs specific to more advanced
   * Levels of SBML.
   <p>
   * Before calling this method, callers may check compatibility directly
   * using the methods {@link SBMLDocument#checkL1Compatibility()},
   * {@link SBMLDocument#checkL2v1Compatibility()},
   * {@link SBMLDocument#checkL2v2Compatibility()},
   * {@link SBMLDocument#checkL2v3Compatibility()},
   * {@link SBMLDocument#checkL2v4Compatibility()}, and
   * {@link SBMLDocument#checkL3v1Compatibility()}.
   <p>
   * The valid combinations of SBML Level and Version as of this release
   * of libSBML are the following: 
   * <ul>
   * <li> Level&nbsp;1 Version&nbsp;2
   * <li> Level&nbsp;2 Version&nbsp;1
   * <li> Level&nbsp;2 Version&nbsp;2
   * <li> Level&nbsp;2 Version&nbsp;3
   * <li> Level&nbsp;2 Version&nbsp;4
   * <li> Level&nbsp;3 Version&nbsp;1
   * </ul>
   <p>
   * Strict conversion applies the additional criteria that both the
   * source and the target model must be consistent SBML.  Users can
   * control the consistency checks that are applied using the
   * {@link SBMLDocument#setConsistencyChecksForConversion(int, boolean)} method.  If either
   * the source or the potential target model have validation errors, the
   * conversion is not performed.  When a strict conversion is successful,
   * the underlying SBML object model is altered to reflect the new level
   * and version.  Thus, information that cannot be converted
   * (e.g. sboTerms) will be lost.
   <p>
   * @param level the desired SBML Level
   <p>
   * @param version the desired Version within the SBML Level
   <p>
   * @param strict boolean indicating whether to check consistency
   * of both the source and target model when performing
   * conversion (defaults to <code> true </code>)
   <p>
   * @param ignorePackages boolean indicating whether the presence of
   * packages should be ignored by the conversion routine 
   * (defaults to <code> false </code>)
   <p>
   * @return <code>true</code> if the level and version of the document were
   * successfully set to the requested values (which may have required
   * conversion of the model), <code>false</code> otherwise.
   <p>
   * @note Calling this method will not <em>necessarily</em> lead to a successful
   * conversion.  If the conversion fails, it will be logged in the error
   * list associated with this {@link SBMLDocument}.  Callers should consult
   * getNumErrors() to find out if the conversion succeeded without
   * problems.  For conversions from Level&nbsp;2 to Level&nbsp;1, callers
   * can also check the Level of the model after calling this method to
   * find out whether it is Level&nbsp;1.  (If the conversion to
   * Level&nbsp;1 failed, the Level of this model will be left unchanged.)
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   <p>
   * @see #checkL1Compatibility()
   * @see #checkL2v1Compatibility()
   * @see #checkL2v2Compatibility()
   * @see #checkL2v3Compatibility()
   * @see #checkL2v4Compatibility()
   * @see #checkL3v1Compatibility()
   * @see #checkL3v1Compatibility()
   */ public
 boolean setLevelAndVersion(long level, long version, boolean strict, boolean ignorePackages) {
    return libsbmlJNI.SBMLDocument_setLevelAndVersion__SWIG_0(swigCPtr, this, level, version, strict, ignorePackages);
  }

  
/**
   * Sets the SBML Level and Version of this {@link SBMLDocument} instance,
   * attempting to convert the model as needed.
   <p>
   * This method is the principal way in libSBML to convert models between
   * Levels and Versions of SBML.  Generally, models can be converted
   * upward without difficulty (e.g., from SBML Level&nbsp;1 to
   * Level&nbsp;2, or from an earlier Version of Level&nbsp;2 to the latest
   * Version of Level&nbsp;2).  Sometimes models can be translated downward
   * as well, if they do not use constructs specific to more advanced
   * Levels of SBML.
   <p>
   * Before calling this method, callers may check compatibility directly
   * using the methods {@link SBMLDocument#checkL1Compatibility()},
   * {@link SBMLDocument#checkL2v1Compatibility()},
   * {@link SBMLDocument#checkL2v2Compatibility()},
   * {@link SBMLDocument#checkL2v3Compatibility()},
   * {@link SBMLDocument#checkL2v4Compatibility()}, and
   * {@link SBMLDocument#checkL3v1Compatibility()}.
   <p>
   * The valid combinations of SBML Level and Version as of this release
   * of libSBML are the following: 
   * <ul>
   * <li> Level&nbsp;1 Version&nbsp;2
   * <li> Level&nbsp;2 Version&nbsp;1
   * <li> Level&nbsp;2 Version&nbsp;2
   * <li> Level&nbsp;2 Version&nbsp;3
   * <li> Level&nbsp;2 Version&nbsp;4
   * <li> Level&nbsp;3 Version&nbsp;1
   * </ul>
   <p>
   * Strict conversion applies the additional criteria that both the
   * source and the target model must be consistent SBML.  Users can
   * control the consistency checks that are applied using the
   * {@link SBMLDocument#setConsistencyChecksForConversion(int, boolean)} method.  If either
   * the source or the potential target model have validation errors, the
   * conversion is not performed.  When a strict conversion is successful,
   * the underlying SBML object model is altered to reflect the new level
   * and version.  Thus, information that cannot be converted
   * (e.g. sboTerms) will be lost.
   <p>
   * @param level the desired SBML Level
   <p>
   * @param version the desired Version within the SBML Level
   <p>
   * @param strict boolean indicating whether to check consistency
   * of both the source and target model when performing
   * conversion (defaults to <code> true </code>)
   <p>
   * @param ignorePackages boolean indicating whether the presence of
   * packages should be ignored by the conversion routine 
   * (defaults to <code> false </code>)
   <p>
   * @return <code>true</code> if the level and version of the document were
   * successfully set to the requested values (which may have required
   * conversion of the model), <code>false</code> otherwise.
   <p>
   * @note Calling this method will not <em>necessarily</em> lead to a successful
   * conversion.  If the conversion fails, it will be logged in the error
   * list associated with this {@link SBMLDocument}.  Callers should consult
   * getNumErrors() to find out if the conversion succeeded without
   * problems.  For conversions from Level&nbsp;2 to Level&nbsp;1, callers
   * can also check the Level of the model after calling this method to
   * find out whether it is Level&nbsp;1.  (If the conversion to
   * Level&nbsp;1 failed, the Level of this model will be left unchanged.)
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   <p>
   * @see #checkL1Compatibility()
   * @see #checkL2v1Compatibility()
   * @see #checkL2v2Compatibility()
   * @see #checkL2v3Compatibility()
   * @see #checkL2v4Compatibility()
   * @see #checkL3v1Compatibility()
   * @see #checkL3v1Compatibility()
   */ public
 boolean setLevelAndVersion(long level, long version, boolean strict) {
    return libsbmlJNI.SBMLDocument_setLevelAndVersion__SWIG_1(swigCPtr, this, level, version, strict);
  }

  
/**
   * Sets the SBML Level and Version of this {@link SBMLDocument} instance,
   * attempting to convert the model as needed.
   <p>
   * This method is the principal way in libSBML to convert models between
   * Levels and Versions of SBML.  Generally, models can be converted
   * upward without difficulty (e.g., from SBML Level&nbsp;1 to
   * Level&nbsp;2, or from an earlier Version of Level&nbsp;2 to the latest
   * Version of Level&nbsp;2).  Sometimes models can be translated downward
   * as well, if they do not use constructs specific to more advanced
   * Levels of SBML.
   <p>
   * Before calling this method, callers may check compatibility directly
   * using the methods {@link SBMLDocument#checkL1Compatibility()},
   * {@link SBMLDocument#checkL2v1Compatibility()},
   * {@link SBMLDocument#checkL2v2Compatibility()},
   * {@link SBMLDocument#checkL2v3Compatibility()},
   * {@link SBMLDocument#checkL2v4Compatibility()}, and
   * {@link SBMLDocument#checkL3v1Compatibility()}.
   <p>
   * The valid combinations of SBML Level and Version as of this release
   * of libSBML are the following: 
   * <ul>
   * <li> Level&nbsp;1 Version&nbsp;2
   * <li> Level&nbsp;2 Version&nbsp;1
   * <li> Level&nbsp;2 Version&nbsp;2
   * <li> Level&nbsp;2 Version&nbsp;3
   * <li> Level&nbsp;2 Version&nbsp;4
   * <li> Level&nbsp;3 Version&nbsp;1
   * </ul>
   <p>
   * Strict conversion applies the additional criteria that both the
   * source and the target model must be consistent SBML.  Users can
   * control the consistency checks that are applied using the
   * {@link SBMLDocument#setConsistencyChecksForConversion(int, boolean)} method.  If either
   * the source or the potential target model have validation errors, the
   * conversion is not performed.  When a strict conversion is successful,
   * the underlying SBML object model is altered to reflect the new level
   * and version.  Thus, information that cannot be converted
   * (e.g. sboTerms) will be lost.
   <p>
   * @param level the desired SBML Level
   <p>
   * @param version the desired Version within the SBML Level
   <p>
   * @param strict boolean indicating whether to check consistency
   * of both the source and target model when performing
   * conversion (defaults to <code> true </code>)
   <p>
   * @param ignorePackages boolean indicating whether the presence of
   * packages should be ignored by the conversion routine 
   * (defaults to <code> false </code>)
   <p>
   * @return <code>true</code> if the level and version of the document were
   * successfully set to the requested values (which may have required
   * conversion of the model), <code>false</code> otherwise.
   <p>
   * @note Calling this method will not <em>necessarily</em> lead to a successful
   * conversion.  If the conversion fails, it will be logged in the error
   * list associated with this {@link SBMLDocument}.  Callers should consult
   * getNumErrors() to find out if the conversion succeeded without
   * problems.  For conversions from Level&nbsp;2 to Level&nbsp;1, callers
   * can also check the Level of the model after calling this method to
   * find out whether it is Level&nbsp;1.  (If the conversion to
   * Level&nbsp;1 failed, the Level of this model will be left unchanged.)
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   <p>
   * @see #checkL1Compatibility()
   * @see #checkL2v1Compatibility()
   * @see #checkL2v2Compatibility()
   * @see #checkL2v3Compatibility()
   * @see #checkL2v4Compatibility()
   * @see #checkL3v1Compatibility()
   * @see #checkL3v1Compatibility()
   */ public
 boolean setLevelAndVersion(long level, long version) {
    return libsbmlJNI.SBMLDocument_setLevelAndVersion__SWIG_2(swigCPtr, this, level, version);
  }

  
/** * @internal */ public
 void updateSBMLNamespace(String arg0, long level, long version) {
    libsbmlJNI.SBMLDocument_updateSBMLNamespace(swigCPtr, this, arg0, level, version);
  }

  
/**
   * Sets the {@link Model} for this {@link SBMLDocument} to a copy of the given {@link Model}.
   <p>
   * @param m the new {@link Model} to use.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH}
   *
   * </ul> <p>
   * @see #createModel()
   * @see #getModel()
   */ public
 int setModel(Model m) {
    return libsbmlJNI.SBMLDocument_setModel(swigCPtr, this, Model.getCPtr(m), m);
  }

  
/**
   * Creates a new {@link Model} inside this {@link SBMLDocument}, and returns a pointer to
   * it.
   <p>
   * In SBML Level&nbsp;2, the use of an identifier on a {@link Model} object is
   * optional.  This method takes an optional argument, <code>sid</code>, for setting
   * the identifier.  If not supplied, the identifier attribute on the
   * {@link Model} instance is not set.
   <p>
   * @param sid the identifier of the new {@link Model} to create.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   <p>
   * @see #getModel()
   * @see SBMLDocument#setModel(Model)
   */ public
 Model createModel(String sid) {
    long cPtr = libsbmlJNI.SBMLDocument_createModel__SWIG_0(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new Model(cPtr, false);
  }

  
/**
   * Creates a new {@link Model} inside this {@link SBMLDocument}, and returns a pointer to
   * it.
   <p>
   * In SBML Level&nbsp;2, the use of an identifier on a {@link Model} object is
   * optional.  This method takes an optional argument, <code>sid</code>, for setting
   * the identifier.  If not supplied, the identifier attribute on the
   * {@link Model} instance is not set.
   <p>
   * @param sid the identifier of the new {@link Model} to create.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   <p>
   * @see #getModel()
   * @see SBMLDocument#setModel(Model)
   */ public
 Model createModel() {
    long cPtr = libsbmlJNI.SBMLDocument_createModel__SWIG_1(swigCPtr, this);
    return (cPtr == 0) ? null : new Model(cPtr, false);
  }

  
/**
   * Sets the location of this {@link SBMLDocument}.
   <p>
   * Called automatically when readSBMLFromFile is used, but may be set
   * manually as well.
   */ public
 void setLocationURI(String uri) {
    libsbmlJNI.SBMLDocument_setLocationURI(swigCPtr, this, uri);
  }

  
/**
   * Get the location of this {@link SBMLDocument}.
   <p>
   * If this document was read from a file or had its location set manually,
   * that filename or set location will be returned, otherwise, an empty
   * string is returned.
   */ public
 String getLocationURI() {
    return libsbmlJNI.SBMLDocument_getLocationURI__SWIG_0(swigCPtr, this);
  }

  
/**
   * Controls the consistency checks that are performed when
   * {@link SBMLDocument#checkConsistency()} is called.
   <p>
   * This method works by adding or subtracting consistency checks from the
   * set of all possible checks that {@link SBMLDocument#checkConsistency()} knows
   * how to perform.  This method may need to be called multiple times in
   * order to achieve the desired combination of checks.  The first
   * argument (<code>category</code>) in a call to this method indicates the category
   * of consistency/error checks that are to be turned on or off, and the
   * second argument (<code>apply</code>, a boolean) indicates whether to turn it on
   * (value of <code>true</code>) or off (value of <code>false</code>).
   <p>
   * The possible categories (values to the argument <code>category</code>) are the
   * set of constants whose names begin with the characters <code>LIBSBML_CAT_</code>
   * in the interface class {@link libsbmlConstants}.
   * The following are the possible choices:
   <p>
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_CAT_GENERAL_CONSISTENCY LIBSBML_CAT_GENERAL_CONSISTENCY}:
   * Correctness and consistency of specific SBML language constructs.
   * Performing this set of checks is highly recommended.  With respect to
   * the SBML specification, these concern failures in applying the
   * validation rules numbered 2xxxx in the Level&nbsp;2
   * Versions&nbsp;2&ndash;4 and Level&nbsp;3 Version&nbsp;1 specifications.
   <p>
   * <li> {@link libsbmlConstants#LIBSBML_CAT_IDENTIFIER_CONSISTENCY LIBSBML_CAT_IDENTIFIER_CONSISTENCY}:
   * Correctness and consistency of identifiers used for model entities.  An
   * example of inconsistency would be using a species identifier in a
   * reaction rate formula without first having declared the species.  With
   * respect to the SBML specification, these concern failures in applying
   * the validation rules numbered 103xx in the Level&nbsp;2
   * Versions&nbsp;2&ndash;4 and Level&nbsp;3 Version&nbsp;1 specifications.
   <p>
   * <li> {@link libsbmlConstants#LIBSBML_CAT_UNITS_CONSISTENCY LIBSBML_CAT_UNITS_CONSISTENCY}:
   * Consistency of measurement units associated with quantities in a model.
   * With respect to the SBML specification, these concern failures in
   * applying the validation rules numbered 105xx in the Level&nbsp;2
   * Versions&nbsp;2&ndash;4 and Level&nbsp;3 Version&nbsp;1 specifications.
   <p>
   * <li> {@link libsbmlConstants#LIBSBML_CAT_MATHML_CONSISTENCY LIBSBML_CAT_MATHML_CONSISTENCY}:
   * Syntax of MathML constructs.  With respect to the SBML specification,
   * these concern failures in applying the validation rules numbered 102xx
   * in the Level&nbsp;2 Versions&nbsp;2&ndash;4 and Level&nbsp;3
   * Version&nbsp;1 specifications.
   <p>
   * <li> {@link libsbmlConstants#LIBSBML_CAT_SBO_CONSISTENCY LIBSBML_CAT_SBO_CONSISTENCY}:
   * Consistency and validity of SBO identifiers (if any) used in the model.
   * With respect to the SBML specification, these concern failures in
   * applying the validation rules numbered 107xx in the Level&nbsp;2
   * Versions&nbsp;2&ndash;4 and Level&nbsp;3 Version&nbsp;1 specifications.
   <p>
   * <li> {@link libsbmlConstants#LIBSBML_CAT_OVERDETERMINED_MODEL LIBSBML_CAT_OVERDETERMINED_MODEL}:
   * Static analysis of whether the system of equations implied by a model is
   * mathematically overdetermined.  With respect to the SBML specification,
   * this is validation rule #10601 in the Level&nbsp;2
   * Versions&nbsp;2&ndash;4 and Level&nbsp;3 Version&nbsp;1 specifications.
   <p>
   * <li> {@link libsbmlConstants#LIBSBML_CAT_MODELING_PRACTICE LIBSBML_CAT_MODELING_PRACTICE}:
   * Additional checks for recommended good modeling practice. (These are
   * tests performed by libSBML and do not have equivalent SBML validation
   * rules.)  </ul>
   <p>
   * <em>By default, all validation checks are applied</em> to the model in
   * an {@link SBMLDocument} object <em>unless</em>
   * {@link SBMLDocument#setConsistencyChecks(int categ, boolean onoff)}
   * is called to indicate that only a subset should be applied.  Further,
   * this default (i.e., performing all checks) applies separately to
   * <em>each new {@link SBMLDocument} object</em> created.  In other words, each
   * time a model is read using {@link SBMLReader#readSBML(String filename)},
   * {@link SBMLReader#readSBMLFromString(String xml)},
   * or the global functions readSBML() and readSBMLFromString(), a new
   * {@link SBMLDocument} is created and for that document, a call to
   * {@link SBMLDocument#checkConsistency()} will default to applying all possible checks.
   * Calling programs must invoke
   * {@link SBMLDocument#setConsistencyChecks(int categ, boolean onoff)}
   * for each such new model if they wish to change the consistency checks
   * applied.
   <p>
   * @param category a value drawn from * the set of SBML error categories indicating the
   * consistency checking/validation to be turned on or off.
   <p>
   * @param apply a boolean indicating whether the checks indicated by
   * <code>category</code> should be applied or not.
   <p>
   * @see SBMLDocument#checkConsistency()
   */ public
 void setConsistencyChecks(int category, boolean apply) {
    libsbmlJNI.SBMLDocument_setConsistencyChecks(swigCPtr, this, category, apply);
  }

  
/**
   * Controls the consistency checks that are performed when
   * {@link SBMLDocument#setLevelAndVersion(long, long, boolean)} is called.
   <p>
   * This method works by adding or subtracting consistency checks from the
   * set of all possible checks that may be performed to avoid conversion
   * to or from an invalid document.  This method may need to be called 
   * multiple times in
   * order to achieve the desired combination of checks.  The first
   * argument (<code>category</code>) in a call to this method indicates the category
   * of consistency/error checks that are to be turned on or off, and the
   * second argument (<code>apply</code>, a boolean) indicates whether to turn it on
   * (value of <code>true</code>) or off (value of <code>false</code>).
   <p>
   * The possible categories (values to the argument <code>category</code>) are the
   * set of constants whose names begin with the characters <code>LIBSBML_CAT_</code>
   * in the interface class {@link libsbmlConstants}.
   * The following are the possible choices:
   <p>
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_CAT_GENERAL_CONSISTENCY LIBSBML_CAT_GENERAL_CONSISTENCY}:
   * Correctness and consistency of specific SBML language constructs.
   * Performing this set of checks is highly recommended.  With respect to
   * the SBML specification, these concern failures in applying the
   * validation rules numbered 2xxxx in the Level&nbsp;2
   * Versions&nbsp;2&ndash;4 and Level&nbsp;3 Version&nbsp;1 specifications.
   <p>
   * <li> {@link libsbmlConstants#LIBSBML_CAT_IDENTIFIER_CONSISTENCY LIBSBML_CAT_IDENTIFIER_CONSISTENCY}:
   * Correctness and consistency of identifiers used for model entities.  An
   * example of inconsistency would be using a species identifier in a
   * reaction rate formula without first having declared the species.  With
   * respect to the SBML specification, these concern failures in applying
   * the validation rules numbered 103xx in the Level&nbsp;2
   * Versions&nbsp;2&ndash;4 and Level&nbsp;3 Version&nbsp;1 specifications.
   <p>
   * <li> {@link libsbmlConstants#LIBSBML_CAT_UNITS_CONSISTENCY LIBSBML_CAT_UNITS_CONSISTENCY}:
<p>
   * Consistency of measurement units associated with quantities in a model.
   * With respect to the SBML specification, these concern failures in
   * applying the validation rules numbered 105xx in the Level&nbsp;2
   * Versions&nbsp;2&ndash;4 and Level&nbsp;3 Version&nbsp;1 specifications.
   <p>
   * <li> {@link libsbmlConstants#LIBSBML_CAT_MATHML_CONSISTENCY LIBSBML_CAT_MATHML_CONSISTENCY}:
   * Syntax of MathML constructs.  With respect to the SBML specification,
   * these concern failures in applying the validation rules numbered 102xx
   * in the Level&nbsp;2 Versions&nbsp;2&ndash;4 and Level&nbsp;3
   * Version&nbsp;1 specifications.
   <p>
   * <li> {@link libsbmlConstants#LIBSBML_CAT_SBO_CONSISTENCY LIBSBML_CAT_SBO_CONSISTENCY}:
   * Consistency and validity of SBO identifiers (if any) used in the model.
   * With respect to the SBML specification, these concern failures in
   * applying the validation rules numbered 107xx in the Level&nbsp;2
   * Versions&nbsp;2&ndash;4 and Level&nbsp;3 Version&nbsp;1 specifications.
   <p>
   * <li> {@link libsbmlConstants#LIBSBML_CAT_OVERDETERMINED_MODEL LIBSBML_CAT_OVERDETERMINED_MODEL}:
   * Static analysis of whether the system of equations implied by a model is
   * mathematically overdetermined.  With respect to the SBML specification,
   * this is validation rule #10601 in the Level&nbsp;2
   * Versions&nbsp;2&ndash;4 and Level&nbsp;3 Version&nbsp;1 specifications.
   <p>
   * <li> {@link libsbmlConstants#LIBSBML_CAT_MODELING_PRACTICE LIBSBML_CAT_MODELING_PRACTICE}:
   * Additional checks for recommended good modeling practice. (These are
   * tests performed by libSBML and do not have equivalent SBML validation
   * rules.)
   * </ul>
   <p>
   * <em>By default, all validation checks are applied</em> to the model in
   * an {@link SBMLDocument} object <em>unless</em>
   * {@link SBMLDocument#setConsistencyChecks(int, boolean)}
   * is called to indicate that only a subset should be applied.  Further,
   * this default (i.e., performing all checks) applies separately to
   * <em>each new {@link SBMLDocument} object</em> created.  In other words, each
   * time a model is read using {@link SBMLReader#readSBML(String)},
   * {@link SBMLReader#readSBMLFromString(String)},
   * or the global functions readSBML() and readSBMLFromString(), a new
   * {@link SBMLDocument} is created and for that document, a call to
   * {@link SBMLDocument#checkConsistency()} will default to applying all possible checks.
   * Calling programs must invoke
   * {@link SBMLDocument#setConsistencyChecks(int, boolean)}
   * for each such new model if they wish to change the consistency checks
   * applied.
   <p>
   * @param category a value drawn from * the set of SBML error categories indicating the consistency
   * checking/validation to be turned on or off.
   <p>
   * @param apply a boolean indicating whether the checks indicated by
   * <code>category</code> should be applied or not.
   <p>
   * @see SBMLDocument#setLevelAndVersion(long, long, boolean)
   */ public
 void setConsistencyChecksForConversion(int category, boolean apply) {
    libsbmlJNI.SBMLDocument_setConsistencyChecksForConversion(swigCPtr, this, category, apply);
  }

  
/**
   * Performs consistency checking and validation on this SBML document.
   <p>
   * If this method returns a nonzero value (meaning, one or more
   * consistency checks have failed for SBML document), the failures may be
   * due to warnings <em>or</em> errors.  Callers should inspect the severity
   * flag in the individual {@link SBMLError} objects returned by
   * {@link SBMLDocument#getError(long)} to determine the nature of the failures.
   <p>
   * @return the number of failed checks (errors) encountered.
   <p>
   * @see SBMLDocument#checkInternalConsistency()
   */ public
 long checkConsistency() {
    return libsbmlJNI.SBMLDocument_checkConsistency(swigCPtr, this);
  }

  
/**
   * Performs consistency checking and validation on this SBML document
   * using the ultra strict units validator that assumes that there
   * are no hidden numerical conversion factors.
   <p>
   * If this method returns a nonzero value (meaning, one or more
   * consistency checks have failed for SBML document), the failures may be
   * due to warnings <em>or</em> errors.  Callers should inspect the severity
   * flag in the individual {@link SBMLError} objects returned by
   * {@link SBMLDocument#getError(long)} to determine the nature of the failures.
   <p>
   * @return the number of failed checks (errors) encountered.
   <p>
   * @see SBMLDocument#checkInternalConsistency()
   */ public
 long checkConsistencyWithStrictUnits() {
    return libsbmlJNI.SBMLDocument_checkConsistencyWithStrictUnits(swigCPtr, this);
  }

  
/**
   * Performs consistency checking and validation on this SBML document.
   <p>
   * If this method returns a nonzero value (meaning, one or more
   * consistency checks have failed for SBML document), the failures may be
   * due to warnings <em>or</em> errors.  Callers should inspect the severity
   * flag in the individual {@link SBMLError} objects returned by
   * {@link SBMLDocument#getError(long)} to determine the nature of the failures.
   <p>
   * @note unlike checkConsistency this method will write the document
   *       in order to determine all errors for the document. This will 
   *       also clear the error log. 
   <p>
   * @return the number of failed checks (errors) encountered.
   <p>
   * @see SBMLDocument#checkConsistency()
   */ public
 long validateSBML() {
    return libsbmlJNI.SBMLDocument_validateSBML(swigCPtr, this);
  }

  
/**
   * Performs consistency checking on libSBML's internal representation of 
   * an SBML {@link Model}.
   <p>
   * Callers should query the results of the consistency check by calling
   * {@link SBMLDocument#getError(long)}.
   <p>
   * @return the number of failed checks (errors) encountered.
   <p>
   * The distinction between this method and
   * {@link SBMLDocument#checkConsistency()} is that this method reports on
   * fundamental syntactic and structural errors that violate the XML
   * Schema for SBML; by contrast, {@link SBMLDocument#checkConsistency()}
   * performs more elaborate model verifications and also validation
   * according to the validation rules written in the appendices of the
   * SBML Level&nbsp;2 Versions&nbsp;2&ndash;4 specification documents.
   <p>
   * @see SBMLDocument#checkConsistency()
   */ public
 long checkInternalConsistency() {
    return libsbmlJNI.SBMLDocument_checkInternalConsistency(swigCPtr, this);
  }

  
/**
   * Performs a set of consistency checks on the document to establish
   * whether it is compatible with SBML Level&nbsp;1 and can be converted
   * to Level&nbsp;1.
   <p>
   * Callers should query the results of the consistency check by calling
   * {@link SBMLDocument#getError(long)}.
   <p>
   * @return the number of failed checks (errors) encountered.
   */ public
 long checkL1Compatibility(boolean inConversion) {
    return libsbmlJNI.SBMLDocument_checkL1Compatibility__SWIG_0(swigCPtr, this, inConversion);
  }

  
/**
   * Performs a set of consistency checks on the document to establish
   * whether it is compatible with SBML Level&nbsp;1 and can be converted
   * to Level&nbsp;1.
   <p>
   * Callers should query the results of the consistency check by calling
   * {@link SBMLDocument#getError(long)}.
   <p>
   * @return the number of failed checks (errors) encountered.
   */ public
 long checkL1Compatibility() {
    return libsbmlJNI.SBMLDocument_checkL1Compatibility__SWIG_1(swigCPtr, this);
  }

  
/**
   * Performs a set of consistency checks on the document to establish
   * whether it is compatible with SBML Level&nbsp;2 Version&nbsp;1 and can
   * be converted to Level&nbsp;2 Version&nbsp;1.
   <p>
   * Callers should query the results of the consistency check by calling
   * {@link SBMLDocument#getError(long)}.
   <p>
   * @return the number of failed checks (errors) encountered.
   */ public
 long checkL2v1Compatibility(boolean inConversion) {
    return libsbmlJNI.SBMLDocument_checkL2v1Compatibility__SWIG_0(swigCPtr, this, inConversion);
  }

  
/**
   * Performs a set of consistency checks on the document to establish
   * whether it is compatible with SBML Level&nbsp;2 Version&nbsp;1 and can
   * be converted to Level&nbsp;2 Version&nbsp;1.
   <p>
   * Callers should query the results of the consistency check by calling
   * {@link SBMLDocument#getError(long)}.
   <p>
   * @return the number of failed checks (errors) encountered.
   */ public
 long checkL2v1Compatibility() {
    return libsbmlJNI.SBMLDocument_checkL2v1Compatibility__SWIG_1(swigCPtr, this);
  }

  
/**
   * Performs a set of consistency checks on the document to establish
   * whether it is compatible with SBML Level&nbsp;2 Version&nbsp;2 and can
   * be converted to Level&nbsp;2 Version&nbsp;2.
   <p>
   * Callers should query the results of the consistency check by calling
   * {@link SBMLDocument#getError(long)}.
   <p>
   * @return the number of failed checks (errors) encountered.
   */ public
 long checkL2v2Compatibility(boolean inConversion) {
    return libsbmlJNI.SBMLDocument_checkL2v2Compatibility__SWIG_0(swigCPtr, this, inConversion);
  }

  
/**
   * Performs a set of consistency checks on the document to establish
   * whether it is compatible with SBML Level&nbsp;2 Version&nbsp;2 and can
   * be converted to Level&nbsp;2 Version&nbsp;2.
   <p>
   * Callers should query the results of the consistency check by calling
   * {@link SBMLDocument#getError(long)}.
   <p>
   * @return the number of failed checks (errors) encountered.
   */ public
 long checkL2v2Compatibility() {
    return libsbmlJNI.SBMLDocument_checkL2v2Compatibility__SWIG_1(swigCPtr, this);
  }

  
/**
   * Performs a set of consistency checks on the document to establish
   * whether it is compatible with SBML Level&nbsp;2 Version&nbsp;3 and can
   * be converted to Level&nbsp;2 Version&nbsp;3.
   <p>
   * Callers should query the results of the consistency check by calling
   * {@link SBMLDocument#getError(long)}.
   <p>
   * @return the number of failed checks (errors) encountered.
   */ public
 long checkL2v3Compatibility(boolean inConversion) {
    return libsbmlJNI.SBMLDocument_checkL2v3Compatibility__SWIG_0(swigCPtr, this, inConversion);
  }

  
/**
   * Performs a set of consistency checks on the document to establish
   * whether it is compatible with SBML Level&nbsp;2 Version&nbsp;3 and can
   * be converted to Level&nbsp;2 Version&nbsp;3.
   <p>
   * Callers should query the results of the consistency check by calling
   * {@link SBMLDocument#getError(long)}.
   <p>
   * @return the number of failed checks (errors) encountered.
   */ public
 long checkL2v3Compatibility() {
    return libsbmlJNI.SBMLDocument_checkL2v3Compatibility__SWIG_1(swigCPtr, this);
  }

  
/**
   * Performs a set of consistency checks on the document to establish
   * whether it is compatible with SBML Level&nbsp;2 Version&nbsp;4 and can
   * be converted to Level&nbsp;2 Version&nbsp;4.
   <p>
   * Callers should query the results of the consistency check by calling
   * {@link SBMLDocument#getError(long)}.
   <p>
   * @return the number of failed checks (errors) encountered.
   */ public
 long checkL2v4Compatibility() {
    return libsbmlJNI.SBMLDocument_checkL2v4Compatibility(swigCPtr, this);
  }

  
/**
   * Performs a set of consistency checks on the document to establish
   * whether it is compatible with SBML Level&nbsp;3 Version&nbsp;1 and can
   * be converted to Level&nbsp;3 Version&nbsp;1.
   <p>
   * Callers should query the results of the consistency check by calling
   * {@link SBMLDocument#getError(long)}.
   <p>
   * @return the number of failed checks (errors) encountered.
   */ public
 long checkL3v1Compatibility() {
    return libsbmlJNI.SBMLDocument_checkL3v1Compatibility(swigCPtr, this);
  }

  
/**
   * Returns the nth error or warning encountered during parsing,
   * consistency checking, or attempted translation of this model.
   <p>
   * Callers can use method {@link XMLError#getSeverity()} on the result to assess
   * the severity of the problem.  The possible severity levels range from
   * informational messages to fatal errors.
   <p>
   * @return the error or warning indexed by integer <code>n</code>, or return 
   * <code>null</code> if <code>n &gt; (getNumErrors() - 1)</code>.
   <p>
   * @param n the integer index of the error sought.
   <p>
   * @see SBMLDocument#getNumErrors()
   */ public
 SBMLError getError(long n) {
    long cPtr = libsbmlJNI.SBMLDocument_getError(swigCPtr, this, n);
    return (cPtr == 0) ? null : new SBMLError(cPtr, false);
  }

  
/**
   * Returns the nth error or warning with the given severity
   * encountered during parsing, consistency checking, or attempted
   * translation of this model.
   <p>
   * @return the error or warning indexed by integer <code>n</code>, or return 
   * <code>null</code> if <code>n &gt; (getNumErrors(severity) - 1)</code>.
   <p>
   * @param n the integer index of the error sought.
   * @param severity the severity of the error sought.
   <p>
   * @see SBMLDocument#getNumErrors()
   */ public
 SBMLError getErrorWithSeverity(long n, long severity) {
    long cPtr = libsbmlJNI.SBMLDocument_getErrorWithSeverity(swigCPtr, this, n, severity);
    return (cPtr == 0) ? null : new SBMLError(cPtr, false);
  }

  
/**
   * Returns the number of errors or warnings encountered during parsing,
   * consistency checking, or attempted translation of this model.
   <p>
   * @return the number of errors or warnings encountered
   <p>
   * @see SBMLDocument#getError(long n)
   */ public
 long getNumErrors() {
    return libsbmlJNI.SBMLDocument_getNumErrors__SWIG_0(swigCPtr, this);
  }

  
/**
   * Returns the number of errors or warnings encountered with the given 
   * severity during parsing,
   * consistency checking, or attempted translation of this model.
   <p>
   * @param severity the severity of the error sought. 
   <p>
   * @return the number of errors or warnings encountered
   <p>
   * @see SBMLDocument#getError(long n)
   */ public
 long getNumErrors(long severity) {
    return libsbmlJNI.SBMLDocument_getNumErrors__SWIG_1(swigCPtr, this, severity);
  }

  
/**
   * Prints all the errors or warnings encountered trying to parse,
   * check, or translate this SBML document.
   <p>
   * It prints the text to the stream given by the optional parameter 
   * <code>stream</code>.  If no parameter is given, it prints the output to the
   * standard error stream.
   <p>
   * If no errors have occurred, i.e., <code>getNumErrors() == 0</code>, no
   * output will be sent to the stream.
   <p>
   * The format of the output is:
   * <pre class='fragment'>
   N error(s):
     line NNN: (id) message
 </pre>
   <p>
   * @param stream the ostream or ostringstream object indicating where
   * the output should be printed.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   <p>
   * @see #getNumErrors()
   * @see #getErrorLog()
   * @see SBMLDocument#getError(long n)
   */ public
 void printErrors(OStream stream) {
    libsbmlJNI.SBMLDocument_printErrors__SWIG_0(swigCPtr, this, SWIGTYPE_p_std__ostream.getCPtr(stream.get_ostream()), stream);
  }

  
/**
   * Prints all the errors or warnings encountered trying to parse,
   * check, or translate this SBML document.
   <p>
   * It prints the text to the stream given by the optional parameter 
   * <code>stream</code>.  If no parameter is given, it prints the output to the
   * standard error stream.
   <p>
   * If no errors have occurred, i.e., <code>getNumErrors() == 0</code>, no
   * output will be sent to the stream.
   <p>
   * The format of the output is:
   * <pre class='fragment'>
   N error(s):
     line NNN: (id) message
 </pre>
   <p>
   * @param stream the ostream or ostringstream object indicating where
   * the output should be printed.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   <p>
   * @see #getNumErrors()
   * @see #getErrorLog()
   * @see SBMLDocument#getError(long n)
   */ public
 void printErrors() {
    libsbmlJNI.SBMLDocument_printErrors__SWIG_1(swigCPtr, this);
  }

  
/**
    * Prints all the errors or warnings with the given severity encountered 
    * trying to parse, check, or translate this SBML document.
    <p>
    * It prints the text to the stream given by the parameter 
    * <code>stream</code>.  
    <p>
    * If no errors have occurred, i.e., <code>getNumErrors(severity) == 0</code>, no
    * output will be sent to the stream.
    <p>
    * The format of the output is:
    * <pre class='fragment'>
    N error(s):
      line NNN: (id) message
</pre>
    <p>
    * @param stream the ostream or ostringstream object indicating where
    * the output should be printed.
    * @param severity of the errors sought.
    <p>
    * @see #getNumErrors(long severity)
    * @see #getErrorLog()
    * @see SBMLDocument#getErrorWithSeverity(long n, long severity)
    */ public
 void printErrors(OStream stream, long severity) {
    libsbmlJNI.SBMLDocument_printErrors__SWIG_2(swigCPtr, this, SWIGTYPE_p_std__ostream.getCPtr(stream.get_ostream()), stream, severity);
  }

  public void connectToChild() {
    libsbmlJNI.SBMLDocument_connectToChild(swigCPtr, this);
  }

  
/**
   * Converts this document using the converter that best matches
   * the given conversion properties. 
   <p>
   * @param props the conversion properties to use
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * <li> {@link libsbmlConstants#LIBSBML_CONV_CONVERSION_NOT_AVAILABLE LIBSBML_CONV_CONVERSION_NOT_AVAILABLE}
   * </ul>
   */ public
 int convert(ConversionProperties props) {
    return libsbmlJNI.SBMLDocument_convert(swigCPtr, this, ConversionProperties.getCPtr(props), props);
  }

  
/** * @internal */ public
 void enablePackageInternal(String pkgURI, String pkgPrefix, boolean flag) {
    libsbmlJNI.SBMLDocument_enablePackageInternal(swigCPtr, this, pkgURI, pkgPrefix, flag);
  }

  
/**
   * Returns the libSBML type code for this SBML object.
   <p>
   * <p>
 * LibSBML attaches an identifying code to every kind of SBML object.  These
 * are integer constants known as <em>SBML type codes</em>.  The names of all
 * the codes begin with the characters <code>SBML_</code>.
 * In the Java language interface for libSBML, the
 * type codes are defined as static integer constants in the interface class
 * {@link libsbmlConstants}.    Note that different Level&nbsp;3
 * package plug-ins may use overlapping type codes; to identify the package
 * to which a given object belongs, call the <code>getPackageName()</code>
 * method on the object.
   <p>
   * @return the SBML type code for this object:
   * {@link libsbmlConstants#SBML_DOCUMENT SBML_DOCUMENT} (default).
   <p>
   * <p>
 * @warning <span class='warning'>The specific integer values of the possible
 * type codes may be reused by different libSBML plug-ins for SBML Level&nbsp;3.
 * packages,  To fully identify the correct code, <strong>it is necessary to
 * invoke both getTypeCode() and getPackageName()</strong>.</span>
   <p>
   * @see SBMLDocument#getElementName()
   * @see #getPackageName()
   */ public
 int getTypeCode() {
    return libsbmlJNI.SBMLDocument_getTypeCode(swigCPtr, this);
  }

  
/**
   * Returns the XML element name of this object, which for {@link SBMLDocument},
   * is always <code>'sbml'.</code>
   <p>
   * @return the name of this element, i.e., <code>'sbml'.</code>
   */ public
 String getElementName() {
    return libsbmlJNI.SBMLDocument_getElementName(swigCPtr, this);
  }

  
/**
   * Returns the list of errors or warnings logged during parsing, 
   * consistency checking, or attempted translation of this model.
   <p>
   * @return the {@link SBMLErrorLog} used for this {@link SBMLDocument}
   <p>
   * @see SBMLDocument#getNumErrors()
   */ public
 SBMLErrorLog getErrorLog() {
    long cPtr = libsbmlJNI.SBMLDocument_getErrorLog__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new SBMLErrorLog(cPtr, false);
  }

  
/**
   * Returns a list of XML Namespaces associated with the XML content
   * of this SBML document.
   <p>
   * @return the XML Namespaces associated with this SBML object
   */ public
 XMLNamespaces getNamespaces() {
    long cPtr = libsbmlJNI.SBMLDocument_getNamespaces(swigCPtr, this);
    return (cPtr == 0) ? null : new XMLNamespaces(cPtr, false);
  }

  
/**
   * Set/unset default namespace to each top-level element defined in the
   * given package extension.
   <p>
   * This works by adding a <code>xmlns=&quot;...&quot;</code> attribute.  No
   * prefix will be written when writing elements defined in the given
   * package extension if <code>true</code> is given as second argument.
   <p>
   * @param package the name or URI of the package extension.
   * @param flag boolean value to indicate whether to write a namespace
   * prefix.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_PKG_UNKNOWN_VERSION LIBSBML_PKG_UNKNOWN_VERSION}
   * </ul>
   */ public
 int enableDefaultNS(String arg0, boolean flag) {
    return libsbmlJNI.SBMLDocument_enableDefaultNS(swigCPtr, this, arg0, flag);
  }

  
/**
   * Returns <code>true</code> if a default namespace is added to each top-level
   * element defined in the given package extension, otherwise returns
   * <code>false.</code>
   <p>
   * This basically checks if the attribute
   * <code>xmlns=&quot;...&quot;</code> is present.
   <p>
   * @param package the name or URI of the package extension.
   <p>
   * @return a boolean 
   */ public
 boolean isEnabledDefaultNS(String arg0) {
    return libsbmlJNI.SBMLDocument_isEnabledDefaultNS(swigCPtr, this, arg0);
  }

  
/**
   * Sets the <code>required</code> attribute value of the given package
   * extension.
   <p>
   * @note The name of package must not be given if the package is not
   * enabled.
   <p>
   * @param package the name or URI of the package extension.
   * @param flag Boolean value indicating whether the package is required.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_PKG_UNKNOWN_VERSION LIBSBML_PKG_UNKNOWN_VERSION}
   * </ul>
   */ public
 int setPackageRequired(String arg0, boolean flag) {
    return libsbmlJNI.SBMLDocument_setPackageRequired(swigCPtr, this, arg0, flag);
  }

  
/**
   * Returns the <code>required</code> attribute of the given package
   * extension.
   <p>
   * @note The name of package must not be given if the package is not
   * enabled.
   <p>
   * @param package the name or URI of the package extension.
   <p>
   * @return Boolean flag indicating whether the package is flagged as
   * being required.
   */ public
 boolean getPackageRequired(String arg0) {
    return libsbmlJNI.SBMLDocument_getPackageRequired(swigCPtr, this, arg0);
  }

  
/**
   * Returns <code>true</code> if the required attribute of the given package extension
   * is defined, otherwise returns <code>false.</code>
   <p>
   * @note The name of package must not be given if the package is not
   * enabled.
   <p>
   * @param package the name or URI of the package extension.
   <p>
   * @return a Boolean
   */ public
 boolean isSetPackageRequired(String arg0) {
    return libsbmlJNI.SBMLDocument_isSetPackageRequired(swigCPtr, this, arg0);
  }

  
/**
   * Returns <code>true</code> if the given package extension is one of an ignored
   * packages, otherwise returns <code>false.</code>
   <p>
   * An ignored package is one that is defined to be used in this SBML
   * document, but the package is not enabled in this copy of libSBML.
   <p>
   * @param pkgURI the URI of the package extension.
   <p>
   * @return a Boolean, <code>true</code> if the package is being ignored and
   * <code>false</code> otherwise.
   */ public
 boolean isIgnoredPackage(String pkgURI) {
    return libsbmlJNI.SBMLDocument_isIgnoredPackage(swigCPtr, this, pkgURI);
  }

  
/**
   * Returns <code>true</code> if the given package extension is one of an ignored
   * packages that has been disabled, otherwise returns <code>false.</code>
   <p>
   * An ignored package is one that is defined to be used in this SBML
   * document, but the package is not enabled in this copy of libSBML.
   * It may have been disabled to avoid reproducing the package
   * information when writing out the file.
   <p>
   * @param pkgURI the URI of the package extension.
   <p>
   * @return a Boolean, <code>true</code> if the package is being ignored and
   * <code>false</code> otherwise.
   */ public
 boolean isDisabledIgnoredPackage(String pkgURI) {
    return libsbmlJNI.SBMLDocument_isDisabledIgnoredPackage(swigCPtr, this, pkgURI);
  }

  
/**
   * Sets the value of the <code>required</code> attribute for the given
   * package.
   <p>
   * @note The name of package must not be given if the package is not
   * enabled.
   <p>
   * @param package the name or URI of the package extension.
   * @param flag a Boolean value.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_PKG_UNKNOWN_VERSION LIBSBML_PKG_UNKNOWN_VERSION}
   *
   * </ul> <p>
   * @deprecated <div class='deprecated'>Replaced in libSBML 5.2.0 by
   * setPackageRequired(String, boolean)
   </div>
   * */ public
 int setPkgRequired(String arg0, boolean flag) {
    return libsbmlJNI.SBMLDocument_setPkgRequired(swigCPtr, this, arg0, flag);
  }

  
/**
   * Returns the <code>required</code> attribute of the given package
   * extension.
   <p>
   * @note The name of package must not be given if the package is not
   * enabled.
   <p>
   * @param package the name or URI of the package extension.
   <p>
   * @return a Boolean value indicating whether the package is flagged as
   * being required in this SBML document.
   <p>
   * @deprecated <div class='deprecated'>Replaced in libSBML 5.2.0 by
   * getPackageRequired(String)
   </div>
   * */ public
 boolean getPkgRequired(String arg0) {
    return libsbmlJNI.SBMLDocument_getPkgRequired(swigCPtr, this, arg0);
  }

  
/**
   * Returns <code>true</code> if the required attribute of the given package extension
   * is defined, otherwise returns <code>false.</code>
   <p>
   * @note The name of package must not be given if the package is not
   * enabled.
   <p>
   * @param package the name or URI of the package extension.
   <p>
   * @return a Boolean value.
   <p>
   * @deprecated <div class='deprecated'>Replaced in libSBML 5.2.0 by
   * isSetPackageRequired(String)
   </div>
   * */ public
 boolean isSetPkgRequired(String arg0) {
    return libsbmlJNI.SBMLDocument_isSetPkgRequired(swigCPtr, this, arg0);
  }

  
/**
   * Returns <code>true</code> if the given package extension is one of ignored
   * packages, otherwise returns <code>false.</code>
   <p>
   * An ignored package is one that is defined to be used in this SBML
   * document, but the package is not enabled in this copy of libSBML.
   <p>
   * @param pkgURI the URI of the package extension.
   <p>
   * @return a boolean
   <p>
   * @deprecated <div class='deprecated'>Replaced in libSBML 5.2.0 by
   * isIgnoredPackage(String)
   </div>
   * */ public
 boolean isIgnoredPkg(String pkgURI) {
    return libsbmlJNI.SBMLDocument_isIgnoredPkg(swigCPtr, this, pkgURI);
  }

  
/** * @internal */ public
 short getApplicableValidators() {
    return libsbmlJNI.SBMLDocument_getApplicableValidators(swigCPtr, this);
  }

  
/** * @internal */ public
 short getConversionValidators() {
    return libsbmlJNI.SBMLDocument_getConversionValidators(swigCPtr, this);
  }

  
/** * @internal */ public
 void setApplicableValidators(short appl) {
    libsbmlJNI.SBMLDocument_setApplicableValidators(swigCPtr, this, appl);
  }

  
/** * @internal */ public
 void setConversionValidators(short appl) {
    libsbmlJNI.SBMLDocument_setConversionValidators(swigCPtr, this, appl);
  }

  
/** * @internal */ public
 long getNumValidators() {
    return libsbmlJNI.SBMLDocument_getNumValidators(swigCPtr, this);
  }

  
/** * @internal */ public
 int clearValidators() {
    return libsbmlJNI.SBMLDocument_clearValidators(swigCPtr, this);
  }

  
/** * @internal */ public
 int addValidator(SBMLValidator validator) {
    return libsbmlJNI.SBMLDocument_addValidator(swigCPtr, this, SBMLValidator.getCPtr(validator), validator);
  }

  
/** * @internal */ public
 SBMLValidator getValidator(long index) {
    long cPtr = libsbmlJNI.SBMLDocument_getValidator(swigCPtr, this, index);
    return (cPtr == 0) ? null : new SBMLValidator(cPtr, false);
  }

  
/** * @internal */ public
 int addUnknownPackageRequired(String pkgURI, String prefix, boolean flag) {
    return libsbmlJNI.SBMLDocument_addUnknownPackageRequired(swigCPtr, this, pkgURI, prefix, flag);
  }

  
/** * @internal */ public
 boolean hasUnknownPackage(String pkgURI) {
    return libsbmlJNI.SBMLDocument_hasUnknownPackage(swigCPtr, this, pkgURI);
  }

  
/** * @internal */ public
 int getNumUnknownPackages() {
    return libsbmlJNI.SBMLDocument_getNumUnknownPackages(swigCPtr, this);
  }

  
/** * @internal */ public
 String getUnknownPackageURI(int index) {
    return libsbmlJNI.SBMLDocument_getUnknownPackageURI(swigCPtr, this, index);
  }

  
/** * @internal */ public
 String getUnknownPackagePrefix(int index) {
    return libsbmlJNI.SBMLDocument_getUnknownPackagePrefix(swigCPtr, this, index);
  }

}
