#!/bin/bash

VER=$2  # e.g. 1.42 
FILE=$3 # e.g. ../librsl_1.42.orig.tar.gz 

OLD_DIR=rsl-v$VER
OLD_TAR=${FILE/orig/nonfree.orig}
NEW_DIR=rsl-v$VER.dfsg
NEW_TAR=${FILE/orig/dfsg.orig}

# Extract old tar
mv $FILE $OLD_TAR
tar -xzf $OLD_TAR
mv $OLD_DIR $NEW_DIR

# Remove non-free functions
cat > $NEW_DIR/edge_to_radar.c <<-EOF
	#include "rsl.h"
	Radar *RSL_EDGE_to_radar(char *f)
	{
	  fprintf(stderr, "%s",
	    "The RSL interface to load EDGE files and the\n"
	    "corresponding ETOR library are not GPL compatible\n"
	    "and have been removed from this version\n");
	  return NULL;
	}
EOF

# Create new tar
tar -czf $NEW_TAR $NEW_DIR
ln -s $(basename $NEW_TAR) $FILE
rm -rf $NEW_DIR

echo "Repackaged $FILE to remove non-free components"
