/*

  IMHO - webmail module for Roxen
  
  Copyright  
  Stefan Wallstrm <stewa@lysator.liu.se>
  & Bosse Lincoln <lincoln@lysator.liu.se> 1998-2000
  
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  See the file "LICENSE" for details.

*/

string imho_lang() {
  return "svenska";
}

string imho_lang_short() {
  return "sv";
}

string imho_lang_charset() {
  return "iso-8859-1";
}

string imho_lang_replacement_string() {
  //this is a UNICODE string that MUST be encodable by the local charset
  // This isn't needed anymore since IMHO now encodes characters that cannot be represented by
  // the current characterset as HTML entities.
  return "";
}

string msg(object sessobj,int m,array arg) {
  switch(m) {
    
    // Login page
    
  case M_LOGIN:
    //return "Login:";
    return "Login:";
  case M_PASSWORD:
    //return "Password:";
    return "Lsen:";
  case M_NOLOGIN:
    //return "<b>Could not log in:</b> Wrong login or password. Try again. ";
    return "<b>Kunde inte logga in:</b> Login eller lsen r fel. Frsk igen. ";
  case M_IMAPERROR:
    //return "There was a problem talking to the mail (IMAP) server. Please contact the administrator.";
    return "Det uppstod ett fel i kommunikationen med mail- (IMAP) servern. Kontakta systemansvarig.";
  case M_SMTPERROR:
    //return "There was a problem talking to the outgoing mail (SMTP) server. The recipient of the mail might not exist.";
    return "Det uppstod ett fel i kommunikationen med utgende mailserver (SMTP) och mailet skickades inte. Det kan bero p att mottagaren inte existerar.";
  case M_SAVEDUSERINTERFACE:
    //return "From preferences";
    return "Frn instllningar";
  case M_USERINTERFACE:
    //return "User interface:";
    return "Anvndargrnssnitt:";
  case M_LOGIN_OK:
    //return "OK";
    return "OK";

  case M_NEWMAIL:
    //return "Compose";
    return "Skriv brev";
  case M_MAILBOX:
    //return sprintf("Mailbox: %s",@arg);
    return sprintf("Brevlda: %s",@arg);
  case M_MAILBOXES:
    //return "Mailboxes";
    return "Brevldor";
  case M_FILES:
    //return "Files";
    return "Filer";
  case M_PREFS:
    //return "Preferences";
    return "Instllningar";
  case M_LOGOUT:
    //return "Logout";
    return "Logga ut";
  case M_CURRMAILBOX:
    // return "Current Mailbox";
    return "Aktiv brevlda";
  case M_CHECKACTIVEMAILBOXES:
    // return "Check active mailboxes";
    return "Kolla inkommande brevldor";

  case M_FROM:
    //return "From";
    return "Frn";
  case M_TO:
    //return "To";
    return "Till";
  case M_CC:
    //return "Cc";
    return "Cc";
  case M_BCC:
    //return "Bcc";
    return "Bcc";
  case M_SUBJECT:
    //return "Subject";
    return "rende";
  case M_ATTACHMENTS:
    //return "Attachments";
    return "Bilagor";
  case M_TIME:
    //return "Time";
    return "Tid";
  case M_DATE:
    //return "Date";
    return "Datum";
    
  case  M_MARKFLAG:
    //return "M";
    return "M";
  case M_NEWFLAG:
    //return "N";
    return "N";
  case M_ANSWEREDFLAG:
    //return "A";
    return "S";
    
    
  case M_SEND:
    //return "Send";
    return "Skicka";
  case M_CANCELSEND:
    //return "Cancel";
    return "Avbryt";
  case M_SENDMOREFILES:
    //return "Select files to send. Press 'Ctrl' to toggle-select multiple files.";
    return "Markera de filer du vill skicka med. Tryck 'Ctrl' fr att vlja fler filer.";
  case M_COMPOSEMAIL:
    //return "Compose mail";
    return "Skriv brev";
  case M_SPELLCHECK:
    return "Kontrollera stavning";
  case M_DONTSAVEMAIL:
    //return "Do not save this mail.";
    return "Spara inte det hr brevet.";
  case M_ADDFILEASATTACHMENT:
    //return "Add file as attachment";
    return "Lgg till fil som bilaga";
  case M_NOATTACHMENTS:
    //return "No attachments";
    return "Inga bilagor";
  case M_ADDATTACHMENT:
    //return "Add attachment...";
    return "Lgg till bilaga...";
  case M_REMOVEMARKEDATTACHMENTS:
    //return "Remove marked attachments";
    return "Ta bort markerade bilagor";
  case M_UPLOADATTACHMENT:
    //return "Upload attachment";
    return "Ladda upp bilaga";
  case M_ADDMARKEDTOATTACHMENTS:
    //return "Add marked to attachments";
    return "Lgg till markerade till bilagor";
  case M_UPLOADTOATTACHMENTS:
    //return "Upload to attachments";
    return "Ladda upp och lgg till bilagor";
  case M_BACKTOCOMPOSE:
    //return "Back to compose";
    return "Tillbaka till skriv brev";
  case M_NOATTACHFILES:
    //return "No files";
    return "Inga filer";
  case  M_ATTACHMENTSHEADER:
    return "Bilagor";
  case M_SENDSAVEFAILED:
    //return "Mail was sent successfully, but save in folder failed.";
    return "Mailet skickades, men kunde inte sparas i utgende brevlda.";
  case M_SENDNORECV:
    //return "You must specify a recipient of the mail.";
    return "Du mste ange en mottagare till mailet.";
  case M_DSN_DELAY:
    //return("Report delayed delivery.");
    return "Rapportera frsenad leverans.";
  case M_DSN_SUCCESS:
    // return("Report successful delivery.");
    return "Bekrfta leverans till mottagare.";
  case M_SAVEDRAFT:
    //return("Save draft");
    return("Spara utkast");
  case M_SAVEDRAFTINSESSION:
    //return("Save draft (during session)");
    return("Spara utkast (under denna session)");
  case M_COMPOSEDRAFT:
    //return("You have a draft mail saved. Do you want to start from it now?");
    return("Du har ett utkast till ett brev sparat. Vill du utg frn det?");
  case M_DRAFTEXISTS:
    // return("There is already another draft mail saved.");
    return("Det finns redan ett annat utkast sparat.");
  case M_OVERWRITEDRAFT:
    //return("Owerwrite current draft");
    return("Skriv ver nuvarande utkast");
  case M_DISCARDDRAFT:
    //return("Discard current mail, keep draft");
    return("Slng nuvarande brev, behll utkastet"); 
  case M_SENDBROKENADDR:
    //return(sprintf("The address \"%s\" is not a correct email address. Please correct it and try again.", arg[0]));
    return(sprintf("Adressen \"%s\" r inte korrekt. Rtta till felet och frsk igen.", arg[0])); 
  case M_SAVEMAILCOPY:
    //return("Save a copy");  
    return("Spara en kopia");

  case M_DELETEMARKED:
    //return "Delete marked";
    return "Radera markerade";
  case M_MOVEMARKED:
    //return "Move marked to";
    return "Flytta markerade till";
  case M_SELECTMBOX:
    //return "(Select a mailbox)";
    return "(Vlj en brevlda)";
  case M_CHECKNEWMAIL:
    //return "Check for new mail";
    return "Kolla efter nya brev";
  case M_MAILSHOWN:
    // return sprintf("Mail %d-%d of %d", @arg);
    return sprintf("Brev %d-%d av %d", @arg);
  case M_BACKN:
    //return sprintf("[<< Prev %d]", @arg);
    return sprintf("[<< Fregende %d]", @arg);
  case M_FORWARDN:
    // return sprintf("[Next %d >>]", @arg);
    return sprintf("[Nsta %d >>]", @arg);
  case M_NUMBER:
    return "#";
  case M_DELETEMARKEDP:
    //sprintf("Are you sure you want to delete the %d marked message(s)?", 
    return 
      sprintf("r du sker p att du vill radera de %d markerade breven?", 
	      @arg);
  case M_DELETEMARKEDNONE:
    //return "Please mark some messages first.";
    return "Markera ngra brev frst.";
  case M_CHANGESORTORDER:
    //return "Change sort order";
    return "ndra sortering";
  case M_MOVETOTRASH:
    //return "Move marked to trash";
    return "Slng markerade i soptunna";
  case M_DELETEALLTRASH:
    //return "Delete ALL trash";
    return "Tm hela soptunnan";
  case M_NOMAILS:
    // return "[No mail]";
    return "[Inga brev]";
  case M_MARKALL:
    //return "Mark all";
    return "Markera alla";
  case M_PAGEGO:
    //return "Go";
    return "G";

  case M_MBOXNAME:
    //return "Mailbox";
    return "Brevlda";
  case M_DELETEMARKEDMBOX:
    //return "Delete marked";
    return "Radera markerade";
  case M_CREATEMBOX:
    //return "Create a new mailbox";
    return "Skapa en ny brevlda";
  case M_NEWMBOXNAME:
    //return "(Name)";
    return "(Namn)";
  case M_MBOXREMOVEP:
    //return "Are you sure you want to delete the following mailboxes?";
    return "r du sker p att du vill ta bort fljande brevldor?";
  case M_MBOXMARKONE:
    //return "Mark at least one mailbox.";
    return "Markera minst en brevlda frst.";    
  case M_NEWMBOXNONAME:
    // return "Type in a name first.";
    return "Skriv ett namn p den nya brevldan frst..";
  case M_CREATEMBOXERROR:
    //return "Failed to create mailbox. The name may be illegal or the mailbox may exist.";
    return "Det gick inte att skapa brevldan. Namnet kan vara otilltet eller brevldan kanske redan finns.";
  case M_INBOX:
    //return "Inbox";
    return "Inkommande";
  case M_PREVIOUS_LEVEL:
    //return "[Previous level]";
    return "[Fregende niv]";
  case M_FOLDER_PATH:
    //return "Path:";
    return "Skvg:";
  case M_BOXTRASH:
    //return "Trash";
    return("Soptunna");
  case M_BOXSENTMAIL:
    //return "Sent";
    return("Skickade");
  case M_USEMARKEDINMENULIST:
    //return "Use marked in menu list";
    return "Anvnd markerade i menylistan";
  case M_CHANGEINBOXESMSG:
    // return "The marked mailboxes will appear in the menu after you\n"
    // "reload the whole page or re-login.";
    return "De markerade brevldorna kommer synas i menylistan om du\n"
      "laddar om sidan eller loggar in igen.";

  case M_FILENAME:
    //return "Filename";
    return "Filnamn";
  case M_SIZE:
    //return "Size";
    return "Storlek";
  case M_MIMETYPE:
    //return "Type";
    return "Typ";
  case M_DELETEMARKEDFILES:
    //return "Delete marked";
    return "Radera markerade";
  case M_UPLOAD:
    //return "Upload";
    return "Ladda upp";
  case M_AVAILSPACE:
    //return sprintf("You have %d Kb available for upload.",@arg);
    return sprintf("Du har %d Kb tillgngligt fr filer.",@arg);
  case M_WINDOWSBUG :
    //return "Windowsusers: Due to a bug in some browsers, filenames can be crippled. Avoid this by replacing the last \\ with \\\\ before pressing 'Upload'.";
    return "Windowsanvndare: Pga en bug i flera weblsare kan filnamnen bli lite konstiga. Undvik detta genom att byta ut det sista '\\' mot '\\\\' innan du trycker 'Ladda upp'.";
  case M_NOFILES:
    //return "You have no uploades files.";
    return "Du har inte laddat upp ngra filer.";

  case M_PNAME:
    //return "Name";
    return "Namn";
  case M_PMAILADDRESS:
    //return "Mail address";
    return "Mailadress";
  case M_PMAILPATH:
    //return "Mail searchpath";
    return "Mailkatalog";
  case M_PINCLUDEMAIL:
    //return "Include mail when replying";
    return "Inkludera originalbrev i svar";
  case M_PQUOTEPREFIX :
    //return "Prefix";
    return "Prefix";
  case M_PSIGNATURE:
    //return "Signature";
    return "Signatur";
  case M_PINACTIVELOGOUT:
    //return "Inactive logout (minutes)";
    return "Inaktiv utloggning (minuter)";
  case M_PSAVEANDUSE:
    //return "Save and use";
    return "Spara och anvnd";
  case M_PVISIBLEMESSAGES:
    //return "Messages shown in mailbox";
    return "Visade brev i brevldan";
  case M_PSORTORDER:
    //return "Mail sort order";
    return "Sortering av brev";
  case M_PSORTORDERS:
    //return ([ "forward": "forward", "backward":"backward"])[arg[0]];
    return ([ "forward": "framlnges", "backward":"baklnges"])[arg[0]];
  case M_PTRASHFOLDER:
    //return "Trash folder";
    return "Soptunne-brevlda";
  case M_PSENTFOLDER:
    //return "Sent mail folder";
    return "Utgende brevlda";
  case M_PDEFAULTBCC:
    //return "Default Bcc address";
    return "Frinstlld Bcc adress";
  case M_PSAVEATTACHMENTS:
    //return "Save attachments";
    return "Inkludera bilagor";
  case M_PLANGUAGE:
    //return "Language";
    return "Sprk";
  case M_PUSERINTERFACE:
    //return "User interface";
    return "Anvndargrnssnitt";
  case M_PINBOXES:
    //return "Inboxes";
    return "Brevldor i menylista";
  case M_PCOMMASEPARATED: 
    //return "(Comma separated list of mailboxes)";
    return "(Kommaseparerad lista, \"lda1, lda2, ...\")";
  case M_PHEADER:
    //return "Extra headers";
    return "Extra headers";
  case M_PHEADERDESC:
    //return "(Lines with headers in this format: header:value )";
    return "(Rader med headers i formatet: header:vrde )";
  case M_PSORTCOLUMN:
    //return "Sort on column";
    return("Sortera efter kolumn");
  case M_PSHOWHTML:
    // return "Show HTML messages";
    return("Visa HTML-brev");
  case M_PSHOWHIDDENHEADERS:
    //return "Enable <i>\"Show full headers\"</i>-button";
    return("\"Visa all mailinfo\"-knapp");
  case M_PMAILADDRESSDESC:
    //return "(List of addresses from which you would like to be able to send mail. One per line or comma-separated.)";
    return "(Lista p avsndaradresser du vill anvnda. En per rad eller kommaseparerad lista.)";
  case M_PPROCMAIL:
    //return "Filtering";
    return "Filtrering";
  case M_PPROCMAILDESC:
    //return "(Filtering directives in the form <code>mailbox to/from/subject toaddr/fromaddr/subject (regexp))</code><br><i><b>Note:</b> Only rules created using this interface are affected</i><br>Examples:<pre>hugbox    from     hugs@someplace.cozy\nlistbox   to       list@lots.of.maillists\nspambox   subject  .*SPAM.*</pre>";
    return "(Filtreringsdirektiv i formatet <code>mailbox to/from/subject toaddr/fromaddr/subject (regexp))</code><br><i><b>Notera:</b> Endast regler skapade i detta grnssnitt pverkas</i><br>Exampel:<pre>hugbox    from     hugs@someplace.cozy\nlistbox   to       list@lots.of.maillists\nspambox   subject  .*SPAM.*</pre>";
  case M_PFORWARDING:
    //return "Forwarding";
    return "Eftersndning";
  case M_PFORWARDINGDESC:
    //return "(List of addresses to forward your incoming mail to. One per line or comma-separated.)";
    return "(Lista p adresser att eftersnda inkommande brev till. En per rad eller kommaseparerad lista.)";



  case M_SPELLDONE:
    //return "Done";
    return "Klar";
  case M_SPELLPREV:
    //return "Previous";
    return "Fregende";
  case M_SPELLNEXT:
    //return "Next";
    return "Nsta";
  case  M_SPELLCHANGETO:
    //return "Change to";
    return "ndra till";
  case M_SPELLSUGGESTIONS:
    //return "Suggestions";
    return "Frslag";
  case M_NOSPELLINGERRORS:
    // return "No spelling errors found.";
    return "Inga stavfel hittades.";

  case M_LOGOUTMSG:
    //return "You are logged out. Close this browser window to make sure no one can read your mail.<br><br>Reload this page to login.";
    return "Du r nu utloggad. Stng det hr browser-fnstret om du vill vara sker p att ingen ska kunna se dina brev.<br><br>Ladda om sidan fr att logga in p nytt.";
  case M_LOGGEDOUT:
    //return "Logged out";
    return "Utloggad";

  case M_QUESTION:
    //return "Question"; 
    return "Frga";
  case M_INFO:
    //return "Info"; 
    return "Info";

  case M_REPLY:
    //return "Reply";
    return "Svara";
  case M_READPREV:
    //return "Read previous";
    return "Ls fregende";
  case M_READNEXT:
    //return "Read next";
    return "Ls nsta";
  case M_ATTACHMENTLINK:
    //return sprintf("%sattachment of type %s",@arg);
    return sprintf("%sbilaga av typen %s",@arg);
  case M_MAILMISSING:
    //return "<b>Error:</b> Failed to fetch mail. Try again. <br>";
    return "<b>Fel:</b> Lyckades inte hitta brevet. Frsk igen.<br>";
  case M_MAILMISSINGBACK:
    //return "Back";
    return "Tillbaka";
  case M_DELETE:
    //return "Delete";
    return "Radera";
  case M_FORWARD:
    //return "Forward";
    return "Skicka vidare";
  case M_MAIL:
    // return "Mail";
    return "Brev";
  case M_SHOWFULLHEADERS:
    //return "Show full headers";
    return "Visa all mailinfo";
  case M_HIDEFULLHEADERS:
    //return "Hide full headers";
    return "Gm mailinfo";
  case M_MAILTOOBIG:
    // return "Mail is too big to be shown. Click here to download it.";
    return "Mailet r fr stort fr att visas. Klicka hr fr att ladda ner det.";
  case M_REPLYTOALL:
    //return "Reply to all";
    return "Svara till alla";
  case M_MOVETHISTOTRASH:
    //return "Move to trash";
    return "Slng i soptunnan";
  case M_CHARSETWARNING:
    //return sprintf("Warning! Unable to decode the characterset \"%s\". Message is presented undecoded.",@arg);
    return sprintf("Varning! Misslyckades med att avkoda teckenuppsttningen \"%s\". Meddelandet r ej avkodat.",@arg);

  case M_ADDRESSBOOKTITLE: 
    //return("Address Book");         
    return("Adressbok");
  case M_ADDRESSBOOK:
    //return("Address book...");
    return("Adressbok...");
  case M_INDEXNAMERECIPIENT:
    //return("Intex name (click to add as recipient)");
    return("Indexnamn (klicka fr att lgga till som mottagare)");
  case M_INDEXNAMEEDIT:
    //return("Index name (click to edit)");
    return("Indexnamn (klicka fr att ndra)");
  case M_ADDRESS:
    //return("Address");
    return("Adress");
  case M_NOADDRESSES:
    //return("No addresses");
    return("Inga adresser");
  case M_NEWADDRESS:
    //return("New address...");
    return("Ny adress...");
  case M_EDITADDRESS:
    //return("Edit address");
    return("ndra adress");
  case M_ADDADDRESS:
    //return("Add to address book");
    return("Lgg till i adressboken");
  case M_INDEXNAME:
    //return("Index name");
    return("Indexnamn");
  case M_ADDRESSFORMAT:
    //return("Address(es), comma separated");
    return("Adress(er), med komma mellan varje");
  case M_SAVEADDRESS:
    //return("Save and use");
    return("Spara och anvnd");
  case M_DELETEADDRESS:
    //return("Delete address");
    return("Radera adress");
  case M_CANCELADDRESS:
    //return("Cancel");
    return("Avbryt");
  case M_CANNOTIMPORT:
    //return("Cannot import this addressbook, since its\nformat is not recognized.");
    return("Kan inte importera den hr adressboken, eftersom\ndess format inte knns igen.");
  case M_IMPORTADDRESSBOOKTITLE:
    //return("Import address book");
    return("Importera adressbok");
  case M_UPLOADADDRESSBOOK:
    //return("Upload a Pine or exported Netscape (.ldif) address book");
    return("Ladda upp en Pine- eller exporterad Netscape (.ldif) adressbok");
  case M_PINELOCATION:
    //return("The Pine address book is often in ~/.addressbook");
    return("Pines adressbok heter ofta ~/.addressbook");
  case M_UPLOADANDIMPORT:
    //return("Upload and import");
    return("Ladda upp och importera");
  case M_IMPORTADDRESSBOOK:
    // return("Import address book...");
    return("Importera adressbok...");
  case M_GLOBALADDRESSES:
    return("Gemensamma adresser:");
  case M_INSERTMARKEDADDRESSES:
    //return("Insert marked");
    return("Vlj markerade");
  case M_DELETEMARKEDADDRESSES:
    //return("Delete marked");
    return("Radera markerade");

  case M_LDAPTITLE:
    //return("LDAP addresses");
    return("LDAP adresser");
  case M_LDAP:
    //return("LDAP search");
    return("LDAP-skning");
  case M_SEARCHLDAP:
    //return("Search LDAP");
    return("Sk LDAP");
  case M_NAMECONT:
    //return("Search name containing:");
    return("Sk efter namn som innehller:");
  case M_OU:
    //return("OU");
    return("OU");

 case M_MAILNOTIFYWINDOW:
   //return("Mail notification...");
    return("Nytt-brev-fnster...");
  case M_GETNEWMAIL:
    //return("Get new mail...");
    return("Till nytt brev...");

  case M_SEARCHMAILTITLE:
    //return("Search mail");
    return("Sk brev");
  case M_SEARCHMAIL:
    //return("Search...");
    return("Sk...");
  case M_SEARCHMAILBOX:
    //return(sprintf("Find mail in mailbox <b>%s</b> which contains",arg[0]));
    return(sprintf("Sk efter brev i <b>%s</b> vilka innehller",arg[0]));
  case M_SEARCHANYWHERE:
    //return("anywhere");
    return("var som helst");
  case M_SEARCHFROMFIELD:
    //return("in 'from' field");
    return("i 'frn'-fltet");
  case M_SEARCHTOFIELD:
    //return("in 'to' field");
    return("i 'till'-fltet");
  case M_SEARCHSUBJECT:
    //return("in subject");
    return("i mnesraden");
  case M_SEARCHBODY:
    //return("in mail body");
    return("i brevtexten");
  case M_SEARCHAND:
    //return("AND");
    return("OCH");
  case M_SEARCHSHOWINGMAIL:
    //return("Showing mail with ");
    return("Visar brev med ");

  case M_YES:
    //return "Yes";
    return "Ja";
  case M_NO:
    //return "No";
    return "Nej";
  case M_DIALOGOK:
    // return "OK";
    return "OK";
  case M_DIALOGCANCEL:
    // return "Cancel";
    return "Avbryt";
   
  }
  return 0;
}
