/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the license.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "QImageBuffer.h"

#include <QImage>

using namespace QtGTL;

struct QImageBuffer::Private {
  Private( const QImage& _image) : image(_image)
  {
  }
  QImage image;
};

QImageBuffer::QImageBuffer(const QImage& img) : d(new Private(img))
{
}

QImageBuffer::~QImageBuffer()
{
}
    
char * QImageBuffer::rawData()
{
  return (char*)d->image.bits();
}
    
const char * QImageBuffer::rawData() const
{
  return (const char*)d->image.bits();
}
    
int QImageBuffer::size() const
{
  return d->image.numBytes();
}
    
const QImage& QImageBuffer::image() const
{
  return d->image;
}
