/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef LIBPOLYXMASS_REPORTOPT_H
#define LIBPOLYXMASS_REPORTOPT_H


#include "libpolyxmass-globals.h"
#include "pxmchem-calcopt.h"
#include "libpolyxmass-prop.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */




#define EXPORT_FORMAT_TEXT 1
#define EXPORT_FORMAT_LATEX 2


  typedef struct _PxmReportOpt PxmReportOpt;

  typedef enum _PxmReportOptPolymer PxmReportOptPolymer;
  typedef enum _PxmReportOptOligomer PxmReportOptOligomer;
  typedef enum _PxmReportOptMonomer PxmReportOptMonomer;


  enum _PxmReportOptPolymer 
    {
      PXM_PLM_REPORTOPT_NONE = 0,
      PXM_PLM_REPORTOPT_CALCOPTIONS = 1 << 0,
      PXM_PLM_REPORTOPT_WHOLE_SEQ_MASSES = 1 << 1,
      PXM_PLM_REPORTOPT_SELECTION_MASSES = 1 << 2,
      PXM_PLM_REPORTOPT_SEQUENCE = 1 << 3,
      PXM_PLM_REPORTOPT_PROP = 1 << 4,
      PXM_PLM_REPORTOPT_AUTHOR = 1 << 5,
      PXM_PLM_REPORTOPT_DATE = 1 << 6,
    };
  
  
  enum _PxmReportOptOligomer
    {
      PXM_OLM_REPORTOPT_NONE = 0,
      PXM_OLM_REPORTOPT_CALCOPTIONS = 1 << 0,
      PXM_OLM_REPORTOPT_SEQUENCE = 1 << 1,
      PXM_OLM_REPORTOPT_MONO_MASS = 1 << 2,
      PXM_OLM_REPORTOPT_AVG_MASS = 1 << 3,
      PXM_OLM_REPORTOPT_PROP = 1 << 4,
    };
  
  
  enum _PxmReportOptMonomer
    {
      PXM_MNM_REPORTOPT_NONE = 0,
      PXM_MNM_REPORTOPT_PROP = 1 << 0,
    };
  
  struct _PxmReportOpt
  {
    PxmReportOptPolymer polymer_opt;
    PxmReportOptOligomer oligomer_opt;
    PxmReportOptMonomer monomer_opt;
    
    PxmCalcOpt *calcopt;
    
    gint line_chars;
    gint page_lines;

    gint export_format;
    
    gint codes_per_div;

    GPtrArray *propGPA;
  };
  



  /* NEW'ING FUNCTIONS, DUPLICATING FUNCTIONS ...
   */
  PxmReportOpt *
  libpolyxmass_reportopt_new (void);

  PxmProp*
  libpolyxmass_reportopt_prop_new (void);
  
  PxmReportOpt *
  libpolyxmass_reportopt_dup (PxmReportOpt *reportopt, gint how_dup);

  PxmProp *
  libpolyxmass_reportopt_prop_dup (PxmProp *prop, gint how_dup);
  
  gboolean
  libpolyxmass_reportopt_copy_not_deep (PxmReportOpt *dest, 
					PxmReportOpt *src);
  
  
  /* DATA MODIFYING FUNCTIONS
   */
  gboolean
  libpolyxmass_reportopt_set_default (PxmReportOpt *reportopt);
  



  /* LOCATING FUNCTIONS
   */
  



  /* COMPARISON FUNCTIONS
   */
  gint
  libpolyxmass_reportopt_cmp (PxmReportOpt *reportopt1, 
			      PxmReportOpt *reportopt2,
			      gint how_cmp);
  
  gint
  libpolyxmass_reportopt_prop_cmp (PxmProp *prop1, PxmProp *prop2, 
				   gint how_cmp);
  


  /* FREE'ING FUNCTIONS
   */
  gint 
  libpolyxmass_reportopt_free (PxmReportOpt *reportopt);

  gint 
  libpolyxmass_reportopt_prop_free (PxmProp *prop);
  
       

#ifdef __cplusplus
}
#endif /* __cplusplus */



#endif






