#include "../recursiveDoUndoMove.h"
#include "../doUndoMoveLockTest.h"
#include "osl/record/csaRecord.h"
#include "osl/record/csaString.h"
#include "osl/state/simpleState.tcc"

#include "osl/container/pieceVector.h"
#include "osl/effect_action/storePiece.h"

#include <iomanip>
#include <fstream>
#include <vector>
#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>


class SimpleStateTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE( SimpleStateTest );
  CPPUNIT_TEST(testEmulateCapture);
  CPPUNIT_TEST(testEmulateHandPiece);
  CPPUNIT_TEST(testRotate180);
  CPPUNIT_TEST(testBoard0);
  CPPUNIT_TEST_SUITE_END();
public:
  void testEmulateCapture();
  void testEmulateHandPiece();
  void testRotate180();
  void testBoard0();
};


CPPUNIT_TEST_SUITE_REGISTRATION(SimpleStateTest);
using namespace osl;
using namespace osl::state;

void SimpleStateTest::testEmulateCapture()
{
  SimpleState state(CsaString(
			      "P1+NY * +TO *  *  * -OU-KE-KY\n"
			      "P2 *  *  *  *  * -GI-KI *  * \n"
			      "P3 * +RY *  * +UM * -KI-FU-FU\n"
			      "P4 *  * +FU-FU *  * -FU *  * \n"
			      "P5 *  * -KE * +FU * +KY+FU * \n"
			      "P6-KE *  * +FU+GI-FU *  * +FU\n"
			      "P7 *  * -UM *  *  *  *  *  * \n"
			      "P8 *  *  *  *  *  *  *  *  * \n"
			      "P9 * +OU * -GI *  *  *  * -NG\n"
			      "P+00FU\n"
			      "P+00FU\n"
			      "P+00FU\n"
			      "P+00FU\n"
			      "P+00FU\n"
			      "P+00FU\n"
			      "P+00FU\n"
			      "P+00KE\n"
			      "P+00KI\n"
			      "P-00KI\n"
			      "P-00KY\n"
			      "P+00HI\n"
			      "+\n"
			      ).getInitialState());
  {
    SimpleState state1=state.emulateCapture(state.pieceAt(Square(5,3)),WHITE);
    CPPUNIT_ASSERT(state1.isConsistent());
    CPPUNIT_ASSERT_EQUAL(state.turn(), state1.turn());
    SimpleState state2(CsaString(
				 "P1+NY * +TO *  *  * -OU-KE-KY\n"
				 "P2 *  *  *  *  * -GI-KI *  * \n"
				 "P3 * +RY *  *  *  * -KI-FU-FU\n"
				 "P4 *  * +FU-FU *  * -FU *  * \n"
				 "P5 *  * -KE * +FU * +KY+FU * \n"
				 "P6-KE *  * +FU+GI-FU *  * +FU\n"
				 "P7 *  * -UM *  *  *  *  *  * \n"
				 "P8 *  *  *  *  *  *  *  *  * \n"
				 "P9 * +OU * -GI *  *  *  * -NG\n"
				 "P+00FU\n"
				 "P+00FU\n"
				 "P+00FU\n"
				 "P+00FU\n"
				 "P+00FU\n"
				 "P+00FU\n"
				 "P+00FU\n"
				 "P+00KE\n"
				 "P+00KI\n"
				 "P-00KI\n"
				 "P-00KY\n"
				 "P-00KA\n"
				 "P+00HI\n"
				 "+\n"
				 ).getInitialState());

    CPPUNIT_ASSERT_EQUAL(state1,state2);
  }
  state.changeTurn();
  {
    SimpleState state1=state.emulateCapture(state.pieceAt(Square(5,3)),WHITE);
    CPPUNIT_ASSERT(state1.isConsistent());
    CPPUNIT_ASSERT_EQUAL(state.turn(), state1.turn());
  }
}

void SimpleStateTest::testEmulateHandPiece()
{
  SimpleState state(CsaString(
			      "P1+NY * +TO *  *  * -OU-KE-KY\n"
			      "P2 *  *  *  *  * -GI-KI *  * \n"
			      "P3 * +RY *  * +UM * -KI-FU-FU\n"
			      "P4 *  * +FU-FU *  * -FU *  * \n"
			      "P5 *  * -KE * +FU * +KY+FU * \n"
			      "P6-KE *  * +FU+GI-FU *  * +FU\n"
			      "P7 *  * -UM *  *  *  *  *  * \n"
			      "P8 *  *  *  *  *  *  *  *  * \n"
			      "P9 * +OU * -GI *  *  *  * -NG\n"
			      "P+00FU\n"
			      "P+00FU\n"
			      "P+00FU\n"
			      "P+00FU\n"
			      "P+00FU\n"
			      "P+00FU\n"
			      "P+00FU\n"
			      "P+00KE\n"
			      "P+00KI\n"
			      "P-00KI\n"
			      "P-00KY\n"
			      "P+00HI\n"
			      "+\n"
			      ).getInitialState());
  {
    SimpleState state1=state.emulateHandPiece(BLACK,WHITE,ROOK);
    CPPUNIT_ASSERT(state1.isConsistent());
    CPPUNIT_ASSERT_EQUAL(state.turn(), state1.turn());
    SimpleState state2(CsaString(
				 "P1+NY * +TO *  *  * -OU-KE-KY\n"
				 "P2 *  *  *  *  * -GI-KI *  * \n"
				 "P3 * +RY *  * +UM * -KI-FU-FU\n"
				 "P4 *  * +FU-FU *  * -FU *  * \n"
				 "P5 *  * -KE * +FU * +KY+FU * \n"
				 "P6-KE *  * +FU+GI-FU *  * +FU\n"
				 "P7 *  * -UM *  *  *  *  *  * \n"
				 "P8 *  *  *  *  *  *  *  *  * \n"
				 "P9 * +OU * -GI *  *  *  * -NG\n"
				 "P+00FU\n"
				 "P+00FU\n"
				 "P+00FU\n"
				 "P+00FU\n"
				 "P+00FU\n"
				 "P+00FU\n"
				 "P+00FU\n"
				 "P+00KE\n"
				 "P+00KI\n"
				 "P-00KI\n"
				 "P-00KY\n"
				 "P-00HI\n"
				 "+\n"
				 ).getInitialState());

    CPPUNIT_ASSERT_EQUAL(state1,state2);
  }
  state.changeTurn();
  {
    SimpleState state1=state.emulateHandPiece(BLACK,WHITE,ROOK);
    CPPUNIT_ASSERT(state1.isConsistent());
    CPPUNIT_ASSERT_EQUAL(state.turn(), state1.turn());
  }
}

void SimpleStateTest::testRotate180()
{
  {
    SimpleState state(CsaString(
			"P1-KY * +UM *  *  *  * -KE-KY\n"
			"P2 *  *  *  *  *  *  * -OU * \n"
			"P3 *  *  *  *  * -HI * -FU-FU\n"
			"P4-FU * -FU * -FU-KI-FU-GI * \n"
			"P5 *  *  *  *  *  *  *  * +FU\n"
			"P6+FU+FU+FU+KI+FU * +FU *  * \n"
			"P7 * +KI * +FU *  * -UM *  * \n"
			"P8 * +OU * +GI *  * -NG *  * \n"
			"P9+KY+KE *  *  *  *  *  * -RY\n"
			"P+00KI00GI00KY00FU\n"
			"P-00KE00KE00FU00FU00FU00FU\n"
			"+\n").getInitialState());
    SimpleState state2(CsaString(
			 "P1+RY *  *  *  *  *  * -KE-KY\n"
			 "P2 *  * +NG *  * -GI * -OU * \n"
			 "P3 *  * +UM *  * -FU * -KI * \n"
			 "P4 *  * -FU * -FU-KI-FU-FU-FU\n"
			 "P5-FU *  *  *  *  *  *  *  * \n"
			 "P6 * +GI+FU+KI+FU * +FU * +FU\n"
			 "P7+FU+FU * +HI *  *  *  *  * \n"
			 "P8 * +OU *  *  *  *  *  *  * \n"
			 "P9+KY+KE *  *  *  * -UM * +KY\n"
			 "P+00KE00KE00FU00FU00FU00FU\n"
			 "P-00KI00GI00KY00FU\n"
			 "-\n").getInitialState());
    CPPUNIT_ASSERT_EQUAL(state2, state.rotate180());
  }
}

void SimpleStateTest::testBoard0()
{
  SimpleState state(HIRATE);
  CPPUNIT_ASSERT(state.pieceAt(Square::STAND()).isEdge());
  CPPUNIT_ASSERT(state.pieceAt(Square::makeDirect(0)).isEdge());
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
