#include "osl/container/tripleInt.h"
#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;

class TripleIntTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(TripleIntTest);
  CPPUNIT_TEST(testAdd);
  CPPUNIT_TEST(testMul);
  CPPUNIT_TEST(testShift);
  CPPUNIT_TEST(testSet);
  CPPUNIT_TEST_SUITE_END();
 public:
  void testAdd();
  void testMul();
  void testShift();
  void testSet();
};

CPPUNIT_TEST_SUITE_REGISTRATION(TripleIntTest);

void TripleIntTest::testAdd(){
  TripleInt a, b;
  CPPUNIT_ASSERT_EQUAL(a[0], 0);
  CPPUNIT_ASSERT_EQUAL(a[1], 0);
  CPPUNIT_ASSERT_EQUAL(a[2], 0);
  CPPUNIT_ASSERT_EQUAL(b[0], 0);
  CPPUNIT_ASSERT_EQUAL(b[1], 0);
  CPPUNIT_ASSERT_EQUAL(b[2], 0);

  a[0] = 1; a[1] = 2; a[2] = 3;
  b[0] = 7; b[1] = 16; b[2] = 27;
  
  TripleInt c = a + b, d = a - b;
  CPPUNIT_ASSERT_EQUAL(c[0], 8);
  CPPUNIT_ASSERT_EQUAL(c[1], 18);
  CPPUNIT_ASSERT_EQUAL(c[2], 30);

  CPPUNIT_ASSERT_EQUAL(d[0], -6);
  CPPUNIT_ASSERT_EQUAL(d[1], -14);
  CPPUNIT_ASSERT_EQUAL(d[2], -24);
}

void TripleIntTest::testMul(){
  TripleInt a, b;
  CPPUNIT_ASSERT_EQUAL(a[0], 0);
  CPPUNIT_ASSERT_EQUAL(a[1], 0);
  CPPUNIT_ASSERT_EQUAL(a[2], 0);
  CPPUNIT_ASSERT_EQUAL(b[0], 0);
  CPPUNIT_ASSERT_EQUAL(b[1], 0);
  CPPUNIT_ASSERT_EQUAL(b[2], 0);

  a[0] = 1; a[1] = 2; a[2] = 3;
  b[0] = 7; b[1] = 16; b[2] = 27;
  
  TripleInt a7 = a * 7, a_13 = a * -13;
  TripleInt b1 = b * 1, b_1 = b * -1, b0 = b * 0;
  CPPUNIT_ASSERT_EQUAL(a7[0], 7);
  CPPUNIT_ASSERT_EQUAL(a7[1], 14);
  CPPUNIT_ASSERT_EQUAL(a7[2], 21);

  CPPUNIT_ASSERT_EQUAL(a_13[0], -13);
  CPPUNIT_ASSERT_EQUAL(a_13[1], -26);
  CPPUNIT_ASSERT_EQUAL(a_13[2], -39);

  CPPUNIT_ASSERT_EQUAL(b1[0], 7);
  CPPUNIT_ASSERT_EQUAL(b1[1], 16);
  CPPUNIT_ASSERT_EQUAL(b1[2], 27);

  CPPUNIT_ASSERT_EQUAL(b_1[0], -7);
  CPPUNIT_ASSERT_EQUAL(b_1[1], -16);
  CPPUNIT_ASSERT_EQUAL(b_1[2], -27);

  CPPUNIT_ASSERT_EQUAL(b0[0], 0);
  CPPUNIT_ASSERT_EQUAL(b0[1], 0);
  CPPUNIT_ASSERT_EQUAL(b0[2], 0);
}

void TripleIntTest::testSet()
{
  TripleInt a(1, 2, 3);
  CPPUNIT_ASSERT_EQUAL(a[0], 1);
  CPPUNIT_ASSERT_EQUAL(a[1], 2);
  CPPUNIT_ASSERT_EQUAL(a[2], 3);
  CPPUNIT_ASSERT_EQUAL(a[3], 0);
}

void TripleIntTest::testShift()
{
  TripleInt a(1, 2, 3);
  a >>= 1;
  CPPUNIT_ASSERT_EQUAL(a[0], 0);
  CPPUNIT_ASSERT_EQUAL(a[1], 1);
  CPPUNIT_ASSERT_EQUAL(a[2], 1);
  CPPUNIT_ASSERT_EQUAL(a[3], 0);

  TripleInt b(11, 12, 13);
  b >>= 1;
  CPPUNIT_ASSERT_EQUAL(b[0], 5);
  CPPUNIT_ASSERT_EQUAL(b[1], 6);
  CPPUNIT_ASSERT_EQUAL(b[2], 6);
  CPPUNIT_ASSERT_EQUAL(b[3], 0);

  TripleInt c(-11, -12, -13);
  c >>= 1;
  CPPUNIT_ASSERT_EQUAL(c[0], (-11 >> 1));
  CPPUNIT_ASSERT_EQUAL(c[1], (-12 >> 1));
  CPPUNIT_ASSERT_EQUAL(c[2], (-13 >> 1));
  CPPUNIT_ASSERT_EQUAL(c[3], 0);
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
